/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.HttpHeaders;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VisionOBJServiceUtility
extends RestAPIServiceUtility {
    VisionOBJServiceUtility() {
    }

    public UserInfoBean getUserInfoFromRequest(HttpServletRequest request) {
        UserInfoBean userInfo = null;
        String userInfoStr = "";
        try {
            HttpSession session = request.getSession();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            return userInfo;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Error in getting User info from Request [" + e.getMessage() + "]"));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPageDetails(HttpServletRequest request, HttpHeaders header, String appId, String objName, String pageNo) {
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_NAME=" + objName);
                paramString.append("&PAGE_NO=" + pageNo);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getPageDetails() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
            BaseLogger.log((String)"3", null, null, (Object)("getPageDetails() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                objName = this.checkNull(objName);
                appId = this.checkNull(appId);
                pageNo = this.checkNull(pageNo);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                DBAccessEJB dbAccess = new DBAccessEJB();
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo, "T", pageNo);
                JSONObject jsonObject = XML.toJSONObject((String)pageDetails);
                BaseLogger.log((String)"3", null, null, (Object)("getPageDetails with pageno API works JSON=" + jsonObject.toString()));
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getListPageData(HttpServletRequest request, HttpHeaders header, String appId, String objName, String objContext, String pageContext, String currentRowNo, String upToRowNo) {
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_CONTEXT=" + objContext);
                paramString.append("&PAGE_CONTEXT=" + pageContext);
                paramString.append("&CURR_ROW_NUM=" + currentRowNo);
                paramString.append("&UPTO_ROW_NUM=" + upToRowNo);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() tokenId=" + tokenId));
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
            BaseLogger.log((String)"3", null, null, (Object)("getListPageData() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                appId = this.checkNull(appId);
                objName = this.checkNull(objName);
                objContext = this.checkNull(objContext);
                pageContext = this.checkNull(pageContext);
                currentRowNo = this.checkNull(currentRowNo);
                upToRowNo = this.checkNull(upToRowNo);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                DBAccessEJB dbAccess = new DBAccessEJB();
                MasterDataEJB masterDataEJB = new MasterDataEJB();
                HttpSession sess = request.getSession();
                String qryParam = "";
                String qryParamType = "";
                String advQuery = "";
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                boolean isRCP = true;
                boolean isMaxBrowCheck = true;
                String globalFilterFlag = "";
                HashMap<String, String> incrementalSearchParam = new HashMap<String, String>();
                incrementalSearchParam.put("CURR_ROW_NUM", currentRowNo == null ? "0" : currentRowNo);
                incrementalSearchParam.put("UPTO_ROW_NUM", upToRowNo == null ? "0" : upToRowNo);
                String xmlData = masterDataEJB.getXMLFromDBForBrow(objName, "1", "1", qryParam, qryParamType, advQuery, userInfo, isRCP, globalFilterFlag, incrementalSearchParam, isMaxBrowCheck);
                JSONObject jsonObject = XML.toJSONObject((String)xmlData);
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPageMeta(HttpServletRequest request, HttpHeaders header, String appId, String objName, String formName, String objContext, String pageContext) {
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_NAME=" + objName);
                paramString.append("&FORMA_NAME=" + formName);
                paramString.append("&OBJ_CONTEXT=" + objContext);
                paramString.append("&PAGE_CONTEXT=" + pageContext);
                params = paramString.toString();
            }
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() params=" + params));
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() tokenId=" + tokenId));
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageMetadata");
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() result=" + result));
            if ("valid".equalsIgnoreCase(result)) {
                appId = this.checkNull(appId);
                objName = this.checkNull(objName);
                objContext = this.checkNull(objContext);
                pageContext = this.checkNull(pageContext);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                UserInfoBean userInfo = this.getUserInfoFromRequest(request);
                String transDB = userInfo.getTransDB();
                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                if (userInfo != null) {
                    propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                    propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                    propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                    propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
                }
                propEditorInfoMap.put("EDITOR", "WebEditor");
                String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
                BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() FilePath=" + filePath));
                File metadataFile = new File(filePath);
                String xmlString = this.readFile(metadataFile);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)(String.valueOf(objName) + "_" + objContext + "_" + pageContext));
                jsonObject.put("obj_name", (Object)objName);
                jsonObject.put("form_title", (Object)formName);
                jsonObject.put("form_no", (Object)objContext);
                jsonObject.put("page_context", (Object)pageContext);
                jsonObject.put("columns", (Object)this.getPageMetadataJSON(xmlString));
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Exception : getPageDetails : " + e.getMessage()));
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    private String readFile(File fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            if (fileName.exists()) {
                FileInputStream fMainIn = new FileInputStream(fileName);
                bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
                String outTempStr = null;
                while ((outTempStr = bfr.readLine()) != null) {
                    fileContent.append(outTempStr);
                }
                bfr.close();
                bfr = null;
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception in releasing file resource :[" + fileName + "]"));
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    private JSONArray getPageMetadataJSON(String xmlData) {
        try {
            BaseLogger.log((String)"3", null, null, (Object)("getPageMeta() xmlData=" + xmlData.length()));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
            NodeList columnObjectList = doc.getElementsByTagName("ColumnObject");
            NodeList textObjectList = doc.getElementsByTagName("TextObject");
            Map<String, String> labelMap = this.getLabelMap(textObjectList);
            BaseLogger.log((String)"3", null, null, (Object)("label map " + labelMap));
            NodeList groupboxObjectList = doc.getElementsByTagName("GroupBox");
            JSONArray groupArray = this.getGroupBoxArray(groupboxObjectList);
            BaseLogger.log((String)"3", null, null, (Object)("group array = " + groupArray.toString()));
            NodeList tableColumnList = doc.getElementsByTagName("table_column");
            Map<String, JSONObject> tableColumnObjectWithValue = this.getValueTableColumn(tableColumnList);
            BaseLogger.log((String)"3", null, null, (Object)("table column size " + tableColumnList.getLength()));
            JSONArray columnArray = new JSONArray();
            int i = 0;
            while (i < columnObjectList.getLength()) {
                Element columnObject = (Element)columnObjectList.item(i);
                JSONObject column = new JSONObject();
                column.put("alignment", (Object)this.getElementValue(columnObject, "alignment"));
                column.put("tabsequence", (Object)this.getElementValue(columnObject, "tabsequence"));
                column.put("x", (Object)this.getElementValue(columnObject, "x"));
                column.put("y", (Object)this.getElementValue(columnObject, "y"));
                column.put("height", (Object)this.getElementValue(columnObject, "height"));
                column.put("width", (Object)this.getElementValue(columnObject, "width"));
                column.put("format", (Object)this.getElementValue(columnObject, "format"));
                column.put("name", (Object)this.getElementValue(columnObject, "name"));
                column.put("visible", (Object)this.getElementValue(columnObject, "visible"));
                column.put("tag", (Object)this.getElementValue(columnObject, "tag"));
                Element editStyle = (Element)columnObject.getElementsByTagName("EditStyle").item(0);
                String style = editStyle.getAttribute("style");
                column.put("edit_style", (Object)style);
                String limit = this.getElementValue(editStyle, "limit");
                column.put("limit", (Object)limit);
                String required = this.getElementValue(editStyle, "required");
                required = required.equals("") ? "false" : "true";
                column.put("required", (Object)required);
                String caseValue = this.getElementValue(editStyle, "case");
                column.put("case", (Object)caseValue);
                String mask = this.getElementValue(editStyle, "mask");
                column.put("mask", (Object)mask);
                String name = this.getElementValue(columnObject, "name");
                column.put("display_label", (Object)labelMap.get(name));
                String x = this.getElementValue(columnObject, "x");
                String y = this.getElementValue(columnObject, "y");
                String group = this.findGroup(x, y, groupArray);
                column.put("group", (Object)group);
                BaseLogger.log((String)"3", null, null, (Object)("Found groupbox name " + group));
                if (tableColumnObjectWithValue.containsKey(name)) {
                    column.put("initial", tableColumnObjectWithValue.get(name).get("initial"));
                    column.put("values", tableColumnObjectWithValue.get(name).get("values"));
                }
                columnArray.put((Object)column);
                ++i;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("column", (Object)columnArray);
            BaseLogger.log((String)"3", null, null, (Object)("column array=" + jsonObject.toString()));
            return columnArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log((String)"3", null, null, (Object)"Error in getting JSON");
            return new JSONArray();
        }
    }

    private String getElementValue(Element parentElement, String tagName) {
        NodeList nodeList = parentElement.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return "";
    }

    private String findGroup(String x, String y, JSONArray groupArray) {
        String groupName = "";
        try {
            int columnX = Integer.parseInt(x);
            int columnY = Integer.parseInt(y);
            int i = 0;
            while (i < groupArray.length()) {
                JSONObject groupBox = groupArray.getJSONObject(i);
                String name = groupBox.getString("name");
                int groupBoxX = groupBox.getInt("x");
                int groupBoxXMax = groupBox.getInt("x_max");
                int groupBoxY = groupBox.getInt("y");
                int groupBoxYMax = groupBox.getInt("y_max");
                if (columnX >= groupBoxX && columnX <= groupBoxXMax && columnY >= groupBoxY && columnY <= groupBoxYMax) {
                    groupName = name;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Error: " + e.getMessage()));
        }
        BaseLogger.log((String)"3", null, null, (Object)("Found Groups name " + groupName));
        return groupName;
    }

    Map<String, String> getLabelMap(NodeList textObjectList) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        int i = 0;
        while (i < textObjectList.getLength()) {
            Node node = textObjectList.item(i);
            if (node.getNodeType() == 1) {
                Element textObject = (Element)node;
                String name = this.getElementValue(textObject, "name");
                String text = this.getElementValue(textObject, "text");
                if (name != null && name.endsWith("_t")) {
                    name = name.substring(0, name.length() - 2);
                }
                if (name != null) {
                    labelMap.put(name, text);
                }
            }
            ++i;
        }
        return labelMap;
    }

    private JSONArray getGroupBoxArray(NodeList groupboxObjectList) {
        JSONArray gruopArray = new JSONArray();
        int i = 0;
        while (i < groupboxObjectList.getLength()) {
            Node node = groupboxObjectList.item(i);
            if (node.getNodeType() == 1) {
                Element textObject = (Element)node;
                String name = this.getElementValue(textObject, "text");
                String x = this.getElementValue(textObject, "x");
                String y = this.getElementValue(textObject, "y");
                String height = this.getElementValue(textObject, "height");
                String width = this.getElementValue(textObject, "width");
                try {
                    int xVal = Integer.parseInt(x);
                    int heightVal = Integer.parseInt(height);
                    int yVal = Integer.parseInt(y);
                    int widthVal = Integer.parseInt(width);
                    JSONObject group = new JSONObject();
                    group.put("x", xVal);
                    group.put("height", heightVal);
                    group.put("x_max", xVal + widthVal);
                    group.put("name", (Object)name);
                    group.put("y", yVal);
                    group.put("y_max", yVal + heightVal);
                    group.put("width", widthVal);
                    gruopArray.put((Object)group);
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Error" + e.getMessage()));
                }
            }
            ++i;
        }
        return gruopArray;
    }

    private Map<String, JSONObject> getValueTableColumn(NodeList tableColumnList) {
        HashMap<String, JSONObject> elementMap = new HashMap<String, JSONObject>();
        try {
            int i = 0;
            while (i < tableColumnList.getLength()) {
                Element tableColumnElement;
                NodeList valuesList;
                Node node = tableColumnList.item(i);
                if (node.getNodeType() == 1 && (valuesList = (tableColumnElement = (Element)node).getElementsByTagName("values")).getLength() > 0) {
                    String columnName = this.getElementValue(tableColumnElement, "name");
                    String initial = this.getElementValue(tableColumnElement, "initial");
                    Element valuesElement = (Element)valuesList.item(0);
                    NodeList itemList = valuesElement.getElementsByTagName("item");
                    JSONArray valueArray = new JSONArray();
                    int j = 0;
                    while (j < itemList.getLength()) {
                        Element itemElement = (Element)itemList.item(j);
                        String displayValue = itemElement.getAttribute("display");
                        String dataValue = itemElement.getAttribute("data");
                        JSONObject item = new JSONObject();
                        item.put("display", (Object)displayValue);
                        item.put("data", (Object)dataValue);
                        valueArray.put((Object)item);
                        ++j;
                    }
                    JSONObject values = new JSONObject();
                    values.put("values", (Object)valueArray);
                    values.put("initial", (Object)initial);
                    elementMap.put(columnName, values);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elementMap;
    }
}

