/*
 * Decompiled with CFR 0.152.
 */
package ibase.marketingCampaign;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarketingCampaignIC
extends ValidatorEJB {
    E12GenericUtility genericUtility = new E12GenericUtility();

    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        Document dom = null;
        Document dom1 = null;
        Document dom2 = null;
        String errString = null;
        System.out.println("xmlString[" + xmlString + "]");
        System.out.println("xmlString1[" + xmlString1 + "]");
        System.out.println("xmlString2[" + xmlString2 + "]");
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                dom = this.genericUtility.parseString(xmlString);
            }
            if (xmlString1 != null && xmlString1.trim().length() != 0) {
                dom1 = this.genericUtility.parseString(xmlString1);
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                dom2 = this.genericUtility.parseString(xmlString2);
            }
            errString = this.wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
            System.out.println("ErrString: " + errString);
        }
        catch (Exception e) {
            System.out.println("Exception: SfaTime: wfValData(String xmlString): " + e.getMessage() + ":");
            errString = this.genericUtility.createErrorString(e);
            e.printStackTrace();
        }
        System.out.println("Returning from SfaTime wfValData");
        return errString;
    }

    public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)">>>>>>>>>>>>>>>>>>validation called>>>>>>>>>>>>>>>>>>>");
        System.out.println("Inside SfaTime validation");
        NodeList parentNodeList = null;
        NodeList childNodeList = null;
        Node parentNode = null;
        Node childNode = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String childNodeName = null;
        String errorString = "";
        String userId = "";
        int ctr = 0;
        int currentFormNo = 0;
        int childNodeListLength = 0;
        int batchCount = 0;
        SimpleDateFormat dtFormat = new SimpleDateFormat("dd/MM/yy");
        try {
            try {
                conn = this.getConnection();
                userId = this.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
                if (objContext != null && objContext.trim().length() > 0) {
                    currentFormNo = Integer.parseInt(objContext);
                }
                parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
                parentNode = parentNodeList.item(0);
                childNodeList = parentNode.getChildNodes();
                childNodeListLength = childNodeList.getLength();
                ctr = 0;
                while (ctr < childNodeListLength) {
                    childNode = childNodeList.item(ctr);
                    childNodeName = childNode.getNodeName();
                    switch (currentFormNo) {
                        case 1: {
                            if (!childNodeName.equalsIgnoreCase("campaign_id")) break;
                            if (childNode.getFirstChild() == null) {
                                errorString = this.getErrorString("campaign_id", "NLSTATCODE", userId);
                                System.out.println("Inside check null condition");
                                break;
                            }
                            batchCount = Integer.parseInt(this.genericUtility.getColumnValue("batch_count", dom));
                            String startDate = this.genericUtility.getColumnValue("start_date", dom);
                            String endDate = this.genericUtility.getColumnValue("end_date", dom);
                            String expEndDate = this.genericUtility.getColumnValue("exp_end_date", dom);
                            startDate = startDate.trim();
                            endDate = endDate.trim();
                            expEndDate = expEndDate.trim();
                            BaseLogger.log((String)"0", null, null, (Object)("start date [" + startDate + "]"));
                            BaseLogger.log((String)"0", null, null, (Object)("end date [" + endDate + "]"));
                            BaseLogger.log((String)"0", null, null, (Object)("expected end date [" + endDate + "]"));
                            try {
                                Date formatedStartDate = dtFormat.parse(startDate);
                                Date formatedEndDate = dtFormat.parse(endDate);
                                Date formatedExpEndDate = dtFormat.parse(expEndDate);
                                if (formatedStartDate.compareTo(formatedEndDate) > 0) {
                                    errorString = this.getErrorString("start_date", "VMINVPRDST", userId);
                                }
                                if (formatedStartDate.compareTo(formatedExpEndDate) > 0) {
                                    errorString = this.getErrorString("exp_end_date", "VMINVPRDST", userId);
                                }
                            }
                            catch (ParseException pe) {
                                BaseLogger.log((String)"0", null, null, (Object)("Parsing error: " + pe.getMessage()));
                                errorString = "Invalid date format";
                            }
                            if (batchCount >= 1) break;
                            errorString = this.getErrorString("batch_count", "VTBATCH2", userId);
                        }
                    }
                    ++ctr;
                }
            }
            catch (Exception e) {
                System.out.println("Exception: SfaTime: wfValData: " + e.getMessage() + ":");
                e.printStackTrace();
                this.closeResources(rs, pstmt, conn);
            }
        }
        finally {
            this.closeResources(rs, pstmt, conn);
        }
        return errorString;
    }

    public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        Document dom = null;
        Document dom1 = null;
        Document dom2 = null;
        String errString = null;
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                dom = this.genericUtility.parseString(xmlString);
            }
            if (xmlString1 != null && xmlString1.trim().length() != 0) {
                dom1 = this.genericUtility.parseString(xmlString1);
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                dom2 = this.genericUtility.parseString(xmlString2);
            }
            errString = this.itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
            System.out.println("ErrString :" + errString);
        }
        catch (Exception e) {
            System.out.println("Exception :SfaTime :itemChanged(String,String):" + e.getMessage() + ":");
            errString = this.genericUtility.createErrorString(e);
        }
        System.out.println("returning from SfaTime itemChanged");
        return errString;
    }

    public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        StringBuffer valueXmlString;
        block13: {
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)">>>>>>>>>>>>>>>>>>itemchange called>>>>>>>>>>>>>>>>>>>");
            System.out.println("Inside itemchange");
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            valueXmlString = null;
            int currentFormNo = 0;
            String userId = "";
            try {
                try {
                    conn = this.getConnection();
                    userId = this.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
                    if (objContext != null && objContext.trim().length() > 0) {
                        currentFormNo = Integer.parseInt(objContext);
                    }
                    valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
                    valueXmlString.append(editFlag).append("</editFlag></header>");
                    switch (currentFormNo) {
                        case 1: {
                            valueXmlString.append("<Detail1>");
                            if ("campaign_frequency".equalsIgnoreCase(currentColumn.trim())) {
                                String campaignFrequency = this.checkNull(this.genericUtility.getColumnValue("campaign_frequency", dom));
                                if ("O".equalsIgnoreCase(campaignFrequency)) {
                                    valueXmlString.append("<schedule_id protect='1'>").append("<![CDATA[]]>").append("</schedule_id>\r\n");
                                } else if ("S".equalsIgnoreCase(campaignFrequency)) {
                                    valueXmlString.append("<schedule_id protect='0'>").append("<![CDATA[]]>").append("</schedule_id>\r\n");
                                }
                            }
                            valueXmlString.append("</Detail1>\r\n");
                        }
                    }
                    valueXmlString.append("</Root>\r\n");
                }
                catch (Exception e) {
                    System.out.println("Exception :SfaTime :itemChanged(Document,String):" + e.getMessage() + ":");
                    e.printStackTrace();
                    this.closeResources(rs, pstmt, conn);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, pstmt, conn);
                throw throwable;
            }
            this.closeResources(rs, pstmt, conn);
        }
        return valueXmlString.toString();
    }

    private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String checkNull(String input) {
        input = input == null ? "" : input.trim();
        return input;
    }
}

