/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.ejb.CommonDBAccessEJB;
import ibase.hibernate.bean.DocTypeProc;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocTypeProcDAO {
    public void saveOverviewData(UserInfoBean userInfo, JSONObject overViewObj) throws ITMException {
        DocTypeProc docTypeProcDoc = null;
        try {
            String transDB = userInfo.getTransDB();
            String userID = userInfo.getLoginCode();
            String docType = this.checkNull(overViewObj.optString("doc_type"));
            String entType = this.checkNull(overViewObj.optString("ent_type"));
            String entCode = this.checkNull(overViewObj.optString("ent_code"));
            String fileType = this.checkNull(overViewObj.optString("file_type"));
            String chgTerm = userInfo.getRemoteAddress();
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Transaction tx = session.beginTransaction();
            docTypeProcDoc = this.getDocTypeProcObj(docType, entType, entCode, fileType, transDB);
            if (docTypeProcDoc == null) {
                BaseLogger.log("3", userInfo, null, "In if DocTypeProc is null");
                docTypeProcDoc = new DocTypeProc();
                docTypeProcDoc.setDocType(this.checkNull(overViewObj.optString("doc_type")));
                docTypeProcDoc.setEntType(this.checkNull(overViewObj.optString("ent_type")));
                docTypeProcDoc.setEntCode(this.checkNull(overViewObj.optString("ent_code")));
                docTypeProcDoc.setFileType(this.checkNull(overViewObj.optString("file_type")));
            }
            docTypeProcDoc.setEntName(this.checkNull(overViewObj.optString("ent_name")));
            docTypeProcDoc.setProcMtd(this.checkNull(overViewObj.optString("proc_mtd")));
            docTypeProcDoc.setAiProcTempl(this.checkNull(overViewObj.optString("ai_proc_templ")));
            docTypeProcDoc.setAiProcVariables(this.checkNull(overViewObj.optString("ai_proc_variables")));
            BaseLogger.log("2", userInfo, null, "In saveOverviewData data to insert or update :[" + docTypeProcDoc + "]");
            session.saveOrUpdate((Object)docTypeProcDoc);
            session.flush();
            tx.commit();
            session.close();
        }
        catch (HibernateException he) {
            BaseLogger.log("0", userInfo, null, "HibernateException in saveOverviewData :[" + E12GenericUtility.getStackTrace((Exception)((Object)he)) + "]");
            he.printStackTrace();
            throw new ITMException((Exception)((Object)he));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception in saveOverviewData :[" + E12GenericUtility.getStackTrace(e) + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public JSONObject getDocTypeProcParams(UserInfoBean userInfo, String docType, String entType, String entCode, String fileType) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        JSONObject docTypeProcObj = new JSONObject();
        String prcMethod = "";
        String prcInstr = "";
        try {
            try {
                docTypeProcObj.put("doc_type", (Object)docType);
                docTypeProcObj.put("ent_type", (Object)entType);
                docTypeProcObj.put("ent_code", (Object)entCode);
                docTypeProcObj.put("file_type", (Object)fileType);
                conn = connDriver.getConnectDB(userInfo);
                String sql = "SELECT PROC_MTD, AI_PROC_TEMPL, AI_PROC_VARIABLES, ENT_NAME FROM DOC_TYPE_PROC WHERE DOC_TYPE = ? AND ENT_TYPE = ? AND ENT_CODE = ? AND FILE_TYPE = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docType);
                pstmt.setString(2, entType);
                pstmt.setString(3, entCode);
                pstmt.setString(4, fileType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    docTypeProcObj.put("proc_mtd", (Object)rs.getString("PROC_MTD"));
                    docTypeProcObj.put("ent_name", (Object)rs.getString("ENT_NAME"));
                    Clob clob = rs.getClob("AI_PROC_TEMPL");
                    InputStream is = clob.getAsciiStream();
                    String aiProcTempl = clob.getSubString(1L, (int)clob.length());
                    Clob clob1 = rs.getClob("AI_PROC_VARIABLES");
                    InputStream is1 = clob1.getAsciiStream();
                    String aiProcVar = clob1.getSubString(1L, (int)clob1.length());
                    docTypeProcObj.put("ai_proc_templ", (Object)aiProcTempl);
                    docTypeProcObj.put("ai_proc_variables", (Object)aiProcVar);
                    BaseLogger.log("3", null, null, "docTypeProcObj :: configured proc_mtd & proc_instr : [" + docTypeProcObj.toString() + "]");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd"))) || "".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_templ"))) || "".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_variables")))) {
                    String defaultSql = "SELECT DEF_PROC_MTD, AI_PROC_TEMPL, AI_PROC_VARIABLES FROM DOC_TYPE WHERE DOC_TYPE=?";
                    pstmt = conn.prepareStatement(defaultSql);
                    pstmt.setString(1, docType);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Clob clob = rs.getClob("AI_PROC_TEMPL");
                        InputStream is = clob.getAsciiStream();
                        String aiProcTempl = clob.getSubString(1L, (int)clob.length());
                        Clob clob1 = rs.getClob("AI_PROC_VARIABLES");
                        InputStream is1 = clob1.getAsciiStream();
                        String aiProcVar = clob1.getSubString(1L, (int)clob1.length());
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("proc_mtd")))) {
                            docTypeProcObj.put("proc_mtd", (Object)rs.getString("DEF_PROC_MTD"));
                        }
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_templ")))) {
                            docTypeProcObj.put("ai_proc_templ", (Object)aiProcTempl);
                        }
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(docTypeProcObj.optString("ai_proc_variables")))) {
                            docTypeProcObj.put("ai_proc_variables", (Object)aiProcVar);
                        }
                        BaseLogger.log("3", null, null, "docTypeProcObj :: default proc_mtd & proc_instr : [" + docTypeProcObj.toString() + "]");
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
                this.updateDefaultValue(userInfo, docTypeProcObj);
                BaseLogger.log("3", null, "DocTypeProcDAO.getDocTypeProcParams()", " docTypeProcObj::: [" + docTypeProcObj + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getDocTypeProcParams()", " Exception in getDocTypeProcParams : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getDocTypeProcParams()", " Exception in getDocTypeProcParams Finally : " + e);
            }
        }
        return docTypeProcObj;
    }

    public void updateDefaultValue(UserInfoBean userInfo, JSONObject docTypeProcObj) throws ITMException {
        String type = "";
        try {
            String str = docTypeProcObj.optString("ai_proc_variables");
            JSONObject argumentJson = new JSONObject(str);
            Iterator keys = argumentJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray argumentJSONArr = argumentJson.optJSONArray(key);
                int i = 0;
                while (i < argumentJSONArr.length()) {
                    String actualValue;
                    String defSrcInput;
                    String sql;
                    JSONObject procVariableObj = argumentJSONArr.optJSONObject(i);
                    type = procVariableObj.optString("type");
                    if (type.equalsIgnoreCase("SQL")) {
                        sql = procVariableObj.optString("def_source");
                        defSrcInput = procVariableObj.optString("def_source_input");
                        actualValue = this.getSQLData(userInfo, docTypeProcObj, procVariableObj, sql, defSrcInput);
                        procVariableObj.put("defaultValue", (Object)actualValue);
                    } else if (type.equalsIgnoreCase("RestAPI")) {
                        sql = procVariableObj.optString("def_source");
                        defSrcInput = procVariableObj.optString("def_source_input");
                        actualValue = this.getRestAPIData(userInfo, docTypeProcObj, procVariableObj, sql, defSrcInput);
                        procVariableObj.put("defaultValue", (Object)actualValue);
                    }
                    ++i;
                }
            }
            docTypeProcObj.put("ai_proc_variables", (Object)argumentJson);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, "DocTypeProcDAO.updateDefaultValue()", " Exception in updateDefaultValue  : " + e);
            throw new ITMException(e);
        }
    }

    private String getRestAPIData(UserInfoBean userInfo, JSONObject docTypeProcObj, JSONObject procVariableObj, String sql, String defSrcInput) throws ITMException {
        String returnValue = "";
        try {
            String[] defSrcInputArr = defSrcInput.split(":");
            String userInfoXML = userInfo.toString();
            StringBuffer sb = new StringBuffer();
            Document userInfoDom = new E12GenericUtility().parseString(userInfoXML);
            NodeList tempNodeList = userInfoDom.getElementsByTagName("UserInfo");
            int i = 0;
            while (i < defSrcInputArr.length) {
                String keys = defSrcInputArr[i];
                String[] keyArr = keys.split("\\.");
                String key = keyArr[0];
                String mappedKey = keyArr[1];
                String value = mappedKey;
                if ("".equalsIgnoreCase(E12GenericUtility.checkNull(value))) {
                    value = this.getFromUserInfo(mappedKey, tempNodeList);
                }
                if ("".equalsIgnoreCase(E12GenericUtility.checkNull(value))) {
                    value = mappedKey;
                }
                if (i == 0) {
                    sb.append(String.valueOf(key) + "=" + value);
                } else {
                    sb.append("&" + key + "=" + value);
                }
                ++i;
            }
            String extWebServiceURL = procVariableObj.optString("def_source");
            StringBuffer queryParam = new StringBuffer();
            ByteArrayInputStream postDataInputStream = null;
            if (!extWebServiceURL.startsWith("http")) {
                if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0) {
                    CommonConstants.setIBASEHOME();
                }
                extWebServiceURL = String.valueOf(CommonConstants.TOMCAT_HOME) + extWebServiceURL;
            }
            String userInfoStr = userInfo.toString();
            String queryParamStr = sb.toString();
            if (queryParamStr != null) {
                postDataInputStream = new ByteArrayInputStream(queryParamStr.getBytes(StandardCharsets.UTF_8));
            }
            byte[] responseData = E12GenericUtility.makeRequest(extWebServiceURL, postDataInputStream, 0, userInfo.getSesstionId());
            returnValue = new String(responseData);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, "DocTypeProcDAO.getrestAPIData()", " Exception in getrestAPIData  : " + e);
            throw new ITMException(e);
        }
        return returnValue;
    }

    private String getSQLData(UserInfoBean userInfo, JSONObject docTypeProcObj, JSONObject procVariableObj, String sql, String defSrcInput) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ConnDriver connDriver = new ConnDriver();
        ArrayList list = new ArrayList();
        String returnValue = "";
        try {
            try {
                String[] defSrcInputArr = defSrcInput.split(":");
                String userInfoXML = userInfo.toString();
                Document userInfoDom = new E12GenericUtility().parseString(userInfoXML);
                NodeList tempNodeList = userInfoDom.getElementsByTagName("UserInfo");
                conn = connDriver.getConnectDB(userInfo);
                pstmt = conn.prepareStatement(sql);
                if (sql.indexOf("?") != -1) {
                    int k = 1;
                    int i = 0;
                    while (i < defSrcInputArr.length) {
                        String key = defSrcInputArr[i];
                        String parameter = docTypeProcObj.optString(key);
                        if ("".equalsIgnoreCase(E12GenericUtility.checkNull(parameter))) {
                            parameter = this.getFromUserInfo(key, tempNodeList);
                        } else if ("".equalsIgnoreCase(E12GenericUtility.checkNull(parameter))) {
                            parameter = key;
                        }
                        pstmt.setString(k, parameter);
                        ++k;
                        ++i;
                    }
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    returnValue = "".equalsIgnoreCase(this.checkNull(returnValue)) ? this.checkNull(rs.getString(1)) : String.valueOf(returnValue) + ", " + this.checkNull(rs.getString(1));
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getSQLData()", " Exception in getSQLData  : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getSQLData()", " Exception in getSQLData Finally : " + e);
            }
        }
        return returnValue;
    }

    private String getFromUserInfo(String key, NodeList tempNodeList) {
        String value = "";
        try {
            Node rootNode = tempNodeList.item(0);
            NodeList propNodeList = rootNode.getChildNodes();
            int noOfProps = propNodeList.getLength();
            int propCtr = 0;
            while (propCtr < noOfProps) {
                String propName;
                Node propNode = propNodeList.item(propCtr);
                if (propNode != null && (propName = propNode.getNodeName()).equalsIgnoreCase(key)) {
                    value = propNode.getFirstChild() != null ? propNode.getFirstChild().getNodeValue() : propNode.getNodeValue();
                    break;
                }
                ++propCtr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, "DocTypeProcDAO.getParameter()", " Exception in getParameter  : " + e);
        }
        return value;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private DocTypeProc getDocTypeProcObj(String docType, String entType, String entCode, String fileType, String transDB) {
        DocTypeProc docTypeProc = null;
        try {
            Session session = HibernateUtil.getSessionFactory(transDB).openSession();
            Query query = session.createQuery("from DocTypeProc where docType='" + docType + "' and entType='" + entType + "' and entCode='" + entCode + "' and fileType='" + fileType + "'");
            List docTypeProcList = query.getResultList();
            BaseLogger.log("3", null, null, "data for geting getDocTypeProcObj in docTypeProcList:::" + docTypeProcList);
            if (docTypeProcList != null && docTypeProcList.size() > 0) {
                docTypeProc = (DocTypeProc)docTypeProcList.get(0);
                BaseLogger.log("3", null, null, "data for geting getDocTypeProcObj in docTypeProc:::" + docTypeProc);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException getDocTypeProcObj :");
            BaseLogger.log("0", null, null, e.getMessage());
            BaseLogger.log("0", null, null, "Exception in [getDocTypeProcObj]:::" + e.getMessage());
        }
        return docTypeProc;
    }

    public String getProcMethodList(UserInfoBean userInfo, String docType) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        JSONArray procMethodJSONArr = new JSONArray();
        boolean result = true;
        try {
            try {
                conn = connDriver.getConnectDB(userInfo);
                String sql = "SELECT PROC_MTD FROM PROC_MTDS WHERE DOC_TYPE = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, docType);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = false;
                    procMethodJSONArr.put((Object)rs.getString("PROC_MTD"));
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (result) {
                    String defSql = "SELECT DEF_PROC_MTD FROM DOC_TYPE WHERE DOC_TYPE = ?";
                    pstmt = conn.prepareStatement(defSql);
                    pstmt.setString(1, docType);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        procMethodJSONArr.put((Object)rs.getString("DEF_PROC_MTD"));
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getProcMethodList()", " Exception in getProcMethodList : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getProcMethodList()", " Exception in getProcMethodList Finally : " + e);
            }
        }
        return procMethodJSONArr.toString();
    }

    public JSONObject getProcessMethodParams(UserInfoBean userInfo, String documentType, String procApiName, String entCode, String entType, String fileType) throws ITMException {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        ConnDriver connDriver = new ConnDriver();
        JSONObject procMethodObj = new JSONObject();
        boolean result = true;
        try {
            try {
                conn = connDriver.getConnectDB(userInfo);
                String sql = "SELECT AI_PROC_TEMPL, AI_PROC_VARIABLES FROM DOC_TYPE_PROC WHERE DOC_TYPE = ? AND ENT_TYPE = ? AND ENT_CODE = ? AND FILE_TYPE = ? AND PROC_MTD = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, documentType);
                pstmt.setString(2, entType);
                pstmt.setString(3, entCode);
                pstmt.setString(4, fileType);
                pstmt.setString(5, procApiName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = false;
                    Clob clob = rs.getClob("AI_PROC_TEMPL");
                    InputStream is = clob.getAsciiStream();
                    String aiProcTempl = clob.getSubString(1L, (int)clob.length());
                    Clob clob1 = rs.getClob("AI_PROC_VARIABLES");
                    InputStream is1 = clob1.getAsciiStream();
                    String aiProcVar = clob1.getSubString(1L, (int)clob1.length());
                    procMethodObj.put("ai_proc_templ", (Object)aiProcTempl);
                    procMethodObj.put("ai_proc_variables", (Object)aiProcVar);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                if (result) {
                    String defsql = "SELECT AI_PROC_TEMPL,AI_PROC_VARIABLES FROM PROC_MTDS WHERE DOC_TYPE = ? AND PROC_MTD = ?";
                    pstmt = conn.prepareStatement(defsql);
                    pstmt.setString(1, documentType);
                    pstmt.setString(2, procApiName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Clob clob = rs.getClob("AI_PROC_TEMPL");
                        InputStream is = clob.getAsciiStream();
                        String aiProcTempl = clob.getSubString(1L, (int)clob.length());
                        Clob clob1 = rs.getClob("AI_PROC_VARIABLES");
                        InputStream is1 = clob1.getAsciiStream();
                        String aiProcVar = clob1.getSubString(1L, (int)clob1.length());
                        procMethodObj.put("ai_proc_templ", (Object)aiProcTempl);
                        procMethodObj.put("ai_proc_variables", (Object)aiProcVar);
                    }
                    rs.close();
                    rs = null;
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getProcessMethodParams()", " Exception in getProcessMethodParams : " + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, "DocTypeProcDAO.getProcessMethodParams()", " Exception in getProcessMethodParams Finally : " + e);
            }
        }
        return procMethodObj;
    }

    public String getDistChannel(String entCode, UserInfoBean userInfo) {
        String ordType = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo);
                String sql = "SELECT ORDER_TYPE FROM CUSTOMER WHERE CUST_CODE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, entCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ordType = this.checkNull(rs.getString("ORDER_TYPE"));
                }
                pstmt.close();
                rs.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "DocTypeProcDAO getDistChannel Exception :CATCH: [" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "DocTypeProcDAO getDistChannel Exception :FINALLY: [" + e2.getMessage() + "]");
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", null, null, "DocTypeProcDAO getDistChannel Exception :FINALLY: [" + e2.getMessage() + "]");
            }
        }
        return ordType;
    }
}

