/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.DocumentHandlerServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DocumentViewerServiceUtility
extends RestAPIServiceUtility {
    public byte[] getPreviewImageAgainstDocId(String objName, String refId, String checkObjName, HttpServletRequest request, HttpServletResponse response, String tokenIDfromHeader) {
        BaseLogger.log("3", null, null, " getPreviewImageAgainstDocId method call: ");
        UserInfoBean userInformation = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        String refSer = null;
        try {
            refSer = dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", "TRAN_WINDOW = 'w_" + objName + "'", "Driver");
        }
        catch (ITMException | RemoteException e) {
            e.printStackTrace();
        }
        DocumentHandlerServiceUtility documentHandlerServiceUtility = new DocumentHandlerServiceUtility();
        byte[] byteArray = null;
        try {
            byteArray = documentHandlerServiceUtility.getAttachConfigData(objName, refSer, refId, checkObjName, request, tokenIDfromHeader);
            String responseData = new String(byteArray);
            ArrayList<String> docIds = new ArrayList<String>();
            try {
                JSONArray jsonArray = new JSONArray(responseData);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String docId = jsonObject.optString("docId");
                    docIds.add(docId);
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (String docId : docIds) {
                try {
                    BaseLogger.log("3", null, null, "DocumentViewerServlet :: docID [" + docId + "]");
                    byteArray = docId == null || "".equals(docId.trim()) ? new byte[1] : ((byteArray = this.getVideoFrame(docId, userInformation)) == null ? new byte[1] : byteArray);
                    response.setContentType("image/png");
                    response.getOutputStream().write(byteArray);
                }
                catch (Exception ex) {
                    BaseLogger.log("3", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArray;
    }

    private byte[] getVideoFrame(String docId, UserInfoBean userInformation) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        InputStream inputStream = null;
        byte[] iconByteArray = new byte[1];
        BaseLogger.log("3", null, null, " getVideoFrame method call: ");
        try {
            try {
                String sql = "SELECT ICON FROM DOC_CONTENTS WHERE DOC_ID = " + docId;
                BaseLogger.log("3", userInformation, null, "DocumentViewerServlet :: getVideoFrame() : sql [" + sql + "]");
                String transDB = userInformation.getTransDB();
                conn = new ConnDriver().getConnectDB(transDB);
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                if (rs.next() && (inputStream = rs.getBinaryStream(1)) != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int i = 0;
                    while ((i = inputStream.read()) != -1) {
                        byteArrayOutputStream.write(i);
                    }
                    iconByteArray = byteArrayOutputStream.toByteArray();
                }
            }
            catch (Exception ex) {
                BaseLogger.log("3", userInformation, null, "Exception in DocumentViewerServlet :: getVideoFrame() : " + ex);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (st != null) {
                    st.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return iconByteArray;
    }
}

