/*
 * Decompiled with CFR 0.152.
 */
package ibase.sd.project.deploy.wrkflw;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONObject;

public class WrkflwXPDLObject {
    private UserInfoBean userInfo = null;
    private E12GenericUtility genericUtility = new E12GenericUtility();

    public String buildWrkflwXPDL(String wfDesignId, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"In buildWrkflwXPDL");
        Connection conn = null;
        String workflowFileName = "";
        try {
            this.setUserInfo(userInfo);
            ConnDriver connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(userInfo.getTransDB());
            connDriver = null;
            String workflowName = this.getWorkflowName(wfDesignId, conn);
            String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + "wrkflw";
            String fileName = String.valueOf(workflowName) + ".xml";
            File xpdlFileObj = new File(String.valueOf(filePath) + File.separator + fileName);
            if (xpdlFileObj.exists()) {
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("(" + fileName + ") already exist at (" + filePath + ") path."));
                String string = String.valueOf(filePath) + File.separator + fileName;
                return string;
            }
            try {
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                StringBuilder workFlowString = new StringBuilder();
                workFlowString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                workFlowString.append("\n<Package Id=\"" + workflowName + "\" Name=\"" + workflowName + "\" xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">");
                workFlowString.append("\n<PackageHeader>");
                workFlowString.append("\n<XPDLVersion>1.0</XPDLVersion>");
                workFlowString.append("\n<Vendor>Together</Vendor>");
                workFlowString.append("\n<Created>" + timeStamp + "</Created>");
                workFlowString.append("\n</PackageHeader>");
                workFlowString.append("\n<RedefinableHeader PublicationStatus=\"UNDER_TEST\"/>");
                workFlowString.append("\n<ConformanceClass GraphConformance=\"NON_BLOCKED\"/>");
                workFlowString.append("\n<WorkflowProcesses>");
                workFlowString.append("\n<WorkflowProcess AccessLevel=\"PUBLIC\" Id=\"" + workflowName + "\" Name=\"" + workflowName + "\">");
                workFlowString.append("\n<ProcessHeader DurationUnit=\"D\">");
                workFlowString.append("\n<Created>" + timeStamp + "</Created>");
                workFlowString.append("\n</ProcessHeader>");
                workFlowString.append("\n<RedefinableHeader PublicationStatus=\"UNDER_TEST\"/>");
                workFlowString.append(this.buildParticipants(wfDesignId, conn));
                workFlowString.append(this.buildApplications(wfDesignId, conn));
                workFlowString.append(this.buildActivities(wfDesignId, workflowName, conn));
                workFlowString.append(this.buildTransitions(wfDesignId, workflowName, conn));
                workFlowString.append(this.buildExtendedAttributes(wfDesignId, workflowName, conn));
                workFlowString.append("\n</WorkflowProcess>");
                workFlowString.append("\n</WorkflowProcesses>");
                workFlowString.append("\n<ExtendedAttributes>");
                workFlowString.append("\n<ExtendedAttribute Name=\"MadeBy\" Value=\"JaWE\" />");
                workFlowString.append("\n<ExtendedAttribute Name=\"Version\" Value=\"1.4.2\" />");
                workFlowString.append("\n</ExtendedAttributes>");
                workFlowString.append("\n</Package>");
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("[FINAL] workFlowString : [" + workFlowString + "]"));
                workflowFileName = this.createWrkflwXPDL(filePath, fileName, workFlowString.toString());
            }
            catch (ITMException e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ITMException :: buildWrkflwXPDL : [" + e.getMessage() + "]"));
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Exception :: buildWrkflwXPDL : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return workflowFileName;
    }

    private String getWorkflowName(String wfDesignId, Connection conn) throws ITMException {
        String workflowName = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String workflowNameSql = "SELECT XPDL_FILE FROM WF_DESIGN WHERE WF_DESIGN_ID = ? ";
                pstmt = conn.prepareStatement(workflowNameSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    workflowName = rs.getString("XPDL_FILE");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("workflowName : [" + workflowName + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: getWorkflowName : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return workflowName;
    }

    private String getParticipants(String wfDesignId, Connection conn) throws ITMException {
        String participantsList = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String participantsSql = "SELECT ROLE_CODE FROM WF_DESIGN_ROLE WHERE WF_DESIGN_ID = ? ORDER BY LINE_NO";
                pstmt = conn.prepareStatement(participantsSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    participantsList = String.valueOf(participantsList) + E12GenericUtility.checkNull((String)rs.getString("ROLE_CODE")) + ";";
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("participantsList : [" + participantsList + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: getParticipants : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return participantsList;
    }

    private String buildParticipants(String wfDesignId, Connection conn) throws ITMException {
        StringBuilder workFlowParticipantsString = new StringBuilder();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"PARTICIPANTS");
                workFlowParticipantsString.append("\n<Participants>");
                String participantsSql = "SELECT ROLE_CODE, LINE_NO, ROLE_SQL_INPUT, DESCR FROM WF_DESIGN_ROLE  WHERE WF_DESIGN_ID = ?  ORDER BY LINE_NO";
                pstmt = conn.prepareStatement(participantsSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String participantId = E12GenericUtility.checkNull((String)rs.getString("ROLE_CODE"));
                    String participantValue = E12GenericUtility.checkNull((String)rs.getString("ROLE_SQL_INPUT"));
                    String participantDescr = E12GenericUtility.checkNull((String)rs.getString("DESCR"));
                    String participantType = "String:";
                    if (participantValue.indexOf(":") != -1) {
                        String[] participantValueArr = participantValue.split(":");
                        participantValue = String.valueOf(E12GenericUtility.checkNull((String)participantValueArr[0])) + ":";
                        if (E12GenericUtility.checkNull((String)participantValueArr[1]).length() > 0) {
                            participantType = String.valueOf(E12GenericUtility.checkNull((String)participantValueArr[1])) + ":";
                        }
                    }
                    workFlowParticipantsString.append("\n<Participant Id=\"" + participantId + "\" Name=\"" + participantId + "\">");
                    workFlowParticipantsString.append("\n<ParticipantType1 Type=\"ROLE\"/>");
                    workFlowParticipantsString.append("\n<ExtendedAttributes>");
                    workFlowParticipantsString.append("\n<ExtendedAttribute Name=\"PRFMR_ROLE_CODE\" Value=\"" + participantId + "\"/>");
                    workFlowParticipantsString.append("\n<ExtendedAttribute Name=\"SIGN_FOR\" Value=\"" + participantDescr + "\"/>");
                    if (participantValue != null && participantValue.length() > 0) {
                        workFlowParticipantsString.append("\n<ExtendedAttribute Name=\"PRFMR_ROLE_EXPR\" Value=\"" + participantValue + "\"/>");
                        workFlowParticipantsString.append("\n<ExtendedAttribute Name=\"PRFMR_ROLE_EXPR_TYPE\" Value=\"" + participantType + "\"/>");
                    }
                    workFlowParticipantsString.append("\n</ExtendedAttributes>");
                    workFlowParticipantsString.append("\n</Participant>");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                workFlowParticipantsString.append("\n</Participants>");
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("workFlowParticipantsString : [" + workFlowParticipantsString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: buildParticipants : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return workFlowParticipantsString.toString();
    }

    private String buildApplications(String wfDesignId, Connection conn) throws ITMException {
        StringBuilder workFlowApplicationString = new StringBuilder();
        Statement pstmt = null;
        Statement pstmt2 = null;
        Statement pstmt3 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        try {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"APPLICATIONS");
                workFlowApplicationString.append("\n<Applications>");
                String applicationSql = "SELECT DISTINCT ACTIVITY_CODE FROM WF_DESIGN_ROUTE WHERE WF_DESIGN_ID = ?";
                pstmt = conn.prepareStatement(applicationSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String activityCode = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("activityCode : [" + activityCode + "]"));
                    String applicationSql2 = "SELECT ACTIVITY_CODE, DESCR, ACTIVITY_TYPE, INVOKE_SYNC, CLASS_NAME, METHOD_NAME  FROM WF_ACTIVITY  WHERE ACTIVITY_CODE = ?";
                    pstmt2 = conn.prepareStatement(applicationSql2);
                    pstmt2.setString(1, activityCode);
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        String activityType = E12GenericUtility.checkNull((String)rs2.getString("ACTIVITY_TYPE"));
                        String activityDescr = E12GenericUtility.checkNull((String)rs2.getString("DESCR"));
                        String invoc = E12GenericUtility.checkNull((String)rs2.getString("INVOKE_SYNC"));
                        String className = E12GenericUtility.checkNull((String)rs2.getString("CLASS_NAME"));
                        String methoName = E12GenericUtility.checkNull((String)rs2.getString("METHOD_NAME"));
                        if ("0".equalsIgnoreCase(activityType)) {
                            activityType = "JB";
                        }
                        invoc = "0".equalsIgnoreCase(invoc) ? "SYNC" : "ASYNC";
                        workFlowApplicationString.append("\n<Application Id=\"" + activityCode + "\" Name=\"" + activityDescr + "\">");
                        String applicationSql3 = "SELECT ARG_NAME, ARG_TYPE, ARG_DEF_VALUE FROM WF_ACTIVITY_ARGS WHERE ACTIVITY_CODE = ?";
                        pstmt3 = conn.prepareStatement(applicationSql3);
                        pstmt3.setString(1, activityCode);
                        rs3 = pstmt3.executeQuery();
                        workFlowApplicationString.append("\n<FormalParameters>");
                        int index = 1;
                        while (rs3.next()) {
                            String argName = E12GenericUtility.checkNull((String)rs3.getString("ARG_NAME"));
                            String argType = E12GenericUtility.checkNull((String)rs3.getString("ARG_TYPE"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("argName : [" + argName + "], argType : [" + argType + "]"));
                            workFlowApplicationString.append("\n<FormalParameter Id=\"" + argName + "\" Index=\"" + index + "\" Mode=\"IN\">");
                            workFlowApplicationString.append("\n<DataType>");
                            workFlowApplicationString.append("\n<BasicType Type=\"" + argType + "\"/>");
                            workFlowApplicationString.append("\n</DataType>");
                            workFlowApplicationString.append("\n</FormalParameter>");
                            ++index;
                        }
                        rs3.close();
                        rs3 = null;
                        pstmt3.close();
                        pstmt3 = null;
                        workFlowApplicationString.append("\n</FormalParameters>");
                        workFlowApplicationString.append("\n<ExtendedAttributes>");
                        workFlowApplicationString.append("\n<ExtendedAttribute Name=\"APPLN_TYPE\" Value=\"" + activityType + "\"/>");
                        workFlowApplicationString.append("\n<ExtendedAttribute Name=\"COMP_NAME\" Value=\"" + className + "\"/>");
                        workFlowApplicationString.append("\n<ExtendedAttribute Name=\"METHOD_NAME\" Value=\"" + methoName + "\"/>");
                        workFlowApplicationString.append("\n<ExtendedAttribute Name=\"EXEC_MODE\" Value=\"" + invoc + "\"/>");
                        workFlowApplicationString.append("\n</ExtendedAttributes>");
                        workFlowApplicationString.append("\n</Application>");
                    }
                    rs2.close();
                    rs2 = null;
                    pstmt2.close();
                    pstmt2 = null;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                workFlowApplicationString.append("\n</Applications>");
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("workFlowApplicationString : [" + workFlowApplicationString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: buildApplications : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (pstmt2 != null) {
                    pstmt2.close();
                    pstmt2 = null;
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (pstmt3 != null) {
                    pstmt3.close();
                    pstmt3 = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return workFlowApplicationString.toString();
    }

    private String buildTransitions(String wfDesignId, String workflowName, Connection conn) throws ITMException {
        StringBuilder workFlowTransitionString = new StringBuilder();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"TRANSITIONS");
                workFlowTransitionString.append("\n<Transitions>");
                String transitionSql = "SELECT ROUTE.ACTIVITY_CODE__PREV, ROUTE.RULE_CODE, ROUTE.ACTIVITY_CODE, ROUTE.ACTIVITY_INPUT, ROUTE.ROUTE_NAME, ROUTE.ROUTE_BLOCK, RULE.RULE_TYPE, RULE.RULE_EXPRESSION, RULE.EXPRESSION_INPUT, ROUTE.RULE_INPUT  FROM WF_DESIGN_ROUTE ROUTE LEFT OUTER JOIN WF_DESIGN_RULE RULE ON ROUTE.WF_DESIGN_ID = RULE.WF_DESIGN_ID AND ROUTE.RULE_CODE = RULE.RULE_CODE  WHERE ROUTE.WF_DESIGN_ID = ? ORDER BY ROUTE.LINE_NO";
                pstmt = conn.prepareStatement(transitionSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String ruleCode = E12GenericUtility.checkNull((String)rs.getString("RULE_CODE"));
                    String transitionFrom = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE__PREV"));
                    String transitionTo = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE"));
                    String transitionType = E12GenericUtility.checkNull((String)rs.getString("RULE_TYPE"));
                    String transitionExpression = E12GenericUtility.checkNull((String)rs.getString("RULE_EXPRESSION"));
                    String transitionExprInput = E12GenericUtility.checkNull((String)rs.getString("EXPRESSION_INPUT"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("ruleCode : [" + ruleCode + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("transitionFrom : [" + transitionFrom + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("transitionTo : [" + transitionTo + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("transitionType : [" + transitionType + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("transitionExpression : [" + transitionExpression + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("transitionExprInput : [" + transitionExprInput + "]"));
                    if ("SUBMIT".equalsIgnoreCase(transitionFrom)) {
                        transitionFrom = workflowName;
                    }
                    workFlowTransitionString.append("\n<Transition From=\"" + transitionFrom + "\" Id=\"" + ruleCode + "\" To=\"" + transitionTo + "\">");
                    if (!"NO-CONDN".equalsIgnoreCase(ruleCode)) {
                        workFlowTransitionString.append("\n<Condition Type=\"" + transitionType + "\">" + transitionExpression + "</Condition>");
                    }
                    workFlowTransitionString.append("\n<ExtendedAttributes>");
                    workFlowTransitionString.append("\n<ExtendedAttribute Name=\"RoutingType\" Value=\"NOROUTING\"/>");
                    if (!"NO-CONDN".equalsIgnoreCase(ruleCode)) {
                        workFlowTransitionString.append("\n<ExtendedAttribute Name=\"VAR_NAMES\" Value=\"" + transitionExprInput + "\"/>");
                    }
                    workFlowTransitionString.append("\n</ExtendedAttributes>");
                    workFlowTransitionString.append("\n</Transition>");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                workFlowTransitionString.append("\n</Transitions>");
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("workFlowTransitionString : [" + workFlowTransitionString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: buildTransitions : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return workFlowTransitionString.toString();
    }

    private String buildActivities(String wfDesignId, String workflowName, Connection conn) throws ITMException {
        StringBuilder workFlowActivityString = new StringBuilder();
        Statement pstmt = null;
        Statement pstmt2 = null;
        Statement pstmt3 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        try {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"ACTIVITIES");
                workFlowActivityString.append("\n<Activities>");
                String participantsList = this.getParticipants(wfDesignId, conn);
                String initialPerformer = participantsList.substring(0, participantsList.indexOf(";"));
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("initial : [" + initialPerformer + "]"));
                workFlowActivityString.append("\n<Activity Id=\"" + workflowName + "\" Name=\"" + workflowName + "\">");
                workFlowActivityString.append("\n<Implementation><No/></Implementation>");
                workFlowActivityString.append("\n<Performer>" + initialPerformer + "</Performer>");
                workFlowActivityString.append("\n<StartMode><Automatic/></StartMode>");
                workFlowActivityString.append("\n<FinishMode><Automatic/></FinishMode>");
                workFlowActivityString.append("\n<ExtendedAttributes>");
                workFlowActivityString.append("\n<ExtendedAttribute Name=\"ParticipantID\" Value=\"" + initialPerformer + "\" />");
                workFlowActivityString.append("\n<ExtendedAttribute Name=\"XOffset\" Value=\"0\"/>");
                workFlowActivityString.append("\n<ExtendedAttribute Name=\"YOffset\" Value=\"0\"/>");
                workFlowActivityString.append("\n</ExtendedAttributes>");
                workFlowActivityString.append("\n</Activity>");
                String activitySql = "SELECT ROUTE.ACTIVITY_CODE, ACT.DESCR AS ACTIVITY_NAME, ROUTE.ACTIVITY_INPUT, ROUTE.ROUTE_NAME, ROUTE.ROUTE_BLOCK, ROUTE.RULE_INPUT, ROUTE.ROLE_CODE__PERFORM  FROM WF_DESIGN_ROUTE ROUTE LEFT OUTER JOIN WF_ACTIVITY ACT ON ROUTE.ACTIVITY_CODE = ACT.ACTIVITY_CODE  WHERE ROUTE.WF_DESIGN_ID = ?  ORDER BY ROUTE.LINE_NO";
                pstmt = conn.prepareStatement(activitySql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String activityId = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE"));
                    String toolId = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_NAME"));
                    String actualParameters = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_INPUT"));
                    String performer = E12GenericUtility.checkNull((String)rs.getString("ROLE_CODE__PERFORM"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("activityId : [" + activityId + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("toolId : [" + toolId + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("actualParameters : [" + actualParameters + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("performer : [" + performer + "]"));
                    workFlowActivityString.append("\n<Activity Id=\"" + activityId + "\" Name=\"" + activityId + "\">");
                    workFlowActivityString.append("\n<Implementation>");
                    workFlowActivityString.append("\n<Tool Id=\"" + activityId + "\" Type=\"APPLICATION\">");
                    workFlowActivityString.append("\n<ActualParameters>");
                    try {
                        if (actualParameters != null && actualParameters.length() > 0) {
                            String actParameter;
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("actualParameters : [" + actualParameters + "]"));
                            JSONObject actualParamJson = new JSONObject(actualParameters);
                            if ("APRV-EMAIL".equalsIgnoreCase(activityId) || "REJ-EMAIL".equalsIgnoreCase(activityId) || activityId.indexOf("EMAIL") != -1) {
                                String objName = "";
                                if (actualParamJson.has("obj_name")) {
                                    objName = actualParamJson.getString("obj_name");
                                }
                                String mailFormatCode = "";
                                if (actualParamJson.has("mail_format_code")) {
                                    mailFormatCode = actualParamJson.getString("mail_format_code");
                                }
                                actParameter = this.genericUtility.encodeXMLString(this.getMailXML(objName, mailFormatCode));
                                workFlowActivityString.append("\n<ActualParameter>" + actParameter + "</ActualParameter>");
                                Iterator keys = actualParamJson.keys();
                                while (keys.hasNext()) {
                                    String key = (String)keys.next();
                                    if ("obj_name".equalsIgnoreCase(key) || "mail_format_code".equalsIgnoreCase(key) || !(actualParamJson.get(key) instanceof String)) continue;
                                    actParameter = actualParamJson.getString(key);
                                    actParameter = this.genericUtility.encodeXMLString(actParameter);
                                    workFlowActivityString.append("\n<ActualParameter>" + actParameter + "</ActualParameter>");
                                }
                            } else {
                                Iterator keys = actualParamJson.keys();
                                while (keys.hasNext()) {
                                    String key = (String)keys.next();
                                    if (!(actualParamJson.get(key) instanceof String)) continue;
                                    actParameter = actualParamJson.getString(key);
                                    actParameter = this.genericUtility.encodeXMLString(actParameter);
                                    workFlowActivityString.append("\n<ActualParameter>" + actParameter + "</ActualParameter>");
                                }
                            }
                        }
                    }
                    catch (Exception ae) {
                        ae.printStackTrace();
                        BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("APPLICATIONS JSONArray Exception : [" + ae.getMessage() + "]"));
                    }
                    workFlowActivityString.append("\n</ActualParameters>");
                    workFlowActivityString.append("\n</Tool>");
                    workFlowActivityString.append("\n</Implementation>");
                    workFlowActivityString.append("\n<Performer>" + performer + "</Performer>");
                    workFlowActivityString.append("\n<StartMode><Automatic/></StartMode>");
                    workFlowActivityString.append("\n<FinishMode><Automatic/></FinishMode>");
                    String transitionRestrictionsCntSql = "SELECT COUNT(ACTIVITY_CODE__PREV) FROM WF_DESIGN_ROUTE WHERE WF_DESIGN_ID = ? AND ACTIVITY_CODE__PREV = ? ";
                    pstmt2 = conn.prepareStatement(transitionRestrictionsCntSql);
                    pstmt2.setString(1, wfDesignId);
                    pstmt2.setString(2, activityId);
                    rs2 = pstmt2.executeQuery();
                    if (rs2.next() && rs2.getInt(1) > 1) {
                        workFlowActivityString.append("\n<TransitionRestrictions>");
                        workFlowActivityString.append("\n<TransitionRestriction>");
                        workFlowActivityString.append("\n<Split Type=\"XOR\">");
                        workFlowActivityString.append("\n<TransitionRefs>");
                        String transitionRestrictionsSql = "SELECT RULE_CODE FROM WF_DESIGN_ROUTE WHERE WF_DESIGN_ID = ? AND ACTIVITY_CODE__PREV = ? ORDER BY LINE_NO";
                        pstmt3 = conn.prepareStatement(transitionRestrictionsSql);
                        pstmt3.setString(1, wfDesignId);
                        pstmt3.setString(2, activityId);
                        rs3 = pstmt3.executeQuery();
                        while (rs3.next()) {
                            String ruleCode = E12GenericUtility.checkNull((String)rs3.getString("RULE_CODE"));
                            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("ruleCode : [" + ruleCode + "]"));
                            workFlowActivityString.append("\n<TransitionRef Id=\"" + ruleCode + "\" />");
                        }
                        rs3.close();
                        rs3 = null;
                        pstmt3.close();
                        pstmt3 = null;
                        workFlowActivityString.append("\n</TransitionRefs>");
                        workFlowActivityString.append("\n</Split>");
                        workFlowActivityString.append("\n</TransitionRestriction>");
                        workFlowActivityString.append("\n</TransitionRestrictions>");
                    }
                    rs2.close();
                    rs2 = null;
                    pstmt2.close();
                    pstmt2 = null;
                    workFlowActivityString.append("\n<ExtendedAttributes>");
                    workFlowActivityString.append("\n<ExtendedAttribute Name=\"ParticipantID\" Value=\"" + performer + "\"/>");
                    workFlowActivityString.append("\n<ExtendedAttribute Name=\"XOffset\" Value=\"0\"/>");
                    workFlowActivityString.append("\n<ExtendedAttribute Name=\"YOffset\" Value=\"0\"/>");
                    workFlowActivityString.append("\n</ExtendedAttributes>");
                    workFlowActivityString.append("\n</Activity>");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                workFlowActivityString.append("\n</Activities>");
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("workFlowActivityString : [" + workFlowActivityString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: buildActivities : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs2 != null) {
                    rs2.close();
                    rs2 = null;
                }
                if (pstmt2 != null) {
                    pstmt2.close();
                    pstmt2 = null;
                }
                if (rs3 != null) {
                    rs3.close();
                    rs3 = null;
                }
                if (pstmt3 != null) {
                    pstmt3.close();
                    pstmt3 = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return workFlowActivityString.toString();
    }

    private String buildExtendedAttributes(String wfDesignId, String workflowName, Connection conn) throws ITMException {
        StringBuilder extendedAttributeString = new StringBuilder();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"EXTENDED ATTRIBUTES");
                String participantsList = this.getParticipants(wfDesignId, conn);
                String initialPerformer = participantsList.substring(0, participantsList.indexOf(";"));
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("initial : [" + initialPerformer + "]"));
                extendedAttributeString.append("\n<ExtendedAttributes>");
                extendedAttributeString.append("\n<ExtendedAttribute Name=\"StartOfWorkflow\" Value=\"" + initialPerformer + ";" + workflowName + ";0;0;NOROUTING\"/>");
                ArrayList<String> tranFromList = new ArrayList<String>();
                ArrayList<String> tranToList = new ArrayList<String>();
                String extendedAttrSql = "SELECT RULE_CODE, ACTIVITY_CODE__PREV, ACTIVITY_CODE FROM WF_DESIGN_ROUTE WHERE WF_DESIGN_ID = ? ORDER BY LINE_NO";
                pstmt = conn.prepareStatement(extendedAttrSql);
                pstmt.setString(1, wfDesignId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String transitionFrom = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE__PREV"));
                    tranFromList.add(transitionFrom);
                    String transitionTo = E12GenericUtility.checkNull((String)rs.getString("ACTIVITY_CODE"));
                    tranToList.add(transitionTo);
                }
                int i = 0;
                while (i < tranToList.size()) {
                    String tranTo = (String)tranToList.get(i);
                    if (!tranFromList.contains(tranTo)) {
                        extendedAttributeString.append("\n<ExtendedAttribute Name=\"EndOfWorkflow\" Value=\"" + initialPerformer + ";" + tranTo + ";0;0;NOROUTING\"/>");
                    }
                    ++i;
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                extendedAttributeString.append("\n<ExtendedAttribute Name=\"ParticipantVisualOrder\" Value=\"" + participantsList + "\"/>");
                extendedAttributeString.append("\n</ExtendedAttributes>");
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("extendedAttributeString : [" + extendedAttributeString + "]"));
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("Exception :: buildExtendedAttributes : [" + e.getMessage() + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return extendedAttributeString.toString();
    }

    private String createWrkflwXPDL(String filePath, String workflowNameFileName, String workflowXPDLData) throws Exception {
        try {
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)"In createWrkflwXPDL()");
            BaseLogger.log((String)"3", null, null, (Object)(" value of filePath [ " + filePath + "]"));
            BaseLogger.log((String)"3", null, null, (Object)(" value of workflowNameFileName [ " + workflowNameFileName + "]"));
            BaseLogger.log((String)"3", null, null, (Object)(" value of workflowXPDLData [ " + workflowXPDLData + "]"));
            new E12GenericUtility().writeFile(filePath, workflowNameFileName, workflowXPDLData);
            String result = String.valueOf(filePath) + File.separator + workflowNameFileName;
            return result;
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)(" createWrkflwXPDL Exception : [" + e.getMessage() + "]"));
            e.printStackTrace();
            throw e;
        }
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    private String getMailXML(String objName, String mailFormat) {
        return "<ROOT><EMAIL_TYPE></EMAIL_TYPE><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_ID>$REF_ID</REF_ID>" + "<REF_SER>$REF_SER</REF_SER>" + "<LINE_NO>1</LINE_NO>" + "<TRANS_INFO></TRANS_INFO>" + "<DOM_STR>$XML_DATA_ALL</DOM_STR>" + "<FORMAT_CODE>" + mailFormat + "</FORMAT_CODE>" + "<XML_DATA>$XML_DATA_ALL</XML_DATA>" + "<ENTITY_CODE>$PRFMR_CODE</ENTITY_CODE>" + "<LINK_ADDR></LINK_ADDR>" + "</ROOT>";
    }
}

