/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.bean.DateBean;
import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.GenaralProp;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLBuilder
implements Serializable {
    private Column[] columns;
    private String selectedValues = null;
    private ArrayList allElementNameList = null;
    private ArrayList grElementNameList = null;
    private ArrayList fxElementNameList = null;
    private ArrayList ctElementNameList = null;
    private ArrayList vlElementNameList = null;
    private ArrayList grElementList;
    private ArrayList fxElementList;
    private ArrayList ctElementList;
    private ArrayList vlElementList;
    private ArrayList grElementTypeList;
    private ArrayList fxElementTypeList;
    private ArrayList ctElementTypeList;
    private ArrayList vlElementTypeList;
    private GenaralProp genProp;
    private String baName;
    private int baID;
    private int noOfGroupColumns = 0;
    private int noOfFixedColumns = 0;
    private int noOfCrossTabColumns = 0;
    private int noOfValueColumns = 0;
    String sortOrder = "ascending";
    private ArrayList groupElements;
    private ArrayList columnElements;
    private ArrayList crossTabElements;
    private ArrayList valueElements;
    private ArrayList colNames;
    private ArrayList sortcols;
    private ArrayList sortId;
    private String xslGroupFileName;
    private String filteredGroupFileName;
    private String countStatus;
    private String target = null;

    public XSLBuilder() {
    }

    public XSLBuilder(String baName, int baID) throws Exception {
        try {
            this.baName = baName;
            this.baID = baID;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public XSLBuilder(Column[] columns, GenaralProp genProp, ArrayList colNames) throws Exception {
        try {
            BaseLogger.log("3", null, null, "XSLBuilder Constructed");
            this.genProp = genProp;
            this.columns = columns;
            this.colNames = colNames;
            int size = columns.length;
            int grCtr = 0;
            this.groupElements = new ArrayList();
            int clCtr = 0;
            this.columnElements = new ArrayList();
            int ctCtr = 0;
            this.crossTabElements = new ArrayList();
            int vaCtr = 0;
            this.valueElements = new ArrayList();
            int ctr = 0;
            while (ctr < size) {
                if (columns[ctr].getPlacement() == 1 && columns[ctr].isExists()) {
                    this.groupElements.add(columns[ctr]);
                    ++grCtr;
                } else if (columns[ctr].getPlacement() == 2 && columns[ctr].isExists()) {
                    this.columnElements.add(columns[ctr]);
                    ++clCtr;
                } else if (columns[ctr].getPlacement() == 3 && columns[ctr].isExists() && columns[ctr].isVisible()) {
                    this.crossTabElements.add(columns[ctr]);
                    ++ctCtr;
                } else if (columns[ctr].getPlacement() == 4 && columns[ctr].isExists()) {
                    this.valueElements.add(columns[ctr]);
                    ++vaCtr;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setAllElementNameList(ArrayList allColumnList) throws Exception {
        try {
            BaseLogger.log("3", null, null, "All Columns List(XSLBuilder): " + allColumnList);
            this.allElementNameList = new ArrayList(allColumnList);
            this.setGroupElementNameList((ArrayList)this.allElementNameList.get(0));
            this.setFixedElementNameList((ArrayList)this.allElementNameList.get(1));
            this.setCrossTabElementNameList((ArrayList)this.allElementNameList.get(2));
            this.setValueElementNameList((ArrayList)this.allElementNameList.get(3));
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setGroupElementNameList(ArrayList groupElementNameList) throws Exception {
        this.grElementNameList = new ArrayList(groupElementNameList);
    }

    private void setFixedElementNameList(ArrayList fixedElementNameList) throws Exception {
        this.fxElementNameList = new ArrayList(fixedElementNameList);
    }

    private void setCrossTabElementNameList(ArrayList crossTabElementNameList) throws Exception {
        this.ctElementNameList = new ArrayList(crossTabElementNameList);
    }

    private void setValueElementNameList(ArrayList valueElementNameList) throws Exception {
        this.vlElementNameList = new ArrayList(valueElementNameList);
    }

    public void setColumns(Column[] cols) throws Exception {
        try {
            this.columns = cols;
            int size = 0;
            size = this.columns.length;
            this.noOfGroupColumns = this.grElementNameList.size();
            this.grElementList = new ArrayList();
            this.grElementTypeList = new ArrayList();
            int ctr = 0;
            while (ctr < this.noOfGroupColumns) {
                this.grElementList.add(null);
                this.grElementTypeList.add(null);
                ++ctr;
            }
            this.noOfFixedColumns = this.fxElementNameList.size();
            this.fxElementList = new ArrayList();
            this.fxElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfFixedColumns) {
                this.fxElementList.add(null);
                this.fxElementTypeList.add(null);
                ++ctr;
            }
            this.noOfCrossTabColumns = this.ctElementNameList.size();
            this.ctElementList = new ArrayList();
            this.ctElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfCrossTabColumns) {
                this.ctElementList.add(null);
                this.ctElementTypeList.add(null);
                ++ctr;
            }
            this.noOfValueColumns = this.vlElementNameList.size();
            this.vlElementList = new ArrayList();
            this.vlElementTypeList = new ArrayList();
            ctr = 0;
            while (ctr < this.noOfValueColumns) {
                this.vlElementList.add(null);
                this.vlElementTypeList.add(null);
                ++ctr;
            }
            ctr = 0;
            while (ctr < size) {
                String type;
                if (this.columns[ctr].getPlacement() == 1 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.grElementList.set(this.grElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.grElementTypeList.set(this.grElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                } else if (this.columns[ctr].getPlacement() == 2 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.fxElementList.set(this.fxElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.fxElementTypeList.set(this.fxElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                } else if (this.columns[ctr].getPlacement() == 3 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.ctElementList.set(this.ctElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.ctElementTypeList.set(this.ctElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                } else if (this.columns[ctr].getPlacement() == 4 && this.columns[ctr].isExists()) {
                    type = this.columns[ctr].getDataType();
                    type = type.indexOf("NUMBER") != -1 || type.indexOf("Double") != -1 ? "NUMBER" : type;
                    this.vlElementList.set(this.vlElementNameList.indexOf(this.columns[ctr].getLogicalName()), this.columns[ctr]);
                    this.vlElementTypeList.set(this.vlElementNameList.indexOf(this.columns[ctr].getLogicalName()), type);
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setBAName(String baName) throws Exception {
        try {
            this.baName = baName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setBAId(int baID) throws Exception {
        try {
            this.baID = baID;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setSortCols(ArrayList sortcols, ArrayList sortId) throws Exception {
        this.sortcols = sortcols;
        this.sortId = sortId;
    }

    public void setOriginalProperties() throws Exception {
        try {
            Object obj;
            this.colNames = this.colNames;
            this.groupElements = new ArrayList();
            this.columnElements = new ArrayList();
            this.crossTabElements = new ArrayList();
            this.valueElements = new ArrayList();
            int ctr = 0;
            while (ctr < this.grElementList.size()) {
                if (this.grElementList.get(ctr).getClass().toString().indexOf("Column") != -1) {
                    this.groupElements.add(this.grElementList.get(ctr));
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < this.fxElementList.size()) {
                obj = this.fxElementList.get(ctr);
                if (obj != null && obj.getClass().toString().indexOf("Column") != -1) {
                    this.columnElements.add(this.fxElementList.get(ctr));
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < this.ctElementList.size()) {
                if (this.ctElementList.get(ctr).getClass().toString().indexOf("Column") != -1) {
                    this.crossTabElements.add(this.ctElementList.get(ctr));
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < this.vlElementList.size()) {
                obj = this.vlElementList.get(ctr);
                if (obj != null && obj.getClass().toString().indexOf("Column") != -1) {
                    this.valueElements.add(this.vlElementList.get(ctr));
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getXslForLocVar(HashMap locVariable, HashMap locOnChangedMap) throws Exception {
        StringBuffer xslStringBuffer = new StringBuffer();
        try {
            StringBuffer groupedOnStrBuff = new StringBuffer();
            StringBuffer keyStrBuff = new StringBuffer();
            StringBuffer forEachBuff = new StringBuffer();
            Iterator iterOnChgMap = locOnChangedMap.keySet().iterator();
            ArrayList<String> uniqueVarNameList = new ArrayList<String>();
            String groupedOnStr = "";
            int noOfVars = 0;
            while (iterOnChgMap.hasNext()) {
                ++noOfVars;
                String varName = (String)iterOnChgMap.next();
                ArrayList groupedOnList = (ArrayList)locOnChangedMap.get(varName);
                String varExpr = (String)locVariable.get(varName);
                int i = 0;
                while (i < groupedOnList.size()) {
                    groupedOnStrBuff.append(groupedOnList.get(i)).append(",");
                    ++i;
                }
                if (groupedOnList.size() > 0) {
                    groupedOnStr = groupedOnStrBuff.deleteCharAt(groupedOnStrBuff.length() - 1).toString();
                    groupedOnStrBuff.delete(0, groupedOnStrBuff.length());
                    if (uniqueVarNameList.contains(varName)) continue;
                    if (groupedOnStr.indexOf(",") != -1) {
                        keyStrBuff.append("<xsl:key name=\"" + varName + "\" match=\"//Data/Detail\" use=\"concat(" + groupedOnStr + ")\"/>\n");
                        forEachBuff.append("<xsl:for-each select=\"//Data/Detail[generate-id(.)=generate-id(key('" + varName + "',concat(" + groupedOnStr + ")) [1] )]\">\n");
                        forEachBuff.append("<xsl:variable name='v" + noOfVars + "' select='concat(" + groupedOnStr + ")'/>\n");
                    } else {
                        keyStrBuff.append("<xsl:key name=\"" + varName + "\" match=\"//Data/Detail\" use=\"" + groupedOnStr + "\"/>\n");
                        forEachBuff.append("<xsl:for-each select=\"//Data/Detail[generate-id(.)=generate-id(key('" + varName + "'," + groupedOnStr + ") [1] )]\">\n");
                        forEachBuff.append("<xsl:variable name='v" + noOfVars + "' select='" + groupedOnStr + "'/>\n");
                    }
                    Iterator tempIterOnChgMap = locOnChangedMap.keySet().iterator();
                    String tempGroupedOnStr = "";
                    while (tempIterOnChgMap.hasNext()) {
                        String tempVarName = (String)tempIterOnChgMap.next();
                        ArrayList tempGroupedOnList = (ArrayList)locOnChangedMap.get(tempVarName);
                        String tempVarExpr = (String)locVariable.get(tempVarName);
                        StringBuffer tempGroupedOnStrBuff = new StringBuffer();
                        int i2 = 0;
                        while (i2 < tempGroupedOnList.size()) {
                            tempGroupedOnStrBuff.append(tempGroupedOnList.get(i2)).append(",");
                            ++i2;
                        }
                        if (tempGroupedOnList.size() <= 0) continue;
                        tempGroupedOnStr = tempGroupedOnStrBuff.deleteCharAt(tempGroupedOnStrBuff.length() - 1).toString();
                        tempGroupedOnStrBuff.delete(0, tempGroupedOnStrBuff.length());
                        if (!tempGroupedOnStr.equalsIgnoreCase(groupedOnStr)) continue;
                        uniqueVarNameList.add(tempVarName);
                        forEachBuff.append("<" + tempVarName + " value=\"{concat($v" + noOfVars + ",'','')}\">\n");
                        forEachBuff.append("<xsl:value-of select=\"sum(//rows/Data/Detail[concat(" + groupedOnStr + ",'','')=concat($v" + noOfVars + ",'','')]/" + tempVarExpr + ")\"/>\n");
                        forEachBuff.append("</" + tempVarName + ">\n");
                    }
                    forEachBuff.append("</xsl:for-each>\n");
                    continue;
                }
                uniqueVarNameList.add(varName);
                forEachBuff.append("<xsl:for-each select='/rows/Data'>\n");
                forEachBuff.append("<" + varName + " value=\"{concat('','')}\">\n");
                forEachBuff.append("<xsl:value-of select=\"sum(Detail/" + varExpr + ")\"/>\n");
                forEachBuff.append("</" + varName + ">\n");
                forEachBuff.append("</xsl:for-each>\n");
            }
            xslStringBuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
            xslStringBuffer.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            xslStringBuffer.append("<xsl:output method=\"xml\" indent=\"yes\" cdata-section-elements=\"value\"/>\n");
            xslStringBuffer.append(keyStrBuff.toString());
            xslStringBuffer.append("<xsl:template match='/rows'>\n");
            xslStringBuffer.append("<rows xmlns:dt='urn:schemas-microsoft-com:datatypes'>\n");
            xslStringBuffer.append("<LOC_VARS>\n");
            xslStringBuffer.append(forEachBuff.toString());
            xslStringBuffer.append("</LOC_VARS>\n");
            xslStringBuffer.append("<xsl:copy-of select='*'/>\n");
            xslStringBuffer.append("</rows>\n");
            xslStringBuffer.append("</xsl:template>\n");
            xslStringBuffer.append("</xsl:stylesheet>\n");
            String locXslFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "LocXSL" + System.currentTimeMillis() + ".xsl";
            FileOutputStream fout = new FileOutputStream(locXslFileName);
            BaseLogger.log("3", null, null, "locXslFileName: " + locXslFileName);
            fout.write(xslStringBuffer.toString().getBytes());
            fout.close();
            return locXslFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getGroupXSL() throws Exception {
        String fileName = "";
        StringBuffer xslStringBuffer = new StringBuffer();
        String conditionToBeAdded = "";
        try {
            xslStringBuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
            xslStringBuffer.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            xslStringBuffer.append("<xsl:output method=\"xml\" indent=\"yes\" cdata-section-elements=\"value\"/>\n");
            StringBuffer groupColumnBuffer = new StringBuffer();
            char sepChar = '~';
            int noOfGroupElements = this.groupElements.size();
            int ctr = 0;
            while (ctr < noOfGroupElements) {
                if (ctr == noOfGroupElements - 1) {
                    groupColumnBuffer.append(String.valueOf(((Column)this.groupElements.get(ctr)).getLogicalName()) + ",'" + sepChar + "'");
                } else {
                    groupColumnBuffer.append(String.valueOf(((Column)this.groupElements.get(ctr)).getLogicalName()) + ",'" + sepChar + "',");
                }
                ++ctr;
            }
            if (noOfGroupElements == 1) {
                xslStringBuffer.append("<xsl:key name=\"grColumn\" match=\"//DocumentRoot/group0/Header0/Detail\" use=\"normalize-space(" + ((Column)this.groupElements.get(0)).getLogicalName() + ")\"/>\n");
            } else {
                xslStringBuffer.append("<xsl:key name=\"grColumn\" match=\"//DocumentRoot/group0/Header0/Detail\" use=\"normalize-space(concat(" + groupColumnBuffer.toString() + "))\"/>\n");
            }
            xslStringBuffer.append("<xsl:template match=\"/\">\n");
            if (noOfGroupElements > 0) {
                xslStringBuffer.append(this.getGroupsPart(conditionToBeAdded));
            }
            xslStringBuffer.append("</xsl:template></xsl:stylesheet>");
            String groupXslFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "GroupXSL" + System.currentTimeMillis() + ".xsl";
            FileOutputStream fout = new FileOutputStream(groupXslFileName);
            BaseLogger.log("3", null, null, "groupXslFileName: " + groupXslFileName);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
            bw.write(xslStringBuffer.toString());
            bw.close();
            return groupXslFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getFirstXSL(String xslCondition) throws Exception {
        DateBean dtbean = new DateBean();
        BaseLogger.log("2", null, null, "(XSLBuilder)XSL Condition :" + xslCondition);
        String fileName = "";
        StringBuffer xslStringBuffer = new StringBuffer();
        String conditionToBeAdded = "";
        try {
            xslStringBuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
            xslStringBuffer.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            xslStringBuffer.append("<xsl:output method=\"xml\" indent=\"yes\" cdata-section-elements=\"value\"/>\n");
            StringBuffer initialCondition = new StringBuffer();
            int noOfGroupElements = this.groupElements.size();
            String dbPattern = null;
            String disPattern = null;
            int ctr = 0;
            while (ctr < noOfGroupElements) {
                Column colObj = (Column)this.groupElements.get(ctr);
                dbPattern = colObj.getDBPattern();
                disPattern = colObj.getDisplayPattern();
                xslStringBuffer.append("<xsl:key name=\"" + ((Column)this.groupElements.get(ctr)).getLogicalName() + "\" match=\"//DocumentRoot/group0/Header0/Detail/" + ((Column)this.groupElements.get(ctr)).getLogicalName() + "\" use=\".\"/>\n");
                if (xslCondition == null) {
                    xslStringBuffer.append("<xsl:variable name=\"V" + ctr + "\" ><xsl:value-of select=\"normalize-space(//DocumentRoot/group0/Header0/Detail/" + ((Column)this.groupElements.get(ctr)).getLogicalName() + "[position()=1])\"/></xsl:variable>\n");
                    if (ctr == noOfGroupElements - 1) {
                        initialCondition.append("normalize-space(" + ((Column)this.groupElements.get(ctr)).getLogicalName() + ")=$V" + ctr);
                    } else {
                        initialCondition.append("normalize-space(" + ((Column)this.groupElements.get(ctr)).getLogicalName() + ")=$V" + ctr + " and ");
                    }
                }
                ++ctr;
            }
            if (noOfGroupElements > 0) {
                if (xslCondition == null) {
                    conditionToBeAdded = initialCondition.toString();
                } else {
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null")) {
                        int firstIndex = xslCondition.indexOf("'");
                        int lastIndex = xslCondition.lastIndexOf("'");
                        String groupValue = xslCondition.substring(firstIndex + 1, lastIndex);
                        groupValue = dtbean.convertPattern(disPattern, dbPattern, groupValue);
                        String beforeGRVal = xslCondition.substring(0, firstIndex + 1);
                        String afterGRVal = xslCondition.substring(lastIndex);
                        xslCondition = String.valueOf(beforeGRVal) + groupValue + afterGRVal;
                    }
                    conditionToBeAdded = xslCondition;
                }
            }
            StringBuffer ctColumnBuffer = new StringBuffer();
            char sepChar = '~';
            int noOfCrossTabElements = this.crossTabElements.size();
            int ctr2 = 0;
            while (ctr2 < noOfCrossTabElements) {
                if (ctr2 == noOfCrossTabElements - 1) {
                    ctColumnBuffer.append(String.valueOf(((Column)this.crossTabElements.get(ctr2)).getLogicalName()) + ",'" + sepChar + "'");
                } else {
                    ctColumnBuffer.append(String.valueOf(((Column)this.crossTabElements.get(ctr2)).getLogicalName()) + ",'" + sepChar + "',");
                }
                ++ctr2;
            }
            if (noOfCrossTabElements > 0) {
                if (noOfGroupElements > 0) {
                    xslStringBuffer.append("<xsl:key name=\"ctColumn\" match=\"//DocumentRoot/group0/Header0/Detail[" + conditionToBeAdded + "]\" use=\"concat(" + ctColumnBuffer.toString() + ")\"/>\n");
                } else {
                    xslStringBuffer.append("<xsl:key name=\"ctColumn\" match=\"//DocumentRoot/group0/Header0/Detail\" use=\"concat(" + ctColumnBuffer.toString() + ")\"/>\n");
                }
            }
            xslStringBuffer.append("<xsl:template match=\"/\">\n");
            xslStringBuffer.append("<rows xmlns:dt=\"urn:schemas-microsoft-com:datatypes\">\n");
            if (noOfCrossTabElements > 0) {
                xslStringBuffer.append("<CrossTab>\n");
                xslStringBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('ctColumn',concat(" + ctColumnBuffer.toString() + ")) [1] )]\">\n");
                if (noOfCrossTabElements > 1) {
                    this.crossTabElements = this.sortColumnElements(this.crossTabElements);
                }
                ctr2 = 0;
                while (ctr2 < noOfCrossTabElements) {
                    String type = ((Column)this.crossTabElements.get(ctr2)).getSortType();
                    String sortOrder = ((Column)this.crossTabElements.get(ctr2)).getSortOrder();
                    if (type == null || type.equals("") || type.equals("Default") || type.equalsIgnoreCase("Date")) {
                        String string = type = ((Column)this.crossTabElements.get(ctr2)).getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
                    }
                    if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("text")) {
                        xslStringBuffer.append("<xsl:sort select=\"" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "\" data-type=\"" + type + "\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Numeric")) {
                        xslStringBuffer.append("<xsl:sort select=\"" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Full Month")) {
                        xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('JANUARYFEBRUARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER',translate(normalize-space(" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "),'januaryfebruarymarchaprilmayjunejulyaugustseptemberoctobernovemberdecember','JANUARYFEBRUARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Full Day")) {
                        xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY',translate(normalize-space(" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "),'mondaytuesdaywednesdaythursdayfridaysaturdaysunday','MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Short Day")) {
                        xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONTUEWEDTHUFRISATSUN',translate(substring(" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + ",1,3),'montuewedthufrisatsun','MONTUEWEDTHUFRISATSUN')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Short Month")) {
                        xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC',translate(substring(" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + ",1,3),'janfebmaraprmayjunjulaugsepoctnovdec','JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
                    } else if (type.equalsIgnoreCase("Customized")) {
                        xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('" + ((Column)this.crossTabElements.get(ctr2)).getCustomString() + "'," + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "))\" data-type=\"number\" />\n");
                    }
                    ++ctr2;
                }
                xslStringBuffer.append("<value><xsl:value-of select=\"concat(" + ctColumnBuffer.toString() + ")\"/></value>\n");
                xslStringBuffer.append("</xsl:for-each>\n");
                xslStringBuffer.append("</CrossTab>\n");
            }
            xslStringBuffer.append("<Data>\n");
            xslStringBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail\">\n");
            int noOfColumnElements = this.columnElements.size();
            if (this.sortcols != null) {
                ArrayList orderList = new ArrayList(this.columnElements);
                int i = 0;
                while (i < this.sortcols.size()) {
                    int j = 0;
                    while (j < this.columnElements.size()) {
                        if (((Column)this.columnElements.get(j)).getLogicalName().equals(this.sortcols.get(i))) {
                            orderList.add(this.columnElements.get(j));
                        }
                        ++j;
                    }
                    ++i;
                }
                this.columnElements = orderList;
            }
            if (this.columnElements.size() > 1) {
                this.columnElements = this.sortColumnElements(this.columnElements);
            }
            int ctr3 = 0;
            while (ctr3 < noOfColumnElements) {
                this.sortOrder = ((Column)this.columnElements.get(ctr3)).getSortOrder();
                String type = ((Column)this.columnElements.get(ctr3)).getSortType();
                if (type == null || type.equals("") || type.equalsIgnoreCase("Default") || type.equalsIgnoreCase("Date")) {
                    String string = type = ((Column)this.columnElements.get(ctr3)).getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
                }
                if (type.equalsIgnoreCase("number") || type.equalsIgnoreCase("text")) {
                    xslStringBuffer.append("<xsl:sort select=\"" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + "\" data-type=\"" + type + "\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Numeric")) {
                    xslStringBuffer.append("<xsl:sort select=\"" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + "\" data-type=\"number\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Full Month")) {
                    xslStringBuffer.append("<xsl:sort  select=\"string-length(substring-before('JANUARYFEBRUARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER',translate(normalize-space(" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + "),'januaryfebruarymarchaprilmayjunejulyaugustseptemberoctobernovemberdecember','JANUARYFEBURARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER')))\" data-type=\"number\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Full Day")) {
                    xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY',translate(normalize-space(" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + "),'mondaytuesdaywednesdaythursdayfridaysaturdaysunday','MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY')))\" data-type=\"number\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Short Day")) {
                    xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONTUEWEDTHUFRISATSUN',translate(substring(" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + ",1,3),'montuewedthufrisatsun','MONTUEWEDTHUFRISATSUN')))\" data-type=\"number\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Short Month")) {
                    xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC',translate(substring(" + ((Column)this.columnElements.get(ctr3)).getLogicalName() + ",1,3),'janfebmaraprmayjunjulaugsepoctnovdec','JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC')))\" data-type=\"number\"  order=\"" + this.sortOrder + "\" />\n");
                } else if (type.equalsIgnoreCase("Customized")) {
                    xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('" + ((Column)this.columnElements.get(ctr3)).getCustomString() + "'," + ((Column)this.columnElements.get(ctr3)).getLogicalName() + "))\" data-type=\"number\"  />\n");
                }
                ++ctr3;
            }
            if (noOfGroupElements > 0) {
                xslStringBuffer.append("<xsl:if test=\"" + conditionToBeAdded + "\">\n");
            }
            xslStringBuffer.append("<xsl:copy-of select=\".\"/>\n");
            if (noOfGroupElements > 0) {
                xslStringBuffer.append("</xsl:if>\n");
            }
            xslStringBuffer.append("</xsl:for-each>\n");
            xslStringBuffer.append("</Data>\n");
            xslStringBuffer.append("<DESCRIPTION>" + this.countStatus + "</DESCRIPTION>");
            xslStringBuffer.append("</rows>\n");
            xslStringBuffer.append("</xsl:template>\n");
            xslStringBuffer.append("</xsl:stylesheet>\n");
            String absFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "FirstXSL" + Math.random() + ".xsl";
            String suffix = ".xsl";
            String prefix = "FirstXSL" + Math.random();
            File tempDirectory = new File(String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles");
            File tempFile = File.createTempFile(prefix, suffix, tempDirectory);
            absFileName = tempFile.getAbsolutePath();
            FileOutputStream fout = new FileOutputStream(absFileName);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
            bw.write(xslStringBuffer.toString());
            bw.flush();
            bw.close();
            fileName = absFileName;
        }
        catch (Exception e) {
            fileName = null;
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return fileName;
    }

    public ArrayList sortColumnElements(ArrayList unOrderedList) throws Exception {
        ArrayList<Column> newList = null;
        try {
            newList = new ArrayList<Column>();
            Column[] tempCol = new Column[unOrderedList.size()];
            int i = 0;
            while (i < unOrderedList.size()) {
                tempCol[i] = (Column)unOrderedList.get(i);
                ++i;
            }
            i = 0;
            while (i < tempCol.length) {
                int x = i;
                while (x < tempCol.length) {
                    if (tempCol[i].getSortPosition() > tempCol[x].getSortPosition()) {
                        Column temp = tempCol[i];
                        tempCol[i] = tempCol[x];
                        tempCol[x] = temp;
                    }
                    ++x;
                }
                ++i;
            }
            i = 0;
            while (i < tempCol.length) {
                newList.add(tempCol[i]);
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return newList;
    }

    private String getGroupsPart(String conditionToBeAdded) throws Exception {
        StringBuffer groupsPartBuffer = new StringBuffer();
        BaseLogger.log("3", null, null, "Group part conditionToBeAdded==>" + conditionToBeAdded);
        ArrayList groupFieldValues = new ArrayList();
        if (this.groupElements.size() > 0) {
            int noOfGroupElements;
            StringBuffer groupColumnBuffer = new StringBuffer();
            char sepChar = '~';
            int groupSize = noOfGroupElements = this.groupElements.size();
            StringBuffer displayNames = new StringBuffer();
            StringBuffer logicalNames = new StringBuffer();
            int ctr = 0;
            while (ctr < noOfGroupElements) {
                displayNames.append(String.valueOf(((Column)this.groupElements.get(ctr)).getDisplayName()) + "~");
                logicalNames.append(String.valueOf(((Column)this.groupElements.get(ctr)).getLogicalName()) + "~");
                if (ctr == noOfGroupElements - 1) {
                    groupColumnBuffer.append(String.valueOf(((Column)this.groupElements.get(ctr)).getLogicalName()) + ",'" + sepChar + "'");
                } else {
                    groupColumnBuffer.append(String.valueOf(((Column)this.groupElements.get(ctr)).getLogicalName()) + ",'" + sepChar + "',");
                }
                ++ctr;
            }
            displayNames.deleteCharAt(displayNames.length() - 1);
            logicalNames.deleteCharAt(logicalNames.length() - 1);
            groupsPartBuffer.append("<groups>");
            if (noOfGroupElements == 1) {
                groupsPartBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('grColumn',normalize-space(" + ((Column)this.groupElements.get(0)).getLogicalName() + " ))[1] )]\">\n");
            } else {
                groupsPartBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('grColumn',normalize-space(concat(" + groupColumnBuffer.toString() + "))) [1] )]\">\n");
            }
            String groupFields = "(";
            int ctr2 = 0;
            while (ctr2 < this.groupElements.size()) {
                groupFields = String.valueOf(groupFields) + ((Column)this.groupElements.get(ctr2)).getLogicalName() + ",'~',";
                ++ctr2;
            }
            groupFields = groupFields.substring(0, groupFields.length() - 5);
            groupFields = String.valueOf(groupFields) + "))\"/>";
            if (noOfGroupElements == 1) {
                groupsPartBuffer.append("<xsl:if test=\"position() = 1\">");
                groupsPartBuffer.append("<value selected=\"1\"><xsl:value-of select=\"normalize-space(" + ((Column)this.groupElements.get(0)).getLogicalName() + ")\"/>");
                groupsPartBuffer.append("</value>");
                groupsPartBuffer.append("</xsl:if>");
                groupsPartBuffer.append("<xsl:if test=\"position() != 1\">");
                groupsPartBuffer.append("<value selected=\"0\"><xsl:value-of select=\"normalize-space(" + ((Column)this.groupElements.get(0)).getLogicalName() + ")\"/>");
                groupsPartBuffer.append("</value>");
                groupsPartBuffer.append("</xsl:if>");
                groupsPartBuffer.append("</xsl:for-each>");
            } else {
                groupsPartBuffer.append("<xsl:if test=\"position() = 1\">");
                groupsPartBuffer.append("<value selected=\"1\"><xsl:value-of select=\"normalize-space(concat");
                groupsPartBuffer.append(groupFields);
                groupsPartBuffer.append("</value>");
                groupsPartBuffer.append("</xsl:if>");
                groupsPartBuffer.append("<xsl:if test=\"position() != 1\">");
                groupsPartBuffer.append("<value selected=\"0\"><xsl:value-of select=\"normalize-space(concat");
                groupsPartBuffer.append(groupFields);
                groupsPartBuffer.append("</value>");
                groupsPartBuffer.append("</xsl:if>");
                groupsPartBuffer.append("</xsl:for-each>");
            }
            groupsPartBuffer.append("<DisplayNames>" + displayNames.toString() + "</DisplayNames>");
            groupsPartBuffer.append("<LogicalNames>" + logicalNames.toString() + "</LogicalNames>");
            groupsPartBuffer.append("</groups>\n");
        }
        return groupsPartBuffer.toString();
    }

    private String getRowPart(String conditionToBeAdded, String fColumns) throws Exception {
        StringBuffer rowPartBuffer = new StringBuffer();
        if (this.crossTabElements.size() > 0) {
            if (conditionToBeAdded.length() > 0) {
                rowPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail[generate-id(.) = generate-id(key('fColumn',concat(" + fColumns + "))[1]) and " + conditionToBeAdded + "]\">\n");
            } else {
                rowPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail[generate-id(.) = generate-id(key('fColumn',concat(" + fColumns + "))[1]) " + conditionToBeAdded + "]\">\n");
            }
            int noOfColumnElements = this.columnElements.size();
            int ctr = 0;
            while (ctr < noOfColumnElements) {
                String type = ((Column)this.columnElements.get(ctr)).getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
                rowPartBuffer.append("<xsl:sort select=\"" + ((Column)this.columnElements.get(ctr)).getLogicalName() + "\" data-type=\"" + type + "\"/>\n");
                ++ctr;
            }
        } else if (conditionToBeAdded.length() > 0) {
            rowPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail[" + conditionToBeAdded + "]\">\n");
        } else {
            rowPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail\">\n");
        }
        rowPartBuffer.append("<row groupCondition=\"" + conditionToBeAdded + "\">\n");
        int ctr = 0;
        while (ctr < this.columnElements.size()) {
            rowPartBuffer.append("<value><xsl:value-of select=\"" + ((Column)this.columnElements.get(ctr)).getLogicalName() + "\"/></value>\n");
            ++ctr;
        }
        if (this.crossTabElements.size() > 0) {
            rowPartBuffer.append("<xsl:call-template name=\"EachColumnValue\">\n");
            rowPartBuffer.append("<xsl:with-param name=\"curRowID\" select=\"concat(" + fColumns + ")\"/>\n");
            rowPartBuffer.append("</xsl:call-template>\n");
        }
        rowPartBuffer.append("</row>\n");
        rowPartBuffer.append("</xsl:for-each>\n");
        return rowPartBuffer.toString();
    }

    public String getGraphXSL(String type, String[] xDim, String[] yyDim, String[] yDim, String conditionToBeAdded, Column[] columns) throws Exception {
        StringBuffer xslStringBuffer = new StringBuffer();
        try {
            int i;
            this.columns = columns;
            if (conditionToBeAdded.equals("")) {
                conditionToBeAdded = "1=1";
            }
            xslStringBuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
            xslStringBuffer.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
            xslStringBuffer.append("<xsl:output method=\"xml\" indent=\"yes\"/>\n");
            xslStringBuffer.append("<xsl:key name=\"" + xDim[0] + "\" match=\"rows/Data/Detail[" + conditionToBeAdded + "]\" use=\"" + xDim[0] + "\"/>\n");
            xslStringBuffer.append("<xsl:template match=\"/\">\n");
            xslStringBuffer.append("<GraphData><xsl:for-each select=\"rows/Data/Detail[generate-id(.) = generate-id(key('" + xDim[0] + "'," + xDim[0] + ") [1] )]\">");
            Column column = this.findColumn(xDim[0]);
            String sortOrder = column.getSortOrder();
            String sortType = column.getSortType();
            if (sortType == null || sortType.equals("") || sortType.equals("Default")) {
                String string = sortType = column.getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
            }
            if (sortType.equalsIgnoreCase("number") || sortType.equalsIgnoreCase("text")) {
                xslStringBuffer.append("<xsl:sort select=\"" + column.getLogicalName() + "\" data-type=\"" + sortType + "\"  order=\"" + sortOrder + "\" />\n");
            } else if (sortType.equalsIgnoreCase("Numeric")) {
                xslStringBuffer.append("<xsl:sort select=\"" + column.getLogicalName() + "\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
            } else if (sortType.equalsIgnoreCase("Full Month")) {
                xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('JANUARYFEBRUARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER',translate(normalize-space(" + column.getLogicalName() + "),'januaryfebruarymarchaprilmayjunejulyaugustseptemberoctobernovemberdecember','JANUARYFEBURARYMARCHAPRILMAYJUNEJULYAUGUSTSEPTEMBEROCTOBERNOVEMBERDECEMBER')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
            } else if (sortType.equalsIgnoreCase("Full Day")) {
                xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY',translate(normalize-space(" + column.getLogicalName() + "),'mondaytuesdaywednesdaythursdayfridaysaturdaysunday','MONDAYTUESDAYWEDNESDAYTHURSDAYFRIDAYSATURDAYSUNDAY')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
            } else if (sortType.equalsIgnoreCase("Short Day")) {
                xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('MONTUEWEDTHUFRISATSUN',translate(substring(" + column.getLogicalName() + ",1,3),'montuewedthufrisatsun','MONTUEWEDTHUFRISATSUN')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
            } else if (sortType.equalsIgnoreCase("Short Month")) {
                xslStringBuffer.append("<xsl:sort select=\"string-length(substring-before('JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC',translate(substring(" + column.getLogicalName() + ",1,3),'janfebmaraprmayjunjulaugsepoctnovdec','JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC')))\" data-type=\"number\"  order=\"" + sortOrder + "\" />\n");
            } else {
                sortType.equalsIgnoreCase("Date");
            }
            xslStringBuffer.append("<xsl:variable name=\"curXValue\">");
            xslStringBuffer.append("<xsl:value-of select=\"" + xDim[0] + "\"/>");
            xslStringBuffer.append("</xsl:variable>");
            xslStringBuffer.append("<xsl:variable name=\"occurence\" select=\"count(//rows/Data/Detail[" + conditionToBeAdded + " and " + xDim[0] + "=$curXValue])\"/>");
            xslStringBuffer.append("<" + xDim[0] + " occurence=\"{$occurence}\" value=\"{$curXValue}\">");
            if (yyDim != null && yyDim.length > 0) {
                xslStringBuffer.append(" <xsl:for-each select=\"//rows/Data/Detail\">");
                xslStringBuffer.append("<xsl:if test=\"" + xDim[0] + "=$curXValue\">");
                i = 0;
                while (i < yyDim.length) {
                    xslStringBuffer.append("<xsl:variable name=\"curYYValue" + i + "\" select=\"" + yyDim[i] + "\"/>");
                    ++i;
                }
                xslStringBuffer.append("<xsl:call-template name=\"GetYYValue\">");
                xslStringBuffer.append("<xsl:with-param name=\"curX\" select=\"$curXValue\"/>");
                i = 0;
                while (i < yyDim.length) {
                    xslStringBuffer.append("<xsl:with-param name=\"curID" + i + "\" select=\"$curYYValue" + i + "\"/>");
                    ++i;
                }
                xslStringBuffer.append("</xsl:call-template>");
                xslStringBuffer.append("</xsl:if></xsl:for-each>");
                xslStringBuffer.append("</" + xDim[0] + ">");
                xslStringBuffer.append("</xsl:for-each></GraphData></xsl:template>");
                xslStringBuffer.append("<xsl:template name=\"GetYYValue\"><xsl:param name=\"curX\"/>");
                i = 0;
                while (i < yyDim.length) {
                    xslStringBuffer.append("<xsl:param name=\"curID" + i + "\"/>");
                    ++i;
                }
                xslStringBuffer.append("<xsl:for-each select=\"//rows/Data\">");
                i = 0;
                while (i < yyDim.length) {
                    xslStringBuffer.append("<" + yyDim[i] + "__" + yDim[0] + " value=\"{$curID" + i + "}\">");
                    xslStringBuffer.append("<xsl:value-of select=\"sum(Detail[" + yyDim[i] + "=$curID" + i + " and " + xDim[0] + "=$curX]/" + yDim[0] + "[.!=''])\"/>");
                    xslStringBuffer.append("</" + yyDim[i] + "__" + yDim[0] + ">");
                    ++i;
                }
                xslStringBuffer.append("</xsl:for-each></xsl:template></xsl:stylesheet>");
            } else {
                xslStringBuffer.append("<xsl:call-template name=\"GetXValue\">");
                xslStringBuffer.append("<xsl:with-param name=\"curID\" select=\"$curXValue\"/>");
                xslStringBuffer.append("</xsl:call-template>");
                xslStringBuffer.append("</" + xDim[0] + ">");
                xslStringBuffer.append("</xsl:for-each>");
                xslStringBuffer.append("</GraphData>");
                xslStringBuffer.append("</xsl:template>");
                xslStringBuffer.append("<xsl:template name=\"GetXValue\">");
                xslStringBuffer.append("<xsl:param name=\"curID\"/>");
                xslStringBuffer.append("<xsl:for-each select=\"//rows/Data\">");
                if (yDim != null && yDim.length > 0) {
                    i = 0;
                    while (i < yDim.length) {
                        BaseLogger.log("3", null, null, "THE XDIM IS -->" + xDim[0]);
                        BaseLogger.log("3", null, null, "The YDIM IS -->" + yDim[i]);
                        xslStringBuffer.append("<" + yDim[i] + ">");
                        xslStringBuffer.append("<xsl:value-of select=\"sum(Detail[" + conditionToBeAdded + " and " + xDim[0] + "=$curID]/" + yDim[i] + "[.!=''])\"/>");
                        xslStringBuffer.append("</" + yDim[i] + ">");
                        ++i;
                    }
                }
                xslStringBuffer.append("</xsl:for-each></xsl:template></xsl:stylesheet>");
            }
            String absFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "Graph_" + Math.random() + ".xsl";
            FileWriter fw = new FileWriter(absFileName);
            fw.write(xslStringBuffer.toString());
            fw.flush();
            fw.close();
            BaseLogger.log("3", null, null, "xsl file writen");
            return absFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private int getFrozenColumns() throws Exception {
        int colCount = 0;
        int crosstab = 0;
        int value = 0;
        int frozen = 0;
        int i = 0;
        while (i < this.columns.length) {
            int placement = this.columns[i].getPlacement();
            if (placement == 2) {
                ++colCount;
            } else if (placement == 3) {
                ++crosstab;
            } else if (placement == 4) {
                ++value;
            }
            ++i;
        }
        frozen = colCount == 0 ? 0 : (crosstab + value == 0 ? 0 : (crosstab + value > 0 ? colCount : 0));
        return Math.abs(frozen);
    }

    private String getXSL(String xslCondition, String colName, String title, String fun) throws Exception {
        int ctr;
        StringBuffer xslStringBuffer = new StringBuffer();
        String conditionToBeAdded = "";
        xslStringBuffer.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
        xslStringBuffer.append("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
        xslStringBuffer.append("<xsl:output method=\"xml\" indent=\"yes\"/>\n");
        StringBuffer initialCondition = new StringBuffer();
        int noOfGroupElements = this.groupElements.size();
        int ctr2 = 0;
        while (ctr2 < noOfGroupElements) {
            xslStringBuffer.append("<xsl:key name=\"" + ((Column)this.groupElements.get(ctr2)).getLogicalName() + "\" match=\"DocumentRoot/group0/Header0/Detail/" + this.columns[ctr2].getLogicalName() + "\" use=\".\"/>\n");
            if (xslCondition == null) {
                xslStringBuffer.append("<xsl:variable name=\"V" + ctr2 + "\" ><xsl:value-of select=\"DocumentRoot/group0/Header0/Detail/" + this.columns[ctr2].getLogicalName() + "[position()=1]\"/></xsl:variable>\n");
                if (ctr2 == noOfGroupElements - 1) {
                    initialCondition.append(String.valueOf(((Column)this.groupElements.get(ctr2)).getLogicalName()) + "=$V" + ctr2);
                } else {
                    initialCondition.append(String.valueOf(((Column)this.groupElements.get(ctr2)).getLogicalName()) + "=$V" + ctr2 + " and ");
                }
            }
            ++ctr2;
        }
        StringBuffer fColumnBuffer = new StringBuffer();
        StringBuffer ctColumnBuffer = new StringBuffer();
        int noOfColumnElements = this.columnElements.size();
        int noOfCrossTabElements = this.crossTabElements.size();
        if (noOfGroupElements > 0) {
            conditionToBeAdded = xslCondition == null ? initialCondition.toString() : xslCondition;
        }
        BaseLogger.log("3", null, null, "Get XSL XSLCondition===>" + xslCondition);
        BaseLogger.log("3", null, null, "Get XSL conditionToBeAdded===>" + conditionToBeAdded);
        if (noOfCrossTabElements > 0 && noOfColumnElements > 0) {
            ctr = 0;
            while (ctr < noOfColumnElements) {
                if (ctr == noOfColumnElements - 1) {
                    fColumnBuffer.append(String.valueOf(((Column)this.columnElements.get(ctr)).getLogicalName()) + ",'~'");
                } else {
                    fColumnBuffer.append(String.valueOf(((Column)this.columnElements.get(ctr)).getLogicalName()) + ",'~',");
                }
                ++ctr;
            }
            xslStringBuffer.append("<xsl:key name=\"fColumn\" match=\"DocumentRoot/group0/Header0/Detail\" use=\"concat(" + fColumnBuffer.toString() + ")\"/>\n");
            ctr = 0;
            while (ctr < noOfCrossTabElements) {
                if (ctr == noOfCrossTabElements - 1) {
                    ctColumnBuffer.append(String.valueOf(((Column)this.crossTabElements.get(ctr)).getLogicalName()) + ",'~'");
                } else {
                    ctColumnBuffer.append(String.valueOf(((Column)this.crossTabElements.get(ctr)).getLogicalName()) + ",'~',");
                }
                ++ctr;
            }
            xslStringBuffer.append("<xsl:key name=\"ctColumn\" match=\"DocumentRoot/group0/Header0/Detail\" use=\"concat(" + ctColumnBuffer.toString() + ")\"/>\n");
        }
        xslStringBuffer.append("<xsl:template match=\"/\">\n");
        xslStringBuffer.append("<rows xmlns:dt=\"urn:schemas-microsoft-com:datatypes\">\n");
        if (noOfGroupElements > 0) {
            xslStringBuffer.append(this.getGroupsPart(conditionToBeAdded));
        }
        xslStringBuffer.append(this.getColDefPart(conditionToBeAdded, ctColumnBuffer.toString(), colName, title, fun));
        xslStringBuffer.append(this.getRowPart(conditionToBeAdded, fColumnBuffer.toString()));
        xslStringBuffer.append("<properties><![CDATA[" + this.genProp.toString() + "]]></properties>\n");
        xslStringBuffer.append("<displayoptions>" + this.genProp.getDisplayOpt() + "</displayoptions>\n");
        xslStringBuffer.append("<numericformat>" + this.genProp.getUnits() + "</numericformat>\n");
        xslStringBuffer.append("<anumericformat>" + this.genProp.getANumericFormat() + "</anumericformat>\n");
        xslStringBuffer.append("<dateformat>" + this.genProp.getDateFormat() + "</dateformat>\n");
        xslStringBuffer.append("<frozencolumns>" + this.getFrozenColumns() + "</frozencolumns>\n");
        xslStringBuffer.append("<NO_OF_GROUP_COLUMNS>" + this.groupElements.size() + "</NO_OF_GROUP_COLUMNS>\n");
        xslStringBuffer.append("<NO_OF_FIXED_COLUMNS>" + this.columnElements.size() + "</NO_OF_FIXED_COLUMNS>\n");
        xslStringBuffer.append("<NO_OF_CROSSTAB_COLUMNS>" + this.crossTabElements.size() + "</NO_OF_CROSSTAB_COLUMNS>\n");
        xslStringBuffer.append("<NO_OF_VALUE_COLUMNS>" + this.valueElements.size() + "</NO_OF_VALUE_COLUMNS>\n");
        xslStringBuffer.append("</rows>\n");
        xslStringBuffer.append("</xsl:template>\n");
        if (noOfCrossTabElements > 0) {
            xslStringBuffer.append("<xsl:template name=\"EachColumnValue\">\n");
            xslStringBuffer.append("<xsl:param name=\"curRowID\"/>\n");
            if (conditionToBeAdded.length() > 0) {
                xslStringBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('ctColumn',concat(" + ctColumnBuffer.toString() + ")) [1] ) and " + conditionToBeAdded + "]\">\n");
            } else {
                xslStringBuffer.append("<xsl:for-each select=\"//DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('ctColumn',concat(" + ctColumnBuffer.toString() + ")) [1] )" + conditionToBeAdded + "]\">\n");
            }
            ctr = 0;
            while (ctr < noOfCrossTabElements) {
                String type = ((Column)this.crossTabElements.get(ctr)).getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
                xslStringBuffer.append("<xsl:sort select=\"" + ((Column)this.crossTabElements.get(ctr)).getLogicalName() + "\" data-type=\"" + type + "\"/>\n");
                ++ctr;
            }
            xslStringBuffer.append("<xsl:call-template name=\"printValues\">\n");
            xslStringBuffer.append("<xsl:with-param name=\"rowID\" select=\"$curRowID\"/>\n");
            xslStringBuffer.append("<xsl:with-param name=\"colID\" select=\"concat(" + ctColumnBuffer.toString() + ")\"/>\n");
            xslStringBuffer.append("</xsl:call-template>\n");
            xslStringBuffer.append("</xsl:for-each>\n");
            xslStringBuffer.append("</xsl:template>\n");
            xslStringBuffer.append("<xsl:template name=\"printValues\">\n");
            xslStringBuffer.append("<xsl:param name=\"rowID\"/>\n");
            xslStringBuffer.append("<xsl:param name=\"colID\"/>\n");
            int noOfValueElements = this.valueElements.size();
            int ctr3 = 0;
            while (ctr3 < noOfValueElements) {
                xslStringBuffer.append("<value>");
                if (conditionToBeAdded.length() > 0) {
                    xslStringBuffer.append("<xsl:value-of select = \"sum(//DocumentRoot/group0/Header0/Detail[concat(" + fColumnBuffer.toString() + ")=$rowID and concat(" + ctColumnBuffer.toString() + ")=$colID and " + conditionToBeAdded + "]/" + ((Column)this.valueElements.get(ctr3)).getLogicalName() + ")\"/>");
                } else {
                    xslStringBuffer.append("<xsl:value-of select = \"sum(//DocumentRoot/group0/Header0/Detail[concat(" + fColumnBuffer.toString() + ")=$rowID and concat(" + ctColumnBuffer.toString() + ")=$colID" + conditionToBeAdded + "]/" + ((Column)this.valueElements.get(ctr3)).getLogicalName() + ")\"/>");
                }
                xslStringBuffer.append("</value>\n");
                ++ctr3;
            }
            xslStringBuffer.append("</xsl:template>\n");
        }
        xslStringBuffer.append("</xsl:stylesheet>\n");
        String absFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "FirstXSL" + Math.random() + ".xsl";
        FileWriter fw = new FileWriter(absFileName);
        fw.write(xslStringBuffer.toString());
        fw.flush();
        fw.close();
        BaseLogger.log("3", null, null, "xsl file writen");
        return absFileName;
    }

    private String getColDefPart(String conditionToBeAdded, String ctColumns, String colName, String title, String fun) throws Exception {
        StringBuffer colDefPartBuffer = new StringBuffer();
        colDefPartBuffer.append("<coldef>\n");
        int noOfColumnElements = this.columnElements.size();
        int ctr = 0;
        while (ctr < noOfColumnElements) {
            colDefPartBuffer.append("<column>\n");
            colDefPartBuffer.append("<heading>" + ((Column)this.columnElements.get(ctr)).getDisplayName() + "</heading>\n");
            colDefPartBuffer.append("<type>" + ((Column)this.columnElements.get(ctr)).getDataType() + "</type>\n");
            colDefPartBuffer.append("<format>" + ((Column)this.columnElements.get(ctr)).getUnits() + "</format>\n");
            colDefPartBuffer.append("<fontfamily>" + ((Column)this.columnElements.get(ctr)).getFont() + "</fontfamily>\n");
            colDefPartBuffer.append("<fontsize>" + ((Column)this.columnElements.get(ctr)).getFontSize() + "</fontsize>\n");
            colDefPartBuffer.append("<width>" + ((Column)this.columnElements.get(ctr)).getWidth() + "</width>\n");
            colDefPartBuffer.append("<bold>" + ((Column)this.columnElements.get(ctr)).getBold() + "</bold>\n");
            colDefPartBuffer.append("<italic>" + ((Column)this.columnElements.get(ctr)).getItalic() + "</italic>\n");
            colDefPartBuffer.append("<underline>" + ((Column)this.columnElements.get(ctr)).getUnderline() + "</underline>\n");
            colDefPartBuffer.append("<align>" + ((Column)this.columnElements.get(ctr)).getAlignment() + "</align>\n");
            colDefPartBuffer.append("<fgcolor>" + ((Column)this.columnElements.get(ctr)).getFGColor() + "</fgcolor>\n");
            colDefPartBuffer.append("<bgcolor>" + ((Column)this.columnElements.get(ctr)).getBGColor() + "</bgcolor>\n");
            colDefPartBuffer.append("<logicalname>" + ((Column)this.columnElements.get(ctr)).getLogicalName() + "</logicalname>\n");
            colDefPartBuffer.append("<capitalize>" + ((Column)this.columnElements.get(ctr)).isCaps() + "</capitalize>\n");
            colDefPartBuffer.append("<placement>" + ((Column)this.columnElements.get(ctr)).getPlacement() + "</placement>\n");
            if (((Column)this.columnElements.get(ctr)).getDisplayName().equals(colName) && ((Column)this.columnElements.get(ctr)).getDataType().equalsIgnoreCase("number")) {
                if (fun.equals("Sum")) {
                    colDefPartBuffer.append("<lastrow>");
                    colDefPartBuffer.append("Total:<xsl:value-of select=\"sum(//group0/Header0/Detail/" + ((Column)this.columnElements.get(ctr)).getLogicalName() + ")\"/>");
                    colDefPartBuffer.append("</lastrow>");
                } else if (fun.equals("Avg")) {
                    colDefPartBuffer.append("<lastrow>");
                    colDefPartBuffer.append("Avg:<xsl:value-of select=\"sum(//group0/Header0/Detail/" + ((Column)this.columnElements.get(ctr)).getLogicalName() + ") div count(//group0/Header0/Detail/" + ((Column)this.columnElements.get(ctr)).getLogicalName() + ")\"/>");
                    colDefPartBuffer.append("</lastrow>");
                }
            }
            colDefPartBuffer.append("</column>\n");
            ++ctr;
        }
        if (this.crossTabElements.size() > 0) {
            if (conditionToBeAdded.length() > 0) {
                colDefPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('ctColumn',concat(" + ctColumns + ")) [1] ) and " + conditionToBeAdded + "]\">\n");
            } else {
                colDefPartBuffer.append("<xsl:for-each select=\"DocumentRoot/group0/Header0/Detail[generate-id(.)=generate-id(key('ctColumn',concat(" + ctColumns + ")) [1] )" + conditionToBeAdded + "]\">\n");
            }
            int noOfCrossTabElements = this.crossTabElements.size();
            int ctr2 = 0;
            while (ctr2 < noOfCrossTabElements) {
                String type = ((Column)this.crossTabElements.get(ctr2)).getDataType().equalsIgnoreCase("NUMBER") ? "number" : "text";
                colDefPartBuffer.append("<xsl:sort select=\"" + ((Column)this.crossTabElements.get(ctr2)).getLogicalName() + "\" data-type=\"" + type + "\"/>\n");
                ++ctr2;
            }
            int noOfValueElements = this.valueElements.size();
            int ctr3 = 0;
            while (ctr3 < noOfValueElements) {
                colDefPartBuffer.append("<column>\n");
                colDefPartBuffer.append("<heading><xsl:value-of select=\"concat(" + ctColumns + ",'" + ((Column)this.valueElements.get(ctr3)).getDisplayName() + "')\"/></heading>\n");
                colDefPartBuffer.append("<type>" + ((Column)this.valueElements.get(ctr3)).getDataType() + "</type>\n");
                colDefPartBuffer.append("<format>" + ((Column)this.valueElements.get(ctr3)).getUnits() + "</format>\n");
                colDefPartBuffer.append("<fontfamily>" + ((Column)this.valueElements.get(ctr3)).getFont() + "</fontfamily>\n");
                colDefPartBuffer.append("<fontsize>" + ((Column)this.valueElements.get(ctr3)).getFontSize() + "</fontsize>\n");
                colDefPartBuffer.append("<width>" + ((Column)this.valueElements.get(ctr3)).getWidth() + "</width>\n");
                colDefPartBuffer.append("<bold>" + ((Column)this.valueElements.get(ctr3)).getBold() + "</bold>\n");
                colDefPartBuffer.append("<italic>" + ((Column)this.valueElements.get(ctr3)).getItalic() + "</italic>\n");
                colDefPartBuffer.append("<underline>" + ((Column)this.valueElements.get(ctr3)).getUnderline() + "</underline>\n");
                colDefPartBuffer.append("<align>" + ((Column)this.valueElements.get(ctr3)).getAlignment() + "</align>\n");
                colDefPartBuffer.append("<fgcolor>" + ((Column)this.valueElements.get(ctr3)).getFGColor() + "</fgcolor>\n");
                colDefPartBuffer.append("<bgcolor>" + ((Column)this.valueElements.get(ctr3)).getBGColor() + "</bgcolor>\n");
                colDefPartBuffer.append("<logicalname>" + ((Column)this.valueElements.get(ctr3)).getLogicalName() + "</logicalname>\n");
                colDefPartBuffer.append("<capitalize>" + ((Column)this.valueElements.get(ctr3)).isCaps() + "</capitalize>\n");
                colDefPartBuffer.append("<placement>" + ((Column)this.valueElements.get(ctr3)).getPlacement() + "</placement>\n");
                colDefPartBuffer.append("</column>\n");
                ++ctr3;
            }
            colDefPartBuffer.append("</xsl:for-each>\n");
        }
        colDefPartBuffer.append("</coldef>\n");
        return colDefPartBuffer.toString();
    }

    public String setGroupParseDom(String xmlFile, boolean isHeader, String isExcel, boolean isStatic, String biFileName, String output) throws Exception {
        String xslGroupText = "";
        String grpValues = "-";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            NodeList nlGroupColumns = doc.getElementsByTagName("NO_OF_GROUP_COLUMNS");
            NodeList nlGroupColumns1 = doc.getElementsByTagName("properties");
            String outputValue = output;
            String groupColumnsString = nlGroupColumns.item(0).getFirstChild().getNodeValue().trim();
            int noOfGroupElements = Integer.parseInt(groupColumnsString);
            this.setGroupFileName();
            NodeList nlGroups = doc.getElementsByTagName("groups");
            Node ndGroups = nlGroups.item(0);
            xslGroupText = String.valueOf(xslGroupText) + "<form name='grpForm' method='post' action='../../jsp/collectquery.jsp' target='" + this.getFormattedTargetName(biFileName) + "'>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='dragConditon' value='ingoButton'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='counter' value='" + noOfGroupElements + "'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='qCount' value='qCountValue'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='outputType' value='outputTypeValue'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='fileName' value='fileNameValue'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='isHeader' value='" + isHeader + "'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='isExcel' value='" + isExcel + "'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='biFileName' value='" + biFileName + "'/>";
            xslGroupText = String.valueOf(xslGroupText) + "<input type='hidden' name='customXslFName' id='customXslFName' value=''/>";
            xslGroupText = String.valueOf(xslGroupText) + "<div id='btnDiv' style='position:absolute;top=0%;left=0%;'>";
            xslGroupText = String.valueOf(xslGroupText) + "<span id='btnSpan'>";
            if (!isStatic) {
                xslGroupText = String.valueOf(xslGroupText) + "<table name='Top' style='border-collapse: collapse;margin-left:1%;' border='0' cellpadding='1%' cellspacing='1%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<tr name='row1' width='0%' height='25%' align='left'>";
                xslGroupText = String.valueOf(xslGroupText) + "<td id='OutputTD' height='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<img  src='../../images/format.jpg' style='cursor=hand;' alt='Output Type' width='20' height='20' onclick=\" divoutputtype.style.display=(divoutputtype.style.display==''? 'none':'');\"/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "<td id='NewTD' height='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<img  src='../../images/Reset.gif' style='cursor=hand;' alt='New' name='btnNew' onclick=\" parent.createNew('" + this.baID + "','" + this.baName + "'); \"/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "<td id='saveTD' height='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<img  src='../../images/Save.gif' style='cursor=hand;' alt='Save Report' name='btnSave' onclick=\" parent.actionE('htmlSave');  \"/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "<td id='dataSourceTD' height='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<img  src='../../images/dataSource.gif' style='cursor=hand;' alt='DataSource' name='btnDataSource' onclick=\" parent.actionE('datasource'); \"/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "<td id='emailTD' height='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<img  src='../../images/Email.gif' style='cursor=hand;' alt='Email Report' name='btnEmail' onclick=\" parent.actionE('email');  \"/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "</tr>";
                xslGroupText = String.valueOf(xslGroupText) + "</table>";
            }
            if (ndGroups != null) {
                String grpDispNameAttr;
                String grpNameAttr;
                Node ndGroup;
                NodeList nlGroup = ndGroups.getChildNodes();
                String groupDisplayNames = "";
                String groupLogicalNames = "";
                int ig = 0;
                while (ig < nlGroup.getLength()) {
                    ndGroup = nlGroup.item(ig);
                    grpNameAttr = ndGroup.getAttributes().getNamedItem("name").getNodeValue();
                    grpDispNameAttr = ndGroup.getAttributes().getNamedItem("disName").getNodeValue();
                    if (ig == nlGroup.getLength() - 1) {
                        groupDisplayNames = String.valueOf(groupDisplayNames) + grpDispNameAttr;
                        groupLogicalNames = String.valueOf(groupLogicalNames) + grpNameAttr;
                    } else {
                        groupDisplayNames = String.valueOf(groupDisplayNames) + grpDispNameAttr + "~";
                        groupLogicalNames = String.valueOf(groupLogicalNames) + grpNameAttr + "~";
                    }
                    ++ig;
                }
                xslGroupText = String.valueOf(xslGroupText) + "<script>";
                xslGroupText = String.valueOf(xslGroupText) + " var displayNames=\"" + groupDisplayNames + "\";";
                xslGroupText = String.valueOf(xslGroupText) + " var logicalNames=\"" + groupLogicalNames + "\";";
                xslGroupText = String.valueOf(xslGroupText) + "</script>";
                xslGroupText = String.valueOf(xslGroupText) + "<table id='grpElementTable' style='vertical-align:top;width=0%;border-collapse: collapse;margin-left:15%;' border='0' cellpadding='1%' cellspacing='1%' align='left'>";
                xslGroupText = String.valueOf(xslGroupText) + "<tr name='grpElements' width='100%'>";
                xslGroupText = String.valueOf(xslGroupText) + "<td>";
                ig = 0;
                while (ig < nlGroup.getLength()) {
                    ndGroup = nlGroup.item(ig);
                    grpNameAttr = ndGroup.getAttributes().getNamedItem("name").getNodeValue();
                    grpDispNameAttr = ndGroup.getAttributes().getNamedItem("disName").getNodeValue();
                    NodeList nlValues = ndGroup.getChildNodes();
                    xslGroupText = String.valueOf(xslGroupText) + "<Select name=\"GROUP_FIELDS" + (ig + 1) + "\" onChange=\"callServlet(this.name,grpForm.qCount.value)\">";
                    xslGroupText = String.valueOf(xslGroupText) + "<option value=\"'1=1'\">All " + grpDispNameAttr + "</option>";
                    int iv = 1;
                    while (iv < nlValues.getLength()) {
                        Node ndValues = nlValues.item(iv);
                        String valSelectedAttr = ndValues.getAttributes().getNamedItem("selected").getNodeValue();
                        grpValues = nlValues.item(iv).getFirstChild().getNodeValue();
                        grpValues = this.getReplacedString(grpValues);
                        xslGroupText = valSelectedAttr.equals("1") ? String.valueOf(xslGroupText) + "<option value=\"normalize-space(" + grpNameAttr + ")=normalize-space('" + grpValues + "')\" SELECTED='1'>" + grpValues + "</option>" : String.valueOf(xslGroupText) + "<option value=\"normalize-space(" + grpNameAttr + ")=normalize-space('" + grpValues + "')\">" + grpValues + "</option>";
                        ++iv;
                    }
                    xslGroupText = String.valueOf(xslGroupText) + "</Select>";
                    ++ig;
                }
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "<td>";
                xslGroupText = String.valueOf(xslGroupText) + "<input type='submit' name='btnSubmit' value='Go' style='width=30;color=black;cursor=hand;' onClick='setAction()'/>";
                xslGroupText = String.valueOf(xslGroupText) + "</td>";
                xslGroupText = String.valueOf(xslGroupText) + "</tr>";
                xslGroupText = String.valueOf(xslGroupText) + "</table>";
            }
            xslGroupText = String.valueOf(xslGroupText) + "</span>";
            xslGroupText = String.valueOf(xslGroupText) + "</div>";
            xslGroupText = String.valueOf(xslGroupText) + "<div id='divoutputtype' style='position:absolute;left=5px;top=10px;width:100px;height=100px;overflow:auto;background:white;border:1 outset silver;display:none;'>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"ITM BI\");divoutputtype.style.display=\"none\";'><nobr>Insight</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"Excel\");divoutputtype.style.display=\"none\";'><nobr>Spreadsheet</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"ExcelFitWidth\");divoutputtype.style.display=\"none\";'><nobr>SpreadsheetFitWidth</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"Word\");divoutputtype.style.display=\"none\";'><nobr>Word Processor</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"Acrobat PDF\");divoutputtype.style.display=\"none\";'><nobr>Acrobat PDF</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"HTML\");divoutputtype.style.display=\"none\";'><nobr>HTML</nobr></span>";
            xslGroupText = String.valueOf(xslGroupText) + "<span style='width:100%;font-family=arial,verdana,helvetica,sans-serif;font-size=8pt;' onmouseover='this.style.color=\"white\";this.style.background=\"highlight\";this.style.cursor=\"hand\";' onmouseout='this.style.color=\"black\";this.style.background=\"white\";' class='p' onclick='parent.showOutputType(\"Graph\");divoutputtype.style.display=\"none\";'><nobr>Graph</nobr></span></div>";
            xslGroupText = String.valueOf(xslGroupText) + "</form>";
            xslGroupText = String.valueOf(xslGroupText) + "<script language='Javascript'>";
            xslGroupText = String.valueOf(xslGroupText) + "if(document.all['grpElementTable'] == undefined ){";
            xslGroupText = String.valueOf(xslGroupText) + "parent.setframevalue('10%,*');}";
            xslGroupText = String.valueOf(xslGroupText) + "</script>";
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return xslGroupText;
    }

    private String getReplacedString(String initialString) throws Exception {
        long start = 0L;
        String finalString = null;
        try {
            StringBuffer initialStringBuff = new StringBuffer(initialString);
            char[] symbolsArray = new char[]{'&', '\"', '\'', '\ufffd', '\ufffd', '\ufffd', '\ufffd'};
            String[] entityArray = new String[]{"&amp;", "&quot;", "&#x2018;;", "&euro;", "&pound;", "&sup3;", "&sup2;"};
            start = System.currentTimeMillis();
            int arrInd = 0;
            while (arrInd < symbolsArray.length) {
                char ch = symbolsArray[arrInd];
                int startIndex = 0;
                while (initialStringBuff.toString().indexOf(ch, startIndex) != -1) {
                    startIndex = initialStringBuff.toString().indexOf(ch, startIndex);
                    initialStringBuff.replace(startIndex, startIndex + 1, entityArray[arrInd]);
                    ++startIndex;
                }
                ++arrInd;
            }
            finalString = initialStringBuff.toString();
        }
        catch (Exception e) {
            finalString = null;
            throw e;
        }
        return finalString;
    }

    private void setGroupFileName() throws Exception {
        String xslGroupFileName;
        this.xslGroupFileName = xslGroupFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "Groups" + Math.random() + ".xsl";
    }

    public String getGroupFileName() throws Exception {
        try {
            return this.xslGroupFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void getHTMLGroup(String xslCondition, String xslGroupText) throws Exception {
        try {
            StringBuffer xslTextGroupAdded = new StringBuffer();
            String conditionToBeAdded = "";
            xslTextGroupAdded.append(this.getHTMLFormat(conditionToBeAdded));
            xslTextGroupAdded.append("<script language='Javascript'>");
            xslTextGroupAdded.append("var count = 0;");
            xslTextGroupAdded.append("function load() {");
            xslTextGroupAdded.append("\tif(!parent.isServerFile) {");
            xslTextGroupAdded.append("\t\tdocument.getElementById('customXslFName').value=parent.customXslFName;");
            xslTextGroupAdded.append("\t\tgrpForm.action='../../jsp/loadFile.jsp';");
            xslTextGroupAdded.append("\t\tgrpForm.submit();");
            xslTextGroupAdded.append("\t}");
            xslTextGroupAdded.append("\telse {");
            xslTextGroupAdded.append("\tparent.table.document.write(parent.serverFileMessage);");
            xslTextGroupAdded.append("\tdocument.all['saveTD'].style.visibility='hidden';");
            xslTextGroupAdded.append("\tdocument.all['emailTD'].style.visibility='hidden';");
            xslTextGroupAdded.append("\t}");
            xslTextGroupAdded.append("}");
            xslTextGroupAdded.append("function setAction(){count++;grpForm.action='../../jsp/collectquery.jsp?count='+count;} ");
            xslTextGroupAdded.append("</script>");
            xslTextGroupAdded.append("<body onLoad = 'load()'>");
            xslTextGroupAdded.append(xslGroupText);
            xslTextGroupAdded.append(this.getEndElements(conditionToBeAdded));
            this.writeToFileGroup(xslTextGroupAdded.toString());
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void writeToFileGroup(String fileContent) throws Exception {
        FileOutputStream fout = new FileOutputStream(this.getGroupFileName());
        BufferedWriter fos = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, CommonConstants.ENCODING));
        fos.write(fileContent);
        fos.flush();
        fos.close();
    }

    private String getEndElements(String xslCondition) throws Exception {
        StringBuffer endElementsString = new StringBuffer();
        endElementsString.append("</body>\n</html>\n");
        return endElementsString.toString();
    }

    private String getHTMLFormat(String xslCondition) throws Exception {
        xslCondition = "V0";
        StringBuffer htmlFormatString = new StringBuffer();
        BaseLogger.log("3", null, null, "HTML FORMAT (Start)");
        htmlFormatString.append("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>\n");
        htmlFormatString.append("<html xsl:version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n");
        htmlFormatString.append("<head>\n");
        htmlFormatString.append("<script src=\"../../js/jsrsClient.js\"></script>");
        htmlFormatString.append("<script src=\"../../js/groupFilter.js\"></script>");
        htmlFormatString.append("</head>\n");
        BaseLogger.log("3", null, null, "HTML FORMAT (End)");
        return htmlFormatString.toString();
    }

    private String getSelectedValues() throws Exception {
        return this.selectedValues;
    }

    private void setSelectedValues(ArrayList selectedList) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < selectedList.size()) {
            buffer.append(String.valueOf((String)selectedList.get(i)) + "~");
            ++i;
        }
        buffer.deleteCharAt(buffer.length() - 1);
        this.selectedValues = buffer.toString();
    }

    private String removeEscapeChars(String str) throws Exception {
        char[] symbolsArray = new char[]{'&', '\"', '\'', '\ufffd', '\ufffd', '\ufffd', '\ufffd'};
        String[] entityArray = new String[]{"&amp;", "&quot;", "&#x2018;", "&euro;", "&pound;", "&sup3;", "&sup2;"};
        String repString = new String(str);
        StringBuffer repBuff = new StringBuffer(repString);
        int entInd = 0;
        while (entInd < entityArray.length) {
            int entPos = -1;
            while ((entPos = repBuff.toString().indexOf(entityArray[entInd])) != -1) {
                repBuff.replace(entPos, entPos + entityArray[entInd].length(), String.valueOf(symbolsArray[entInd]));
            }
            ++entInd;
        }
        return repBuff.toString();
    }

    public void setCountStatus(String countStatus) {
        this.countStatus = countStatus;
    }

    public String firstFilter(String fileName, String xslCondition) throws Exception {
        String returnString = null;
        ArrayList selectedList = null;
        try {
            if (xslCondition != null) {
                selectedList = this.getSelectedList(this.grElementNameList, xslCondition);
                this.setSelectedValues(selectedList);
            } else {
                this.selectedValues = null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fileName);
            NodeList valueNodeList = doc.getElementsByTagName("value");
            String sepChar = "~";
            ArrayList<String> firstGroupValue = new ArrayList<String>();
            int i = 0;
            while (i < valueNodeList.getLength()) {
                if (valueNodeList.item(i).getFirstChild() != null) {
                    String selValue;
                    String str = valueNodeList.item(i).getFirstChild().getNodeValue();
                    if (this.selectedValues == null && (selValue = valueNodeList.item(i).getAttributes().getNamedItem("selected").getNodeValue()) != null && selValue.equals("1")) {
                        this.selectedValues = str;
                        selectedList = this.split(str, "~");
                    }
                    if (str.indexOf(sepChar) != -1) {
                        str = str.substring(0, str.indexOf(sepChar));
                    }
                    if (!firstGroupValue.contains(str)) {
                        firstGroupValue.add(str);
                    }
                }
                ++i;
            }
            StringBuffer firstGroup = new StringBuffer();
            int i2 = 0;
            while (i2 < firstGroupValue.size()) {
                firstGroup.append(String.valueOf((String)firstGroupValue.get(i2)) + sepChar);
                ++i2;
            }
            if (firstGroup.length() > 0) {
                firstGroup.deleteCharAt(firstGroup.length() - 1);
            }
            firstGroup.append("#");
            if (selectedList != null) {
                BaseLogger.log("3", null, null, "page is loading after clicking go button");
                BaseLogger.log("3", null, null, "selectedList on 1680: " + selectedList);
                String stringToFilter = "";
                StringBuffer sb = new StringBuffer();
                String filteredString = "";
                int i3 = 0;
                while (i3 < selectedList.size() - 1) {
                    stringToFilter = String.valueOf(stringToFilter) + (String)selectedList.get(i3) + "~";
                    BaseLogger.log("3", null, null, "String To Filter on 1687: " + stringToFilter);
                    filteredString = this.filterGroupData(stringToFilter, fileName);
                    if (filteredString.indexOf("#") != -1) {
                        filteredString = filteredString.substring(0, filteredString.indexOf("#") + 1);
                    }
                    sb.append(filteredString);
                    ++i3;
                }
                sb.insert(0, firstGroup.toString());
                returnString = this.sort(sb.toString());
            } else if (this.grElementNameList.size() == 1) {
                returnString = this.sort(firstGroup.toString());
            } else if (firstGroupValue.size() > 0) {
                String filteredString;
                String stringToFilter = (String)firstGroupValue.get(0);
                if (stringToFilter.length() == 0) {
                    int i4 = 0;
                    while (i4 < firstGroupValue.size()) {
                        stringToFilter = (String)firstGroupValue.get(i4);
                        if (stringToFilter.length() > 1) break;
                        ++i4;
                    }
                }
                if ((filteredString = this.filterGroupData(stringToFilter, fileName)).indexOf("#") != -1) {
                    filteredString = filteredString.substring(0, filteredString.indexOf("#") + 1);
                }
                StringBuffer sb = new StringBuffer(filteredString);
                int i5 = 0;
                while (i5 < this.grElementNameList.size() - 2) {
                    if (filteredString.indexOf("#") != -1) {
                        if ((filteredString = filteredString.substring(0, filteredString.indexOf("#"))).indexOf(sepChar) != -1) {
                            filteredString = filteredString.substring(0, filteredString.indexOf(sepChar));
                        }
                    } else if (filteredString.indexOf(sepChar) != -1) {
                        filteredString = filteredString.substring(0, filteredString.indexOf(sepChar));
                    }
                    if ((filteredString = this.filterGroupData(stringToFilter = String.valueOf(stringToFilter) + "~" + filteredString, fileName)).indexOf("#") != -1) {
                        filteredString = filteredString.substring(0, filteredString.indexOf("#") + 1);
                    }
                    sb.append(filteredString);
                    ++i5;
                }
                sb.insert(0, firstGroup.toString());
                returnString = this.sort(sb.toString());
            }
        }
        catch (Exception e) {
            returnString = null;
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return returnString;
    }

    public String filterGroupData(String filterString, String fileName) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fileName);
            StringBuffer rtnString = new StringBuffer();
            ArrayList filterList = new ArrayList();
            StringTokenizer tok = new StringTokenizer(filterString, "~");
            String sepChar = "~";
            if (filterString.endsWith("~")) {
                filterString = filterString.substring(0, filterString.length() - 1);
            }
            filterList = this.split(filterString, "~");
            ArrayList[] filteredList = new ArrayList[this.grElementList.size() - filterList.size()];
            int i = 0;
            while (i < filteredList.length) {
                filteredList[i] = new ArrayList();
                ++i;
            }
            NodeList valueNodeList = doc.getElementsByTagName("value");
            int i2 = 0;
            while (i2 < valueNodeList.getLength()) {
                String value = valueNodeList.item(i2).getFirstChild().getNodeValue();
                tok = new StringTokenizer(value, sepChar);
                ArrayList valueList = new ArrayList();
                valueList = this.split(value, "~");
                boolean matching = false;
                int x = 0;
                while (x < filterList.size()) {
                    if (((String)filterList.get(x)).equals((String)valueList.get(x))) {
                        matching = true;
                    } else if (((String)filterList.get(x)).equals("1=1")) {
                        matching = true;
                    } else {
                        matching = false;
                        break;
                    }
                    ++x;
                }
                if (matching) {
                    int count = 0;
                    int x2 = filterList.size();
                    while (x2 < valueList.size()) {
                        if (!filteredList[count].contains(valueList.get(x2))) {
                            filteredList[count].add(valueList.get(x2));
                        }
                        ++count;
                        ++x2;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < filteredList.length) {
                int x = 0;
                while (x < filteredList[i2].size()) {
                    rtnString.append(String.valueOf((String)filteredList[i2].get(x)) + sepChar);
                    ++x;
                }
                if (rtnString.length() > 1 && rtnString.charAt(rtnString.length() - 1) == '~') {
                    rtnString.deleteCharAt(rtnString.length() - 1);
                }
                rtnString.append("#");
                ++i2;
            }
            if (rtnString.length() > 1 && rtnString.charAt(rtnString.length() - 1) == '#') {
                rtnString.deleteCharAt(rtnString.length() - 1);
            }
            return this.sort(rtnString.toString());
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String filterForSelItems(String stringToFilter, String filteredGroup, String selectedItems, String fileName) throws Exception {
        try {
            String sepChar = "~";
            StringTokenizer tok = new StringTokenizer(selectedItems, sepChar);
            String[] selItems = new String[tok.countTokens()];
            String toFilter = stringToFilter;
            int counter = 0;
            while (tok.hasMoreTokens()) {
                selItems[counter] = tok.nextToken();
                ++counter;
            }
            tok = null;
            tok = new StringTokenizer(filteredGroup, "#");
            ArrayList<String> filteredList = new ArrayList<String>();
            int filteredCount = tok.countTokens();
            int index = 0;
            String outerToken = tok.nextToken();
            StringTokenizer childTok = new StringTokenizer(outerToken, sepChar);
            while (childTok.hasMoreTokens()) {
                filteredList.add(childTok.nextToken());
            }
            tok = null;
            tok = new StringTokenizer(stringToFilter, "~");
            int filterCount = tok.countTokens();
            index = 0;
            int matchingCount = 0;
            ArrayList<String> matchedList = new ArrayList<String>();
            String previousStr = "";
            int i = filterCount;
            while (i < selItems.length - 1) {
                boolean matching = false;
                if (filteredList.contains(selItems[i])) {
                    matching = true;
                } else if (selItems[i].equals("1=1")) {
                    matching = true;
                } else {
                    if (filteredList.size() < 1) break;
                    ArrayList filterList = new ArrayList(filteredList);
                    Collections.sort(filterList);
                    filteredList = filterList;
                    if (filteredList.get(0) == null || filteredList.get(0).equals("")) break;
                    selItems[i] = (String)filteredList.get(0);
                    matching = true;
                }
                if (matching) {
                    ++matchingCount;
                    stringToFilter = String.valueOf(stringToFilter) + "~" + selItems[i];
                    String str = this.filterGroupData(stringToFilter, fileName);
                    matchedList.add(str);
                    int hashIndex = str.indexOf("#");
                    if (hashIndex != -1) {
                        str = str.substring(0, hashIndex);
                        tok = new StringTokenizer(str, sepChar);
                        filteredList.clear();
                        while (tok.hasMoreTokens()) {
                            filteredList.add(tok.nextToken());
                        }
                    } else {
                        tok = new StringTokenizer(str, sepChar);
                        filteredList.clear();
                        while (tok.hasMoreTokens()) {
                            filteredList.add(tok.nextToken());
                        }
                    }
                }
                ++index;
                ++i;
            }
            String filteredStr = "";
            if (matchingCount == 0) {
                return filteredGroup;
            }
            String onMatchString = toFilter;
            StringBuffer buffer = new StringBuffer(filteredGroup.substring(0, filteredGroup.indexOf("#")));
            int i2 = filterCount;
            while (i2 < filterCount + matchingCount) {
                filteredStr = this.filterGroupData(onMatchString = String.valueOf(onMatchString) + "~" + selItems[i2], fileName);
                int hashIndex = filteredStr.indexOf("#");
                if (hashIndex != -1) {
                    String substr = filteredStr.substring(0, hashIndex);
                    buffer.append("#" + substr);
                } else {
                    buffer.append("#" + filteredStr);
                }
                ++i2;
            }
            String bufferString = buffer.toString();
            bufferString = bufferString.substring(0, bufferString.lastIndexOf("#") + 1);
            bufferString = String.valueOf(bufferString) + filteredStr;
            return this.sort(bufferString);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private String sort(String stringToSort) throws Exception {
        String sepChar = "~";
        if (stringToSort != null) {
            StringTokenizer outerToken = new StringTokenizer(stringToSort, "#");
            StringBuffer outerBuffer = new StringBuffer();
            while (outerToken.hasMoreTokens()) {
                String token = outerToken.nextToken();
                StringTokenizer innerToken = new StringTokenizer(token, sepChar);
                String[] strArray = new String[innerToken.countTokens()];
                int index = 0;
                while (innerToken.hasMoreTokens()) {
                    strArray[index] = innerToken.nextToken();
                    ++index;
                }
                if (strArray.length > 1) {
                    int i = 0;
                    while (i < strArray.length) {
                        int x = i;
                        while (x < strArray.length) {
                            if (strArray[i].compareTo(strArray[x]) > 0) {
                                String temp = strArray[i];
                                strArray[i] = strArray[x];
                                strArray[x] = temp;
                            }
                            ++x;
                        }
                        ++i;
                    }
                    StringBuffer innerBuffer = new StringBuffer();
                    int i2 = 0;
                    while (i2 < strArray.length) {
                        if (!strArray[i2].trim().equals("")) {
                            innerBuffer.append(String.valueOf(strArray[i2]) + sepChar);
                        }
                        ++i2;
                    }
                    if (innerBuffer.length() > 0) {
                        innerBuffer.deleteCharAt(innerBuffer.length() - 1);
                    }
                    outerBuffer.append(String.valueOf(innerBuffer.toString()) + "#");
                    continue;
                }
                outerBuffer.append(String.valueOf(strArray[0]) + "#");
            }
            if (outerBuffer.length() > 0) {
                outerBuffer.deleteCharAt(outerBuffer.length() - 1);
            }
            return outerBuffer.toString();
        }
        return null;
    }

    private Column findColumn(String lgname) throws Exception {
        Column col = null;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].getLogicalName().equals(lgname)) {
                col = this.columns[i];
                break;
            }
            ++i;
        }
        return col;
    }

    private ArrayList getSelectedList(ArrayList groupList, String xslCondition) throws Exception {
        ArrayList<String> rtnList = null;
        try {
            rtnList = new ArrayList<String>();
            int i = 0;
            while (i < groupList.size()) {
                String logicalName = (String)groupList.get(i);
                int wordIndex = xslCondition.indexOf(logicalName);
                if (wordIndex != -1) {
                    char symbol = xslCondition.charAt(wordIndex - 1);
                    if (symbol == '(') {
                        wordIndex = wordIndex + logicalName.length() + 19;
                        int lastIndex = xslCondition.indexOf(39, wordIndex);
                        String subString = xslCondition.substring(wordIndex, lastIndex);
                        subString = this.removeEscapeChars(subString);
                        rtnList.add(subString);
                    } else {
                        rtnList.add("1=1");
                    }
                } else {
                    rtnList.add("1=1");
                }
                ++i;
            }
        }
        catch (Exception e) {
            rtnList = null;
            throw e;
        }
        return rtnList;
    }

    public void setGroupData(String filteredData, boolean isUserRequest) throws Exception {
        try {
            DateBean dtbean = new DateBean();
            String sepChar = "~";
            StringTokenizer outerToken = null;
            if (filteredData != null) {
                outerToken = new StringTokenizer(filteredData, "#");
            }
            StringTokenizer selectedValueToken = null;
            BaseLogger.log("3", null, null, "selectedValues:" + this.selectedValues);
            if (this.selectedValues != null) {
                selectedValueToken = new StringTokenizer(this.selectedValues, sepChar);
            }
            StringBuffer htmlBuffer = new StringBuffer();
            StringBuffer displayNames = new StringBuffer();
            StringBuffer logicalNames = new StringBuffer();
            htmlBuffer.append("<groups>");
            int i = 0;
            while (i < this.grElementList.size()) {
                Column column = (Column)this.grElementList.get(i);
                displayNames.append(String.valueOf(column.getDisplayName()) + sepChar);
                logicalNames.append(String.valueOf(column.getLogicalName()) + sepChar);
                htmlBuffer.append("<group name=\"" + column.getLogicalName() + "\" disName=\"" + column.getDisplayName() + "\" code=\"" + (i + 1) + "\">");
                String groupToken = "";
                String dbPattern = column.getDBPattern();
                String disPattern = column.getDisplayPattern();
                if (outerToken != null && outerToken.hasMoreTokens()) {
                    groupToken = outerToken.nextToken();
                }
                StringTokenizer innerToken = new StringTokenizer(groupToken, sepChar);
                boolean selected = false;
                String selectedItem = "";
                if (selectedValueToken != null) {
                    BaseLogger.log("3", null, null, "selectedValueToken.countTokens(): " + selectedValueToken.countTokens());
                    if (selectedValueToken.countTokens() > 0) {
                        selectedItem = selectedValueToken.nextToken();
                        if (dbPattern != null && !dbPattern.equalsIgnoreCase("null") && !isUserRequest && selectedItem.length() > 0) {
                            selectedItem = dtbean.convertPattern(dbPattern, disPattern, selectedItem);
                        }
                    }
                }
                htmlBuffer.append("<value selected=\"0\"><![CDATA[All " + column.getDisplayName() + "]]></value>");
                boolean isSingleRecode = false;
                if (innerToken.countTokens() == 1) {
                    isSingleRecode = true;
                    BaseLogger.log("3", null, null, "innerToken.countTokens   " + innerToken.countTokens());
                } else {
                    BaseLogger.log("3", null, null, "INNER TOKENS IS NOT EQUAL TO One        " + innerToken.countTokens());
                }
                while (innerToken.hasMoreTokens()) {
                    String item = innerToken.nextToken();
                    if (dbPattern != null && !dbPattern.equalsIgnoreCase("null") && item.length() > 0) {
                        item = dtbean.convertPattern(dbPattern, disPattern, item);
                    }
                    if (this.selectedValues == null) {
                        if (!selected || isSingleRecode) {
                            htmlBuffer.append("<value selected=\"1\"><![CDATA[" + item + "]]></value>");
                            selected = true;
                            continue;
                        }
                        htmlBuffer.append("<value selected=\"0\"><![CDATA[" + item + "]]></value>");
                        isSingleRecode = false;
                        continue;
                    }
                    if (item.equals(selectedItem) || isSingleRecode) {
                        htmlBuffer.append("<value selected=\"1\"><![CDATA[" + item + "]]></value>");
                        continue;
                    }
                    htmlBuffer.append("<value selected=\"0\"><![CDATA[" + item + "]]></value>");
                    isSingleRecode = false;
                }
                htmlBuffer.append("</group>");
                ++i;
            }
            logicalNames = logicalNames.deleteCharAt(logicalNames.length() - 1);
            displayNames = displayNames.deleteCharAt(displayNames.length() - 1);
            htmlBuffer.append("</groups>");
            htmlBuffer.append("<LOGICALNAMES>" + logicalNames.toString() + "</LOGICALNAMES>");
            htmlBuffer.append("<DISPLAYNAMES>" + displayNames.toString() + "</DISPLAYNAMES>");
            this.filteredGroupFileName = String.valueOf(CommonConstants.BIHOME) + File.separator + "xmldatafiles" + File.separator + "Filtered_Group" + Math.random() + ".xml";
            FileWriter fileWriter = new FileWriter(this.filteredGroupFileName);
            fileWriter.write("<root>");
            fileWriter.write("<NO_OF_GROUP_COLUMNS>" + this.grElementList.size() + "</NO_OF_GROUP_COLUMNS>");
            fileWriter.write("<TARGET>" + this.target + "</TARGET>");
            fileWriter.write(htmlBuffer.toString());
            fileWriter.write("</root>");
            fileWriter.close();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getFilteredGroupFileName() throws Exception {
        try {
            return this.filteredGroupFileName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setTarget(String target) throws Exception {
        try {
            this.target = target;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private ArrayList split(String stringToSplit, String delimeter) throws Exception {
        ArrayList<String> splitedDataList = new ArrayList<String>();
        int curIndex = 0;
        while (curIndex <= stringToSplit.length()) {
            int indexOfsepChar = stringToSplit.indexOf(delimeter, curIndex);
            String tmp = "";
            if (indexOfsepChar != -1) {
                tmp = stringToSplit.substring(curIndex, indexOfsepChar);
                curIndex = indexOfsepChar;
            } else {
                tmp = stringToSplit.substring(curIndex);
                curIndex = stringToSplit.length();
            }
            tmp = tmp.length() == 0 ? " " : tmp;
            splitedDataList.add(tmp);
            ++curIndex;
        }
        return splitedDataList;
    }

    private String getFormattedTargetName(String biFileName) {
        if (biFileName != null && biFileName.indexOf(" ") != -1) {
            biFileName = biFileName.replace(" ", "_");
        }
        BaseLogger.log("2", null, null, "biFileName[" + biFileName + "]");
        return biFileName;
    }

    public String getSelectedList() {
        return this.selectedValues;
    }
}

