/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.sys;

import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class UtilMethods {
    public static UtilMethods getInstance() {
        return new UtilMethods();
    }

    public Timestamp RelativeDate(Timestamp baseDate, int noOfDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.add(5, noOfDays);
        Date newDate = cal.getTime();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        return Timestamp.valueOf(String.valueOf(sdt.format(newDate)) + " 00:00:00.000");
    }

    public Date RelativeDate(Date baseDate, int noOfDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.add(5, noOfDays);
        Date newDate = cal.getTime();
        return newDate;
    }

    public Date AddMonths(Date baseDate, int noOfMonths) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.add(2, noOfMonths);
        Date newDate = cal.getTime();
        return newDate;
    }

    public Timestamp AddMonths(Timestamp baseDate, int noOfMonths) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.add(2, noOfMonths);
        Date newDate = cal.getTime();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        return Timestamp.valueOf(String.valueOf(sdt.format(newDate)) + " 00:00:00.000");
    }

    public long DaysAfter(Timestamp date1, Timestamp date2) {
        Calendar calen = Calendar.getInstance();
        Calendar calen1 = Calendar.getInstance();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        long totDays = 0L;
        date1 = Timestamp.valueOf(String.valueOf(sdt.format(date1)) + " 00:00:00.000");
        calen.setTime(date1);
        date2 = Timestamp.valueOf(String.valueOf(sdt.format(date2)) + " 00:00:00.000");
        calen1.setTime(date2);
        totDays = (calen1.getTime().getTime() - calen.getTime().getTime()) / 86400000L;
        return totDays;
    }

    public String getReqDecString(double actVal, int prec) {
        String fmtStr = "############0";
        Object strValue = null;
        if (prec > 0) {
            fmtStr = String.valueOf(fmtStr) + "." + "000000000".substring(0, prec);
        }
        DecimalFormat decFormat = new DecimalFormat(fmtStr);
        return decFormat.format(actVal);
    }

    public int MonthsBetween(Timestamp date1, Timestamp date2) {
        Calendar calen = Calendar.getInstance();
        Calendar calen1 = Calendar.getInstance();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        long totDays = 0L;
        int startMonth = 0;
        int endMonth = 0;
        int startDay = 0;
        int totMonths = 0;
        Timestamp tmpDate = null;
        date1 = Timestamp.valueOf(String.valueOf(sdt.format(date1)) + " 00:00:00.000");
        if ((date2 = Timestamp.valueOf(String.valueOf(sdt.format(date2)) + " 00:00:00.000")).compareTo(date1) < 0) {
            tmpDate = date2;
            date2 = date1;
            date1 = tmpDate;
        }
        calen.setTime(date1);
        calen1.setTime(date2);
        startDay = calen.get(5);
        startMonth = calen.get(2) + 1;
        endMonth = calen1.get(2) + 1;
        System.out.println("start month before" + startMonth);
        if (startDay > 15 && ++startMonth > 12) {
            startMonth = 1;
        }
        totMonths = startMonth > endMonth ? 12 - startMonth + 1 + endMonth : endMonth - startMonth + 1;
        return totMonths;
    }

    public double ElapsedTimeHHMM(Timestamp date1, Timestamp date2) {
        Calendar calen = Calendar.getInstance();
        Calendar calen1 = Calendar.getInstance();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd kk:mm");
        double totHHMM = 0.0;
        long totalTime = 0L;
        long amills = 0L;
        long bmills = 0L;
        int multiplier = 1;
        if (date2.compareTo(date1) < 0) {
            Timestamp tmpDate = date2;
            date2 = date1;
            date1 = tmpDate;
            multiplier = -1;
        }
        date1 = Timestamp.valueOf(String.valueOf(sdt.format(date1)) + ":00.000");
        calen.setTime(date1);
        date2 = Timestamp.valueOf(String.valueOf(sdt.format(date2)) + ":00.000");
        calen1.setTime(date2);
        bmills = calen.getTimeInMillis();
        amills = calen1.getTimeInMillis();
        totalTime = amills - bmills;
        int totSecs = (int)(0.001 * (double)totalTime);
        int totalHrs = totSecs / 3600;
        int totlMts = (totSecs - totalHrs * 3600) / 60;
        totSecs -= totalHrs * 3600 + totlMts * 60;
        totHHMM = Double.parseDouble(String.valueOf(Integer.toString(totalHrs).trim()) + "." + Integer.toString(totlMts).trim());
        return totHHMM *= (double)multiplier;
    }

    public Date today() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.clear(10);
        rightNow.clear(12);
        rightNow.clear(13);
        rightNow.clear(14);
        Date today = rightNow.getTime();
        return today;
    }

    public java.sql.Date todaySqlDate() {
        java.sql.Date today = new java.sql.Date(System.currentTimeMillis());
        return today;
    }

    public Time now() {
        return new Time(System.currentTimeMillis());
    }

    public java.sql.Date getSqlDate(Timestamp ts1) throws ITMException {
        java.sql.Date sd = null;
        try {
            sd = new java.sql.Date(ts1.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return sd;
    }

    public java.sql.Date date(Timestamp ts1) throws ITMException {
        java.sql.Date sd = null;
        try {
            sd = new java.sql.Date(ts1.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return sd;
    }

    public java.sql.Date getSqlDate(int year, int month, int day) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        java.sql.Date today = null;
        try {
            rightNow.set(5, day);
            rightNow.set(2, month - 1);
            rightNow.set(1, year);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            Date dt = rightNow.getTime();
            today = new java.sql.Date(dt.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return today;
    }

    public java.sql.Date date(int year, int month, int day) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        java.sql.Date today = null;
        try {
            rightNow.set(5, day);
            rightNow.set(2, month - 1);
            rightNow.set(1, year);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            Date dt = rightNow.getTime();
            today = new java.sql.Date(dt.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return today;
    }

    public int year(java.sql.Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int year = 0;
        try {
            rightNow.setTime(sd);
            year = rightNow.get(1);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return year;
    }

    public int year(Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int year = 0;
        try {
            rightNow.setTime(sd);
            year = rightNow.get(1);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return year;
    }

    public int year(Timestamp st) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int year = 0;
        try {
            rightNow.setTime(st);
            year = rightNow.get(1);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return year;
    }

    public int month(java.sql.Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int month = 0;
        try {
            rightNow.setTime(sd);
            month = rightNow.get(2) + 1;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return month;
    }

    public int month(Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int month = 0;
        try {
            rightNow.setTime(sd);
            month = rightNow.get(2) + 1;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return month;
    }

    public int month(Timestamp st) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int month = 0;
        try {
            rightNow.setTime(st);
            month = rightNow.get(2) + 1;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return month;
    }

    public int day(java.sql.Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            rightNow.setTime(sd);
            day = rightNow.get(5);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }

    public int day(Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            rightNow.setTime(sd);
            day = rightNow.get(5);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }

    public int day(Timestamp st) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            rightNow.setTime(st);
            day = rightNow.get(5);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }

    public Date getUtilDate(Date date) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        try {
            rightNow.setTime(date);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            today = rightNow.getTime();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return today;
    }

    public Date date(Date date) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        try {
            rightNow.setTime(date);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            today = rightNow.getTime();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return today;
    }

    public Timestamp dateTime(Date ud) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        Timestamp ts = null;
        try {
            rightNow.setTime(ud);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            today = rightNow.getTime();
            ts = new Timestamp(today.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return ts;
    }

    public Timestamp dateTime(java.sql.Date sd) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        Timestamp ts = null;
        try {
            rightNow.setTime(sd);
            rightNow.clear(10);
            rightNow.clear(12);
            rightNow.clear(13);
            rightNow.clear(14);
            today = rightNow.getTime();
            ts = new Timestamp(today.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return ts;
    }

    public Timestamp dateTime(java.sql.Date sd, Time sqlTime) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        String timeStr = "";
        Timestamp ts = null;
        try {
            timeStr = sqlTime.toString();
            String[] timeStrArr = timeStr.split(":");
            rightNow.setTime(sd);
            today = rightNow.getTime();
            ts = new Timestamp(today.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return ts;
    }

    public Timestamp dateTime(Date ud, Time sqlTime) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        Date today = null;
        String timeStr = "";
        Timestamp ts = null;
        try {
            timeStr = sqlTime.toString();
            String[] timeStrArr = timeStr.split(":");
            rightNow.setTime(ud);
            today = rightNow.getTime();
            ts = new Timestamp(today.getTime());
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return ts;
    }

    public double mod(double value1, double value2) {
        return value1 % value2;
    }

    public double mod(double value1, Double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(double value1, int value2) {
        return value1 % (double)value2;
    }

    public double mod(double value1, Integer value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % (double)value2.intValue();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(int value1, int value2) {
        return value1 % value2;
    }

    public double mod(int value1, Integer value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(int value1, double value2) {
        return (double)value1 % value2;
    }

    public double mod(int value1, Double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = (double)value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Integer value1, Integer value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Integer value1, int value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Integer value1, double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = (double)value1.intValue() % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Integer value1, Double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = (double)value1.intValue() % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Double value1, Double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Double value1, double value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Double value1, int value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % (double)value2;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public double mod(Double value1, Integer value2) throws ITMException {
        double d1 = 0.0;
        try {
            d1 = value1 % (double)value2.intValue();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return d1;
    }

    public String mid(String lsStr, int start, int liColWidth) throws ITMException {
        String str1 = null;
        try {
            if (liColWidth < lsStr.length()) {
                if (start > 0) {
                    --start;
                }
                if (liColWidth > 0) {
                    liColWidth = start + liColWidth;
                }
                str1 = lsStr.substring(start, liColWidth);
            } else {
                str1 = lsStr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return str1;
    }

    public String mid(String lsStr, int start) throws ITMException {
        String str1 = null;
        try {
            if (start > 0) {
                --start;
            }
            str1 = lsStr.substring(start);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return str1;
    }

    public String left(String src, int size) throws ITMException {
        String str1 = null;
        try {
            if (src.length() < size) {
                size = src.length();
            }
            str1 = src.substring(0, size);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return str1;
    }

    public String right(String src, int size) throws ITMException {
        String str1 = null;
        try {
            str1 = src.length() < size ? "" : src.substring(src.length() - size);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return str1;
    }

    public int pos(String str, String searchChar) throws ITMException {
        int i1 = 0;
        try {
            i1 = str.indexOf(searchChar);
            i1 = i1 == -1 ? 0 : ++i1;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return i1;
    }

    public int pos(String str, String searchChar, int position) throws ITMException {
        int i1 = 0;
        try {
            i1 = str.indexOf(searchChar, position) == -1 ? 0 : str.indexOf(searchChar, position) + 1;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return i1;
    }

    public String space(int noOfSpaces) {
        String blankStr = null;
        blankStr = "";
        int cnt = 0;
        while (cnt < noOfSpaces) {
            blankStr = String.valueOf(blankStr) + " ";
            ++cnt;
        }
        return blankStr;
    }

    public int getRowCount(Document dom, int formNo) throws ITMException {
        int rowCount = 0;
        NodeList detailList = null;
        String detail = null;
        try {
            detail = "Detail" + formNo;
            detailList = dom.getElementsByTagName(detail);
            rowCount = detailList.getLength();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return rowCount;
    }

    public boolean isnumber(String str) {
        try {
            int val = Integer.parseInt(str);
        }
        catch (NumberFormatException nex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public String leftTrim(String str) throws ITMException {
        String returnStr = null;
        try {
            if (str == null) {
                returnStr = null;
            } else if (str == null || str.trim().length() == 0) {
                returnStr = "";
            } else {
                StringBuilder sb = new StringBuilder(str);
                while (Character.isWhitespace(sb.charAt(0))) {
                    sb.deleteCharAt(0);
                }
                returnStr = sb.toString();
            }
        }
        catch (Exception e) {
            returnStr = null;
        }
        return returnStr;
    }

    public String rightTrim(String str) throws ITMException {
        String returnStr = null;
        try {
            if (str == null) {
                returnStr = null;
            } else if (str == null || str.trim().length() == 0) {
                returnStr = "";
            } else {
                StringBuilder sb = new StringBuilder(str);
                while (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                returnStr = sb.toString();
            }
        }
        catch (Exception e) {
            returnStr = null;
        }
        return returnStr;
    }

    public String convertToString(int ival) throws ITMException {
        String returnStr = null;
        try {
            returnStr = String.valueOf(ival);
        }
        catch (Exception e) {
            returnStr = null;
        }
        return returnStr;
    }

    public String convertToString(double dval) throws ITMException {
        String returnStr = null;
        try {
            returnStr = String.valueOf(dval);
        }
        catch (Exception e) {
            returnStr = null;
        }
        return returnStr;
    }

    public String convertToString(Integer ival) throws ITMException {
        String returnStr = null;
        try {
            returnStr = ival.toString();
        }
        catch (Exception e) {
            returnStr = null;
        }
        return returnStr;
    }

    public int DaysAfter(Date d1, Date d2) throws ITMException {
        int noDays = 0;
        try {
            noDays = (int)((d2.getTime() - d1.getTime()) / 86400000L);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return noDays;
    }

    public int DaysAfter(java.sql.Date d1, java.sql.Date d2) throws ITMException {
        int noDays = 0;
        try {
            noDays = (int)((d2.getTime() - d1.getTime()) / 86400000L);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return noDays;
    }

    public double convertMinutesToHours(int min) throws ITMException {
        double hrs = 0.0;
        double dReminder = 0.0;
        int i1 = 0;
        int iSign = 1;
        try {
            if (min != 0) {
                if (min < 0) {
                    iSign = -1;
                    min *= -1;
                }
                dReminder = this.mod(min, 60);
                i1 = (min - (int)dReminder) / 60;
                hrs = (double)i1 + dReminder / 100.0;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return hrs * (double)iSign;
    }

    public int convertTimeInMin(double dTime) throws ITMException {
        double dReminder = 0.0;
        int min = 0;
        int iSign = 1;
        try {
            if (dTime != 0.0) {
                if (dTime < 0.0) {
                    iSign = -1;
                    dTime *= -1.0;
                }
                dReminder = this.mod(dTime, 1.0);
                min = (int)((dTime - dReminder) * 60.0 + dReminder * 100.0);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return min * iSign;
    }

    public Time stringToTime(String str) throws ITMException {
        Object sTime = null;
        try {
            String[] s = str.split(":");
            if (s.length < 2) {
                str = String.valueOf(str) + ":00:00";
            } else if (s.length < 3) {
                str = String.valueOf(str) + ":00";
            }
            System.out.println("\r\nTime String :::" + str + "\r\n");
            return Time.valueOf(str);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int upperBound(String[] strArr) throws ITMException {
        boolean iLength = false;
        try {
            return strArr.length;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int upperBound(int[] intArr) throws ITMException {
        boolean iLength = false;
        try {
            return intArr.length;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int upperBound(Timestamp[] tsArr) throws ITMException {
        boolean iLength = false;
        try {
            return tsArr.length;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int upperBound(java.sql.Date[] sdArr) throws ITMException {
        boolean iLength = false;
        try {
            return sdArr.length;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int convertTimeInMin(Time sqlTime) throws ITMException {
        String timeStr = "";
        int min = 0;
        int iSign = 1;
        try {
            timeStr = sqlTime.toString();
            String[] timeStrArr = timeStr.split(":");
            min = Integer.parseInt(timeStrArr[0]) * 60 + Integer.parseInt(timeStrArr[1]);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return min * iSign;
    }

    public int abs(int intVal) throws ITMException {
        try {
            if (intVal < 0) {
                intVal *= -1;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return intVal;
    }

    public double abs(double dblVal) throws ITMException {
        try {
            if (dblVal < 0.0) {
                dblVal *= -1.0;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return dblVal;
    }

    public boolean isChar(String inputStr, int start, int lengthStr) throws ITMException {
        boolean result = false;
        int resultStr = 0;
        String firstChar = "";
        String inputStrChar = "";
        try {
            inputStrChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            firstChar = this.mid(inputStr, start, lengthStr);
            System.out.println("firstChar::::::[" + firstChar + "]");
            resultStr = this.pos(inputStrChar, firstChar);
            System.out.println("resultStr::::[" + resultStr + "]");
            result = resultStr > 0;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        System.out.println("result::::[" + result + "]");
        return result;
    }

    public String getMsg(String trace, String Code, Connection conn) throws ITMException, Exception {
        String mainStr = "";
        try {
            ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
            String errString = "";
            errString = itmDBAccessEJB.getErrorString("", Code, "", "", conn);
            String begPart = errString.substring(0, errString.indexOf("<message>") + 9);
            String begDesc = errString.substring(0, errString.indexOf("<description>") + 13);
            String endDesc = errString.substring(errString.indexOf("</description>"));
            mainStr = String.valueOf(begPart) + trace + " </message> <description>";
            mainStr = String.valueOf(mainStr) + endDesc;
            begPart = null;
            itmDBAccessEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return mainStr;
    }

    public int day(java.sql.Date sd, String periodType) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            System.out.println("sql.Date sd :::>>" + sd);
            System.out.println("periodType :::>>" + periodType);
            rightNow.setTime(sd);
            if ("W".equalsIgnoreCase(periodType)) {
                day = rightNow.get(7);
            } else if ("M".equalsIgnoreCase(periodType)) {
                day = rightNow.get(5);
            } else if ("Y".equalsIgnoreCase(periodType)) {
                day = rightNow.get(6);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }

    public int day(Date sd, String periodType) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            System.out.println("util.Date sd :::>>" + sd);
            System.out.println("periodType :::>>" + periodType);
            rightNow.setTime(sd);
            if ("W".equalsIgnoreCase(periodType)) {
                day = rightNow.get(7);
            } else if ("M".equalsIgnoreCase(periodType)) {
                day = rightNow.get(5);
            } else if ("Y".equalsIgnoreCase(periodType)) {
                day = rightNow.get(6);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }

    public int day(Timestamp st, String periodType) throws ITMException {
        Calendar rightNow = Calendar.getInstance();
        int day = 0;
        try {
            System.out.println("sql.Timestamp st :::>>" + st);
            System.out.println("periodType :::>>" + periodType);
            rightNow.setTime(st);
            if ("W".equalsIgnoreCase(periodType)) {
                day = rightNow.get(7);
            } else if ("M".equalsIgnoreCase(periodType)) {
                day = rightNow.get(5);
            } else if ("Y".equalsIgnoreCase(periodType)) {
                day = rightNow.get(6);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return day;
    }
}

