package ibase.webitm.utility.wsfa;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

import javax.servlet.SingleThreadModel;

public class DateObject implements SingleThreadModel
{
	static final long ONE_HOUR = 60 * 60 * 1000L;
	Calendar earlierDate;
	Calendar laterDate;
	Calendar dateObject = null;
	String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	private Vector presentDate;
	private Vector absentDate;
	private String dateFrom;
	private String dateTo;


	public DateObject()
	{
	}

	public void setDateFrom(String dtFrom)
	{
		dateFrom = dtFrom;
	}

	public void setDateTo(String dtTo)
	{
		dateTo = dtTo;
	}

	public void setPresentDate(Vector presentDt)
	{
		presentDate = presentDt ;
	}

	public Vector getAbsentDate()
	{
		return absentDate ;
	}

	/*
		@ param -	date in format .. yyyy-mm-dd hh:mm:ss
		@exception -	none
		output:		date in format .. dd-mon-yyyy
	 */

	public String getAccessDate(String dateWork)
	{
		dateWork=dateWork.substring(0,10);
		String months[] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; 
		StringTokenizer stringArray = new StringTokenizer(dateWork,"-");

		String dateArr[] = new String[stringArray.countTokens()];
		dateArr[2]=stringArray.nextToken();	

		int mth = Integer.parseInt(stringArray.nextToken());

		dateArr[1] = months[mth-1];
		dateArr[0] = stringArray.nextToken();
		String resultDate=dateArr[0]+"-"+dateArr[1]+"-"+dateArr[2];
		return resultDate;
	}

	/*
		@method		Convert Date from String to Calendar object.
		@input			String in the form - 1-Jan-2000
		@output		Calendar object representation of @input.
		@desc			Assumption - Input string is in the format -> dd-Mon-yyyy

	 */
	public void setDate(String date)
	{
		StringTokenizer stringArray = new StringTokenizer(date,"-");
		int[] dateArray = new int[stringArray.countTokens()];

		dateArray[0] = Integer.parseInt(stringArray.nextToken());	

		String s = stringArray.nextToken();

		for(int i=0;i<months.length;i++)
		{
			if(s.equalsIgnoreCase(months[i]))
			{
				dateArray[1] = i;
				break;
			}
		}
		dateArray[2] = Integer.parseInt(stringArray.nextToken());

		TimeZone timeZone = TimeZone.getTimeZone("Asia/Calcutta");
		TimeZone.setDefault(timeZone);

		dateObject = Calendar.getInstance();
		dateObject.set(dateArray[2],dateArray[1],dateArray[0]);
	}
	/**
	@method				getDate()
	@desc					return the date object set using setDate()
	 */
	public void setDate(Calendar cal)
	{
		dateObject = cal;
	}
	public Calendar getDate()
	{
		return dateObject;
	}

	public String getMonth()
	{
		Calendar calDate = getDate();
		return months[calDate.get(Calendar.MONTH)];
	}

	public String getYear()
	{
		Calendar calDate = getDate();
		return new Integer(calDate.get(Calendar.YEAR)).toString();
	}

	public String getDay()
	{
		Calendar calDate = getDate();
		return new Integer(calDate.get(Calendar.DATE)).toString();
	}

	// get the previous month.If the month is Jan of the a year, then it should give Dec with prev year
	// will change the class variable 'dateObject'.

	public void getPrevMonth()
	{
		int yr = 0;
		int mon = 0;
		int day = 1;
		if(dateObject.get(Calendar.MONTH)==0) // that means it's january
		{
			mon = 11;								// month is december
			yr = dateObject.get(Calendar.YEAR) - 1; // previous yr
			dateObject.set(yr,mon,day);
		}
		else
		{
			mon = dateObject.get(Calendar.MONTH) - 1 ; // previous month
			yr = dateObject.get(Calendar.YEAR);
			dateObject.set(yr,mon,day);
		}

	}

	public int getLastDayOfMonth()
	{ 
		Calendar calDate = getDate();
		GregorianCalendar gcDate = new GregorianCalendar(calDate.get(Calendar.YEAR),calDate.get(Calendar.MONTH),calDate.get(Calendar.DATE));
		gcDate.add(Calendar.MONTH,1); 
		gcDate.set(Calendar.DATE,0); 
		return gcDate.get(Calendar.DATE); 
	}

	public int getFirstDayOfMonth()
	{
		return 1;
	}

	public String getLastDateOfMonth()
	{
		Calendar calDate = getDate();
		int day = getLastDayOfMonth();
		String lastDate = new Integer(day).toString() +"-" + months[calDate.get(Calendar.MONTH)]+ "-" +calDate.get(Calendar.YEAR);
		return lastDate;
	}

	public String getFirstDateOfMonth()
	{
		Calendar calDate = getDate();
		int day = getFirstDayOfMonth();
		String firstDate = new Integer(day).toString() + "-" + months[calDate.get(Calendar.MONTH)]+ "-" + calDate.get(Calendar.YEAR);
		return firstDate;
	}

	public void setEarlierDate(int year,int month,int date, int hr, int min,int sec)
	{
		earlierDate = new GregorianCalendar();
		earlierDate.set(year, month, date, hr, min, sec);    // FEB!! 05, 1997
	}
	public void setEarlierDate(Calendar eCalObject)
	{
		earlierDate = eCalObject;
	}
	public Calendar getEarlierDate()
	{
		return earlierDate;
	}
	public void setLaterDate(int year,int month,int date, int hr, int min,int sec)
	{
		laterDate = new GregorianCalendar();
		laterDate.set(year, month, date, hr, min, sec);      // Feb 05, 1998
	}
	public void setLaterDate(Calendar lCalObject)
	{
		laterDate = lCalObject;
	}
	public Calendar getLaterDate()
	{
		return laterDate;
	}

	/*
	This function gives the no of days between two Calender Dates 

	@desc 
		The getLaterDate() gives a calender date.The calender's getTime() function returns a Date object.
		The Date's  getTime() gives the time in milliseconds from 1/1/1970
		The millisec of both dates are computed and the subtrated.The difference is then divided by
		(24*60*60*1000)

	 */
	public long getDateBetweenCount()
	{
		long duration =  getLaterDate().getTime().getTime() - getEarlierDate().getTime().getTime();
		// Add one hour in case the duration includes a 23 hour Daylight Savings spring forward day.
		long  nDays = ( duration + ONE_HOUR ) / (24 * ONE_HOUR);
		// it doesn't include the last date.
		nDays=nDays+1;				 
		return nDays;
	}

	public String[]  getDatesBetween()
	{
		long dateCount = 	getDateBetweenCount();	
		int len = new Long(dateCount).intValue();
		String[] datesArray = new String[len];

		for(int i=0;i<len;i++)
		{
			Calendar newDate = getEarlierDate();
			datesArray[i] = newDate.get(Calendar.DAY_OF_MONTH) + "-" + months[newDate.get(Calendar.MONTH)] + "-" + newDate.get(Calendar.YEAR);
			newDate.add(Calendar.DAY_OF_MONTH,1);
		}
		return datesArray;
	}
	/*
	@method		Convert Date from String to Calendar object.
	@input			String in the form - 1-Jan-2000
	@output		Calendar object representation of @input.
	@desc			Assumption - Input string is in the format -> dd-MMM-yyyy

	 */
	public Calendar getDate(String date)
	{

		StringTokenizer stringArray = new StringTokenizer(date,"-");
		int[] dateArray = new int[stringArray.countTokens()];
		dateArray[0] = Integer.parseInt(stringArray.nextToken());	
		String s = stringArray.nextToken();
		for(int i=0;i<months.length;i++)
		{
			if(s.equalsIgnoreCase(months[i]))
			{
				dateArray[1] = i;
				break;
			}
		}
		dateArray[2] = Integer.parseInt(stringArray.nextToken());
		TimeZone timeZone = TimeZone.getTimeZone("Asia/Calcutta");
		TimeZone.setDefault(timeZone);
		Calendar cal = Calendar.getInstance();
		cal.set(dateArray[2],dateArray[1],dateArray[0]);
		return cal;
	}

	// The folllowing function basically converts calendar class to string in dd-mmm-yyyy format
	public String calToString (Calendar cal)
	{
		String  date = "";
		if (cal.get(Calendar.DATE) < 10)
		{
			date = date+ "0" + cal.get(Calendar.DATE);
		}
		else 
		{
			date = date + cal.get(Calendar.DATE);
		}
		return (date + "-" +months[cal.get(Calendar.MONTH)] + "-" +cal.get(Calendar.YEAR));
	}

	//The following function gives the next date 
	public Calendar getNextDate(Calendar cal)
	{
		cal.add(Calendar.DATE,1);
		return cal;
	}

	//The following function rturns true if the day of Calender is monday
	public boolean isMonday(Calendar cal)
	{
		if (cal.get(Calendar.DAY_OF_WEEK)==Calendar.MONDAY)
			return true;
		else 
			return false;
	}

	//The following function returns true if the day of Calender is sunday
	public boolean isSunday(Calendar cal)
	{
		if (cal.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY)

		{	
			return true;
		}
		else 		
		{
			return false;
		}

	}

	public boolean isSunday(String date)
	{
		Calendar cal1,cal2;
		setDate(date);
		cal2 = getDate();
		return isSunday(cal2);
	}

	//The following function gives the first monday  from the given Calendar  class
	public Calendar getFirstMonday(Calendar cal)
	{
		while (!isMonday(cal))
		{
			cal = getNextDate(cal);
		}
		return cal;
	}

	//The following function gives the first sunday  from the given Calendar  class
	public Calendar getFirstSunday(Calendar cal)
	{
		while (!isSunday(cal))
		{
			cal = getNextDate(cal);
		}
		return cal;
	}


	public Vector  getAllMondays(String dateFrom,String dateTo)
	{
		Vector mondays = new Vector(2,1);
		Calendar calDateFrom =getDate(dateFrom);
		Calendar calDateTo = getDate(dateTo);
		Calendar cal = calDateFrom ;
		cal = getFirstMonday(cal);
		while(cal.before(calDateTo))
		{
			mondays.addElement(calToString(cal));
			cal.add(Calendar.DATE,7);
		}
		return mondays;
	}

	// this function gives the sundays coming after the first monday
	public Vector getAllSundays(String dateFrom,String dateTo)
	{

		Vector sundays = new Vector(2,1);
		Calendar calDateFrom =getDate(dateFrom);
		Calendar calDateTo = getDate(dateTo);
		Calendar cal = calDateFrom ;
		cal = getFirstMonday(cal);
		cal.add(Calendar.DATE,6);		//get the sunday for that week
		while(cal.before(calDateTo))
		{
			sundays.addElement(calToString(cal));
			cal.add(Calendar.DATE,7);
		}
		return sundays;
	}

	// this function gives all sundays between two dates
	public Vector getSundays(String dateFrom,String dateTo)
	{
		Vector sundays = new Vector(2,1);
		Calendar calDateFrom =getDate(dateFrom);
		Calendar calDateTo = getDate(dateTo);
		Calendar cal = calDateFrom ;
		cal = getFirstSunday(cal);
		while(cal.before(calDateTo) || cal.equals(calDateTo))
		{
			sundays.addElement(calToString(cal));
			cal.add(Calendar.DATE,7);
		}

		return sundays;
	}

	public void calculateAbsentDate()
	{
		Calendar calDateFrom =  getDate(dateFrom);
		Calendar calDateTo = getDate(dateTo);
		Calendar cal = calDateFrom ;
		String strCal = "" ;
		String temp = "01-Jan-2001";  //Date is given for initialization purpose
		Calendar calTemp = getDate(temp);
		absentDate =  new Vector();
		int i=0 ; 
		boolean flag = true ;

		for (cal = calDateFrom ; cal.before(calDateTo) || cal.equals(calDateTo) ;)
		{
			strCal = calToString(cal);
			flag = true ; 
			for (i=0 ;i < presentDate.size(); i++)
			{
				temp = (presentDate.elementAt(i)).toString();
				calTemp = getDate(temp);
				temp = calToString(calTemp);
				if (strCal.equalsIgnoreCase(temp))
				{
					flag = false ; 
				}
			}
			if (flag)
			{
				absentDate.addElement(strCal);
			}
			cal.add(Calendar.DATE,1);
		}
	}

	/*public static void main(String[] args)
	{
		DateObject dtObj = new DateObject();

		DateObject dobj = new DateObject();
		dobj.setDate("5-sep-2000");
		Calendar cal = dobj.getDate();
		dobj.setEarlierDate(cal);

		dobj.setDate("05-Sep-2001");
		cal = dobj.getDate();
		dobj.setLaterDate(cal);
	}*/
}