package ibase.webitm.ejb.wsfa.transactions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSSender;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wsfa.WSFACommon;

//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgCustAddAprv implements StrgCustAddAprvLocal,StrgCustAddAprvRemote
{
	WSFACommon wsfaCommon = new WSFACommon();
	public String strgCustApprove(String tranID, String dcrID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Inside strgCustApprove()....." );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		String reportTo = "";

		ConnDriver connDriver = null;
		Connection conn = null;

		boolean isError = false;

		String empCode = "";//Added by kailash.

		String entityCode = "";//Added by kailash.
		try
		{
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			//conn.setAutoCommit(false);
			//connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(start)

			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(end)
			System.out.println("\nTRAN_ID = ["+tranID+"] \nDCR_ID=["+dcrID+"] \nSALES_PERS=["+salesPers+"]");

			//Added and modified by kailash on 17-12-18[start] 

			/*
			String getReportToSql = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ?";
			pStmt = conn.prepareStatement(getReportToSql);
			pStmt.setString(1, salesPers);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				reportTo = checkNull(rs.getString("REPORT_TO"));
			}*/

			String getSignBy = "SELECT EMP_CODE, ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'S'";
			pStmt = conn.prepareStatement(getSignBy);
			pStmt.setString(1, refSer);
			pStmt.setString(2, tranID);
			System.out.println("tranID["+getSignBy+"]refSer["+refSer+"]");

			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				empCode = rs.getString("EMP_CODE");
				entityCode = rs.getString("ENTITY_CODE");
				System.out.println("empCode["+empCode+"]entityCode["+entityCode+"]");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if ( empCode != null && empCode.trim().length() > 0 )
			{
				reportTo = empCode;
			}
			else
			{
				reportTo = entityCode;
			}

			System.out.println("reportTo =["+reportTo+"]");

			//Added and modified by kailash on 17-12-18[end]
			//Updating strg_cust_add table
			String updStrgCustSql = "UPDATE STRG_CUST_ADD SET WF_STATUS = 'A', EMP_CODE__APRV = ? WHERE TRAN_ID = ? ";

			pStmt = conn.prepareStatement(updStrgCustSql);
			pStmt.setString(1, reportTo);
			pStmt.setString(2, tranID);
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[STRG_CUST_ADD] =["+updCnt+"]");

			//Updating strg_meet table
			String updStrgMeetSql = "UPDATE STRG_MEET SET WF_STATUS = 'A', EMP_CODE__APRV = ? WHERE TRAN_ID = ? AND DCR_ID = ? AND SALES_PERS = ?";

			pStmt = conn.prepareStatement(updStrgMeetSql);
			pStmt.setString(1, reportTo);
			pStmt.setString(2, tranID);
			pStmt.setString(3, dcrID);
			pStmt.setString(4, salesPers);
			updCnt = pStmt.executeUpdate();

			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[STRG_MEET] =["+updCnt+"]");
			createStrgCustomerAndSeries(tranID, dcrID, salesPers, refSer, conn);
		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
	public String strgCustomerReject(String tranID, String dcrID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Inside strgCustomerReject()......" );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";

		ConnDriver connDriver = null;
		Connection conn = null;
		String signRemarks = "";
		boolean isError = false;
		try
		{
			/*			
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;*/
			//added by mrunalini sinkar on 27-April-2018(start)

			UserInfoBean userInfo = new UserInfoBean(userInfostr);

			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(end)

			String getReportToSql = "SELECT SIGN_REMARKS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? ";
			pStmt = conn.prepareStatement(getReportToSql);
			pStmt.setString(1, refSer);
			pStmt.setString(2, tranID);
			rs = pStmt.executeQuery();

			if(rs.next())
			{
				signRemarks = checkNull(rs.getString("SIGN_REMARKS"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("signRemarks =["+signRemarks+"]");
			//Updating strg_cust_add table
			String updStrgCustSql = "UPDATE STRG_CUST_ADD SET WF_STATUS = 'R', REMARKS = ? WHERE TRAN_ID = ? ";
			pStmt = conn.prepareStatement(updStrgCustSql);
			pStmt.setString(1, signRemarks);
			pStmt.setString(2, tranID);
			int updCnt = pStmt.executeUpdate();

			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[STRG_CUST_ADD] =["+updCnt+"]");

			//Updating strg_meet table

			String updStrgMeetSql = "UPDATE STRG_MEET SET WF_STATUS = 'R', REMARKS = ? WHERE TRAN_ID = ? AND DCR_ID = ? AND SALES_PERS = ?";
			pStmt = conn.prepareStatement(updStrgMeetSql);
			pStmt.setString(1, signRemarks);
			pStmt.setString(2, tranID);
			pStmt.setString(3, dcrID);
			pStmt.setString(4, salesPers);

			updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[STRG_MEET] =["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}

	public String createStrgCustomerAndSeries(String tranID, String dcrID, String salesPers, String refSer, Connection conn) throws ITMException
	{
		System.out.println("Inside createStrgCustomerAndSeries()......" );
		String sql = "";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		PreparedStatement pstmtStrgCustAdd = null;
		PreparedStatement pstmtShortId = null;
		PreparedStatement pstmtStrgCustIns = null;
		PreparedStatement pstmtStrgSerIns = null;
		PreparedStatement pstmtInsertStrgStatHist = null;
		ResultSet rsStrgCustAdd = null;
		ResultSet rsShortId = null;
		String retString = "";
		int shortId=0;
		String propValueAcct = "0415";
		String propValueCctr = "    ";
		String signRemarks = "";
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			java.sql.Timestamp eventDate = null;
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//added by mrunalini sinakr to set ACCT_CODE__AP,CCTR_CODE__AP,CURR_CODE values in strg customer table 05-07-2019(start)
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'ACCT_CODE__AP' AND ITEM_SER ='ALL' "  ;
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery(sql);	
			if(rs.next())
			{
				propValueAcct = rs.getString("PROP_VALUE") ==  null ? "0415" :rs.getString("PROP_VALUE");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'CCTR_CODE__AP' AND ITEM_SER ='ALL' "  ;

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery(sql);	
			if(rs.next())
			{
				propValueCctr = rs.getString("PROP_VALUE") ==  null ? "    " :rs.getString("PROP_VALUE");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			String currCode = "RS";
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'CURR_CODE_CUSTOMER' AND ITEM_SER ='ALL' "  ;

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery(sql);	
			if(rs.next())
			{
				currCode  = rs.getString("PROP_VALUE") ==  null ? "RS" :rs.getString("PROP_VALUE");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			String custCodeBill = getPropertyValue(salesPers,"CUST_CODE__BIL",conn);
			String groupCode = getPropertyValue(salesPers,"GROUP_CODE",conn);
			String cctrCodeAr = getPropertyValue(salesPers,"CCTR_CODE__AR",conn);
			String acctCodeAr = getPropertyValue(salesPers,"ACCT_CODE__AR",conn);

			//added by mrunalini sinakr to set values in strg customer table 05-07-2019(end)
			String mgrCode = getMGREmployee(salesPers, conn); 

			String stockistTable = getSfaParmValue(salesPers,"GET_STOCKIST_DETAILS",conn);

			//Change by sadique shaikh 04-03-2020 [unlisted customer event info realted changes]

			String getStrgCustAddSql ="";

			if(mgrCode.trim().length()!= 0)
			{
				 getStrgCustAddSql = "SELECT S.EVENT_DATE, S.SALES_PERS, S.STRG_CODE, S.ADDRESS_AS, S.STRG_NAME, S.STRG_TYPE,S.SPL_CODE, " +
							"S.GENDER, S.LOCALITY_CODE, S.ADDR1, S.ADDR2, S.ADDR3,S.AGE,S.QUALIFICATION , S.MOBILE_NO, S.EMAIL_ADDR, S.STRG_CLASS_CODE, L.DESCR,S.ROUTE_ID, " +//added by mrunalini sinkar for on 27-04-2019 adding route_id
							"L.STAN_CODE, L.STATE_CODE, L.PIN, L.COUNT_CODE, SP.ITEM_SER, SR.ROUTE_ID , SC.NO_VISIT , SC.MAX_INTERVAL_VISIT , SC.MIN_INTERVAL_VISIT , SC.CLASS_CODE_DESCR, " +
							"S.PIN AS PIN_CODE, S.SUBCLASS_CODE, S.PROMOTER_NAME, S.MAN_POWER, S.GST_NO,S.STRG_EVENT_INFO, S.REG_NO " + // added by rupali on 19/01/19 for adding new fields in realtime report
							"FROM STRG_MEET S LEFT OUTER JOIN STRG_CUST_CLASS SC ON S.STRG_CLASS_CODE= SC.CLASS_CODE AND S.STRG_TYPE = SC.CUST_TYPE, LOCALITY L, SALES_PERS SP, SPRS_ROUTE SR " +
							"WHERE S.LOCALITY_CODE = L.LOCALITY_CODE AND S.SPRS_CODE__WW = SR.SPRS_CODE AND S.LOCALITY_CODE = SR.LOCALITY_CODE AND TRAN_ID = ? AND S.SALES_PERS = SP.SALES_PERS AND S.ROUTE_ID = SR.ROUTE_ID ";

			}
			else
			{
				 getStrgCustAddSql = "SELECT S.EVENT_DATE, S.SALES_PERS, S.STRG_CODE, S.ADDRESS_AS, S.STRG_NAME, S.STRG_TYPE,S.SPL_CODE, " +
							"S.GENDER, S.LOCALITY_CODE, S.ADDR1, S.ADDR2, S.ADDR3,S.AGE,S.QUALIFICATION , S.MOBILE_NO, S.EMAIL_ADDR, S.STRG_CLASS_CODE, L.DESCR,S.ROUTE_ID, " +//added by mrunalini sinkar for on 27-04-2019 adding route_id
							"L.STAN_CODE, L.STATE_CODE, L.PIN, L.COUNT_CODE, SP.ITEM_SER, SR.ROUTE_ID , SC.NO_VISIT , SC.MAX_INTERVAL_VISIT , SC.MIN_INTERVAL_VISIT , SC.CLASS_CODE_DESCR, " +
							"S.PIN AS PIN_CODE, S.SUBCLASS_CODE, S.PROMOTER_NAME, S.MAN_POWER, S.GST_NO,S.STRG_EVENT_INFO, S.REG_NO " + // added by rupali on 19/01/19 for adding new fields in realtime report
							"FROM STRG_CUST_ADD S LEFT OUTER JOIN STRG_CUST_CLASS SC ON S.STRG_CLASS_CODE= SC.CLASS_CODE AND S.STRG_TYPE = SC.CUST_TYPE, LOCALITY L, SALES_PERS SP, SPRS_ROUTE SR " +
							"WHERE S.LOCALITY_CODE = L.LOCALITY_CODE AND S.SALES_PERS = SR.SPRS_CODE AND S.LOCALITY_CODE = SR.LOCALITY_CODE AND TRAN_ID = ? AND S.SALES_PERS = SP.SALES_PERS AND S.ROUTE_ID = SR.ROUTE_ID ";

			}

			pstmtStrgCustAdd = conn.prepareStatement(getStrgCustAddSql);
			pstmtStrgCustAdd.setString(1, tranID);
			rsStrgCustAdd = pstmtStrgCustAdd.executeQuery();
			if(rsStrgCustAdd.next())
			{
				String empFname = "";
				String empMname = "";
				String empLname = "";
				String noVisit="";
				String maxInterval ="";
				String minInterval = "";
				String classCodeDescr = "";

				eventDate = rsStrgCustAdd.getTimestamp("EVENT_DATE");
				String salesPersDb = checkNull(rsStrgCustAdd.getString("SALES_PERS"));
				String strgCode = checkNull(rsStrgCustAdd.getString("STRG_CODE"));
				String addressAs = checkNull(rsStrgCustAdd.getString("ADDRESS_AS"));
				String strgName = checkNull(rsStrgCustAdd.getString("STRG_NAME"));
				String strgType = checkNull(rsStrgCustAdd.getString("STRG_TYPE"));
				String gender = checkNull(rsStrgCustAdd.getString("GENDER"));
				String localityCode = checkNull(rsStrgCustAdd.getString("LOCALITY_CODE"));
				String routeId=checkNull(rsStrgCustAdd.getString("ROUTE_ID"));//added by mrunalini sinkar for on 27-04-2019 adding route_id
				String addr1 = checkNull(rsStrgCustAdd.getString("ADDR1"));
				String addr2 = checkNull(rsStrgCustAdd.getString("ADDR2"));
				String addr3 = checkNull(rsStrgCustAdd.getString("ADDR3"));
				String age = checkNull(rsStrgCustAdd.getString("AGE"));
				String qualification = checkNull(rsStrgCustAdd.getString("QUALIFICATION"));
				String mobileNo = checkNull(rsStrgCustAdd.getString("MOBILE_NO"));
				String emailAddr = checkNull(rsStrgCustAdd.getString("EMAIL_ADDR"));
				String stanCode = checkNull(rsStrgCustAdd.getString("STAN_CODE"));
				String stateCode = checkNull(rsStrgCustAdd.getString("STATE_CODE"));
				// commentted and added by rupali on 19/01/19 for adding new fields in realtime report [start]

				//String pin = checkNull(rsStrgCustAdd.getString("PIN"));

				String pin = checkNull(rsStrgCustAdd.getString("PIN_CODE"));
				// commentted and added by rupali on 19/01/19 for adding new fields in realtime report [end]

				String countCode = checkNull(rsStrgCustAdd.getString("COUNT_CODE"));
				String strgClassCode = checkNull(rsStrgCustAdd.getString("STRG_CLASS_CODE"));
				String itemSer = checkNull(rsStrgCustAdd.getString("ITEM_SER"));
				String routeID = checkNull(rsStrgCustAdd.getString("ROUTE_ID"));
				String splCode = checkNull(rsStrgCustAdd.getString("SPL_CODE"));
				maxInterval = checkNull(rsStrgCustAdd.getString("MAX_INTERVAL_VISIT"));
				minInterval = checkNull(rsStrgCustAdd.getString("MIN_INTERVAL_VISIT"));

				// added by rupali on 19/01/19 for adding new fields in realtime report [start]

				String subclassCode = checkNull(rsStrgCustAdd.getString("SUBCLASS_CODE"));
				String promoterName = checkNull(rsStrgCustAdd.getString("PROMOTER_NAME"));
				String gstNo = checkNull(rsStrgCustAdd.getString("GST_NO"));
				//Added by sadique shaikh 04-03-2020 [unlisted customer event info realted changes]
				String strgEventInfo = checkNull(rsStrgCustAdd.getString("STRG_EVENT_INFO"));
				int manPower = rsStrgCustAdd.getInt("MAN_POWER");
				String regNo = checkNull(rsStrgCustAdd.getString("REG_NO"));
				if(gender==null || gender.trim().length()==0)
				{
					gender="M";
				}
				// added by rupali on 19/01/19 for adding new fields in realtime report [end]
				if(mgrCode.trim().length()!= 0)
				{
					salesPersDb=checkNull(getSprsCodeWWFromCustomer(tranID,salesPersDb,conn));
				}
				System.out.println("salesPersDb[");
				//added by mrunalini sinkar to get count from strg_ser_class on 01-02-2019(start)

				int cnt = getCountFromSerClass(itemSer,strgClassCode,conn);
				if(cnt>0)
				{
					String serClasssql = " SELECT MIN_VISITS,DESCR FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
							" WHERE  C.CLASS_CODE= CS.CLASS_CODE AND C.CLASS_CODE = ? AND C.ACTIVE_YN='Y'  AND CS.ITEM_SER = ?   ";	
					PreparedStatement serClasspstmt = conn.prepareStatement(serClasssql);
					serClasspstmt.setString(1, strgClassCode);
					serClasspstmt.setString(2, itemSer);
					ResultSet serClassrs = serClasspstmt.executeQuery();					
					if( serClassrs.next() )
					{
						noVisit  = checkNull(serClassrs.getString("MIN_VISITS"));
						classCodeDescr = checkNull(serClassrs.getString("DESCR"));
					}
					if (serClassrs != null )
					{
						serClassrs.close();
						serClassrs = null;
					}
					if ( serClasspstmt != null )
					{
						serClasspstmt.close();
						serClasspstmt = null;
					}
				}
				else
				{
					noVisit = checkNull(rsStrgCustAdd.getString("NO_VISIT"));
					classCodeDescr = checkNull(rsStrgCustAdd.getString("CLASS_CODE_DESCR"));
				}
				//added by mrunalini sinkar to get count from strg_ser_class on 01-02-2019(end)

				if (strgType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
				{
					String shortIdSql = "SELECT MAX(SHORT_ID) AS SHORT_ID FROM SPRS_STOCKIST WHERE SPRS_CODE = ?";
					pstmtShortId = conn.prepareStatement(shortIdSql);
					pstmtShortId.setString(1, salesPersDb);
					rsShortId = pstmtShortId.executeQuery();
					if(rsShortId.next())
					{
						shortId = rsShortId.getInt("SHORT_ID");
						System.out.println("shortId is:"+shortId);
					}
					if( rsShortId != null )
					{
						rsShortId.close();
						rsShortId = null;
					}
					if(pstmtShortId != null)
					{
						pstmtShortId.close();
						pstmtShortId = null;
					}
					int newShortId = shortId+1;
					System.out.println("newShortId is:"+newShortId);
					String speciality="";
					if(splCode!=null && splCode.trim().length()>0 )
					{
						speciality=splCode;
					}
					else
					{
						speciality = checkNull(getSfaParmValue(salesPers,"DEF_SPL_CODE",conn));

					}
					System.out.println("speciality code:["+speciality+"]");

					String insertStrgCustSql = "INSERT INTO CUSTOMER(CUST_CODE, CUST_NAME, ADDR1, ADDR2, ADDR3, STAN_CODE, STATE_CODE, PIN, COUNT_CODE, EMAIL_ADDR, LOCALITY_CODE, CUST_TYPE, CHG_DATE,CHG_USER, CHG_TERM, CURR_CODE, "+
							"CURR_CODE__INS,CURR_CODE__FRT,ROUND_TO,ROUND,CONTACT_CODE,CREDIT_LMT,CUST_CODE__BIL,GROUP_CODE,CCTR_CODE__ADV,ACCT_CODE__ADV,IGNORE_CREDIT,SALES_PERS,CCTR_CODE__AR,ACCT_CODE__AR,SH_NAME,BLACK_LISTED) "+
							"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
					pstmtStrgCustIns = conn.prepareStatement(insertStrgCustSql);
					pstmtStrgCustIns.setString(1, strgCode);
					pstmtStrgCustIns.setString(2, strgName);
					pstmtStrgCustIns.setString(3, addr1);
					pstmtStrgCustIns.setString(4, addr2);
					pstmtStrgCustIns.setString(5, addr3);
					pstmtStrgCustIns.setString(6, stanCode);
					pstmtStrgCustIns.setString(7, stateCode);
					pstmtStrgCustIns.setString(8, pin);
					pstmtStrgCustIns.setString(9, countCode);
					pstmtStrgCustIns.setString(10, emailAddr);
					pstmtStrgCustIns.setString(11, localityCode);
					pstmtStrgCustIns.setString(12, strgType);
					pstmtStrgCustIns.setTimestamp(13, java.sql.Timestamp.valueOf(currDate));
					pstmtStrgCustIns.setString(14, "SYSTEM");
					pstmtStrgCustIns.setString(15, "SYSTEM");
					pstmtStrgCustIns.setString(16, currCode);

					pstmtStrgCustIns.setString(17, currCode);
					pstmtStrgCustIns.setString(18, currCode);
					pstmtStrgCustIns.setString(19, "1");
					pstmtStrgCustIns.setString(20, "N");
					pstmtStrgCustIns.setString(21, salesPersDb);
					pstmtStrgCustIns.setString(22, "99999999999.999");
					pstmtStrgCustIns.setString(23, custCodeBill);
					pstmtStrgCustIns.setString(24, groupCode);
					pstmtStrgCustIns.setString(25, propValueAcct);
					pstmtStrgCustIns.setString(26, propValueCctr);
					pstmtStrgCustIns.setString(27, "99999999999");
					pstmtStrgCustIns.setString(28, salesPersDb);
					pstmtStrgCustIns.setString(29, cctrCodeAr);
					pstmtStrgCustIns.setString(30, acctCodeAr);
					pstmtStrgCustIns.setString(31, addressAs);
					pstmtStrgCustIns.setString(32, "N");

					int strgCustInsCount = pstmtStrgCustIns.executeUpdate();
					pstmtStrgCustIns.clearParameters();

					System.out.println("Insert into CUSTOMER [strgCustInsCount] =["+strgCustInsCount+"]");

					String insertSergSerSql = "INSERT INTO SPRS_STOCKIST(SPRS_CODE,CUST_CODE,ROUTE_ID,CHG_DATE,CHG_USER,CHG_TERM,STATUS,SHORT_ID,REPLY_STATUS) "+
							"VALUES(?,?,?,?,?,?,?,?,?)";
					pstmtStrgSerIns = conn.prepareStatement(insertSergSerSql);
					pstmtStrgSerIns.setString(1, salesPersDb);
					pstmtStrgSerIns.setString(2, strgCode);
					pstmtStrgSerIns.setString(3, routeId);
					pstmtStrgSerIns.setTimestamp(4, java.sql.Timestamp.valueOf(currDate));
					pstmtStrgSerIns.setString(5, "SYSTEM");
					pstmtStrgSerIns.setString(6, "SYSTEM");
					pstmtStrgSerIns.setString(7, "Y");
					pstmtStrgSerIns.setInt(8, newShortId);
					pstmtStrgSerIns.setString(9, "0");

					int strgSerInsCount = pstmtStrgSerIns.executeUpdate();
					pstmtStrgSerIns.clearParameters();

					System.out.println("Insert into SPRS_STOCKIST [strgSerInsCount] =["+strgSerInsCount+"]");
				}
				else
				{
					if(strgName.length() > 0 && strgName.indexOf(" ") != -1)
					{
						empFname = strgName.substring(0, strgName.indexOf(" "));
						strgName = strgName.substring(strgName.indexOf(" ")+1);
						if(strgName.indexOf(" ") != -1)
						{
							empLname = strgName.substring(strgName.lastIndexOf(" ")+1 );
							empMname = strgName.substring(0, strgName.lastIndexOf(" "));
						}
						else
						{
							empLname = strgName;
						}
					}
					else
					{
						empFname = strgName;
					}
					// added by mrunalini sinkar on 20-july-2017 to add SHOERT_ID,MAX_INTERVAL_VISIT,MIN_INTERVAL_VISIT,NO_VISIT(START)
					String shortIdSql = " SELECT MAX(SHORT_ID) AS SHORT_ID FROM STRG_SERIES WHERE SALES_PERS= ?";
					pstmtShortId = conn.prepareStatement(shortIdSql);
					pstmtShortId.setString(1, salesPersDb);
					rsShortId = pstmtShortId.executeQuery();
					if(rsShortId.next())
					{
						shortId = rsShortId.getInt("SHORT_ID");
						System.out.println("shortId is:"+shortId);
					}
					if( rsShortId != null )
					{
						rsShortId.close();
						rsShortId = null;
					}
					if(pstmtShortId != null)
					{
						pstmtShortId.close();
						pstmtShortId = null;
					}
					int newShortId = shortId+1;
					System.out.println("newShortId is:"+newShortId);
					//added by mrunalini sinkar on 20-july-2017 to add SHOERT_ID,MAX_INTERVAL_VISIT,MIN_INTERVAL_VISIT,NO_VISIT(END)
					// added by mrunalini sinkar to insert spl_code in strg_series (start)
					String speciality="";
					if(splCode!=null && splCode.trim().length()>0 )
					{
						speciality=splCode;
					}
					else
					{
						speciality = checkNull(getSfaParmValue(salesPers,"DEF_SPL_CODE",conn));

					}
					System.out.println("speciality code:["+speciality+"]");
					// added by mrunalini sinkar to insert spl_code in strg_series (end)
					String insertStrgCustSql = "INSERT INTO STRG_CUSTOMER(SC_CODE, FIRST_NAME, MIDDLE_NAME, LAST_NAME, ADDRESS_AS, ADDR1, ADDR2, ADDR3, STAN_CODE," +
							" STATE_CODE, PIN, COUNT_CODE, MOBILE_NO, SEX, EMAIL_ADDR, LOCALITY_CODE, CUST_TYPE, STATUS, CLASS_CODE,CHG_DATE, CHG_USER, CHG_TERM, SUBCLASS_CODE, PROMOTER_NAME, GST_NO, MAN_POWER,ACCT_CODE__AP,CCTR_CODE__AP,CURR_CODE, REG_NO,AGE,QUALIFICATION)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
					pstmtStrgCustIns = conn.prepareStatement(insertStrgCustSql);
					pstmtStrgCustIns.setString(1, strgCode);
					pstmtStrgCustIns.setString(2, empFname);
					pstmtStrgCustIns.setString(3, empMname);
					pstmtStrgCustIns.setString(4, empLname);
					pstmtStrgCustIns.setString(5, addressAs);
					pstmtStrgCustIns.setString(6, addr1);
					pstmtStrgCustIns.setString(7, addr2);
					pstmtStrgCustIns.setString(8, addr3);
					pstmtStrgCustIns.setString(9, stanCode);
					pstmtStrgCustIns.setString(10, stateCode);
					pstmtStrgCustIns.setString(11, pin);
					pstmtStrgCustIns.setString(12, countCode);
					pstmtStrgCustIns.setString(13, mobileNo);
					pstmtStrgCustIns.setString(14, gender);
					pstmtStrgCustIns.setString(15, emailAddr);
					pstmtStrgCustIns.setString(16, localityCode);
					pstmtStrgCustIns.setString(17, strgType);
					pstmtStrgCustIns.setString(18, "A");
					pstmtStrgCustIns.setString(19, strgClassCode);
					pstmtStrgCustIns.setTimestamp(20, java.sql.Timestamp.valueOf(currDate));
					pstmtStrgCustIns.setString(21, "SYSTEM");
					pstmtStrgCustIns.setString(22, "SYSTEM");
					// added by rupali on 19/01/19 for adding new fields in realtime report [start]
					pstmtStrgCustIns.setString(23, subclassCode);
					pstmtStrgCustIns.setString(24, promoterName);
					pstmtStrgCustIns.setString(25, gstNo);
					pstmtStrgCustIns.setInt(26, manPower);
					pstmtStrgCustIns.setString(27, propValueAcct);
					pstmtStrgCustIns.setString(28, propValueCctr);
					pstmtStrgCustIns.setString(29, currCode);
					pstmtStrgCustIns.setString(30, regNo);
					pstmtStrgCustIns.setString(31,age);
					pstmtStrgCustIns.setString(32,qualification);
					// added by rupali on 19/01/19 for adding new fields in realtime report [end]

					int strgCustInsCount = pstmtStrgCustIns.executeUpdate();
					pstmtStrgCustIns.clearParameters();
					
					//Added by sadique shaikh 04-03-2020 [Insert event info data into events table]
					setStrgEventsData(strgEventInfo, strgCode, salesPersDb, conn);

					System.out.println("Insert into STRG_CUSTOMER [strgCustInsCount] =["+strgCustInsCount+"]");

					String insertSergSerSql = "INSERT INTO STRG_SERIES(SC_CODE, ITEM_SER, SALES_PERS, CLASS_CODE, NO_VISIT, CUST_TYPE, EFF_DATE, ROUTE_ID, STATUS, LOCALITY_CODE, MAX_INTERVAL_VISIT, MIN_INTERVAL_VISIT, CLASS_CODE_DESCR, SHORT_ID, SPL_CODE ,CHG_DATE, CHG_USER, CHG_TERM, SUBCLASS_CODE,CHG_TYPE)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmtStrgSerIns = conn.prepareStatement(insertSergSerSql);
					pstmtStrgSerIns.setString(1, strgCode);
					pstmtStrgSerIns.setString(2, itemSer);
					pstmtStrgSerIns.setString(3, salesPersDb);
					pstmtStrgSerIns.setString(4, strgClassCode);
					pstmtStrgSerIns.setString(5, noVisit);
					pstmtStrgSerIns.setString(6, strgType);
					pstmtStrgSerIns.setTimestamp(7, eventDate);
					pstmtStrgSerIns.setString(8, routeId);
					pstmtStrgSerIns.setString(9, "Y");
					pstmtStrgSerIns.setString(10, localityCode);
					pstmtStrgSerIns.setString(11, maxInterval);
					pstmtStrgSerIns.setString(12, minInterval);
					pstmtStrgSerIns.setString(13, classCodeDescr);
					pstmtStrgSerIns.setInt(14, newShortId);
					pstmtStrgSerIns.setString(15, speciality);
					pstmtStrgSerIns.setTimestamp(16, java.sql.Timestamp.valueOf(currDate));
					pstmtStrgSerIns.setString(17, "SYSTEM");
					pstmtStrgSerIns.setString(18, "SYSTEM");
					pstmtStrgSerIns.setString(19, subclassCode); // added by rupali on 19/01/19 for adding new fields in realtime report
					pstmtStrgSerIns.setString(20, "T");
					int strgSerInsCount = pstmtStrgSerIns.executeUpdate();
					pstmtStrgSerIns.clearParameters();

					System.out.println("Insert into STRG_SERIES [strgSerInsCount] =["+strgSerInsCount+"]");

					String tranIdStatHist = generateTranID( conn ) ;

					//Calculation of validupto
					Calendar cal = Calendar.getInstance();
					cal.setTime( eventDate );
					cal.add( Calendar.YEAR , 10 );
					String validUpto = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					String insertStrgStatHistSql ="INSERT INTO STRG_STATUS_HIST(TRAN_ID, TRAN_DATE, SALES_PERS, SC_CODE, CUST_TYPE, ITEM_SER, ROUTE_ID, "+
							"EFF_FROM , VALID_UPTO, STATUS, CHG_DATE , CHG_USER, CHG_TERM, EDITFLAG) "+
							"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

					pstmtInsertStrgStatHist = conn.prepareStatement(insertStrgStatHistSql);
					pstmtInsertStrgStatHist.setString(1, tranIdStatHist);
					pstmtInsertStrgStatHist.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
					pstmtInsertStrgStatHist.setString(3, salesPersDb);
					pstmtInsertStrgStatHist.setString(4, strgCode);
					pstmtInsertStrgStatHist.setString(5, strgType);
					pstmtInsertStrgStatHist.setString(6, itemSer);
					pstmtInsertStrgStatHist.setString(7, routeID);
					pstmtInsertStrgStatHist.setTimestamp(8, eventDate);
					pstmtInsertStrgStatHist.setTimestamp(9, java.sql.Timestamp.valueOf(validUpto));
					pstmtInsertStrgStatHist.setString(10, "Y");
					pstmtInsertStrgStatHist.setTimestamp(11, java.sql.Timestamp.valueOf(currDate) );
					pstmtInsertStrgStatHist.setString(12, "SYSTEM");
					pstmtInsertStrgStatHist.setString(13, "SYSTEM");
					pstmtInsertStrgStatHist.setString(14, "A");

					int strgSerHistInsCount = pstmtInsertStrgStatHist.executeUpdate();
					pstmtInsertStrgStatHist.clearParameters();

					System.out.println("Insert into STRG_STATUS_HIST [strgSerHistInsCount] =["+strgSerHistInsCount+"]");
					//Added by Bhagyashri t after approval insert into ENTITY_CONTACT[01/02/22][START][W21JFOR007]
					String isFortuneAct =getSfaParmValue(salesPers,"IS_FORTUNE_ACTIVITY",conn);
					System.out.println("updCnt[STRG_MEET]  isFortuneAct=["+isFortuneAct+"]");
					System.out.println("updCnt[STRG_MEET]  StrgCode is=["+strgCode+"]");
					if("Y".equalsIgnoreCase(isFortuneAct))
					{
						PreparedStatement pstmt1 = null;
						PreparedStatement pstmt2 = null;
						ResultSet rs1 = null;
						String strgCd= "";
						String sql1="SELECT SCA.STRG_CODE AS STRG_CODE FROM STRG_CUST_ADD SCA,STRG_MEET SM WHERE " +
								" SM.STRG_CODE=SCA.STRG_CODE AND SM.CONTACT_PERS IS NOT NULL AND SM.DCR_ID=SCA.DCR_ID AND SCA.DCR_ID= ? AND SM.STRG_CODE= ?";
						pstmt1 =  conn.prepareStatement(sql1);
						pstmt1.setString(1,dcrID);
						pstmt1.setString(2,strgCode);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							strgCd=rs1.getString("STRG_CODE").trim();
							String insertSql= "";
							insertSql = " INSERT INTO ENTITY_CONTACT(ENTITY_TYPE, ENTITY_CODE, CONTACT_PERS,CONTACT_PERS_NAME, ADDR1, ADDR2, " +
									" ADDR3, EMAIL_ID, MOBILE_NO,PIN )" +
								//Changes made by Rahul P. on 27-Sep-2023 [Start] set ENTITY_TYPE='R'
								//" (SELECT 'C' AS ENTITY_TYPE, STRG_CODE, CONTACT_PERS, CONTACT_PERS_NAME, ADDR1, ADDR2, " +
								" (SELECT 'R' AS ENTITY_TYPE, STRG_CODE, CONTACT_PERS, CONTACT_PERS_NAME, ADDR1, ADDR2, " +
								//Changes made by Rahul P. on 27-Sep-2023 [End]
								" ADDR3, EMAIL_ADDR, MOBILE_NO,PIN" +
									" FROM STRG_MEET " +
									" WHERE DCR_ID = ? AND STRG_CODE= ?)";
							pstmt2 = conn.prepareStatement(insertSql);
							pstmt2.setString(1, dcrID);
							pstmt2.setString(2, strgCd);
							int strgCustCnt = pstmt2.executeUpdate();
							if(strgCustCnt > 0)
							{
								System.out.println("ENTITY_CONTACT Inserted Successfully =["+strgCustCnt+"]");
							}
							if ( pstmt2 != null )
							{
								pstmt2.close();
								pstmt2= null;
							}
						}
						if(rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
						System.out.println("Created strg_code ArrayList is["+strgCd+"]");
					}
					//Added by Bhagyashri t after approval insert into ENTITY_CONTACT[01/02/22][END]
					
				}
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rsStrgCustAdd != null )
				{
					rsStrgCustAdd.close();
					rsStrgCustAdd = null;
				}
				if( rsShortId != null )
				{
					rsShortId.close();
					rsShortId = null;
				}
				if(pstmtStrgCustAdd != null)
				{
					pstmtStrgCustAdd.close();
					pstmtStrgCustAdd = null;
				}
				if(pstmtStrgCustIns != null)
				{
					pstmtStrgCustIns.close();
					pstmtStrgCustIns = null;
				}
				if(pstmtStrgSerIns != null)
				{
					pstmtStrgSerIns.close();
					pstmtStrgSerIns = null;
				}
				if(pstmtInsertStrgStatHist != null)
				{
					pstmtInsertStrgStatHist.close();
					pstmtInsertStrgStatHist = null;
				}
				if(pstmtShortId != null)
				{
					pstmtShortId.close();
					pstmtShortId = null;
				}
			}
			catch(Exception e)
			{
			}
		}

		return retString;
	}
	private String generateTranID( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 't_strg_series_st' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//Added by kailash for customer approve for HO user[start]
	public String strgCustApproveManager(String tranID, String dcrID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Inside strgCustApproveHoUser()....." );
		String retString ="";
		String itemSer ="", hoEmpCode ="";
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String reportTo = "";
		Connection conn = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;

			String getReportToSql = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ?";
			pStmt = conn.prepareStatement(getReportToSql);
			pStmt.setString(1, salesPers);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				reportTo = checkNull(rs.getString("REPORT_TO"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println("reportTo =["+reportTo+"]");
			//Updating strg_cust_add table
			String updStrgCustSql = "UPDATE STRG_CUST_ADD SET WF_STATUS = '', EMP_CODE__APRV = ? WHERE TRAN_ID = ? ";

			pStmt = conn.prepareStatement(updStrgCustSql);
			pStmt.setString(1, reportTo);
			pStmt.setString(2, tranID);
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println("updCnt[STRG_CUST_ADD] =["+updCnt+"]");

			String updStrgMeetSql = "UPDATE STRG_MEET SET WF_STATUS = '', EMP_CODE__APRV = ? WHERE TRAN_ID = ? AND DCR_ID = ? AND SALES_PERS = ?";

			pStmt = conn.prepareStatement(updStrgMeetSql);
			pStmt.setString(1, reportTo);
			pStmt.setString(2, tranID);
			pStmt.setString(3, dcrID);
			pStmt.setString(4, salesPers);
			updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[STRG_MEET] =["+updCnt+"]");
			System.out.println("salesPers>>>["+salesPers+"]");
			hoEmpCode = checkNull(getSfaParmValue(salesPers,"DAR_DIVISION_HO",conn));
			System.out.println("hoEmpCode>>["+hoEmpCode+"]");
			if (hoEmpCode != null && hoEmpCode.trim().length() > 0)
			{
				retString ="Y";
			}
			else
			{
				System.out.println("Inside else of strgCustApproveHoUser");
				retString ="N";
				String updCustSql = "UPDATE STRG_CUST_ADD SET WF_STATUS = 'A', EMP_CODE__APRV = ? WHERE TRAN_ID = ? ";

				pStmt = conn.prepareStatement(updCustSql);
				pStmt.setString(1, reportTo);
				pStmt.setString(2, tranID);
				int updCustCount = pStmt.executeUpdate();
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("updCnt[STRG_CUST_ADD723] =["+updCustCount+"]");

				String updMeetSql = "UPDATE STRG_MEET SET WF_STATUS = 'A', EMP_CODE__APRV = ? WHERE TRAN_ID = ? AND DCR_ID = ? AND SALES_PERS = ?";

				pStmt = conn.prepareStatement(updMeetSql);
				pStmt.setString(1, reportTo);
				pStmt.setString(2, tranID);
				pStmt.setString(3, dcrID);
				pStmt.setString(4, salesPers);
				int updMeetCount = pStmt.executeUpdate();
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				System.out.println("updCnt[updMeetCount] =["+updMeetCount+"]");
				createStrgCustomerAndSeries(tranID, dcrID, salesPers, refSer, conn);
			}
			System.out.println("itemSer:>>["+itemSer+"]hoEmpCode::["+hoEmpCode+"]retString["+retString+"]");
		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception strgCustApproveManager(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull(allRs.getString(1));
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	//Added by kailash for customer approve for HO user[end]
	//added by mrunalii sinkar to cehck manager approval is compulsory or not

	public String CheckMangerApprover(String tranID, String dcrID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Manager approval compulsory or not");
		String reString="N";
		Connection conn = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;

			String mgrAprvCompu = checkNull(getSfaParmValue(salesPers,"MGR_APRV_COUMP",conn));
			System.out.println("mgrAprvCompu>>["+mgrAprvCompu+"]");
			if (mgrAprvCompu.equalsIgnoreCase("Y"))
			{
				reString ="Y";
			}
			else
			{
				reString ="N";
			}
		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception strgCustApproveManager(String) :==>\n"+e.getMessage());
			}

		}



		return reString;

	}

	//added by mrunalini sinkar to get count from strg_ser_class on 01-02-2019(start)

	public int getCountFromSerClass(String division, String classCode,Connection con)
	{
		PreparedStatement pstmt= null;
		ResultSet rs = null;

		int count=0;
		try
		{
			String sql = " SELECT COUNT(*) AS COUNT FROM STRG_CLASS C , STRG_SER_CLASS CS  " +
					" WHERE  C.CLASS_CODE= CS.CLASS_CODE AND C.CLASS_CODE = ? AND C.ACTIVE_YN='Y'  AND CS.ITEM_SER = ?   ";	
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, classCode);
			pstmt.setString(2, division);
			rs = pstmt.executeQuery();					
			if( rs.next() )
			{
				count  = rs.getInt("COUNT");
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		System.out.println("class count is:["+count+"]");
		return count;
	}
	//added by mrunalini sinkar to get count from strg_ser_class on 01-02-2019(end)
	public String checkHoExist(String tranID, String dcrID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Inside strgCustApprove()....." );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		String reportTo = "";

		ConnDriver connDriver = null;
		Connection conn = null;

		boolean isError = false;
		String empCode = "";//Added by kailash.
		String entityCode = "";//Added by kailash.

		try
		{
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			//conn.setAutoCommit(false);
			//connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(start)
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			//added by mrunalini sinkar on 27-April-2018(end)

			String hoEmpCode = checkNull(getSfaParmValue(salesPers,"DAR_DIVISION_HO",conn));
			System.out.println("hoEmpCode>>["+hoEmpCode+"]");
			if (hoEmpCode != null && hoEmpCode.trim().length() > 0)
			{
				retString ="Y";
			}
			else
			{
				retString ="N";
			}

		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return retString;
	}
	public String getPropertyValue(String userId,String propName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String itemSer = "";
		String propValue ="";
		boolean isLocalConn = false;
		String sql = "";
		try
		{
			String getSalesPerData = "SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					"WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? AND ITEM_SER = ?";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, propName);
			pstmt.setString(2, itemSer);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				propValue  = checkNull(rs.getString(1));
			}
			else
			{
				System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, propName);
				pstmt1.setString(2, "ALL");
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					propValue  = checkNull(rs1.getString(1));
				}

				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of propValue is::........."+propValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return propValue;
	}

	//Added by sadique shaikh 04-03-2020 [Insert event info data into events table] Start
	private void setStrgEventsData(String strgEventInfo,String strgCode,String salesPers,Connection conn)
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		PreparedStatement pstmtInsertStrgEvent = null;
		try 
		{
			if(strgEventInfo != null && strgEventInfo.trim().length() !=0)
			{
				org.json.JSONObject strgEventjson = new org.json.JSONObject(strgEventInfo);
				Timestamp eventDate = null;
				for (int i = 1; i <= strgEventjson.length()/2; i++) 
				{
					String insertStrgEventSql ="insert into STRG_EVENTS(SC_CODE,EVENT_CODE,EVENT_DATE,DESCR,CHG_USER,CHG_DATE,CHG_TERM,LINE_NO) values(?,?,?,?,?,?,?,?)";
					
					if(strgEventjson.getString("event_dt"+i).length() != 0)
					{
						
						eventDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(strgEventjson.getString("event_dt"+i),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.00");
					}
					else
					{
						eventDate = null;
						
					}
					pstmtInsertStrgEvent = conn.prepareStatement(insertStrgEventSql);
					pstmtInsertStrgEvent.setString(1, checkNull(strgCode));
					pstmtInsertStrgEvent.setString(2, checkNull(strgEventjson.getString("event_"+i)) );
					pstmtInsertStrgEvent.setTimestamp(3, eventDate);
					pstmtInsertStrgEvent.setString(4, checkNull(strgEventjson.getString("event_"+i)));
					pstmtInsertStrgEvent.setString(5, salesPers);
					pstmtInsertStrgEvent.setTimestamp(6, eventDate);
					pstmtInsertStrgEvent.setString(7, salesPers);
					pstmtInsertStrgEvent.setInt(8, i);
					int insertStrgEventCount = pstmtInsertStrgEvent.executeUpdate();
					System.out.println("insertStrgEventCount ["+insertStrgEventCount+"]");

				}
				
			}
			
		} 
		catch (Exception e) 
		{
			System.out.println("StrgCustAddAprv.setStrgEventsData()["+e.getMessage()+"]");
		}
		finally 
		{
			try {
				if ( pstmtInsertStrgEvent != null ) //Changed By Nilesh for nullpointer exception Start ::06-04-2020
				{
					pstmtInsertStrgEvent.close();
					pstmtInsertStrgEvent= null;
				}	
				//Changed By Nilesh for nullpointer exception End ::06-04-2020
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	//Added by sadique shaikh 04-03-2020 [Insert event info data into events table] End
	//Added by Bhagyashri T For Checking approver is HO or not[26/04/21][START][W21ASUN046]
	public String findNextApproverConf(String refSer, String refId, String salesPers, String currApprover, String xmlString ,String userInfoStr ) throws RemoteException, ITMException
	{
		System.out.println("findNextApproverConf is called......");
		Connection conn = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtEmp = null;
		PreparedStatement pstmtobjSign = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rsEmp = null;
		ResultSet rsObjSign = null;
		String nextAprvr = "";
		String reportTo = "";
		String entityCode = "";
		String gradeLevel ="";
		boolean isHOF=false;
		java.sql.Date relieveDate = null;
		boolean isError = false;
		
		try 
		{
			System.out.println("refSer =["+refSer+"], refId =["+refId+"], salesPers =["+salesPers+"], currApprover =["+currApprover+"]");
			String transDB = "";
		      System.out.println("Inside STRGSERIESConfirm confirm section: " + userInfoStr);
		      connDriver = new ConnDriver();
		      UserInfoBean userInfo = new UserInfoBean(userInfoStr);
		      if (userInfo != null)
		      {
		        transDB = userInfo.getTransDB();
		      }
		      System.out.println("get TransDB connection in STRGSERIESConfirm : " + transDB);
	
		      if ((transDB != null) && (transDB.trim().length() > 0))
		      {
		        conn = connDriver.getConnectDB(transDB);
		      }
		      else
		      {
		        conn = connDriver.getConnectDB("DriverITM");
		      }
				conn.setAutoCommit(false);
				String signTransSql = "SELECT ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS ='S' AND LINE_NO = (SELECT MAX(LINE_NO) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS ='S')";
				pstmtobjSign = conn.prepareStatement(signTransSql);
				pstmtobjSign.setString(1, refSer);
				pstmtobjSign.setString(2, refId);
				pstmtobjSign.setString(3, refSer);
				pstmtobjSign.setString(4, refId);
				rsObjSign = pstmtobjSign.executeQuery();
				if(rsObjSign.next())
				{
					entityCode = checkNull(rsObjSign.getString("ENTITY_CODE"));
				}
				if (rsObjSign != null)
				{
					rsObjSign.close();
					rsObjSign = null;
				}
				if ( pstmtobjSign != null )
				{
					pstmtobjSign.close();
					pstmtobjSign = null;
				}
				System.out.println("entityCode =["+entityCode+"]");
				//isHOF=isHOEmployee(userId);
				String empSql = "SELECT TRIM(REPORT_TO) AS REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtEmp = conn.prepareStatement(empSql);
				pstmtEmp.setString(1, entityCode);
				rsEmp = pstmtEmp.executeQuery();
				if(rsEmp.next())
				{
					reportTo = checkNull(rsEmp.getString("REPORT_TO"));
					
				if(rsEmp != null)
				{
					rsEmp.close();
					rsEmp = null;
				}
				if(pstmtEmp != null)
				{
					pstmtEmp.close();
					pstmtEmp = null;
				}

				System.out.println("Report to CONF =["+reportTo+"]");
				if (reportTo == null || reportTo.trim().length() == 0)
				{
					nextAprvr = "NO"; //Report_To is HO
				}
				else
				{
					String sql=" SELECT TRIM(GRADE.LEVEL_NO) AS APRV_LEVEL FROM GRADE GRADE, EMPLOYEE EMP WHERE EMP.GRADE = GRADE.GRADE_CODE"
							+ " AND EMP.EMP_CODE = ? AND RELIEVE_DATE IS NULL ";
						
					pstmtEmp = conn.prepareStatement(sql);
					pstmtEmp.setString(1, reportTo);
					rsEmp = pstmtEmp.executeQuery();
					if(rsEmp.next())
					{
						gradeLevel = checkNull(rsEmp.getString("APRV_LEVEL"));
					}
					if(rsEmp != null)
					{
						rsEmp.close();
						rsEmp = null;
					}
					if(pstmtEmp != null)
					{
						pstmtEmp.close();
						pstmtEmp = null;
					}
					System.out.println("gradeLevel CONF =["+gradeLevel+"]");
					if (gradeLevel == null || gradeLevel.trim().length() == 0)
					{
						nextAprvr = "NO"; //Report_To is HO 
					}
					else
					{
						if(gradeLevel.equalsIgnoreCase("1") || gradeLevel.equalsIgnoreCase("2") || gradeLevel.equalsIgnoreCase("3") || gradeLevel.equalsIgnoreCase("4"))
						{
							nextAprvr = "YES";
						}
						else
						{
							nextAprvr = "NO";    //Report_To is HO
						}
					}
				}	
			}
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if(rsEmp != null)
				{
					rsEmp.close();
					rsEmp = null;
				}
				if(rsObjSign != null)
				{
					rsObjSign.close();
					rsObjSign = null;
				}
				if(pstmtEmp != null)
				{
					pstmtEmp.close();
					pstmtEmp = null;
				}
				if(pstmtobjSign != null)
				{
					pstmtobjSign.close();
					pstmtobjSign = null;
				}
				if(conn != null)
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				
			}
		}
		System.out.println("nextAprvrCONF =["+nextAprvr+"]");
		return nextAprvr;	
	}
	//Added by Bhagyashri T For Checking approver is HO or not[26/04/21][end][W21ASUN046]
	public String getMGREmployee(String empCode,Connection con) throws ITMException
	{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String empCodeMGR = "";
			String selectSql = "";
			try
			{
				selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

				pstmt = con.prepareStatement(selectSql);
				pstmt.setString(1, empCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					empCodeMGR = checkNull(rs.getString("EMP_CODE"));
				}
				rs.close();
			} catch (Exception e)
			{
				throw new ITMException(e);
			} finally
			{
				try
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				} 
				catch (Exception e1){}
			}
			return empCodeMGR;
		}
	 public String getSprsCodeWWFromCustomer( String tranID, String salesPersDb,Connection connectionObject )throws ITMException
		{
			String sql = "";
			String sprsCodeWW = "";
			PreparedStatement pstmt = null;
			ResultSet rs = null ;
			try
			{
				

				sql = "SELECT SPRS_CODE__WW FROM STRG_MEET WHERE TRAN_ID=?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, tranID);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(sprsCodeWW == null || sprsCodeWW.trim().length()==0)
				{
					sprsCodeWW=salesPersDb;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e); 

			}
			finally
			{
				try
				{
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}

			return sprsCodeWW;
		}
	 //Added by Bhagyashri T for Wrkflw Aprrove by Second approver[21-11-2022][start]
	public String invoiceStockApprove(String tranID, String dcrID, String salesPers, String refSer,String userInfostr,String xmlData) throws ITMException
	{
		System.out.println("Inside invoiceStockApprove()....." );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		String reportTo = "";

		ConnDriver connDriver = null;
		Connection conn = null;
		boolean isError = false;
		String empCode = "";
		String entityCode = "";
		String getTranId = "";
		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			String eventDate="";
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pStmt =  conn.prepareStatement(sprsSql);
			pStmt.setString(1, dcrID);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt!=null)
			{
				pStmt.close();
				pStmt = null;
			}
			/* -- Commented and changed by Gulzar on 16DEC23 - if more than one load is created in the same day.
			String maxDaySummDate="";
			String minDaySummDate="";

			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pStmt =  conn.prepareStatement(daySummMaxSQL);
			pStmt.setString(1, salesPers);
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt!=null)
			{
				pStmt.close();
				pStmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE >? ";
			pStmt =  conn.prepareStatement(daySummMinSQL);
			pStmt.setString(1, salesPers);
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt!=null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{
				minCon=" AND EVENT_DATE< ? ";
			}
			ArrayList<String> dcrIdList =new ArrayList<String>();

			String getTranId = "SELECT DCR_ID FROM  STRG_MEET WHERE EVENT_DATE >= ?  "+
					minCon+" "+
					" AND SALES_PERS =? ";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");

			pStmt = conn.prepareStatement(getTranId);
			pStmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{
				pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pStmt.setString( 3, salesPers);
			}
			else
			{
				pStmt.setString( 2, salesPers);
			}
			*/
			//End changes Gulzar on 15DEC23
			
			String loadNo = wsfaCommon.getLoadNo(salesPers, conn);
			
			ArrayList<String> dcrIdList =new ArrayList<String>();
			getTranId = "SELECT DISTINCT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ?) "; 

			pStmt = conn.prepareStatement(getTranId);
			pStmt.setString(1, salesPers);
			pStmt.setString(2, salesPers);
			pStmt.setString(3, loadNo);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				dcrID = checkNull(rs.getString("DCR_ID"));
				if(dcrID != null && dcrID.trim().length()>0)
				{
					if(!dcrIdList.contains(dcrID))
					{
						dcrIdList.add(dcrID);
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("dcrIdList["+dcrIdList+"]");
			//OrgStructure orgStructure=new OrgStructure();
			String dcrIdInForm=wsfaCommon.getFormattedList(dcrIdList);
			if(dcrIdInForm==null || dcrIdInForm.trim().length()==0)
			{
				dcrIdInForm="'X'";
			}
			System.out.println("\nTRAN_ID = ["+tranID+"] \nDCR_ID=["+dcrID+"] \nSALES_PERS=["+salesPers+"]");
			String getSignBy = "SELECT EMP_CODE, ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'S'";
			pStmt = conn.prepareStatement(getSignBy);
			pStmt.setString(1, refSer);
			pStmt.setString(2, dcrID);
			System.out.println("tranID["+getSignBy+"]refSer["+refSer+"]");
			rs = pStmt.executeQuery();
			while ( rs.next() )
			{
				empCode = rs.getString("EMP_CODE");
				entityCode = rs.getString("ENTITY_CODE");
				//System.out.println("empCode["+empCode+"]entityCode["+entityCode+"]");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if ( empCode != null && empCode.trim().length() > 0 )
			{
				reportTo = empCode;
			}
			else
			{
				reportTo = entityCode;
			}
			System.out.println("reportTo =["+reportTo+"]");
			String updStrgMeetSql = "UPDATE STRG_MEET SET WF_STATUS = 'A', EMP_CODE__APRV = ?,CONFIRMED = 'Y' , CONF_DATE = ? WHERE DCR_ID IN("+dcrIdInForm+") ";
			pStmt = conn.prepareStatement(updStrgMeetSql);
			pStmt.setString(1, reportTo);
			pStmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));

			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println("updCnt in strg_customer approval[STRG_MEET] =["+updCnt+"]");
			String objName="strg_meet_dcr_wiz";
			String user_lang = "en";
			String user_country = "US";
			String XTRA_PARAMS_SEPARATOR = "~~";

			String xtraParams = "loginCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "loginEmpCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "loginSiteCode=" + userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "entityCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "profileId=" + userInfo.getProfileId() + XTRA_PARAMS_SEPARATOR + "userType=" + userInfo.getUserType() + XTRA_PARAMS_SEPARATOR + "runMode=I" + XTRA_PARAMS_SEPARATOR + "user_lang=" + user_lang + XTRA_PARAMS_SEPARATOR + "user_country=" + user_country + XTRA_PARAMS_SEPARATOR + "site_code=" + userInfo.getSiteCode() +  XTRA_PARAMS_SEPARATOR +"termId="+ userInfo.getRemoteHost()+ XTRA_PARAMS_SEPARATOR +"chgTerm=" + userInfo.getRemoteHost()+ XTRA_PARAMS_SEPARATOR +"objName=" + objName;


			//callJavaBeanComponent(compName , dcrID, "", methodName,userInfo,objName,salesPers);
			//callJMS(salesPers,refSer,dcrID, objName, userInfo);

			StrgMeetDCRWizConf strgMeetDCRWizConf=new StrgMeetDCRWizConf();
			strgMeetDCRWizConf.setUserInfo( userInfo);
			strgMeetDCRWizConf.confirmAfterSubmit(dcrIdInForm, xtraParams, "",updCnt);
			strgMeetDCRWizConf=null;
			String actionId="approve";
			int count=0;
			String sql = "SELECT COUNT(*) AS COUNT FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME = ? AND ACTION_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, objName);
			pStmt.setString(2, actionId);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				count = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(count > 0)
			{
				callJMS(salesPers,refSer,dcrID, objName, userInfo,xmlData,actionId,xtraParams);
			}
			actionId="DWH_SALES";
			sql = "SELECT COUNT(*) AS COUNT FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME = ? AND ACTION_ID = 'DWH_SALES'";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, objName);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				count = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(count > 0 )
			{
				callJMS(salesPers,refSer,dcrID, objName, userInfo,xmlData,actionId,xtraParams);
			}
		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}

	public String invoiceStockAprvSave(String dcrID,String salesPers,String userInfostr,String xmlString,String refSer,String signByRoleCode) throws ITMException
	{
		BaseLogger.log("3",null,null," Inside invoiceStockAprvSave...");
		BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => xmlString :: ["+xmlString+"]");
		String retString = "YES";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = null;
		Connection conn = null;
		Document dom = null;
		PreparedStatement instPstmt=null;
		PreparedStatement updatePstmt=null;
		boolean isError = false;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		int childNodeListLength = 0;
		Node childNode = null;
		String childNodeName = "";
		String getTranId = "";
		HashMap<String,String> chgRefBankNoMap=new HashMap<String,String>();
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			//Added by mrunalini sinkar for Load Number changes28 Feb 2023(Start)

			String eventDate="";
			String sprsSql="SELECT EVENT_DATE AS EVENT_DATE FROM SPRS_ACT_TRAN WHERE DCR_ID=? ";
			pstmt =  conn.prepareStatement(sprsSql);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				eventDate=checkNull(rs.getString("EVENT_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			/* -- Commented and changed by Gulzar on 16DEC23 - if more than one load is created in the same day.
			String maxDaySummDate="";
			String minDaySummDate="";
			
			
			String daySummMaxSQL="SELECT MAX(EVENT_DATE)AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
			pstmt =  conn.prepareStatement(daySummMaxSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			String daySummMinSQL="SELECT MIN(EVENT_DATE) AS MIN_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE >? ";
			pstmt =  conn.prepareStatement(daySummMinSQL);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				minDaySummDate=checkNull(rs.getString("MIN_DAY_SUMM_DATE"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			String minCon="";
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{

				minCon=" AND EVENT_DATE< ? ";
				
			}
			ArrayList<String> dcrIdList =new ArrayList<String>();

			String getTranId = "SELECT DCR_ID FROM  STRG_MEET WHERE EVENT_DATE >= ?  "+
					minCon+" "+
					" AND SALES_PERS =? ";
			System.out.println("getTranId Sql["+getTranId+"minEveDate["+minDaySummDate+"]");
			
			pstmt = conn.prepareStatement(getTranId);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(maxDaySummDate));
			if(minDaySummDate != null && minDaySummDate.trim().length() > 0) 
			{
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(minDaySummDate));
				pstmt.setString( 3, salesPers);
			}
			else
			{
				pstmt.setString( 2, salesPers);
			}
			*/
			//End changes Gulzar on 16DEC2023
			
			ArrayList<String> dcrIdList =new ArrayList<String>();
			
			String loadNo = wsfaCommon.getLoadNo(salesPers, conn);
			
			getTranId = "SELECT DISTINCT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ?) "; 

			pstmt = conn.prepareStatement(getTranId);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, salesPers);
			pstmt.setString(3, loadNo);
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				dcrID = checkNull(rs.getString("DCR_ID"));
				if(dcrID != null && dcrID.trim().length()>0)
				{
					if(!dcrIdList.contains(dcrID))
					{
						dcrIdList.add(dcrID);
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("dcrIdList["+dcrIdList+"]");

			//OrgStructure orgStructure=new OrgStructure();
			String dcrIdInForm= wsfaCommon.getFormattedList(dcrIdList);
			if(dcrIdInForm==null || dcrIdInForm.trim().length()==0)
			{
				dcrIdInForm="'X'";
			}
			//Added by mrunalini sinkar for Load Number changes 28 Feb 2023(END)

			HashMap<String,String> detBankMap=new HashMap<String,String>();
			HashMap<String,String> detRefNoMap=new HashMap<String,String>();
			String detSql = "SELECT STRG_CODE,REF_BANK,REF_NO FROM STRG_MEET_COLLECT WHERE DCR_ID IN("+dcrIdInForm+")  ";
			pstmt = conn.prepareStatement(detSql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String scCode = checkNull(rs.getString("STRG_CODE"));
				String refBank = checkNull(rs.getString("REF_BANK"));
				String refNo = checkNull(rs.getString("REF_NO"));
				String customer=scCode;
				detBankMap.put(customer, refBank);
				detRefNoMap.put(customer, refNo);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			//added by Rahul P. [START]
			HashMap<String,String> invoiceStatusMap=new HashMap<String,String>();
			String sqlString = "SELECT INVOICE_ID, INVOICE_STATUS FROM STRG_MEET_INVOICE WHERE DCR_ID IN("+dcrIdInForm+")  ";
			pstmt = conn.prepareStatement(sqlString);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String invID = checkNull(rs.getString("INVOICE_ID"));
				String invStatus = checkNull(rs.getString("INVOICE_STATUS"));
				invoiceStatusMap.put(invID, invStatus);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => invoiceStatusMap :: ["+invoiceStatusMap+"]");
			//added by Rahul P. [END]

			String dataStr="";
			
			//Changed by ManishK to solve null pointer exception upon Second Approval[11-10-23]

			//String query = "SELECT OST.TRANS_INFO_XML.GETCLOBVAL() from OBJ_SIGN_TRANS OST where REF_SER = ? and REF_ID = ? AND ROLE_CODE__SIGN =?";
			String query = "SELECT OST.TRANS_INFO_XML.GETCLOBVAL() from OBJ_SIGN_TRANS OST where REF_SER = ? AND ROLE_CODE__SIGN =? and REF_ID IN("+dcrIdInForm+")";

			pstmt = conn.prepareStatement(query);

			pstmt.setString(1, refSer);

		//	pstmt.setString(2, dcrID);

		//	pstmt.setString(3, signByRoleCode);
			pstmt.setString(2, signByRoleCode);

			rs = pstmt.executeQuery();

			if (rs.next())
			{
				dataStr = (rs.getString(1) == null) ?"":rs.getString(1);
			}

			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
			}
			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)
			{
				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
			}

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => dataStr :: ["+dataStr+"]");
			if(dataStr != null && dataStr.trim().length()!=0)
			{
				dom = genericUtility.parseString(dataStr); 
			}

			parentNodeList = dom.getElementsByTagName("Detail2");

			int parentNodeListLength = parentNodeList.getLength();

			//System.out.println("parentNodeListLength for check details::"+parentNodeListLength);

			if(parentNodeListLength > 0)
			{
				for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
				{
					Node parentNode = parentNodeList.item(selectedRow);
					String recChg = "";
					if(parentNode.getAttributes().getNamedItem("isChg") != null)
					{
						recChg = parentNode.getAttributes().getNamedItem("isChg").getNodeValue();
					}
					BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => recChg :: ["+recChg+"]");
					
					if(recChg != null && recChg.equals("1"))
					{
						childNodeList = parentNode.getChildNodes();
						childNodeListLength = childNodeList.getLength();
						String strgCode="",refBank="",refNo="",invoiceStatusFromDom ="",invoiceId="";

						for (int childRow = 0; childRow < childNodeListLength; childRow++)
						{
							childNode = childNodeList.item(childRow);
							childNodeName = childNode.getNodeName();

							//System.out.println("Inside recChg is 1 childNodeName::"+childNodeName);
							if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
							{
								strgCode = childNode.getFirstChild().getNodeValue();
							}
							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("ref_bank") )
							{
								refBank = childNode.getFirstChild().getNodeValue();
							}
							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("ref_no") )
							{
								refNo = childNode.getFirstChild().getNodeValue();
							}
							//added by Rahul P. [START]
							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("invoice_status") )
							{
								invoiceStatusFromDom = checkNull(childNode.getFirstChild().getNodeValue());
							}
							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("invoice_id") )
							{
								invoiceId = checkNull(childNode.getFirstChild().getNodeValue());
							}
							//added by Rahul P. [END]
						}

						String custCompare=checkNull(strgCode);
						BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => strgCode :: ["+strgCode+"] & refBank :: ["+refBank+"] & refNo :: ["+refNo+"]");
						
						if((refBank!=null && refBank.trim().length()>0) ||(refNo!=null && refNo.trim().length()>0))
						{
							if((detBankMap.containsKey(custCompare)) ||(detRefNoMap.containsKey(custCompare)))
							{
								String  approveBank=detBankMap.get(custCompare);
								String  approveDDNo=detRefNoMap.get(custCompare);
								//if((approveBank!=refBank) || (approveDDNo!=refNo))
								if(!approveBank.equalsIgnoreCase(refBank) || !approveDDNo.equalsIgnoreCase(refNo))
								{
									String updateStrgBrandAct = "UPDATE STRG_MEET_COLLECT SET REF_BANK = ?,REF_NO=? WHERE  STRG_CODE=? AND DCR_ID IN("+dcrIdInForm+") ";
									updatePstmt = conn.prepareStatement(updateStrgBrandAct);

									updatePstmt.setString(1,refBank);
									updatePstmt.setString(2,refNo);
									updatePstmt.setString(3,strgCode);

									int updateStrgBrandActCnt = updatePstmt.executeUpdate();

									//System.out.println("Inside updateStrgBrandActCnt count::"+updateStrgBrandActCnt);
									if ( updatePstmt != null )
									{
										updatePstmt.close();
										updatePstmt = null;
									}
								}
							}
						}
						//added by Rahul P. [START]
						BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => invoiceStatusMap :: ["+invoiceStatusMap+"]");
						BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => invoiceId :: ["+invoiceId+"] & invoiceStatusFromDom :: ["+invoiceStatusFromDom+"]");
						if(!invoiceStatusFromDom.trim().isEmpty())
						{
							if(invoiceStatusMap.containsKey(invoiceId))
							{
								String  invStatusdB = invoiceStatusMap.get(invoiceId);
								//String userCode =  userInfo.getLoginCode();
								String userCode =  userInfo.getEmpCode();
								BaseLogger.log("3",null,null,"inside invoiceStockAprvSave => invStatus :: ["+invStatusdB+"] & userCode :: ["+userCode+"]");
								//if(invoiceStatus != invStatus)
								if(!invoiceStatusFromDom.equalsIgnoreCase(invStatusdB))
								{
									String updateInvoiceStatusQuery = "UPDATE STRG_MEET_INVOICE SET INVOICE_STATUS = ?, CANCEL_DATE = ?, EMP_CODE__CANCEL = ?  WHERE  INVOICE_ID = ? AND DCR_ID IN("+dcrIdInForm+") ";
									updatePstmt = conn.prepareStatement(updateInvoiceStatusQuery);

									updatePstmt.setString(1,invoiceStatusFromDom.trim());
									updatePstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
									updatePstmt.setString(3,userCode.trim());
									updatePstmt.setString(4,invoiceId);

									int updateInvoiceStatusCnt = updatePstmt.executeUpdate();
									if(updateInvoiceStatusCnt > 0)
									{
										BaseLogger.log("3",null,null,"Successfully updated Invoice Status :: ["+updateInvoiceStatusCnt+"]");
									}
									if ( updatePstmt != null )
									{
										updatePstmt.close();
										updatePstmt = null;
									}
								}
								
								
							}
						}
						//added by Rahul P. [END]
					}
				}
			}
		}
		catch (Exception e)
		{
			retString = "NO";
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();

			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(updatePstmt != null)
				{
					updatePstmt.close();
					updatePstmt = null;
				}
				if(instPstmt != null)
				{
					instPstmt.close();
					instPstmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception invoiceStockAprvSave(String) :==>\n"+e.getMessage());
			}
		}
		return retString;

	}
	//Added by mrunalini sinkar for call java componnet same as service handler two-----Start
	public String callJavaBeanComponent( String componentName, String tranId, String forcedFlag, String methodName,UserInfoBean userInfo ,String objName,String salesPers)throws ITMException
	{
		System.out.println("Inside CallJb of wsfacommon");
		String returnValue = null;
		String user_lang = "en";
		String user_country = "US";

		final String XTRA_PARAMS_SEPARATOR = "~~";
		try
		{
			int noOfArgs = 4;
			//int noOfArgs = 5;
			String xtraParams = "loginCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "loginEmpCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "loginSiteCode=" + userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "entityCode=" + salesPers + XTRA_PARAMS_SEPARATOR + "profileId=" + userInfo.getProfileId() + XTRA_PARAMS_SEPARATOR + "userType=" + userInfo.getUserType() + XTRA_PARAMS_SEPARATOR + "runMode=I" + XTRA_PARAMS_SEPARATOR + "user_lang=" + user_lang + XTRA_PARAMS_SEPARATOR + "user_country=" + user_country + XTRA_PARAMS_SEPARATOR + "site_code=" + userInfo.getSiteCode() +  XTRA_PARAMS_SEPARATOR +"termId="+ userInfo.getRemoteHost()+ XTRA_PARAMS_SEPARATOR +"chgTerm=" + userInfo.getRemoteHost()+ XTRA_PARAMS_SEPARATOR +"objName=" + objName;

			Class[] paramSpec = new Class[3];
			//Class[] paramSpec = new Class[4];
			Class stringClass = Class.forName("java.lang.String");

			//Commented and changed below by Gulzar on 05/02/16 : START
			//Used Object array instead of String to put different types of object
			//String[] params = new String[3];

			//Object[] params = new Object[4];
			Object[] params = new Object[3];
			//Commented and changed below by Gulzar on 05/02/16 : END

			paramSpec[0] = stringClass;
			paramSpec[1] = stringClass;
			paramSpec[2] = stringClass;

			params[0] = tranId;
			params[1] = xtraParams;
			params[2] = forcedFlag;

			//Commented and changed by Gulzar on 05/02/16 to pass UserInfoBean Object instead of transDB value: START
			//params[3] = userInfo.getTransDB();
			String tranDB = userInfo.getTransDB();
			System.out.println("Inside CallJb of wsfacommon tranDB["+tranDB+"]");
			if ( methodName == null || (methodName.trim()).length() <= 0 )
			{
				methodName = "confirm";
			}
			System.out.println("Inside CallJb of wsfacommon methodName["+methodName+"]");
			Class classObj = null;

			classObj = Class.forName(componentName);
			ActionHandlerEJB actionHandlerEJB = (ActionHandlerEJB)classObj.newInstance();
			actionHandlerEJB.setUserInfo(userInfo);
			System.out.println("confirm ejb is found");
			System.out.println("Inside CallJb of wsfacommon methodName["+methodName+"]");
			Method metObj = classObj.getMethod(methodName, paramSpec);
			metObj.setAccessible(true);
			returnValue = (String)metObj.invoke(actionHandlerEJB, ( Object[] )params);
			actionHandlerEJB = null;
		}
		catch(InvocationTargetException invTargetExcp)
		{
			Exception causedBy = (Exception)invTargetExcp.getCause();
			BaseLogger.log("0", userInfo, null, "InvocationTargetException :ServiceHandlerServlet2 :callJB :\n");
			causedBy.printStackTrace();
			throw new ITMException(  causedBy );
		}
		//Added by Prajyot for unwrapping exception from InvocationTargetException
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo, null, "Exception :ServiceHandlerServlet2 :callJB :\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("Inside CallJb of wsfacommon methodName returnValue["+returnValue+"]");
		return returnValue;
	}
	//Added by mrunalini sinkar for call java componnet same as service handler two-----End
		
	public void callJMS( String userId, String refSer, String tranId, String objName, UserInfoBean userInfo ,String transDomString,String actionId,String xtraParams)
	{
		try
		{
			Document dataDom = null;
			dataDom = new E12GenericUtility().parseString(transDomString);

			System.out.println("inside callJMS of DAR for folwup actions =["+tranId+"],actionId =["+actionId+"]");
			String jmsData = new E12GenericUtility().serializeDom(dataDom)+"!~~!"+objName+"!~~!"+"1"+"!~~!"+refSer+"!~~!"+tranId+"!~~!"+actionId+"!~~!"+xtraParams+"!~~!"+userInfo.toString();

			JMSSender jmsSender = new JMSSender(userInfo);
			jmsSender.getMessage().setJMSType("FOLLOWUP_ACTIONS");
			jmsSender.send(jmsData);
			
		}
		catch (Exception e)
		{
			BaseLogger.log("3",null,null, "callJMS Exception - "+ e.getMessage() );
			BaseLogger.log("3",userInfo,null,"callJMS Exception - JMS Exception :["+E12GenericUtility.getStackTrace(e)+"]");
			e.printStackTrace();
		}
	}
	
	// Added by Rahul P. on 20-feb-24 to check for invoice_status [START]
	public String checkInvoicesForCancelStatus(String dcrID, String salesPers, String userInfostr, String xmlString, String refSer, String signByRoleCode) throws ITMException 
	{
	    BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus..");
		BaseLogger.log("3",null,null,"Inside checkInvoicesForCancelStatus => xmlString :: ["+xmlString+"]");

	    String isStatusCancel = "TRUE";
	    ConnDriver connDriver = null;
	    Connection conn = null;
	    Document dom = null;
	    boolean isError = false;

	    try 
	    {
	    	BaseLogger.log("3", null, null, "userInfostr :: ["+userInfostr+"]");
	        E12GenericUtility genericUtility = new E12GenericUtility();
	        UserInfoBean userInfo = new UserInfoBean(userInfostr);
	        BaseLogger.log("3", null, null, "userInfo :: "+userInfo);
	        if (userInfo != null && userInfo.getTransDB() != null) 
	        {
	            String transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
	            connDriver = new ConnDriver();
	            conn = connDriver.getConnectDB(transDB);
	        }
	        conn.setAutoCommit(false);

	        ArrayList<String> dcrIdList = new ArrayList<String>();
	        String loadNo = wsfaCommon.getLoadNo(salesPers, conn);
	        String getTranId = "SELECT DISTINCT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ?) ";
	        try (PreparedStatement pstmt = conn.prepareStatement(getTranId))
	        {
	            pstmt.setString(1, salesPers);
	            pstmt.setString(2, salesPers);
	            pstmt.setString(3, loadNo);

	            try (ResultSet rs = pstmt.executeQuery()) 
	            {
	                while (rs.next()) 
	                {
	                    dcrID = checkNull(rs.getString("DCR_ID"));
	                    if (dcrID != null && dcrID.trim().length() > 0 && !dcrIdList.contains(dcrID)) 
	                    {
	                        dcrIdList.add(dcrID);
	                    }
	                }
	            }
	        }

	        BaseLogger.log("3",null,null,"Inside checkInvoicesForCancelStatus => dcrIdList :: ["+dcrIdList+"]");
	        String dcrIdInForm = wsfaCommon.getFormattedList(dcrIdList);
	        if (dcrIdInForm == null || dcrIdInForm.trim().length() == 0) 
	        {
	            dcrIdInForm = "'X'";
	        }

	        BaseLogger.log("3",null,null,"Inside checkInvoicesForCancelStatus => dcrIdInForm :: ["+dcrIdInForm+"]");
	        String dataStr = "";
	        String query = "SELECT OST.TRANS_INFO_XML.GETCLOBVAL() from OBJ_SIGN_TRANS OST where REF_SER = ? AND ROLE_CODE__SIGN =? and REF_ID IN(" + dcrIdInForm + ")";
	        try (PreparedStatement pstmt = conn.prepareStatement(query)) 
	        {
	            pstmt.setString(1, refSer);
	            pstmt.setString(2, signByRoleCode);

	            try (ResultSet rs = pstmt.executeQuery()) 
	            {
	                if (rs.next()) 
	                {
	                    dataStr = (rs.getString(1) == null) ? "" : rs.getString(1);
	                }
	            }
	        }
	        BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => dataStr :: ["+dataStr+"]");
	        if (dataStr != null && !dataStr.isEmpty()) 
	        {
	            int endIndex = dataStr.indexOf("</DocumentRoot>");
	            
	            if (endIndex == -1) 
	            {
	                endIndex = dataStr.indexOf("</Root>");
	            }
	            
	            if (endIndex != -1) 
	            {
	                dataStr = dataStr.substring(0, endIndex + 15);
	            }
	        }

	        BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => After substring => dataStr :: ["+dataStr+"]");
	        if (dataStr != null && !dataStr.trim().isEmpty()) 
	        {
	            dom = genericUtility.parseString(dataStr);
	        }

	        NodeList parentNodeList = dom.getElementsByTagName("Detail2");
	        int parentNodeListLength = parentNodeList.getLength();
	        BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => parentNodeListLength :: ["+parentNodeListLength+"]");
	        if (parentNodeListLength > 0) 
	        {
	            int cancelledInvoiceCount = 0;
	            for (int i = 0; i < parentNodeListLength; i++) 
	            {
	                Node parentNode = parentNodeList.item(i);
	                BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => parentNode :: ["+parentNode+"]");
	               
	                String recChg = parentNode.getAttributes().getNamedItem("isChg") != null ? parentNode.getAttributes().getNamedItem("isChg").getNodeValue() : "";
	                BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => recChg :: ["+recChg+"]");
	                
	                if (recChg != null && recChg.equals("1")) 
	                {
	                    NodeList childNodeList = parentNode.getChildNodes();
	                    BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => childNodeListLength :: ["+childNodeList.getLength()+"]");
	                    for (int childRow = 0; childRow < childNodeList.getLength(); childRow++) 
	                    {
	                        Node childNode = childNodeList.item(childRow);
	                        BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => childNode :: ["+childNode+"]");
	                        if (childNode != null && childNode.getFirstChild() != null && childNode.getNodeName().equalsIgnoreCase("invoice_status")) 
	                        {
	                        	BaseLogger.log("3", null, null, "invoice_status childnode..");
	                           
	                        	String invoiceStatus = checkNull(childNode.getFirstChild().getNodeValue());
	                            BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => invoiceStatus :: ["+invoiceStatus+"]");
	                            if (!invoiceStatus.isEmpty() && invoiceStatus.equalsIgnoreCase("C")) 
	                            {
	                                cancelledInvoiceCount++;
	                            }
	                        }
	                    }
	                }
	            }
	            BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => cancelledInvoiceCount :: ["+cancelledInvoiceCount+"]");
	            if (cancelledInvoiceCount > 0) 
	            {
	                isStatusCancel = "TRUE";
	            }
	            else
	            {
	            	isStatusCancel = "FALSE";
	            }
	        }
	    } 
	    catch (Exception e) 
	    {
	        isStatusCancel = "FALSE";
	        isError = true;
	        try 
	        {
	            if (conn != null) 
	            {
	                conn.rollback();
	            }
	        } 
	        catch (Exception ee) 
	        {
	        	BaseLogger.log("3", null, null, "Exception occurred while conn.rollback().. :==> [" + ee.getMessage()+"]");
	        }
	        
	        BaseLogger.log("3", null, null, "Exception in checkInvoicesForCancelStatus => [" + e.getMessage()+"]");
	        throw new ITMException(e);
	    } 
	    finally 
	    {
	        try 
	        {
	            if (conn != null && !isError) 
	            {
	                conn.commit();
	            }
	        } 
	        catch (Exception ee) 
	        {
	        	BaseLogger.log("3", null, null, "Exception occurred while conn.commit().. => [" + ee.getMessage()+"]");
	        } 
	        finally 
	        {
	            try 
	            {
	                if (conn != null) 
	                {
	                    conn.close();
	                }
	            } 
	            catch (Exception ee) 
	            {
	            	BaseLogger.log("3", null, null, "Exception occurred while conn.close().. => [" + ee.getMessage()+"]");
	            }
	        }
	    }
	    
	    BaseLogger.log("3", null, null, "Inside checkInvoicesForCancelStatus => isStatusCancel :: ["+isStatusCancel+"]");
	    return isStatusCancel;
	}
	
	public String invoiceStockAdminAprvSave(String dcrID, String salesPers, String userInfostr, String xmlString, String refSer, String signByRoleCode) throws ITMException 
	{
	    BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave..");
	    BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => xmlString :: ["+xmlString+"]");

	    String retString = "YES";
	    ConnDriver connDriver = null;
	    Connection conn = null;
	    Document dom = null;
	    boolean isError = false;

	    try 
	    {
	    	BaseLogger.log("3", null, null, "userInfostr :: ["+userInfostr+"]");
	        E12GenericUtility genericUtility = new E12GenericUtility();
	        UserInfoBean userInfo = new UserInfoBean(userInfostr);
	        BaseLogger.log("3", null, null, "userInfo :: "+userInfo);
	        if (userInfo != null && userInfo.getTransDB() != null) 
	        {
	            String transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
	            connDriver = new ConnDriver();
	            conn = connDriver.getConnectDB(transDB);
	        }
	        conn.setAutoCommit(false);
	        
	        ArrayList<String> dcrIdList = new ArrayList<String>();
	        String loadNo = wsfaCommon.getLoadNo(salesPers, conn);
	        String getTranId = "SELECT DISTINCT DCR_ID FROM STRG_MEET WHERE SALES_PERS = ? AND DCR_ID IN( SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND LOAD_NO = ?) ";
	        try (PreparedStatement pstmt = conn.prepareStatement(getTranId))
	        {
	            pstmt.setString(1, salesPers);
	            pstmt.setString(2, salesPers);
	            pstmt.setString(3, loadNo);

	            try (ResultSet rs = pstmt.executeQuery()) 
	            {
	                while (rs.next()) 
	                {
	                    dcrID = checkNull(rs.getString("DCR_ID"));
	                    if (dcrID != null && dcrID.trim().length() > 0 && !dcrIdList.contains(dcrID)) 
	                    {
	                        dcrIdList.add(dcrID);
	                    }
	                }
	            }
	        }

	        BaseLogger.log("3", null, null, "dcrIdList :: ["+dcrIdList+"]");
	        String dcrIdInForm = wsfaCommon.getFormattedList(dcrIdList);
	        if (dcrIdInForm == null || dcrIdInForm.trim().length() == 0) 
	        {
	            dcrIdInForm = "'X'";
	        }

	        BaseLogger.log("3", null, null, "dcrIdInForm :: ["+dcrIdInForm+"]");
	        
			HashMap<String,String> invoiceStatusMap=new HashMap<String,String>();
			String sqlString = "SELECT INVOICE_ID, INVOICE_STATUS FROM STRG_MEET_INVOICE WHERE DCR_ID IN("+dcrIdInForm+")  ";
			try (PreparedStatement pstmt = conn.prepareStatement(sqlString)) 
			{
				try (ResultSet rs = pstmt.executeQuery()) 
				{
					while (rs.next()) 
					{
						String invID = checkNull(rs.getString("INVOICE_ID"));
						String invStatus = checkNull(rs.getString("INVOICE_STATUS"));
						BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => invID :: [" + invID + "] & invStatus :: [" + invStatus + "]");
						invoiceStatusMap.put(invID, invStatus);
					}
				}
			}
			BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => invoiceStatusMap :: ["+invoiceStatusMap+"]");
	        
	        String dataStr = "";
	        String query = "SELECT OST.TRANS_INFO_XML.GETCLOBVAL() from OBJ_SIGN_TRANS OST where REF_SER = ? AND ROLE_CODE__SIGN =? and REF_ID IN(" + dcrIdInForm + ")";
	        try (PreparedStatement pstmt = conn.prepareStatement(query)) 
	        {
	            pstmt.setString(1, refSer);
	            pstmt.setString(2, signByRoleCode);

	            try (ResultSet rs = pstmt.executeQuery()) 
	            {
	                if (rs.next()) 
	                {
	                    dataStr = (rs.getString(1) == null) ? "" : rs.getString(1);
	                }
	            }
	        }
	        BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => dataStr :: ["+dataStr+"]");
	        if (dataStr != null && !dataStr.isEmpty()) 
	        {
	            int endIndex = dataStr.indexOf("</DocumentRoot>");
	            
	            if (endIndex == -1) 
	            {
	                endIndex = dataStr.indexOf("</Root>");
	            }
	            
	            if (endIndex != -1) 
	            {
	                dataStr = dataStr.substring(0, endIndex + 15);
	            }
	        }

	        BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => After substring => dataStr :: ["+dataStr+"]");
	        if (dataStr != null && !dataStr.trim().isEmpty()) 
	        {
	            dom = genericUtility.parseString(dataStr);
	        }

	        NodeList parentNodeList = dom.getElementsByTagName("Detail2");
	        int parentNodeListLength = parentNodeList.getLength();
	        BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => parentNodeListLength :: ["+parentNodeListLength+"]");
	        if (parentNodeListLength > 0) 
	        {
	            for (int i = 0; i < parentNodeListLength; i++) 
	            {
	                Node parentNode = parentNodeList.item(i);
	                BaseLogger.log("3", null, null, "parentNode :: ["+parentNode+"]");
	               
	                String recChg = parentNode.getAttributes().getNamedItem("isChg") != null ? parentNode.getAttributes().getNamedItem("isChg").getNodeValue() : "";
	                BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => recChg :: ["+recChg+"]");
	                
	                if (recChg != null && recChg.equals("1")) 
	                {
	                    NodeList childNodeList = parentNode.getChildNodes();
	                    BaseLogger.log("3", null, null, "childNodeListLength :: ["+childNodeList.getLength()+"]");
	                    
	                    String invoiceStatusFromDom ="",invoiceId="";
	                    
						for (int childRow = 0; childRow < childNodeList.getLength(); childRow++) 
						{
							
							Node childNode = childNodeList.item(childRow);
							BaseLogger.log("3", null, null, "childNode :: [" + childNode + "]");
							
							if (childNode != null && childNode.getFirstChild() != null && childNode.getNodeName().equalsIgnoreCase("invoice_status")) {

								invoiceStatusFromDom = checkNull(childNode.getFirstChild().getNodeValue());
							}

							else if (childNode != null && childNode.getFirstChild() != null && childNode.getNodeName().equalsIgnoreCase("invoice_id")) {
								
								invoiceId = checkNull(childNode.getFirstChild().getNodeValue());
							}
							BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => invoiceStatusFromDom :: [" + invoiceStatusFromDom + "]");
	                      
	                    }
						
						BaseLogger.log("3",null,null,"Inside invoiceStockAdminAprvSave => invoiceStatusMap :: ["+invoiceStatusMap+"]");
						BaseLogger.log("3",null,null,"Inside invoiceStockAdminAprvSave => invoiceId :: ["+invoiceId+"] & invoiceStatusFromDom :: ["+invoiceStatusFromDom+"]");
						if(!invoiceStatusFromDom.trim().isEmpty())
						{
							if(invoiceStatusMap.containsKey(invoiceId))
							{
								String  invStatusdB = invoiceStatusMap.get(invoiceId);
								BaseLogger.log("3",null,null,"Inside invoiceStockAdminAprvSave => invStatus :: ["+invStatusdB+"]");
								//if(invoiceStatus != invStatus)
								if(!invoiceStatusFromDom.equalsIgnoreCase(invStatusdB))
								{
									String userCode =  userInfo.getLoginCode();
									String updateInvoiceStatusQuery = "";
									BaseLogger.log("3",null,null,"Inside invoiceStockAdminAprvSave => invStatus :: ["+invStatusdB+"] & userCode :: ["+userCode+"]");
									
									if(invoiceStatusFromDom.equalsIgnoreCase("C"))
									{
										updateInvoiceStatusQuery = "UPDATE STRG_MEET_INVOICE SET INVOICE_STATUS = ?, CANCEL_DATE = ?, EMP_CODE__CANCEL = ?  WHERE  INVOICE_ID=? AND DCR_ID IN("+dcrIdInForm+") ";
										try( PreparedStatement updatePstmt = conn.prepareStatement(updateInvoiceStatusQuery);)
										{

											updatePstmt.setString(1,invoiceStatusFromDom);
											updatePstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
											updatePstmt.setString(3,userCode);
											updatePstmt.setString(2,invoiceId);
											
											int updateInvoiceStatusCnt = updatePstmt.executeUpdate();
											if(updateInvoiceStatusCnt > 0)
											{
												BaseLogger.log("3",null,null,"Successfully updated Invoice Status for C :: ["+updateInvoiceStatusCnt+"]");
											}
										}
									}
									else if(invoiceStatusFromDom.equalsIgnoreCase("A"))
									{
										//String updateInvoiceStatusQuery = "UPDATE STRG_MEET_INVOICE SET INVOICE_STATUS = ?, CANCEL_DATE = ?, EMP_CODE__CANCEL = ?  WHERE  INVOICE_ID=? AND DCR_ID IN("+dcrIdInForm+") ";
										updateInvoiceStatusQuery = "UPDATE STRG_MEET_INVOICE SET INVOICE_STATUS = ?, CANCEL_DATE = null, EMP_CODE__CANCEL = null WHERE  INVOICE_ID= ? AND DCR_ID IN("+dcrIdInForm+") ";
										try( PreparedStatement updatePstmt = conn.prepareStatement(updateInvoiceStatusQuery);)
										{

											updatePstmt.setString(1,invoiceStatusFromDom);
											//updatePstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
											//updatePstmt.setString(3,userCode);
											updatePstmt.setString(2,invoiceId);
											
											int updateInvoiceStatusCnt = updatePstmt.executeUpdate();
											if(updateInvoiceStatusCnt > 0)
											{
												BaseLogger.log("3",null,null,"Successfully updated Invoice Status for A :: ["+updateInvoiceStatusCnt+"]");
											}
										}
									}
								}
							}
						} 
	                }
	            }
	           
	        }
	    } 
	    catch (Exception e) 
	    {
	    	retString = "NO";
	        isError = true;
	        try {
	            if (conn != null) 
	            {
	                conn.rollback();
	            }
	        } catch (Exception ee) 
	        {
	        	BaseLogger.log("3", null, null, "Exception occurred while conn.rollback().. :==> [" + ee.getMessage()+"]");
	        }
	        
	        BaseLogger.log("3", null, null, "Exception in invoiceStockAdminAprvSave => [" + e.getMessage()+"]");
	        throw new ITMException(e);
	    } 
	    finally 
	    {
	        try 
	        {
	            if (conn != null && !isError) 
	            {
	                conn.commit();
	            }
	        } 
	        catch (Exception ee) 
	        {
	        	BaseLogger.log("3", null, null, "Exception occurred while conn.commit().. => [" + ee.getMessage()+"]");
	        } 
	        finally 
	        {
	            try 
	            {
	                if (conn != null) 
	                {
	                    conn.close();
	                }
	            } 
	            catch (Exception ee) 
	            {
	            	BaseLogger.log("3", null, null, "Exception occurred while conn.close().. => [" + ee.getMessage()+"]");
	            }
	        }
	    }
	    
	    BaseLogger.log("3", null, null, "Inside invoiceStockAdminAprvSave => retString :: ["+retString+"]");
	    return retString;
	}
	// Added by Rahul P. on 20-Feb-24 [END]

}