/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.WorkflowProcessDataMangerLocal;
import ibase.wrkflw.WorkflowProcessDataMangerRemote;
import ibase.wrkflw.schedule.WorkflowShedule;
import ibase.wrkflw.utility.WorkflowLogger;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.xdb.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Stateless
public class WorkflowProcessDataMangerEJB
implements WorkflowProcessDataMangerLocal,
WorkflowProcessDataMangerRemote {
    SessionContext cSessionContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext mSessionContext) {
    }

    @Override
    public String saveProcessInputData(String processId, int instanceId, String processInputParamXML, Connection passedCon, String refSer, String refID) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB.saveProcessInputData.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusString = "";
        Connection con = null;
        Object stmt = null;
        Statement pStmt = null;
        boolean isConnLocal = false;
        Document processInputParamDom = null;
        boolean parseRetry = false;
        E12GenericUtility genericUtility = new E12GenericUtility();
        Object oConnection = null;
        try {
            try {
                try {
                    processInputParamDom = this.parseString(processInputParamXML);
                }
                catch (SAXParseException saxe) {
                    WorkflowLogger.info("Exception :saveProcessInputData :parsingXMLString :==>\n" + saxe.getMessage());
                    parseRetry = true;
                }
                if (parseRetry) {
                    processInputParamDom = this.parsingFile(processInputParamXML);
                }
                NodeList processParamNodeList = processInputParamDom.getElementsByTagName("ProcessParam").item(0).getChildNodes();
                int noOfParams = processParamNodeList.getLength();
                if (passedCon != null) {
                    con = passedCon;
                } else {
                    con = this.getConnection();
                    isConnLocal = true;
                }
                con.setAutoCommit(false);
                Object testStr = null;
                if (testStr == null) {
                    BaseLogger.log("3", null, null, "Inserting for Nullpointer exception................. ");
                }
                int processParamCtr = 0;
                while (processParamCtr < noOfParams) {
                    Node currParam = processParamNodeList.item(processParamCtr);
                    String argumentId = currParam.getNodeName();
                    argumentId = "$" + argumentId;
                    String argumentValue = this.serializeDom(currParam.getFirstChild());
                    if (!this.isProcessExists(processId, instanceId, argumentId, con)) {
                        String prcDataInsQuery;
                        WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "]");
                        if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                            WorkflowLogger.info("Using mssql with binary stream");
                            prcDataInsQuery = "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE, REF_SER, REF_ID) VALUES(?,?,?,?,?,?)";
                            pStmt = con.prepareStatement(prcDataInsQuery);
                            pStmt.setString(1, processId);
                            pStmt.setInt(2, instanceId);
                            pStmt.setString(3, argumentId);
                            byte[] encoded = argumentValue.getBytes();
                            ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                            pStmt.setBinaryStream(4, byteArrayIn, byteArrayIn.available());
                            pStmt.setString(5, refSer);
                            pStmt.setString(6, refID);
                            int noOfRows = pStmt.executeUpdate();
                            BaseLogger.log("3", null, null, "noOfRows[" + noOfRows + "]");
                            statusString = noOfRows > 0 ? "true" : "false";
                            pStmt.close();
                            pStmt = null;
                        } else {
                            BaseLogger.log("3", null, null, "@@@@ argumentValue :[ " + argumentValue + " ]");
                            prcDataInsQuery = "";
                            prcDataInsQuery = argumentId.equalsIgnoreCase("$XML_DATA_ALL") ? "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE,ARGUMENT_VALUE_XML, REF_SER, REF_ID) VALUES(?,?,?,EMPTY_BLOB(),XMLType(?),?,?)" : "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE, REF_SER, REF_ID) VALUES(?,?,?,EMPTY_BLOB(),?,?)";
                            pStmt = con.prepareStatement(prcDataInsQuery);
                            pStmt.setString(1, processId);
                            pStmt.setInt(2, instanceId);
                            pStmt.setString(3, argumentId);
                            if (argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                                CLOB xmlData = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                                xmlData.putString(1L, argumentValue);
                                pStmt.setClob(4, (Clob)xmlData);
                                pStmt.setString(5, refSer);
                                pStmt.setString(6, refID);
                            } else {
                                pStmt.setString(4, refSer);
                                pStmt.setString(5, refID);
                            }
                            pStmt.executeUpdate();
                            pStmt.close();
                            pStmt = null;
                        }
                    }
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME) && argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                        String query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID=? FOR UPDATE NOWAIT";
                        ArrayList<String> bindVarValues = new ArrayList<String>();
                        bindVarValues.add(processId);
                        bindVarValues.add(String.valueOf(instanceId));
                        bindVarValues.add(argumentId);
                        ArrayList<String> bindVarTypes = new ArrayList<String>();
                        bindVarTypes.add("String");
                        bindVarTypes.add("Int");
                        bindVarTypes.add("String");
                        WorkflowLogger.info("Updating Workflow data for Process Id :[" + processId + "] Instance Id :[" + instanceId + "]");
                        WorkflowLogger.info("Argument Id :[" + argumentId + "] Argument Value :[" + argumentValue + "]");
                        boolean updStatus = this.updateBlob(con, query, argumentValue, bindVarValues, bindVarTypes);
                        WorkflowLogger.info("saveProcessInputData:updStatus[" + updStatus + "]");
                        statusString = updStatus ? "true" : "false";
                    }
                    ++processParamCtr;
                }
            }
            catch (Exception e) {
                try {
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(e), "", String.valueOf(processId) + "_" + instanceId, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    if (con != null && !con.isClosed() && isConnLocal) {
                        con.commit();
                        con.close();
                        con = null;
                    }
                    if (oConnection != null) {
                        oConnection.close();
                        oConnection = null;
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return statusString;
    }

    @Override
    public HashMap getProcessInputData(String processId, int instanceId, String activityId, int seqId) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB.getProcessInputData.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String statusString = "";
        Connection con = null;
        Statement pStmt = null;
        try {
            try {
                String prcDataSelQuery = null;
                prcDataSelQuery = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT WF.ARGUMENT_ID, WF.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WF WHERE PROCESS_ID=? AND INSTANCE_ID=?" : "SELECT ARGUMENT_ID,ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=?";
                WorkflowLogger.info("Selecting Process Data :[" + prcDataSelQuery + "]");
                WorkflowLogger.info("processId :[" + processId + "] instanceId :[" + instanceId + "]");
                con = this.getConnection();
                pStmt = con.prepareStatement(prcDataSelQuery);
                pStmt.setString(1, processId);
                pStmt.setInt(2, instanceId);
                ResultSet rs = pStmt.executeQuery();
                String argumentId = null;
                String argumentValue = null;
                while (rs.next()) {
                    argumentId = rs.getString("ARGUMENT_ID");
                    InputStream is = null;
                    WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "]");
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        String string = argumentValue = rs.getString(2) == null ? "" : rs.getString(2);
                        if (argumentValue.indexOf("</DocumentRoot>") != -1) {
                            argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                        }
                    } else {
                        is = rs.getBinaryStream("ARGUMENT_VALUE");
                    }
                    if (is != null) {
                        InputStreamReader isr = new InputStreamReader(is);
                        StringBuffer xmlBuff = new StringBuffer();
                        int ch = -1;
                        while ((ch = isr.read()) != -1) {
                            xmlBuff.append((char)ch);
                        }
                        isr.close();
                        argumentValue = xmlBuff.toString();
                        if (argumentValue.indexOf("</DocumentRoot>") != -1) {
                            argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                        }
                    }
                    WorkflowLogger.info("argumentId  [:" + argumentId + "] Value Length :[" + argumentValue.length() + "]");
                    if (argumentId == null) continue;
                    paramMap.put(argumentId, argumentValue);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                prcDataSelQuery = "SELECT OBJ_NAME,REF_SER,REF_ID,ROLE_CODE__PERF,ENTITY_CODE__PERF FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? AND SEQ_ID=?";
                WorkflowLogger.info("Selecting Process Status Info");
                pStmt = con.prepareStatement(prcDataSelQuery);
                pStmt.setString(1, processId);
                pStmt.setInt(2, instanceId);
                pStmt.setString(3, activityId);
                pStmt.setInt(4, seqId);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String refSer = rs.getString("REF_SER");
                    String refId = rs.getString("REF_ID");
                    paramMap.put("$REF_SER", refSer);
                    paramMap.put("$REF_ID", refId);
                    paramMap.put("$OBJ_NAME", rs.getString("OBJ_NAME"));
                    paramMap.put("$PRFMR_ROLE_CODE", rs.getString("ROLE_CODE__PERF"));
                    paramMap.put("$ENTITY_CODE", rs.getString("ENTITY_CODE__PERF"));
                    String xmlData = (String)paramMap.get("$XML_DATA_ALL");
                    if (xmlData == null) continue;
                    Document dom = null;
                    boolean parseRetry = false;
                    try {
                        dom = this.parseString(xmlData);
                    }
                    catch (SAXParseException saxe) {
                        WorkflowLogger.info("Exception :getProcessInputData :parsingXMLString :==>\n" + saxe.getMessage());
                        parseRetry = true;
                    }
                    if (parseRetry) {
                        dom = this.parsingFile(xmlData);
                    }
                    String lastSignRem = this.getPrevSignRemarks(refSer, refId, con);
                    dom.getFirstChild().appendChild(dom.importNode(this.parseString(lastSignRem).getFirstChild(), true));
                    xmlData = this.serializeDom(dom);
                    paramMap.put("$XML_DATA_ALL", xmlData);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                WorkflowLogger.info("Process Status Info Obj Name:[" + paramMap.get("$OBJ_NAME") + "] Ref Ser :[" + paramMap.get("$REF_SER") + "] Ref Id :[" + paramMap.get("$REF_ID") + "] Prfrmr Role Code :[" + paramMap.get("$PRFMR_ROLE_CODE") + "] Entity Code :[" + paramMap.get("$ENTITY_CODE") + "]");
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    if (!con.isClosed()) {
                        con.close();
                    }
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return paramMap;
    }

    @Override
    public String getXMLData(String processId, String instanceId) throws RemoteException, BaseException {
        Connection con = null;
        Statement pStmt = null;
        String argumentValue = null;
        try {
            try {
                String prcDataSelQuery = null;
                prcDataSelQuery = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT WF.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WF WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?" : "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                WorkflowLogger.info("Selecting Process Data :[" + prcDataSelQuery + "]");
                WorkflowLogger.info("processId :[" + processId + "] instanceId :[" + instanceId + "]");
                con = this.getConnection();
                pStmt = con.prepareStatement(prcDataSelQuery);
                pStmt.setString(1, processId);
                pStmt.setString(2, instanceId);
                pStmt.setString(3, "$XML_DATA_ALL");
                ResultSet rs = pStmt.executeQuery();
                while (rs.next()) {
                    InputStream is = null;
                    WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "]");
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        String string = argumentValue = rs.getString(1) == null ? "" : rs.getString(1);
                        if (argumentValue.indexOf("</DocumentRoot>") != -1) {
                            argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                        }
                    } else {
                        is = rs.getBinaryStream("ARGUMENT_VALUE");
                    }
                    if (is == null) continue;
                    InputStreamReader isr = new InputStreamReader(is);
                    StringBuffer xmlBuff = new StringBuffer();
                    int ch = -1;
                    while ((ch = isr.read()) != -1) {
                        xmlBuff.append((char)ch);
                    }
                    isr.close();
                    argumentValue = xmlBuff.toString();
                    if (argumentValue.indexOf("</DocumentRoot>") == -1) continue;
                    argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    if (!con.isClosed()) {
                        con.close();
                    }
                    con = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return argumentValue;
    }

    @Override
    public HashMap getProcessInputData(String processId, int instanceId, String activityId, int seqId, Connection con) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB with connection.getProcessInputData.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String statusString = "";
        Statement pStmt = null;
        String prcDataSelQuery = "";
        try {
            try {
                prcDataSelQuery = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT WF.ARGUMENT_ID AS ARGUMENT_ID, WF.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WF WHERE PROCESS_ID=? AND INSTANCE_ID=?" : "SELECT ARGUMENT_ID,ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=?";
                WorkflowLogger.info("Selecting Process Data :[" + prcDataSelQuery + "]");
                WorkflowLogger.info("processId :[" + processId + "] instanceId :[" + instanceId + "]");
                pStmt = con.prepareStatement(prcDataSelQuery);
                pStmt.setString(1, processId);
                pStmt.setInt(2, instanceId);
                ResultSet rs = pStmt.executeQuery();
                String argumentId = null;
                String argumentValue = null;
                while (rs.next()) {
                    argumentId = rs.getString("ARGUMENT_ID");
                    InputStream is = null;
                    WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "]");
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        argumentValue = rs.getString(2) == null ? "" : rs.getString(2);
                        BaseLogger.log("3", null, null, "argumentValue ::" + argumentValue);
                        if (argumentValue.indexOf("</DocumentRoot>") != -1) {
                            argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                        }
                    } else {
                        is = rs.getBinaryStream("ARGUMENT_VALUE");
                    }
                    if (is != null) {
                        InputStreamReader isr = new InputStreamReader(is);
                        StringBuffer xmlBuff = new StringBuffer();
                        int ch = -1;
                        while ((ch = isr.read()) != -1) {
                            xmlBuff.append((char)ch);
                        }
                        isr.close();
                        argumentValue = xmlBuff.toString();
                        if (argumentValue.indexOf("</DocumentRoot>") != -1) {
                            argumentValue = argumentValue.substring(0, argumentValue.indexOf("</DocumentRoot>") + 15);
                        }
                    }
                    WorkflowLogger.info("argumentId  [:" + argumentId + "] Value Length :[" + argumentValue.length() + "]");
                    if (argumentId == null) continue;
                    paramMap.put(argumentId, argumentValue);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                prcDataSelQuery = "SELECT OBJ_NAME,REF_SER,REF_ID,ROLE_CODE__PERF,ENTITY_CODE__PERF FROM WF_PRC_STATUS WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ACTIVITY_ID=? AND SEQ_ID=?";
                WorkflowLogger.info("Selecting Process Status Info");
                pStmt = con.prepareStatement(prcDataSelQuery);
                pStmt.setString(1, processId);
                pStmt.setInt(2, instanceId);
                pStmt.setString(3, activityId);
                pStmt.setInt(4, seqId);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String refSer = rs.getString("REF_SER");
                    String refId = rs.getString("REF_ID");
                    paramMap.put("$REF_SER", refSer);
                    paramMap.put("$REF_ID", refId);
                    paramMap.put("$OBJ_NAME", rs.getString("OBJ_NAME"));
                    paramMap.put("$PRFMR_ROLE_CODE", rs.getString("ROLE_CODE__PERF"));
                    paramMap.put("$ENTITY_CODE", rs.getString("ENTITY_CODE__PERF"));
                    String xmlData = (String)paramMap.get("$XML_DATA_ALL");
                    if (xmlData == null) continue;
                    Document dom = null;
                    boolean parseRetry = false;
                    try {
                        dom = this.parseString(xmlData);
                    }
                    catch (SAXParseException saxe) {
                        WorkflowLogger.info("Exception :getProcessInputData :parsingXMLString :==>\n" + saxe.getMessage());
                        parseRetry = true;
                    }
                    if (parseRetry) {
                        dom = this.parsingFile(xmlData);
                    }
                    String lastSignRem = this.getPrevSignRemarks(refSer, refId, con);
                    dom.getFirstChild().appendChild(dom.importNode(this.parseString(lastSignRem).getFirstChild(), true));
                    xmlData = this.serializeDom(dom);
                    paramMap.put("$XML_DATA_ALL", xmlData);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                WorkflowLogger.info("Process Status Info Obj Name:[" + paramMap.get("$OBJ_NAME") + "] Ref Ser :[" + paramMap.get("$REF_SER") + "] Ref Id :[" + paramMap.get("$REF_ID") + "] Prfrmr Role Code :[" + paramMap.get("$PRFMR_ROLE_CODE") + "] Entity Code :[" + paramMap.get("$ENTITY_CODE") + "]");
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return paramMap;
    }

    private Document parseString(String xmlString) throws Exception {
        Document dom = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        dom = genericUtility.parseString(xmlString);
        return dom;
    }

    private String serializeDom(Node dom) throws BaseException {
        String retString = null;
        try {
            retString = new E12GenericUtility().serializeDom(dom);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return retString;
    }

    private Connection getConnection() throws BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB.getConnection.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return con;
    }

    private boolean isProcessExists(String processId, int instanceId, String argumentId, Connection con) throws BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB.isProcessExists.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        WorkflowLogger.info("Checking for process existance for processId [" + processId + "] and instanceId [" + instanceId + "] and argumentId [" + argumentId + "] ");
        Statement stmt = null;
        boolean isExist = false;
        try {
            try {
                stmt = con.createStatement();
                String query = "SELECT COUNT(1) CNT FROM WF_PRC_DATA WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId + " AND ARGUMENT_ID = '" + argumentId + "' ";
                WorkflowLogger.info("Selecting Existance [" + query + "]");
                ResultSet rs = stmt.executeQuery(query);
                if (rs.next() && rs.getInt("CNT") > 0) {
                    isExist = true;
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        WorkflowLogger.info("Existance of process is [" + isExist + "]");
        return isExist;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws BaseException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    } else {
                        dataByteArray = dataStr.getBytes();
                    }
                    WorkflowLogger.info("blobOutputStream :[" + blobOutputStream + "]");
                    WorkflowLogger.info("dataByteArray :[" + dataByteArray + "]");
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :WorkflowProcessDataManger :updateBlob :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return updStatus;
    }

    private String getPrevSignRemarks(String refSer, String refID, Connection conn) throws RemoteException, ITMException {
        WorkflowLogger.info("To append lastSignRemark in XML_DATA_ALL ");
        Statement pStmt = null;
        ResultSet rs = null;
        StringBuffer retStringBuff = new StringBuffer("<WRKFLW_REMARKS>");
        try {
            try {
                BaseLogger.log("3", null, null, "getPrevSignRemarks B4");
                String query = "SELECT LINE_NO, SIGN_REMARKS, SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? ORDER BY LINE_NO ";
                pStmt = conn.prepareStatement(query);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                rs = pStmt.executeQuery();
                String lastSignRemarks = "";
                while (rs.next()) {
                    String lineNoStr = "REMARKS_LINE_NO_" + rs.getInt("LINE_NO") + ">";
                    String signRemarks = rs.getString("SIGN_REMARKS");
                    String string = signRemarks = signRemarks == null || "null".equalsIgnoreCase(signRemarks) ? "" : signRemarks;
                    if (rs.getString("SIGN_STATUS") != null) {
                        lastSignRemarks = signRemarks;
                    }
                    retStringBuff.append("<").append(lineNoStr).append(" <![CDATA[" + signRemarks + "]]>").append("</").append(lineNoStr);
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                retStringBuff.append("<REMARKS>").append("<![CDATA[" + lastSignRemarks + "]]>").append("</REMARKS>").append("</WRKFLW_REMARKS>");
                WorkflowLogger.info("[WorkflowProcessDataMangerEJB] getPrevSignRemarks previous remarks [" + retStringBuff.toString() + "] ");
                BaseLogger.log("3", null, null, "WorkflowProcessDataMangerEJB getPrevSignRemarks After");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :WorkflowProcessDataMangerEJB :getPrevSignRemarks 3 :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :WorkflowProcessDataMangerEJB :getLastSignRemarks 3 :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retStringBuff.toString();
    }

    private InitialContext getInitialContext() throws BaseException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return ctx;
    }

    private Document parsingFile(String writeFileString) throws BaseException {
        BufferedWriter parseFileWriter = null;
        Document dom = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                double randomNo = Math.random();
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").createNewFile();
                }
                String parseFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml";
                WorkflowLogger.info("writeParsingFile:parseFileName[" + parseFileName + "]");
                parseFileWriter = new BufferedWriter(new FileWriter(parseFileName));
                parseFileWriter.write(writeFileString);
                parseFileWriter.flush();
                parseFileWriter.close();
                parseFileWriter = null;
                dom = genericUtility.parseFile(parseFileName);
            }
            catch (Exception e) {
                dom = null;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (parseFileWriter != null) {
                    parseFileWriter.flush();
                    parseFileWriter.close();
                    parseFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parseFileWriter = null;
            }
        }
        return dom;
    }

    private Document parseXMLFile(Object sourceXMLFile) throws Exception {
        Document dom = null;
        try {
            File file = null;
            file = sourceXMLFile.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)sourceXMLFile) : (File)sourceXMLFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            dom = parser.parse(file);
        }
        catch (Exception e) {
            dom = null;
            WorkflowLogger.info("Exception :WorkflowEngineEJB :parseFile :\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    @Override
    public String updateProcessInputData(String processId, int instanceId, String processInputParamXML, Connection passedCon, String refSer, String refID) throws RemoteException, BaseException {
        WorkflowLogger.info("WorkflowProcessDataMangerEJB.saveProcessInputData.SCHEDULER_INVOCATION_CTR [" + WorkflowShedule.SCHEDULER_INVOCATION_CTR + "]");
        String statusString = "";
        Connection con = null;
        Object stmt = null;
        Statement pStmt = null;
        boolean isConnLocal = false;
        Document processInputParamDom = null;
        boolean parseRetry = false;
        E12GenericUtility genericUtility = new E12GenericUtility();
        Object oConnection = null;
        try {
            try {
                try {
                    processInputParamDom = this.parseString(processInputParamXML);
                }
                catch (SAXParseException saxe) {
                    WorkflowLogger.info("Exception :saveProcessInputData :parsingXMLString :==>\n" + saxe.getMessage());
                    parseRetry = true;
                }
                if (parseRetry) {
                    processInputParamDom = this.parsingFile(processInputParamXML);
                }
                NodeList processParamNodeList = processInputParamDom.getElementsByTagName("ProcessParam").item(0).getChildNodes();
                int noOfParams = processParamNodeList.getLength();
                if (passedCon != null) {
                    con = passedCon;
                } else {
                    con = this.getConnection();
                    isConnLocal = true;
                }
                con.setAutoCommit(false);
                Object testStr = null;
                if (testStr == null) {
                    BaseLogger.log("3", null, null, "Inserting for Nullpointer exception................. ");
                }
                int processParamCtr = 0;
                while (processParamCtr < noOfParams) {
                    Node currParam = processParamNodeList.item(processParamCtr);
                    String argumentId = currParam.getNodeName();
                    argumentId = "$" + argumentId;
                    String argumentValue = this.serializeDom(currParam.getFirstChild());
                    if (this.isProcessExists(processId, instanceId, argumentId, con)) {
                        String processInstExist = "DELETE FROM WF_PRC_DATA WHERE PROCESS_ID='" + processId + "' AND INSTANCE_ID=" + instanceId;
                        WorkflowLogger.info("Delete ProcessInstance already created  From WF_PRC_DATA sql[" + processInstExist + "]");
                        pStmt = con.prepareStatement(processInstExist);
                        pStmt.executeUpdate();
                        WorkflowLogger.info(" DELETED FROM WF_PRC_DATA ");
                        pStmt.close();
                        pStmt = null;
                    }
                    if (!this.isProcessExists(processId, instanceId, argumentId, con)) {
                        String prcDataInsQuery;
                        WorkflowLogger.info("CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "]");
                        if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                            WorkflowLogger.info("Using mssql with binary stream");
                            prcDataInsQuery = "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE, REF_SER, REF_ID) VALUES(?,?,?,?,?,?)";
                            pStmt = con.prepareStatement(prcDataInsQuery);
                            pStmt.setString(1, processId);
                            pStmt.setInt(2, instanceId);
                            pStmt.setString(3, argumentId);
                            byte[] encoded = argumentValue.getBytes();
                            ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                            pStmt.setBinaryStream(4, byteArrayIn, byteArrayIn.available());
                            pStmt.setString(5, refSer);
                            pStmt.setString(6, refID);
                            int noOfRows = pStmt.executeUpdate();
                            BaseLogger.log("3", null, null, "noOfRows[" + noOfRows + "]");
                            statusString = noOfRows > 0 ? "true" : "false";
                            pStmt.close();
                            pStmt = null;
                        } else {
                            BaseLogger.log("3", null, null, "@@@@ argumentValue :[ " + argumentValue + " ]");
                            prcDataInsQuery = "";
                            prcDataInsQuery = argumentId.equalsIgnoreCase("$XML_DATA_ALL") ? "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE,ARGUMENT_VALUE_XML, REF_SER, REF_ID) VALUES(?,?,?,EMPTY_BLOB(),?,?,?)" : "INSERT INTO WF_PRC_DATA(PROCESS_ID,INSTANCE_ID,ARGUMENT_ID,ARGUMENT_VALUE, REF_SER, REF_ID) VALUES(?,?,?,EMPTY_BLOB(),?,?)";
                            pStmt = con.prepareStatement(prcDataInsQuery);
                            pStmt.setString(1, processId);
                            pStmt.setInt(2, instanceId);
                            pStmt.setString(3, argumentId);
                            if (argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                                XMLType argumentValueXml = XMLType.createXML((Connection)con, (String)argumentValue);
                                if (oConnection != null) {
                                    oConnection.close();
                                    oConnection = null;
                                }
                                pStmt.setObject(4, argumentValueXml);
                                pStmt.setString(5, refSer);
                                pStmt.setString(6, refID);
                            } else {
                                pStmt.setString(4, refSer);
                                pStmt.setString(5, refID);
                            }
                            pStmt.executeUpdate();
                            pStmt.close();
                            pStmt = null;
                        }
                    }
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME) && argumentId.equalsIgnoreCase("$XML_DATA_ALL")) {
                        String query = "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID=? FOR UPDATE NOWAIT";
                        ArrayList<String> bindVarValues = new ArrayList<String>();
                        bindVarValues.add(processId);
                        bindVarValues.add(String.valueOf(instanceId));
                        bindVarValues.add(argumentId);
                        ArrayList<String> bindVarTypes = new ArrayList<String>();
                        bindVarTypes.add("String");
                        bindVarTypes.add("Int");
                        bindVarTypes.add("String");
                        WorkflowLogger.info("Updating Workflow data for Process Id :[" + processId + "] Instance Id :[" + instanceId + "]");
                        WorkflowLogger.info("Argument Id :[" + argumentId + "] Argument Value :[" + argumentValue + "]");
                        boolean updStatus = this.updateBlob(con, query, argumentValue, bindVarValues, bindVarTypes);
                        WorkflowLogger.info("saveProcessInputData:updStatus[" + updStatus + "]");
                        statusString = updStatus ? "true" : "false";
                    }
                    ++processParamCtr;
                }
            }
            catch (Exception e) {
                try {
                    genericUtility.generateLog(genericUtility.writePrintStacktrace(e), "", String.valueOf(processId) + "_" + instanceId, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    if (con != null && !con.isClosed() && isConnLocal) {
                        con.commit();
                        con.close();
                        con = null;
                    }
                    if (oConnection != null) {
                        oConnection.close();
                        oConnection = null;
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return statusString;
    }
}

