/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.bean.ExtAuthApplicationBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CryptographyUtil;
import ibase.utility.UserInfoBean;
import ibase.webService.RestAPIService;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ExtAuthAppServiceUtility;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;

@Path(value="/ExtAuthAppService")
public class ExtAuthAppService
extends RestAPIService {
    protected UserInfoBean userInfo = null;
    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
    APIUtility apiUtility = new APIUtility();
    String dirName = String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump" + File.separator + "forms";

    @GET
    @Path(value="/extauthapi")
    @Produces(value={"application/json"})
    public Response authAPIService(@QueryParam(value="USER_CODE") String userCode, @QueryParam(value="PASSWORD") String password, @QueryParam(value="IS_PWD_ENCRYPT") String isPwdEncrypt, @QueryParam(value="APP_ID") String appId, @QueryParam(value="IS_ADMIN") String isAdminUser, @Context HttpServletRequest request) throws BaseException, Exception {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        JSONObject resultJson = e12extauthappserviceutility.Login(userCode, password, isPwdEncrypt, appId, isAdminUser, request);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/extlogout")
    @Produces(value={"application/json"})
    public Response logoutAPIService(@QueryParam(value="JWT") String jwt, @QueryParam(value="APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        JSONObject resultJson = e12extauthappserviceutility.Logout(jwt, appId, request);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/getfileslist")
    @Produces(value={"application/json"})
    public Response getFilesList(@Context HttpServletRequest request, @QueryParam(value="JWT") String jwt, @QueryParam(value="APP_ID") String appId) throws IOException, Exception {
        ExtAuthApplicationBean applicationBean = this.getCommonDBAccess().getExtAuthApplicationInfo(appId);
        String jwtResult = CryptographyUtil.parseBase64EncodedJWT((String)jwt, (String)applicationBean.getSharedKey());
        BaseLogger.log((String)"3", null, null, (Object)("dirName =" + this.dirName));
        if (!jwtResult.equalsIgnoreCase("invalid") && !jwtResult.equalsIgnoreCase("expired")) {
            if (this.userInfo == null) {
                this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwt);
            }
            if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                return Response.status((int)200).entity((Object)"Daily API call limit exceeded").build();
            }
            ArrayList<String> arrList = new ArrayList<String>();
            File fileSource = new File(this.dirName);
            if (!fileSource.exists()) {
                BaseLogger.log((String)"3", null, null, (Object)"File Directory doesn't exist");
            } else {
                File[] files;
                BaseLogger.log((String)"3", null, null, (Object)"File Directory exist");
                File[] fileArray = files = fileSource.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isFile()) {
                        try {
                            arrList.add(f.getName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            return Response.status((int)200).entity((Object)arrList.toString()).build();
        }
        return Response.status((int)401).entity((Object)"Unauthorized User!").build();
    }

    @GET
    @Path(value="/downloadfile")
    @Produces(value={"application/json"})
    public Response downnloadFile(@QueryParam(value="JWT") String jwt, @QueryParam(value="APP_ID") String appId, @QueryParam(value="FILENAME") String filename, @Context HttpServletRequest req) throws BaseException, Exception {
        ExtAuthApplicationBean applicationBean = this.getCommonDBAccess().getExtAuthApplicationInfo(appId);
        String jwtResult = CryptographyUtil.parseBase64EncodedJWT((String)jwt, (String)applicationBean.getSharedKey());
        if (!jwtResult.equalsIgnoreCase("expired") && !jwtResult.equalsIgnoreCase("invalid")) {
            if (this.userInfo == null) {
                this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwt);
            }
            if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                return Response.status((int)200).entity((Object)"Daily API call limit exceeded").build();
            }
            String url = String.valueOf(this.dirName) + File.separator + filename;
            File file = new File(url);
            return Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
        }
        return Response.status((int)401).entity((Object)"Unauthorized User!").build();
    }

    @GET
    @Path(value="/updateJWTtoken/{tokenId}/{appId}/{userCode}")
    @Produces(value={"application/json"})
    public Response updateJWTtoken(@PathParam(value="tokenId") String tokenId, @PathParam(value="appId") String appId, @PathParam(value="userCode") String userCode) throws BaseException, Exception {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        BaseLogger.log((String)"3", null, null, (Object)("method::: updateJWTtoken variable::: tokenId" + tokenId));
        BaseLogger.log((String)"3", null, null, (Object)("method::: updateJWTtoken variable::: appId" + appId));
        BaseLogger.log((String)"3", null, null, (Object)("method::: updateJWTtoken variable::: userCode" + userCode));
        String result = e12extauthappserviceutility.updateJWTToken(tokenId, appId, userCode);
        return Response.status((int)200).entity((Object)result).build();
    }

    @POST
    @Path(value="/uploadfiles")
    @Consumes(value={"multipart/form-data"})
    public void uploadFiles(@Context HttpServletRequest req, @QueryParam(value="JWT") String jwt, @QueryParam(value="APP_ID") String appId, @QueryParam(value="USERNAME") String username, @QueryParam(value="PASSWORD") String password) throws BaseException, Exception {
        String status = "";
        String result = "";
        ExtAuthApplicationBean applicationBean = this.getCommonDBAccess().getExtAuthApplicationInfo(appId);
        String jwtResult = CryptographyUtil.parseBase64EncodedJWT((String)jwt, (String)applicationBean.getSharedKey());
        if (!jwtResult.equalsIgnoreCase("expired") && !jwtResult.equalsIgnoreCase("invalid")) {
            if (this.userInfo == null) {
                this.userInfo = this.apiUtility.createUserInfoFromJWTToken(jwt);
            }
            if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                status = "Reject";
                result = "Daily API call limit exceeded";
            } else {
                BaseLogger.log((String)"3", null, null, (Object)"Valid Token");
                String filename = req.getHeader("x-file-name");
                String fileType = req.getHeader("x-file-type");
                BaseLogger.log((String)"3", null, null, (Object)("name =" + filename + "\n type =" + fileType));
                ServletInputStream inputstream = req.getInputStream();
                ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int readed = -1;
                while ((readed = inputstream.read(buffer)) != -1) {
                    ((OutputStream)outputstream).write(buffer, 0, readed);
                }
                byte[] barray = outputstream.toByteArray();
                StringBuffer retXMLStringBuff = null;
                DocumentHandlerWrapperEJB docHandlerWrapperEJB = new DocumentHandlerWrapperEJB();
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                UserInfoBean userInfoBean = commonDBAccessEJB.getBasicUserInfo(username);
                String doc_name = filename;
                String doc_passwd = password;
                String docLinkOptn = "DOC_CONTENT";
                String docType = "PDF";
                if (fileType != null) {
                    docType = fileType;
                }
                byte[] previewImage = new byte[]{};
                retXMLStringBuff = new StringBuffer();
                retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
                retXMLStringBuff.append("<DocumentRoot>");
                retXMLStringBuff.append("<description>Datawindow Root</description>");
                retXMLStringBuff.append("<group0>");
                retXMLStringBuff.append("<description>Group0 description</description>");
                retXMLStringBuff.append("<Header0>");
                retXMLStringBuff.append("<description>Header0 members</description>");
                retXMLStringBuff.append("<header>");
                retXMLStringBuff.append("<username><![CDATA[" + username + "]]></username>");
                retXMLStringBuff.append("<doc_password><![CDATA[" + doc_passwd + "]]></doc_password>");
                retXMLStringBuff.append("<doc_name><![CDATA[" + doc_name + "]]></doc_name>");
                retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
                retXMLStringBuff.append("<created_by><![CDATA[").append(username).append("]]></created_by>");
                retXMLStringBuff.append("<doc_type><![CDATA[").append(docType).append("]]></doc_type>");
                retXMLStringBuff.append("<document_type><![CDATA[").append(docType).append("]]></document_type>");
                retXMLStringBuff.append("</header>");
                retXMLStringBuff.append("</Header0>");
                retXMLStringBuff.append("</group0>");
                retXMLStringBuff.append("</DocumentRoot>");
                docHandlerWrapperEJB.addDocument(retXMLStringBuff.toString(), barray, previewImage, userInfoBean);
            }
        } else {
            BaseLogger.log((String)"3", null, null, (Object)"Invalid token");
        }
    }

    @POST
    @Path(value="/fileWrite")
    @Produces(value={"application/json"})
    public Response fileWrite(@FormParam(value="fileData") String fileData, @FormParam(value="fileDetails") String fileDetails, @FormParam(value="JWT") String jwt, @FormParam(value="APP_ID") String appId, @Context HttpServletRequest request) throws ITMException {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        JSONObject resultJson = e12extauthappserviceutility.fileWrite(fileData, fileDetails, jwt, appId, request);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/writeFileObject")
    @Produces(value={"application/json"})
    public Response writeFileObject(@Context HttpServletRequest request) throws ITMException {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        JSONObject resultJson = e12extauthappserviceutility.writeFileObject(request);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/tokenExchange")
    public Response getShortLivedJWTToken(@FormParam(value="JWT") String jwtToken, @FormParam(value="APP_ID") String appId, @Context HttpServletRequest request) throws ITMException {
        ExtAuthAppServiceUtility e12extauthappserviceutility = new ExtAuthAppServiceUtility();
        JSONObject resultJson = e12extauthappserviceutility.tokenExchange(jwtToken, appId, request);
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }
}

