/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.bean;

import ibase.bi.ejb.session.BusinessAreaEJB;
import ibase.bi.ejb.session.BusinessDetailEJB;
import ibase.bi.ejb.session.DBAccessEJB;
import ibase.bi.utility.BIException;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class BusinessDetailJB
extends DefaultHandler
implements Serializable {
    public int baID;
    public String baName;
    public String baType;
    boolean table;
    boolean tName;
    boolean cName;
    boolean root;
    StringBuffer sb;
    int tCount = 0;
    int cCount = 0;
    String prevTable = "a" + this.tCount;
    String prevColumn = "b" + this.cCount;
    String hidden;
    String xmlStr;
    private ArrayList baIdList = new ArrayList();
    private ArrayList baUserLevList = new ArrayList();
    private int userLevel = -1;

    public String getBusinessAreas(String user) throws Exception {
        BaseLogger.log("2", null, null, "[BusinessAreaJB][getBusinessAreas]");
        BusinessAreaEJB businessAreaRemote = new BusinessAreaEJB();
        String retStr = null;
        try {
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            businessAreaRemote = new BusinessAreaEJB();
            retStr = businessAreaRemote.getBusinessAreaTreeXML(user);
            businessAreaRemote.stopSession();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception In--->BusinessAreaJB.getBusinessAreas()");
            retStr = null;
            throw e;
        }
        return retStr;
    }

    public void setBaID(int baID) throws Exception {
        try {
            this.baID = baID;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setBaName(String mBaName) throws Exception {
        try {
            this.baName = mBaName = mBaName.replace(' ', '_');
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public int getBaID() throws Exception {
        try {
            return this.baID;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getBaName() throws Exception {
        try {
            return this.baName;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getFunctionNames(String baName, String userId) throws Exception {
        ArrayList dbArraylist = null;
        try {
            BusinessDetailEJB ejbObj = new BusinessDetailEJB();
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            ejbObj = new BusinessDetailEJB();
            dbArraylist = ejbObj.getFunctionNames(baName, userId);
            ejbObj.stopSession();
        }
        catch (Exception e) {
            dbArraylist = null;
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return dbArraylist;
    }

    public boolean getTree(String userID, String profileID) throws Exception {
        String jsStr;
        block5: {
            BaseLogger.log("2", null, null, "\nBusinessDetailJB ==> Calling getTree..");
            String fileStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + userID + File.separator + "js" + File.separator + this.baName + "tree.js";
            BaseLogger.log("3", null, null, "JS file :" + fileStr);
            File file = new File(fileStr);
            if (file.exists()) {
                BaseLogger.log("3", null, null, String.valueOf(file.getName()) + " Exists");
                return true;
            }
            BusinessDetailEJB ejbObj = new BusinessDetailEJB();
            try {
                String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + userID + File.separator + "js" + File.separator;
                File dir = new File(dirStr);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                AppConnectParm appConnect = new AppConnectParm("bi");
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                ejbObj = new BusinessDetailEJB();
                jsStr = ejbObj.getBusinessDetailTree(this.baID, this.baName, userID, profileID);
                ejbObj.stopSession();
                if (jsStr != null) break block5;
                return false;
            }
            catch (Exception e) {
                BIException.setErrorCode(0);
                e.printStackTrace();
                throw e;
            }
        }
        return this.writeJSFiles(jsStr, userID);
    }

    public void setBaType(String mBaType) throws Exception {
        this.baType = mBaType;
    }

    public String getBAType() throws Exception {
        AppConnectParm appConnect = new AppConnectParm("bi");
        Properties props = appConnect.getProperty();
        InitialContext ctx = new InitialContext(props);
        DBAccessEJB mDBAccessRemote = new DBAccessEJB();
        this.baType = mDBAccessRemote.getBAType(this.baName);
        return this.baType;
    }

    private boolean writeJSFiles(String jsStr, String userID) throws Exception {
        boolean returnVal = false;
        try {
            File dir = new File(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator);
            File[] dirList = dir.listFiles();
            int dirListSize = dirList.length;
            File userDir = null;
            String jsFileStr = null;
            int i = 0;
            while (i < dirListSize) {
                userDir = dirList[i];
                if (userDir.isDirectory()) {
                    jsFileStr = String.valueOf(userDir.getPath()) + File.separator + "js" + File.separator + this.baName + "tree.js";
                    if (userDir.getName().equalsIgnoreCase(userID)) {
                        returnVal = this.writeDocument(jsStr, jsFileStr);
                    } else if (!userDir.getName().equalsIgnoreCase("common") && !userDir.getName().equalsIgnoreCase("temp") && new File(jsFileStr).exists()) {
                        this.writeDocument(jsStr, jsFileStr);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :writeJSFiles :==>");
            throw e;
        }
        return returnVal;
    }

    private boolean writeDocument(String str, String path) throws Exception {
        try {
            File file = new File(path);
            FileWriter fw = new FileWriter(file);
            fw.write(str);
            fw.flush();
            fw.close();
            BaseLogger.log("3", null, null, String.valueOf(file.getName()) + " Created");
            return true;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :writeDocument :==>");
            e.printStackTrace();
            throw e;
        }
    }

    public void loadSchemaTree(String user) throws Exception {
        try {
            String fileStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + user + File.separator + "js" + File.separator + "Schematree.js";
            File file = new File(fileStr);
            if (file.exists()) {
                BaseLogger.log("3", null, null, String.valueOf(file.getName()) + " Exists");
            } else {
                AppConnectParm appConnect = new AppConnectParm("bi");
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                BusinessAreaEJB businessAreaRemote = new BusinessAreaEJB();
                String baInfoXML = businessAreaRemote.getBusinessAreaTreeXML(user);
                if (baInfoXML != null) {
                    this.populateBaInfo(baInfoXML, user);
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void populateBaInfo(String baInfoXML, String userCode) throws Exception {
        try {
            BaseLogger.log("3", null, null, "In populateBaInfo");
            String jsStr = this.getJSTree(baInfoXML);
            this.fileWriter(jsStr, userCode);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getJSTree(String xmlStr) throws Exception {
        StringBuffer menu = new StringBuffer();
        try {
            BaseLogger.log("3", null, null, "In getJSTree");
            menu.append("var tr; \n if (document.getElementById) {\n");
            menu.append("var tree = new WebFXTree('My Schemas');\n");
            if (xmlStr != null && xmlStr.length() > 0) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                ByteArrayInputStream baIn = new ByteArrayInputStream(xmlStr.getBytes());
                Document doc = db.parse(baIn);
                NodeList ndList = doc.getElementsByTagName("SCHEMA_TREE");
                Node rootNode = ndList.item(0);
                menu.append(this.buildChildNodes(rootNode, "tree"));
            }
            menu.append("}\n");
            menu.append("function loadTree(id)\n {\n");
            menu.append("tr = document.all[id];\n");
            menu.append("tr.insertAdjacentHTML(\"BeforeEnd\",tree);\n");
            menu.append("}\n");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: BusinessAreaEJB: getJSTree: ==>\n" + e);
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return menu.toString();
    }

    public StringBuffer buildChildNodes(Node node, String value) throws Exception {
        StringBuffer newMenu = new StringBuffer();
        try {
            NodeList tempNodeList = node.getChildNodes();
            int tempHierCnt = 1;
            int tempBaCnt = 1;
            int i = 0;
            while (i < tempNodeList.getLength()) {
                String tempVar;
                Node ndHier = tempNodeList.item(i);
                if (ndHier.getNodeName().startsWith("HIERKEY_LEVEL_")) {
                    String itemName = ndHier.getAttributes().getNamedItem("TITLE").getNodeValue();
                    String iconPath = ndHier.getAttributes().getNamedItem("ICON").getNodeValue();
                    String descr = ndHier.getFirstChild().getNodeValue();
                    tempVar = String.valueOf(value) + "_" + tempHierCnt;
                    if (iconPath.equalsIgnoreCase("null")) {
                        iconPath = "/ibase/bi/images/foldericon.png";
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "'," + tempVar + ",'','','" + iconPath + "','','" + descr + "');\n");
                    } else {
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "'," + tempVar + ",'','','" + iconPath + "','" + iconPath + "','" + descr + "');\n");
                    }
                    newMenu.append(this.buildChildNodes(ndHier, tempVar));
                    newMenu.append(String.valueOf(value) + ".add(" + tempVar + ");\n");
                    ++tempHierCnt;
                }
                if (ndHier.getNodeName().startsWith("BUSINESS_AREA_")) {
                    String schemaName = ndHier.getAttributes().getNamedItem("SCHEMA_NAME").getNodeValue();
                    String itemName = ndHier.getAttributes().getNamedItem("BA_TITLE").getNodeValue();
                    String iconPath = ndHier.getAttributes().getNamedItem("ICON").getNodeValue();
                    tempVar = String.valueOf(value) + "_b" + tempBaCnt;
                    String lev = ndHier.getAttributes().getNamedItem("USR_ACC_LEV").getNodeValue();
                    int baID = Integer.parseInt(ndHier.getAttributes().getNamedItem("BA_ID").getNodeValue());
                    String descr = ndHier.getFirstChild().getNodeValue();
                    this.baIdList.add(new Integer(ndHier.getAttributes().getNamedItem("BA_ID").getNodeValue()));
                    if (!lev.equalsIgnoreCase("null") && lev.length() > 0) {
                        int usrAccLev = Integer.parseInt(lev);
                        this.baUserLevList.add(new Integer(usrAccLev));
                    } else {
                        this.baUserLevList.add(new Integer(this.userLevel));
                    }
                    if (iconPath.equalsIgnoreCase("null")) {
                        iconPath = "/ibase/bi/images/file.png";
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "','" + baID + "','showtree.jsp?baID=" + baID + "&baName=" + schemaName + "&edit=false','','" + iconPath + "','','" + descr + "');\n");
                    } else {
                        newMenu.append("var " + tempVar + " = new WebFXTreeItem('" + itemName + "','" + baID + "','showtree.jsp?baID=" + baID + "&baName=" + schemaName + "&edit=false','','" + iconPath + "','" + iconPath + "','" + descr + "');\n");
                    }
                    newMenu.append(String.valueOf(value) + ".add(" + tempVar + ");\n");
                    ++tempBaCnt;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return newMenu;
    }

    public void fileWriter(String xmlFile, String userCode) throws Exception {
        try {
            String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + userCode + File.separator + "js" + File.separator;
            File dir = new File(dirStr);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileWriter fw = new FileWriter(String.valueOf(dirStr) + "Schematree.js");
            fw.write(xmlFile);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getBAIDList() {
        return this.baIdList;
    }

    public ArrayList getBaUserLevList() {
        return this.baUserLevList;
    }

    public int getUsrLevForBAID(int baId, String userID) throws Exception {
        int usrLev = this.userLevel;
        try {
            int index = this.baIdList.indexOf(new Integer(baId));
            if (index != -1) {
                usrLev = (Integer)this.baUserLevList.get(index);
            } else {
                AppConnectParm appConnect = new AppConnectParm("bi");
                Properties props = appConnect.getProperty();
                InitialContext ctx = new InitialContext(props);
                DBAccessEJB mDBAccessRemote = new DBAccessEJB();
                usrLev = mDBAccessRemote.getUsrLevForBAID(baId, userID);
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return usrLev;
    }

    public ArrayList getUserReports(String user) throws Exception {
        ArrayList<String> userReports = null;
        try {
            userReports = new ArrayList<String>();
            String userBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + user + File.separator + "userbi";
            File userBIDir = new File(userBIReportsPath);
            if (userBIDir.exists()) {
                String[] fileList = userBIDir.list();
                int i = 0;
                while (i < fileList.length) {
                    userReports.add(fileList[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TabManagerBean :getUserReports :==>" + e.getMessage());
            throw e;
        }
        return userReports;
    }

    private String getJSTree(String user, boolean commonFlag) throws Exception {
        StringBuffer jsBuff = null;
        try {
            jsBuff = new StringBuffer("var tr; \n if (document.getElementById) {\n");
            if (!commonFlag) {
                jsBuff.append("var tree = new WebFXTree('" + user + "');\n");
                jsBuff.append("tree.setBehavior('Classic');\n");
                String userBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + user;
                File userBIDir = new File(userBIReportsPath);
                if (userBIDir.exists()) {
                    File[] fileList = userBIDir.listFiles();
                    int i = 0;
                    while (i < fileList.length) {
                        BaseLogger.log("3", null, null, "file/Directory :" + fileList[i].getName());
                        if (fileList[i].isDirectory()) {
                            jsBuff.append("var a = new WebFXTreeItem('" + fileList[i].getName() + "');\n");
                            jsBuff.append("tree.add(a);\n");
                        }
                        ++i;
                    }
                }
            } else {
                jsBuff.append("var tree = new WebFXTree('Common');\n");
                jsBuff.append("tree.setBehavior('Classic');\n");
                String commonBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common";
                File commonBIDir = new File(commonBIReportsPath);
                if (commonBIDir.exists()) {
                    File[] fileList = commonBIDir.listFiles();
                    int i = 0;
                    while (i < fileList.length) {
                        BaseLogger.log("3", null, null, "file/Directory :" + fileList[i].getName());
                        if (fileList[i].isDirectory() && fileList[i].getName().equals("userbi")) {
                            jsBuff.append("var a = new WebFXTreeItem('" + fileList[i].getName() + "');\n");
                            jsBuff.append("tree.add(a);\n");
                        }
                        ++i;
                    }
                }
            }
            jsBuff.append("}\n");
            jsBuff.append("function loadTree(){\n");
            jsBuff.append("tr=document.all['TreeDiv'];\n");
            jsBuff.append("tr.insertAdjacentHTML(\"BeforeEnd\", tree);\n");
            jsBuff.append("}\n");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getJSStr :==>\n" + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return jsBuff.toString();
    }

    public boolean getCommonBIReportsTree(String user) throws Exception {
        String jsStr;
        String fileStr;
        block4: {
            fileStr = null;
            try {
                boolean commonFlag = true;
                fileStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + "common" + File.separator + "js" + File.separator + "BIReportsTree.js";
                String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + "common" + File.separator + "js" + File.separator;
                File dir = new File(dirStr);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((jsStr = this.getJSTree(user, commonFlag)) != null) break block4;
                return false;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getCommonBIReportsTree :==>\n" + e.getMessage());
                throw e;
            }
        }
        return this.writeDocument(jsStr, fileStr);
    }

    public ArrayList getCommonReports() throws Exception {
        ArrayList<String> userReports = null;
        try {
            userReports = new ArrayList<String>();
            String commonBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "userbi";
            File commonBIDir = new File(commonBIReportsPath);
            if (commonBIDir.exists()) {
                String[] fileList = commonBIDir.list();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].indexOf(".xml") != -1) {
                        userReports.add(fileList[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getCommonReports :==>" + e.getMessage());
            throw e;
        }
        return userReports;
    }

    public ArrayList getCommonReportsList() throws Exception {
        ArrayList userReports = null;
        try {
            userReports = new ArrayList();
            String commonBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common";
            File commonBIDir = new File(commonBIReportsPath);
            if (commonBIDir.exists()) {
                File[] fileList = commonBIDir.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    BaseLogger.log("3", null, null, "file/Directory :" + fileList[i].getName());
                    if (fileList[i].isDirectory() && fileList[i].getName().equals("userbi")) {
                        ArrayList<String> currUserReports = new ArrayList<String>();
                        currUserReports.add(fileList[i].getName());
                        String[] files = fileList[i].list();
                        int j = 0;
                        while (j < files.length) {
                            if (files[j].indexOf(".xml") != -1 && files[j].indexOf("EMailBIReport") == -1) {
                                currUserReports.add(files[j]);
                            }
                            ++j;
                        }
                        userReports.add(currUserReports);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getCommonReportsList :==>" + e.getMessage());
            throw e;
        }
        return userReports;
    }

    public ArrayList getUserReportsList(String user) throws Exception {
        ArrayList userReports = null;
        try {
            userReports = new ArrayList();
            String userBIReportsPath = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + user;
            File userBIDir = new File(userBIReportsPath);
            if (userBIDir.exists()) {
                File[] fileList = userBIDir.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        BaseLogger.log("3", null, null, "Directory :" + fileList[i].getName());
                        ArrayList<String> currUserReports = new ArrayList<String>();
                        currUserReports.add(fileList[i].getName());
                        String[] files = fileList[i].list();
                        int j = 0;
                        while (j < files.length) {
                            if (files[j].indexOf(".xml") != -1 && files[j].indexOf("EMailBIReport") == -1) {
                                currUserReports.add(files[j]);
                            }
                            ++j;
                        }
                        userReports.add(currUserReports);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getUserReportsList :==>" + e.getMessage());
            throw e;
        }
        return userReports;
    }

    public ArrayList getBusinessAreasList(String user) throws Exception {
        ArrayList businessAreasList = null;
        try {
            AppConnectParm appConnect = new AppConnectParm("bi");
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for BusinessArea EJB with Properties==>\n" + p);
            BusinessAreaEJB businessArea = new BusinessAreaEJB();
            businessAreasList = businessArea.getBusinessAreasList(user);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getBusinessAreasList :==>\n" + e.getMessage());
            throw e;
        }
        return businessAreasList;
    }

    public boolean getUserBIReportsTree(String user, String profileID) throws Exception {
        String jsStr;
        String fileStr;
        block4: {
            fileStr = null;
            try {
                boolean commonFlag = false;
                fileStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + user + File.separator + "js" + File.separator + "BIReportsTree.js";
                String dirStr = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + user + File.separator + "js" + File.separator;
                File dir = new File(dirStr);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((jsStr = this.getJSTree(user, commonFlag)) != null) break block4;
                return false;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :BusinessDetailJB :getUserBIReportsTree :==>\n" + e.getMessage());
                throw e;
            }
        }
        return this.writeDocument(jsStr, fileStr);
    }
}

