package ibase.webitm.utility.wsfa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.jcr.query.Row;
import javax.servlet.http.HttpServletRequest;

import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import ibase.system.config.ConnDriver;

public class XSLUpdateUtility {

	public String updateXSL(HttpServletRequest request) throws Exception 
	{
        try 
        {
        	Connection connection = null;
    		PreparedStatement pstmt = null;
    		ResultSet rs = null;
            FileInputStream fileIn = new FileInputStream(new File("/wildfly/server/default/deploy/ibase.ear/metadata/Custom_Template.xls"));
            XSSFWorkbook workbook = new XSSFWorkbook(fileIn);
            fileIn.close();
            XSSFSheet sheet = workbook.getSheet("Product");
            
            ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("Driver");
			String sql ="select product_code, descr, sh_descr, product_type, brand_code, item_ser from product";
			pstmt = connection.prepareStatement(sql);
			rs = pstmt.executeQuery();
           
            int rowNum = 1; 
            while (rs.next()) 
            {
                Row row = (Row) sheet.createRow(rowNum++);
                ((XSSFRow) row).createCell(0).setCellValue(rs.getString("product_code"));
                ((XSSFRow) row).createCell(1).setCellValue(rs.getString("descr"));
                ((XSSFRow) row).createCell(2).setCellValue(rs.getString("sh_descr"));
                ((XSSFRow) row).createCell(3).setCellValue(rs.getString("product_type"));
                ((XSSFRow) row).createCell(4).setCellValue(rs.getString("brand_code"));
                ((XSSFRow) row).createCell(5).setCellValue(rs.getString("item_ser"));
            }
            
            FileOutputStream fileOut = new FileOutputStream(new File("/wildfly/server/default/deploy/ibase.ear/metadata/Custom_Template.xls"));
            workbook.write(fileOut);
            fileOut.close();

            return "XSL file updated successfully";
        } 
        catch (IOException | SQLException e) 
        {
            e.printStackTrace();
            return "Error updating XSL file: " + e.getMessage();
        }
    }
	
}
