package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;

import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.utility.CommonConstants;
//@javax.ejb.Stateless          commented by Sagar M [22 Nov 2018].

public class StrgBrandActWizPreSaveEJB extends ValidatorEJB //implements SessionBean
{	/*
	public void ejbCreate() throws RemoteException, CreateException
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
		System.out.println("ejbPassivate() method calling........");
	}*/

	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams,Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String objName = "";
		String tranId = "";
		String salesPers = "";
		String prdCode = "";

		PreparedStatement pStmtOuter = null;
		Document dom = null;

		boolean isError = false;
		boolean isLocalConn = false;

		try
		{

			isLocalConn = true;
			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);
			objName  = getObjNameFromDom( dom, "objName");
			System.out.println("objName["+objName+"]");

			System.out.println("domString StrgBrandActWizPreSaveEJB ["+domString+"]");
			//tranId = genericUtility.getColumnValue("tran_id", dom, "1", "");
			salesPers = genericUtility.getColumnValue("sales_pers", dom, "1", "");
			prdCode = genericUtility.getColumnValue("prd_code", dom, "1", "");//17/04/13
			System.out.println("salesPers =[" + salesPers + "], tranId =[" + tranId + "]  prdCode=["+prdCode+"]" );
			int updateCnt = 0;

					String selectSql = "SELECT TRAN_ID FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ?";
					PreparedStatement selectPstmt = conn.prepareStatement(selectSql);
					selectPstmt.setString(1, salesPers);
					selectPstmt.setString(2,prdCode);
					ResultSet selectRs = selectPstmt.executeQuery();
					while(selectRs.next())
					{
						tranId = selectRs.getString("TRAN_ID");
						System.out.println("TRAN_ID to be deleted [" + tranId + "]");
						String sql = "DELETE FROM STRG_BRAND_ACT WHERE TRAN_ID = ?";
						System.out.println(" Delete if record exist["+sql+"]");
						PreparedStatement pStmt = conn.prepareStatement( sql );
						pStmt.setString( 1, tranId);
						updateCnt = pStmt.executeUpdate();
						// Added By Hariom S for close dirty Connection --30-Aug-2021 [Start]
						if(pStmt != null)
						{
							pStmt.close();
							pStmt = null;
						}
						// Added By Hariom S for close dirty Connection --30-Aug-2021 [End]
						System.out.println("[StrgBrandActWizPreSaveEJB]Update Count for deleting from sprs_act_tran:"+updateCnt);

						sql = "DELETE FROM STRG_BRAND_ACT_DET WHERE TRAN_ID = ?";
						pStmt = conn.prepareStatement( sql );
						pStmt.setString( 1, tranId);
						updateCnt = pStmt.executeUpdate();
						if(pStmt!=null)
						{
							pStmt.close(); 
							pStmt = null;
						}
						System.out.println("[StrgBrandActWizPreSaveEJB]Update Count for deleting from sprs_travel:"+updateCnt);

					}
					//Added by Hariom for connection close change --19-Jan-21 [Start]
					if (selectRs!= null)
					{
						selectRs.close();
						selectRs = null;
					}
					if(selectPstmt!=null)
					{
						selectPstmt.close();
						selectPstmt = null;
					}
					//Added by Hariom for connection close change --19-Jan-21 [End]
					
					
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaDSRWizPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				/*conn.commit();
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
						}
						conn.close();
						conn = null;
					}

				}

				if(pStmtOuter != null)
				{
					pStmtOuter.close();
					pStmtOuter = null;
				}*/
			}
			catch(Exception e)
			{
				System.out.println("Exception :WsfaDSRWizPreSaveEJB : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}

	private String getObjNameFromDom( Document dom, String attribute ) throws RemoteException,ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail1");
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private String getPropertiesVal(Connection conn, String propName) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if(rsProp != null)
			{
				rsProp.close(); 
				rsProp = null;
			}
			if(pstmtProp != null)
			{
				pstmtProp.close();
				 pstmtProp = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		}
		catch(Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e){}
		}
		System.out.println("propVal for "+propName+" =["+propVal+"]");
		return propVal;
	}
	private boolean isActivityCodeExist( String activityCode , String propName,Connection conn ) throws Exception
	{
		System.out.println(" >>> Inside  isActivityCodeExist() <<< ");
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		boolean isActivityExist=false;
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if(rsProp != null)
			{
				rsProp.close(); rsProp = null;
			}
			if(pstmtProp != null)
			{
				pstmtProp.close(); pstmtProp = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
			if(propVal.length() > 0)
			{
				ArrayList propValList = new ArrayList<String>(Arrays.asList(propVal.split(",")));
				if(propValList.contains(activityCode))
				{
					isActivityExist = true;
				}
			}

		}
		catch(Exception e)
		{
			System.out.println("isActivityCodeExist Catch Exception"+e.getMessage());
			throw e;

		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Finaly Catch Exception"+e.getMessage());
			}
		}
		System.out.println("is Activity code exist =["+isActivityExist+"]");

	    return 	 isActivityExist;

	}
	private String getDCRId(Connection conn, String salesPers, String dcrDate, String selActCode) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			GenericUtility genericUtility = GenericUtility.getInstance();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Select the activity type of selected activity code
			String selActType = "";
			String actTypeSql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";

			PreparedStatement pstmtActType = conn.prepareStatement( actTypeSql );
			pstmtActType.setString(1, selActCode);
			ResultSet rsActType = pstmtActType.executeQuery();
			if( rsActType.next() )
			{
				selActType = checkNull(rsActType.getString("ACTIVITY_TYPE"));
			}
			if(rsActType != null)
			{
				rsActType.close();
				rsActType = null;
			}
			if(pstmtActType != null)
			{
				pstmtActType.close();
				pstmtActType = null;
			}
			
			//Select the activity code from sprs_act_tran of selected activity type
			String actCodeDb = "";
			String actCodeSql = "SELECT A.ACTIVITY_CODE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE = ? ";

			PreparedStatement pstmtActCode = conn.prepareStatement( actCodeSql );
			pstmtActCode.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtActCode.setString(2, salesPers);
			pstmtActCode.setString(3, selActType);
			ResultSet rsActCode = pstmtActCode.executeQuery();
			if( rsActCode.next() )
			{
				actCodeDb = checkNull(rsActCode.getString("ACTIVITY_CODE"));
			}
			rsActCode.close();rsActCode = null;
			pstmtActCode.close();pstmtActCode = null;

			if(actCodeDb.trim().length() > 0)
			{
				activityCode = actCodeDb;
			}
			else
			{
				activityCode = selActCode;
			}

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ? AND ACTIVITY_CODE = ? ";

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			pstmtDCRID.setString(3, activityCode);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = checkNull(rsDCRID.getString("DCR_ID"));
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if (rsDCRID != null)
			{
				rsDCRID.close();
				rsDCRID = null;
			}
			if(pstmtDCRID !=null)
			{
				pstmtDCRID.close();
				pstmtDCRID = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		return dcrID;
	}

}
