package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;
import java.lang.String;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.util.*;
import java.util.Date;
import java.sql.*;
import java.text.*;
import java.io.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*; 

@Stateless
public class StrgCustChgLocalityPrc extends ProcessEJB implements StrgCustChgLocalityPrcLocal,StrgCustChgLocalityPrcRemote
{
	File filePtr ;
	File logDir ;
	String logDirName = "";			
	static String logOnOffFlag = "Y";//For On-Off Log file.
	String err = "";
	E12GenericUtility genericUtility = new E12GenericUtility();

	static void writeLog(File f,String Msg,boolean flag)
	{
		try
		{  
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			if(logOnOffFlag.trim().equals("Y"))
			{
				pw.println( Msg);		
			}
			pw.close();
		}
		catch(Exception exWm){exWm.printStackTrace();}		
	}
	static void writeLog(File f,Exception Msg,boolean flag)
	{
		try{
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			pw.println(" "+Msg);		
			pw.close();		
		}
		catch(Exception exWm){exWm.printStackTrace();}
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";

		try
		{	
			if(CommonConstants.J2EE_VERSION.equals("1"))
			{
				logDirName =  CommonConstants.JBOSSHOME  + File.separator + "log" ;
			}
			else if(CommonConstants.J2EE_VERSION.equals("2"))
			{
				logDirName =  CommonConstants.JBOSSHOME   + File.separator + "server"+ File.separator +"default"+ File.separator +"log" ;
			}
			logDir = new File(logDirName);
			filePtr = new File(logDirName+ File.separator + "ChgLocality.log");
			writeLog(filePtr,"*****************************************************",true);
			writeLog(filePtr,"xmlString-->"+xmlString,true);
			writeLog(filePtr,"xmlString2-->"+xmlString2,true);
			writeLog(filePtr,"windowName-->"+windowName,true);			

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
				writeLog(filePtr,"headerDom-->"+headerDom,true);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
				writeLog(filePtr,"detailDom-->"+detailDom,true);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{			
			System.out.println("Exception :StrgCustChgLocality :process:" + e.getMessage() + ":");
			e.printStackTrace();
			writeLog(filePtr,"Exception in process-->"+e.getMessage(),true);
			retStr = e.getMessage();
		}
		writeLog(filePtr,"Return from process-->"+retStr,true);
		return retStr;
	}
	// END OF PROCESS ONE

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		Statement stmtTemp = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtSel1 = null;
		PreparedStatement pstmtUpd1 = null;
		PreparedStatement pstmtUpd2 = null;
		PreparedStatement pstmtroute = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		//Added by Bhagyashri T [15/04/2021][Start][W21ASUN029]
		PreparedStatement pstmtStatus = null;
		PreparedStatement pstmtStsupd1 = null;
		PreparedStatement pstmtStsupd2 = null;
		ResultSet rsStatus = null;
		//Added by Bhagyashri T [15/04/2021][End][W21ASUN029]
		String custCode = "";
		String salesPers = "";
		String routeIdExisting = "";
		String statusExisting = "";//Changed by Bhagyashri T [15/04/2021][W21ASUN029]
		String statusNew = "";//Changed by Bhagyashri T [15/04/2021][W21ASUN029]
		String routeIdNew = "";
		String routeType = "";
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
		String retString = "";
		String localityCode = "";
		String sqlStr = "";
		String sqlupdateStr = "";
		String statusSql = ""; //Changed by Bhagyashri T [15/04/2021][W21ASUN029]
		String statusUpd1 = ""; //Changed by Bhagyashri T [15/04/2021][W21ASUN029]
		String statusUpd2 = ""; //Changed by Bhagyashri T [15/04/2021][W21ASUN029]
		String errCode = "";
		String spName = ""; //Gulzar - 9/26	/2008

		int msgCntr = 0;

		StringBuffer warningMsgBuf = new StringBuffer();
		//java.sql.Date chgDate = new java.sql.Date(System.currentTimeMillis());//Gulzar - 14/08/08 Req ID : SY78SUN032
		java.sql.Timestamp chgDate = new java.sql.Timestamp(System.currentTimeMillis()); //Gulzar - 14/08/08 Req ID : SY78SUN032
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]

		//ITMDBAccessLocal itmDBAccessLocal = null;
		ITMDBAccessEJB itmDBAccessLocal = null;

		try
		{
			/*InitialContext ctx = getInitialContext();
			itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			itmDBAccessLocal = new ITMDBAccessEJB();		

			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			custCode = genericUtility.getColumnValue("sc_code",headerDom);
			localityCode = genericUtility.getColumnValue("locality_code",headerDom);
			writeLog(filePtr,"Customer Code From Filter -->" + custCode,true);
			writeLog(filePtr,"Locality Code From Filter -->" + localityCode,true);

			stmt = conn.createStatement();


			// - Added - Gulzar - 14/08/08 Req ID : SY78SUN032
			if(custCode == null || custCode.trim().length() == 0)
			{
				errCode = "NULSPRCODE";
				retString = "Sales Person Code Cannot be Blank";
				//retString = errMsg("sc_code" , errCode , userId , retString);
				retString = itmDBAccessLocal.getErrorString( "sc_code", errCode, userId );
				return retString;
			}
			else
			{
				int custCodeCnt = 0;
				sqlStr = "SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE SC_CODE = '"+custCode+"' ";
				System.out.println("sqlStr : " + sqlStr);
				rs = stmt.executeQuery(sqlStr);
				if (rs.next())
				{
					custCodeCnt = rs.getInt("CNT");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}				
				if (custCodeCnt == 0)
				{
					errCode = "VTSLPERS1";
					retString = "Invalid Sales Person Code";
					//retString = errMsg("sc_code" , errCode , userId , retString);
					retString = itmDBAccessLocal.getErrorString( "sc_code", errCode, userId );
					return retString;
				}
			}
			if(localityCode == null || localityCode.trim().length() == 0)
			{
				errCode = "VMLOCPK";
				retString = "Locality Code Cannot be Blank";
				//retString = errMsg("locality_code" , errCode , userId , retString);
				retString = itmDBAccessLocal.getErrorString( "locality_code", errCode, userId );
				return retString;
			}
			else
			{
				int locCodeCnt = 0;
				String sqlStrCount = "SELECT COUNT(*) AS CNT FROM LOCALITY WHERE LOCALITY_CODE = '"+localityCode+"' ";
				System.out.println("sqlStrCount : " + sqlStrCount);
				rs = stmt.executeQuery(sqlStrCount);
				if (rs.next())
				{
					locCodeCnt = rs.getInt("CNT");
				}
				rs.close();
				rs = null;
				if (locCodeCnt == 0)
				{
					errCode = "VMLOCPK";
					retString = "Invalid Locality Code";
					//retString = errMsg("locality_code" , errCode , userId , retString);
					retString = itmDBAccessLocal.getErrorString( "locality_code", errCode, userId );
					return retString;
				}
			}
			// - End Added - Gulzar - 14/08/08 Req ID : SY78SUN032

			if (custCode != null && custCode.trim().length() > 0 && localityCode != null && localityCode.trim().length() > 0)
			{
				//Modified by Rupesh on [05/07/2012] [Check for Employee resign status and Doctor's status]

				//sqlStr = "SELECT STRG_SERIES.SALES_PERS , STRG_SERIES.ROUTE_ID " + 
				//"FROM STRG_SERIES, SPRS_ROUTE, STRG_CUSTOMER, SALES_PERS " + 
				//"WHERE STRG_SERIES.SC_CODE = '" + custCode + "' " + 
				//"AND STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE " + 
				//"AND STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID " + 
				//"AND STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE " + 
				//"AND STRG_CUSTOMER.LOCALITY_CODE = SPRS_ROUTE.LOCALITY_CODE " + 
				//"AND STRG_SERIES.SALES_PERS =SALES_PERS.SALES_PERS" ;

				/*sqlStr = "SELECT STRG_SERIES.SALES_PERS , STRG_SERIES.ROUTE_ID " + 
						"FROM STRG_SERIES, SPRS_ROUTE, STRG_CUSTOMER, SALES_PERS ,EMPLOYEE " + 
						"WHERE STRG_SERIES.SC_CODE = '" + custCode + "' " + 
						"AND STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE " + 
						"AND STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID " + 
						"AND STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE " + 
						"AND STRG_CUSTOMER.LOCALITY_CODE = SPRS_ROUTE.LOCALITY_CODE " + 
						"AND STRG_SERIES.SALES_PERS =SALES_PERS.SALES_PERS " + 
						"AND SALES_PERS.SALES_PERS = EMPLOYEE.EMP_CODE " + 
						//Modified By Rupesh on [03/09/2012] [As per suggestion of Piyush Sir]
						//"AND EMPLOYEE.STATUS <> 'S' " +
						"AND (EMPLOYEE.RESI_DATE IS NULL OR (EMPLOYEE.RESI_DATE IS NOT NULL " + 
						"AND (SELECT COUNT(1) FROM STRG_SERIES SSB WHERE SSB.SALES_PERS = STRG_SERIES.SALES_PERS AND SSB.STATUS = 'Y') > 0))";*/
				//Changes by Bhagyashri T  For check Status from Strg_series on[15/04/2021][W21ASUN029][Start] 
				sqlStr = "SELECT STRG_SERIES.SALES_PERS , STRG_SERIES.ROUTE_ID , STRG_SERIES.STATUS " + 
						"FROM STRG_SERIES, SPRS_ROUTE, STRG_CUSTOMER, SALES_PERS ,EMPLOYEE " + 
						"WHERE STRG_SERIES.SC_CODE = '" + custCode + "' " + 
						"AND STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE " + 
						"AND STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID " + 
						"AND STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE " + 
						"AND STRG_CUSTOMER.LOCALITY_CODE = SPRS_ROUTE.LOCALITY_CODE " + 
						"AND STRG_SERIES.SALES_PERS =SALES_PERS.SALES_PERS " + 
						"AND SALES_PERS.SALES_PERS = EMPLOYEE.EMP_CODE " + 
						//Modified By Rupesh on [03/09/2012] [As per suggestion of Piyush Sir]
						//"AND EMPLOYEE.STATUS <> 'S' " +
						"AND (EMPLOYEE.RESI_DATE IS NULL OR (EMPLOYEE.RESI_DATE IS NOT NULL " + 
						"AND (SELECT COUNT(1) FROM STRG_SERIES SSB WHERE SSB.SALES_PERS = STRG_SERIES.SALES_PERS AND SSB.STATUS = 'Y') > 0))";
				//Changes by Bhagyashri T  For check Status from Strg_series on[15/04/2021][W21ASUN029][End]

				writeLog(filePtr,"Main Sql -->" + sqlStr,true);
				System.out.println("sqlStr :: "+sqlStr);
				rs = stmt.executeQuery(sqlStr);
				StringBuffer strBuff = new StringBuffer("<p>Following sales person does not have record in route master for the change locality code or there status = N in root master!!!</p>"); //Gulzar - 9/26/2008
				strBuff.append("<table class = 'alertContentTable' ><tr class = 'alertContentTr'><td class = 'alertContentTd'>Sales Person</td><td class = 'alertContentTd'>Name</td><td class = 'alertContentTd'>Route Type</td></tr>");
				//strBuff.append("<tr><td>------------------</td><td>----------------------------------</td></tr>");

				//Added - Gulzar - 9/26/2008
				sqlStr = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
				pstmt = conn.prepareStatement(sqlStr);
				//End Changes - Gulzar - 9/26/2008

				sqlStr = "SELECT ROUTE_ID FROM SPRS_ROUTE  " + 
						"WHERE SPRS_CODE = ? " + 
						"AND LOCALITY_CODE = ? " +
						"AND STATUS = 'Y' " ;	
				writeLog(filePtr,"No Route Id for salesPers , localityCode and STATUS='Y' -->" + sqlStr,true);
				pstmtSel1 = conn.prepareStatement(sqlStr);


				sqlupdateStr = "UPDATE STRG_SERIES " +
						"SET ROUTE_ID = ? ," +
						"CHG_USER = ? , " +
						"CHG_DATE = ? ," +
						"CHG_TERM = ? " +
						"WHERE SALES_PERS = ? " +
						"AND SC_CODE = ? " +
						"AND ROUTE_ID = ? ";
				pstmtUpd1 = conn.prepareStatement(sqlupdateStr);
				System.out.println("sqlStr :: "+sqlupdateStr);
				while (rs.next())
				{
					salesPers = rs.getString(1);
					routeIdExisting = rs.getString(2);
					statusExisting = rs.getString(3);  //Changed by Bhagyashri T[15/04/2021][W21ASUN029]
					writeLog(filePtr,"Sales Person Code -->" + salesPers,true);
					writeLog(filePtr,"Existing Route ID -->" + routeIdExisting,true);
					writeLog(filePtr,"Existing Status -->" + statusExisting,true); //Changed by Bhagyashri T[15/04/2021][W21ASUN029]
					//Added - Gulzar - 9/26/2008
					pstmt.setString(1 , salesPers);
					rs1 = pstmt.executeQuery();
					pstmt.clearParameters();
					if ( rs1.next() )
					{
						spName =  rs1.getString("SP_NAME");
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					//End Changes - Gulzar - 9/26/2008

					pstmtSel1.setString( 1, salesPers );
					pstmtSel1.setString( 2, localityCode );
					rs1 = pstmtSel1.executeQuery();
					pstmtSel1.clearParameters();

					routeIdNew = "";
					if (rs1.next())
					{					
						routeIdNew = rs1.getString(1);
						//Commented by Bhagyashri T for Checking new Route id present in Strg_series or not[15/04/21][W21ASUN029][START]
						/*pstmtUpd1 = conn.prepareStatement(sqlupdateStr);
						pstmtUpd1.setString( 1 , routeIdNew );
						pstmtUpd1.setString( 2 , userId );
						//pstmtUpd1.setDate(3,chgDate); //Gulzar - 14/08/08 Req ID : SY78SUN032
						pstmtUpd1.setTimestamp( 3,chgDate ); //Gulzar - 14/08/08 Req ID : SY78SUN032
						pstmtUpd1.setString( 4 , chgTerm );
						pstmtUpd1.setString( 5 , salesPers );
						pstmtUpd1.setString( 6 , custCode );
						pstmtUpd1.setString( 7 , routeIdExisting );
						int updCnt = 0;
						updCnt = pstmtUpd1.executeUpdate();
						pstmtUpd1.clearParameters();
						if(pstmtUpd1!=null)
						{
							pstmtUpd1.close();
							pstmtUpd1 = null;
						}*/
						/* -- Commented and Changes below Gulzar - 14/08/08 Req ID : SY78SUN032
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_SERIES : Update Count -->" + updCnt,true);
							retString = "Failed to update strg series for Sales Person [" + salesPers + "] AND Customer [" + custCode + "] AND Route ID [" + routeIdExisting + "]";
							retString = errMsg("" , "SQLERR" , userId , retString);
							break;
						}*/
						/*if (updCnt > 0)
						{
							System.out.println("Updated into STRG_SERIES successfully [updCnt] :"+updCnt);
						}*/
						//End Changes - Gulzar - 14/08/08 Req ID : SY78SUN032
						//Commented by Bhagyashri T for Checking new Route id present in Strg_series or not[15/04/21][W21ASUN029][End]
						//Changes By bhagyashri T  For Checking new Route id present in Strg_series or not[15/04/21][W21ASUN029][START]
						System.out.println("Inside the new route id of sprs_route");
						
						statusSql = "SELECT SC_CODE , STATUS FROM STRG_SERIES  " + 
								"WHERE SALES_PERS = ? " +
								"AND SC_CODE = ? " +
								"AND ROUTE_ID = ? ";	
						writeLog(filePtr,"STATUS,SC CODE FOR NEW ROUTE ID-->" + statusSql,true);
						System.out.println("New status sql of strg_series:"+statusSql);
						pstmtStatus = conn.prepareStatement(statusSql);
						pstmtStatus.setString( 1, salesPers );
						pstmtStatus.setString( 2, custCode );
						pstmtStatus.setString( 3, routeIdNew );
						rsStatus = pstmtStatus.executeQuery();
						pstmtStatus.clearParameters();
						if (rsStatus.next())
						{
							System.out.println("Inside the new status of strg_series");
							statusUpd1 = "UPDATE STRG_SERIES " +
									"SET STATUS = ? ," +
									"CHG_USER = ? , " +
									"CHG_DATE = ? ," +
									"CHG_TERM = ? " +
									"WHERE SALES_PERS = ? " +
									"AND SC_CODE = ? " +
									"AND ROUTE_ID = ? ";
							pstmtStsupd1 = conn.prepareStatement(statusUpd1);
							System.out.println("update new status sql of strg_series status:"+statusUpd1);
							pstmtStsupd1.setString( 1 , statusExisting );
							pstmtStsupd1.setString( 2 , userId );
							pstmtStsupd1.setTimestamp( 3,chgDate ); 
							pstmtStsupd1.setString( 4 , chgTerm );
							pstmtStsupd1.setString( 5 , salesPers );
							pstmtStsupd1.setString( 6 , custCode );
							pstmtStsupd1.setString( 7 , routeIdNew );
							int statusUpd1Cnt = 0;
							statusUpd1Cnt = pstmtStsupd1.executeUpdate();
							pstmtStsupd1.clearParameters();
							if(pstmtStsupd1!=null)
							{
								pstmtStsupd1.close();
								pstmtStsupd1 = null;
							}
							if (statusUpd1Cnt > 0)
							{
								System.out.println("Updated New Status into STRG_SERIES successfully [updCnt] :"+statusUpd1Cnt);
							}
							
							System.out.println("UPDATE FOR OLD ROUTE ID");
							
							statusUpd2 = "UPDATE STRG_SERIES " +
									"SET STATUS = 'N'  ," +
									"CHG_USER = ? , " +
									"CHG_DATE = ? ," +
									"CHG_TERM = ? " +
									"WHERE SALES_PERS = ? " +
									"AND SC_CODE = ? " +
									"AND ROUTE_ID = ? ";
							pstmtStsupd2 = conn.prepareStatement(statusUpd2);
							System.out.println("update status sql OF OLd ROUTE ID of strg_series status:"+statusUpd2);
							pstmtStsupd2.setString( 1 , userId );
							pstmtStsupd2.setTimestamp( 2,chgDate ); 
							pstmtStsupd2.setString( 3 , chgTerm );
							pstmtStsupd2.setString( 4 , salesPers );
							pstmtStsupd2.setString( 5 , custCode );
							pstmtStsupd2.setString( 6 , routeIdExisting );
							int statusUpd2Cnt = 0;
							statusUpd2Cnt = pstmtStsupd2.executeUpdate();
							pstmtStsupd2.clearParameters();
							if(pstmtStsupd2!=null)
							{
								pstmtStsupd2.close();
								pstmtStsupd2 = null;
							}
							if (statusUpd2Cnt > 0)
							{
								System.out.println("Updated Status 'N' into STRG_SERIES successfully [updCnt] :"+statusUpd2Cnt);
							}	
						}
						
						else
						{
							System.out.println("iNSIDE NEW UPDATE");
							pstmtUpd1 = conn.prepareStatement(sqlupdateStr);
							pstmtUpd1.setString( 1 , routeIdNew );
							pstmtUpd1.setString( 2 , userId );
							//pstmtUpd1.setDate(3,chgDate); //Gulzar - 14/08/08 Req ID : SY78SUN032
							pstmtUpd1.setTimestamp( 3,chgDate ); //Gulzar - 14/08/08 Req ID : SY78SUN032
							pstmtUpd1.setString( 4 , chgTerm );
							pstmtUpd1.setString( 5 , salesPers );
							pstmtUpd1.setString( 6 , custCode );
							pstmtUpd1.setString( 7 , routeIdExisting );
							int updCnt = 0;
							updCnt = pstmtUpd1.executeUpdate();
							pstmtUpd1.clearParameters();
							if(pstmtUpd1!=null)
							{
								pstmtUpd1.close();
								pstmtUpd1 = null;
							}
							if (updCnt > 0)
							{
								System.out.println("Updated into STRG_SERIES successfully [updCnt] :"+updCnt);
							}
						}
						if(rsStatus != null)
						{
							rsStatus.close();
							rsStatus = null;
						}
						if(pstmtStatus!=null)
						{
							pstmtStatus.close();
							pstmtStatus = null;
						}
						//Changes By bhagyashri T  For Checking new Route id present in Strg_series or not[15/04/21][W21ASUN029][End]	
					}
					else
					{
						String sql = "SELECT ROUTE_TYPE FROM SPRS_ROUTE  " + 
								"WHERE SPRS_CODE = ? " + 
								"AND LOCALITY_CODE = ? ";	
						pstmtroute = conn.prepareStatement(sql);
						pstmtroute.setString( 1, salesPers );
						pstmtroute.setString( 2, localityCode );
						rs1 = pstmtroute.executeQuery();
						pstmtroute.clearParameters();
						routeType = "";
						if (rs1.next())
						{					
							routeType = rs1.getString(1);
							System.out.println("routeType ["+routeType+"]");
						}

						if(rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}
						if(pstmtroute!=null)
						{
							pstmtroute.close();
							pstmtroute = null;
						}
						//retString = "No Active Route exist for Sales Person [" + salesPers + "] AND Customer [" + custCode + "] AND Route Id [" + routeIdExisting + "]";
						//retString = errMsg("" , "SQLERR" , userId , retString);
						strBuff.append("<tr class = 'alertContentTr'><td class = 'alertContentTd'>"+salesPers+"</td><td class = 'alertContentTd'>" + spName + "</td><td class = 'alertContentTd'>" + routeType + "</td></tr>"); //Gulzar - 9/26/2008
						//break; //Gulzar - 9/26/2008
						msgCntr++;
						//continue; //Gulzar - 9/26/2008
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
				}
				strBuff.append("</table>");
				if(rs != null)
				{
					rs.close();
					rs = null;
				} //Gulzar - 14/08/08 Req ID : SY78SUN032
				/*pstmt.close(); //Gulzar - 9/26/2008
				pstmt = null;*/
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("strBuff ::: : " + strBuff.toString());
				if ( msgCntr > 0 ) //Gulzar - 9/26/2008
				{
					retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process not Done Successfully</message><description><![CDATA[" + strBuff.toString() + "]]></description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				}
				if (retString == null || retString.trim().length() == 0)
				{
					String city = "";
					String pinCode = "";
					String district = "";
					String stanCode = "";
					String stateCode = "";
					String countryCode = "";

					sqlStr = "SELECT CITY,PIN,STAN_CODE,STATE_CODE,COUNT_CODE,DISTRICT FROM LOCALITY " + 
							"WHERE LOCALITY_CODE = '"+localityCode+"' " ;

					rs = stmt.executeQuery(sqlStr);

					routeIdNew = "";
					if (rs.next())
					{
						city = rs.getString(1);
						pinCode = rs.getString(2);
						stanCode = rs.getString(3);
						stateCode = rs.getString(4);
						countryCode = rs.getString(5);
						district = rs.getString(6);

						sqlStr = "UPDATE STRG_CUSTOMER " +
								"SET CITY = ? , " +
								"STAN_CODE = ? , " +
								"STATE_CODE = ? , " +
								"COUNT_CODE = ? , " +
								"LOCALITY_CODE = ? , " +
								"CHG_USER = ? , " +
								"CHG_DATE = ? , " +
								"CHG_TERM = ? , " +
								"DISTRICT_OFF = ?  " +
								"WHERE SC_CODE = ? ";
						pstmtUpd2 = conn.prepareStatement(sqlStr);

						pstmtUpd2.setString( 1 , city );
						pstmtUpd2.setString( 2 , stanCode );
						pstmtUpd2.setString( 3 , stateCode );
						pstmtUpd2.setString( 4 , countryCode );
						pstmtUpd2.setString( 5 , localityCode );
						pstmtUpd2.setString( 6 , userId );
						//pstmtUpd2.setDate( 7 , chgDate ); //Gulzar - 14/08/08 Req ID : SY78SUN032
						pstmtUpd2.setTimestamp( 7,chgDate ); //Gulzar - 14/08/08 Req ID : SY78SUN032
						pstmtUpd2.setString( 8 , chgTerm );
						pstmtUpd2.setString( 9 , district );
						pstmtUpd2.setString( 10 , custCode );
						int updCnt = 0;
						updCnt = pstmtUpd2.executeUpdate();
						pstmtUpd2.clearParameters();
						/* -- Commented and Changes below Gulzar - 14/08/08 Req ID : SY78SUN032
						if (updCnt != 1)
						{
							writeLog(filePtr,"Failed to update STRG_CUSTOMER : Update Count -->" + updCnt,true);
							retString = "Failed to update strg customer for Customer [" + custCode + "]" ;
							retString = errMsg("" , "SQLERR" , userId , retString);
						}*/
						if (updCnt > 0)
						{
							System.out.println("Updated into STRG_CUSTOMER successfully [updCnt] :"+updCnt);
						}
						//End Changes - Gulzar - 14/08/08 Req ID : SY78SUN032
					}
					else
					{
						retString = "Failed to fetch locality details from locality for Locality [" + localityCode + "]" ;
						//retString = errMsg("" , "SQLERR" , userId , retString);
						retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"E\" column_name=\"\"><message>Process not Done Successfully</message><description>"+retString+"</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}

				if (retString == null || retString.trim().length() == 0)
				{
					conn.commit();
					retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS\" type=\"P\" column_name=\"\"><message>Process Done Successfully</message><description>Process Done Successfully</description><type>P</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				}
				else
				{
					conn.rollback();
				}
			}
		}
		catch(SQLException se)  //Gulzar - 14/08/08 Req ID : SY78SUN032
		{
			System.out.println("Exception : StrgCustChgLocalityPrcEJB : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			writeLog(filePtr,"Exception in process-->"+se,true);
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (SQLException SQLE)
			{
				writeLog(filePtr,"Exception in process-->"+SQLE,true);
				throw new ITMException(SQLE);
			}
			writeLog(filePtr,"Exception in process-->"+e,true);
			System.out.println( e.getMessage());
			throw new ITMException(e);
		}  
		finally
		{
			try
			{
				//Added by Hariom for connection close change --19-Jan-21 [Start]
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				//Added by Hariom for connection close change --19-Jan-21 [End]
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( pstmtSel1 != null )
				{
					pstmtSel1.close();
					pstmtSel1 = null;
				}
				if ( pstmtUpd1 != null )
				{
					pstmtUpd1.close();
					pstmtUpd1 = null;
				}
				if ( pstmtUpd2 != null )
				{
					pstmtUpd2.close();
					pstmtUpd2 = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				writeLog(filePtr,"Exception in process-->"+e,true);
				System.out.println(e.getMessage());
			}
		}		
		/*--Commented by gulzar - not required - 11/05/10
		if (retString == null || retString.trim().length() == 0)
		{
			retString = warningMsgBuf.toString();

			if (retString == null || retString.trim().length() == 0)
			{
				retString = itmDBAccessEJB.getErrorString("","VPSUCC1","","",conn);
			}
			else
			{
				retString = errMsg("" , "VPWARN" , userId , retString);
			}
		}
		 */
		//*--End Commented by gulzar - not required - 11/05/10
		return retString;
	}	


	public String errMsg(String columnName,String msgNo,String userId,String errTrace)throws RemoteException,ITMException
	{
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver(); //Commented by vinayak on [11/07/2016]
		StringBuffer errStringXml;
		Statement stmt = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		String sqlQuery,sqlQuery1;
		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String lmsgString = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";		
		String msgTime = "";

		String redirerr = "" ;
		String soundPlay = "";
		FileOutputStream fos;
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");				
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				lmsgString = "Message Not Defined >>" + msgNo;
				msgDescription = "Message Id not found.";
				msgType = "";
				msgString = "";
			}

			if (msgType.equals("E") || msgType.trim().length() == 0) 
			{
				sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				rs1 = conn.createStatement().executeQuery(sqlQuery1);
				if (rs1.next())
				{
					profileId=rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId= "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND PROFILE_ID='" + profileId.trim() + "'";
					rs2 = conn.createStatement().executeQuery(sqlQuery1);
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
				}
				if (tempMsgType!=null && tempMsgType.trim().length()>0)
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if (errSource!=null && errSource.trim().equals("D"))
			{
				msgDescription = msgDescription +  " * From Database ";
			}
			if (redirerr==null || redirerr.trim().length()==0)
			{
				redirerr = "1";
			}
			if (msgOption!=null && msgOption.trim().equals("M"))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			if (rs != null)
			{
				rs.close();
			}
			if (rs1 != null)
			{
				rs1.close();			
			}
			conn.close();
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException : [ValidatorEJB][getErrorString] :==>\n"+itme.getMessage());
			throw itme;
		}
		catch(SQLException se)
		{
			lmsgString = "Database Error >>" + se.getErrorCode(); //msgNo;
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n"+se.getMessage());
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		errStringXml = new StringBuffer();
		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		errStringXml.append("<error id=\"");
		errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
		errStringXml.append(columnName).append("\">\r\n").append("<message>").append(msgString);
		errStringXml.append("</message>\r\n<description>").append(msgDescription).append("</description>\r\n");
		errStringXml.append("<type>").append(msgType).append("</type>\r\n<option>").append(msgOption).append("</option>\r\n");		
		errStringXml.append("<time>").append(msgTime).append("</time>\r\n");

		errStringXml.append("<alarm>").append(soundPlay).append("</alarm>\r\n<source>");
		errStringXml.append(errSource).append("</source>\r\n<trace>").append(errTrace);
		errStringXml.append("</trace>\r\n<redirect>").append(redirerr).append("</redirect>\r\n</error>\r\n");
		errStringXml.append("</Errors></Root>\r\n");
		/*		if (msgType.trim().equals("E"))
		{
			errStringXml = buildErrorString();
		}*/
		try 
		{
			fos = new FileOutputStream("C:" + File.separator + "ErrorXml.xml");
			byte convertStringToByte[] = errStringXml.toString().getBytes();
			fos.write(convertStringToByte);
			fos.close();
		}
		catch(Exception e)
		{ 
			System.out.println("Exception : [ValidatorEJB][getErrorString] \n:==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errStringXml.toString();

	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgCustChgLocalityPrc] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgCustChgLocalityPrc] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}