/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequest;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.json.JSONException;

public class UserEnterpriseEJB
extends ActionHandlerEJB {
    public String generateEnterpriseCode(String userId, String userLicType) throws ITMException {
        BaseLogger.log("2", null, null, "UserEnterpriseEJB called....");
        String responseMessage = "";
        if (userId == null && userId.trim().length() == 0) {
            throw new ITMException(new Exception("User Id is null"));
        }
        responseMessage = this.generateEnterpriseCode(userId, userId, userLicType);
        return responseMessage;
    }

    public String generateEnterpriseCode(String userId, String enterpriseDescr, String userLicType) throws ITMException {
        BaseLogger.log("2", null, null, "UserEnterpriseEJB called....");
        String responseMessage = "";
        if (userId == null && userId.trim().length() == 0) {
            throw new ITMException(new Exception("User Id is null"));
        }
        responseMessage = this.callEXTWebService(userId, enterpriseDescr, userLicType);
        return responseMessage;
    }

    private String callEXTWebService(String userId, String enterpriseDescr, String userLicType) throws ITMException {
        BaseLogger.log("2", null, null, "Inside UserEnterpriseEJB::EXTWebService....");
        String returnValue = "";
        String LICENCE_AUTH_URL = "https://pilotdebug.proteusvision.com";
        try {
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            if (CommonConstants.TOMCAT_HOME.equals("https://pilotdebug.proteusvision.com")) {
                returnValue = this.getEnterpriseCode(userId, enterpriseDescr, userLicType);
            } else {
                String extWebServiceURI = "/ibase/rest/E12ExtService/getEnterpriseCode";
                extWebServiceURI = "https://pilotdebug.proteusvision.com" + extWebServiceURI;
                BaseLogger.log("3", null, null, "[UserEnterpriseEJB]Service url :[" + extWebServiceURI + "]");
                String APPLICATION_JSON = "application/json";
                HttpRequest extServiceReq = Unirest.get((String)extWebServiceURI).header("Content-Type", APPLICATION_JSON).queryString("userId", (Object)userId).queryString("entpDescr", (Object)enterpriseDescr).queryString("usrLicType", (Object)userLicType).queryString("appId", (Object)"USERREG").queryString("endPoint", (Object)"getEnterpriseCode").getHttpRequest();
                HttpResponse extServiceResp = extServiceReq.asString();
                BaseLogger.log("3", null, null, "extServiceResp.getStatus()[" + extServiceResp.getStatus() + "]");
                BaseLogger.log("3", null, null, "extServiceResp.getBody()[" + (String)extServiceResp.getBody() + "]");
                String extServiceObj = ((String)extServiceResp.getBody()).toString();
                BaseLogger.log("3", null, null, "extServiceObj[" + extServiceObj + "]");
                returnValue = extServiceObj.toString();
            }
        }
        catch (UnirestException urex) {
            System.err.println("Exception :UserEnterpriseEJB :callEXTWebService :\n" + urex.getMessage());
            throw new ITMException((Exception)((Object)urex));
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            System.err.println("Exception :UserEnterpriseEJB :callEXTWebService :\n" + e.getMessage());
            throw new ITMException(e);
        }
        return returnValue;
    }

    public String getEnterpriseCode(String userId, String enterpriseDescr, String usrLicType) throws JSONException, ITMException {
        BaseLogger.log("2", null, null, "userId[" + userId + "]usrLicType[" + usrLicType + "]");
        String responseString = "";
        try {
            responseString = this.getEnterprise();
            if (responseString != null || responseString.trim().length() != 0) {
                BaseLogger.log("3", null, null, "valid Request - insertEnterpriseInDB");
                this.insertEnterpriseInDB(userId, enterpriseDescr, responseString, usrLicType);
            } else {
                ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
                String msgNo = "VTENTFAIL";
                responseString = itmDbAccess.getErrorString("", msgNo, userId);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "responseString[" + responseString + "]");
        return responseString;
    }

    private String getEnterprise() throws Exception {
        System.out.println("***** In getEnterpriseCode Method ****");
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        String seqCount = "";
        String enterprise = null;
        String enterpriseCode = "V";
        try {
            try {
                String sql = "select lpad(to_char(schemaid_seq.nextval),9,'0') from dual";
                conn = new ConnDriver().getConnectDB("Driver");
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    seqCount = rs.getString(1);
                }
                enterprise = String.valueOf(enterpriseCode) + seqCount;
                System.out.println("enterprise::[" + enterprise + "]");
                pstmt.close();
                pstmt = null;
                rs.close();
                rs = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (conn != null) {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
        }
        finally {
            if (conn != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                conn.close();
                conn = null;
            }
        }
        return enterprise;
    }

    private void insertEnterpriseInDB(String userId, String enterpriseDescr, String entpCode, String userLicType) throws ITMException {
        Statement pstmt = null;
        ResultSet rs = null;
        Connection autConn = null;
        String sql = "";
        try {
            try {
                ConnDriver conDriver = new ConnDriver();
                autConn = conDriver.getConnectDB("Driver");
                java.sql.Date currentDate = new java.sql.Date(new Date().getTime());
                System.out.println("currentDate :" + currentDate);
                sql = "Insert into ENTERPRISE (ENTERPRISE,ENTERPRISE_DESCR,ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,ENT_TYPE,SMTP_FALLBACK) values (?,?,?,?,?,?,?,?,?,?)";
                pstmt = autConn.prepareStatement(sql);
                pstmt.setString(1, entpCode);
                pstmt.setString(2, enterpriseDescr);
                pstmt.setDate(3, currentDate);
                pstmt.setString(4, userId);
                pstmt.setString(5, "USER_REG");
                pstmt.setDate(6, currentDate);
                pstmt.setString(7, userId);
                pstmt.setString(8, "USER_REG");
                pstmt.setString(9, "0");
                pstmt.setString(10, "Y");
                pstmt.executeUpdate();
                pstmt.close();
                autConn.commit();
                pstmt.close();
                pstmt = null;
                sql = "Insert into entp_users_licence (ENTERPRISE,LINE_NO,USER_LIC_TYPE,LIC_USERS) values (?,?,?,?)";
                pstmt = autConn.prepareStatement(sql);
                pstmt.setString(1, entpCode);
                pstmt.setInt(2, 1);
                pstmt.setString(3, userLicType);
                pstmt.setInt(4, 5);
                pstmt.executeUpdate();
                pstmt.close();
                autConn.commit();
                pstmt.close();
                pstmt = null;
                int userLicChrgCnt = 0;
                String countEntpUserLicChrgSql = "SELECT COUNT(1) AS COUNT FROM ENTP_USER_LIC_CHRGS WHERE ENTERPRISE = ?";
                pstmt = autConn.prepareStatement(countEntpUserLicChrgSql);
                pstmt.setString(1, entpCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    userLicChrgCnt = rs.getInt("COUNT");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                BaseLogger.log("3", null, null, "userLicChrgCnt =[ " + userLicChrgCnt + "]");
                if (userLicChrgCnt == 0) {
                    double chrgAmt = 0.0;
                    String userTypeLicChrgAmtSql = "SELECT CHRG_AMT FROM USERTYPE_LIC_CHRGS WHERE USER_LIC_TYPE ='E'";
                    pstmt = autConn.prepareStatement(userTypeLicChrgAmtSql);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        chrgAmt = rs.getDouble("CHRG_AMT");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    String entrpUsrLicChrg = "Insert into ENTP_USER_LIC_CHRGS (ENTERPRISE,LINE_NO,USER_LIC_TYPE,CHRG_AMT) values (?,?,?,?)";
                    pstmt = autConn.prepareStatement(entrpUsrLicChrg);
                    pstmt.setString(1, entpCode);
                    pstmt.setInt(2, 1);
                    pstmt.setString(3, "E");
                    pstmt.setDouble(4, chrgAmt);
                    pstmt.executeUpdate();
                    pstmt.close();
                    autConn.commit();
                    pstmt.close();
                    pstmt = null;
                }
                autConn.close();
                autConn = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException :E12ExtService :insertEnterpriseInDB :==>");
                throw itme;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", null, null, "SQLException ::E12ExtService :insertEnterpriseInDB :==>" + ie);
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception ::E12ExtService :insertEnterpriseInDB :==>" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (autConn != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    autConn.close();
                    autConn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
    }
}

