/** 
*		Developed by	: Ganesh Wakchaure
*		Company			: Base Information Management Pvt. Ltd
*		Start Date		: 06-Nov-2013*		
*		Name			: StrgSerChgStatGWTPos.java
*		Purpose			: Migration of change status option in Doctor List Updation menu in GWT
**/

package ibase.webitm.ejb.wsfa.masters;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;

import java.util.*;
import java.sql.*;
import java.io.*;

import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.InitialContext;
import java.text.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

@Stateless
public class StrgSerChgStatGWTPos extends ValidatorEJB  
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId,String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException,ITMException
	{
		System.out.println("XML for processing the dom:::"+domString);		
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		Document dom = genericUtility.parseString(domString);
		InitialContext ctx = null;
		String windowName = "w_"+getObjName(dom);
		System.out.println("Window Name Got :::["+windowName+"]");
		PreparedStatement pstmtInner = null;

		try
		{
			ctx = getInitialContext(); 
			//StrgSerChgStatPrcGWTLocal strgSerChgStatPrcGWT = (StrgSerChgStatPrcGWTLocal)ctx.lookup("ibase/StrgSerChgStatPrcGWT/local");
			//System.out.println("strgSerChgStatPrcGWT-- "+strgSerChgStatPrcGWT);
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			String loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");

			System.out.println("@@@@ loginEmpCode ::"+loginEmpCode);
			String userId = loginEmpCode.trim();
			StrgSerChgStatPrcGWT strgSerChgStatPrcGWT = new StrgSerChgStatPrcGWT();
			System.out.println("strgSerChgStatPrcGWT-- "+strgSerChgStatPrcGWT);
			NodeList parentList = null;
			parentList = dom.getElementsByTagName("Detail2");
			System.out.println("Detail2::::"+parentList);
			System.out.println("Case 2 itm_default");
			System.out.println("In if...");
			errString = strgSerChgStatPrcGWT.process(dom,dom,windowName,xtraParams,getUserInfo());
			//Added by Sachin Satre request Id : W18BSUN009 on [20-Jul-18]  [Start]
			String division_ho_appr = genericUtility.getColumnValue("division_ho_appr",dom);
			String userType = getUserType(loginEmpCode,loginCode,conn);
			String aprvType = getEmpGradeLevel( userId, conn );
			
			//Added by Sachin Satre on [14-Dec-18] [Start]
			String itemSer ="";
			String hoAprvStatus ="";
			if( division_ho_appr == null || "".equalsIgnoreCase(division_ho_appr) || division_ho_appr.trim().length() == 0)
			{
				 itemSer = getItemSer(userId, conn);
				 hoAprvStatus = isHOAprvl(itemSer,xtraParams, conn);
				division_ho_appr = hoAprvStatus;
			}	
			//Added by Sachin Satre on [14-Dec-18] [End]
			System.out.println("aprvLevel::"+aprvType+"]::userType::["+userType+"]");
			if( aprvType.equalsIgnoreCase("TLM") || aprvType.equalsIgnoreCase("NSM") || aprvType.equalsIgnoreCase("SBU")  || userType.equalsIgnoreCase("H") || (division_ho_appr != null && division_ho_appr.equalsIgnoreCase("N") ) ) 
			{
				String updateSql ="UPDATE  STRG_SERIES_AMD SET WF_STATUS ='S' , CONFIRM ='Y'  WHERE TRAN_ID = '" + tranId + "' ";
				pstmtInner = conn.prepareStatement(updateSql);
				int updCnt = 0;
				updCnt = pstmtInner.executeUpdate();
				System.out.println("updCnt:in amd table:::::["+updCnt+"]");
				if ( pstmtInner != null )
				{
					pstmtInner.close();
					pstmtInner = null;
				}
				System.out.println("StrgSerChgStatGWTPos errString ==>>["+errString+" ]");
			}
			//Added by Sachin Satre request Id : W18BSUN009 on [20-Jul-18]  [End]
		}
		catch(Exception e)
		{		
			System.out.println("Exception: StrgSerChgStatGWTPos: postSave(): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}		
		System.out.println("Returning from StrgSerChgStatGWTPos postSave");
		return errString;		
	}	

	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgSerChgStatGWTPos] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgSerChgStatGWTPos] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	private String getObjName(Document dom2)
	{	
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail2");
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail2").equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	//Added by Sachin Satre request Id : W18BSUN009 on [19-Jul-18]  [Start]
	public String getEmpGradeLevel( String empCode, Connection conn ) throws Exception
	{
		String selectSql = "";
		//String gradeLev = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String aprvLevel ="";
		String aprvType ="";
		try
		{
			selectSql = "SELECT GRADE.LEVEL_NO AS APRV_LEVEL FROM GRADE GRADE, EMPLOYEE EMP WHERE EMP.GRADE = GRADE.GRADE_CODE AND EMP.EMP_CODE = ? ";
			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				aprvLevel = checkNull(rs.getString("APRV_LEVEL"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( aprvLevel!=null && !aprvLevel.equals("") && aprvLevel.length()>0)
			{
				if ( aprvLevel != null && !aprvLevel.equals("") && aprvLevel.equals("1") )
				{
					aprvType = "TLM";
				}
				else if ( aprvLevel != null && !aprvLevel.equals("") && aprvLevel.equals("2") )
				{
					aprvType = "SLM";
				}
				else if ( aprvLevel != null && !aprvLevel.equals("") && aprvLevel.equals("3") )
				{
					aprvType = "FLM";
				}
				else if ( aprvLevel != null && !aprvLevel.equals("") && aprvLevel.equals("4") )
				{
					aprvType = "SO";
				}
				else if ( aprvLevel != null && !aprvLevel.equals("") && aprvLevel.equals("231") )
				{
					aprvType = "NSM";
				}
				else
				{
					aprvType = "SBU";
				}
			}	
		}
		catch ( Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}catch(Exception e){}
		}
		System.out.println("gradeLev[getEmpGradeLevel] =["+aprvLevel+"]");
		return aprvType;
	} 
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	private String getUserType(String empCode,String userCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
					"WHERE A.EMP_CODE = ? " + 
					"AND A.GRADE = B.GRADE_CODE " + 
					"AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[StrgSerChgStatGWTIc][getUserType()] selectSql -->> "+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
						"WHERE A.CODE = ? " + 
						"AND A.PROFILE_ID = B.PROFILE_ID " +
						"AND B.APPLICATION = 'MRO' " +
						"AND B.MENU_ROW = 1 " +       
						"AND B.MENU_COL = 1 " +       
						"AND B.MENU_SUBCOL = 1 " +
						"AND B.LEVEL_4 = 1 " +        
						"AND B.LEVEL_5 = 1 " +        
						"AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, userCode );
				System.out.println("[StrgSerChgStatGWTIc][getUserType()] selectSql for HO >> "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[StrgSerChgStatGWTIc][getUserType()] userType1 >> "+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;		
	}
	//Added by Sachin Satre request Id : W18BSUN009 on [19-Jul-18]  [End]
	//Added by Sachin Satre on [14-Dec-18] [Start]
	public String getItemSer(String salesPers,Connection conn)  throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sqlItmser="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
			pstmt = conn.prepareStatement(sqlItmser);
			pstmt.setString(1, salesPers);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				itemSer=checkNull(rs.getString("ITEM_SER"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return itemSer;
	}
	public String isHOAprvl(String itemSer,String xtraParams, Connection conn) throws ITMException
	{
		System.out.println("In side getHOAprvStatus()............");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String selected = "";
		int ctr4 = 0;
		int noOfChilds4 = 0;
		int currentFormNo = 0;
		String hoAprvStatus="";
		
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			String loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			System.out.println("itemSer:getHOAprvStatus::["+itemSer+"]");
			String sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT = ?  "+
					" AND ACTIVE = 'Y'  "+
					" AND PARM_NAME='DR_LIST_CHG_DIV_APRV' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);		
			pstmt.setString(1, "X"+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));										
			rs = pstmt.executeQuery();					
			if( rs.next() )
			{
				hoAprvStatus  = checkNull(rs.getString(1));				
			}
			System.out.println("hoAprvStatus:::["+hoAprvStatus+"]");
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}						
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}
		if(hoAprvStatus.trim().length() <= 0 )
		{
			hoAprvStatus ="Y";
		}
		System.out.println("hoAprvStatus..:::=["+hoAprvStatus+"]");
		return hoAprvStatus;
	}
	//Added by Sachin Satre on [14-Dec-18] [End]
}