
/**
 *  PURPOSE  : Home screen confirm comp
 *  AUTHOR   : Mrunalini Sinkar
 */

package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.HashMap;
import java.util.Iterator;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;


public class ManageSqlConf extends ActionHandlerEJB
{
	int reUpdateCnt = 0;
	String sqlError = "";
	public String confirm( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		System.out.println("HeaderDetailConf Called!!!!!........["+tranId+"]");

		boolean isError = false;


		String applDB = "",enterprises="";
		String sql = "";
		String requestID = "";

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection con = null;
		String errString = "";
		String schemaName = "";
		String enterpriseSQL="";
		ITMDBAccessEJB itmdbAccessLocal = null ;
		boolean isThisObject=false;
		try
		{

			itmdbAccessLocal = new ITMDBAccessEJB();

			GenericUtility genericUtility = GenericUtility.getInstance();
			con = getConnection();
			con.setAutoCommit(false);
			String userId  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
			String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));


			HashMap<String,String> schemaListMap= new HashMap<String,String>();
			sql = "SELECT APPL_DB,ENTERPRISES,REQ_ID FROM SQL_CHANGES WHERE TRAN_ID=?"; 
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				applDB = checkNull( rs.getString("APPL_DB") );
				enterprises = checkNull( rs.getString("ENTERPRISES") );
				requestID = checkNull( rs.getString("REQ_ID") );


			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			if(applDB.equalsIgnoreCase("E"))
			{
				sql = "SELECT SCHEMA_NAME,ENTERPRISE FROM ENTERPRISE WHERE SCHEMA_NAME IS NOT NULL"; 
				pstmt = con.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					schemaName = checkNull( rs.getString("SCHEMA_NAME") );
					enterpriseSQL = checkNull( rs.getString("ENTERPRISE") );
					schemaListMap.put(schemaName,enterpriseSQL);

				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			if(applDB.equalsIgnoreCase("S"))
			{
				String EnterPriseInFormat=getFormattedStringBuff(enterprises);
				sql = "SELECT SCHEMA_NAME,ENTERPRISE FROM ENTERPRISE WHERE ENTERPRISE IN("+EnterPriseInFormat+") " ;
				pstmt = con.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					schemaName = checkNull( rs.getString("SCHEMA_NAME") );
					enterpriseSQL = checkNull( rs.getString("ENTERPRISE") );

					schemaListMap.put(schemaName,enterpriseSQL);
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			sql = "SELECT ORA_STMNT,LINE_NO FROM SQL_CHANGES_DET WHERE TRAN_ID=?"; 
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				String oracleStatment = checkNull( rs.getString("ORA_STMNT") );
				String linNo = checkNull( rs.getString("LINE_NO") );

				System.out.println("oracle execute statment["+oracleStatment+"]");
				if( oracleStatment.lastIndexOf(";") != -1 )
				{
					if(!oracleStatment.toUpperCase().startsWith("CREATE"))
					{
						BaseLogger.log("3", null, null, "Inside if oracleStatment [" + oracleStatment + "]");//Added by Ashish.J
						int endIndex=oracleStatment.lastIndexOf(";");
						oracleStatment=oracleStatment.substring(0, endIndex);
					}
					else if(oracleStatment.toUpperCase().startsWith("CREATE TABLE"))
					{
						BaseLogger.log("3", null, null, "Inside else oracleStatment [" + oracleStatment + "]");//Added by Ashish.J
						int endIndex=oracleStatment.lastIndexOf(";");
						oracleStatment=oracleStatment.substring(0, endIndex);
					}


				}
				if(oracleStatment.toUpperCase().startsWith("CREATE") && !oracleStatment.toUpperCase().startsWith("CREATE TABLE"))
				{
					BaseLogger.log("3", null, null, "Inside is the object oracleStatment [" + oracleStatment + "]");//Added by Ashish.J
					isThisObject=true;

				}

				//if( oracleStatment.toUpperCase().startsWith("ALTER") || oracleStatment.toUpperCase().startsWith("INSERT INTO") || oracleStatment.toUpperCase().startsWith("UPDATE") || oracleStatment.toUpperCase().startsWith("DELETE"))
				//{
				executeQueries(con,schemaListMap, oracleStatment,tranId,linNo,requestID,userId,chgTerm,isThisObject) ;
				//}


			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			String upSql="UPDATE SQL_CHANGES SET CONFIRMED='Y',CONF_DATE=SYSDATE,EMP_CODE_APRV=?,EXECUTED='Y' WHERE TRAN_ID=?";
			pstmt = con.prepareStatement(upSql);
			pstmt.setString(1, userId);
			pstmt.setString(2, tranId);

			int updCnt = pstmt.executeUpdate();
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("update count is["+updCnt+"]");
			if(updCnt>0)
			{
				errString = itmdbAccessLocal.getErrorString("confirmed", "VTCONFIRM", "","",con);
				System.out.println("errString is "+ errString);

			}

		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				con.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Commiting and Closing Connection..........");
				if ( !(isError) )
				{
					System.out.println( "inside finally if" );
					con.commit();
					//errString = itmdbAccessLocal.getErrorString("","TEMCONFIRM",loginEmpCode);
					//errString = itmdbAccessLocal.getErrorString("confirmed", "TEMCONFIRM", "","",con);
				}
				else
				{
					System.out.println( "inside finally rollback else" );
					con.rollback();
				}
				if( pstmt != null )
				{
					System.out.println( "inside finally if pstmt " );

					pstmt.close();
					pstmt = null;
				}
				if( con != null && !con.isClosed() )
				{
					System.out.println( "inside finally if con " );
					con.close();
					con = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errString);
		return errString;
	}


	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

	private String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}

	private int executeQueries(Connection connection,HashMap<String,String> schemaListMap, String Sql,String tranID,String lineNo,String requestID,String userId,String chgTerm,boolean isThisObjectType) 
	{
		BaseLogger.log("3", null, null, "Inside executeQueries [" + Sql + "]");

		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		Statement stmnt = null;
		int updateCount=0;
		CallableStatement callableStmt = null;
		String error = "";//Added by Ashish.J

		try 
		{

			System.out.println("isThisObjectType:::::["+isThisObjectType+"]");
			if(!schemaListMap.isEmpty())
			{
				Iterator<String> itr = schemaListMap.keySet().iterator();
				while (itr.hasNext()) 
				{
					String schema = itr.next();
					String enterprise = schemaListMap.get(schema);
					int updCount = 0;

					conn = connDriver.getConnectDB(schema);
					if( conn == null ) 
					{
						BaseLogger.log("3", null, null, "Unable to get connection for [" + schema + "]");
						throw new Exception("Unable to get connection for [" + schema + "]");
					}


					if(checkNull(Sql).trim().length() > 0)
					{
						BaseLogger.log("3", null, null, "is the object---[" + isThisObjectType + "]");

						if(isThisObjectType)
						{
							BaseLogger.log("3", null, null, "is the object if [" + isThisObjectType + "]");
							String plsql = " begin " +
									" dbms_metadata.set_transform_param ( DBMS_METADATA.SESSION_TRANSFORM, 'SQLTERMINATOR', false ); " +
									" end; ";
							callableStmt = conn.prepareCall(plsql);
							callableStmt.execute();

						}

						try 
						{
							BaseLogger.log("3", null, null, "Inside try....");//Added by Ashish.J

							stmnt = conn.createStatement();
							updCount = stmnt.executeUpdate(Sql);
							error="";
							BaseLogger.log("3", null, null, "Inside try of error..["+error+"]");//Added by Ashish.J
							BaseLogger.log("3", null, null, "schema...["+schema+"]updateCnt to get Sql [" + updCount + "]");
							insertIntoSqlExectionLog(connection,tranID,enterprise,lineNo,requestID,Sql,updCount, "C" , userId,chgTerm,error);

						}
						catch(SQLException ise)
						{
							error=ise.getMessage();//Added by Ashish.J
							BaseLogger.log("3", null, null, "Inside catch of error..["+error+"]");
							//insertIntoSqlExectionLog(connection,tranID,enterprise,lineNo,requestID,Sql, userId,chgTerm);
							BaseLogger.log("3", null, null, "Inside catch....");
							insertIntoSqlExectionLog(connection,tranID,enterprise,lineNo,requestID,Sql,updCount, "E" , userId,chgTerm,error);
						}//Added by Ashish.J

						finally 
						{
							if (stmnt != null) 
							{
								stmnt.close();
								stmnt = null;
							}
						}
					}


					Thread.sleep(100);					
					conn.commit();
				}
			}


		} 
		catch (Exception e) 
		{
			try 
			{
				BaseLogger.log("3", null, null, "Excepotion in executeAlterQueries occured while executing Alter Queries>>>>" + e.getMessage());
				conn.rollback();
			} 
			catch (SQLException sqle) 
			{
				BaseLogger.log("3", null, null, "SQLException executeAlterQueries occured during rollback:: " + sqle.getMessage());
				sqle.printStackTrace();
			}
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (callableStmt != null) 
				{
					callableStmt.close();
					callableStmt = null;
				}
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
			} 
			catch (SQLException sqle) 
			{
				BaseLogger.log("3", null, null, "SQLException executeAlterQueries inside finally:: "+ sqle.getMessage());
				sqle.printStackTrace();
			}
		}
		return updateCount;
	}
	//Added by Ashish.J one more parameter has added sql_exception
	private String insertIntoSqlExectionLog( Connection conn, String refTranID, String enterprise, String lineNo,String requestID,String Sql,int updateCnt, String status, String userId,String chgTerm,String error) throws ITMException, RemoteException
	{
		System.out.println("inside insertIntoSqlExectionLog method");
		String errorString="";
		int insCount=0;
		PreparedStatement pstmtIns=null;
		ITMDBAccessEJB itmdbAccessLocal = new ITMDBAccessEJB();
		try
		{
			System.out.println("inside try of method");
			GenericUtility genericUtility = GenericUtility.getInstance();
			String Aformat= genericUtility.getApplDateFormat();
			java.text.SimpleDateFormat dtf= new java.text.SimpleDateFormat(Aformat);
			String currDate  = dtf.format(new java.util.Date());
			System.out.println("currDate --> ["+currDate+"]");
			System.out.println("insertIntoSqlExectionLog in --> ["+error+"]");
			String tranID=generateTranID(conn);
			String insSql="INSERT INTO SQL_EXEC_LOG(TRAN_ID,REF_TRAN_ID,ENTERPRISE,LINE_NO,REQ_ID,ORA_STMNT,CHG_DATE,CHG_USER,CHG_TERM,RESULT,STATUS,SQL_EXCEPTION) "
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtIns = conn.prepareStatement(insSql);
			pstmtIns.setString(1, tranID);

			pstmtIns.setString(2, refTranID);
			pstmtIns.setString(3,enterprise);
			pstmtIns.setString(4, lineNo);
			pstmtIns.setString(5, requestID);
			pstmtIns.setString(6, Sql);
			pstmtIns.setTimestamp( 7,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(checkNull(currDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()))); //Added by kailash on 24-04-18.
			pstmtIns.setString( 8,userId);
			pstmtIns.setString( 9,chgTerm);
			pstmtIns.setInt( 10,updateCnt);
			pstmtIns.setString( 11,status);
			pstmtIns.setString( 12,error);

			insCount = pstmtIns.executeUpdate();//Added by Ashish.J one more parameter has added sql_exception
			System.out.println("insCount into strg_meet_items["+lineNo+"] insCount= ["+insCount+"]");
			pstmtIns.clearParameters();
			if (pstmtIns != null)
			{
				pstmtIns.close();
				pstmtIns = null;
			}
		}
		catch (Exception e) 
		{
			errorString= itmdbAccessLocal.getErrorString("confirmed", "CONFFAILED", "","",conn);
			return errorString;
		}
		finally
		{
			{
				try 
				{
					if (pstmtIns != null)
					{
						pstmtIns.close();
						pstmtIns = null;

					}

				} catch (SQLException e) 
				{
					e.printStackTrace();
				}
			}
		}

		return errorString;
	}
	public String CancelLogTransaction( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		boolean isError = false;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection con = null;
		ITMDBAccessEJB itmdbAccessLocal = null ;
		String errString="";
		String status="";
		try
		{
			itmdbAccessLocal = new ITMDBAccessEJB();

			GenericUtility genericUtility = GenericUtility.getInstance();
			con = getConnection();
			con.setAutoCommit(false);
			String sql = "SELECT STATUS FROM SQL_EXEC_LOG WHERE TRAN_ID=?";
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				status = checkNull( rs.getString("STATUS") );
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if("C".equalsIgnoreCase(status))
			{
				errString = itmdbAccessLocal.getErrorString("confirmed", "VTECLNCANC", "","",con);
				System.out.println("errString is "+ errString);
			}
			else if("X".equalsIgnoreCase(status))
			{
				errString = itmdbAccessLocal.getErrorString("confirmed", "VTMCANL1", "","",con);
				System.out.println("errString is "+ errString);
			}
			else
			{
				String userId  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
				String upSql="UPDATE SQL_EXEC_LOG SET STATUS='X' WHERE TRAN_ID=?";
				pstmt = con.prepareStatement(upSql);
				pstmt.setString(1, tranId);

				int updCnt = pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("update count is["+updCnt+"]");
				if(updCnt>0)
				{
					errString = itmdbAccessLocal.getErrorString("confirmed", "VTLVECAR01", "","",con);
					System.out.println("errString is "+ errString);

				}
			}


		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				con.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( !(isError) )
				{
					con.commit();
					//errString = itmdbAccessLocal.getErrorString("","TEMCONFIRM",loginEmpCode);
					//errString = itmdbAccessLocal.getErrorString("confirmed", "TEMCONFIRM", "","",con);
				}
				else
				{
					con.rollback();
				}
				if( pstmt != null )
				{

					pstmt.close();
					pstmt = null;
				}
				if( con != null && !con.isClosed() )
				{
					con.close();
					con = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errString);
		return errString;
	}


	public String ConfirmLog( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{
		System.out.println("managelogsql  ConfirmLog........["+tranId+"]");

		boolean isError = false;


		String enterprises="";
		String sql = "";

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection con = null;
		String errString = "";
		String schemaName = "";
		ITMDBAccessEJB itmdbAccessLocal = null ;
		boolean isThisObject=false;
		String sqlExecute="";
		try
		{

			itmdbAccessLocal = new ITMDBAccessEJB();

			GenericUtility genericUtility = GenericUtility.getInstance();
			con = getConnection();
			con.setAutoCommit(false);
			String userId  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));


			sql = "SELECT ENTERPRISE FROM SQL_EXEC_LOG WHERE TRAN_ID=?"; 
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				enterprises = checkNull( rs.getString("ENTERPRISE") );
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}


			String EnterPriseInFormat=getFormattedStringBuff(enterprises);
			sql = "SELECT SCHEMA_NAME,ENTERPRISE FROM ENTERPRISE WHERE ENTERPRISE IN("+EnterPriseInFormat+") " ;
			pstmt = con.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				schemaName = checkNull( rs.getString("SCHEMA_NAME") );
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			sql = "SELECT ORA_STMNT FROM SQL_EXEC_LOG WHERE TRAN_ID=?"; 
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				String oracleStatment = checkNull( rs.getString("ORA_STMNT") );

				System.out.println("oracle execute statment["+oracleStatment+"]");
				if( oracleStatment.lastIndexOf(";") != -1 )
				{
					if(!oracleStatment.toUpperCase().startsWith("CREATE"))
					{
						int endIndex=oracleStatment.lastIndexOf(";");
						oracleStatment=oracleStatment.substring(0, endIndex);
					}
					else if(oracleStatment.toUpperCase().startsWith("CREATE TABLE"))
					{
						int endIndex=oracleStatment.lastIndexOf(";");
						oracleStatment=oracleStatment.substring(0, endIndex);
					}


				}
				if(oracleStatment.toUpperCase().startsWith("CREATE") && !oracleStatment.toUpperCase().startsWith("CREATE TABLE"))
				{
					isThisObject=true;

				}

				//if( oracleStatment.toUpperCase().startsWith("ALTER") || oracleStatment.toUpperCase().startsWith("INSERT INTO") || oracleStatment.toUpperCase().startsWith("UPDATE") || oracleStatment.toUpperCase().startsWith("DELETE"))
				//{
				sqlExecute=executeLogQueries(con,schemaName, oracleStatment,isThisObject) ;
				//}


			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}//changed by Ashish.J
			if("SUCCESS".equalsIgnoreCase(sqlExecute))
			{
				//String upSql="UPDATE SQL_EXEC_LOG SET STATUS='C' WHERE TRAN_ID=?";
				String upSql="UPDATE SQL_EXEC_LOG SET STATUS='C', RESULT = ?, SQL_EXCEPTION = ? WHERE TRAN_ID=?";
				pstmt = con.prepareStatement(upSql);
				pstmt.setInt(1, reUpdateCnt);
				pstmt.setString(2, sqlError);
				pstmt.setString(3, tranId);

				int updCnt = pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("inside if update count is["+updCnt+"]");
				if(updCnt>0)
				{
					errString = itmdbAccessLocal.getErrorString("confirmed", "VTCONFIRM", "","",con);
					System.out.println("errString is "+ errString);

				}
			}
			else
			{
				String upSql="UPDATE SQL_EXEC_LOG SET STATUS='E', RESULT = ?, SQL_EXCEPTION = ? WHERE TRAN_ID=?";
				pstmt = con.prepareStatement(upSql);
				pstmt.setInt(1, reUpdateCnt);
				pstmt.setString(2, sqlError);
				pstmt.setString(3, tranId);

				int updCnt = pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("inside else update count is["+updCnt+"]");
				errString = itmdbAccessLocal.getErrorString("confirmed", "CONFFAILED", "","",con);
			}

		}//Changed by Ashish.J
		catch(Exception e)
		{
			isError = true;
			try
			{
				con.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Commiting and Closing Connection..........");
				if ( !(isError) )
				{
					System.out.println( "inside finally if" );
					con.commit();
					//errString = itmdbAccessLocal.getErrorString("","TEMCONFIRM",loginEmpCode);
					//errString = itmdbAccessLocal.getErrorString("confirmed", "TEMCONFIRM", "","",con);
				}
				else
				{
					System.out.println( "inside finally rollback else" );
					con.rollback();
				}
				if( pstmt != null )
				{
					System.out.println( "inside finally if pstmt " );

					pstmt.close();
					pstmt = null;
				}
				if( con != null && !con.isClosed() )
				{
					System.out.println( "inside finally if con " );
					con.close();
					con = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errString);
		return errString;
	}

	private String executeLogQueries(Connection connection,String schemaName, String Sql,boolean isThisObjectType) 
	{
		BaseLogger.log("3", null, null, "Inside executeQueries1 [" + Sql + "]");

		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		Statement stmnt = null;
		int updateCount=0;
		CallableStatement callableStmt = null;
		String ExecuteSql="SUCCESS";
		try 
		{

			System.out.println("isThisObjectType1:::::["+isThisObjectType+"]");
			conn = connDriver.getConnectDB(schemaName);
			if( conn == null ) 
			{
				BaseLogger.log("3", null, null, "Unable to get connection for [" + schemaName + "]");
				throw new Exception("Unable to get connection for [" + schemaName + "]");
			}


			if(checkNull(Sql).trim().length() > 0)
			{

				if(isThisObjectType)
				{
					String plsql = " begin " +
							" dbms_metadata.set_transform_param ( DBMS_METADATA.SESSION_TRANSFORM, 'SQLTERMINATOR', false ); " +
							" end; ";
					callableStmt = conn.prepareCall(plsql);
					callableStmt.execute();

				}

				try 
				{
					BaseLogger.log("3", null, null, "Inside manageconf try");
					stmnt = conn.createStatement();
					//int updateCnt = stmnt.executeUpdate(Sql);
					reUpdateCnt = stmnt.executeUpdate(Sql);
					BaseLogger.log("3", null, null, "schema["+schemaName+"]updateCnt to get Sql [" + updateCount + "]");

				}
				catch(SQLException ise)
				{
					sqlError = ise.getMessage();
					BaseLogger.log("3", null, null, "Inside manageconf catch::"+ise.getMessage());
					ExecuteSql="NOT EXECUTE";
					throw new ITMException(ise); 
				}

				finally 
				{
					if (stmnt != null) 
					{
						stmnt.close();
						stmnt = null;
					}
				}
			}


			Thread.sleep(100);					
			conn.commit();




		} 
		catch (Exception e) 
		{
			try 
			{
				BaseLogger.log("3", null, null, "Excepotion in executeAlterQueries occured while executing Alter Queries>>>>::" + e.getMessage());
				ExecuteSql="NOT EXECUTE";
				conn.rollback();
				//sqlError = e.getMessage();
			} 
			catch (SQLException sqle) 
			{
				BaseLogger.log("3", null, null, "SQLException executeAlterQueries occured during rollback:: " + sqle.getMessage());
				sqle.printStackTrace();
			}
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (callableStmt != null) 
				{
					callableStmt.close();
					callableStmt = null;
				}
				if (conn != null) 
				{
					conn.close();
					conn = null;
				}
			} 
			catch (SQLException sqle) 
			{
				BaseLogger.log("3", null, null, "SQLException executeAlterQueries inside finally:: "+ sqle.getMessage());
				sqle.printStackTrace();
			}
		}
		return ExecuteSql;
	}

	private String generateTranID( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_sql_exec_log' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<tran_id></tran_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception exp)
		{
			System.out.println("Exception : RealTimeReportPos :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : RealTimeReportPos :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}

}
