/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.MasterDataStatefulEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.XML2DBEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.Sign;
import ibase.wrkflw.SignManagerLocal;
import ibase.wrkflw.SignManagerRemote;
import ibase.wrkflw.WorkflowProcessDataMangerEJB;
import ibase.wrkflw.WorkflowProcessInstanceMonitorEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.PostActivate;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.nfunk.jep.JEP;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SignManagerEJB
implements SignManagerRemote,
SignManagerLocal {
    static HashMap signMap = new HashMap();
    transient InitialContext ctx = null;
    SessionContext cSessionContext;
    UserInfoBean userInfo = null;
    FileWriter fileWriter = null;
    final String XTRA_PARAMS_SEPARATOR = "~~";
    Connection conn = null;
    String userIDSign;
    String actionCode = "";
    String objName = "";
    String signBy = "";
    protected static String database = CommonConstants.DB_NAME;
    String currentRowNum = null;
    String uptoRowNum = null;

    public SignManagerEJB() {
        try {
            this.setInitialContext();
            WorkflowLogger.info("Setting Ibase Home");
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            this.setInitialContext();
            WorkflowLogger.info("Setting Ibase Home");
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    public void ejbRemove() {
    }

    @PostActivate
    public void ejbActivate() {
        try {
            this.setInitialContext();
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :ejbActivate :==>\n" + e);
        }
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext mSessionContext) {
    }

    private void setInitialContext() throws ITMException {
        try {
            AppConnectParm appConnect = new AppConnectParm();
            this.ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :setInitialContext :");
            throw itme;
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :setInitialContext :");
            throw new ITMException(e);
        }
    }

    @Override
    public String evaluateSign(String objName, String objID) throws RemoteException, ITMException {
        String retString = null;
        try {
            WorkflowLogger.info("[SignManagerEJB]Creating DOM for tran id :[" + objID + "]");
            String domString = this.createDomString(objName, objID);
            Document dom = new E12GenericUtility().parseString(domString);
            retString = this.evaluateSign(dom, objName, objID, null);
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :evaluateSign :Parsing domString ==>");
            throw itme;
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :evaluateSign :Parsing domString ==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retString;
    }

    @Override
    public String evaluateSign(String domString, String objName, String objID) throws RemoteException, ITMException {
        String retString = null;
        try {
            WorkflowLogger.info("[SignManagerEJB]Evaluating Sign for domString :[" + domString + "]");
            Document dom = new E12GenericUtility().parseString(domString);
            retString = this.evaluateSign(dom, objName, objID, null);
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :evaluateSign :Parsing domString ==>");
            throw itme;
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :evaluateSign :Parsing domString ==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retString;
    }

    @Override
    public String evaluateSign(Document dom, String objName, String refID, Connection con) throws RemoteException, ITMException {
        return this.evaluateSign(dom, objName, refID, con, null);
    }

    public String evaluateSign(Document dom, String objName, String refID, Connection con, UserInfoBean userInfo) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Evaluating Sign for...........");
        String retString = "";
        Object confirmedSignXMLStr = null;
        String refSer = null;
        boolean isError = false;
        boolean isConnLocal = false;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                this.userInfo = userInfo;
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                refSer = this.getRefSer(this.conn, objName);
                ArrayList signList = this.getSignObjList(objName);
                if (signList != null && signList.size() > 0 && this.deleteSign(refSer, refID, this.conn)) {
                    JEP signJEP = new JEP();
                    int i = 0;
                    while (i < signList.size()) {
                        Sign currSignObj = (Sign)signList.get(i);
                        refSer = currSignObj.getRefSer();
                        String exprToEval = currSignObj.getCondnExpr();
                        StringBuffer expr = null;
                        boolean confirmFlag = true;
                        if (exprToEval != null && !exprToEval.equalsIgnoreCase("null") && exprToEval.length() > 0) {
                            String varNamesString = currSignObj.getVarNames();
                            StringTokenizer expStringToken = null;
                            if (varNamesString != null && !varNamesString.equalsIgnoreCase("null") && varNamesString.length() > 0) {
                                expStringToken = new StringTokenizer(varNamesString, ",");
                                while (expStringToken.hasMoreTokens()) {
                                    String currField = expStringToken.nextToken();
                                    Object currFieldValue = null;
                                    String currFieldName = currField.substring(0, currField.indexOf("."));
                                    String currFieldDatatype = currField.substring(currField.indexOf(".") + 1);
                                    int indexOfEquals = currFieldDatatype.indexOf("=");
                                    if (indexOfEquals != -1) {
                                        String sqlExpr = currFieldDatatype.substring(indexOfEquals + 1);
                                        currFieldDatatype = currFieldDatatype.substring(0, indexOfEquals);
                                        currFieldValue = this.getSQLResult(sqlExpr, dom, currFieldDatatype);
                                    } else {
                                        currFieldValue = this.getValueOfField(dom, currFieldName, currFieldDatatype);
                                    }
                                    if (currFieldValue == null) continue;
                                    WorkflowLogger.info("Adding Variable value to JEP varname :[" + currFieldName + "] value :[" + currFieldValue + "]");
                                    signJEP.addVariableAsObject(currFieldName, currFieldValue);
                                }
                            }
                            expr = new StringBuffer(exprToEval);
                            if (exprToEval.toUpperCase().indexOf(" AND ") > 0) {
                                expr.replace(exprToEval.toUpperCase().indexOf(" AND "), exprToEval.toUpperCase().indexOf(" AND ") + " AND ".length(), " && ");
                            }
                            if (exprToEval.toUpperCase().indexOf(" OR ") > 0) {
                                expr.replace(exprToEval.toUpperCase().indexOf(" OR "), exprToEval.toUpperCase().indexOf(" OR ") + " OR ".length(), " || ");
                            }
                            exprToEval = new String(expr);
                            WorkflowLogger.info("exprToEval :[" + exprToEval + "]");
                            signJEP.parseExpression(exprToEval);
                            Object resultObj = null;
                            String errorString = signJEP.getErrorInfo();
                            if (errorString != null) {
                                WorkflowLogger.info("[SignManagerEJB]Error while parsing expression : " + errorString);
                                resultObj = errorString;
                                confirmFlag = false;
                            } else {
                                resultObj = signJEP.getValueAsObject();
                                WorkflowLogger.info("[SignManagerEJB] resultObj :[" + resultObj + "]");
                                if (!Double.valueOf("1").equals(resultObj)) {
                                    confirmFlag = false;
                                }
                            }
                        }
                        if (confirmFlag) {
                            String xslFileName = String.valueOf(refSer) + "_Sign";
                            WorkflowLogger.info("[SignManagerEJB]Applying system defined XSL :" + xslFileName + ":");
                            ArrayList roleInfoList = this.getRoleInfoList(this.conn, currSignObj.getRoleCodeSign());
                            String roleEntityCode = this.getRoleEntityCode(currSignObj.getRoleExpr(), currSignObj.getRoleExprType(), roleInfoList, dom);
                            String signXmlStr = "<ROOT><REF_SER>" + refSer + "</REF_SER><REF_ID>" + refID.trim() + "</REF_ID><ROLE_TYPE>" + (String)roleInfoList.get(0) + "</ROLE_TYPE><ROLE_ENTITY>" + (String)roleInfoList.get(1) + "</ROLE_ENTITY><ENTITY_CODE>" + roleEntityCode + "</ENTITY_CODE><ROLE_CODE_SIGN>" + currSignObj.getRoleCodeSign() + "</ROLE_CODE_SIGN><LINE_NO>" + currSignObj.getLineNo() + "</LINE_NO><SIGN_FOR><![CDATA[" + currSignObj.getSignFor() + "]]></SIGN_FOR></ROOT>";
                            this.insertSign(this.conn, signXmlStr, currSignObj.getObjName(), genericUtility.serializeDom(dom), currSignObj.getApprFormatCode(), currSignObj.getSignMsgFormatFile());
                        }
                        ++i;
                    }
                    int minLineNo = this.getMinLineNo(refSer, refID);
                    if (minLineNo > 0) {
                        ArrayList entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                        this.sendMail(genericUtility.serializeDom(dom), refSer, objName, refID, "" + minLineNo, this.getFormatCode(refSer, minLineNo, "APPR_FORMAT_CODE"), (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                    }
                }
            }
            catch (ITMException itme) {
                WorkflowLogger.info("ITMException :SignManagerEJB :evaluateSign :==>");
                isError = true;
                throw itme;
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :evaluateSign :==>" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal && this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private ArrayList getRoleInfoList(Connection con, String roleCode) throws RemoteException, ITMException {
        WorkflowLogger.info("[DBAccessEJB]Getting role code info for roleCode :[" + roleCode + "]");
        Connection mConnection = con;
        Statement mStmt = null;
        ResultSet rs = null;
        ArrayList<String> roleInfoList = null;
        try {
            try {
                if (roleCode != null) {
                    String selectQuery = "SELECT ROLE_TYPE, ROLE_ENTITY, ROLE_ENTITY_SQL, USER_ID FROM WF_ROLE WHERE ROLE_CODE = '" + roleCode + "'";
                    WorkflowLogger.info("Query for Role Info List :[" + selectQuery + "]");
                    mStmt = mConnection.prepareStatement(selectQuery);
                    rs = mStmt.executeQuery();
                    roleInfoList = new ArrayList<String>();
                    if (rs.next()) {
                        String roleType = rs.getString("ROLE_TYPE");
                        roleInfoList.add(roleType);
                        roleInfoList.add(rs.getString("ROLE_ENTITY"));
                        roleInfoList.add(rs.getString("ROLE_ENTITY_SQL"));
                        String userId = rs.getString("USER_ID");
                        if ("S".equals(roleType)) {
                            selectQuery = "SELECT ENTITY_CODE FROM USERS WHERE CODE='" + userId + "'";
                            PreparedStatement stmt = mConnection.prepareStatement(selectQuery);
                            ResultSet rsInr = stmt.executeQuery();
                            if (rsInr.next()) {
                                userId = rsInr.getString("ENTITY_CODE");
                            }
                            if (rsInr != null) {
                                rsInr.close();
                                rsInr = null;
                            }
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                        }
                        roleInfoList.add(userId);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getRoleInfo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mConnection != null) {
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getRoleInfoList :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Returning role code info list :" + roleInfoList + ":");
        return roleInfoList;
    }

    private String getRoleEntityCode(String roleExpr, String roleExprType, ArrayList roleInfoList, Document dataDom) throws Exception {
        String entityCode = "";
        Statement roleExprPStmt = null;
        try {
            try {
                if (((String)roleInfoList.get(0)).equalsIgnoreCase("D")) {
                    WorkflowLogger.info("[SignManagerEJB]Evaluating RoleExpr as roleType is D");
                    if (roleExpr != null) {
                        roleExprPStmt = this.conn.prepareStatement((String)roleInfoList.get(2));
                        int indexOfSep = -1;
                        int bindCtr = 1;
                        WorkflowLogger.info("[SignManagerEJB] roleExpr.indexOf(\":\") " + roleExpr.indexOf(":"));
                        while ((indexOfSep = roleExpr.indexOf(":")) != -1) {
                            String currField = roleExpr.substring(0, indexOfSep);
                            String currType = roleExprType.substring(0, roleExprType.indexOf(":"));
                            WorkflowLogger.info("[SignManagerEJB] currField [" + currField + "] currType [" + currType + "]");
                            Object currValue = this.getValueOfField(dataDom, currField, currType);
                            WorkflowLogger.info("Setting value as :" + currValue + ": for field :" + currField + ":");
                            roleExprPStmt.setObject(bindCtr, currValue);
                            roleExpr = roleExpr.substring(indexOfSep + 1);
                            roleExprType = roleExprType.substring(roleExprType.indexOf(":") + 1);
                            ++bindCtr;
                        }
                        ResultSet roleExprRS = roleExprPStmt.executeQuery();
                        if (roleExprRS.next()) {
                            entityCode = roleExprRS.getString(1);
                            WorkflowLogger.info("[SignManagerEJB]Setting Dynamic entityCode :" + entityCode + ":");
                        }
                        roleExprRS.close();
                        roleExprRS = null;
                        if (roleExprPStmt != null) {
                            roleExprPStmt.close();
                            roleExprPStmt = null;
                        }
                    }
                } else {
                    entityCode = (String)roleInfoList.get(3);
                    WorkflowLogger.info("[SignManagerEJB]Setting Static entityCode  :" + entityCode + ":");
                }
                WorkflowLogger.info("[SignManagerEJB]entityCode :" + entityCode + ":");
            }
            catch (ITMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (roleExprPStmt != null) {
                    roleExprPStmt.close();
                    roleExprPStmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return entityCode;
    }

    private String getRefSer(Connection mConnection, String objName) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]getRefSer() called for objName :[" + objName + "]");
        Statement mStmt = null;
        ResultSet rs = null;
        String refSer = null;
        try {
            try {
                String sqlQuery = null;
                sqlQuery = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
                WorkflowLogger.info("[SignManagerEJB]Fetching refSer from TRANSETUP for the current object : Query :\n" + sqlQuery);
                mStmt = mConnection.prepareStatement(sqlQuery);
                rs = mStmt.executeQuery();
                if (rs.next()) {
                    refSer = rs.getString(1);
                }
                rs.close();
                rs = null;
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getRefSer :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getRefSer :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return refSer != null ? refSer.trim() : refSer;
    }

    private String getRefSerDesc(Connection mConnection, String refSer) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]getRefSerDesc() called for refSer :" + refSer + ":");
        String desc = "";
        Statement mStmt = null;
        ResultSet rs = null;
        try {
            try {
                String mQuery = "SELECT DESCR FROM REFSER WHERE REF_SER = '" + refSer.trim() + "'";
                WorkflowLogger.info("[SignManagerEJB]Retrieving description for the refSer, Query :\n" + mQuery);
                mStmt = mConnection.prepareStatement(mQuery);
                rs = mStmt.executeQuery();
                if (rs.next()) {
                    desc = rs.getString(1);
                }
                rs.close();
                rs = null;
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getRefSerDesc :==>\n" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return desc;
    }

    @Override
    public boolean insertSign(Connection con, String signXmStr, String objName, String dataStr, String formatCode, String xslFileName) throws RemoteException, ITMException {
        boolean isError = false;
        boolean isConnLocal = false;
        boolean updStatus = false;
        Object mQuery = null;
        Statement pStmt = null;
        try {
            try {
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                Document signXmlDom = new E12GenericUtility().parseString(signXmStr);
                String refSer = this.getValueOfField(signXmlDom, "REF_SER");
                String refID = this.getValueOfField(signXmlDom, "REF_ID");
                String roleCodeSign = this.getValueOfField(signXmlDom, "ROLE_CODE_SIGN");
                String roleType = this.getValueOfField(signXmlDom, "ROLE_TYPE");
                String roleEntity = this.getValueOfField(signXmlDom, "ROLE_ENTITY");
                String entityCode = this.getValueOfField(signXmlDom, "ENTITY_CODE");
                String lineNo = this.getValueOfField(signXmlDom, "LINE_NO");
                String signFor = this.getValueOfField(signXmlDom, "SIGN_FOR");
                String prcInstId = this.getValueOfField(signXmlDom, "PRC_INST__WF");
                WorkflowLogger.info("[SignManagerEJB]Inserting record in OBJ_SIGN_TRANS table");
                int noOfRows = 0;
                String insertQuery = "INSERT INTO OBJ_SIGN_TRANS(REF_SER, REF_ID, LINE_NO, SIGN_FOR, ROLE_CODE__SIGN, CREATE_DATE, SIGN_STATUS, TITLE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, PRC_INST__WF, TRANS_INFO, MSG_FRM_FNAME,OBJ_NAME ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_BLOB(), ?,?)";
                WorkflowLogger.info("SignManager .. Inserting into OBJ_SIGN_TRANS [" + insertQuery + "]");
                WorkflowLogger.info("Setting Values refSer [" + refSer + "] refID [" + refID + "] lineNo [" + lineNo + "] signFor [" + signFor + "] roleCodeSign [" + roleCodeSign + "] roleType [" + roleType + "] roleEntity [" + roleEntity + "] entityCode [" + entityCode + "] prcInstId [" + prcInstId + "]");
                pStmt = this.conn.prepareStatement(insertQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, Integer.parseInt(lineNo.trim()));
                pStmt.setString(4, this.customizeDataStr(signFor, dataStr));
                pStmt.setString(5, roleCodeSign);
                pStmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                pStmt.setString(7, "U");
                pStmt.setString(8, "Signature for " + roleCodeSign);
                pStmt.setString(9, roleType);
                pStmt.setString(10, roleEntity);
                pStmt.setString(11, entityCode);
                if (prcInstId == null || "null".equalsIgnoreCase(prcInstId) || prcInstId != null && prcInstId.trim().length() == 0) {
                    pStmt.setString(12, "");
                } else {
                    pStmt.setString(12, prcInstId);
                }
                if (xslFileName != null && xslFileName.length() > 0) {
                    pStmt.setString(13, xslFileName);
                } else {
                    pStmt.setNull(13, 12);
                }
                pStmt.setString(14, objName);
                noOfRows += pStmt.executeUpdate();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                WorkflowLogger.info("[SignManagerEJB]No. of records inserted for curr transaction :" + noOfRows);
                String retStr = this.updateTransInfo(objName, this.conn, refSer, refID, lineNo, signXmStr, dataStr, true, "U");
                if (retStr == "" || "success".equalsIgnoreCase(retStr)) {
                    updStatus = true;
                }
                BaseLogger.log("3", null, null, "new changes conn!!!!" + this.conn);
                this.conn.commit();
                String tableName = " WF_ROLE_USERS ";
                String columnName = " USERID ";
                StringBuilder condition = new StringBuilder();
                condition.append(" WHERE ROLE_CODE='").append(roleCodeSign).append("' ");
                ArrayList<String> userIdList = this.getDBColumnValues(tableName, columnName, condition.toString(), this.userInfo.getTransDB());
                userIdList.add(entityCode);
                String userMessage = "Workflow : " + signFor;
                int lineNumber = Integer.parseInt(lineNo);
                this.publishPushNotificationEJB().invockPushNotification(userMessage, this.userInfo.getLoginCode(), "W", refID, userIdList, "", refID, refSer, this.userInfo.getLoginCode(), lineNumber, this.userInfo);
            }
            catch (ITMException itme) {
                WorkflowLogger.info("ITMException :SignManagerEJB :insertSign :==>\n");
                isError = true;
                updStatus = false;
                throw itme;
            }
            catch (Exception e) {
                e.printStackTrace();
                isError = true;
                updStatus = false;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    @Override
    public boolean deleteSign(String refSer, String refID) throws RemoteException, ITMException {
        boolean retValue = false;
        try {
            retValue = this.deleteSign(refSer, refID, null);
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :deleteSign :==>\n");
            throw itme;
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :deleteSign :==>\n");
            throw new ITMException(e);
        }
        return retValue;
    }

    @Override
    public boolean deleteSign(String refSer, String refID, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]DeleteSign for refser :" + refSer + ": and refID :" + refID);
        boolean retValue = false;
        boolean isError = false;
        boolean isConnLocal = false;
        Object mQuery = null;
        Statement pStmt = null;
        try {
            try {
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                String deleteQuery = "DELETE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ?";
                WorkflowLogger.info("[SignManagerEJB]Deleting signature object...");
                pStmt = this.conn.prepareStatement(deleteQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID.trim());
                int deleteCnt = pStmt.executeUpdate();
                WorkflowLogger.info("[SignManagerEJB]Record(s) deleted :" + deleteCnt);
                retValue = true;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (ITMException itme) {
                WorkflowLogger.info("ITMException :SignManagerEJB :deleteSign :==>\n");
                isError = true;
                throw itme;
            }
            catch (Exception e) {
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retValue;
    }

    private void sendMail(String transInfo, String refSer, String objName, String refId, String lineNo, String formatCode, String entityType, String entityCode, Connection connection) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Sending mail to minimum unsigned signature ...........");
        boolean emailFlag = false;
        try {
            Document xmlDom = null;
            if (transInfo.length() > 0) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                transInfo = genericUtility.remAllXmlDec(transInfo);
                xmlDom = genericUtility.parseString(transInfo);
            }
            if (formatCode != null) {
                String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>" + objName + "</OBJ_NAME>" + "<REF_SER>" + refSer + "</REF_SER><REF_ID>" + refId + "</REF_ID>" + "<LINE_NO>" + lineNo + "</LINE_NO></TRANS_INFO>" + "<MAIL><EMAIL_TYPE>link</EMAIL_TYPE><ENTITY_CODE>" + entityCode + "</ENTITY_CODE>" + "<ENTITY_TYPE>" + entityType + "</ENTITY_TYPE><FORMAT_CODE>" + formatCode + "</FORMAT_CODE>" + "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" + "</MAIL><XML_DATA>" + transInfo + "</XML_DATA></ROOT>";
                WorkflowLogger.info(mailDomStr);
                EMail email = new EMail();
                email.sendMail(mailDomStr, "ITM", this.userInfo);
            }
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :sendMail() :==>\n");
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :sendMail() :==>\n" + e.getMessage());
        }
    }

    @Override
    public String getUserXSLFileName(String refSer, String refId, int lineNo, String roleCode, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Getting user def xsl file name for refSer :" + refSer + " and linNo :" + lineNo + ":");
        Statement pStmt = null;
        ResultSet rs = null;
        String xslFileName = null;
        boolean isConnLocal = false;
        try {
            try {
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                String selectQuery = "SELECT MSG_FRM_FNAME FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
                pStmt = this.conn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refId);
                pStmt.setInt(3, lineNo);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    WorkflowLogger.info("File Name From OBJ_SIGN_TRANS");
                    xslFileName = rs.getString("MSG_FRM_FNAME");
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                if (xslFileName == null || xslFileName != null && xslFileName.length() == 0) {
                    selectQuery = "SELECT MSG_FRM_FNAME FROM OBJ_SIGN WHERE REF_SER = ? AND LINE_NO = ?";
                    pStmt = this.conn.prepareStatement(selectQuery);
                    pStmt.setString(1, refSer);
                    pStmt.setInt(2, lineNo);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        WorkflowLogger.info("File Name From OBJ_SIGN");
                        xslFileName = rs.getString("MSG_FRM_FNAME");
                    }
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                }
                if (xslFileName == null || xslFileName != null && xslFileName.length() == 0) {
                    WorkflowLogger.info("File Name From refSer and roleCode");
                    xslFileName = String.valueOf(refSer) + "_" + roleCode;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getUserXSLFileName :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null && isConnLocal) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getUserXSLFileName :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Returning XSL file name :" + xslFileName + ":");
        return xslFileName;
    }

    @Override
    public String getSignXMLString(String userID, String siteCode, String objName, String refSer, String refID, int lineNo, boolean isSelTransInfo, boolean isViewAll, String signDate, String createDate, String operand, String userInfoStr, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Getting sign XML string for \nuserID :" + userID + ": \nobjName :" + objName + ": \nrefSer :" + refSer + ": \nrefID :" + refID + ": \nlineNo :" + lineNo + ": \nisSelTransInfo :" + isSelTransInfo + ": \nisViewAll :" + isViewAll + ":");
        ResultSet rs = null;
        Statement pStmt = null;
        ResultSetMetaData rsmd = null;
        String retString = null;
        boolean isError = false;
        boolean isConnLocal = false;
        String loginEntityCode = "";
        String entiCode = "";
        String roleCode = "";
        boolean isExist = false;
        try {
            try {
                this.conn = con;
                this.userInfo = new UserInfoBean(userInfoStr);
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                WorkflowLogger.info("ENITY CODE = " + this.userInfo.getEntityCode());
                loginEntityCode = this.userInfo.getEntityCode();
                String selQuery = null;
                StringBuffer xmlStringBuff = new StringBuffer();
                StringBuffer roleCodeBuff = new StringBuffer();
                ArrayList roleCodeList = null;
                StringBuffer addWhereClauseBuff = new StringBuffer();
                String refSerDesc = "";
                int domId = 1;
                boolean isRefID = false;
                boolean isLineNo = false;
                if (userID != null && userID.length() > 0) {
                    roleCodeList = this.getRoleCodeList(userID);
                    int ctr = 0;
                    while (ctr < roleCodeList.size()) {
                        roleCodeBuff.append("'" + roleCodeList.get(ctr) + "',");
                        ++ctr;
                    }
                    if (roleCodeBuff.length() > 0) {
                        roleCodeBuff.deleteCharAt(roleCodeBuff.length() - 1);
                    }
                }
                if (refSer == null && objName != null && objName.length() > 0) {
                    refSer = this.getRefSer(this.conn, objName);
                }
                refSerDesc = this.getRefSerDesc(this.conn, refSer);
                addWhereClauseBuff.append(" REF_SER = ?");
                if (refID != null && !"null".equalsIgnoreCase(refID) && refID.length() > 0) {
                    isRefID = true;
                    addWhereClauseBuff.append(" AND LTRIM( RTRIM ( REF_ID ) ) = '").append(refID.trim()).append("' ");
                }
                if (roleCodeBuff.length() > 0) {
                    addWhereClauseBuff.append(" AND ( ROLE_CODE__SIGN IN(" + roleCodeBuff.toString() + ")").append(" OR LTRIM( RTRIM ( ENTITY_CODE )  ) ='").append(this.checkNull(this.userInfo.getEntityCode()).trim()).append("' ) ");
                } else {
                    addWhereClauseBuff.append(" AND LTRIM( RTRIM ( ENTITY_CODE )  ) ='").append(this.checkNull(this.userInfo.getEntityCode()).trim()).append("' ");
                }
                if (!isViewAll) {
                    addWhereClauseBuff.append(" AND SIGN_STATUS = 'U' ");
                }
                if (lineNo != -1 && isRefID) {
                    isLineNo = true;
                    addWhereClauseBuff.append(" AND LINE_NO = ").append("?");
                }
                selQuery = isSelTransInfo ? " SELECT REF_SER, REF_ID, LINE_NO, SIGN_REMARKS, SIGN_STATUS, ROLE_CODE__SIGN, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, RIGHTS_CHAR_SIGN, USER_INPUT FROM OBJ_SIGN_TRANS" : " SELECT REF_SER, REF_ID, LINE_NO, SIGN_FOR, ROLE_CODE__SIGN, SIGN_DATE, USER_ID__SIGN, USER_ID__SIGN AS SIGNED_BY, SIGN_REMARKS, SIGN_STATUS, CREATE_DATE, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, RIGHTS_CHAR_SIGN, USER_INPUT FROM OBJ_SIGN_TRANS";
                selQuery = String.valueOf(selQuery) + " WHERE " + addWhereClauseBuff.toString();
                WorkflowLogger.info("[SignManagerEJB]Retrieving relevant records from OBJ_SIGN_TRANS table, Query :\n" + selQuery);
                pStmt = this.conn.prepareStatement(selQuery);
                WorkflowLogger.info("Setting Ref Ser :[" + refSer + "]");
                pStmt.setString(1, refSer);
                if (isRefID) {
                    WorkflowLogger.info("Setting Ref Id :[" + refID.trim() + "]");
                    WorkflowLogger.info("this.database :[" + database + "]");
                    if (isLineNo) {
                        WorkflowLogger.info("Setting Line No. :[" + lineNo + "]");
                        pStmt.setInt(2, lineNo);
                    }
                } else if (isLineNo) {
                    WorkflowLogger.info("Setting line No :[" + lineNo + "]");
                    pStmt.setInt(2, lineNo);
                }
                WorkflowLogger.info("[SignManagerEJB]Executing Query...........");
                rs = pStmt.executeQuery();
                WorkflowLogger.info("[SignManagerEJB]Query executed");
                rsmd = rs.getMetaData();
                int noOfCols = rsmd.getColumnCount();
                while (rs.next()) {
                    entiCode = "";
                    roleCode = "";
                    isExist = false;
                    entiCode = rs.getString("ENTITY_CODE");
                    roleCode = rs.getString("ROLE_CODE__SIGN");
                    isExist = loginEntityCode.equals(entiCode) ? true : this.isTransactionAsignedToUser(userID, roleCode, entiCode);
                    if (!isExist) continue;
                    WorkflowLogger.info("Records Found....");
                    xmlStringBuff.append("<Detail domID='" + domId++ + "' objName='" + objName + "' refSerDesc='" + refSerDesc + "'>");
                    xmlStringBuff.append("<attribute id='pkfield1value:pkfield2value:'/>");
                    xmlStringBuff.append("<attribute status=''/>");
                    xmlStringBuff.append("<attribute selected=''/>");
                    String roleType = null;
                    String roleEntity = null;
                    String entityCode = null;
                    String roleCodeSign = null;
                    String userInput = null;
                    int i = 1;
                    while (i <= noOfCols) {
                        String data = null;
                        String colName = rsmd.getColumnName(i);
                        int metaType = rsmd.getColumnType(i);
                        if (metaType == 91 || metaType == 93) {
                            E12GenericUtility genericUtility;
                            if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                                Timestamp currTimestamp = rs.getTimestamp(i);
                                if (currTimestamp != null) {
                                    genericUtility = new E12GenericUtility();
                                    data = genericUtility.getValidDateTimeString(currTimestamp.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                                }
                            } else {
                                Date currDate = rs.getDate(i);
                                if (currDate != null) {
                                    genericUtility = new E12GenericUtility();
                                    data = genericUtility.getValidDateString(currDate.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                                }
                            }
                        } else {
                            data = rs.getString(i);
                        }
                        if (data == null) {
                            data = "";
                        }
                        if (data.toUpperCase().indexOf("<![CDATA[") == -1) {
                            xmlStringBuff.append("<" + colName + "><![CDATA[" + data + "]]></" + colName + ">");
                        } else {
                            xmlStringBuff.append("<" + colName + ">" + data + "</" + colName + ">");
                        }
                        if (colName.equalsIgnoreCase("ROLE_TYPE")) {
                            roleType = data;
                        } else if (colName.equalsIgnoreCase("ROLE_ENTITY")) {
                            roleEntity = data;
                        } else if (colName.equalsIgnoreCase("ENTITY_CODE")) {
                            entityCode = data;
                        } else if (colName.equalsIgnoreCase("ROLE_CODE__SIGN")) {
                            roleCodeSign = data;
                        } else if (colName.equalsIgnoreCase("USER_INPUT")) {
                            userInput = data;
                        }
                        ++i;
                    }
                    userInfoStr = this.userInfo.getEntityCode();
                    WorkflowLogger.info("Comparing userInfoStr [" + userInfoStr + "] with entityCode [" + entityCode + "]entityCode");
                    WorkflowLogger.info("OR roleCode :[" + roleCodeSign + "] IN List :" + roleCodeList);
                    if (isSelTransInfo) {
                        BaseLogger.log("3", null, null, " CommonConstants.DB_NAME ..[ " + CommonConstants.DB_NAME + " ]");
                        if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                            BaseLogger.log("3", null, null, "inside if...");
                            xmlStringBuff.append("<TRANS_INFO>").append(this.getTransInfoXMLTypeStr(refSer, refID, lineNo, addWhereClauseBuff.toString())).append(this.getPrevSignRemarks(refSer, refID)).append("</TRANS_INFO>");
                        } else {
                            BaseLogger.log("3", null, null, "inside else...");
                            xmlStringBuff.append("<TRANS_INFO>").append(this.getTransInfo(refSer, refID, lineNo, addWhereClauseBuff.toString())).append(this.getPrevSignRemarks(refSer, refID)).append("</TRANS_INFO>");
                        }
                    }
                    if (entityCode != null) {
                        entityCode = entityCode.trim();
                    }
                    if (userInfoStr.trim().equalsIgnoreCase(entityCode) || roleCodeList.contains(roleCodeSign)) {
                        xmlStringBuff.append("<UPDATE_FLAG><![CDATA[Y]]></UPDATE_FLAG>");
                    } else {
                        xmlStringBuff.append("<UPDATE_FLAG><![CDATA[N]]></UPDATE_FLAG>");
                    }
                    xmlStringBuff.append("</Detail>");
                }
                retString = new E12GenericUtility().getNormalizeString(xmlStringBuff.toString());
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (ITMException itme) {
                System.err.println("ITMException :SignManagerEJB :getSignXMLString :\n");
                isError = true;
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getSignXMLString :\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getSignXMLString :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Returning sign xml string length [" + retString.length() + "]");
        return retString;
    }

    private ArrayList getRoleCodeList(String userID) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Getting all role codes for the given user :" + userID + ":");
        ArrayList<String> roleCodeList = null;
        Statement mStmt = null;
        try {
            roleCodeList = new ArrayList<String>();
            String sqlQuery = " SELECT WF_ROLE_USERS.ROLE_CODE FROM WF_ROLE_USERS, WF_ROLE  WHERE WF_ROLE_USERS.ROLE_CODE = WF_ROLE.ROLE_CODE AND WF_ROLE.ROLE_TYPE = 'S' AND WF_ROLE_USERS.USERID = '" + userID + "' ";
            WorkflowLogger.info("[SignMangerEJB]Retrieving all role codes for the given user, query :\n" + sqlQuery);
            mStmt = this.conn.prepareStatement(sqlQuery);
            ResultSet rs = mStmt.executeQuery();
            while (rs.next()) {
                String currRoleCode = rs.getString("ROLE_CODE");
                roleCodeList.add(currRoleCode.trim());
            }
            WorkflowLogger.info("[SignMangerEJB]ArrayList listing all Role Code corresponding to the given User :" + roleCodeList);
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (mStmt != null) {
                mStmt.close();
                mStmt = null;
            }
        }
        catch (Exception e) {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception exp) {
                WorkflowLogger.info("Exception :SignManagerEJB :getRoleCodeList :\n" + e.getMessage());
                throw new ITMException(exp);
            }
            throw new ITMException(e);
        }
        return roleCodeList;
    }

    @Override
    public String saveTrans(String objName, String refSer, String refID, String lineNo, String chgSignStr, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignTransEJB]Updating Trans Info  ..................");
        String updStatus = "true";
        Statement pstmt = null;
        boolean isConnLocal = false;
        boolean isError = false;
        String transInfo = null;
        String transInfoXmlBefore = "";
        String transInfoXmlAfter = "";
        String wfAction = "U";
        String userId = "";
        String xtraParams = "";
        try {
            try {
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                if (chgSignStr != null && chgSignStr.length() > 0) {
                    transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, Integer.parseInt(lineNo.trim())) : this.getTransInfo(refSer, refID, Integer.parseInt(lineNo.trim()));
                    transInfoXmlBefore = transInfo;
                    transInfoXmlAfter = transInfo = this.applyDataToXML(chgSignStr, transInfo);
                    String retStr = this.updateTransInfo(objName, this.conn, refSer, refID, lineNo, chgSignStr, transInfo, false, "U");
                    if (retStr == "" || "success".equalsIgnoreCase(retStr)) {
                        updStatus = "<Root><Detail>Success</Detail></Root>";
                        try {
                            ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, lineNo);
                            String processInstanceId = (String)processInstanceInfo.get(0);
                            String chgTransInfoXml = this.getChangedDataString(transInfoXmlAfter, false);
                            String auditChangedXml = this.getChangedXmlString(objName, transInfoXmlBefore, chgTransInfoXml, transInfoXmlAfter, this.conn);
                            XML2DBEJB xml2dbejb = new XML2DBEJB();
                            if (refID == null || refID.trim().length() == 0) {
                                refID = "          ";
                            }
                            BaseLogger.log("3", null, null, "\ntransInfoXmlBefore ::" + transInfoXmlBefore);
                            BaseLogger.log("3", null, null, "\nchgTransInfoXml ::" + chgTransInfoXml);
                            BaseLogger.log("3", null, null, "\ntransInfoXmlAfter ::" + transInfoXmlAfter);
                            if (this.userInfo != null) {
                                userId = this.userInfo.getLoginCode();
                                xtraParams = this.getXtraParams();
                            }
                            boolean updateStatus = xml2dbejb.saveValuesInAudit(userId, refID, wfAction, objName, processInstanceId, transInfoXmlBefore, auditChangedXml, transInfoXmlAfter, xtraParams, this.conn, this.userInfo.toString());
                            xml2dbejb = null;
                            BaseLogger.log("3", null, null, "updateStatus in saveTrans[6] from audit trail =[" + updateStatus + "], refID=[" + refID + "]");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        updStatus = retStr;
                    }
                }
            }
            catch (Exception e) {
                updStatus = "false";
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :SaveTrans :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    @Override
    public String saveTrans(String objName, String refSer, String refID, String lineNo, String chgSignStr, String userInfoStr, String saveRemarks, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignTransEJB]Updating Trans Info  ..................");
        String updStatus = "true";
        Object rs = null;
        String sql = "";
        Statement pstmt = null;
        boolean isConnLocal = false;
        boolean isError = false;
        String transInfo = null;
        String transInfoXmlBefore = "";
        String transInfoXmlAfter = "";
        String wfAction = "U";
        String xtraParams = "";
        try {
            try {
                String updateStr;
                String retStr;
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                this.userInfo = new UserInfoBean(userInfoStr);
                BaseLogger.log("3", null, null, "chgSignStr....[" + chgSignStr + "]");
                if (chgSignStr != null && chgSignStr.length() > 0) {
                    transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, Integer.parseInt(lineNo.trim())) : this.getTransInfo(refSer, refID, Integer.parseInt(lineNo.trim()));
                    transInfoXmlBefore = transInfo;
                    transInfoXmlAfter = transInfo = this.applyDataToXML(chgSignStr, transInfo);
                    retStr = this.updateTransInfo(objName, this.conn, refSer, refID, lineNo, chgSignStr, transInfo, false, "U");
                    updStatus = retStr == "" || "success".equalsIgnoreCase(retStr) ? ((updateStr = this.updateObjSignTrans(refSer, refID, Integer.parseInt(lineNo), saveRemarks, "U", this.conn, "")) != null && "true".equalsIgnoreCase(updateStr) ? "<Root><Detail>Success</Detail></Root>" : retStr) : retStr;
                } else {
                    retStr = this.updateTransInfo(objName, this.conn, refSer, refID, lineNo, chgSignStr, transInfo, false, "U");
                    updateStr = this.updateObjSignTrans(refSer, refID, Integer.parseInt(lineNo), saveRemarks, "U", this.conn, "");
                    if (updateStr != null && "true".equalsIgnoreCase(updateStr)) {
                        updStatus = "<Root><Detail>Success</Detail></Root>";
                        transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, Integer.parseInt(lineNo.trim())) : this.getTransInfo(refSer, refID, Integer.parseInt(lineNo.trim()));
                        transInfoXmlBefore = transInfoXmlAfter = transInfo;
                    } else {
                        updStatus = retStr;
                    }
                }
                BaseLogger.log("3", null, null, "updStatus in saveTrans[8] =[" + updStatus + "]");
                if (updStatus != null && updStatus.indexOf("Success") != -1) {
                    try {
                        ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, lineNo);
                        String processInstanceId = (String)processInstanceInfo.get(0);
                        String chgTransInfoXml = this.getChangedDataString(transInfoXmlAfter, false);
                        String auditChangedXml = this.getChangedXmlString(objName, transInfoXmlBefore, chgTransInfoXml, transInfoXmlAfter, this.conn);
                        XML2DBEJB xml2dbejb = new XML2DBEJB();
                        if (refID == null || refID.trim().length() == 0) {
                            refID = "          ";
                        }
                        BaseLogger.log("3", null, null, "\ntransInfoXmlBefore ::" + transInfoXmlBefore);
                        BaseLogger.log("3", null, null, "\nchgTransInfoXml ::" + chgTransInfoXml);
                        BaseLogger.log("3", null, null, "\ntransInfoXmlAfter ::" + transInfoXmlAfter);
                        xtraParams = this.getXtraParams();
                        boolean updateStatus = xml2dbejb.saveValuesInAudit(this.userInfo.getLoginCode(), refID, wfAction, objName, processInstanceId, transInfoXmlBefore, auditChangedXml, transInfoXmlAfter, xtraParams, this.conn, userInfoStr);
                        xml2dbejb = null;
                        BaseLogger.log("3", null, null, "updateStatus in saveTrans[8] from audit trail =[" + updateStatus + "], refID=[" + refID + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                updStatus = "false";
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :SaveTrans :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    @Override
    public String sign(String signXMLString, String chgString, String userInfoStr, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Updating the current signature ..................");
        String wsReturnValue = "";
        String retString = "";
        Statement pStmt = null;
        String mQuery = null;
        boolean isConnLocal = false;
        boolean isError = false;
        String formatCode = "";
        String transInfoXmlBefore = "";
        String transInfoXmlAfter = "";
        String wfAction = "";
        String wfProcessInstanceId = "";
        try {
            try {
                this.userInfo = new UserInfoBean(userInfoStr);
                this.conn = con;
                if (this.conn == null) {
                    this.conn = this.getConnection(this.userInfo.getTransDB());
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                ArrayList signDetailList = this.getSignDetailList(signXMLString);
                String objName = (String)signDetailList.get(0);
                String refSer = (String)signDetailList.get(1);
                if ((refSer == null || refSer.equalsIgnoreCase("null")) && objName != null && objName.length() > 0) {
                    refSer = this.getRefSer(this.conn, objName);
                }
                WorkflowLogger.info("[SignManagerEJB]Ref Series :" + refSer + ":");
                String workflowOpt = this.getWorkFlowOpt(objName, this.userInfo);
                String xtraParams = this.getXtraParams();
                StringTokenizer refIdST = new StringTokenizer((String)signDetailList.get(2), ",");
                StringTokenizer lineNoST = new StringTokenizer(((String)signDetailList.get(3)).trim(), ",");
                while (refIdST.hasMoreTokens()) {
                    String refID = refIdST.nextToken();
                    int lineNo = Integer.parseInt(lineNoST.nextToken().trim());
                    String transInfo = "";
                    transInfoXmlBefore = "";
                    transInfoXmlAfter = "";
                    if (chgString != null && chgString.length() > 0) {
                        transInfoXmlAfter = transInfo = this.getChangedTransInfo(refSer, refID, "" + lineNo, chgString);
                        transInfoXmlBefore = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                        String signStatus = (String)signDetailList.get(6);
                        String retStr = this.updateTransInfo(objName, this.conn, refSer, refID, "" + lineNo, chgString, transInfo, false, signStatus);
                        if (retStr != "" && !"success".equalsIgnoreCase(retStr)) {
                            retString = retStr;
                            isError = true;
                            break;
                        }
                    } else {
                        BaseLogger.log("3", null, null, "@@@@ calling getTransInfoXMLTypeStr in else");
                        transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                        transInfoXmlBefore = transInfoXmlAfter = transInfo;
                    }
                    try {
                        boolean isAllSigned = false;
                        if ("1".equals(workflowOpt)) {
                            boolean toMail = true;
                            String signStatus = (String)signDetailList.get(6);
                            if (signStatus.equalsIgnoreCase("R")) {
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                formatCode = "REJ_FORMAT_CODE";
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                            } else if (this.isAllSigned(refSer, refID, "" + lineNo)) {
                                wsReturnValue = this.updateTransData(objName, refID, transInfo, (String)signDetailList.get(4), (String)signDetailList.get(7), null);
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                                if (!isError) {
                                    wsReturnValue = this.executeSystemEvent(objName, "pre_confirm", null, transInfo, xtraParams);
                                    WorkflowLogger.info("[SignManagerEJB] Return Value After pre_confirm [" + wsReturnValue + "]");
                                    if (wsReturnValue.indexOf("<Errors>") != -1) {
                                        isError = true;
                                    }
                                }
                                isAllSigned = true;
                                toMail = false;
                            }
                            if (wsReturnValue.indexOf("<Errors>") != -1) {
                                WorkflowLogger.info("[SignManagerEJB]Ws With Errors");
                                retString = wsReturnValue;
                                isError = true;
                            } else if (toMail) {
                                int minLineNo = lineNo;
                                if (signStatus.equalsIgnoreCase("S")) {
                                    minLineNo = this.getMinLineNo(refSer, refID);
                                }
                                if (minLineNo > 0) {
                                    ArrayList entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                    String mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                    if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                        this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                    }
                                }
                            }
                        } else if ("2".equals(workflowOpt) || "3".equals(workflowOpt) || "4".equals(workflowOpt)) {
                            ArrayList processInstanceInfo = this.getProcessInstanceInfo((String)signDetailList.get(1), refID, "" + lineNo);
                            String processInstanceId = (String)processInstanceInfo.get(0);
                            String processId = (String)processInstanceInfo.get(1);
                            String instanceId = (String)processInstanceInfo.get(2);
                            if (processInstanceId != null && processInstanceId.length() > 0) {
                                WorkflowLogger.info("Updating WF_PRC_DATA ... ");
                                String chgTransInfo = this.getChangedDataString(transInfo, true);
                                WorkflowLogger.info("SignManagerEJB chgTransInfo [" + chgTransInfo + "]");
                                chgTransInfo = "<Root>" + chgTransInfo + "</Root>";
                                String query = "";
                                query = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' " : "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
                                ArrayList<String> bindVarValues = new ArrayList<String>();
                                bindVarValues.add(processId.trim());
                                bindVarValues.add(instanceId.trim());
                                ArrayList<String> bindVarTypes = new ArrayList<String>();
                                bindVarTypes.add("String");
                                bindVarTypes.add("Int");
                                BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB sign4");
                                String wfData = "";
                                wfData = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getXMLTypeStr(this.conn, query, bindVarValues, bindVarTypes) : this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, this.userInfo);
                                transInfo = this.applyDataToXML(chgTransInfo, wfData);
                                WorkflowLogger.info(" CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "] ");
                                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                                    Connection tempConn = this.getConnection();
                                    WorkflowLogger.info("Using mssql with binary stream...");
                                    String prcDataInsQuery = "UPDATE WF_PRC_DATA  SET ARGUMENT_VALUE = ? WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = '$XML_DATA_ALL'";
                                    pStmt = tempConn.prepareStatement(prcDataInsQuery);
                                    byte[] encoded = transInfo.getBytes();
                                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                                    pStmt.setBinaryStream(1, byteArrayIn, byteArrayIn.available());
                                    pStmt.setString(2, processId);
                                    pStmt.setInt(3, Integer.parseInt(instanceId));
                                    pStmt.executeUpdate();
                                    pStmt.close();
                                    pStmt = null;
                                    tempConn.close();
                                    tempConn = null;
                                } else {
                                    query = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?)  WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                                    bindVarValues.clear();
                                    bindVarValues.add(processId.trim());
                                    bindVarValues.add(instanceId.trim());
                                    bindVarValues.add("$XML_DATA_ALL");
                                    bindVarTypes.clear();
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    boolean updateStatus = this.updateXMLTypeStr(this.conn, query, transInfo, bindVarValues, bindVarTypes);
                                    if (updateStatus) {
                                        isError = false;
                                    }
                                }
                                WorkflowLogger.info("Updated WF_PRC_DATA");
                                WorkflowLogger.info("Updating ActivityStatus");
                                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
                                String signStatus = (String)signDetailList.get(6);
                                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + signStatus + "]]></RESULT></ROOT>";
                                WorkflowLogger.info("Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from sign ");
                                workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", "", "", "", new E12GenericUtility().getValueFromXTRA_PARAMS(retString, "entityCode"), "E", resultXmlStr, this.conn);
                            }
                        }
                        if (!isError) {
                            mQuery = "UPDATE OBJ_SIGN_TRANS SET SIGN_DATE=?,USER_ID__SIGN=?,SIGN_REMARKS=?,SIGN_STATUS = ?, EMP_CODE = ? WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
                            pStmt = this.conn.prepareStatement(mQuery);
                            WorkflowLogger.info("[SignManagerEJB]Updating the curr signature, Query :\n" + mQuery);
                            Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
                            pStmt.setTimestamp(1, timeStamp);
                            pStmt.setString(2, this.userInfo.getLoginCode());
                            pStmt.setString(3, (String)signDetailList.get(5));
                            pStmt.setString(4, (String)signDetailList.get(6));
                            pStmt.setString(5, this.userInfo.getEmpCode());
                            pStmt.setString(6, refSer);
                            pStmt.setString(7, refID);
                            pStmt.setInt(8, lineNo);
                            int updRowNo = pStmt.executeUpdate();
                            if ("1".equals(workflowOpt) && isAllSigned) {
                                int minLineNo = lineNo;
                                String signStatus = (String)signDetailList.get(6);
                                if (signStatus.equalsIgnoreCase("S")) {
                                    minLineNo = this.getMinLineNo(refSer, refID);
                                }
                                if (minLineNo > 0) {
                                    ArrayList entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                    String mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                    if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                        this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                    }
                                }
                            }
                            pStmt.close();
                            pStmt = null;
                        }
                        isError = false;
                    }
                    catch (Exception e) {
                        isError = false;
                        continue;
                    }
                    if (isError) continue;
                    try {
                        wfAction = (String)signDetailList.get(6);
                        ArrayList processInstanceInfo = this.getProcessInstanceInfo((String)signDetailList.get(1), refID, "" + lineNo);
                        String processInstanceId = (String)processInstanceInfo.get(0);
                        String chgTransInfoXml = this.getChangedDataString(transInfoXmlAfter, false);
                        String auditChangedXml = this.getChangedXmlString(objName, transInfoXmlBefore, chgTransInfoXml, transInfoXmlAfter, this.conn);
                        XML2DBEJB xml2dbejb = new XML2DBEJB();
                        if (refID == null || refID.trim().length() == 0) {
                            refID = "          ";
                        }
                        BaseLogger.log("3", this.userInfo, null, "\ntransInfoXmlBefore ::" + transInfoXmlBefore);
                        BaseLogger.log("3", this.userInfo, null, "\nchgTransInfoXml ::" + chgTransInfoXml);
                        BaseLogger.log("3", this.userInfo, null, "\ntransInfoXmlAfter ::" + transInfoXmlAfter);
                        boolean updateStatus = xml2dbejb.saveValuesInAudit(this.userInfo.getLoginCode(), refID, wfAction, objName, processInstanceId, transInfoXmlBefore, auditChangedXml, transInfoXmlAfter, xtraParams, this.conn, userInfoStr);
                        xml2dbejb = null;
                        BaseLogger.log("3", null, null, "updateStatus sign(4) from audit trail =[" + updateStatus + "], refID =[" + refID + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!isError) {
                    retString = "<Root><Detail>Success</Detail></Root>";
                }
            }
            catch (ITMException itme) {
                isError = true;
                itme.printStackTrace();
                throw itme;
            }
            catch (SQLException e) {
                WorkflowLogger.info("Exception :SignManagerEJB :sign :==> \n" + e.getMessage());
                isError = true;
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                isError = true;
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Return String from update sign:" + retString + ":");
        return retString;
    }

    @Override
    public String sign(int lineNo, String refID, String refSer, String objName, String signStatus, String userId, String siteCode, String signRemarks, String chgString, String userInfoStr) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Updating the current signature With single connection..................");
        String wsReturnValue = "";
        String retString = "";
        Statement pStmt = null;
        Object mQuery = null;
        Object sql = null;
        String processId = null;
        ResultSet rsLock = null;
        Statement pstmtLock = null;
        boolean isError = false;
        String formatCode = "";
        E12GenericUtility genericutility = new E12GenericUtility();
        String transInfoXmlBefore = "";
        String transInfoXmlAfter = "";
        try {
            try {
                this.userInfo = new UserInfoBean(userInfoStr);
                if (this.conn == null) {
                    this.conn = this.getConnection(this.userInfo.getTransDB());
                }
                this.conn.setAutoCommit(false);
                String workflowOpt = this.getWorkFlowOpt(objName, this.conn);
                String xtraParams = this.getXtraParams();
                String transInfo = "";
                if ((refSer == null || refSer.equalsIgnoreCase("null")) && objName != null && objName.length() > 0) {
                    refSer = this.getRefSerFromTransetup(objName, this.conn);
                }
                if (chgString != null && chgString.length() > 0) {
                    transInfoXmlAfter = transInfo = this.getChangedTransInfo(refSer, refID, "" + lineNo, chgString, this.conn);
                    transInfoXmlBefore = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                } else {
                    BaseLogger.log("3", null, null, "@@@@ calling getTransInfoXMLTypeStr in else");
                    transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                    transInfoXmlBefore = transInfoXmlAfter = transInfo;
                }
                String retStr = this.updateTransInfo(objName, this.conn, refSer, refID, "" + lineNo, chgString, transInfo, false, signStatus);
                if (retStr != "" && !"success".equalsIgnoreCase(retStr)) {
                    retString = retStr;
                    isError = true;
                }
                try {
                    String mailFormatCode;
                    ArrayList entityInfo;
                    boolean isAllSigned = false;
                    if (!isError) {
                        if ("1".equals(workflowOpt)) {
                            boolean toMail = true;
                            if (signStatus.equalsIgnoreCase("R")) {
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                formatCode = "REJ_FORMAT_CODE";
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                            } else if (this.isAllSigned(refSer, refID, "" + lineNo, this.conn)) {
                                wsReturnValue = this.updateTransData(objName, refID, transInfo, userId, siteCode, null);
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                                if (!isError) {
                                    wsReturnValue = this.executeSystemEvent(objName, "pre_confirm", null, transInfo, xtraParams);
                                    WorkflowLogger.info("[SignManagerEJB] Return Value After pre_confirm [" + wsReturnValue + "]");
                                    if (wsReturnValue.indexOf("<Errors>") != -1) {
                                        isError = true;
                                    }
                                }
                                isAllSigned = true;
                                toMail = false;
                            }
                            if (wsReturnValue.indexOf("<Errors>") != -1) {
                                WorkflowLogger.info("[SignManagerEJB]Ws With Errors");
                                retString = wsReturnValue;
                                isError = true;
                            } else if (toMail) {
                                int minLineNo = lineNo;
                                if (signStatus.equalsIgnoreCase("S")) {
                                    minLineNo = this.getMinLineNo(refSer, refID, this.conn);
                                }
                                if (minLineNo > 0) {
                                    entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                    mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                    if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                        this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                    }
                                }
                            }
                        } else if ("2".equals(workflowOpt) || "3".equals(workflowOpt) || "4".equals(workflowOpt)) {
                            ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, "" + lineNo, this.conn);
                            String processInstanceId = (String)processInstanceInfo.get(0);
                            processId = (String)processInstanceInfo.get(1);
                            String instanceId = (String)processInstanceInfo.get(2);
                            if (processInstanceId != null && processInstanceId.length() > 0) {
                                WorkflowLogger.info("Updating WF_PRC_DATA ... ");
                                String chgTransInfo = this.getChangedDataString(transInfo, true);
                                chgTransInfo = "<Root>" + chgTransInfo + "</Root>";
                                WorkflowLogger.info("SignManagerEJB chgTransInfo [" + chgTransInfo + "]");
                                String query = "";
                                query = "mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' " : "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
                                ArrayList<String> bindVarValues = new ArrayList<String>();
                                bindVarValues.add(processId.trim());
                                bindVarValues.add(instanceId.trim());
                                ArrayList<String> bindVarTypes = new ArrayList<String>();
                                bindVarTypes.add("String");
                                bindVarTypes.add("Int");
                                String wfData = "";
                                BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB sign10");
                                wfData = "mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, this.userInfo) : this.getXMLTypeStr(this.conn, query, bindVarValues, bindVarTypes);
                                transInfo = this.applyDataToXML(chgTransInfo, wfData);
                                WorkflowLogger.info(" CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "] ");
                                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                                    WorkflowLogger.info("Using mssql with binary stream...");
                                    String prcDataInsQuery = "UPDATE WF_PRC_DATA  SET ARGUMENT_VALUE = ? WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = '$XML_DATA_ALL'";
                                    pStmt = this.conn.prepareStatement(prcDataInsQuery);
                                    byte[] encoded = transInfo.getBytes();
                                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                                    pStmt.setBinaryStream(1, byteArrayIn, byteArrayIn.available());
                                    pStmt.setString(2, processId);
                                    pStmt.setInt(3, Integer.parseInt(instanceId));
                                    pStmt.executeUpdate();
                                    pStmt.close();
                                    pStmt = null;
                                } else {
                                    query = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?)  WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                                    bindVarValues.clear();
                                    bindVarValues.add(processId.trim());
                                    bindVarValues.add(instanceId.trim());
                                    bindVarValues.add("$XML_DATA_ALL");
                                    bindVarTypes.clear();
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    boolean updateStatus = this.updateXMLTypeStr(this.conn, query, transInfo, bindVarValues, bindVarTypes);
                                    if (updateStatus) {
                                        isError = false;
                                    }
                                }
                                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
                                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + signStatus + "]]></RESULT></ROOT>";
                                WorkflowLogger.info("Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from sign ");
                                isError = workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", "", "", "", new E12GenericUtility().getValueFromXTRA_PARAMS(retString, "entityCode"), "E", resultXmlStr, this.conn);
                            }
                        }
                    }
                    if (!isError) {
                        if (this.isunsigned(refSer, refID, "" + lineNo, this.conn)) {
                            String updateStr = this.updateObjSignTrans(refSer, refID, lineNo, signRemarks, signStatus, this.conn, "");
                            if (updateStr != null && "true".equalsIgnoreCase(updateStr)) {
                                if ("1".equals(workflowOpt) && isAllSigned) {
                                    int minLineNo = lineNo;
                                    if (signStatus.equalsIgnoreCase("S")) {
                                        minLineNo = this.getMinLineNo(refSer, refID);
                                    }
                                    if (minLineNo > 0) {
                                        entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                        mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                        if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                            this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                        }
                                    }
                                }
                            } else {
                                isError = true;
                                genericutility.generateLog("Record Not Found For refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "]", "", String.valueOf(processId) + refID, false);
                            }
                        } else {
                            isError = true;
                            genericutility.generateLog("Sign Status of refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "] is U", "", String.valueOf(processId) + refID, false);
                            retString = "SignStatus is not U";
                        }
                    }
                }
                catch (Exception e) {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                if (!isError) {
                    retString = "Success";
                    try {
                        ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, "" + lineNo, this.conn);
                        String processInstanceId = (String)processInstanceInfo.get(0);
                        String chgTransInfoXml = this.getChangedDataString(transInfoXmlAfter, false);
                        String auditChangedXml = this.getChangedXmlString(objName, transInfoXmlBefore, chgTransInfoXml, transInfoXmlAfter, this.conn);
                        XML2DBEJB xml2dbejb = new XML2DBEJB();
                        if (refID == null || refID.trim().length() == 0) {
                            refID = "          ";
                        }
                        BaseLogger.log("3", this.userInfo, null, "\ntransInfoXmlBefore ::" + transInfoXmlBefore);
                        BaseLogger.log("3", this.userInfo, null, "\nchgTransInfoXml ::" + chgTransInfoXml);
                        BaseLogger.log("3", this.userInfo, null, "\ntransInfoXmlAfter ::" + transInfoXmlAfter);
                        boolean updateStatus = xml2dbejb.saveValuesInAudit(userId, refID, signStatus, objName, processInstanceId, transInfoXmlBefore, auditChangedXml, transInfoXmlAfter, xtraParams, this.conn, userInfoStr);
                        xml2dbejb = null;
                        BaseLogger.log("3", null, null, "updateStatus sign(10) from audit trail =[" + updateStatus + "], refID =[" + refID + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ITMException itme) {
                try {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(itme), "", String.valueOf(processId) + refID, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw itme;
            }
            catch (SQLException e) {
                try {
                    WorkflowLogger.info("Exception :SignManagerEJB :sign :==> \n" + e.getMessage());
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ITMException(e);
                }
            }
            catch (Exception e) {
                try {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rsLock != null) {
                    rsLock.close();
                    rsLock = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (pstmtLock != null) {
                    pstmtLock.close();
                    pstmtLock = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        WorkflowLogger.info("Connection commit succesfully");
                        this.conn.commit();
                    }
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Return String from update sign:" + retString + ":");
        return retString;
    }

    @Override
    public String sign(int lineNo, String refID, String refSer, String objName, String signStatus, String userId, String siteCode, String signRemarks, String chgString, String userInfoStr, String actionCode, String signBy, String signReason) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]Updating the current signature With single connection..................");
        this.actionCode = actionCode;
        this.objName = objName;
        this.signBy = signBy;
        String wsReturnValue = "";
        String retString = "";
        Statement pStmt = null;
        Object mQuery = null;
        Object sql = null;
        String processId = null;
        ResultSet rsLock = null;
        Statement pstmtLock = null;
        boolean isError = false;
        String formatCode = "";
        E12GenericUtility genericutility = new E12GenericUtility();
        String transInfoXmlBefore = "";
        String transInfoXmlAfter = "";
        try {
            try {
                this.userInfo = new UserInfoBean(userInfoStr);
                if (this.conn == null) {
                    this.conn = this.getConnection(this.userInfo.getTransDB());
                }
                this.conn.setAutoCommit(false);
                String workflowOpt = this.getWorkFlowOpt(objName, this.conn);
                String xtraParams = this.getXtraParams();
                String transInfo = "";
                if ((refSer == null || refSer.equalsIgnoreCase("null")) && objName != null && objName.length() > 0) {
                    refSer = this.getRefSerFromTransetup(objName, this.conn);
                }
                if (chgString != null && chgString.length() > 0) {
                    transInfoXmlAfter = transInfo = this.getChangedTransInfo(refSer, refID, "" + lineNo, chgString, this.conn);
                    transInfoXmlBefore = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                } else {
                    BaseLogger.log("3", null, null, "@@@@ calling getTransInfoXMLTypeStr in else");
                    transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, lineNo, this.conn) : this.getTransInfo(refSer, refID, lineNo, this.conn);
                    transInfoXmlBefore = transInfoXmlAfter = transInfo;
                }
                String retStr = this.updateTransInfo(objName, this.conn, refSer, refID, "" + lineNo, chgString, transInfo, false, signStatus);
                BaseLogger.log("3", null, null, "@@@@ retStr=== [" + retStr + "]");
                if (retStr != "" && !"success".equalsIgnoreCase(retStr)) {
                    retString = retStr;
                    isError = true;
                }
                try {
                    String mailFormatCode;
                    ArrayList entityInfo;
                    boolean isAllSigned = false;
                    if (!isError) {
                        if ("1".equals(workflowOpt)) {
                            boolean toMail = true;
                            if (signStatus.equalsIgnoreCase("R")) {
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                formatCode = "REJ_FORMAT_CODE";
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                            } else if (this.isAllSigned(refSer, refID, "" + lineNo, this.conn)) {
                                wsReturnValue = this.updateTransData(objName, refID, transInfo, userId, siteCode, null);
                                wsReturnValue = this.executeSystemEvent(objName, "pre_reject", null, transInfo, xtraParams);
                                if (wsReturnValue.indexOf("<Errors>") != -1) {
                                    isError = true;
                                }
                                if (!isError) {
                                    wsReturnValue = this.executeSystemEvent(objName, "pre_confirm", null, transInfo, xtraParams);
                                    WorkflowLogger.info("[SignManagerEJB] Return Value After pre_confirm [" + wsReturnValue + "]");
                                    if (wsReturnValue.indexOf("<Errors>") != -1) {
                                        isError = true;
                                    }
                                }
                                isAllSigned = true;
                                toMail = false;
                            }
                            if (wsReturnValue.indexOf("<Errors>") != -1) {
                                WorkflowLogger.info("[SignManagerEJB]Ws With Errors");
                                retString = wsReturnValue;
                                isError = true;
                            } else if (toMail) {
                                int minLineNo = lineNo;
                                if (signStatus.equalsIgnoreCase("S")) {
                                    minLineNo = this.getMinLineNo(refSer, refID, this.conn);
                                }
                                if (minLineNo > 0) {
                                    entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                    mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                    if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                        this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                    }
                                }
                            }
                        } else if ("2".equals(workflowOpt) || "3".equals(workflowOpt) || "4".equals(workflowOpt)) {
                            ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, "" + lineNo, this.conn);
                            String processInstanceId = (String)processInstanceInfo.get(0);
                            processId = (String)processInstanceInfo.get(1);
                            String instanceId = (String)processInstanceInfo.get(2);
                            if (processInstanceId != null && processInstanceId.length() > 0) {
                                WorkflowLogger.info("Updating WF_PRC_DATA ... ");
                                String chgTransInfo = this.getChangedDataString(transInfo, true);
                                chgTransInfo = "<Root>" + chgTransInfo + "</Root>";
                                WorkflowLogger.info("SignManagerEJB chgTransInfo [" + chgTransInfo + "]");
                                String query = "";
                                query = "mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? "SELECT ARGUMENT_VALUE FROM WF_PRC_DATA WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' " : "SELECT WPD.ARGUMENT_VALUE_XML.getClobval() FROM WF_PRC_DATA WPD WHERE PROCESS_ID=? AND INSTANCE_ID=? AND ARGUMENT_ID='$XML_DATA_ALL' ";
                                ArrayList<String> bindVarValues = new ArrayList<String>();
                                bindVarValues.add(processId.trim());
                                bindVarValues.add(instanceId.trim());
                                ArrayList<String> bindVarTypes = new ArrayList<String>();
                                bindVarTypes.add("String");
                                bindVarTypes.add("Int");
                                String wfData = "";
                                BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB sign10");
                                wfData = "mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, this.userInfo) : this.getXMLTypeStr(this.conn, query, bindVarValues, bindVarTypes);
                                transInfo = this.applyDataToXML(chgTransInfo, wfData);
                                WorkflowLogger.info(" CommonConstants.DB_NAME [" + CommonConstants.DB_NAME + "] ");
                                if ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) || "db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                                    WorkflowLogger.info("Using mssql with binary stream...");
                                    String prcDataInsQuery = "UPDATE WF_PRC_DATA  SET ARGUMENT_VALUE = ? WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = '$XML_DATA_ALL'";
                                    pStmt = this.conn.prepareStatement(prcDataInsQuery);
                                    byte[] encoded = transInfo.getBytes();
                                    ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(encoded);
                                    pStmt.setBinaryStream(1, byteArrayIn, byteArrayIn.available());
                                    pStmt.setString(2, processId);
                                    pStmt.setInt(3, Integer.parseInt(instanceId));
                                    pStmt.executeUpdate();
                                    pStmt.close();
                                    pStmt = null;
                                } else {
                                    query = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?)  WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                                    bindVarValues.clear();
                                    bindVarValues.add(processId.trim());
                                    bindVarValues.add(instanceId.trim());
                                    bindVarValues.add("$XML_DATA_ALL");
                                    bindVarTypes.clear();
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    bindVarTypes.add("String");
                                    boolean updateStatus = this.updateXMLTypeStr(this.conn, query, transInfo, bindVarValues, bindVarTypes);
                                    if (updateStatus) {
                                        isError = false;
                                    }
                                }
                                WorkflowProcessInstanceMonitorEJB workflowProcessInstanceMonitor = new WorkflowProcessInstanceMonitorEJB();
                                String resultXmlStr = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[" + signStatus + "]]></RESULT></ROOT>";
                                WorkflowLogger.info("Calling workflowProcessInstanceMonitor.updateActivityStatus with '2' from sign ");
                                isError = workflowProcessInstanceMonitor.updateActivityStatus(processInstanceId, "2", "", "", "", new E12GenericUtility().getValueFromXTRA_PARAMS(retString, "entityCode"), "E", resultXmlStr, this.conn);
                            }
                        }
                    }
                    BaseLogger.log("3", null, null, "@@@@ isError===" + isError);
                    if (!isError) {
                        if (this.isunsigned(refSer, refID, "" + lineNo, this.conn)) {
                            String updateStr = this.updateObjSignTrans(refSer, refID, lineNo, signRemarks, signStatus, this.conn, signReason);
                            BaseLogger.log("3", null, null, "@@@@ updateStr===" + updateStr);
                            if (updateStr != null && "true".equalsIgnoreCase(updateStr)) {
                                if ("1".equals(workflowOpt) && isAllSigned) {
                                    int minLineNo = lineNo;
                                    if (signStatus.equalsIgnoreCase("S")) {
                                        minLineNo = this.getMinLineNo(refSer, refID);
                                    }
                                    if (minLineNo > 0) {
                                        entityInfo = this.getEntityInfo(refSer, refID, minLineNo);
                                        mailFormatCode = this.getFormatCode(refSer, minLineNo, formatCode);
                                        if (mailFormatCode != null && mailFormatCode.length() > 0) {
                                            this.sendMail(transInfo, refSer, objName, refID, "" + minLineNo, mailFormatCode, (String)entityInfo.get(0), (String)entityInfo.get(1), this.conn);
                                        }
                                    }
                                }
                            } else {
                                isError = true;
                                genericutility.generateLog("Record Not Found For refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "]", "", String.valueOf(processId) + refID, false);
                                retString = updateStr;
                            }
                        } else {
                            isError = true;
                            genericutility.generateLog("Sign Status of refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "] is U", "", String.valueOf(processId) + refID, false);
                            retString = "SignStatus is not U";
                        }
                    }
                }
                catch (Exception e) {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                    e.printStackTrace();
                    BaseLogger.log("0", null, null, "exception==" + e.getMessage());
                    String tableName = "OBJ_SIGN_TRANS";
                    String columnName = "SIGN_STATUS";
                    StringBuilder condition = new StringBuilder();
                    condition.append(" WHERE REF_ID='").append(refID).append("' ");
                    condition.append("AND REF_SER='").append(refSer).append("' ");
                    condition.append("AND LINE_NO='").append(lineNo).append("' ");
                    ArrayList<String> statusList = this.getDBColumnValues(tableName, columnName, condition.toString(), this.userInfo.getTransDB());
                    if (statusList.size() >= 1) {
                        String wrkflwSignStatus = this.checkNull(statusList.get(0));
                        BaseLogger.log("3", null, null, " wrkflwSignStatus [" + wrkflwSignStatus + "]");
                        if ("S".equalsIgnoreCase(wrkflwSignStatus)) {
                            Exception ex = new Exception("Transaction is already approved for refId " + refID);
                            throw new ITMException(ex);
                        }
                        if ("R".equalsIgnoreCase(wrkflwSignStatus)) {
                            Exception ex = new Exception("Transaction is already rejected for refId " + refID);
                            throw new ITMException(ex);
                        }
                        throw new ITMException(e);
                    }
                    throw new ITMException(e);
                }
                BaseLogger.log("3", null, null, "isError at end==" + isError);
                if (!isError) {
                    retString = "Success";
                    try {
                        ArrayList processInstanceInfo = this.getProcessInstanceInfo(refSer, refID, "" + lineNo, this.conn);
                        String processInstanceId = (String)processInstanceInfo.get(0);
                        String chgTransInfoXml = this.getChangedDataString(transInfoXmlAfter, false);
                        String auditChangedXml = this.getChangedXmlString(objName, transInfoXmlBefore, chgTransInfoXml, transInfoXmlAfter, this.conn);
                        XML2DBEJB xml2dbejb = new XML2DBEJB();
                        if (refID == null || refID.trim().length() == 0) {
                            refID = "          ";
                        }
                        BaseLogger.log("3", null, null, "\ntransInfoXmlBefore ::" + transInfoXmlBefore);
                        BaseLogger.log("3", null, null, "\nchgTransInfoXml ::" + chgTransInfoXml);
                        BaseLogger.log("3", null, null, "\ntransInfoXmlAfter ::" + transInfoXmlAfter);
                        boolean updateStatus = xml2dbejb.saveValuesInAudit(userId, refID, signStatus, objName, processInstanceId, transInfoXmlBefore, auditChangedXml, transInfoXmlAfter, xtraParams, this.conn, userInfoStr);
                        xml2dbejb = null;
                        BaseLogger.log("3", null, null, "updateStatus sign(12) from audit trail =[" + updateStatus + "], refID =[" + refID + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                BaseLogger.log("3", null, null, "retString at end==" + retString);
            }
            catch (ITMException itme) {
                try {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(itme), "", String.valueOf(processId) + refID, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw itme;
            }
            catch (SQLException e) {
                try {
                    WorkflowLogger.info("Exception :SignManagerEJB :sign :==> \n" + e.getMessage());
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ITMException(e);
                }
            }
            catch (Exception e) {
                try {
                    isError = true;
                    genericutility.generateLog(genericutility.writePrintStacktrace(e), "", String.valueOf(processId) + refID, false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rsLock != null) {
                    rsLock.close();
                    rsLock = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (pstmtLock != null) {
                    pstmtLock.close();
                    pstmtLock = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        WorkflowLogger.info("Connection commit succesfully");
                        this.conn.commit();
                    }
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Return String from update sign:" + retString + ":");
        return retString;
    }

    private String executeSystemEvent(String objName, String eventCode, String chgStr, String transInfo, String xtraParams) throws ITMException {
        String wsReturnValue = "";
        try {
            Document transInfoDom = null;
            if (transInfo.length() > 0) {
                transInfoDom = new E12GenericUtility().parseString(transInfo);
            }
            EventManagerEJB eventManager = new EventManagerEJB();
            eventManager.setUserInfo(this.userInfo);
            wsReturnValue = chgStr != null && chgStr.length() > 0 ? eventManager.executeSystemEvent(objName, eventCode, null, chgStr, transInfo, xtraParams, "1") : eventManager.executeSystemEvent(objName, eventCode, null, transInfo, transInfo, xtraParams, "1");
            eventManager = null;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return wsReturnValue;
    }

    private String getChangedTransInfo(String refSer, String refID, String lineNo, String chgSignStr) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignTransEJB]Updating Trans Info  ..................");
        String transInfo = "";
        try {
            if (chgSignStr != null && chgSignStr.length() > 0) {
                transInfo = this.getTransInfo(refSer, refID, Integer.parseInt(lineNo.trim()));
                transInfo = this.applyDataToXML(chgSignStr, transInfo);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getChangedTransInfo(String refSer, String refID, String lineNo, String chgSignStr, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignTransEJB]Updating Trans Info  With Connection..................");
        String transInfo = "";
        try {
            if (chgSignStr != null && chgSignStr.length() > 0) {
                BaseLogger.log("3", null, null, "@@@@ calling getTransInfoXMLTypeStr in getChangedTransInfo");
                transInfo = "oracle".equalsIgnoreCase(CommonConstants.DB_NAME) ? this.getTransInfoXMLTypeStr(refSer, refID, Integer.parseInt(lineNo.trim()), con) : this.getTransInfo(refSer, refID, Integer.parseInt(lineNo.trim()), con);
                transInfo = this.applyDataToXML(chgSignStr, transInfo);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("3", null, null, "transInfo :: [" + transInfo + "]");
        return transInfo;
    }

    private ArrayList getSignObjList(String objName) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Creating possible(OBJ_SIGN) sign objects for objName :" + objName);
        ArrayList signList = null;
        Statement pStmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            try {
                String refSer = this.getRefSer(this.conn, objName);
                WorkflowLogger.info("[SignManagerEJB]Ref Series :" + refSer + ":");
                if (signMap.containsKey(refSer)) {
                    signList = (ArrayList)signMap.get(refSer);
                } else if (refSer != null && refSer.length() > 0) {
                    String qry = "SELECT REF_SER, LINE_NO, CONDN_EXPR, ROLE_CODE__SIGN, SIGN_FOR, VAR_NAMES, APPR_FORMAT_CODE, REJ_FORMAT_CODE, COMM_MODE, MSG_FRM_FNAME, ROLE_EXPR, ROLE_EXPR_TYPE FROM OBJ_SIGN WHERE REF_SER = ? ORDER BY LINE_NO";
                    pStmt = this.conn.prepareStatement(qry);
                    pStmt.setString(1, refSer.trim());
                    rs = pStmt.executeQuery();
                    rsmd = rs.getMetaData();
                    int noOfCols = rsmd.getColumnCount();
                    boolean flag = false;
                    while (rs.next()) {
                        signList = signList == null ? new ArrayList() : signList;
                        Sign signObj = new Sign();
                        int i = 1;
                        while (i <= noOfCols) {
                            signObj.setObjName(objName);
                            signObj.setRefSer(rs.getString("REF_SER"));
                            signObj.setLineNo(rs.getInt("LINE_NO"));
                            signObj.setCondnExpr(rs.getString("CONDN_EXPR"));
                            signObj.setRoleCodeSign(rs.getString("ROLE_CODE__SIGN"));
                            signObj.setSignFor(rs.getString("SIGN_FOR"));
                            signObj.setVarNames(rs.getString("VAR_NAMES"));
                            signObj.setApprFormatCode(rs.getString("APPR_FORMAT_CODE"));
                            signObj.setRejFormatCode(rs.getString("REJ_FORMAT_CODE"));
                            signObj.setCommMode(rs.getString("COMM_MODE"));
                            signObj.setSignMsgFormatFile(rs.getString("MSG_FRM_FNAME"));
                            signObj.setRoleExpr(rs.getString("ROLE_EXPR"));
                            signObj.setRoleExprType(rs.getString("ROLE_EXPR_TYPE"));
                            ++i;
                        }
                        signList.add(signObj);
                    }
                    rs.close();
                    rs = null;
                    pStmt.close();
                    pStmt = null;
                    signMap.put(refSer, signList);
                }
                WorkflowLogger.info("[SignManagerEJB]Sign objects list size :" + (signList != null ? "" + signList.size() : "null"));
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSignObjList :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSignObjList :==>\n" + e);
                throw new ITMException(e);
            }
        }
        return signList;
    }

    private ArrayList getSignDetailList(String signXMLString) throws ITMException {
        ArrayList<String> signDetailList = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String signXML = genericUtility.getNormalizeString(signXMLString);
            Document signDataDom = genericUtility.parseString(signXML);
            signDetailList = new ArrayList<String>();
            NodeList detailNodeList = signDataDom.getElementsByTagName("Detail");
            Node detailNode = detailNodeList.item(0);
            NodeList detailChildList = detailNode.getChildNodes();
            int dCtr = 0;
            while (dCtr < detailChildList.getLength()) {
                Node currChild = detailChildList.item(dCtr);
                if (!currChild.getNodeName().equalsIgnoreCase("attribute")) {
                    if (currChild.getFirstChild() != null) {
                        signDetailList.add(currChild.getFirstChild().getNodeValue());
                    } else {
                        signDetailList.add("");
                    }
                }
                ++dCtr;
            }
        }
        catch (ITMException itme) {
            WorkflowLogger.info("ITMException :SignManagerEJB :getSignDetailList :==>\n");
            throw itme;
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getSignDetailList :==>\n");
            e.printStackTrace();
            throw new ITMException(e);
        }
        WorkflowLogger.info("signDetailList :" + signDetailList);
        return signDetailList;
    }

    private String getFormatCode(String refSer, int lineNo, String formatFieldName) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Getting Format Code for refSer :" + refSer + " and linNo :" + lineNo + ":");
        Statement pStmt = null;
        ResultSet rs = null;
        String formatCode = "";
        try {
            try {
                String selectQuery = "SELECT " + formatFieldName + " FROM OBJ_SIGN WHERE REF_SER = ? AND LINE_NO = ?";
                pStmt = this.conn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setInt(2, lineNo);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    formatCode = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getFormatCode :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getFormatCode :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return formatCode;
    }

    private String getTransInfo(String refSer, String refID, int lineNo) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            String query = "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add(refID);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB getTransInfo3");
            transInfo = this.userInfo != null ? this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, this.userInfo) : this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfo(String refSer, String refID, int lineNo, String addWhereClauseBuff) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            String query = "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE " + addWhereClauseBuff;
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB getTransInfo3");
            transInfo = this.userInfo != null ? this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, this.userInfo) : this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfo(String refSer, String refID, int lineNo, Connection con) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            WorkflowLogger.info("getTransInfo in Connection [" + con + "]");
            String query = "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add(refID);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            BaseLogger.log("3", null, null, "Getting BLOB from SignManagerEJB getTransInfo4");
            transInfo = this.getBlob(con, query, bindVarValues, bindVarTypes);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfoXMLTypeStr(String refSer, String refID, int lineNo) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            String query = "SELECT OST.TRANS_INFO_XML.getClobval() FROM OBJ_SIGN_TRANS OST WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add(refID);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            transInfo = this.getDBAccessObj().getXMLTypeStr(query, bindVarValues, bindVarTypes);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfoXMLTypeStr(String refSer, String refID, int lineNo, String addWhereClauseBuff) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            String query = "SELECT OST.TRANS_INFO_XML.getClobval() FROM OBJ_SIGN_TRANS OST WHERE " + addWhereClauseBuff;
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            transInfo = this.getDBAccessObj().getXMLTypeStr(query, bindVarValues, bindVarTypes);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfoXMLTypeStr(String refSer, String refID, int lineNo, Connection con) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            WorkflowLogger.info("getTransInfoXMLTypeStr in Connection [" + con + "]");
            String query = "SELECT OST.TRANS_INFO_XML.getClobval() FROM OBJ_SIGN_TRANS OST WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add(refID);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            transInfo = this.getXMLTypeStr(con, query, bindVarValues, bindVarTypes);
            BaseLogger.log("3", null, null, "@@@@ transInfo from getXMLTypeStr :" + transInfo);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfoXMLTypeStr :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    @Override
    public String getPrevSignRemarks(String refSer, String refID) throws RemoteException, ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        Statement pStmt = null;
        ResultSet rs = null;
        StringBuffer retStringBuff = new StringBuffer("<WRKFLW_REMARKS>");
        boolean isConnLocal = false;
        try {
            try {
                BaseLogger.log("3", null, null, "getPrevSignRemarks B4");
                String query = "SELECT LINE_NO, USER_ID__SIGN, SIGN_DATE, SIGN_REMARKS, SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? ORDER BY LINE_NO ";
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                pStmt = this.conn.prepareStatement(query);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    String lineNoStr = "<REMARK_INFO line_no = '" + rs.getInt("LINE_NO") + "'>";
                    String signRemarks = this.checkNull(rs.getString("SIGN_REMARKS"));
                    String userIdSign = this.checkNull(rs.getString("USER_ID__SIGN"));
                    String date = "";
                    if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        if (rs.getTimestamp("SIGN_DATE") != null) {
                            date = genericUtility.getValidDateTimeString(rs.getTimestamp("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                        }
                    } else if (rs.getDate("SIGN_DATE") != null) {
                        date = genericUtility.getValidDateString(rs.getDate("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                    }
                    String remark = "<REMARK><![CDATA[" + signRemarks + "]]></REMARK>";
                    String signBy = "<SIGNBY><![CDATA[" + userIdSign + "]]></SIGNBY>";
                    String signDate = "<SIGNDATE><![CDATA[" + date + "]]></SIGNDATE>";
                    retStringBuff.append(lineNoStr).append(remark).append(signBy).append(signDate).append("</REMARK_INFO>");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                retStringBuff.append("</WRKFLW_REMARKS>");
                WorkflowLogger.info("[SignManagerEJB] getPrevSignRemarks previous remarks [" + retStringBuff.toString() + "] ");
                BaseLogger.log("3", null, null, "getPrevSignRemarks After");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getPrevSignRemarks :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null && isConnLocal) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getLastSignRemarks :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retStringBuff.toString();
    }

    @Override
    public String getSignRemarks(String refSer, String refID) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        StringBuffer browXmlDataBuff = new StringBuffer("<Header>");
        boolean isConnLocal = false;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String query = "SELECT LINE_NO, SIGN_FOR, ROLE_CODE__SIGN, SIGN_DATE, SIGN_STATUS, SIGN_REMARKS, ROLE_TYPE, USER_ID__SIGN, USER_INPUT FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? ORDER BY LINE_NO ";
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                pStmt = this.conn.prepareStatement(query);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                rs = pStmt.executeQuery();
                int domID = 0;
                while (rs.next()) {
                    browXmlDataBuff.append("<Detail domID=\"" + ++domID + "\" >");
                    browXmlDataBuff.append("<Seqno>").append(rs.getInt("LINE_NO")).append("</Seqno>");
                    browXmlDataBuff.append("<Signfor>").append(rs.getString("SIGN_FOR")).append("</Signfor>");
                    browXmlDataBuff.append("<Rolecode>").append(rs.getString("ROLE_CODE__SIGN")).append("</Rolecode>");
                    String data = "";
                    if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        if (rs.getTimestamp("SIGN_DATE") != null) {
                            data = genericUtility.getValidDateTimeString(rs.getTimestamp("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                        }
                    } else if (rs.getDate("SIGN_DATE") != null) {
                        data = genericUtility.getValidDateString(rs.getDate("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                    }
                    browXmlDataBuff.append("<Signdate>").append(data).append("</Signdate>");
                    browXmlDataBuff.append("<Signstatus>").append(rs.getString("SIGN_STATUS")).append("</Signstatus>");
                    browXmlDataBuff.append("<Signremarks>").append(this.checkNull(rs.getString("SIGN_REMARKS"))).append("</Signremarks>");
                    browXmlDataBuff.append("<Roletype>").append(rs.getString("ROLE_TYPE")).append("</Roletype>");
                    this.userIDSign = rs.getString("USER_ID__SIGN");
                    if (this.userIDSign != null && this.userIDSign.trim().length() > 0) {
                        String userName = this.getUserName(this.userIDSign);
                        BaseLogger.log("3", null, null, "getuserName>>>>>>>>>>>>" + userName + "[" + this.userIDSign + "]");
                        this.userIDSign = String.valueOf(userName) + "[" + this.userIDSign + "]";
                    }
                    browXmlDataBuff.append("<Useridsign>").append(this.userIDSign).append("</Useridsign>");
                    browXmlDataBuff.append("<Userinput>").append(rs.getString("USER_INPUT")).append("</Userinput>");
                    browXmlDataBuff.append("</Detail>");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                browXmlDataBuff.append("</Header>");
                WorkflowLogger.info("[SignManagerEJB] getSignRemarks remarks [" + browXmlDataBuff.toString() + "] ");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSignRemarks :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null && isConnLocal) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getLastSignRemarks :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return browXmlDataBuff.toString();
    }

    private boolean isAllSigned(String refSer, String refID, String lineNo) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Checking whether all signatures are signed for refSer :" + refSer + " and refID :" + refID + ":");
        Statement pStmt = null;
        ResultSet rs = null;
        boolean flag = false;
        try {
            try {
                String mQuery = "SELECT COUNT(1) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' AND LINE_NO != ?";
                pStmt = this.conn.prepareStatement(mQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, Integer.parseInt(lineNo.trim()));
                rs = pStmt.executeQuery();
                int noOfUnsignedSignObjs = -1;
                if (rs.next()) {
                    noOfUnsignedSignObjs = rs.getInt(1);
                }
                rs.close();
                rs = null;
                if (noOfUnsignedSignObjs == 0) {
                    flag = true;
                }
                WorkflowLogger.info("[SignManagerEJB]No Of Unsigned Sign Objects :" + noOfUnsignedSignObjs + ":");
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :==>While cleaning db resources\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return flag;
    }

    private boolean isAllSigned(String refSer, String refID, String lineNo, Connection conn) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Checking whether all signatures are signed for refSer :" + refSer + " and refID :" + refID + ":");
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean flag = false;
        try {
            try {
                String mQuery = "SELECT COUNT(1) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' AND LINE_NO != ?";
                pStmt = conn.prepareStatement(mQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, Integer.parseInt(lineNo));
                rs = pStmt.executeQuery();
                int noOfUnsignedSignObjs = -1;
                if (rs.next()) {
                    noOfUnsignedSignObjs = rs.getInt(1);
                }
                rs.close();
                rs = null;
                if (noOfUnsignedSignObjs == 0) {
                    flag = true;
                }
                WorkflowLogger.info("[SignManagerEJB]No Of Unsigned Sign Objects :" + noOfUnsignedSignObjs + ":");
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :==>While cleaning db resources\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return flag;
    }

    private boolean isunsigned(String refSer, String refID, String lineNo, Connection conn) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Checking whether all signatures are signed for refSer :" + refSer + " and refID :" + refID + ":");
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean flag = false;
        try {
            try {
                String mQuery = "SELECT COUNT(1) FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' AND LINE_NO = ?";
                pStmt = conn.prepareStatement(mQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, Integer.parseInt(lineNo));
                rs = pStmt.executeQuery();
                int noOfUnsignedSignObjs = -1;
                if (rs.next()) {
                    noOfUnsignedSignObjs = rs.getInt(1);
                    flag = true;
                }
                rs.close();
                rs = null;
                if (noOfUnsignedSignObjs == 0) {
                    flag = false;
                }
                WorkflowLogger.info("[SignManagerEJB]No Of Unsigned Sign Objects :" + noOfUnsignedSignObjs + ":");
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :isAllSigned :==>While cleaning db resources\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return flag;
    }

    private String getXtraParams() {
        String XTRA_PARAMS = null;
        if (this.userInfo != null) {
            BaseLogger.log("3", null, null, "this.signBy===" + this.signBy);
            XTRA_PARAMS = "loginCode=" + this.userInfo.getLoginCode() + "~~" + "loginEmpCode=" + this.userInfo.getEmpCode() + "~~" + "loginSiteCode=" + this.userInfo.getSiteCode() + "~~" + "entityCode=" + this.userInfo.getEntityCode() + "~~" + "profileId=" + this.userInfo.getProfileId() + "~~" + "userType=" + this.userInfo.getUserType() + "~~" + "runMode=I" + "~~" + "actionCode=" + this.actionCode + "~~" + "objName=" + this.objName + "~~" + "signBy=" + this.signBy + "~~" + "chgTerm=" + this.userInfo.getRemoteHost() + "~~" + "site_code=" + this.userInfo.getSiteCode();
        }
        WorkflowLogger.info("[SignManagerEJB]XTRA_PARAMS :" + XTRA_PARAMS + ":");
        return XTRA_PARAMS;
    }

    private Object getSQLResult(String condnSQLExpr, Document dom, String currFieldType) throws ITMException {
        Object fieldValue = null;
        Statement condnExprStmt = null;
        try {
            try {
                boolean bindCtr = true;
                int indexOfBindVar = condnSQLExpr.indexOf(":");
                WorkflowLogger.info("condnSQLExpr :[" + condnSQLExpr + "]");
                WorkflowLogger.info("currFieldType :[" + currFieldType + "]");
                StringBuffer condnSQLExprBuff = new StringBuffer(condnSQLExpr);
                ArrayList<Object> bindVarValueList = new ArrayList<Object>();
                while ((indexOfBindVar = condnSQLExpr.indexOf(":")) != -1) {
                    int spaceIndex = condnSQLExpr.indexOf(32, indexOfBindVar);
                    String bindVariable = condnSQLExpr.substring(indexOfBindVar + 1, spaceIndex);
                    WorkflowLogger.info("bindVariable :[" + bindVariable + "]");
                    Object currValue = this.getValueOfField(dom, bindVariable, "String");
                    WorkflowLogger.info("bindValue :[" + currValue + "]");
                    condnSQLExprBuff.replace(indexOfBindVar, spaceIndex, "'" + currValue + "'");
                    bindVarValueList.add(currValue);
                    condnSQLExpr = condnSQLExprBuff.toString();
                }
                WorkflowLogger.info("Final Query to be executed :[" + condnSQLExpr + "]");
                condnExprStmt = this.conn.prepareStatement(condnSQLExpr);
                ResultSet roleExprRS = condnExprStmt.executeQuery();
                String currFieldValue = null;
                if (roleExprRS.next()) {
                    currFieldValue = roleExprRS.getString(1);
                }
                roleExprRS.close();
                roleExprRS = null;
                condnExprStmt.close();
                condnExprStmt = null;
                if (currFieldValue != null) {
                    fieldValue = currFieldType.equalsIgnoreCase("I") ? Integer.valueOf(currFieldValue.toString()) : (currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") ? Double.valueOf(currFieldValue.toString()) : currFieldValue.trim());
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (condnExprStmt != null) {
                    condnExprStmt.close();
                    condnExprStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSQLResult :==>\n" + e);
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("Returning result of SQL expr :[" + fieldValue + "]");
        return fieldValue;
    }

    private String applyDataToXML(String chgString, String dataString) throws ITMException {
        Document chgDataDom = null;
        Document dataDom = null;
        StringBuffer changedTransInfoBfr = new StringBuffer();
        E12GenericUtility genericUtility = null;
        try {
            genericUtility = new E12GenericUtility();
            WorkflowLogger.info("Applying Data XML....");
            chgDataDom = genericUtility.parseString(chgString);
            dataDom = genericUtility.parseString(dataString);
            HashMap nameValueMap = this.getColNameValueMap(chgDataDom);
            NodeList headerNodeList = null;
            if (nameValueMap.size() > 0) {
                if (dataString != null && dataString.length() > 0 && dataString.indexOf("<DocumentRoot>") != -1) {
                    headerNodeList = dataDom.getElementsByTagName("Header0");
                    BaseLogger.log("3", null, null, "DocumentRoot ** =[" + headerNodeList + "]");
                } else if (dataString != null && dataString.length() > 0 && dataString.indexOf("<Root>") != -1) {
                    headerNodeList = dataDom.getElementsByTagName("Root");
                    BaseLogger.log("3", null, null, "Root ** =[" + headerNodeList + "]");
                }
                Node headerNode = headerNodeList.item(0);
                if (headerNode != null) {
                    NodeList headerChlidList = headerNode.getChildNodes();
                    int noOfHeaderChlid = headerChlidList.getLength();
                    int recCtr = 0;
                    while (recCtr < noOfHeaderChlid) {
                        Node headerChlidNode = headerChlidList.item(recCtr);
                        String headerChlidName = headerChlidNode.getNodeName();
                        if (headerChlidName.startsWith("Detail")) {
                            String dbIdStr = headerChlidNode.getAttributes().getNamedItem("dbID").getNodeValue();
                            NodeList colNodeList = headerChlidNode.getChildNodes();
                            int noOfColNodes = colNodeList.getLength();
                            boolean isChgMarkOnDet = false;
                            int colCtr = 0;
                            while (colCtr < noOfColNodes) {
                                Node currColNode = colNodeList.item(colCtr);
                                String colName = currColNode.getNodeName();
                                WorkflowLogger.info("**** headerChlidName colName ****" + colName);
                                if (!colName.equals("attribute")) {
                                    if (dbIdStr.indexOf(":") != -1 && !"Detail1".equals(headerChlidName)) {
                                        dbIdStr = dbIdStr.substring(dbIdStr.lastIndexOf(":") + 1).trim();
                                    } else if (dbIdStr.indexOf(":") != -1 && "Detail1".equals(headerChlidName)) {
                                        dbIdStr = "1";
                                    }
                                    String key = String.valueOf(headerChlidName) + "." + dbIdStr.trim() + "." + colName;
                                    WorkflowLogger.info("**** Key ****[" + key + "]");
                                    WorkflowLogger.info("nameValueMap.containsKey(" + key + ") : [" + nameValueMap.containsKey(key) + "]");
                                    if (nameValueMap.containsKey(key)) {
                                        Node colValueNode;
                                        ((Element)currColNode).setAttribute("isChg", "1");
                                        if (!isChgMarkOnDet) {
                                            ((Element)headerChlidNode).setAttribute("isChg", "1");
                                            isChgMarkOnDet = true;
                                        }
                                        if ((colValueNode = currColNode.getFirstChild()) != null) {
                                            if (colValueNode.getNodeValue() != null) {
                                                colValueNode.setNodeValue((String)nameValueMap.get(key));
                                            } else {
                                                Document newNode = genericUtility.parseString((String)nameValueMap.get(key));
                                                Node newNodeValue = newNode.getFirstChild();
                                                currColNode.replaceChild(currColNode.getOwnerDocument().importNode(newNodeValue.getFirstChild(), true), currColNode.getFirstChild());
                                            }
                                        } else {
                                            CDATASection cDataSection = dataDom.createCDATASection((String)nameValueMap.get(key));
                                            currColNode.appendChild(cDataSection);
                                        }
                                    }
                                }
                                ++colCtr;
                            }
                        }
                        ++recCtr;
                    }
                }
            }
        }
        catch (ITMException be) {
            throw be;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return genericUtility.serializeDom(dataDom, true);
    }

    private HashMap getColNameValueMap(Document clientDetailDom) {
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        try {
            NodeList rootNodeList = clientDetailDom.getElementsByTagName("Root");
            if (rootNodeList.item(0) != null) {
                NodeList chgDetailList = rootNodeList.item(0).getChildNodes();
                int chgDetailLen = chgDetailList.getLength();
                int ctr = 0;
                while (ctr < chgDetailLen) {
                    Node currDetailNode = chgDetailList.item(ctr);
                    String currTagName = currDetailNode.getNodeName();
                    String currDetailNodeName = currDetailNode.getNodeName();
                    if (currDetailNodeName.startsWith("Detail")) {
                        if (currDetailNode.getFirstChild() != null) {
                            if (currDetailNode.getFirstChild().getNodeValue() != null) {
                                nameValueMap.put(currTagName, currDetailNode.getFirstChild().getNodeValue());
                            } else {
                                E12GenericUtility genericUtility = new E12GenericUtility();
                                nameValueMap.put(currTagName, genericUtility.serializeDom(currDetailNode.getFirstChild()));
                            }
                        } else {
                            nameValueMap.put(currTagName, new String(""));
                        }
                    }
                    ++ctr;
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info(e);
        }
        WorkflowLogger.info("nameValueMap [" + nameValueMap + "]");
        return nameValueMap;
    }

    private Object getValueOfField(Document dom, String currFieldName, String currFieldType) throws ITMException {
        Object fieldValue = null;
        Node currField = null;
        try {
            String currFieldValue = null;
            if (currFieldName.indexOf(".") != -1) {
                String detailName = currFieldName.substring(0, currFieldName.indexOf("."));
                String fieldName = currFieldName.substring(currFieldName.indexOf(".") + 1);
                WorkflowLogger.info("[SignManagerEJB]Getting field value of " + fieldName + " of " + detailName + " tag .......");
                NodeList detailNodeList = dom.getElementsByTagName(detailName).item(0).getChildNodes();
                int ctr = 0;
                while (ctr < detailNodeList.getLength()) {
                    Node currChild = detailNodeList.item(ctr);
                    if (currChild.getNodeName().equalsIgnoreCase(fieldName) && currChild.getFirstChild() != null) {
                        currField = currChild;
                    }
                    ++ctr;
                }
            } else {
                currField = dom.getElementsByTagName(currFieldName).item(0);
            }
            if (currField != null) {
                if (currField.getFirstChild() != null) {
                    currFieldValue = currField.getFirstChild().getNodeValue();
                }
                if (currFieldValue != null) {
                    fieldValue = currFieldType.equalsIgnoreCase("I") ? Integer.valueOf(currFieldValue.toString()) : (currFieldType.equalsIgnoreCase("Number") || currFieldType.equalsIgnoreCase("N") || currFieldType.equalsIgnoreCase("D") ? Double.valueOf(currFieldValue.toString()) : currFieldValue.trim());
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getValueOfField() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return fieldValue;
    }

    @Override
    public String getXSLString(String refSer, String refId, int lineNo, String roleCode, Connection con) throws RemoteException, ITMException {
        String xslString = null;
        try {
            String xslFileName = this.getUserXSLFileName(refSer, refId, lineNo, roleCode, con);
            if (xslFileName != null && xslFileName.length() > 0) {
                xslString = new E12GenericUtility().readFile(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl" + File.separator + xslFileName + ".xsl");
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getXSLString :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return xslString;
    }

    private String getValueOfField(Document dom, String fieldName) throws ITMException {
        String fieldValue = "";
        try {
            Node currField = dom.getElementsByTagName(fieldName).item(0);
            if (currField != null && currField.getFirstChild() != null) {
                fieldValue = currField.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManager :getValueOfField() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        if (fieldValue == null || "null".equals(fieldValue)) {
            fieldValue = "";
        }
        return fieldValue;
    }

    private int getMinLineNo(String refSer, String refID) throws ITMException {
        WorkflowLogger.info("SignManagerEJB :Getting minimum line no of unsigned signature objects corr. to refSer :" + refSer + " and refID :" + refID + ":");
        Statement pStmt = null;
        ResultSet rs = null;
        int lineNo = -1;
        try {
            try {
                String selectQuery = "SELECT MIN(LINE_NO) AS LINE_NO FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' ";
                pStmt = this.conn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    lineNo = rs.getInt("LINE_NO");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getMinLineNo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getMinLineNo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("Returning lineNo [" + lineNo + "]");
        return lineNo;
    }

    private int getMinLineNo(String refSer, String refID, Connection conn) throws ITMException {
        WorkflowLogger.info("SignManagerEJB :Getting minimum line no of unsigned signature objects corr. to refSer :" + refSer + " and refID :" + refID + ":");
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int lineNo = -1;
        try {
            try {
                String selectQuery = "SELECT MIN(LINE_NO) AS LINE_NO FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND SIGN_STATUS = 'U' ";
                pStmt = conn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    lineNo = rs.getInt("LINE_NO");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getMinLineNo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getMinLineNo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("Returning lineNo [" + lineNo + "]");
        return lineNo;
    }

    private ArrayList getEntityInfo(String refSer, String refID, int lineNo) throws ITMException {
        WorkflowLogger.info("SignManagerEJB :Getting minimum line no of unsigned signature objects corr. to refSer :" + refSer + " and refID :" + refID + ":");
        Statement pStmt = null;
        ResultSet rs = null;
        ArrayList<String> mailInfo = new ArrayList<String>();
        try {
            try {
                String selectQuery = "SELECT ROLE_ENTITY, ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? ";
                pStmt = this.conn.prepareStatement(selectQuery);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, lineNo);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    mailInfo.add(rs.getString("ROLE_ENTITY"));
                    mailInfo.add(rs.getString("ENTITY_CODE"));
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getEntityInfo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getEntityInfo :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return mailInfo;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException be) {
            throw be;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return ctx;
    }

    private Connection getConnection() throws ITMException {
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            String transDB = "";
            if (this.userInfo != null) {
                transDB = this.userInfo.getTransDB();
            }
            con = connDriver.getConnectDB(transDB);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return con;
    }

    private Connection getConnection(String transDB) throws ITMException {
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            con = connDriver.getConnectDB(transDB);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return con;
    }

    private DBAccessLocal getDBAccessObj() throws ITMException {
        DBAccessEJB dbAccessEJB = null;
        try {
            dbAccessEJB = new DBAccessEJB();
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getDBAccessObj() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return dbAccessEJB;
    }

    private ArrayList getProcessInstanceInfo(String refSer, String refId, String lineNo) throws ITMException {
        Connection mConnection = null;
        Statement pStmt = null;
        ResultSet rs = null;
        ArrayList<String> processInstList = new ArrayList<String>();
        try {
            try {
                String processInstanceId = null;
                String prcIdSelQry = "SELECT PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
                mConnection = this.getConnection();
                WorkflowLogger.info("Executing Process Id Select Query :[" + prcIdSelQry + "] refSer [" + refSer + "] refId [" + refId + "] lineNo [" + lineNo + "]");
                pStmt = mConnection.prepareStatement(prcIdSelQry);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refId);
                pStmt.setInt(3, Integer.parseInt(lineNo.trim()));
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    processInstanceId = rs.getString("PRC_INST__WF");
                }
                if (processInstanceId == null || processInstanceId.length() <= 0) {
                    throw new Exception("No Process Instance Id found for current Activity");
                }
                processInstList.add(processInstanceId);
                processInstList.add(WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId));
                processInstList.add(WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId));
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                WorkflowLogger.info("Setting processInstanceId [" + processInstanceId + "] processId [" + WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId) + "] instanceId [" + WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId) + "]");
            }
            catch (ITMException be) {
                throw be;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignTransEJB :getUserXSLFileName :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return processInstList;
    }

    @Override
    public String updateTransData(String objName, String refId, String transInfo, String userId, String siteCode, String processInstanceId) throws RemoteException, ITMException {
        String retString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                String changedDataString = this.getChangedDataString(transInfo, false);
                if (changedDataString != null && changedDataString.length() > 0) {
                    StringBuffer dataBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><Root>");
                    dataBuff.append("<Header0>");
                    dataBuff.append("<objName><![CDATA[" + objName + "]]></objName>");
                    dataBuff.append("<pageContext><![CDATA[2]]></pageContext>");
                    dataBuff.append("<editFlag><![CDATA[E]]></editFlag>");
                    dataBuff.append("<focusedColumn><![CDATA[]]></focusedColumn>");
                    dataBuff.append("<action><![CDATA[EDIT]]></action>");
                    dataBuff.append("<elementName><![CDATA[]]></elementName>");
                    dataBuff.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
                    dataBuff.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
                    dataBuff.append("<objContext><![CDATA[1]]></objContext>");
                    dataBuff.append("<objContext><![CDATA[1]]></objContext>");
                    dataBuff.append("<forcedSave><![CDATA[true]]></forcedSave>");
                    dataBuff.append("<keyValue><![CDATA[]]></keyValue>");
                    dataBuff.append("<pkValues><![CDATA[" + refId + "]]></pkValues>");
                    dataBuff.append("<saveLevel><![CDATA[1]]></saveLevel>");
                    if (processInstanceId != null && processInstanceId.length() > 0) {
                        dataBuff.append("<wrkflwProcInstId><![CDATA[" + processInstanceId + "]]></wrkflwProcInstId>");
                    }
                    dataBuff.append("</Header0>");
                    dataBuff.append(changedDataString);
                    dataBuff.append("</Root>");
                    AppConnectParm appConnect = new AppConnectParm();
                    InitialContext ctx = new InitialContext(appConnect.getProperty());
                    masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
                    retString = masterStateful.processRequest(new String[]{userId, ""}, siteCode, true, dataBuff.toString(), false, null);
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (masterStateful != null) {
                    masterStateful.remove();
                    masterStateful = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :updateBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private boolean updateXMLTypeStr(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "@@@@ inside ibase.wrkflw.SignManagerEJB updateXMLType");
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        Statement pStmt = null;
        Object oConnection = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                dataStr = genericUtility.remAllXmlDec(dataStr);
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                }
                pStmt = con.prepareStatement(query);
                CLOB dataStrXml = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                dataStrXml.putString(1L, dataStr);
                pStmt.setClob(1, (Clob)dataStrXml);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 2, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 2, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                int updateCnt = pStmt.executeUpdate();
                BaseLogger.log("3", null, null, "@@@@ updateCnt in updateXMLType" + updateCnt);
                if (updateCnt > 0) {
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :updateXMLType :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private String getChangedDataString(String transInfo, boolean forMap) throws ITMException {
        StringBuffer changedBuffer = new StringBuffer();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            String headerChlidName;
            Node detailNode;
            int recCtr;
            int noOfHeaderChlid;
            NodeList headerChlidList;
            Document transInfoDom = genericUtility.parseString(transInfo);
            NodeList headerNodeList = transInfoDom.getElementsByTagName("Header0");
            Node headerNode = headerNodeList.item(0);
            boolean isDetailNodePresent = false;
            if (headerNode != null) {
                headerChlidList = headerNode.getChildNodes();
                noOfHeaderChlid = headerChlidList.getLength();
                recCtr = 0;
                while (recCtr < noOfHeaderChlid) {
                    detailNode = headerChlidList.item(recCtr);
                    headerChlidName = detailNode.getNodeName();
                    if (headerChlidName.startsWith("Detail")) {
                        isDetailNodePresent = true;
                        break;
                    }
                    ++recCtr;
                }
            }
            BaseLogger.log("3", null, null, "isDetailNodePresent :: [" + isDetailNodePresent + "]");
            if (!isDetailNodePresent) {
                headerNodeList = transInfoDom.getElementsByTagName("Root");
                headerNode = headerNodeList.item(0);
            }
            if (headerNode != null) {
                headerChlidList = headerNode.getChildNodes();
                noOfHeaderChlid = headerChlidList.getLength();
                recCtr = 0;
                while (recCtr < noOfHeaderChlid) {
                    detailNode = headerChlidList.item(recCtr);
                    headerChlidName = detailNode.getNodeName();
                    if (headerChlidName.startsWith("Detail")) {
                        String recChg;
                        NamedNodeMap detAttrNodesMap = detailNode.getAttributes();
                        String string = recChg = detAttrNodesMap.getNamedItem("isChg") != null ? detAttrNodesMap.getNamedItem("isChg").getNodeValue() : null;
                        if (recChg != null && recChg.equals("1")) {
                            String objCtx;
                            String domId = detAttrNodesMap.getNamedItem("domID") != null ? detAttrNodesMap.getNamedItem("domID").getNodeValue() : "";
                            String dbId = detAttrNodesMap.getNamedItem("dbID") != null ? detAttrNodesMap.getNamedItem("dbID").getNodeValue() : "";
                            String string2 = objCtx = detAttrNodesMap.getNamedItem("objContext") != null ? detAttrNodesMap.getNamedItem("objContext").getNodeValue() : "";
                            if (!forMap) {
                                changedBuffer.append("<Detail").append(objCtx).append(" domID='" + domId + "'").append(" objContext='" + objCtx + "'").append(" dbID='" + dbId + "' >");
                            }
                            NodeList detailChlidList = detailNode.getChildNodes();
                            int noOfDeatilChlid = detailChlidList.getLength();
                            int colCtr = 0;
                            while (colCtr < noOfDeatilChlid) {
                                String colChg;
                                Node colNode = detailChlidList.item(colCtr);
                                NamedNodeMap colAttrNodesMap = colNode.getAttributes();
                                String string3 = colChg = colAttrNodesMap != null && colAttrNodesMap.getNamedItem("isChg") != null ? colAttrNodesMap.getNamedItem("isChg").getNodeValue() : null;
                                if (colChg != null && colChg.equals("1")) {
                                    if (forMap) {
                                        WorkflowLogger.info("dbId " + dbId);
                                        String ident = dbId.trim();
                                        if (!"1".equals(objCtx)) {
                                            ident = dbId.substring(dbId.lastIndexOf(":") + 1).trim();
                                        } else if (dbId.indexOf(":") != -1 && "1".equals(objCtx)) {
                                            ident = "1";
                                        }
                                        WorkflowLogger.info("ident " + ident);
                                        String nodeVal = null;
                                        if (colNode.getFirstChild() != null) {
                                            if (colNode.getFirstChild().getNodeValue() != null) {
                                                nodeVal = colNode.getFirstChild().getNodeValue();
                                                changedBuffer.append("<Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">").append("<![CDATA[").append(nodeVal).append("]]></Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">");
                                            } else {
                                                nodeVal = genericUtility.serializeDom(colNode);
                                                changedBuffer.append("<Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">").append(nodeVal).append("</Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">");
                                            }
                                        } else {
                                            changedBuffer.append("<Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">").append("<![CDATA[").append("").append("]]></Detail").append(objCtx).append(".").append(ident).append(".").append(colNode.getNodeName()).append(">");
                                        }
                                    } else {
                                        changedBuffer.append(genericUtility.serializeDom(colNode));
                                    }
                                }
                                ++colCtr;
                            }
                            if (!forMap) {
                                changedBuffer.append("</Detail" + objCtx + ">");
                            }
                        }
                    }
                    ++recCtr;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "changedBuffer ::" + changedBuffer.toString());
        return changedBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    private String updateTransInfo(String objName, Connection conn, String refSer, String refID, String lineNo, String chgString, String transInfo, boolean isDataValid, String signStatus) throws ITMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getWorkFlowOpt(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String wrkFlwOpt = "0";
        Statement mStmt = null;
        Connection conLocal = null;
        boolean isConnLocal = false;
        try {
            try {
                if (this.checkNull(objName).length() > 0) {
                    this.userInfo = userInfo;
                    conLocal = this.conn;
                    if (conLocal == null) {
                        conLocal = this.getConnection();
                        isConnLocal = true;
                    }
                    objName = objName.startsWith("w_") ? objName : "w_" + objName;
                    String sqlQuery = "SELECT WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW='" + objName + "'";
                    mStmt = conLocal.prepareStatement(sqlQuery);
                    ResultSet rs = mStmt.executeQuery();
                    while (rs.next()) {
                        wrkFlwOpt = rs.getString("WORKFLOW_OPT");
                    }
                    rs.close();
                    rs = null;
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                }
            }
            catch (Exception e) {
                try {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    if (isConnLocal && conLocal != null) {
                        conLocal.close();
                        conLocal = null;
                    }
                }
                catch (Exception exp) {
                    WorkflowLogger.info("Exception :SignManagerEJB :getWorkFlowOpt :\n" + e.getMessage());
                    throw new ITMException(exp);
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (isConnLocal && conLocal != null) {
                    conLocal.close();
                    conLocal = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception : SignManagerEJB  :getWorkFlowOpt :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return wrkFlwOpt;
    }

    private String createDomString(String objName, String objID) throws ITMException {
        String domString = null;
        try {
            String refSer = null;
            Object mainTableName = null;
            ArrayList taxList = null;
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            HashMap objDetailMap = dbAccessEJB.getObjDetailMap(objName, this.userInfo.getTransDB());
            if (objDetailMap != null) {
                refSer = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
                taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                WorkflowLogger.info("[SignManagerEJB][Object Name=" + objName + "][Ref Ser=" + refSer + "][Tax List=" + taxList + "]");
            }
            ArrayList objFormsDetailList = dbAccessEJB.getObjFormsDetailList(objName, this.userInfo);
            dbAccessEJB = null;
            int noOfForms = objFormsDetailList.size();
            String headerPKFieldDataTypes = this.getHeaderPKFieldTypes(objName);
            MasterDataStatefulEJB masterData = new MasterDataStatefulEJB();
            domString = masterData.getTransactionXMLForEdit(objName, "2", noOfForms, objID, headerPKFieldDataTypes, null, taxList, refSer, this.userInfo != null ? this.userInfo.toString() : null);
            masterData = null;
        }
        catch (ITMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return domString;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        WorkflowLogger.info("[SignManagerEJB]Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    private String getHeaderPKFieldTypes(String objName) throws Exception {
        WorkflowLogger.info("[SignManagerEJB]Getting header primary key field types..........");
        DWObject dwObj = this.getDWObject(objName, 1);
        ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
        StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
        int i = 0;
        while (i < primaryKeyDataTypeList.size()) {
            headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":");
            ++i;
        }
        WorkflowLogger.info("[SignManagerEJB]Header primary key field types :[" + headerPKFieldDataTypesBuff.toString() + "]");
        return headerPKFieldDataTypesBuff.toString();
    }

    private DWObject getDWObject(String objName, int formNo, String formName) throws ITMException {
        DWObject dwObject = null;
        try {
            String formNum = formName != null && formName.trim().length() > 0 ? formName : "" + formNo;
            String metaDataFileName = String.valueOf(objName) + "2" + formNum;
            DWFactory dws = new DWFactory(this.userInfo);
            dwObject = dws.getDataWindow(metaDataFileName);
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getDWObject :" + e);
            throw new ITMException(e);
        }
        return dwObject;
    }

    private DWObject getDWObject(String objName, int formNo) throws ITMException {
        return this.getDWObject(objName, formNo, null);
    }

    private String customizeDataStr(String msgStr, String domString) throws Exception {
        String fieldValue = "";
        String replacedFieldValue = "";
        String currMsgstr = "";
        StringBuffer msgBuff = new StringBuffer();
        try {
            if (msgStr.indexOf("<") != -1) {
                StringTokenizer msgToken = new StringTokenizer(msgStr, ">");
                while (msgToken.hasMoreTokens()) {
                    currMsgstr = msgToken.nextToken();
                    if (currMsgstr.indexOf("<") == -1) continue;
                    int startBracket = currMsgstr.indexOf("<");
                    msgBuff.append(currMsgstr.substring(0, startBracket));
                    fieldValue = currMsgstr.substring(startBracket + 1, currMsgstr.length());
                    replacedFieldValue = this.getValueOfFieldFromDom(domString, fieldValue);
                    msgBuff.append(replacedFieldValue);
                }
                if (!msgStr.endsWith(">")) {
                    String tempStr = msgStr.substring(msgStr.lastIndexOf(">") + 1, msgStr.length());
                    msgBuff.append(tempStr);
                }
            } else {
                msgBuff.append(msgStr);
            }
            WorkflowLogger.info(" msg buff [" + msgBuff.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgBuff.toString();
    }

    private String getValueOfFieldFromDom(String domStr, String fieldRequired) throws Exception {
        Object parentNode = null;
        Document dom = null;
        String childNodeName = null;
        Object childNodeName1 = null;
        String fieldValue = null;
        String fromNode = null;
        ArrayList taskList = new ArrayList();
        E12GenericUtility genericUtility = new E12GenericUtility();
        dom = genericUtility.parseString(domStr);
        if (fieldRequired.indexOf(".") != -1) {
            fromNode = fieldRequired.substring(0, fieldRequired.indexOf("."));
            fieldRequired = fieldRequired.substring(fieldRequired.indexOf(".") + 1, fieldRequired.length());
        } else {
            fromNode = fromNode == null ? "Detail1" : fromNode;
        }
        NodeList detailList = dom.getElementsByTagName(fromNode);
        int detListLength = detailList.getLength();
        int ctr = 0;
        while (ctr < detListLength) {
            Node currDetailNode = detailList.item(ctr);
            NodeList childList = currDetailNode.getChildNodes();
            int childCtr = childList.getLength();
            int chCnt = 0;
            while (chCnt < childCtr) {
                Node childNode = childList.item(chCnt);
                childNodeName = childNode.getNodeName();
                if (childNodeName.equalsIgnoreCase(fieldRequired) && childNode.getFirstChild() != null) {
                    fieldValue = childNode.getFirstChild().getNodeValue().trim();
                    WorkflowLogger.info("fieldRequired [" + fieldRequired + "] fieldValue  [" + fieldValue + "]");
                }
                ++chCnt;
            }
            ++ctr;
        }
        fieldValue = fieldValue == null ? "" : fieldValue;
        return fieldValue;
    }

    @Override
    public HashMap getUnsignedCountMap(String entityCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection mConnection = null;
        Statement pStmt = null;
        ResultSet rs = null;
        HashMap<String, String> unsignedCountMap = new HashMap<String, String>();
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                String mQuery = "SELECT REF_SER, COUNT(*) CNT FROM OBJ_SIGN_TRANS WHERE ENTITY_CODE='" + entityCode + "' AND SIGN_STATUS='U' GROUP BY REF_SER";
                WorkflowLogger.info("entityCode [" + entityCode + "]");
                WorkflowLogger.info("MyQuery" + mQuery);
                pStmt = mConnection.prepareStatement(mQuery);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    unsignedCountMap.put(rs.getString(1), rs.getString(2));
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (ITMException itme) {
                WorkflowLogger.info("ITMException : SignManagerEJB : :==>" + itme.getMessage());
                throw itme;
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception : SignManagerEJB : :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception : SignManagerEJB  : :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("Returning unsignedCountMap [" + unsignedCountMap + "]");
        return unsignedCountMap;
    }

    private boolean getForcedSaveStatus(String chgString) throws ITMException {
        boolean forcedSave = false;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document signChgDom = genericUtility.parseString(chgString);
            NodeList detailNodeList = signChgDom.getElementsByTagName("header");
            Node detailNode = detailNodeList.item(0);
            if (detailNode != null) {
                NodeList detailChildList = detailNode.getChildNodes();
                int dCtr = 0;
                while (dCtr < detailChildList.getLength()) {
                    Node currChild = detailChildList.item(dCtr);
                    if (currChild.getNodeName().equalsIgnoreCase("forcedSave") && currChild.getFirstChild() != null && !currChild.getFirstChild().getNodeValue().equalsIgnoreCase("false")) {
                        forcedSave = true;
                    }
                    ++dCtr;
                }
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        WorkflowLogger.info("F O R C E D S A V E :::::::::::::::" + forcedSave);
        return forcedSave;
    }

    @Override
    public String getTransXMLString(String userID, String siteCode, String refSer, String refID, int lineNo, String userInfoStr, Connection con) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB] getTransXMLString Getting Trans XML string for \nuserID :" + userID + ": \nrefSer :" + refSer + ": \nrefID :" + refID + ": \nlineNo :" + lineNo + ":");
        ResultSet rs = null;
        Statement pStmt = null;
        ResultSetMetaData rsmd = null;
        String retString = null;
        boolean isError = false;
        boolean isConnLocal = false;
        StringBuffer addWhereClause = new StringBuffer();
        StringBuffer roleCodeBuff = new StringBuffer();
        ArrayList roleCodeList = null;
        try {
            try {
                this.conn = con;
                this.userInfo = new UserInfoBean(userInfoStr);
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                this.conn.setAutoCommit(false);
                WorkflowLogger.info("ENITY CODE [" + this.userInfo.getEntityCode() + "] ");
                StringBuffer xmlStringBuff = new StringBuffer();
                String refSerDesc = this.getRefSerDesc(this.conn, refSer);
                String selQuery = " SELECT REF_SER, REF_ID, LINE_NO, SIGN_REMARKS, SIGN_STATUS, ROLE_CODE__SIGN, ROLE_TYPE, ROLE_ENTITY, ENTITY_CODE, USER_INPUT, RIGHTS_CHAR_SIGN FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? ";
                WorkflowLogger.info("[SignManagerEJB]Retrieving relevant records from OBJ_SIGN_TRANS table, Query :\n" + selQuery);
                pStmt = this.conn.prepareStatement(selQuery);
                WorkflowLogger.info("this.database :[" + database + "] Setting Ref Ser :[" + refSer + "] Ref Id :[" + refID.trim() + "] Setting Line No. :[" + lineNo + "] ");
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, lineNo);
                if (userID != null && userID.length() > 0) {
                    roleCodeList = this.getRoleCodeList(userID);
                    int ctr = 0;
                    while (ctr < roleCodeList.size()) {
                        roleCodeBuff.append("'" + roleCodeList.get(ctr) + "',");
                        ++ctr;
                    }
                    if (roleCodeBuff.length() > 0) {
                        roleCodeBuff.deleteCharAt(roleCodeBuff.length() - 1);
                    }
                }
                addWhereClause.append(" REF_SER = ?");
                addWhereClause.append(" AND LTRIM( RTRIM ( REF_ID ) ) = '").append(refID.trim()).append("' ");
                if (roleCodeBuff.length() > 0) {
                    addWhereClause.append(" AND ( ROLE_CODE__SIGN IN(" + roleCodeBuff.toString() + ")").append(" OR LTRIM( RTRIM ( ENTITY_CODE )  ) ='").append(this.checkNull(this.userInfo.getEntityCode()).trim()).append("' ) ");
                } else {
                    addWhereClause.append(" AND LTRIM( RTRIM ( ENTITY_CODE )  ) ='").append(this.checkNull(this.userInfo.getEntityCode()).trim()).append("' ");
                }
                addWhereClause.append(" AND LINE_NO = ").append("?");
                WorkflowLogger.info("[SignManagerEJB] Executing Query...........");
                rs = pStmt.executeQuery();
                WorkflowLogger.info("[SignManagerEJB] Query executed");
                int domId = 1;
                rsmd = rs.getMetaData();
                int noOfCols = rsmd.getColumnCount();
                while (rs.next()) {
                    WorkflowLogger.info("Records Found....");
                    xmlStringBuff.append("<Detail domID='" + domId++ + "' refSerDesc='" + refSerDesc + "'>");
                    xmlStringBuff.append("<attribute id='pkfield1value:pkfield2value:'/>");
                    xmlStringBuff.append("<attribute status=''/>");
                    xmlStringBuff.append("<attribute selected=''/>");
                    String roleType = null;
                    String roleEntity = null;
                    String entityCode = null;
                    String roleCodeSign = null;
                    String userInput = null;
                    int i = 1;
                    while (i <= noOfCols) {
                        String data = null;
                        String colName = rsmd.getColumnName(i);
                        int metaType = rsmd.getColumnType(i);
                        if (metaType == 91 || metaType == 93) {
                            E12GenericUtility genericUtility;
                            if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                                Timestamp currTimeStamp = rs.getTimestamp(i);
                                if (currTimeStamp != null) {
                                    genericUtility = new E12GenericUtility();
                                    data = genericUtility.getValidDateTimeString(currTimeStamp.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                                }
                            } else {
                                Date currDate = rs.getDate(i);
                                if (currDate != null) {
                                    genericUtility = new E12GenericUtility();
                                    data = genericUtility.getValidDateString(currDate.toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                                }
                            }
                        } else {
                            data = rs.getString(i);
                        }
                        if (data == null) {
                            data = "";
                        }
                        if (data.toUpperCase().indexOf("<![CDATA[") == -1) {
                            xmlStringBuff.append("<" + colName + "><![CDATA[" + data + "]]></" + colName + ">");
                        } else {
                            xmlStringBuff.append("<" + colName + ">" + data + "</" + colName + ">");
                        }
                        if (colName.equalsIgnoreCase("ROLE_TYPE")) {
                            roleType = data;
                        } else if (colName.equalsIgnoreCase("ROLE_ENTITY")) {
                            roleEntity = data;
                        } else if (colName.equalsIgnoreCase("ENTITY_CODE")) {
                            entityCode = data;
                        } else if (colName.equalsIgnoreCase("ROLE_CODE__SIGN")) {
                            roleCodeSign = data;
                        } else if (colName.equalsIgnoreCase("USER_INPUT")) {
                            userInput = data;
                        }
                        ++i;
                    }
                    String userInfoEntityCode = this.userInfo.getEntityCode().trim();
                    if (entityCode != null) {
                        entityCode = entityCode.trim();
                    }
                    WorkflowLogger.info("Comparing userInfoEntityCode [" + userInfoEntityCode + "] with entityCode [" + entityCode + "]");
                    BaseLogger.log("3", null, null, " CommonConstants.DB_NAME ..[ " + CommonConstants.DB_NAME + " ]");
                    if ("oracle".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        xmlStringBuff.append("<TRANS_INFO>").append(this.getTransInfoXMLTypeStr(refSer, refID, lineNo, addWhereClause.toString(), userInfoStr)).append(this.getPrevSignRemarks(refSer, refID)).append(this.getSignStatus(refSer, refID, lineNo)).append("</TRANS_INFO>");
                    } else {
                        xmlStringBuff.append("<TRANS_INFO>").append(this.getTransInfo(refSer, refID, lineNo, addWhereClause.toString(), userInfoStr)).append(this.getPrevSignRemarks(refSer, refID)).append(this.getSignStatus(refSer, refID, lineNo)).append("</TRANS_INFO>");
                    }
                    ArrayList roleCode = this.getRoleCodeList(this.userInfo.getLoginCode().trim());
                    BaseLogger.log("3", null, null, "this.userInfo.getLoginCode().trim() => " + this.userInfo.getLoginCode().trim() + " entityCode => " + entityCode + "Role Code of userInfoEntityCode => " + roleCode + " roleCodeSign => " + roleCodeSign);
                    if (userInfoEntityCode.trim().equalsIgnoreCase(entityCode) || roleCode.contains(roleCodeSign) || entityCode == null || entityCode.trim().length() == 0) {
                        xmlStringBuff.append("<UPDATE_FLAG><![CDATA[Y]]></UPDATE_FLAG>");
                    } else {
                        xmlStringBuff.append("<UPDATE_FLAG><![CDATA[N]]></UPDATE_FLAG>");
                    }
                    xmlStringBuff.append("</Detail>");
                }
                retString = new E12GenericUtility().getNormalizeString(xmlStringBuff.toString());
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (ITMException itme) {
                System.err.println("ITMException :SignManagerEJB :getTransXMLString :\n");
                isError = true;
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getTransXMLString :\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        this.conn.commit();
                    }
                    if (isConnLocal) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getTransXMLString :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Returning Trans xml string length [" + retString.length() + "]");
        return retString;
    }

    @Override
    public String getBrowData(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String transDB) throws RemoteException, Exception {
        StringBuffer browXmlDataBuff;
        block38: {
            BaseLogger.log("3", null, null, "the BrowData (7 Params) called-- ");
            WorkflowLogger.info("[SignTransEJB]Getting the XML from OBJ_SIGN_TRANS .....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            browXmlDataBuff = new StringBuffer("<root>");
            try {
                try {
                    mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    ctx1 = ctx1 == null ? "" : ctx1;
                    ctx2 = ctx2 == null ? "" : ctx2;
                    ctx3 = ctx3 == null ? "" : ctx3;
                    StringBuffer queryBuff = new StringBuffer(" SELECT SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, CREATE_DATE, ROLE_CODE__SIGN, REF_SER, REF_ID, LINE_NO, SIGN_STATUS, USER_ID__SIGN, SIGN_REMARKS, SIGN_DATE, USER_INPUT FROM OBJ_SIGN_TRANS WHERE ");
                    HashMap<String, String> refSerMap = null;
                    String roleSign = this.getRoleSign(roles);
                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                    if (roleSign != null) {
                        if (ctx3.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx2.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx1.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else {
                            queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ").append("ORDER BY CREATE_DATE DESC ");
                        }
                    } else if (ctx3.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx2.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx1.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("'");
                    } else {
                        queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ORDER BY CREATE_DATE DESC ");
                    }
                    BaseLogger.log("3", null, null, "SignManagerEJB:getBrowData:queryBuff.toString()[" + queryBuff.toString() + "]");
                    stmt = mConnection.prepareStatement(queryBuff.toString());
                    rs = stmt.executeQuery();
                    refSerMap = new HashMap<String, String>();
                    while (rs.next()) {
                        String refSerTemp = rs.getString("REF_SER");
                        if (refSerMap.get(refSerTemp) == null) {
                            refSerMap.put(refSerTemp, dbAccessEJB.getRefSerObjName(refSerTemp, transDB));
                        }
                        browXmlDataBuff.append("<VALUES>");
                        browXmlDataBuff.append("<SIGNFOR><![CDATA[").append(rs.getString("SIGN_FOR")).append("]]></SIGNFOR>");
                        browXmlDataBuff.append("<CONTEXT1><![CDATA[").append(rs.getString("CONTEXT_1")).append("]]></CONTEXT1>");
                        browXmlDataBuff.append("<CONTEXT2><![CDATA[").append(rs.getString("CONTEXT_2")).append("]]></CONTEXT2>");
                        browXmlDataBuff.append("<CONTEXT3><![CDATA[").append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                        E12GenericUtility genericUtility = new E12GenericUtility();
                        String createDate = "";
                        String signedDate = "";
                        String userIdSign = this.checkNull(rs.getString("USER_ID__SIGN"));
                        BaseLogger.log("3", null, null, "@userIdSign[" + userIdSign + "]");
                        if (userIdSign.length() > 0) {
                            CommonDBAccessEJB commonDBAccess = new CommonDBAccessEJB();
                            userIdSign = commonDBAccess.getDBColumnValue("users", "name", " where code = '" + userIdSign.trim() + "' ");
                            BaseLogger.log("3", null, null, "@@userIdSign[" + userIdSign + "]");
                        }
                        createDate = rs.getTimestamp("CREATE_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("CREATE_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        signedDate = rs.getTimestamp("SIGN_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        browXmlDataBuff.append("<CREATEDATE><![CDATA[").append(createDate).append("]]></CREATEDATE>");
                        browXmlDataBuff.append("<ROLECODESIGN><![CDATA[").append(rs.getString("ROLE_CODE__SIGN")).append("]]></ROLECODESIGN>");
                        browXmlDataBuff.append("<REFSER><![CDATA[").append(rs.getString("REF_SER")).append("]]></REFSER>");
                        browXmlDataBuff.append("<REFID><![CDATA[").append(rs.getString("REF_ID")).append("]]></REFID>");
                        browXmlDataBuff.append("<LINENO><![CDATA[").append(rs.getInt("LINE_NO")).append("]]></LINENO>");
                        browXmlDataBuff.append("<SIGNSTATUS><![CDATA[").append(rs.getString("SIGN_STATUS")).append("]]></SIGNSTATUS>");
                        browXmlDataBuff.append("<USERIDSIGN><![CDATA[").append(userIdSign).append("]]></USERIDSIGN>");
                        browXmlDataBuff.append("<SIGNREMARKS><![CDATA[").append(this.checkNull(rs.getString("SIGN_REMARKS"))).append("]]></SIGNREMARKS>");
                        browXmlDataBuff.append("<SIGNDATE><![CDATA[").append(signedDate).append("]]></SIGNDATE>");
                        browXmlDataBuff.append("<OBJNAME><![CDATA[").append(refSerMap.get(refSerTemp)).append("]]></OBJNAME>");
                        browXmlDataBuff.append("<USERINPUT><![CDATA[").append(rs.getString("USER_INPUT")).append("]]></USERINPUT>");
                        browXmlDataBuff.append("</VALUES>");
                    }
                    browXmlDataBuff.append("</root>");
                    rs.close();
                    rs = null;
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :SignTransEJB :getBrowData (7 Params) :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                            if (this.conn != null) {
                                this.conn.close();
                                this.conn = null;
                            }
                        }
                        break block38;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getBrowData (7 Params finally):\n" + e2.getMessage());
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                        if (this.conn != null) {
                            this.conn.close();
                            this.conn = null;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getBrowData (7 Params finally):\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getBrowData (7 Params finally):\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the BrowData (7 Params):\n[" + browXmlDataBuff.toString() + "]");
        return browXmlDataBuff.toString();
    }

    public String getBrowData(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String userInfoStr, String applName, String transDB, String currentRowNum, String uptoRowNum) throws RemoteException, Exception {
        try {
            this.currentRowNum = currentRowNum;
            this.uptoRowNum = uptoRowNum;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception>>>Sunny:::" + e.getMessage());
            e.printStackTrace();
        }
        return this.getBrowData(action, status, roles, ctx1, ctx2, ctx3, entityCode, userInfoStr, "", transDB);
    }

    @Override
    public String getBrowData(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String userInfoStr, String transDB) throws RemoteException, Exception {
        return this.getBrowData(action, status, roles, ctx1, ctx2, ctx3, entityCode, userInfoStr, "", transDB);
    }

    @Override
    public String getBrowData(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String userInfoStr, String applName, String transDB) throws RemoteException, Exception {
        StringBuffer browXmlDataBuff;
        block52: {
            BaseLogger.log("3", null, null, "the BrowData (8 Params) called...");
            WorkflowLogger.info("[SignTransEJB]Getting the XML from OBJ_SIGN_TRANS overloaded getBrowData.....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            ArrayList roleCodeList = null;
            String userID = "";
            String userType = "";
            String processId = "";
            String instanceId = "";
            String activityId = "";
            String seqId = "";
            String objName = "";
            String prcInst = "";
            browXmlDataBuff = new StringBuffer("<root>");
            try {
                try {
                    mConnDriver = new ConnDriver();
                    this.conn = mConnection = mConnDriver.getConnectDB(transDB);
                    ctx1 = ctx1 == null ? "" : ctx1;
                    ctx2 = ctx2 == null ? "" : ctx2;
                    ctx3 = ctx3 == null ? "" : ctx3;
                    CommonDBAccessEJB commonDBAccessInstance = new CommonDBAccessEJB();
                    StringBuffer queryBuff = new StringBuffer(" SELECT SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, CREATE_DATE, ROLE_CODE__SIGN, REF_SER, REF_ID, LINE_NO, SIGN_STATUS, USER_ID__SIGN, SIGN_REMARKS, SIGN_DATE, USER_INPUT,OBJ_NAME,PRC_INST__WF,RIGHTS_CHAR_SIGN FROM OBJ_SIGN_TRANS WHERE ");
                    HashMap refSerMap = null;
                    BaseLogger.log("3", null, null, "roles before : [ " + roles + " ]");
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    }
                    if (this.userInfo != null) {
                        userID = this.userInfo.getLoginCode();
                        userType = this.userInfo.getUserType();
                    }
                    if (roles == "" || roles == null || roles.trim().length() == 0) {
                        StringBuffer roleCodeBuff = new StringBuffer();
                        roleCodeList = new ArrayList();
                        roleCodeList = this.getRoleCodeList(userID.trim());
                        for (String roleStr : roleCodeList) {
                            roleCodeBuff = roleCodeBuff.append(String.valueOf(roleStr) + "~");
                        }
                        roles = roleCodeBuff.toString();
                    }
                    BaseLogger.log("3", null, null, "roles after: [ " + roles + " ]");
                    String roleSign = this.getRoleSign(roles);
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    queryBuff.append(" ROLE_ENTITY= '").append(userType).append("' ");
                    queryBuff.append(" AND ");
                    if (roleSign != null) {
                        if (ctx3.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx2.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx1.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else {
                            queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ").append("ORDER BY CREATE_DATE DESC ");
                        }
                    } else if (ctx3.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx2.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx1.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("'");
                    } else {
                        queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ORDER BY CREATE_DATE DESC ");
                    }
                    BaseLogger.log("3", null, null, "SignManagerEJB:getBrowData:queryBuff.toString()[" + queryBuff.toString() + "]");
                    String finalQuery = null;
                    finalQuery = this.currentRowNum != null && this.uptoRowNum != null ? this.getRowNumAppendQuery(queryBuff.toString(), Integer.parseInt(this.currentRowNum), Integer.parseInt(this.uptoRowNum)) : queryBuff.toString();
                    BaseLogger.log("3", null, null, "SignManagerEJB:getBrowData:finalQuery----2--[" + finalQuery + "]");
                    stmt = mConnection.prepareStatement(finalQuery);
                    rs = stmt.executeQuery();
                    refSerMap = new HashMap();
                    while (rs.next()) {
                        objName = rs.getString("OBJ_NAME");
                        prcInst = rs.getString("PRC_INST__WF");
                        BaseLogger.log("3", null, null, "objName.....= " + objName);
                        BaseLogger.log("3", null, null, "prcInst.....= " + prcInst);
                        if (objName == null || objName.trim().length() == 0) {
                            String[] value = prcInst.split(":");
                            processId = value[0] != null ? value[0] : "";
                            instanceId = value[1] != null ? value[1] : "";
                            activityId = value[2] != null ? value[2] : "";
                            seqId = value[3] != null ? value[3] : "";
                            WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                            HashMap paramMap = workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
                            workflowProcessDataManger = null;
                            WorkflowLogger.info("paramMap " + paramMap);
                            objName = (String)paramMap.get("$OBJ_NAME");
                        }
                        HashMap<String, HashMap<String, String>> itm2menuInfoHM = this.getObjDescrAndImageName(objName, this.userInfo);
                        browXmlDataBuff.append("<VALUES>");
                        browXmlDataBuff.append("<SIGNFOR><![CDATA[").append(rs.getString("SIGN_FOR")).append("]]></SIGNFOR>");
                        browXmlDataBuff.append("<CONTEXT1><![CDATA[").append(rs.getString("CONTEXT_1")).append("]]></CONTEXT1>");
                        browXmlDataBuff.append("<CONTEXT2><![CDATA[").append(rs.getString("CONTEXT_2")).append("]]></CONTEXT2>");
                        browXmlDataBuff.append("<CONTEXT3><![CDATA[").append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                        E12GenericUtility genericUtility = new E12GenericUtility();
                        String createDate = "";
                        String signedDate = "";
                        String userIdSign = this.checkNull(rs.getString("USER_ID__SIGN"));
                        BaseLogger.log("3", null, null, "@userIdSign[" + userIdSign + "]");
                        if (userIdSign.length() > 0) {
                            CommonDBAccessEJB commonDBAccess = new CommonDBAccessEJB();
                            userIdSign = commonDBAccess.getDBColumnValue("users", "name", " where code = '" + userIdSign.trim() + "' ");
                            BaseLogger.log("3", null, null, "@@userIdSign[" + userIdSign + "]");
                        }
                        createDate = rs.getTimestamp("CREATE_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("CREATE_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        signedDate = rs.getTimestamp("SIGN_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        browXmlDataBuff.append("<CREATEDATE><![CDATA[").append(createDate).append("]]></CREATEDATE>");
                        browXmlDataBuff.append("<ROLECODESIGN><![CDATA[").append(rs.getString("ROLE_CODE__SIGN")).append("]]></ROLECODESIGN>");
                        browXmlDataBuff.append("<REFSER><![CDATA[").append(rs.getString("REF_SER")).append("]]></REFSER>");
                        browXmlDataBuff.append("<REFID><![CDATA[").append(rs.getString("REF_ID")).append("]]></REFID>");
                        browXmlDataBuff.append("<LINENO><![CDATA[").append(rs.getInt("LINE_NO")).append("]]></LINENO>");
                        browXmlDataBuff.append("<SIGNSTATUS><![CDATA[").append(rs.getString("SIGN_STATUS")).append("]]></SIGNSTATUS>");
                        browXmlDataBuff.append("<USERIDSIGN><![CDATA[").append(userIdSign).append("]]></USERIDSIGN>");
                        browXmlDataBuff.append("<SIGNREMARKS><![CDATA[").append(this.checkNull(rs.getString("SIGN_REMARKS"))).append("]]></SIGNREMARKS>");
                        browXmlDataBuff.append("<SIGNDATE><![CDATA[").append(signedDate).append("]]></SIGNDATE>");
                        browXmlDataBuff.append("<OBJNAME><![CDATA[").append(objName).append("]]></OBJNAME>");
                        String descr = "";
                        String imgName = "";
                        if (itm2menuInfoHM.containsKey(objName)) {
                            HashMap<String, String> itm2menuDetailHM = itm2menuInfoHM.get(objName);
                            descr = itm2menuDetailHM.get("DESCR");
                            imgName = itm2menuDetailHM.get("ICON_PATH");
                        }
                        browXmlDataBuff.append("<OBJDESCR><![CDATA[").append(descr).append("]]></OBJDESCR>");
                        browXmlDataBuff.append("<OBJIMGNAME><![CDATA[").append(imgName).append("]]></OBJIMGNAME>");
                        browXmlDataBuff.append("<USERINPUT><![CDATA[").append(rs.getString("USER_INPUT")).append("]]></USERINPUT>");
                        String wrkFlwOpt = this.getWorkFlowOpt(objName, this.userInfo);
                        ArrayList roleCode = this.getRoleCodeList(this.userInfo.getLoginCode().trim());
                        String roleCodeSign = rs.getString("ROLE_CODE__SIGN");
                        entityCode = entityCode.trim();
                        String userInfoStr1 = this.userInfo.getEntityCode().trim();
                        BaseLogger.log("3", null, null, "getBrowData::this.userInfo.getLoginCode().trim() => [" + this.userInfo.getLoginCode().trim() + "] userInfoStr.trim() ==>[" + userInfoStr1.trim() + "] entityCode => [" + entityCode + "] Role Code of userInfoStr => " + roleCode + " roleCodeSign => " + roleCodeSign);
                        String rightsChar = this.checkNull(rs.getString("RIGHTS_CHAR_SIGN"));
                        browXmlDataBuff.append("<RIGHTSCHARSIGN><![CDATA[").append(rightsChar).append("]]></RIGHTSCHARSIGN>");
                        browXmlDataBuff.append("<WRKFLWOPT><![CDATA[").append(wrkFlwOpt).append("]]></WRKFLWOPT>");
                        if (userInfoStr1.trim().equalsIgnoreCase(entityCode) || roleCode.contains(roleCodeSign) || entityCode == null || entityCode.trim().length() == 0) {
                            browXmlDataBuff.append("<UPDATE_FLAG><![CDATA[Y]]></UPDATE_FLAG>");
                        } else {
                            browXmlDataBuff.append("<UPDATE_FLAG><![CDATA[N]]></UPDATE_FLAG>");
                        }
                        if (prcInst != null && prcInst.trim().length() > 0) {
                            String[] value = prcInst.split(":");
                            processId = value[0] != null ? value[0] : "";
                            instanceId = value[1] != null ? value[1] : "";
                            activityId = value[2] != null ? value[2] : "";
                            seqId = value[3] != null ? value[3] : "";
                            String sqlCondition = "where process_id = '" + processId.trim() + "' AND instance_id='" + instanceId.trim() + "' AND activity_id='" + activityId.trim() + "' AND seq_id='" + seqId.trim() + "'";
                            String actionInfo = commonDBAccessInstance.getDBColumnValue("wf_prc_status", "Action_info", sqlCondition, transDB);
                            BaseLogger.log("3", null, null, "rightsChar[" + rightsChar + "]");
                            BaseLogger.log("3", null, null, "Before change actionInfo[" + actionInfo + "]");
                            if (actionInfo == null) {
                                JSONObject jsonActionData = this.getJSONActionData(rightsChar);
                                BaseLogger.log("3", null, null, "jsonActionData[" + jsonActionData + "]");
                                if (jsonActionData != null) {
                                    actionInfo = jsonActionData.toString();
                                }
                            }
                            BaseLogger.log("3", null, null, "After change actionInfo[" + actionInfo + "]");
                            if (actionInfo != null) {
                                browXmlDataBuff.append("<ACTIONS><![CDATA[").append(actionInfo).append("]]></ACTIONS>");
                            }
                        }
                        browXmlDataBuff.append(this.getActivityActionRights(processId, activityId));
                        browXmlDataBuff.append("</VALUES>");
                    }
                    browXmlDataBuff.append("</root>");
                    rs.close();
                    rs = null;
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :SignTransEJB :getBrowData :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                            if (this.conn != null) {
                                this.conn.close();
                                this.conn = null;
                            }
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        break block52;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e2.getMessage());
                    }
                    break block52;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                        if (this.conn != null) {
                            this.conn.close();
                            this.conn = null;
                        }
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the BrowData (8 Params):\n[" + browXmlDataBuff.toString() + "]");
        return browXmlDataBuff.toString();
    }

    public String getBrowDataJSON(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String userInfoStr, String applName, String transDB, String currentRowNum, String uptoRowNum) throws RemoteException, Exception {
        try {
            this.currentRowNum = currentRowNum;
            this.uptoRowNum = uptoRowNum;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception>>>Sunny:::" + e.getMessage());
            e.printStackTrace();
        }
        return this.getBrowDataJSON(action, status, roles, ctx1, ctx2, ctx3, entityCode, userInfoStr, "", transDB);
    }

    public String getBrowDataJSON(String action, String status, String roles, String ctx1, String ctx2, String ctx3, String entityCode, String userInfoStr, String applName, String transDB) throws RemoteException, Exception {
        JSONObject rootJson;
        block52: {
            BaseLogger.log("3", null, null, "the BrowData (8 Params) called...");
            WorkflowLogger.info("[SignTransEJB]Getting the XML from OBJ_SIGN_TRANS overloaded getBrowData.....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            ArrayList roleCodeList = null;
            String userID = "";
            String userType = "";
            String processId = "";
            String instanceId = "";
            String activityId = "";
            String seqId = "";
            String objName = "";
            String prcInst = "";
            rootJson = new JSONObject();
            try {
                try {
                    mConnDriver = new ConnDriver();
                    this.conn = mConnection = mConnDriver.getConnectDB(transDB);
                    ctx1 = ctx1 == null ? "" : ctx1;
                    ctx2 = ctx2 == null ? "" : ctx2;
                    ctx3 = ctx3 == null ? "" : ctx3;
                    CommonDBAccessEJB commonDBAccessInstance = new CommonDBAccessEJB();
                    StringBuffer queryBuff = new StringBuffer(" SELECT SIGN_FOR, CONTEXT_1, CONTEXT_2, CONTEXT_3, CREATE_DATE, ROLE_CODE__SIGN, REF_SER, REF_ID, LINE_NO, SIGN_STATUS, USER_ID__SIGN, SIGN_REMARKS, SIGN_DATE, USER_INPUT,OBJ_NAME,PRC_INST__WF,RIGHTS_CHAR_SIGN FROM OBJ_SIGN_TRANS WHERE ");
                    HashMap refSerMap = null;
                    BaseLogger.log("3", null, null, "roles before : [ " + roles + " ]");
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    }
                    if (this.userInfo != null) {
                        userID = this.userInfo.getLoginCode();
                        userType = this.userInfo.getUserType();
                    }
                    if (roles == "" || roles == null || roles.trim().length() == 0) {
                        StringBuffer roleCodeBuff = new StringBuffer();
                        roleCodeList = new ArrayList();
                        roleCodeList = this.getRoleCodeList(userID.trim());
                        for (String roleStr : roleCodeList) {
                            roleCodeBuff = roleCodeBuff.append(String.valueOf(roleStr) + "~");
                        }
                        roles = roleCodeBuff.toString();
                    }
                    BaseLogger.log("3", null, null, "roles after: [ " + roles + " ]");
                    String roleSign = this.getRoleSign(roles);
                    DBAccessEJB dbAccess = new DBAccessEJB();
                    queryBuff.append(" ROLE_ENTITY= '").append(userType).append("' ");
                    queryBuff.append(" AND ");
                    if (roleSign != null) {
                        if (ctx3.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx2.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else if (ctx1.length() > 0) {
                            queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ");
                        } else {
                            queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND ( ROLE_CODE__SIGN IN ").append(roleSign).append(" OR  ENTITY_CODE = '").append(entityCode).append("' ) ").append("ORDER BY CREATE_DATE DESC ");
                        }
                    } else if (ctx3.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND CONTEXT_3 = '").append(ctx3).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx2.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND CONTEXT_2 = '").append(ctx2).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ");
                    } else if (ctx1.length() > 0) {
                        queryBuff.append(" CONTEXT_1 = '").append(ctx1).append("' AND SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("'");
                    } else {
                        queryBuff.append(" SIGN_STATUS = '").append(status).append("' AND  ENTITY_CODE = '").append(entityCode).append("' ORDER BY CREATE_DATE DESC ");
                    }
                    BaseLogger.log("3", null, null, "SignManagerEJB:getBrowData:queryBuff.toString()[" + queryBuff.toString() + "]");
                    String finalQuery = null;
                    finalQuery = this.currentRowNum != null && this.uptoRowNum != null ? this.getRowNumAppendQuery(queryBuff.toString(), Integer.parseInt(this.currentRowNum), Integer.parseInt(this.uptoRowNum)) : queryBuff.toString();
                    BaseLogger.log("3", null, null, "SignManagerEJB:getBrowData:finalQuery----2--[" + finalQuery + "]");
                    stmt = mConnection.prepareStatement(finalQuery);
                    rs = stmt.executeQuery();
                    refSerMap = new HashMap();
                    JSONArray valueArray = new JSONArray();
                    while (rs.next()) {
                        objName = rs.getString("OBJ_NAME");
                        prcInst = rs.getString("PRC_INST__WF");
                        BaseLogger.log("3", null, null, "objName.....= " + objName);
                        BaseLogger.log("3", null, null, "prcInst.....= " + prcInst);
                        if (objName == null || objName.trim().length() == 0) {
                            String[] value = prcInst.split(":");
                            processId = value[0] != null ? value[0] : "";
                            instanceId = value[1] != null ? value[1] : "";
                            activityId = value[2] != null ? value[2] : "";
                            seqId = value[3] != null ? value[3] : "";
                            WorkflowProcessDataMangerEJB workflowProcessDataManger = new WorkflowProcessDataMangerEJB();
                            HashMap paramMap = workflowProcessDataManger.getProcessInputData(processId, Integer.parseInt(instanceId), activityId, Integer.parseInt(seqId));
                            workflowProcessDataManger = null;
                            WorkflowLogger.info("paramMap " + paramMap);
                            objName = (String)paramMap.get("$OBJ_NAME");
                        }
                        HashMap<String, HashMap<String, String>> itm2menuInfoHM = this.getObjDescrAndImageName(objName, this.userInfo);
                        JSONObject valueJson = new JSONObject();
                        valueJson.put((Object)"sign_for", (Object)rs.getString("SIGN_FOR"));
                        valueJson.put((Object)"context_1", (Object)rs.getString("CONTEXT_1"));
                        valueJson.put((Object)"context_2", (Object)rs.getString("CONTEXT_2"));
                        valueJson.put((Object)"context_3", (Object)rs.getString("CONTEXT_3"));
                        E12GenericUtility genericUtility = new E12GenericUtility();
                        String createDate = "";
                        String signedDate = "";
                        String userIdSign = this.checkNull(rs.getString("USER_ID__SIGN"));
                        BaseLogger.log("3", null, null, "@userIdSign[" + userIdSign + "]");
                        if (userIdSign.length() > 0) {
                            CommonDBAccessEJB commonDBAccess = new CommonDBAccessEJB();
                            userIdSign = commonDBAccess.getDBColumnValue("users", "name", " where code = '" + userIdSign.trim() + "' ");
                            BaseLogger.log("3", null, null, "@@userIdSign[" + userIdSign + "]");
                        }
                        createDate = rs.getTimestamp("CREATE_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("CREATE_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        signedDate = rs.getTimestamp("SIGN_DATE") != null ? genericUtility.getValidDateTimeString(rs.getTimestamp("SIGN_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) : "";
                        valueJson.put((Object)"created_date", (Object)createDate);
                        valueJson.put((Object)"role_code_sign", (Object)rs.getString("ROLE_CODE__SIGN"));
                        valueJson.put((Object)"ref_ser", (Object)rs.getString("REF_SER"));
                        valueJson.put((Object)"ref_id", (Object)rs.getString("REF_ID"));
                        valueJson.put((Object)"line_no", (Object)rs.getInt("LINE_NO"));
                        valueJson.put((Object)"sign_status", (Object)rs.getString("SIGN_STATUS"));
                        valueJson.put((Object)"user_id_sign", (Object)userIdSign);
                        valueJson.put((Object)"sign_remarks", (Object)this.checkNull(rs.getString("SIGN_REMARKS")));
                        valueJson.put((Object)"sign_date", (Object)signedDate);
                        valueJson.put((Object)"obj_name", (Object)objName);
                        String descr = "";
                        String imgName = "";
                        if (itm2menuInfoHM.containsKey(objName)) {
                            HashMap<String, String> itm2menuDetailHM = itm2menuInfoHM.get(objName);
                            descr = itm2menuDetailHM.get("DESCR");
                            imgName = itm2menuDetailHM.get("ICON_PATH");
                        }
                        valueJson.put((Object)"obj_descr", (Object)descr);
                        valueJson.put((Object)"obj_img_name", (Object)imgName);
                        valueJson.put((Object)"user_input", (Object)rs.getString("USER_INPUT"));
                        String wrkFlwOpt = this.getWorkFlowOpt(objName, this.userInfo);
                        ArrayList roleCode = this.getRoleCodeList(this.userInfo.getLoginCode().trim());
                        String roleCodeSign = rs.getString("ROLE_CODE__SIGN");
                        entityCode = entityCode.trim();
                        String userInfoStr1 = this.userInfo.getEntityCode().trim();
                        BaseLogger.log("3", null, null, "getBrowData::this.userInfo.getLoginCode().trim() => [" + this.userInfo.getLoginCode().trim() + "] userInfoStr.trim() ==>[" + userInfoStr1.trim() + "] entityCode => [" + entityCode + "] Role Code of userInfoStr => " + roleCode + " roleCodeSign => " + roleCodeSign);
                        String rightsChar = this.checkNull(rs.getString("RIGHTS_CHAR_SIGN"));
                        valueJson.put((Object)"rights_char_sign", (Object)rightsChar);
                        valueJson.put((Object)"workflow_opt", (Object)wrkFlwOpt);
                        if (userInfoStr1.trim().equalsIgnoreCase(entityCode) || roleCode.contains(roleCodeSign) || entityCode == null || entityCode.trim().length() == 0) {
                            valueJson.put((Object)"update_flag", (Object)"Y");
                        } else {
                            valueJson.put((Object)"update_flag", (Object)"N");
                        }
                        if (prcInst != null && prcInst.trim().length() > 0) {
                            String[] value = prcInst.split(":");
                            processId = value[0] != null ? value[0] : "";
                            instanceId = value[1] != null ? value[1] : "";
                            activityId = value[2] != null ? value[2] : "";
                            seqId = value[3] != null ? value[3] : "";
                            String sqlCondition = "where process_id = '" + processId.trim() + "' AND instance_id='" + instanceId.trim() + "' AND activity_id='" + activityId.trim() + "' AND seq_id='" + seqId.trim() + "'";
                            String actionInfo = commonDBAccessInstance.getDBColumnValue("wf_prc_status", "Action_info", sqlCondition, transDB);
                            BaseLogger.log("3", null, null, "rightsChar[" + rightsChar + "]");
                            BaseLogger.log("3", null, null, "Before change actionInfo[" + actionInfo + "]");
                            if (actionInfo == null) {
                                JSONObject jsonActionData = this.getJSONActionData(rightsChar);
                                BaseLogger.log("3", null, null, "jsonActionData[" + jsonActionData + "]");
                                if (jsonActionData != null) {
                                    actionInfo = jsonActionData.toString();
                                }
                            }
                            BaseLogger.log("3", null, null, "After change actionInfo[" + actionInfo + "]");
                            if (actionInfo != null) {
                                JSONParser jsonParser = new JSONParser();
                                JSONObject actionObject = (JSONObject)jsonParser.parse(actionInfo);
                                valueJson.put((Object)"actions", (Object)actionObject);
                            }
                        }
                        valueJson.put((Object)"process_det", (Object)this.getActivityActionRights(processId, activityId));
                        valueArray.add((Object)valueJson);
                        BaseLogger.log("3", null, null, "Value JSON single Object=[" + valueJson + "]");
                    }
                    BaseLogger.log("0", null, null, "Value JSON Array Object=[" + valueArray + "]");
                    JSONObject valuesObj = new JSONObject();
                    valuesObj.put((Object)"values", (Object)valueArray);
                    rootJson.put((Object)"root", (Object)valuesObj);
                    BaseLogger.log("0", null, null, "Value root JSON Object=[" + rootJson + "]");
                    rs.close();
                    rs = null;
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Error in JSON creation[" + e.getMessage() + "]");
                    WorkflowLogger.info("Exception :SignTransEJB :getBrowData :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                            if (this.conn != null) {
                                this.conn.close();
                                this.conn = null;
                            }
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        break block52;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e2.getMessage());
                    }
                    break block52;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                        if (this.conn != null) {
                            this.conn.close();
                            this.conn = null;
                        }
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getBrowData (8 Params):\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the BrowData (8 Params):\n[" + rootJson.toString() + "]");
        BaseLogger.log("3", null, null, "Returning Data JSON");
        return rootJson.toString();
    }

    @Override
    public String getRoles(String action, String loginCode, String transDB) throws RemoteException, Exception {
        String browXmlData;
        StringBuffer browXmlDataBuff;
        block19: {
            WorkflowLogger.info("[SignTransEJB]Getting the XML from WF_ROLE_USERS .....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            browXmlDataBuff = new StringBuffer("<ROOT><Roles>");
            browXmlData = "";
            try {
                try {
                    mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    String selQuery = "SELECT DESCR, ROLE_CODE FROM WF_ROLE WHERE ROLE_CODE IN ( SELECT WF_ROLE_USERS.ROLE_CODE FROM WF_ROLE_USERS, WF_ROLE  WHERE WF_ROLE_USERS.ROLE_CODE = WF_ROLE.ROLE_CODE AND WF_ROLE.ROLE_TYPE = 'S' AND WF_ROLE_USERS.USERID = '" + loginCode + "' ) ";
                    WorkflowLogger.info("[SignMangerEJB]Retrieving getRoles query :\n" + selQuery);
                    stmt = mConnection.prepareStatement(selQuery);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        browXmlDataBuff.append("<Description>");
                        browXmlDataBuff.append(rs.getString("Descr"));
                        browXmlDataBuff.append("</Description>");
                        browXmlDataBuff.append("<Role>");
                        browXmlDataBuff.append(rs.getString("role_code"));
                        browXmlDataBuff.append("</Role>");
                    }
                    browXmlDataBuff.append("</Roles></ROOT>");
                    rs.close();
                    rs = null;
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :SignTransEJB :getRole :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                        }
                        break block19;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getRole :\n" + e2.getMessage());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getRole :\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getRole :\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the RoleData :\n");
        browXmlData = browXmlDataBuff.toString();
        return browXmlData;
    }

    @Override
    public String getTree(String action, String roles, String isEntity, String isRole, String entityCode, String transDB) throws RemoteException, Exception {
        String browXmlData;
        StringBuffer browXmlDataBuff;
        block35: {
            WorkflowLogger.info("[SignTransEJB]Getting the XML from OBJ_SIGN_TRANS .....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            browXmlDataBuff = new StringBuffer("<ROOT>");
            browXmlData = "";
            Object roleCodeList = null;
            try {
                try {
                    mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    String roleSign = "";
                    StringBuffer queryBuff = new StringBuffer("");
                    roleSign = this.getRoleSign(roles);
                    boolean prntFlag = false;
                    boolean chldFlag = false;
                    boolean selectFlag = true;
                    boolean firstRec = true;
                    if (!isEntity.equalsIgnoreCase("true") && !isRole.equalsIgnoreCase("true")) {
                        selectFlag = false;
                    } else if (isRole.equalsIgnoreCase("true") && roles.equalsIgnoreCase("")) {
                        selectFlag = false;
                    }
                    while (selectFlag) {
                        selectFlag = false;
                        queryBuff.append(" SELECT CONTEXT_1,CONTEXT_2,CONTEXT_3, SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE ");
                        if (isEntity.equalsIgnoreCase("true")) {
                            queryBuff.append(" ENTITY_CODE= '").append(entityCode).append("' ");
                        } else if (isRole.equalsIgnoreCase("true") && !roles.equalsIgnoreCase("")) {
                            queryBuff.append(" ROLE_CODE__SIGN IN ").append(roleSign).append(" ");
                        }
                        queryBuff.append(" AND SIGN_STATUS IN ('U', 'R', 'S') GROUP BY CONTEXT_1,CONTEXT_2,CONTEXT_3, SIGN_STATUS ORDER BY SIGN_STATUS, CONTEXT_1, CONTEXT_2, CONTEXT_3");
                        String prevCtxStr1 = "";
                        String prevCtxStr2 = "";
                        String prevCtxStr3 = "";
                        String prevStatus = "";
                        stmt = mConnection.prepareStatement(queryBuff.toString());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            if (rs.getString("CONTEXT_1") == null || rs.getString("CONTEXT_2") == null || rs.getString("CONTEXT_3") == null) continue;
                            if (firstRec) {
                                browXmlDataBuff.append("<CONTEXT1><STATUS><![CDATA[");
                                browXmlDataBuff.append(rs.getString("SIGN_STATUS")).append("]]></STATUS>");
                                browXmlDataBuff.append("<HEADER><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_1")).append("]]></HEADER>");
                                browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_2")).append("]]></SHEADER>");
                                browXmlDataBuff.append("<CONTEXT3><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                                prevCtxStr1 = rs.getString("CONTEXT_1").trim();
                                prevCtxStr2 = rs.getString("CONTEXT_2").trim();
                                prevCtxStr3 = rs.getString("CONTEXT_3").trim();
                                prevStatus = rs.getString("SIGN_STATUS").trim();
                                firstRec = false;
                                continue;
                            }
                            String ctxStr1 = rs.getString("CONTEXT_1").trim();
                            String ctxStr2 = rs.getString("CONTEXT_2").trim();
                            String signStatus = rs.getString("SIGN_STATUS").trim();
                            if (!signStatus.equalsIgnoreCase(prevStatus)) {
                                prevStatus = signStatus;
                                prntFlag = true;
                                chldFlag = true;
                            }
                            if (!prevCtxStr1.equalsIgnoreCase(ctxStr1) || prntFlag) {
                                prevCtxStr1 = ctxStr1;
                                chldFlag = true;
                                browXmlDataBuff.append("</CONTEXT2>");
                                browXmlDataBuff.append("</CONTEXT1>");
                                browXmlDataBuff.append("<CONTEXT1><STATUS><![CDATA[");
                                browXmlDataBuff.append(rs.getString("SIGN_STATUS")).append("]]></STATUS>");
                                browXmlDataBuff.append("<HEADER><![CDATA[");
                                browXmlDataBuff.append(prevCtxStr1).append("]]></HEADER>");
                                prntFlag = false;
                            }
                            if (!prevCtxStr2.equalsIgnoreCase(ctxStr2) || chldFlag) {
                                if (chldFlag) {
                                    prevCtxStr2 = ctxStr2;
                                    browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                    browXmlDataBuff.append(ctxStr2).append("]]></SHEADER>");
                                    chldFlag = false;
                                } else {
                                    prevCtxStr2 = ctxStr2;
                                    browXmlDataBuff.append("</CONTEXT2>");
                                    browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                    browXmlDataBuff.append(ctxStr2).append("]]></SHEADER>");
                                }
                            }
                            browXmlDataBuff.append("<CONTEXT3><![CDATA[");
                            browXmlDataBuff.append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                        }
                        rs.close();
                        rs = null;
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        browXmlDataBuff.append("</CONTEXT2>");
                        browXmlDataBuff.append("</CONTEXT1>");
                    }
                    browXmlDataBuff.append("</ROOT>");
                    browXmlDataBuff.toString();
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :SignTransEJB :getTree :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                            if (this.conn != null) {
                                this.conn.close();
                                this.conn = null;
                            }
                        }
                        break block35;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getTree :\n" + e2.getMessage());
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                        if (this.conn != null) {
                            this.conn.close();
                            this.conn = null;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getTree :\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getTree :\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the TreeData :\n");
        browXmlData = browXmlDataBuff.toString();
        return browXmlData;
    }

    @Override
    public String getTree(String action, String roles, String isEntity, String isRole, String entityCode, String userInfoStr, String transDB) throws RemoteException, Exception {
        String browXmlData;
        StringBuffer browXmlDataBuff;
        block38: {
            WorkflowLogger.info("[SignTransEJB]Getting the XML from OBJ_SIGN_TRANS overloaded getTree.....");
            ConnDriver mConnDriver = null;
            Connection mConnection = null;
            Statement stmt = null;
            ResultSet rs = null;
            browXmlDataBuff = new StringBuffer("<ROOT>");
            browXmlData = "";
            ArrayList roleCodeList = null;
            String userID = "";
            String userType = "";
            try {
                try {
                    mConnDriver = new ConnDriver();
                    this.conn = mConnection = mConnDriver.getConnectDB(transDB);
                    String roleSign = "";
                    StringBuffer queryBuff = new StringBuffer("");
                    BaseLogger.log("3", null, null, "roles before tree: [ " + roles + " ]");
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    }
                    if (this.userInfo != null) {
                        userID = this.userInfo.getLoginCode();
                        userType = this.userInfo.getUserType();
                    }
                    if (roles == "" || roles == null || roles.trim().length() == 0) {
                        StringBuffer roleCodeBuff = new StringBuffer();
                        roleCodeList = new ArrayList();
                        roleCodeList = this.getRoleCodeList(userID.trim());
                        for (String roleStr : roleCodeList) {
                            roleCodeBuff = roleCodeBuff.append(String.valueOf(roleStr) + "~");
                        }
                        roles = roleCodeBuff.toString();
                    }
                    BaseLogger.log("3", null, null, "roles after tree:  [ " + roles + " ]");
                    roleSign = this.getRoleSign(roles);
                    boolean prntFlag = false;
                    boolean chldFlag = false;
                    boolean selectFlag = true;
                    boolean firstRec = true;
                    if (!isEntity.equalsIgnoreCase("true") && !isRole.equalsIgnoreCase("true")) {
                        selectFlag = false;
                    } else if (isRole.equalsIgnoreCase("true") && roles.equalsIgnoreCase("")) {
                        selectFlag = false;
                    }
                    while (selectFlag) {
                        selectFlag = false;
                        queryBuff.append(" SELECT CONTEXT_1,CONTEXT_2,CONTEXT_3, SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE ");
                        queryBuff.append(" ROLE_ENTITY= '").append(userType).append("' ");
                        queryBuff.append(" AND ");
                        queryBuff.append("( ENTITY_CODE= '").append(entityCode).append("' ");
                        if (roleSign != null) {
                            queryBuff.append(" OR ROLE_CODE__SIGN IN ").append(roleSign).append(" ) ");
                        } else {
                            queryBuff.append(" ) ");
                        }
                        queryBuff.append(" AND SIGN_STATUS IN ('U', 'R', 'S') GROUP BY CONTEXT_1,CONTEXT_2,CONTEXT_3, SIGN_STATUS ORDER BY SIGN_STATUS, CONTEXT_1, CONTEXT_2, CONTEXT_3");
                        String prevCtxStr1 = "";
                        String prevCtxStr2 = "";
                        String prevCtxStr3 = "";
                        String prevStatus = "";
                        stmt = mConnection.prepareStatement(queryBuff.toString());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            if (rs.getString("CONTEXT_1") == null || rs.getString("CONTEXT_2") == null || rs.getString("CONTEXT_3") == null) continue;
                            if (firstRec) {
                                browXmlDataBuff.append("<CONTEXT1><STATUS><![CDATA[");
                                browXmlDataBuff.append(rs.getString("SIGN_STATUS")).append("]]></STATUS>");
                                browXmlDataBuff.append("<HEADER><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_1")).append("]]></HEADER>");
                                browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_2")).append("]]></SHEADER>");
                                browXmlDataBuff.append("<CONTEXT3><![CDATA[");
                                browXmlDataBuff.append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                                prevCtxStr1 = rs.getString("CONTEXT_1").trim();
                                prevCtxStr2 = rs.getString("CONTEXT_2").trim();
                                prevCtxStr3 = rs.getString("CONTEXT_3").trim();
                                prevStatus = rs.getString("SIGN_STATUS").trim();
                                firstRec = false;
                                continue;
                            }
                            String ctxStr1 = rs.getString("CONTEXT_1").trim();
                            String ctxStr2 = rs.getString("CONTEXT_2").trim();
                            String signStatus = rs.getString("SIGN_STATUS").trim();
                            if (!signStatus.equalsIgnoreCase(prevStatus)) {
                                prevStatus = signStatus;
                                prntFlag = true;
                                chldFlag = true;
                            }
                            if (!prevCtxStr1.equalsIgnoreCase(ctxStr1) || prntFlag) {
                                prevCtxStr1 = ctxStr1;
                                chldFlag = true;
                                browXmlDataBuff.append("</CONTEXT2>");
                                browXmlDataBuff.append("</CONTEXT1>");
                                browXmlDataBuff.append("<CONTEXT1><STATUS><![CDATA[");
                                browXmlDataBuff.append(rs.getString("SIGN_STATUS")).append("]]></STATUS>");
                                browXmlDataBuff.append("<HEADER><![CDATA[");
                                browXmlDataBuff.append(prevCtxStr1).append("]]></HEADER>");
                                prntFlag = false;
                            }
                            if (!prevCtxStr2.equalsIgnoreCase(ctxStr2) || chldFlag) {
                                if (chldFlag) {
                                    prevCtxStr2 = ctxStr2;
                                    browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                    browXmlDataBuff.append(ctxStr2).append("]]></SHEADER>");
                                    chldFlag = false;
                                } else {
                                    prevCtxStr2 = ctxStr2;
                                    browXmlDataBuff.append("</CONTEXT2>");
                                    browXmlDataBuff.append("<CONTEXT2><SHEADER><![CDATA[");
                                    browXmlDataBuff.append(ctxStr2).append("]]></SHEADER>");
                                }
                            }
                            browXmlDataBuff.append("<CONTEXT3><![CDATA[");
                            browXmlDataBuff.append(rs.getString("CONTEXT_3")).append("]]></CONTEXT3>");
                        }
                        rs.close();
                        rs = null;
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        browXmlDataBuff.append("</CONTEXT2>");
                        browXmlDataBuff.append("</CONTEXT1>");
                    }
                    browXmlDataBuff.append("</ROOT>");
                    browXmlDataBuff.toString();
                }
                catch (Exception e) {
                    WorkflowLogger.info("Exception :SignTransEJB :getTree :==>" + e.getMessage());
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (mConnection != null) {
                            mConnection.close();
                            mConnection = null;
                            if (this.conn != null) {
                                this.conn.close();
                                this.conn = null;
                            }
                        }
                        break block38;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception :SignTransEJB :getTree :\n" + e2.getMessage());
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (mConnection != null) {
                        mConnection.close();
                        mConnection = null;
                        if (this.conn != null) {
                            this.conn.close();
                            this.conn = null;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception :SignTransEJB :getTree :\n" + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignTransEJB :getTree :\n" + e.getMessage());
            }
        }
        WorkflowLogger.info("[SignTransEJB]Returning the TreeData :\n");
        browXmlData = browXmlDataBuff.toString();
        return browXmlData;
    }

    private String getRoleSign(String roles) {
        String roleSign = null;
        try {
            if (!roles.equalsIgnoreCase("")) {
                String[] val = roles.split("~");
                String ROLE_CODE_SIGN = "";
                int len = 0;
                if (val.length > 0) {
                    int i = 0;
                    while (i < val.length) {
                        if (!val[i].equalsIgnoreCase("") && !val[i].equalsIgnoreCase("")) {
                            ROLE_CODE_SIGN = String.valueOf(ROLE_CODE_SIGN) + "'" + val[i] + "' ,";
                        }
                        ++i;
                    }
                    len = ROLE_CODE_SIGN.length() - 2;
                    roleSign = "(" + ROLE_CODE_SIGN.substring(0, len) + " )";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roleSign;
    }

    @Override
    public String getMobileXSLString(String refSer, String refId, int lineNo, String roleCode, Connection con) throws RemoteException, ITMException {
        String xslString = null;
        try {
            String xslFileName = this.getUserXSLFileName(refSer, refId, lineNo, roleCode, con);
            if (xslFileName != null && xslFileName.length() > 0) {
                String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl" + File.separator + xslFileName + "_MOBILE.xsl";
                File file = new File(filePath);
                xslString = file.exists() ? new E12GenericUtility().readFile(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl" + File.separator + xslFileName + "_MOBILE.xsl") : new E12GenericUtility().readFile(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "xsl" + File.separator + xslFileName + ".xsl");
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getMobileXSLString :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return xslString;
    }

    @Override
    public boolean updateXMLBlob(String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes, String transDB) throws RemoteException, ITMException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        ConnDriver mConnDriver = null;
        Connection con = null;
        Statement pStmt = null;
        try {
            try {
                mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(transDB);
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    WorkflowLogger.info("Saving");
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (con != null) {
                    con.commit();
                    con.close();
                    con = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :updateXMLBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("updStatus:[" + updStatus + "]");
        return updStatus;
    }

    private String getBlob(Connection con, String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "Inside getBlob.....");
        String dataStr = "";
        PreparedStatement pStmt = null;
        try {
            try {
                InputStream is;
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next() && (is = rs.getBinaryStream(1)) != null) {
                    InputStreamReader isr = new InputStreamReader(is);
                    StringBuffer xmlStringBuff = new StringBuffer();
                    int ch = -1;
                    while ((ch = isr.read()) != -1) {
                        xmlStringBuff.append((char)ch);
                    }
                    isr.close();
                    dataStr = xmlStringBuff.toString();
                }
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DBAccessEJB :getBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "Returning getBlob.....[" + dataStr + "]");
        return dataStr;
    }

    private String getXMLTypeStr(Connection con, String query, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        BaseLogger.log("2", null, null, "@@@@ inside getXMLTypeStr with query :[ " + query + " ] bindVarValues :[ " + bindVarValues.toString() + " ] bindVarTypes :[ " + bindVarTypes + " ]");
        String dataStr = "";
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    String string = dataStr = rs.getString(1) == null ? "" : rs.getString(1);
                }
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DBAccessEJB :getXMLTypeStr :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return dataStr;
    }

    private ArrayList getProcessInstanceInfo(String refSer, String refId, String lineNo, Connection mConnection) throws ITMException {
        BaseLogger.log("3", null, null, "Inside getProcessInstanceInfo ... ");
        Statement pStmt = null;
        ResultSet rs = null;
        ArrayList<String> processInstList = new ArrayList<String>();
        try {
            try {
                String processInstanceId = null;
                String prcIdSelQry = "SELECT PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ?";
                WorkflowLogger.info("Executing Process Id Select Query :[" + prcIdSelQry + "] refSer [" + refSer + "] refId [" + refId + "] lineNo [" + lineNo + "]");
                pStmt = mConnection.prepareStatement(prcIdSelQry);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refId);
                pStmt.setInt(3, Integer.parseInt(lineNo.trim()));
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    processInstanceId = rs.getString("PRC_INST__WF");
                }
                if (processInstanceId == null || processInstanceId.length() <= 0) {
                    throw new Exception("No Process Instance Id found for current Activity");
                }
                processInstList.add(processInstanceId);
                processInstList.add(WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId));
                processInstList.add(WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId));
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
                WorkflowLogger.info("Setting processInstanceId [" + processInstanceId + "] processId [" + WorkflowProcessIdGenerator.getInstance().getProcessId(processInstanceId) + "] instanceId [" + WorkflowProcessIdGenerator.getInstance().getInstanceId(processInstanceId) + "]");
            }
            catch (ITMException be) {
                throw be;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignTransEJB :getUserXSLFileName :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return processInstList;
    }

    private String getRefSerFromTransetup(String objName, Connection mConnection) throws RemoteException, ITMException {
        WorkflowLogger.info("[SignManagerEJB]getRefSer() called for objName :[" + objName + "]");
        Statement mStmt = null;
        ResultSet rs = null;
        String refSer = null;
        try {
            try {
                String sqlQuery = null;
                sqlQuery = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName + "'";
                WorkflowLogger.info("[SignManagerEJB]Fetching refSer from TRANSETUP for the current object : Query :\n" + sqlQuery);
                mStmt = mConnection.prepareStatement(sqlQuery);
                rs = mStmt.executeQuery();
                if (rs.next()) {
                    refSer = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :RSUpdateSign :getRefSer :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :RSUpdateSign :getRefSer :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return refSer != null ? refSer.trim() : refSer;
    }

    private String getWorkFlowOpt(String objName, Connection conLocal) throws RemoteException, ITMException {
        String wrkFlwOpt = "0";
        Statement mStmt = null;
        try {
            try {
                objName = objName.startsWith("w_") ? objName : "w_" + objName;
                String sqlQuery = "SELECT WORKFLOW_OPT FROM TRANSETUP WHERE TRAN_WINDOW='" + objName + "'";
                mStmt = conLocal.prepareStatement(sqlQuery);
                ResultSet rs = mStmt.executeQuery();
                while (rs.next()) {
                    wrkFlwOpt = rs.getString("WORKFLOW_OPT");
                }
                rs.close();
                rs = null;
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                try {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                }
                catch (Exception exp) {
                    WorkflowLogger.info("Exception :SignManagerEJB :getWorkFlowOpt :\n" + e.getMessage());
                    throw new ITMException(exp);
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception : SignManagerEJB  :getWorkFlowOpt :==>finally" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return wrkFlwOpt;
    }

    /*
     * Unable to fully structure code
     */
    private String updateObjSignTrans(String refSer, String refID, int lineNo, String signRemarks, String signStatus, Connection conn, String signReason) throws ITMException {
        block18: {
            pstmtObjSignTrans = null;
            innerPstmtObjSignTrans = null;
            rsObjSignTrans = null;
            sqlObjSignTrans = "";
            mQueryObjSignTrans = "";
            isUpdate = "false";
            try {
                genericUtility = new E12GenericUtility();
                sqlObjSignTrans = "db2".equalsIgnoreCase(CommonConstants.DB_NAME) != false ? "SELECT REF_ID,OBJ_NAME,ROLE_CODE__SIGN,PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? " : ("mssql".equalsIgnoreCase(CommonConstants.DB_NAME) != false ? "SELECT REF_ID,OBJ_NAME,ROLE_CODE__SIGN,PRC_INST__WF FROM OBJ_SIGN_TRANS (UPDLOCK) WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? " : "SELECT REF_ID,OBJ_NAME,ROLE_CODE__SIGN,PRC_INST__WF FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? FOR UPDATE NOWAIT");
                pstmtObjSignTrans = conn.prepareStatement(sqlObjSignTrans);
                pstmtObjSignTrans.setString(1, refSer);
                pstmtObjSignTrans.setString(2, refID);
                pstmtObjSignTrans.setInt(3, lineNo);
                rsObjSignTrans = pstmtObjSignTrans.executeQuery();
                if (!rsObjSignTrans.next()) break block18;
                mQueryObjSignTrans = "UPDATE OBJ_SIGN_TRANS SET SIGN_DATE=?,USER_ID__SIGN=?,SIGN_REMARKS=?,SIGN_STATUS = ?, EMP_CODE = ?, SIGN_REASON = ? WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO = ? ";
                innerPstmtObjSignTrans = conn.prepareStatement(mQueryObjSignTrans);
                WorkflowLogger.info("[SignManagerEJB]Updating the curr signature, Query :\n" + mQueryObjSignTrans);
                timeStamp = new Timestamp(System.currentTimeMillis());
                innerPstmtObjSignTrans.setTimestamp(1, timeStamp);
                innerPstmtObjSignTrans.setString(2, this.userInfo.getLoginCode());
                innerPstmtObjSignTrans.setString(3, signRemarks);
                innerPstmtObjSignTrans.setString(4, signStatus);
                innerPstmtObjSignTrans.setString(5, this.userInfo.getEmpCode());
                innerPstmtObjSignTrans.setString(6, signReason);
                innerPstmtObjSignTrans.setString(7, refSer);
                innerPstmtObjSignTrans.setString(8, refID);
                innerPstmtObjSignTrans.setInt(9, lineNo);
                updRowNo = innerPstmtObjSignTrans.executeUpdate();
                BaseLogger.log("3", null, null, "@@@@ updRowNo : " + updRowNo);
                if (updRowNo <= 0 || "U".equalsIgnoreCase(signStatus)) ** GOTO lbl69
                eventManager = new EventManagerEJB();
                eventManager.setUserInfo(this.userInfo);
                isEventFound = eventManager.isEventExist(rsObjSignTrans.getString("OBJ_NAME"), "post_sign", this.userInfo);
                BaseLogger.log("3", null, null, "isEventFound.....:: " + isEventFound);
                if (isEventFound) {
                    dom = null;
                    signxmlDom = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>");
                    signxmlDom.append("<Detail1  objContext = '1' domID='1' >\r\n");
                    signxmlDom.append("<ref_ser><![CDATA[").append(refSer).append("]]></ref_ser>\r\n");
                    signxmlDom.append("<ref_id><![CDATA[").append(refID).append("]]></ref_id>\r\n");
                    signxmlDom.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
                    signxmlDom.append("<sign_status><![CDATA[").append(signStatus).append("]]></sign_status>\r\n");
                    signxmlDom.append("<sign_remarks><![CDATA[").append(signRemarks).append("]]></sign_remarks>\r\n");
                    signxmlDom.append("<emp_code><![CDATA[").append(this.checkNull(this.userInfo.getEmpCode())).append("]]></emp_code>\r\n");
                    signxmlDom.append("<role_code__sign><![CDATA[").append(this.checkNull(rsObjSignTrans.getString("ROLE_CODE__SIGN"))).append("]]></role_code__sign>\r\n");
                    signxmlDom.append("<prc_inst__wf><![CDATA[").append(this.checkNull(rsObjSignTrans.getString("PRC_INST__WF"))).append("]]></prc_inst__wf>\r\n");
                    signxmlDom.append("</Detail1>\r\n");
                    signxmlDom.append("</Root>\r\n");
                    dom = genericUtility.parseString(signxmlDom.toString());
                    responseStr = eventManager.executeSystemEvent(rsObjSignTrans.getString("OBJ_NAME"), "post_sign", null, dom, dom, this.getXtraParams(), "1", conn);
                    BaseLogger.log("3", null, null, "responseStr ::" + responseStr);
                    if (responseStr.indexOf("Errors") != -1) {
                        var23_23 = responseStr;
                        return var23_23;
                    }
                }
                try {
                    eventManager = null;
lbl69:
                    // 2 sources

                    if (updRowNo > 0) {
                        isUpdate = "true";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (rsObjSignTrans != null) {
                        rsObjSignTrans.close();
                        rsObjSignTrans = null;
                    }
                    if (pstmtObjSignTrans != null) {
                        pstmtObjSignTrans.close();
                        pstmtObjSignTrans = null;
                    }
                    if (innerPstmtObjSignTrans != null) {
                        innerPstmtObjSignTrans.close();
                        innerPstmtObjSignTrans = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        return isUpdate;
    }

    public String getSignStatus(String refSer, String refID, int lineNo) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        StringBuffer retStringBuff = new StringBuffer("<SIGN_DETAILS>");
        boolean isConnLocal = false;
        String signStatus = "";
        try {
            try {
                BaseLogger.log("3", null, null, "get Sign Status ");
                String query = "SELECT SIGN_STATUS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? AND LINE_NO  = ? ";
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                pStmt = this.conn.prepareStatement(query);
                pStmt.setString(1, refSer);
                pStmt.setString(2, refID);
                pStmt.setInt(3, lineNo);
                rs = pStmt.executeQuery();
                String lastSignRemarks = "";
                if (rs.next()) {
                    signStatus = rs.getString("SIGN_STATUS");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                retStringBuff.append("<SIGN_STATUS>").append(signStatus).append("</SIGN_STATUS></SIGN_DETAILS>");
                WorkflowLogger.info("[SignManagerEJB] getSignStatus [" + retStringBuff.toString() + "] ");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSignStatus :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (this.conn != null && isConnLocal) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getSignStatus :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return retStringBuff.toString();
    }

    private String getUserName(String userIDSign) throws ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        String userName = null;
        try {
            try {
                String mQuery = "SELECT NAME FROM USERS WHERE CODE = ?";
                pStmt = this.conn.prepareStatement(mQuery);
                pStmt.setString(1, userIDSign);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    userName = rs.getString("NAME");
                }
                rs.close();
                rs = null;
                WorkflowLogger.info("[SignManagerEJB]User Name :" + userName + ":");
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getUserName :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :SignManagerEJB :getUserName :==>While cleaning db resources\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "userName>>>>>>>>>>>[" + userName + "]");
        return userName;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String toValidDateString(Date date) throws ITMException, Exception {
        BaseLogger.log("2", null, null, "date[" + date + "]");
        if (date != null) {
            BaseLogger.log("3", null, null, "date is not null[" + date + "]");
            E12GenericUtility genericUtility = new E12GenericUtility();
            String validDateStr = date.toString();
            BaseLogger.log("3", null, null, "validDateStr[" + validDateStr + "]");
            if (this.checkNull(validDateStr).trim().length() > 0) {
                validDateStr = genericUtility.getValidDateString(validDateStr, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
            }
            BaseLogger.log("2", null, null, "validDateStr[" + validDateStr + "]");
            return validDateStr;
        }
        return "";
    }

    private boolean isTransactionAsignedToUser(String loginUser, String roleCode, String entityCode) throws ITMException {
        WorkflowLogger.info("[SignManagerEJB]Getting existance for the login user :" + loginUser + ": against role code :" + roleCode);
        boolean isExist = false;
        int count = 0;
        Statement pStmt = null;
        ResultSet rs = null;
        try {
            String sqlQuery = " SELECT COUNT (*) FROM WF_ROLE_USERS WHERE ROLE_CODE = ? AND USERID = ? ";
            String sqlQuery1 = " SELECT ROLE_TYPE FROM WF_ROLE WHERE ROLE_CODE = ? ";
            String roleType = "";
            WorkflowLogger.info("[SignMangerEJB]Retrieving role type, query :\n" + sqlQuery1);
            pStmt = this.conn.prepareStatement(sqlQuery1);
            pStmt.setString(1, roleCode);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                roleType = rs.getString("ROLE_TYPE");
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pStmt != null) {
                pStmt.close();
                pStmt = null;
            }
            BaseLogger.log("3", null, null, " isTransactionAsignedToUser roleType[" + roleType + "]");
            if ("S".equalsIgnoreCase(roleType)) {
                WorkflowLogger.info("[SignMangerEJB]Retrieving existance roles for the login user, query :\n" + sqlQuery);
                pStmt = this.conn.prepareStatement(sqlQuery);
                pStmt.setString(1, roleCode);
                pStmt.setString(2, loginUser);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                if (count > 0) {
                    isExist = true;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            } else if ("D".equalsIgnoreCase(roleType)) {
                BaseLogger.log("3", null, null, "isTransactionAsignedToUser roleType[" + roleType + "] loginUser[" + loginUser + "] roleCode[" + roleCode + "] entityCode[" + entityCode + "]");
                isExist = true;
            } else {
                BaseLogger.log("3", null, null, "isTransactionAsignedToUser roleType not defined for roleCode[" + roleCode + "]");
                isExist = false;
            }
        }
        catch (Exception e) {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception exp) {
                WorkflowLogger.info("Exception :SignManagerEJB :isTransactionAsignedToUser :\n" + e.getMessage());
                throw new ITMException(exp);
            }
            throw new ITMException(e);
        }
        return isExist;
    }

    private HashMap<String, HashMap<String, String>> getObjDescrAndImageName(String objNameParam, UserInfoBean userInfo) throws ITMException {
        HashMap<String, HashMap<String, String>> itm2InfoHM = new HashMap<String, HashMap<String, String>>();
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet rs = null;
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                String mQuery = " SELECT WIN_NAME, DESCR, ICON_PATH FROM ITM2MENU WHERE WIN_NAME='w_" + objNameParam + "' AND OBJ_TYPE !='I' ";
                BaseLogger.log("3", null, null, "mQuery [" + mQuery + "]");
                mStmt = mConnection.createStatement();
                rs = mStmt.executeQuery(mQuery);
                while (rs.next()) {
                    String objName = this.checkNull(rs.getString("WIN_NAME")).replaceAll("w_", "");
                    String descr = this.checkNull(rs.getString("DESCR"));
                    String iconPath = this.checkNull(rs.getString("ICON_PATH"));
                    if (itm2InfoHM.containsKey(objName.trim())) continue;
                    HashMap<String, String> itm2MenuHM = new HashMap<String, String>();
                    itm2MenuHM.put("DESCR", descr);
                    itm2MenuHM.put("ICON_PATH", iconPath);
                    itm2InfoHM.put(objName.trim(), itm2MenuHM);
                }
                rs.close();
                rs = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :SignManagerEJB :getObjDescAndImageName() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :DBAccessEJB :getTransetupColumnValue() :==>finally" + e.getMessage());
            }
        }
        BaseLogger.log("2", null, null, "Dnyaneshwar :: itm2InfoHM[" + itm2InfoHM + "]");
        return itm2InfoHM;
    }

    private String getChangedXmlString(String objName, String xmlDataBefore, String changeXmlData, String xmlDataAfter, Connection conn) throws ITMException {
        String changedXmlStr = "";
        Document xmlDomBefore = null;
        Object xmlDomAfter = null;
        Document changeXmlDom = null;
        String winName = "w_" + objName;
        StringBuffer changedBuffer = new StringBuffer("<Root>");
        try {
            HashMap titleMap = this.getFormTitles(winName, conn);
            E12GenericUtility genericUtility = new E12GenericUtility();
            if (changeXmlData != null && changeXmlData.indexOf("Header0") == -1) {
                changeXmlData = "<Root><Header0>" + changeXmlData + "</Header0></Root>";
            }
            xmlDomBefore = genericUtility.parseString(xmlDataBefore);
            changeXmlDom = genericUtility.parseString(changeXmlData);
            NodeList headerNodeList = changeXmlDom.getElementsByTagName("Header0");
            Node headerNode = headerNodeList.item(0);
            if (headerNode != null) {
                NodeList headerChlidList = headerNode.getChildNodes();
                int noOfHeaderChlid = headerChlidList.getLength();
                int recCtr = 0;
                while (recCtr < noOfHeaderChlid) {
                    Node detailNode = headerChlidList.item(recCtr);
                    String headerChlidName = detailNode.getNodeName();
                    if (headerChlidName.startsWith("Detail")) {
                        NamedNodeMap detAttrNodesMap = detailNode.getAttributes();
                        String domId = detAttrNodesMap.getNamedItem("domID") != null ? detAttrNodesMap.getNamedItem("domID").getNodeValue() : "";
                        String dbId = detAttrNodesMap.getNamedItem("dbID") != null ? detAttrNodesMap.getNamedItem("dbID").getNodeValue() : "";
                        String objCtx = detAttrNodesMap.getNamedItem("objContext") != null ? detAttrNodesMap.getNamedItem("objContext").getNodeValue() : "1";
                        String formName = this.getFormDetails(titleMap, objCtx, "FORM_NAME");
                        DWObject dwObject = this.getDWObject(objName, Integer.parseInt(objCtx), formName);
                        HashMap phyDispNameMap = dwObject.getPhysicalNameDisplayNameMap();
                        BaseLogger.log("3", null, null, "phyDispNameMap ::" + phyDispNameMap);
                        NodeList detailChlidList = detailNode.getChildNodes();
                        int noOfDeatilChlid = detailChlidList.getLength();
                        int colCtr = 0;
                        while (colCtr < noOfDeatilChlid) {
                            String newValue = "";
                            String oldValue = "";
                            String nodeName = "";
                            Node colNode = detailChlidList.item(colCtr);
                            if (colNode.getFirstChild() != null) {
                                newValue = colNode.getFirstChild().getNodeValue();
                            }
                            nodeName = this.checkNull(colNode.getNodeName());
                            oldValue = this.checkNull(genericUtility.getColumnValue(nodeName, xmlDomBefore, objCtx));
                            String dispName = this.checkNull((String)phyDispNameMap.get(nodeName));
                            String title = this.getFormDetails(titleMap, objCtx, "TITLE");
                            BaseLogger.log("3", null, null, "title =[" + title + "], nodeName =[" + nodeName + "], dispName =[" + dispName + "]");
                            changedBuffer.append("<Detail").append(objCtx).append(" domID='" + domId + "'").append(" title='" + title + "' >");
                            changedBuffer.append("<field_name><![CDATA[").append(nodeName).append("]]>").append("</field_name>");
                            changedBuffer.append("<field_disp_name><![CDATA[").append(dispName).append("]]>").append("</field_disp_name>");
                            changedBuffer.append("<new_value><![CDATA[").append(newValue).append("]]>").append("</new_value>");
                            changedBuffer.append("<old_value><![CDATA[").append(oldValue).append("]]>").append("</old_value>");
                            changedBuffer.append("<chg_mode><![CDATA[").append("Edited").append("]]>").append("</chg_mode>");
                            changedBuffer.append("</Detail" + objCtx + ">");
                            ++colCtr;
                        }
                    }
                    ++recCtr;
                }
            }
            changedBuffer.append("</Root>");
            changedXmlStr = changedBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "changedXmlStr ::" + changedXmlStr);
        return changedXmlStr;
    }

    private HashMap getFormTitles(String winName, Connection conn) throws ITMException {
        Statement pstmtTitle = null;
        ResultSet rsTitle = null;
        HashMap titleMap = new HashMap();
        try {
            try {
                String title = "";
                String formNo = "";
                String formName = "";
                String titleSql = "SELECT FORM_NO, TITLE, FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? ";
                pstmtTitle = conn.prepareStatement(titleSql);
                pstmtTitle.setString(1, winName);
                rsTitle = pstmtTitle.executeQuery();
                while (rsTitle.next()) {
                    ArrayList<String> formDetList = new ArrayList<String>();
                    formNo = this.checkNull(rsTitle.getString("FORM_NO"));
                    title = this.checkNull(rsTitle.getString("TITLE"));
                    formName = this.checkNull(rsTitle.getString("FORM_NAME"));
                    formDetList.add(title);
                    formDetList.add(formName);
                    titleMap.put(formNo, formDetList);
                }
                BaseLogger.log("3", null, null, "Form Titles =[" + titleMap + "]");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rsTitle != null) {
                    rsTitle.close();
                    rsTitle = null;
                }
                if (pstmtTitle != null) {
                    pstmtTitle.close();
                    pstmtTitle = null;
                }
            }
            catch (Exception exception) {}
        }
        return titleMap;
    }

    private String getActivityDetails(String activityCode, Connection conn) throws ITMException {
        StringBuffer valueXmlString = new StringBuffer();
        Statement pStmt = null;
        ResultSet rs = null;
        boolean isConnLocal = false;
        try {
            try {
                if (conn == null) {
                    conn = this.getConnection();
                    isConnLocal = true;
                }
                BaseLogger.log("3", null, null, "In getActivityDetails");
                String query = "SELECT LINE_NO, ACTION_TYPE, ACTION_NAME, ACTION_DESCR, RIGHTS_CHAR, REMARKS_MAN, PASSWORD_REQ, REASON_REQ,  REASON_MAN, ALLOW_DEV_PASSWD  FROM WF_ACTIVITY_ACTIONS  WHERE ACTIVITY_CODE = ? ";
                pStmt = conn.prepareStatement(query);
                pStmt.setString(1, activityCode);
                rs = pStmt.executeQuery();
                String lastSignRemarks = "";
                while (rs.next()) {
                    String lineNo = rs.getString(1);
                    String actionType = rs.getString(2);
                    String reasonMan = rs.getString(9);
                    valueXmlString.append("<ACTION lineNo='" + lineNo + "'>\r\n");
                    valueXmlString.append("<LINE_NO>").append("<![CDATA[" + lineNo + "]]>").append("</LINE_NO>\r\n");
                    valueXmlString.append("<ACTION_TYPE>").append("<![CDATA[" + actionType + "]]>").append("</ACTION_TYPE>\r\n");
                    valueXmlString.append("<ACTION_NAME>").append("<![CDATA[" + rs.getString(3) + "]]>").append("</ACTION_NAME>\r\n");
                    valueXmlString.append("<ACTION_DESCR>").append("<![CDATA[" + rs.getString(4) + "]]>").append("</ACTION_DESCR>\r\n");
                    valueXmlString.append("<RIGHTS_CHAR>").append("<![CDATA[" + rs.getString(5) + "]]>").append("</RIGHTS_CHAR>\r\n");
                    valueXmlString.append("<REMARKS_MAN>").append("<![CDATA[" + rs.getString(6) + "]]>").append("</REMARKS_MAN>\r\n");
                    valueXmlString.append("<PASSWORD_REQ>").append("<![CDATA[" + rs.getString(7) + "]]>").append("</PASSWORD_REQ>\r\n");
                    valueXmlString.append("<REASON_REQ>").append("<![CDATA[" + rs.getString(8) + "]]>").append("</REASON_REQ>\r\n");
                    valueXmlString.append("<ALLOW_DEV_PASSWD>").append("<![CDATA[" + rs.getString(10) + "]]>").append("</ALLOW_DEV_PASSWD>\r\n");
                    valueXmlString.append("<REASON_MAN>").append("<![CDATA[" + reasonMan + "]]>").append("</REASON_MAN>\r\n");
                    if (reasonMan.equalsIgnoreCase("Y")) {
                        valueXmlString.append(this.getReasonCodeDescr(activityCode, actionType, conn));
                    }
                    valueXmlString.append("</ACTION>");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                WorkflowLogger.info("[SignManagerEJB] getActivityDetails [" + valueXmlString.toString() + "] ");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getActivityDetails :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null && isConnLocal) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getActivityDetails :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return valueXmlString.toString();
    }

    @Override
    public String getReasonCodeDescr(String activityCode, String actionType, Connection conn) throws RemoteException, ITMException {
        StringBuffer valueXmlString = new StringBuffer();
        Statement pStmt = null;
        ResultSet rs = null;
        boolean isConnLocal = false;
        try {
            try {
                if (conn == null) {
                    conn = this.getConnection();
                    isConnLocal = true;
                }
                BaseLogger.log("3", null, null, "In getReasonCodeDescr");
                String query = "SELECT REAS_CODE, DESCR, SH_DESCR, ACTIVE  FROM WF_ACTIONS_REASONS  WHERE ACTIVITY_CODE = ?  AND ACTION_TYPE = ? ";
                pStmt = conn.prepareStatement(query);
                pStmt.setString(1, activityCode);
                pStmt.setString(2, actionType);
                rs = pStmt.executeQuery();
                String lastSignRemarks = "";
                while (rs.next()) {
                    valueXmlString.append("<REASON_DET>\r\n");
                    valueXmlString.append("<REAS_CODE>").append("<![CDATA[" + rs.getString(1) + "]]>").append("</REAS_CODE>\r\n");
                    valueXmlString.append("<DESCR>").append("<![CDATA[" + rs.getString(2) + "]]>").append("</DESCR>\r\n");
                    valueXmlString.append("<SH_DESCR>").append("<![CDATA[" + rs.getString(3) + "]]>").append("</SH_DESCR>\r\n");
                    valueXmlString.append("<ACTIVE>").append("<![CDATA[" + rs.getString(4) + "]]>").append("</ACTIVE>\r\n");
                    valueXmlString.append("</REASON_DET>");
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                WorkflowLogger.info("[SignManagerEJB] getReasonCodeDescr [" + valueXmlString.toString() + "] ");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getReasonCodeDescr :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null && isConnLocal) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getReasonCodeDescr :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return valueXmlString.toString();
    }

    @Override
    public String getActivityActionRights(String processId, String activityId) throws RemoteException, ITMException {
        StringBuffer valueXmlString = new StringBuffer();
        Statement pStmt = null;
        ResultSet rs = null;
        boolean isConnLocal = false;
        String activityCode = "";
        try {
            try {
                if (this.conn == null) {
                    this.conn = this.getConnection();
                    isConnLocal = true;
                }
                BaseLogger.log("3", null, null, "In getActivityActionRights");
                valueXmlString.append("<PROCESS_DET>\r\n");
                String query = "SELECT PRC_ACT.ACTIVITY_CODE, ACT.DESCR, ACT.ACTIVITY_TYPE, ACT.INVOKE_SYNC, ACT.CLASS_NAME,  ACT.EXCP_SORT_CLASS  FROM WF_PRC_ACT PRC_ACT, WF_ACTIVITY ACT  WHERE PRC_ACT.ACTIVITY_CODE = ACT.ACTIVITY_CODE  AND PRC_ACT.PROCESS_ID = ?  AND PRC_ACT.ACTIVITY_ID = ? ";
                pStmt = this.conn.prepareStatement(query);
                pStmt.setString(1, processId);
                pStmt.setString(2, activityId);
                rs = pStmt.executeQuery();
                String lastSignRemarks = "";
                if (rs.next()) {
                    activityCode = rs.getString(1);
                    valueXmlString.append("<ACTIVITY_CODE>").append("<![CDATA[" + activityCode + "]]>").append("</ACTIVITY_CODE>\r\n");
                    valueXmlString.append("<DESCR>").append("<![CDATA[" + rs.getString(2) + "]]>").append("</DESCR>\r\n");
                    valueXmlString.append("<ACTIVITY_TYPE>").append("<![CDATA[" + rs.getString(3) + "]]>").append("</ACTIVITY_TYPE>\r\n");
                    valueXmlString.append("<INVOKE_SYNC>").append("<![CDATA[" + rs.getString(4) + "]]>").append("</INVOKE_SYNC>\r\n");
                    valueXmlString.append("<CLASS_NAME>").append("<![CDATA[" + rs.getString(5) + "]]>").append("</CLASS_NAME>\r\n");
                    valueXmlString.append("<EXCP_SORT_CLASS>").append("<![CDATA[" + rs.getString(6) + "]]>").append("</EXCP_SORT_CLASS>\r\n");
                    valueXmlString.append(this.getActivityDetails(activityCode, this.conn));
                }
                rs.close();
                rs = null;
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                valueXmlString.append("</PROCESS_DET>");
                WorkflowLogger.info("[SignManagerEJB] getActivityActionRights [" + valueXmlString.toString() + "] ");
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getActivityActionRights :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (this.conn != null && isConnLocal) {
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                WorkflowLogger.info("Exception :SignManagerEJB :getActivityActionRights :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return valueXmlString.toString();
    }

    private PublishPushNotificationEJB publishPushNotificationEJB() throws BaseException {
        PublishPushNotificationEJB publishPushNotificationEJB = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for PublishPushNotification EJB with Properties==>\n" + p);
            publishPushNotificationEJB = new PublishPushNotificationEJB();
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: publishPushNotificationEJB:==>\n" + e);
            throw new BaseException(e);
        }
        return publishPushNotificationEJB;
    }

    public ArrayList<String> getDBColumnValues(String tableName, String columnName, String condition, String transDB) throws ITMException {
        String sql = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        ArrayList<String> columnValues = new ArrayList<String>();
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                sql = " SELECT " + columnName + " FROM " + tableName + " " + condition;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    columnValues.add(rs.getString(columnName));
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues -- >" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception exp) {
                BaseLogger.log("0", null, null, "Excepton in getDBColumnValues -- >" + exp.getMessage());
                exp.printStackTrace();
                throw new ITMException(exp);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new ITMException(se);
            }
        }
        return columnValues;
    }

    @Override
    public String acknowledge(int lineNo, String refID, String refSer, String objName, String signStatus, String userId, String siteCode, String signRemarks, String chgString, String userInfoStr, String actionCode, String signBy, String signReason) throws RemoteException, ITMException {
        String retString;
        block27: {
            WorkflowLogger.info("[SignManagerEJB]Updating the current signature With single connection..................");
            BaseLogger.log("2", null, null, "9632 --- Updating the current signature With single connection...");
            this.actionCode = actionCode;
            this.objName = objName;
            this.signBy = signBy;
            retString = "";
            Object processId = null;
            boolean isError = false;
            E12GenericUtility genericutility = new E12GenericUtility();
            try {
                try {
                    this.userInfo = new UserInfoBean(userInfoStr);
                    if (this.conn == null) {
                        this.conn = this.getConnection();
                    }
                    this.conn.setAutoCommit(false);
                    String workflowOpt = this.getWorkFlowOpt(objName, this.conn);
                    String xtraParams = this.getXtraParams();
                    if ((refSer == null || refSer.equalsIgnoreCase("null")) && objName != null && objName.length() > 0) {
                        refSer = this.getRefSerFromTransetup(objName, this.conn);
                    }
                    if (!isError) {
                        if (this.isunsigned(refSer, refID, "" + lineNo, this.conn)) {
                            String updateStr = this.updateObjSignTrans(refSer, refID, lineNo, signRemarks, signStatus, this.conn, signReason);
                            BaseLogger.log("3", null, null, "9688 --Final updateString is updateStr===" + updateStr);
                            if (updateStr != null && "true".equalsIgnoreCase(updateStr)) {
                                retString = "Success";
                            } else {
                                isError = true;
                                genericutility.generateLog("Record Not Found For refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "]", "", String.valueOf(processId) + refID, false);
                                retString = updateStr;
                            }
                        } else {
                            isError = true;
                            genericutility.generateLog("Sign Status of refSer[" + refSer + "]refID[" + refID + "]lineNo[" + lineNo + "] is U", "", String.valueOf(processId) + refID, false);
                            retString = "SignStatus is not U";
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    isError = true;
                    try {
                        if (this.conn != null) {
                            if (isError) {
                                this.conn.rollback();
                            } else {
                                WorkflowLogger.info("Connection commit succesfully");
                                this.conn.commit();
                            }
                            this.conn.close();
                            this.conn = null;
                        }
                        break block27;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ITMException(e);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.conn != null) {
                        if (isError) {
                            this.conn.rollback();
                        } else {
                            WorkflowLogger.info("Connection commit succesfully");
                            this.conn.commit();
                        }
                        this.conn.close();
                        this.conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (this.conn != null) {
                    if (isError) {
                        this.conn.rollback();
                    } else {
                        WorkflowLogger.info("Connection commit succesfully");
                        this.conn.commit();
                    }
                    this.conn.close();
                    this.conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        WorkflowLogger.info("[SignManagerEJB]Return String from update sign:");
        BaseLogger.log("2", null, null, "9836---" + retString + ":");
        return retString;
    }

    private String getTransInfoXMLTypeStr(String refSer, String refID, int lineNo, String addWhereClauseBuff, String userInfo) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            String query = "SELECT OST.TRANS_INFO_XML.getClobval() FROM OBJ_SIGN_TRANS OST WHERE " + addWhereClauseBuff;
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            transInfo = this.getDBAccessObj().getXMLTypeStr(query, bindVarValues, bindVarTypes, userInfo);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getTransInfo(String refSer, String refID, int lineNo, String addWhereClauseBuff, String userInfo) throws RemoteException, ITMException {
        String transInfo = "";
        try {
            UserInfoBean userInfoBean = new UserInfoBean(userInfo);
            String query = "SELECT TRANS_INFO FROM OBJ_SIGN_TRANS WHERE " + addWhereClauseBuff;
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(refSer);
            bindVarValues.add("" + lineNo);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("Int");
            BaseLogger.log("3", null, null, "Getting BLOB from DBAccessEJB in SignManagerEJB getTransInfo3");
            transInfo = this.getDBAccessObj().getBlob(query, bindVarValues, bindVarTypes, userInfoBean);
            StringBuffer xmlStrBuff = new StringBuffer();
            if (transInfo != null && transInfo.trim().length() != 0) {
                if (transInfo.trim().indexOf("<DocumentRoot") != -1 && transInfo.trim().indexOf("<Root") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<DocumentRoot>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                } else if (transInfo.trim().indexOf("<Root") != -1 && transInfo.trim().indexOf("<DocumentRoot") == -1) {
                    transInfo = transInfo.substring(transInfo.indexOf("<Root>"), transInfo.length());
                    xmlStrBuff.append(transInfo);
                    transInfo = xmlStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :SignManagerEJB :getTransInfo :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return transInfo;
    }

    private String getRowNumAppendQuery(String query, int fromRowNumber, int upToRowNumber) {
        StringBuffer sb = new StringBuffer("SELECT outer.* FROM (SELECT ROWNUM rn, inner.* FROM ( ");
        try {
            sb.append(query);
            sb.append(") INNER ) OUTER WHERE ");
            sb.append("outer.rn >= '" + fromRowNumber + "' ");
            sb.append("AND ");
            sb.append("outer.rn   <= '" + upToRowNumber + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "[getRowNumAppendQuery]Exception-" + e.getMessage());
        }
        return sb.toString();
    }

    private String getFormDetails(HashMap objFormDetMap, String formNo, String fieldName) {
        String fieldVal = "";
        ArrayList formDetList = (ArrayList)objFormDetMap.get(formNo);
        if ("TITLE".equalsIgnoreCase(fieldName)) {
            fieldVal = this.checkNull((String)formDetList.get(0));
        } else if ("FORM_NAME".equalsIgnoreCase(fieldName)) {
            fieldVal = this.checkNull((String)formDetList.get(1));
        }
        return fieldVal;
    }

    private JSONObject getJSONActionData(String rightsChar) {
        JSONArray mainArray;
        JSONObject mainJsonObject;
        block11: {
            block10: {
                mainJsonObject = new JSONObject();
                mainArray = new JSONArray();
                if (rightsChar != null) break block10;
                BaseLogger.log("3", null, null, "rightsChar is null.");
                return null;
            }
            if (rightsChar == null) break block11;
            rightsChar = rightsChar.trim();
            BaseLogger.log("3", null, null, "rightsChar has no value.");
            if (rightsChar.length() != 0) break block11;
            return null;
        }
        try {
            String eventHandler = String.valueOf(File.separator) + "ibase" + File.separator + "WebITMRSUpdateSign";
            char[] rightsCharArray = rightsChar.toCharArray();
            int i = 0;
            while (i < rightsCharArray.length) {
                JSONObject jsonObject = null;
                String rightsCharacter = "" + rightsCharArray[i];
                if ("R".equalsIgnoreCase(rightsCharacter)) {
                    jsonObject = this.getJsonActionInfo("R", "R", "Reject", "R", "-1", "Reject", "reject.png", eventHandler);
                }
                if ("S".equalsIgnoreCase(rightsCharacter)) {
                    jsonObject = this.getJsonActionInfo("A", "A", "Approve", "A", "1", "Approve", "approve.png", eventHandler);
                }
                if ("K".equalsIgnoreCase(rightsCharacter)) {
                    jsonObject = this.getJsonActionInfo("K", "K", "Acknowledge", "K", "0", "Acknowledge or GOTIT", "acknowledge.png", eventHandler);
                }
                if (jsonObject != null) {
                    mainArray.add(i, (Object)jsonObject);
                }
                ++i;
            }
            BaseLogger.log("3", null, null, "size of action array::[" + mainArray.size() + "]");
            if (mainArray.size() > 0) {
                mainJsonObject.put((Object)"Actions", (Object)mainArray);
                return mainJsonObject;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[getJSONActionData]Exception-" + e.getMessage());
        }
        return null;
    }

    private JSONObject getJsonActionInfo(String actionId, String actionType, String actionEnum, String rightsChar, String actionPos, String actionText, String actionIcon, String eventHandler) {
        try {
            JSONObject mainJsonObject = new JSONObject();
            mainJsonObject.put((Object)Actions.action_id, (Object)actionId);
            mainJsonObject.put((Object)Actions.action_type, (Object)actionType);
            mainJsonObject.put((Object)Actions.action_enum, (Object)actionEnum);
            mainJsonObject.put((Object)Actions.rights_char, (Object)rightsChar);
            mainJsonObject.put((Object)Actions.action_pos, (Object)actionPos);
            mainJsonObject.put((Object)Actions.action_text, (Object)actionText);
            mainJsonObject.put((Object)Actions.action_icon, (Object)actionIcon);
            mainJsonObject.put((Object)Actions.event_handler, (Object)eventHandler);
            return mainJsonObject;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[getJsonActionInfo]Exception-" + e.getMessage());
            return null;
        }
    }

    private NodeList getHeadNodeList(String transInfo, Document transDom, String nodeName) {
        NodeList headerNodeList = null;
        boolean detailNodeFound = false;
        try {
            if (transInfo.indexOf("<" + nodeName + ">") != -1) {
                headerNodeList = transDom.getElementsByTagName(nodeName);
                Node headerNode = headerNodeList.item(0);
                NodeList headerChlidList = headerNode.getChildNodes();
                int noOfHeaderChlid = headerChlidList.getLength();
                int recCtr = 0;
                while (recCtr < noOfHeaderChlid) {
                    String headerChlidName;
                    Node headerChlidNode = headerChlidList.item(recCtr);
                    if (headerChlidNode != null && (headerChlidName = headerChlidNode.getNodeName()).startsWith("Detail")) {
                        detailNodeFound = true;
                        break;
                    }
                    ++recCtr;
                }
                if (!detailNodeFound) {
                    headerNodeList = null;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[getHeadNodeName]Exception-" + e.getMessage());
        }
        return headerNodeList;
    }

    private static enum Actions {
        action_id,
        action_type,
        action_enum,
        rights_char,
        action_pos,
        action_text,
        action_icon,
        event_handler;

    }
}

