/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataStatefulEJB;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowProcessIdGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateWFDataUtility {
    public String updateWFPrcData(String prcInstId, String objName, String refId, String refSer) throws RemoteException, ITMException {
        String query = null;
        String xmlData = null;
        String returnStr = "";
        Connection conn = null;
        Element docElement = null;
        Statement pStmt = null;
        ArrayList objFormsDetailList = null;
        ArrayList<String> bindVarValues = new ArrayList<String>();
        ArrayList<String> bindVarTypes = new ArrayList<String>();
        try {
            try {
                BaseLogger.log("3", null, null, "updateWFPrcData :: prcInstId =[" + prcInstId + "], objName =[" + objName + "], refId =[" + refId + "], refSer =[" + refSer + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                String processId = WorkflowProcessIdGenerator.getInstance().getProcessId(prcInstId);
                String instanceId = WorkflowProcessIdGenerator.getInstance().getInstanceId(prcInstId);
                BaseLogger.log("3", null, null, "updateWFPrcData :: processId =[" + processId + "], instanceId =[" + instanceId + "]");
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                objFormsDetailList = dbAccessEJB.getObjFormsDetailList(objName);
                dbAccessEJB = null;
                MasterDataStatefulEJB masterdatastatefulEJB = new MasterDataStatefulEJB();
                String transDomString = masterdatastatefulEJB.getXMLFromDBForEdit(objName, "2", objFormsDetailList.size(), refId, this.getHeaderPKFieldTypes(objName), null, null, refSer, "");
                Document dataDom = genericUtility.parseString(transDomString);
                if (dataDom != null) {
                    docElement = dataDom.getDocumentElement();
                }
                xmlData = genericUtility.serializeDom(docElement);
                query = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?)  WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                bindVarValues.clear();
                bindVarValues.add(processId.trim());
                bindVarValues.add(instanceId.trim());
                bindVarValues.add("$XML_DATA_ALL");
                bindVarTypes.clear();
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                boolean updateStatus = this.updateXMLTypeStr(conn, query, xmlData, bindVarValues, bindVarTypes);
                masterdatastatefulEJB = null;
                BaseLogger.log("3", null, null, "@@@@ updateCnt in updateXMLType :: => [" + updateStatus + "]");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnStr;
    }

    public String updateWFPrcData(String processId, String instanceId, String activityId, String seqId, String resultXmlStr, Connection conn) throws ITMException {
        String query = null;
        String returnStr = "";
        Statement pStmt = null;
        ArrayList<String> bindVarValues = new ArrayList<String>();
        ArrayList<String> bindVarTypes = new ArrayList<String>();
        boolean isLocalConn = false;
        try {
            try {
                BaseLogger.log("3", null, null, "overloaded updateWFPrcData :: \nprocessId =[" + processId + "], \ninstanceId =[" + instanceId + "], \nactivityId =[" + activityId + "], \nseqId =[" + seqId + "], \nresultXmlStr =[" + resultXmlStr + "]");
                if (conn == null) {
                    conn = this.getConnection();
                    isLocalConn = true;
                }
                this.createWfPrcDataTrail(processId, Integer.parseInt(instanceId), activityId, resultXmlStr, conn);
                query = "UPDATE WF_PRC_DATA SET ARGUMENT_VALUE_XML = XMLType(?)  WHERE PROCESS_ID = ? AND INSTANCE_ID = ? AND ARGUMENT_ID = ?";
                bindVarValues.clear();
                bindVarValues.add(processId.trim());
                bindVarValues.add(instanceId.trim());
                bindVarValues.add("$XML_DATA_ALL");
                bindVarTypes.clear();
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                bindVarTypes.add("String");
                boolean updateStatus = this.updateXMLTypeStr(conn, query, resultXmlStr, bindVarValues, bindVarTypes);
                BaseLogger.log("3", null, null, "@@@@ updateStatus in updateXMLType :: => [" + updateStatus + "]");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (isLocalConn) {
                    if (conn != null) {
                        conn.commit();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnStr;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getHeaderPKFieldTypes(String objName) throws Exception {
        DWObject dwObj = this.getDWObject(objName, 1);
        ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
        StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
        int i = 0;
        while (i < primaryKeyDataTypeList.size()) {
            headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":");
            ++i;
        }
        return headerPKFieldDataTypesBuff.toString();
    }

    private DWObject getDWObject(String objName, int formNo) throws ITMException {
        DWObject dwObject = null;
        try {
            String metaDataFileName = String.valueOf(objName) + "2" + formNo;
            DWFactory dws = new DWFactory();
            dwObject = dws.getDataWindow(metaDataFileName);
        }
        catch (Exception e) {
            WorkflowLogger.info("Exception :UpdateWFDataUtility :getDWObject :" + e);
            throw new ITMException(e);
        }
        return dwObject;
    }

    private boolean updateXMLTypeStr(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws ITMException {
        WorkflowLogger.info("updateXMLTypeStr :: query [" + query + "]");
        WorkflowLogger.info("updateXMLTypeStr :: bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("updateXMLTypeStr :: bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        Statement pStmt = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                dataStr = genericUtility.remAllXmlDec(dataStr);
                if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                    dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                }
                pStmt = con.prepareStatement(query);
                CLOB dataStrXml = CLOB.createTemporary((Connection)con.getMetaData().getConnection(), (boolean)true, (int)10);
                dataStrXml.putString(1L, dataStr);
                pStmt.setClob(1, (Clob)dataStrXml);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 2, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 2, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                int updateCnt = pStmt.executeUpdate();
                BaseLogger.log("3", null, null, "@@@@ updateXMLTypeStr :: updateCnt in updateXMLType =[" + updateCnt + "]");
                if (updateCnt > 0) {
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :UpdateWFDataUtility :updateXMLType :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private Connection getConnection() throws BaseException {
        WorkflowLogger.info("UpdateWFDataUtility.getConnection..........");
        Connection con = null;
        try {
            ConnDriver connDriver = new ConnDriver();
            con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return con;
    }

    public String createWfPrcDataTrail(String processId, int instanceId, String activityId, String processInputParamXML, Connection conn) throws BaseException {
        WorkflowLogger.info("createWfPrcDataTrail..............");
        System.out.println("createWfPrcDataTrail..............");
        String statusString = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        int rowsInserted = 0;
        try {
            String tranId = this.generateTransSeqId(conn);
            System.out.println("createWfPrcDataTrail..tranId =[" + tranId + "]");
            if (tranId != null && !tranId.isEmpty()) {
                String wfPrcSql = "INSERT INTO WF_PRC_DATA_TRAIL (TRAN_ID,PROCESS_ID,INSTANCE_ID,ACTIVITY_ID,ARGUMENT_ID,ARGUMENT_VALUE,ARGUMENT_VALUE_XML,REF_SER,REF_ID) SELECT ?,PROCESS_ID,INSTANCE_ID,?,ARGUMENT_ID,ARGUMENT_VALUE,ARGUMENT_VALUE_XML,REF_SER,REF_ID FROM WF_PRC_DATA WHERE PROCESS_ID = ? AND INSTANCE_ID = ? ";
                try {
                    Throwable throwable = null;
                    Object var12_16 = null;
                    try (PreparedStatement pstmt = conn.prepareStatement(wfPrcSql);){
                        pstmt.setString(1, tranId);
                        pstmt.setString(2, activityId);
                        pstmt.setString(3, processId);
                        pstmt.setInt(4, instanceId);
                        rowsInserted = pstmt.executeUpdate();
                        WorkflowLogger.info("Rows inserted: =[" + rowsInserted + "] ");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new ITMException(e);
                }
            }
            statusString = rowsInserted > 0 ? "true" : "false";
        }
        catch (Exception e) {
            try {
                throw new ITMException(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return statusString;
    }

    private Document parsingFile(String writeFileString) throws BaseException {
        BufferedWriter parseFileWriter = null;
        Document dom = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                double randomNo = Math.random();
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml").createNewFile();
                }
                String parseFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "workflwParseFile" + randomNo + ".xml";
                WorkflowLogger.info("writeParsingFile:parseFileName[" + parseFileName + "]");
                parseFileWriter = new BufferedWriter(new FileWriter(parseFileName));
                parseFileWriter.write(writeFileString);
                parseFileWriter.flush();
                parseFileWriter.close();
                parseFileWriter = null;
                dom = genericUtility.parseFile(parseFileName);
            }
            catch (Exception e) {
                dom = null;
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (parseFileWriter != null) {
                    parseFileWriter.flush();
                    parseFileWriter.close();
                    parseFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                parseFileWriter = null;
            }
        }
        return dom;
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws BaseException {
        WorkflowLogger.info("query [" + query + "]");
        WorkflowLogger.info("bindVarTypes [" + bindVarTypes + "]");
        WorkflowLogger.info("bindVarValues [" + bindVarValues + "]");
        boolean updStatus = false;
        PreparedStatement pStmt = null;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    Blob mapBlob = rs.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ((dataStr = genericUtility.remAllXmlDec(dataStr)) != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    } else {
                        dataByteArray = dataStr.getBytes();
                    }
                    WorkflowLogger.info("blobOutputStream :[" + blobOutputStream + "]");
                    WorkflowLogger.info("dataByteArray :[" + dataByteArray + "]");
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :WorkflowProcessDataManger :updateBlob :==>finally\n" + e.getMessage());
                throw new BaseException(e);
            }
        }
        return updStatus;
    }

    private String generateTransSeqId(Connection conn) throws Exception {
        String tranId = "";
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            tranId = "" + genericUtility.getSeqNextVal(conn, "WF_PRC_DATA_TRAIL_SEQ");
            if (!tranId.isEmpty()) {
                tranId = String.format("%012d", Integer.parseInt(tranId));
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return tranId;
    }
}

