/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

public class ResourceImageServiceUtility {
    private String imageFieldValue;
    private String altImageFieldValue;
    private Connection connectionObject;
    private boolean isOval;
    private UserInfoBean userInfo = null;
    static InfinispanLocal infinispanLocalObj = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response getResourceImage(String fldValue, String object, String objName, String altFldValue, String tokenIDfromHeader, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        session = request.getSession();
        if (this.userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            session.setAttribute("userInfo", (Object)this.userInfo);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + this.userInfo + "]");
        }
        Connection connectionObject = null;
        BaseLogger.log("3", null, null, "XXXXXXXXCustomMenuImageServletXXXXXXXXXXXXXX");
        String value = fldValue;
        String alt_Fld_Value = altFldValue;
        String docAttachType = ResourceImageServiceUtility.checkNull(request.getParameter("docAttachType"));
        String bgColor = ResourceImageServiceUtility.checkNull(request.getParameter("bg_color"));
        response.setHeader("Cache-Control", "max-age=86400, public");
        this.imageFieldValue = ResourceImageServiceUtility.checkNull(value);
        this.altImageFieldValue = ResourceImageServiceUtility.checkNull(alt_Fld_Value);
        String refSer = ResourceImageServiceUtility.checkNull(this.getRefSer(object, connectionObject, this.userInfo));
        String docId = "";
        if (refSer.length() > 0) {
            docId = ResourceImageServiceUtility.checkNull(this.getDocID(refSer, value, docAttachType, connectionObject, this.userInfo.getTransDB()));
        }
        if (!"".equalsIgnoreCase(docId) && docId.length() > 0) {
            String action = "GET_DOCUMENT";
            String docType = "image/png";
            String path = "WebITMDocumentHandlerServlet?CUSTOM_IMG_ACTION=" + action + "&CUSTOM_IMG_DOC_ID=" + docId + "&CUSTOM_IMG_DOC_TYPE=" + docType + "&fldValue=" + value;
            RequestDispatcher rd = request.getRequestDispatcher(path);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        if (this.fileExist(value, object)) {
            File f = new File(String.valueOf(CommonConstants.RIALITE_PROFILE_PATH) + File.separator + object + File.separator + value + ".png");
            BufferedImage bi = ImageIO.read(f);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi, "png", baos);
                byte[] byteArray = baos.toByteArray();
                Response response2 = Response.ok((Object)new ByteArrayInputStream(byteArray)).type("image/png").build();
                return response2;
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :CustomMenuImageServlet : Unable write image : " + e.getMessage());
                ImageIO.setUseCache(false);
                return null;
            }
        }
        BufferedImage bi = this.createLabelImage(value, alt_Fld_Value, bgColor);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            byte[] byteArray = baos.toByteArray();
            Response response3 = Response.ok((Object)new ByteArrayInputStream(byteArray)).type("image/png").build();
            return response3;
        }
        catch (Exception e) {
            try {
                BaseLogger.log("0", this.userInfo, null, "Exception :CustomMenuImageServlet : Unable write image : " + e.getMessage());
                ImageIO.setUseCache(false);
                return null;
            }
            catch (Exception e2) {
                BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet : ==>\n" + e2.getMessage());
                try {
                    response.setHeader("Cache-Control", "max-age=86400, public");
                    BufferedImage bi2 = this.createLabelImage(this.imageFieldValue, this.altImageFieldValue, "");
                    ImageIO.setUseCache(false);
                    return null;
                }
                catch (Exception e1) {
                    BaseLogger.log("3", this.userInfo, null, "IOException in CustomMenuImageServlet: " + e1.getMessage());
                    return null;
                }
            }
            finally {
                try {
                    if (connectionObject != null && !connectionObject.isClosed()) {
                        connectionObject.close();
                        connectionObject = null;
                    }
                }
                catch (SQLException e3) {
                    BaseLogger.log("0", this.userInfo, null, "Exception in CustomMenuImage closing main connectionObject ===>" + e3.getMessage());
                    e3.printStackTrace();
                    throw new ITMException(e3);
                }
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (SQLException sqlException) {
                BaseLogger.log("3", this.userInfo, null, "Exception in CustomMenuImage closing main connectionObject ===>" + sqlException.getMessage());
            }
        }
    }

    public static String checkNull(String value) {
        if (value == "undefined" || value == null || "null".equalsIgnoreCase(value)) {
            value = "";
        }
        return value.trim();
    }

    private String getRefSer(String objName, Connection connectionObject, UserInfoBean userInfo) {
        String sql = "";
        String refSer = "";
        PreparedStatement pstmtDescr = null;
        ResultSet rs = null;
        boolean isLocalConnection = false;
        Connection mConnection = connectionObject;
        try {
            try {
                if (mConnection == null) {
                    ConnDriver mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(userInfo.getTransDB());
                    isLocalConnection = true;
                }
                sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
                pstmtDescr = mConnection.prepareStatement(sql);
                pstmtDescr.setString(1, "w_" + objName);
                rs = pstmtDescr.executeQuery();
                if (rs.next()) {
                    refSer = rs.getString("REF_SER");
                }
                BaseLogger.log("3", userInfo, null, "REF_SER for[" + this.imageFieldValue + "] == [" + refSer + "]");
            }
            catch (SQLException e) {
                e.printStackTrace();
                BaseLogger.log("3", userInfo, null, "SQLException inside CustomMenuImageServlet getRefSer : [" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                        pstmtDescr = null;
                    }
                    if (mConnection != null && isLocalConnection) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("3", userInfo, null, "Exception inside CustomMenuImageServlet getRefSer : [" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                        pstmtDescr = null;
                    }
                    if (mConnection != null && isLocalConnection) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                    pstmtDescr = null;
                }
                if (mConnection != null && isLocalConnection) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception exception) {}
        }
        return refSer;
    }

    private String getDocID(String refSer, String refId, String docTypeAttach, Connection connectionObject, String transDB) throws ITMException {
        String sql = "";
        String docId = "";
        PreparedStatement pstmtDescr = null;
        ResultSet rs = null;
        boolean isLocalConnection = false;
        Connection mConnection = connectionObject;
        try {
            try {
                if (mConnection == null) {
                    ConnDriver mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    isLocalConnection = true;
                }
                sql = "SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_SER = ? AND REF_ID = ? AND DOC_TYPE_ATTACH = ? AND (DELETE_FLAG <> 'Y' OR DELETE_FLAG IS NULL)";
                pstmtDescr = mConnection.prepareStatement(sql);
                pstmtDescr.setString(1, refSer);
                refId = refId != null ? refId.trim() : refId;
                pstmtDescr.setString(2, refId);
                if (docTypeAttach != null && docTypeAttach.length() > 0) {
                    pstmtDescr.setString(3, docTypeAttach);
                } else {
                    pstmtDescr.setString(3, "Icon");
                }
                rs = pstmtDescr.executeQuery();
                while (rs.next()) {
                    docId = rs.getString("DOC_ID");
                    BaseLogger.log("3", null, null, "===>DOC_ID for refId[" + refId + "==" + docId + "]");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "SQLException inside CustomMenuImageServlet getDocID : [ " + e.getMessage() + " ]");
                throw new ITMException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception inside CustomMenuImageServlet getDocID : [ " + e.getMessage() + " ]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmtDescr != null) {
                        pstmtDescr.close();
                        pstmtDescr = null;
                    }
                    if (mConnection != null && isLocalConnection) {
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet getDocID : ==>\n[" + refId + "]" + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                    pstmtDescr = null;
                }
                if (mConnection != null && isLocalConnection) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet getDocID : ==>\n[" + refId + "]" + e.getMessage());
            }
        }
        return docId;
    }

    private boolean fileExist(String value, String object) {
        boolean flag = true;
        try {
            String path = String.valueOf(CommonConstants.RIALITE_PROFILE_PATH) + File.separator + object + File.separator + value + ".png";
            BaseLogger.log("3", null, null, "CustomImage servlet path[" + path + "]");
            File f = new File(path);
            flag = f.exists();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet fileExist : ==>\n" + e.getMessage());
        }
        return flag;
    }

    public BufferedImage createLabelImage(String value, String alt_Fld_Value, String bgColor) {
        int width = 100;
        int height = 100;
        BufferedImage bi = new BufferedImage(width, height, 2);
        try {
            Graphics2D g = bi.createGraphics();
            String text = "";
            if (!"".equalsIgnoreCase(ResourceImageServiceUtility.checkNull(alt_Fld_Value))) {
                text = ResourceImageServiceUtility.checkNull(this.dynamicMenuImage(alt_Fld_Value));
            }
            if ("".equalsIgnoreCase(text)) {
                text = ResourceImageServiceUtility.checkNull(this.dynamicMenuImage(value));
            }
            int centerX = 50;
            int centerY = 50;
            int ovalWidth = 100;
            int ovalHeight = 100;
            Font font = new Font("TimesRoman", 0, 50);
            g.setFont(font);
            if ("green".equalsIgnoreCase(bgColor)) {
                g.setColor(Color.decode("#3abf62"));
            } else if ("red".equalsIgnoreCase(bgColor)) {
                g.setColor(Color.decode("#ff6a6a"));
            } else {
                g.setColor(Color.decode("#cfbebe"));
            }
            BaseLogger.log("3", null, null, "this.isOval - [" + this.isOval + "]");
            if (this.isOval) {
                g.fillOval(centerX - ovalWidth / 2, centerY - ovalHeight / 2, ovalWidth, ovalHeight);
            } else {
                g.fillRect(centerX - ovalWidth / 2, centerY - ovalHeight / 2, ovalWidth, ovalHeight);
            }
            FontMetrics fm = g.getFontMetrics();
            double textWidth = fm.getStringBounds(text, g).getWidth();
            g.setColor(Color.WHITE);
            g.drawString(text, (int)((double)centerX - textWidth / 2.0), centerY + fm.getMaxAscent() / 2 - 2);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet createLabelImage : ==>\n" + e.getMessage());
        }
        return bi;
    }

    private String dynamicMenuImage(String objDescr) {
        StringBuffer mnIconBuffer = new StringBuffer();
        String[] refSr = null;
        objDescr = objDescr.toUpperCase();
        objDescr = ResourceImageServiceUtility.checkNull(objDescr);
        if ((objDescr = objDescr.trim()) != "") {
            if (objDescr.indexOf(" ") != -1) {
                refSr = objDescr.split(" ");
            } else if (objDescr.indexOf("-") != -1) {
                refSr = objDescr.split("-");
            } else if (objDescr.indexOf("_") != -1) {
                refSr = objDescr.split("_");
            } else if (objDescr.indexOf(":") != -1) {
                refSr = objDescr.split(":");
            }
            String menuStr = "";
            if (refSr != null) {
                int i = 0;
                while (i < refSr.length) {
                    if (mnIconBuffer.length() < 2 && ResourceImageServiceUtility.checkNull(refSr[i]) != "") {
                        menuStr = refSr[i];
                        if ((menuStr = menuStr.trim()) != ":" && !"".equalsIgnoreCase(menuStr)) {
                            boolean flag = false;
                            int indx = 0;
                            while (indx < menuStr.length()) {
                                char dummyChar = menuStr.charAt(indx);
                                String dummyStr = Character.toString(dummyChar);
                                flag = this.isSpecialChar(dummyStr);
                                if (!flag && dummyStr.trim().length() > 0) {
                                    mnIconBuffer.append(dummyChar);
                                    break;
                                }
                                ++indx;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                mnIconBuffer.append(objDescr.charAt(0));
            }
        }
        String menuIconPath = mnIconBuffer.toString();
        return menuIconPath;
    }

    private boolean isSpecialChar(String value) {
        Pattern p = Pattern.compile("[^a-z0-9 ]", 2);
        Matcher m = p.matcher(value);
        boolean b = m.find();
        return b;
    }

    public Response getMenuImageIcon_old(String fileName, String tokenIDfromHeader, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "getMenuImageIcon Service called ");
        String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "images" + File.separator + "galaxy" + File.separator + fileName;
        File file = new File(filePath);
        BaseLogger.log("3", null, null, "FilePath :" + filePath);
        if (file.exists()) {
            BaseLogger.log("3", null, null, "File exists:" + fileName);
            StreamingOutput fileStream = output -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream in = new FileInputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        output.write(buffer, 0, bytesRead);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            };
            return Response.ok((Object)fileStream, (String)"image/png").header("Content-Disposition", (Object)("inline; filename=\"" + file.getName() + "\"")).build();
        }
        BaseLogger.log("3", null, null, "File not exists:" + fileName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"File not found").build();
    }

    public Response getMenuImageIcon(String fileName, String tokenIDfromHeader, HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log("3", null, null, "getMenuImageIcon Service called");
        String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "images" + File.separator + "galaxy" + File.separator + fileName;
        File file = new File(filePath);
        BaseLogger.log("3", null, null, "Checking FilePath: " + filePath);
        if (file.exists()) {
            BaseLogger.log("3", null, null, "File exists: " + fileName);
            StreamingOutput fileStream = output -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileInputStream in = new FileInputStream(file);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            output.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    BaseLogger.log("3", null, null, "Error while streaming file: " + e.getMessage());
                }
            };
            return Response.ok((Object)fileStream, (String)"image/png").header("Content-Disposition", (Object)("inline; filename=\"" + file.getName() + "\"")).build();
        }
        filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "images" + File.separator + "menuImages" + File.separator + "web" + File.separator + "Galaxy" + File.separator + fileName;
        BaseLogger.log("3", null, null, "Checking FilePath2: " + filePath);
        File imgFile = new File(filePath);
        if (imgFile.exists()) {
            BaseLogger.log("3", null, null, "File exists: " + fileName);
            StreamingOutput fileStream = output -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileInputStream in = new FileInputStream(imgFile);){
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            output.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    BaseLogger.log("3", null, null, "Error while streaming file: " + e.getMessage());
                }
            };
            return Response.ok((Object)fileStream, (String)"image/png").header("Content-Disposition", (Object)("inline; filename=\"" + file.getName() + "\"")).build();
        }
        BaseLogger.log("3", null, null, "File not exists: " + fileName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"File not found").build();
    }
}

