/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.ejb.UserEventLogEJB;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ProfileServiceEJB;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProfileServiceServlet
extends HttpServlet {
    private ProfileServiceEJB profileService = null;
    private String defaultProfilePath = "/tmp/Profile.xml";
    private static final String defaultUserId = "99999";
    private UserEventLogEJB userEventLogEJB = null;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block14: {
            String userId = "";
            String action = "";
            String tempEditorId = "";
            String loginCode = "";
            String sessionId = "";
            UserInfoBean userInfo = null;
            Date startTime = null;
            try {
                this.userEventLogEJB = new UserEventLogEJB();
                String output = "";
                action = req.getParameter("action");
                userId = req.getParameter("userId");
                tempEditorId = "" + new Date().getTime();
                startTime = new Date();
                userInfo = (UserInfoBean)req.getSession().getAttribute("USER_INFO");
                loginCode = userInfo.getLoginCode();
                sessionId = userInfo.getSesstionId();
                if (action != null) {
                    this.profileService = new ProfileServiceEJB();
                    if (action.equals("GETTABS")) {
                        if (this.userEventLogEJB != null && userInfo != null) {
                            this.userEventLogEJB.setEventLog(loginCode, userId, sessionId, tempEditorId, "Get Tabs", action, startTime, null, "userId:[" + userId + "]", "Not Applicable", "Pending", "SA", "");
                        }
                        if (userId != null && userId.trim().length() > 0) {
                            this.defaultProfilePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "resource" + File.separator + userId + File.separator + "Profile.xml";
                        }
                        output = this.profileService.getXMLForTabs(userId, this.defaultProfilePath, defaultUserId, userInfo.getTransDB(), userInfo);
                        if (this.userEventLogEJB != null && userInfo != null) {
                            this.userEventLogEJB.updateEventLog(userInfo.getLoginCode(), userId, sessionId, tempEditorId, "Get Tabs", action, startTime, new Date(), "userId:[" + userId + "]", "Not Applicable", "Success", "SA", "");
                        }
                    } else if (action.equals("UPDATEPOS")) {
                        String posXmlStr = req.getParameter("positionXML");
                        try {
                            this.profileService.saveScreenPositions(userId, posXmlStr, userInfo);
                            output = "SUCCESS";
                        }
                        catch (Exception e) {
                            output = String.valueOf(Messages.getString("ProfileServiceServlet_err")) + e.getMessage();
                        }
                    } else if (action.equals("GETLOCALITY_DASHBOARD")) {
                        double longitude = Double.parseDouble(req.getParameter("LONGITUDE"));
                        double lattitude = Double.parseDouble(req.getParameter("LATTITUDE"));
                        BaseLogger.log("3", userInfo, null, "action is GETLOCALITY_DASHBOARD : " + longitude + ":" + lattitude);
                        output = this.profileService.getDashboardLocacity(longitude, lattitude, userId, userInfo);
                        BaseLogger.log("3", userInfo, null, "Response String GETLOCALITY_DASHBOARD [" + output + "]");
                    } else {
                        output = "ERR: INVALID ACTION REQUEST";
                    }
                }
                ServletOutputStream os = resp.getOutputStream();
                os.write(output.getBytes(CommonConstants.ENCODING));
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                ITMException ie = new ITMException(e);
                if (!action.equals("GETTABS") || this.userEventLogEJB == null || userInfo == null) break block14;
                this.userEventLogEJB.updateEventLog(loginCode, userId, sessionId, tempEditorId, "Get Tabs", "GETTABS", startTime, new Date(), "userId:[" + userId + "]", "Not Applicable", "Exception", "SA", ie.getMessage());
            }
        }
    }
}

