package ibase.webitm.bean.wsfa;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;

import javax.servlet.http.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import java.io.*;
import java.util.HashMap;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
public class StrgBrandActBean 
{

	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public StrgBrandActBean( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	public StrgBrandActBean( String objName) throws ITMException
	{
		try
		{
			this.objName = objName;
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public StrgBrandActBean() throws ITMException
	{
	}
	// added by rupali on 16/08/8 foe multi-tenancy related changes [start]
	public UserInfoBean getUserInfo()
	{
		return this.userInfo;
	}
	public void setUserInfo(UserInfoBean userInfo) 
	{
		System.out.println("getUserInfo"+userInfo);
		this.userInfo = userInfo;
		System.out.println("getUserInfo"+userInfo);
	}
	// added by rupali on 16/08/8 foe multi-tenancy related changes [end]
	
	public String getPrdCode( String salesPers, String selectedItem) throws ITMException
	{
		String prdCode = "";
		//StrgMeetWizardRemote itmWizardRemoteTemp = null;
		Connection connectionObject = null; // added by rupali on 16/08/8 foe multi-tenancy related changes
		try
		{
			connectionObject = getConnection(); // added by rupali on 16/08/8 foe multi-tenancy related changes [start]
			prdCode = getPeriod( salesPers, selectedItem);
			String xslFileName = getXSLFileName( "strg_brand_act_prdcode_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			System.out.println("xslFileName......"+xslFileName);
			prdCode = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, prdCode, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgEventActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		return prdCode;
	
	}
	// added by hariom on 02/04/2020 for manager can change data his sales persons [start]
	public String getSalesPerson( String salesPers, String selectedItem ) throws ITMException
	{
		String prdCode = "";
		Connection connectionObject = null; 
		try
		{
			connectionObject = getConnection(); 
			prdCode = getSalesPersonData( salesPers,selectedItem);
			String xslFileName = getXSLFileName( "strg_brand_act_salesperson_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			System.out.println("xslFileName......"+xslFileName);
			prdCode = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, prdCode, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgEventActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		return prdCode;
	
	}
	// added by hariom on 02/04/2020 for manager can change data his sales persons [end]

	public String getPeriod( String sprsCode, String selectedPrdCode ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try 
		{
			// commented and added by rupali on 16/08/8 foe multi-tenancy related changes [start]
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverITM");*/
			connectionObject = getConnection();
			// commented and added by rupali on 16/08/8 foe multi-tenancy related changes [end]
			//Added and commented By Nilesh As per the Prasad Chipte they want only one year of period code of data Start :: 24-05-18
			//sql = "SELECT CODE, DESCR FROM PERIOD ";
			sql="SELECT A.CODE AS CODE ,A.DESCR AS DESCR FROM PERIOD A WHERE A.CODE BETWEEN TO_CHAR(ADD_MONTHS(SYSDATE,-12),'YYYYMM') AND TO_CHAR(ADD_MONTHS(SYSDATE,0),'YYYYMM') ORDER BY CODE DESC";
			//Added  and commented By Nilesh As per the Prasad Chipte they want only one year of period code of data Start :: 24-05-18
			System.out.println(" selectteam sql [" + sql + "]");
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				String prdCode = rs.getString("CODE");
				String prdCodeDescr = rs.getString("DESCR");
				selectedPrdCode = (selectedPrdCode != null) ? selectedPrdCode.trim() : selectedPrdCode;
				prdCode = (prdCode != null) ? prdCode.trim() : prdCode;
				if (selectedPrdCode.equals(prdCode)) 
				{
					valueXmlString.append("<PERIOD domID='" + num	+ "' selected = 'Y'>\r\n");
				} 
				else 
				{
					valueXmlString.append("<PERIOD domID='" + num	+ "' selected = 'N'>\r\n");
				}

				valueXmlString.append("<PRD_CODE><![CDATA[").append(prdCode).append("]]></PRD_CODE>\r\n");
				valueXmlString.append("<PRD_DESCR><![CDATA[").append(prdCodeDescr).append("]]></PRD_DESCR>\r\n");
				valueXmlString.append("</PERIOD>\r\n");
				num++;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :StrgBrandActBean :getPeriod(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgBrandActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	private String getErrorMsg(String xmlErrString) 
			throws ITMException,Exception
		{
			DocumentBuilderFactory docBuilderFactory = null;
			DocumentBuilder docBuilder = null;
			Document dom = null;
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";

			String message = "";
			String description = "";
			String type = "";
			String errString = "";
			InputStream inputStream = null ;
			//Commented and Changes done by Gaurav Singh on 03-Sep-14
			ibase.webitm.utility.GenericUtility genericUtility = null;
			//ibase.utility.E12GenericUtility genericUtility = null;
			try
			{
					docBuilderFactory = DocumentBuilderFactory.newInstance();
					docBuilder = docBuilderFactory.newDocumentBuilder();
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString :: "+xmlErrString);
					//Commented and Changes done by Gaurav Singh on 03-Sep-14
					genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
					//genericUtility = new ibase.utility.E12GenericUtility();
					dom = genericUtility.parseString(xmlErrString);
					System.out.println("ConfirmDARBean :[getErrorMsg] :: xmlErrString after parsing :: "+dom.toString());
					
					System.out.println("Dom prepared...");
					parentNodeList = dom.getElementsByTagName("error");
					int parentListLength = parentNodeList.getLength();
					for(int prntNo = 0; prntNo < parentListLength ; prntNo++)
					{
						parentNode = parentNodeList.item(prntNo);
						if (parentNode!=null )
						{
							childNodeList = parentNode.getChildNodes();
							if (childNodeList != null && childNodeList.getLength() > 0 )
							{
								int childNodeListLength = childNodeList.getLength();
								for(int ctr = 0; ctr < childNodeListLength; ctr++)
								{
									childNode = childNodeList.item(ctr);
									childNodeName = childNode.getNodeName();
									if (childNode != null && childNode.getFirstChild() != null )
									{
										if (childNodeName.trim().equalsIgnoreCase("message"))
										{
											message = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("description")) 
										{
											description = childNode.getFirstChild().getNodeValue();
										}
										if	(childNodeName.trim().equalsIgnoreCase("type")) 
										{
											type = childNode.getFirstChild().getNodeValue();
										}
										errString = "<table border = '0'><tr><td> "+message+"</td></tr><tr><td>Descr :"+description;
										if (type!=null && type.trim().equalsIgnoreCase("E"))
										{
											errString = errString + "</td></tr><tr><td>type : Error</td></tr>" ;
										}
										else if (type!=null && type.trim().equalsIgnoreCase("W"))
										{
											errString = errString + "</td></tr><tr>type : warning</td></tr>";
										}
										errString = errString+"</table>" ;
									}
									
								}
							}					
						}
						
					}
				
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
				throw ex;
			}
			System.out.println("returning errorMsg from getErrorMsg(String xmlErrString): "+errString);
			return errString ;
		}
	
		public String checkNull(String input)
		{
			if (input == null || "null".equalsIgnoreCase(input))
			{
				input= "";
			}
			return input.trim();
		}
		// added by rupali on 16/08/8 foe multi-tenancy related changes [start]
		public Connection getConnection()
		{
			Connection conn = null;
			ConnDriver connDriver = new ConnDriver();
			try
			{
				System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfo+"]");
				//System.out.println(" In StrgMeetwizardBean :: getConnection() :: ["+this.userInfoBean+"]");
				if(this.userInfo != null)
				{
					String transDB = this.userInfo.getTransDB();
					System.out.println(" StrgMeetwizardBean getConnection :: transDB :: ["+transDB+"]");
					
					if( transDB != null && transDB.trim().length() > 0 && !"null".equalsIgnoreCase(transDB))
					{
						conn = connDriver.getConnectDB(transDB);
						connDriver = null;
						System.out.println(" StrgMeetwizardBean getConnection :: transDB :: on if condition :["+transDB+"]");
					}
					else
					{
						System.out.println(" StrgMeetwizardBean :: transDB is null :: So that creating connection using DriverITM....");					
						conn = connDriver.getConnectDB("DriverITM");
						connDriver = null;
					}
				}
				else
				{
					System.out.println(" StrgMeetwizardBean :: UserInfo is null :: So that creating connection using DriverITM....");
					conn = connDriver.getConnectDB("DriverITM");
					connDriver = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : [StrgMeetwizardBean][getConnection] :==>\n"+e.getMessage());
				e.printStackTrace();
			}
			return conn;
		}
		// added by rupali on 16/08/8 foe multi-tenancy related changes [end]
		// added by hariom on 02/04/2020 for manager can change data his sales persons [start]
		public String getSalesPersonData( String sprsCode, String selectedSpCode ) throws ITMException
		{
			String sql = "";
			StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			PreparedStatement pstmt2 = null;
			ResultSet rs2 = null;
			
			E12GenericUtility genericUtility = new E12GenericUtility();
			try 
			{
			
				connectionObject = getConnection();
				//Added By Nilesh for showing the FinancialYear Start :: 17-06-19
				/*sql="SELECT A.CODE AS CODE ,A.DESCR AS DESCR FROM PERIOD A WHERE A.CODE BETWEEN TO_CHAR(ADD_MONTHS(SYSDATE,-12),'YYYYMM') AND TO_CHAR(ADD_MONTHS(SYSDATE,0),'YYYYMM') ORDER BY CODE DESC";*/
				sql = "SELECT A.EMP_CODE AS SALES_PERS, LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) AS SP_NAME, CASE WHEN B.LEVEL_NO = 1 THEN 'TLM' WHEN B.LEVEL_NO = 2 THEN 'SLM' WHEN B.LEVEL_NO = 3 THEN 'FLM' WHEN B.LEVEL_NO = 4 THEN 'SO' ELSE ' ' END AS DESIGNATION, B.SH_DESCR AS SH_DESCR,STAN.DESCR AS STAN_DESCR,ST.DESCR AS STATE_DESCR,B.LEVEL_NO, A.RELIEVE_DATE as RELIEVE_DATE FROM EMPLOYEE A, GRADE B,STATION STAN,STATE ST WHERE A.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE START WITH EMP_CODE = ?  CONNECT BY PRIOR EMP_CODE = REPORT_TO) AND A.GRADE = B.GRADE_CODE AND A.STAN_CODE__HQ = STAN.STAN_CODE AND ST.STATE_CODE = STAN.STATE_CODE ORDER BY ST.DESCR,STAN.DESCR,DESIGNATION";
				//Added By Nilesh for showing the FinancialYear End :: 17-06-19
				System.out.println(" selectteam sql [" + sql + "]");
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, sprsCode );
				rs = pstmt.executeQuery();
				int num = 1;
				while (rs.next()) 
				{
					int cnt=0;
					String sprsCodeDB = rs.getString("SALES_PERS");
					System.out.println("sprsCode["+sprsCode+"]");
					String stateDescr = rs.getString("STATE_DESCR");
					String hqDescr = rs.getString("STAN_DESCR"); 
					String reliaveDate=checkNull(rs.getString("RELIEVE_DATE"));
					selectedSpCode = (selectedSpCode != null) ? selectedSpCode.trim() : selectedSpCode;
					sprsCodeDB = (sprsCodeDB != null) ? sprsCodeDB.trim() : sprsCodeDB;
					String sqlRelieve="select COUNT(*) AS CNT from SPRS_ROUTE WHERE SPRS_CODE=? AND STATUS='Y'";
					pstmt2 = connectionObject.prepareStatement(sqlRelieve);
					pstmt2.setString(1, sprsCodeDB );
					rs2 = pstmt2.executeQuery();
					while (rs2.next()) 
					{
						cnt = rs2.getInt("CNT"); 
						System.out.println("  cnt ===="+cnt);
					}
					if (rs2 != null)
					{
						rs2.close();
						rs2 = null;
					}
					if ( pstmt2 != null )
					{
						pstmt2.close();
						pstmt2 = null;
					}
					if ( (cnt > 0  && reliaveDate.trim().length()> 0) || (cnt >= 0  && reliaveDate.trim().length() == 0))
					{
						System.out.println("sprsCodeDB : ["+sprsCodeDB+"]");
						if (selectedSpCode.equals(sprsCodeDB)) 
						{
							valueXmlString.append( "<WORKEDWITH domID='" + num + "' selected = 'Y'>\r\n" );
						}
						else
						{
							valueXmlString.append( "<WORKEDWITH domID='" + num + "' selected = 'N'>\r\n" );
						}

						valueXmlString.append("<SALES_PERS><![CDATA[").append( sprsCodeDB ).append("]]></SALES_PERS>\r\n");
						valueXmlString.append("<STATE_DESCR><![CDATA[").append( stateDescr ).append("]]></STATE_DESCR>\r\n");
						valueXmlString.append("<STAN_DESCR><![CDATA[").append( hqDescr ).append("]]></STAN_DESCR>\r\n");
						valueXmlString.append("<NAME><![CDATA[").append(rs.getString("SP_NAME")).append("]]></NAME>\r\n");				
						valueXmlString.append("<DESIGNATION><![CDATA[").append(rs.getString("DESIGNATION")).append("]]></DESIGNATION>\r\n");				
						valueXmlString.append( "</WORKEDWITH>\r\n" );
						num++;
					}
				}
				//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("Exception :StrgEventActBean :getPeriod(String):"	+ e.getMessage() + ":");
				valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			} 
			finally 
			{
				try 
				{
					if (connectionObject != null && !connectionObject.isClosed()) 
					{					
						connectionObject.close();
						connectionObject = null;
					}
				} 
				catch (Exception e) 
				{
					System.out.println("Exception :StrgEventActBean :getPeriod(String) :==>\n"+ e.getMessage());
					throw new ITMException(e);
				}
			}
			valueXmlString.append("</Root>\r\n");
			System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
			return valueXmlString.toString();
		}
		// added by hariom on 02/04/2020 for manager can change data his sales persons [end]
}