
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.time.temporal.ChronoUnit;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONObject;

import com.fasterxml.jackson.databind.ObjectMapper;

import entities.FeedbackCalendar;
import entities.Holiday;
import entities.Leave;
import entities.PlanSchedule;
@WebServlet("/emp")

public class EmployeeServlet extends HttpServlet{

	EmployeeDao empDao = new EmployeeDao();
	List<String> employeeCodeList = new ArrayList<>();
	List<Report> employeeReportList = new ArrayList<>();
	List<String> selectedEmpCode = new ArrayList<String>();
	List<Employee> empList = new ArrayList<>();
	List<Plan>empPlanList = new ArrayList<>();
	
	private static final long serialVersionUID = 1L;
	
	protected void doGet(HttpServletRequest request,HttpServletResponse response) {
		try {
			empList = empDao.getEmpList();
			request.setAttribute("empList", getList());
			request.setAttribute("reportList", employeeReportList);
			request.setAttribute("empList", empList);
			System.out.println("Employee List="+empList);
			RequestDispatcher dispatcher = request.getRequestDispatcher("index.jsp");
			dispatcher.forward(request, response);

		}catch (Exception e) {
		e.printStackTrace();
		}
	}
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	        throws ServletException, IOException {
		SimpleDateFormat formate = new SimpleDateFormat("yyyy/MM/dd");
		response.setContentType("application/json");
		
		String action = request.getParameter("action");
		
		if(action.equalsIgnoreCase("holiday")) {
			String startDate = request.getParameter("start");
			String endDate = request.getParameter("end");
			//System.out.println("I am holiday"+startDate+" "+endDate);
			List<Holiday>holidays = empDao.getHoliday(startDate, endDate);
			String json = new ObjectMapper().writeValueAsString(holidays);
			response.getWriter().write(json);
			//System.out.println(holidays);
		return;	
		}
		if(action.equalsIgnoreCase("leave")) {
			String startDate = request.getParameter("start");
			String endDate = request.getParameter("end");
			String empCode=request.getParameter("empcode");
			List<Leave>leaves = empDao.getLeave(empCode,startDate, endDate);
			String json = new ObjectMapper().writeValueAsString(leaves);
			response.getWriter().write(json);
			
		return;	
		}
		if(action.equalsIgnoreCase("feedbackcalendar")){
			try {
				
				selectedEmpCode = Arrays.asList(request.getParameterValues("empcode[]"));
				List<String>empcode = new ArrayList<String>();
				String date = request.getParameter("date");
				if(selectedEmpCode.contains(" All")) {
					
					empcode.clear();
					empcode.addAll(empDao.getEmployeeCodes());
				}
				else {
					empcode.addAll(selectedEmpCode);
				}
			
				 date = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(date));
				 DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
				 LocalDate d = LocalDate.parse(date,formatter);
				 LocalDate start = d.withDayOfMonth(1);
				 LocalDate last = d.withDayOfMonth(d.lengthOfMonth());
				 
				 Map<String,List<FeedbackCalendar>> map = new EmployeeDao().getFeedbackCalendar(start, last, empcode);
				 map.entrySet().stream().forEach(e-> System.out.println(e));
				 JSONArray jsonArray = new JSONArray();
				 for(Map.Entry<String, List<FeedbackCalendar>>entry:map.entrySet()) {
					 JSONObject jsonObj = new JSONObject();
					 jsonObj.put(entry.getKey(),entry.getValue());
					 jsonArray.put(jsonObj);
				 }
				 
				//response.setContentType("text/plain;charset=UTF-8");
				//response.getWriter().write(jsonArray.toString());	
				
				 String json = new ObjectMapper().writeValueAsString(map);
				
				 response.getWriter().write(json);	
			} catch (Exception e) {
				e.printStackTrace();
			}			
			return;
		}
		if(action.equalsIgnoreCase("plancalendar")) {
			try {
				selectedEmpCode = Arrays.asList(request.getParameterValues("empcode[]"));
				List<String>empcode = new ArrayList<String>();
				String date = request.getParameter("date");
				if(selectedEmpCode.contains(" All")) {
					empcode.clear();
					empcode.addAll(empDao.getEmployeeCodes());
				}
				else {
					empcode.addAll(selectedEmpCode);
				}
			
				 date = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(date));
				 DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
				 LocalDate d = LocalDate.parse(date,formatter);
				 LocalDate start = d.withDayOfMonth(1);
				 LocalDate last = d.withDayOfMonth(d.lengthOfMonth());
				 Map<String,List<Plan>>map = empDao.getPlanCalendar(start, last, empcode);
				 String json = new ObjectMapper().writeValueAsString(map);
				 response.getWriter().write(json);	
			} catch (Exception e) {
				e.printStackTrace();
			}
			return;
		}
		String requestid = request.getParameter("requestid");
		if(action.equalsIgnoreCase("currentStatus")) {//getting current status
			String empcode =  request.getParameter("empcode");
			
			 response.setContentType("text/plain;charset=UTF-8");			 
				response.getWriter().write(empDao.getEmployeeEmailid(empcode)+" "+ empDao.getCurrentStatus(requestid));
				return;
			}
		selectedEmpCode = Arrays.asList(request.getParameterValues("empCode[]"));
		String dateFrom = request.getParameter("dateFrom");
		String dateTo = request.getParameter("dateTo");		
		try {
			dateFrom = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(dateFrom));
			dateTo = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(dateTo));			
		} catch (ParseException e1) {			
			e1.printStackTrace();
		}
		if(Arrays.asList(request.getParameterValues("empCode[]")).contains(" All")) {
			selectedEmpCode = new ArrayList<String>();
			selectedEmpCode.addAll(empDao.getEmployeeCodes());
		}
		if(action.equalsIgnoreCase("feedback")) {
			employeeReportList .clear();
			employeeReportList =  empDao.getData(selectedEmpCode,dateFrom, dateTo,requestid);
			if(employeeReportList.isEmpty()) {
				response.setContentType("text/plain;charset=UTF-8");
				response.getWriter().write("No data to show");
			}else {
			JSONArray jsonArray = getReport(employeeReportList);
			response.getWriter().write(jsonArray.toString());
			}
		}
		else if(action.equalsIgnoreCase("plan")) {
			empPlanList .clear();
			empPlanList =  empDao.getPlanReport(selectedEmpCode,dateFrom, dateTo,requestid);
			if(empPlanList.isEmpty()) {
				response.setContentType("text/plain;charset=UTF-8");
				response.getWriter().write("No data to show");
			}else {
			JSONArray jsonArray = getPlanReport(empPlanList);
			response.getWriter().write(jsonArray.toString());
			}
		}else if(action.equalsIgnoreCase("plangantt")) {
			empPlanList .clear();
			empPlanList =  empDao.getPlanReport(selectedEmpCode,dateFrom, dateTo,requestid);
			if(empPlanList.isEmpty()) {
				response.setContentType("text/plain;charset=UTF-8");
				response.getWriter().write("No data to show");
			}else {
				List<PlanSchedule>planList = new ArrayList<PlanSchedule>();
				for(Plan plan:empPlanList) {
					PlanSchedule pl = new PlanSchedule();
					pl.setActiondtl(plan.getActiondtl());
					pl.setDate(plan.getDate());
					pl.setDescription(plan.getDescription());
					pl.setEnddate(plan.getEnddate());
					pl.setName(plan.getName());
					pl.setRequestid(plan.getRequestid());
					pl.setTime(plan.getTime());
				}
				empPlanList = getEndDate();
				 String json = new ObjectMapper().writeValueAsString(empPlanList);
				//System.out.println(empPlanList);
			JSONArray jsonArray = getPlanReport(empPlanList);
			
			response.getWriter().write(json);
			}
		}
	
		
	}
	public JSONArray getReport(List<Report> list) {
		JSONArray jsonArray = new JSONArray();
	    try {
	    for(Report rt:list) {	
	    	JSONObject formDetailsJson = new JSONObject();
	    	formDetailsJson.put("person", rt.getPerson());   	
	    	formDetailsJson.put("date", rt.getDate());
	    	
	    	formDetailsJson.put("description", rt.getDescription());
	    	formDetailsJson.put("requestid", rt.getRequestId());
	    	formDetailsJson.put("status", rt.getStatus());
	    	formDetailsJson.put("actiondtl", rt.getActiondtl());
	    	formDetailsJson.put("stdtime", rt.getStdtime());
	    	formDetailsJson.put("startdate", rt.getStartdate());
	    	formDetailsJson.put("timespend",rt.getTimespend());
	    	jsonArray.put(formDetailsJson);
	    }
	    }catch (Exception e) {
			e.printStackTrace();
		}
	
		return jsonArray;
	}
	public JSONArray getPlanReport(List<Plan>list) {
		JSONArray jsonArray = new JSONArray();
		
	    try {
	    for(Plan plan:list) {	    	
	    	JSONObject formDetailsJson = new JSONObject();
	    	formDetailsJson.put("person", plan.getName());   	
	    	formDetailsJson.put("date", plan.getDate());	    	
	    	formDetailsJson.put("requestid", plan.getRequestid());
	    	formDetailsJson.put("description",plan.getDescription());
	    	formDetailsJson.put("time",plan.getTime());
	    	formDetailsJson.put("actiondtl", plan.getActiondtl());
	    
	    	jsonArray.put(formDetailsJson);
	    }
	    }catch (Exception e) {
			e.printStackTrace();
		}
		return jsonArray;
	}
	
	List<String> getList() {
		return empDao.getEmployeeCodeName();
	}
	void getAllParameters(HttpServletRequest req) {
		Enumeration<String> parameterNames = req.getParameterNames();
		while (parameterNames.hasMoreElements()) {
			 
            String paramName = parameterNames.nextElement();          
            String[] paramValues = req.getParameterValues(paramName);
            for (int i = 0; i < paramValues.length; i++) {
                String paramValue = paramValues[i];
               //System.out.println(paramName+"=" + paramValue);                
            }
        }
 
	}	
	public List<Plan>getEndDate(){
		
		DateTimeFormatter formatterStr = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
		List<Holiday>holidays = empDao.getHoliday();
		
		List<Plan>newPlanList = new ArrayList<Plan>();
		for(Plan plan:empPlanList) {
			LocalDate planEndDate = getActualEndDate(plan.getTime(),plan.getDate());
			
			LocalDate start = getLocalDate(plan.getDate());
			int holiday = getHolidatDays(start, planEndDate,holidays);
			
			String name1[] = plan.getName().split("\\(");
			
			String name2[] = name1[1].split("\\)");
			int leave = getLeave(name2[0], start, planEndDate);
			
			if(holiday==leave) {
				plan.setEnddate(formatterStr.format(planEndDate.plusDays(holiday)));
			}
			else if(holiday>leave) {
					plan.setEnddate(formatterStr.format(planEndDate.plusDays((holiday-leave))));
			}else 
					{
						plan.setEnddate(formatterStr.format(planEndDate.plusDays((leave-holiday))));
					}
			//adding weekend dates
			LocalDate planStart=getLocalDate(plan.getDate());
			LocalDate planEnd = getLocalDate(plan.getEnddate());
			int weekend=0;
			for(LocalDate date=planStart;date.isBefore(planEnd.plusDays(1));date=date.plusDays(1)) {
				
				if(date.getDayOfWeek()==DayOfWeek.SATURDAY ){
					weekend=weekend+2;
				}
			}
			planEnd = planEnd.plusDays(weekend);
			plan.setEnddate(formatterStr.format(planEnd));
			
			newPlanList.add(plan);
			
		}
		//System.out.println("After setting leave=>");
		
		
		
		return newPlanList;
	}
	public int getHolidatDays(LocalDate start,LocalDate end,List<Holiday>holidays) {
		int day=0;
		for(Holiday h:holidays) {
			if(h.getStart().isAfter(start)&& h.getStart().isBefore(end.plusDays(1))) {
				day = (int) ChronoUnit.DAYS.between(h.getStart(), h.getEnd().plusDays(1));
			}
		}
		return day;
	}
	public int getLeave(String empcode,LocalDate start,LocalDate end) {
		List<Leave>list = empDao.getLeave(empcode);		
		int day=0;
		for(Leave l:list) {
			if(l.getStartdate().isAfter(start) && l.getStartdate().isBefore(end.plusDays(1))) {	
			day = (int) ChronoUnit.DAYS.between(l.getStartdate(), l.getEnddate().plusDays(1));
			
			}
		}
		
		return day;
	} 
	public LocalDate getLocalDate(String date) {
		SimpleDateFormat formate = new SimpleDateFormat("dd-MMM-yyyy");
		Date d;
		try {
			d = formate.parse(date);
			Calendar cal = Calendar.getInstance();
			cal.setTime(d);
			return LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	LocalDate getActualEndDate(int stdtime, String startDate) {
		try {
			int time = (int) Math.ceil(stdtime / 9);
			SimpleDateFormat formate = new SimpleDateFormat("dd-MMM-yyyy");

			Date dateStart = formate.parse(startDate);
			Calendar cal = Calendar.getInstance();
			cal.setTime(dateStart);
			//cal.add(Calendar.DATE, time);

			LocalDate start = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
			LocalDate end = start.plusDays(time);
			//LocalDate end = new LocalDate();
			int i = 0;
			for (LocalDate date = start; date.isBefore(end); date = date.plusDays(1)) {
				DayOfWeek day = date.getDayOfWeek();
				if (day.getValue() == 6 || day.getValue() == 7) {
					i++;
				}
			}
			time += i;

			LocalDate newEnd = start.plusDays(time);
			//DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
			//return formatter.format(end);
			return newEnd;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	public static void main(String[] args) {
		Map<String, List<String>> map = new HashMap<String,List<String>>();
		for(int i=0;i<5;i++) {
		if(map.containsKey("A")){
			map.get("A").add("List2");
		}
		else {
			ArrayList<String>list = new ArrayList();
			list.add("List1");
			map.put("A",list);
		}
		
		
		}
		System.out.println(map);
	}
}

