/*
 * Decompiled with CFR 0.152.
 */
package ibase.wrkflw.utility;

import ibase.utility.BaseException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.wrkflw.metadata.Activities;
import ibase.wrkflw.metadata.Activity;
import ibase.wrkflw.metadata.Application;
import ibase.wrkflw.metadata.Applications;
import ibase.wrkflw.metadata.ExtendedAttribute;
import ibase.wrkflw.metadata.ExtendedAttributesType;
import ibase.wrkflw.metadata.ExternalPackage;
import ibase.wrkflw.metadata.ExternalPackages;
import ibase.wrkflw.metadata.Package;
import ibase.wrkflw.metadata.Transition;
import ibase.wrkflw.metadata.Transitions;
import ibase.wrkflw.metadata.WorkflowProcess;
import ibase.wrkflw.metadata.WorkflowProcesses;
import ibase.wrkflw.utility.WorkflowLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class WorkflowMetaDataManager {
    private static WorkflowMetaDataManager WFMD_MGR = null;
    private static HashMap WFMD_REPOSITORY = null;
    private static String DEF_METADATA_PATH = null;
    private Package guiLibrary = null;

    private WorkflowMetaDataManager() {
        DEF_METADATA_PATH = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator + "wrkflw";
        WFMD_REPOSITORY = new HashMap();
    }

    public static WorkflowMetaDataManager getInstance() {
        if (WFMD_MGR == null) {
            WFMD_MGR = new WorkflowMetaDataManager();
        }
        return WFMD_MGR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isProcessMetadataExists(String processName) throws BaseException {
        boolean isExists = false;
        try {
            if (processName == null) throw new Exception("Invalid Process Name");
            if (processName.length() <= 0) throw new Exception("Invalid Process Name");
            File metadataFile = this.getMetadataFileObj(processName);
            if (!metadataFile.exists()) throw new Exception("Process Metadata not found");
            if (this.getActivity(processName, processName) == null) throw new Exception("Start Activity undefined");
            return true;
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public WorkflowProcess getWorkflowProcess(String processId) throws Exception {
        WorkflowProcess workflowProcess = null;
        try {
            Package processPkg = this.getWfmdLibrary(processId);
            WorkflowProcesses workflowProcesses = (WorkflowProcesses)processPkg.getWorkflowProcesses();
            List workflowProcessList = workflowProcesses.getWorkflowProcess();
            int noOfProcesses = workflowProcessList.size();
            int prcCtr = 0;
            while (prcCtr < noOfProcesses) {
                workflowProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                if (processId.equals(workflowProcess.getId())) break;
                ++prcCtr;
            }
            if (workflowProcess == null) {
                throw new Exception("Workflow Process Undefined");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return workflowProcess;
    }

    public Activity getActivity(WorkflowProcess workflowProcess, String activityId) throws BaseException {
        Activity activity = null;
        try {
            Activities activities = (Activities)workflowProcess.getActivities();
            List activityList = activities.getActivity();
            int noOfActivities = activityList.size();
            int actCtr = 0;
            while (actCtr < noOfActivities) {
                Activity currActivity = (Activity)activityList.get(actCtr);
                if (currActivity.getId().equals(activityId)) {
                    activity = currActivity;
                    break;
                }
                ++actCtr;
            }
            if (activity == null) {
                throw new Exception("Activity [" + activityId + "] Undefined in Workflow Process");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activity;
    }

    public Activity getActivity(String processId, String activityId) throws BaseException {
        Activity activity = null;
        try {
            Package processPkg = this.getWfmdLibrary(processId);
            WorkflowProcesses workflowProcesses = (WorkflowProcesses)processPkg.getWorkflowProcesses();
            List workflowProcessList = workflowProcesses.getWorkflowProcess();
            WorkflowProcess currProcess = null;
            if (workflowProcessList != null) {
                int noOfProcesses = workflowProcessList.size();
                int prcCtr = 0;
                block3: while (prcCtr < noOfProcesses) {
                    currProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                    if (currProcess.getId().equals(processId)) {
                        Activities activities = (Activities)currProcess.getActivities();
                        List activityList = activities.getActivity();
                        int noOfActivities = activityList.size();
                        int actCtr = 0;
                        while (actCtr < noOfActivities) {
                            Activity currActivity = (Activity)activityList.get(actCtr);
                            if (currActivity.getId().equals(activityId)) {
                                activity = currActivity;
                                break block3;
                            }
                            ++actCtr;
                        }
                        break;
                    }
                    ++prcCtr;
                }
            }
            if (currProcess == null) {
                throw new Exception("Workflow Process [" + processId + "] Undefined");
            }
            if (activity == null && !"ESC_ACTIVITY".equals(activityId)) {
                throw new Exception("Activity [" + activityId + "] Undefined in Workflow Process [" + processId + "]");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activity;
    }

    public ArrayList getAllActivities(String processId) throws BaseException {
        ArrayList<String> allActivitiesList;
        block6: {
            allActivitiesList = new ArrayList<String>();
            try {
                Package processPkg = this.getWfmdLibrary(processId);
                WorkflowProcesses workflowProcesses = (WorkflowProcesses)processPkg.getWorkflowProcesses();
                List workflowProcessList = workflowProcesses.getWorkflowProcess();
                WorkflowProcess currProcess = null;
                if (workflowProcessList == null) break block6;
                int noOfProcesses = workflowProcessList.size();
                int prcCtr = 0;
                while (prcCtr < noOfProcesses) {
                    currProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                    if (currProcess.getId().equals(processId)) {
                        Activities activities = (Activities)currProcess.getActivities();
                        List activityList = activities.getActivity();
                        int noOfActivities = activityList.size();
                        int actCtr = 0;
                        while (actCtr < noOfActivities) {
                            Activity currActivity = (Activity)activityList.get(actCtr);
                            allActivitiesList.add(currActivity.getId());
                            ++actCtr;
                        }
                        break;
                    }
                    ++prcCtr;
                }
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return allActivitiesList;
    }

    public ArrayList getAllActivities(WorkflowProcess workflowProcess) throws BaseException {
        ArrayList<String> allActivitiesList = new ArrayList<String>();
        try {
            Activities activities = (Activities)workflowProcess.getActivities();
            List activityList = activities.getActivity();
            int noOfActivities = activityList.size();
            int actCtr = 0;
            while (actCtr < noOfActivities) {
                Activity currActivity = (Activity)activityList.get(actCtr);
                allActivitiesList.add(currActivity.getId());
                ++actCtr;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allActivitiesList;
    }

    public ArrayList getEndActivitiesList(String processId) throws BaseException {
        ArrayList<String> endActivitiesList = new ArrayList<String>();
        try {
            Package processPkg = this.getWfmdLibrary(processId);
            WorkflowProcesses workflowProcesses = (WorkflowProcesses)processPkg.getWorkflowProcesses();
            List workflowProcessList = workflowProcesses.getWorkflowProcess();
            WorkflowProcess currProcess = null;
            if (workflowProcessList != null) {
                int noOfProcesses = workflowProcessList.size();
                int prcCtr = 0;
                while (prcCtr < noOfProcesses) {
                    currProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                    if (currProcess.getId().equals(processId)) {
                        ExtendedAttributesType extAttrType = currProcess.getExtendedAttributes();
                        if (extAttrType == null) break;
                        List extendedAttributeList = extAttrType.getExtendedAttribute();
                        int noOfExtendedAttribute = extendedAttributeList.size();
                        WorkflowLogger.info("noOfExtendedAttribute [" + noOfExtendedAttribute + "]");
                        int extAttrCtr = 0;
                        while (extAttrCtr < noOfExtendedAttribute) {
                            ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributeList.get(extAttrCtr);
                            WorkflowLogger.info("extendedAttribute.getName() [" + extendedAttribute.getName() + "]");
                            if ("EndOfWorkflow".equalsIgnoreCase(extendedAttribute.getName())) {
                                String attrValue = extendedAttribute.getValue();
                                ArrayList valList = new E12GenericUtility().getTokenList(attrValue, ";");
                                endActivitiesList.add((String)valList.get(1));
                            }
                            ++extAttrCtr;
                        }
                        break;
                    }
                    ++prcCtr;
                }
            }
            if (currProcess == null) {
                throw new Exception("Workflow Process [" + processId + "] Undefined");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return endActivitiesList;
    }

    public Transition getTransition(WorkflowProcess workflowProcess, String transitionId) throws BaseException {
        Transition transition = null;
        try {
            Transitions transitions = (Transitions)workflowProcess.getTransitions();
            List transitionList = transitions.getTransition();
            int noOfTransitions = transitionList.size();
            int tranCtr = 0;
            while (tranCtr < noOfTransitions) {
                Transition currTransition = (Transition)transitionList.get(tranCtr);
                if (currTransition.getId().equals(transitionId)) {
                    transition = currTransition;
                    break;
                }
                ++tranCtr;
            }
            if (transition == null) {
                throw new Exception("Transition [" + transitionId + "] Undefined in Workflow Process");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return transition;
    }

    public Transition getTransition(String processId, String transitionId) throws BaseException {
        Transition transition = null;
        try {
            Package processPkg = this.getWfmdLibrary(processId);
            WorkflowProcesses workflowProcesses = (WorkflowProcesses)processPkg.getWorkflowProcesses();
            List workflowProcessList = workflowProcesses.getWorkflowProcess();
            WorkflowProcess currProcess = null;
            if (workflowProcessList != null) {
                int noOfProcesses = workflowProcessList.size();
                int prcCtr = 0;
                block3: while (prcCtr < noOfProcesses) {
                    currProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                    if (currProcess.getId().equals(processId)) {
                        Transitions transitions = (Transitions)currProcess.getTransitions();
                        List transitionList = transitions.getTransition();
                        int noOfTransition = transitionList.size();
                        int tranCtr = 0;
                        while (tranCtr < noOfTransition) {
                            Transition currTransition = (Transition)transitionList.get(tranCtr);
                            if (currTransition.getId().equals(transitionId)) {
                                transition = currTransition;
                                break block3;
                            }
                            ++tranCtr;
                        }
                        break;
                    }
                    ++prcCtr;
                }
            }
            if (currProcess == null) {
                throw new Exception("Workflow Process [" + processId + "] Undefined");
            }
            if (transition == null) {
                throw new Exception("Transition [" + transitionId + "] Undefined in Workflow Process [" + processId + "]");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return transition;
    }

    public List getTransitionsFromActivity(WorkflowProcess workflowProcess, String activityId) throws BaseException {
        ArrayList<Transition> toActivitytransitionList = null;
        try {
            List transitionList;
            toActivitytransitionList = new ArrayList<Transition>();
            Transitions transitions = (Transitions)workflowProcess.getTransitions();
            if (transitions != null && (transitionList = transitions.getTransition()) != null) {
                int noOfTransitions = transitionList.size();
                int tranCtr = 0;
                while (tranCtr < noOfTransitions) {
                    Transition currTransition = (Transition)transitionList.get(tranCtr);
                    if (currTransition.getFrom().equals(activityId)) {
                        toActivitytransitionList.add(currTransition);
                    }
                    ++tranCtr;
                }
            }
            if (toActivitytransitionList.size() == 0) {
                toActivitytransitionList = null;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return toActivitytransitionList;
    }

    public Application getApplication(WorkflowProcess workflowProcess, String applicationId) throws BaseException {
        Application application = null;
        try {
            Applications applications = (Applications)workflowProcess.getApplications();
            List applicationList = applications.getApplication();
            int noOfApplication = applicationList.size();
            int applicationCtr = 0;
            while (applicationCtr < noOfApplication) {
                Application currApplication = (Application)applicationList.get(applicationCtr);
                if (currApplication.getId().equals(applicationId)) {
                    application = currApplication;
                    break;
                }
                ++applicationCtr;
            }
            if (application == null) {
                String processId = workflowProcess.getId();
                Package processPkg = this.getWfmdLibrary(processId);
                ExternalPackages externalPackages = (ExternalPackages)processPkg.getExternalPackages();
                List extPackgs = externalPackages.getExternalPackage();
                int ctr = 0;
                block4: while (ctr < extPackgs.size()) {
                    ExternalPackage externalPackage = (ExternalPackage)extPackgs.get(ctr);
                    String extProcess = externalPackage.getHref();
                    WorkflowLogger.info("External Package name :[" + extProcess + "]");
                    Package extProcessPkg = this.getWfmdLibrary(extProcess);
                    Applications extApplications = null;
                    if ("Application_Repository.xml".equalsIgnoreCase(extProcess)) {
                        extApplications = (Applications)extProcessPkg.getApplications();
                    } else {
                        WorkflowProcesses workflowProcesses = (WorkflowProcesses)extProcessPkg.getWorkflowProcesses();
                        List workflowProcessList = workflowProcesses.getWorkflowProcess();
                        int noOfProcesses = workflowProcessList.size();
                        int prcCtr = 0;
                        while (prcCtr < noOfProcesses) {
                            WorkflowProcess extWorkflowProcess = (WorkflowProcess)workflowProcessList.get(prcCtr);
                            if (extProcess.equals(workflowProcess.getId())) {
                                extApplications = (Applications)extWorkflowProcess.getApplications();
                                break;
                            }
                            ++prcCtr;
                        }
                    }
                    List extApplicationList = extApplications.getApplication();
                    int noOfExtApplication = extApplicationList.size();
                    int applicationCtr2 = 0;
                    while (applicationCtr2 < noOfExtApplication) {
                        Application currApplication = (Application)extApplicationList.get(applicationCtr2);
                        if (currApplication.getId().equals(applicationId)) {
                            application = currApplication;
                            break block4;
                        }
                        ++applicationCtr2;
                    }
                    ++ctr;
                }
            }
            if (application == null) {
                throw new Exception("Application [" + applicationId + "] Undefined in Workflow Process [" + workflowProcess.getId() + "]");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return application;
    }

    private Package getWfmdLibrary(File fileObj) throws BaseException {
        Package processPkg = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"ibase.wrkflw.metadata");
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            processPkg = (Package)unmarshaller.unmarshal(fileObj);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processPkg;
    }

    private Package getWfmdLibrary(String xpdlFileName) throws Exception {
        Package processPkg = null;
        try {
            File fileObj = this.getMetadataFileObj(xpdlFileName);
            processPkg = this.getWfmdLibrary(fileObj);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return processPkg;
    }

    private File getMetadataFileObj(String fileName) throws BaseException {
        File metadataFileObj = null;
        try {
            if (!fileName.endsWith(".xml")) {
                fileName = String.valueOf(fileName) + ".xml";
            }
            if (fileName.indexOf(File.separator) == -1) {
                fileName = String.valueOf(DEF_METADATA_PATH) + File.separator + fileName;
            }
            metadataFileObj = new File(fileName);
            String strtoRep = "ParticipantType ";
            String repWith = "ParticipantType1 ";
            int index = 0;
            StringBuffer fileContent = new StringBuffer();
            FileInputStream fMainIn = new FileInputStream(metadataFileObj);
            InputStreamReader isr = new InputStreamReader(fMainIn);
            BufferedReader bfr = new BufferedReader(isr);
            String outTempStr = null;
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent = fileContent.append(outTempStr);
                fileContent.append("\n");
            }
            while (fileContent.toString().indexOf(strtoRep) != -1) {
                index = fileContent.toString().indexOf(strtoRep);
                fileContent.replace(index, index + strtoRep.length(), repWith);
                FileOutputStream fos = new FileOutputStream(metadataFileObj);
                byte[] byteArrayOfString = fileContent.toString().getBytes();
                fos.write(byteArrayOfString);
                fos.flush();
                fos.close();
            }
            isr.close();
            fMainIn.close();
            bfr.close();
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return metadataFileObj;
    }

    public String getActivityName(String processId, String activityId) throws BaseException {
        String activityName = "";
        try {
            Activity currentActivity = null;
            currentActivity = this.getActivity(processId, activityId);
            activityName = currentActivity.getName();
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return activityName;
    }
}

