package ibase.webitm.bean.wsfa;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class OrgStructure 
{
	/**
	 * This class contains business logic for getting data from org structure.
	 * 
	 * @author rupali
	 *
	 */
	public ArrayList reportToUp(String empCode, String eventDate, Connection conn) throws ITMException
	{
		ArrayList teamList = new ArrayList();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String reportToUpsql = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String versionId="";
			String sql="SELECT VERSION_ID FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO" ;
			pstmt=conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			rs =pstmt.executeQuery();
			if(rs.next())
			{
				versionId=checkNull(rs.getString("VERSION_ID"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		
			
			String dbName = CommonConstants.DB_NAME;
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				/*reportToUpsql = "SELECT EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE START WITH EMP_CODE = (SELECT EMP_CODE FROM ORG_STRUCTURE WHERE POS_CODE = "+
						"(SELECT POS_CODE__REPTO FROM ORG_STRUCTURE WHERE EMP_CODE = ?)) CONNECT BY PRIOR POS_CODE__REPTO = POS_CODE "+
						"AND ACTIVE = 'Y'";*/
				//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(start) 
				/*reportToUpsql = "SELECT EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE START WITH EMP_CODE = (SELECT EMP_CODE FROM ORG_STRUCTURE WHERE POS_CODE = "+
						"(SELECT POS_CODE__REPTO FROM ORG_STRUCTURE WHERE EMP_CODE = ?) AND ? BETWEEN EFF_DATE AND VALID_UPTO ) CONNECT BY PRIOR POS_CODE__REPTO = POS_CODE "+
						"AND ACTIVE = 'Y' AND ? BETWEEN EFF_DATE AND VALID_UPTO ";*/
				
				/*reportToUpsql = "SELECT DISTINCT EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE O, VERSION V START WITH O.POS_CODE= "+
						 "(SELECT O.POS_CODE__REPTO FROM ORG_STRUCTURE O, VERSION V "+
						 "WHERE EMP_CODE = ? AND O.VERSION_ID= V.VERSION_ID AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO "+
						 "AND O.ACTIVE = 'Y') CONNECT BY PRIOR O.POS_CODE__REPTO = O.POS_CODE "+
						 "AND O.VERSION_ID= V.VERSION_ID AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO AND O.ACTIVE = 'Y' "; */ 
				
				reportToUpsql="SELECT DISTINCT O.EMP_CODE REPORT_TO FROM ORG_STRUCTURE O WHERE O.POS_CODE IN " + 
						" (SELECT OI.POS_CODE FROM ORG_STRUCTURE OI WHERE OI.VERSION_ID=? AND OI.ACTIVE = 'Y' START WITH OI.EMP_CODE = ? CONNECT BY PRIOR OI.POS_CODE__REPTO = OI.POS_CODE) " + 
						" AND O.VERSION_ID=? " + 
						" AND O.ACTIVE = 'Y' AND O.EMP_CODE<> ? " ; 
						
				//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(end)
				
				pstmt = conn.prepareStatement(reportToUpsql);
				pstmt.setString(1, versionId);
				pstmt.setString(2, empCode);
				pstmt.setString(3, versionId);
				pstmt.setString(4, empCode);


			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{
				reportToUpsql ="select DISTINCT REPORT_TO from employee where fn_org_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
				pstmt = conn.prepareStatement(reportToUpsql);
				pstmt.setString(1, empCode);

			}
			//pstmt = conn.prepareStatement(reportToUpsql);
			rs =pstmt.executeQuery();
			while(rs.next())
			{
				String teamMember = checkNull(rs.getString("REPORT_TO"));
				teamList.add(teamMember);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return teamList;
	}
	public ArrayList reportToDown(String empCode, String eventDate,String resignEmp, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList teamList = new ArrayList();
		String reportToDownsql = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String dbName = CommonConstants.DB_NAME;
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(start) 
				/*reportToDownsql = "SELECT EMP_CODE FROM ORG_STRUCTURE START WITH EMP_CODE = ? CONNECT BY PRIOR POS_CODE = POS_CODE__REPTO AND POS_CODE__REPTO IS NOT NULL "+
						"AND ACTIVE = 'Y' AND ? BETWEEN EFF_DATE AND VALID_UPTO " +
						"UNION SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO AND RELIEVE_DATE IS NOT NULL";*/

				if("Y".equalsIgnoreCase(resignEmp))
				{
					reportToDownsql="SELECT DISTINCT EMP_CODE FROM EMPLOYEE WHERE EMP_CODE IN (SELECT O.EMP_CODE FROM ORG_STRUCTURE O,VERSION V START WITH O.EMP_CODE = ? "+ 
							"CONNECT BY PRIOR O.POS_CODE = O.POS_CODE__REPTO AND O.POS_CODE__REPTO IS NOT NULL AND V.VERSION_ID=O.VERSION_ID "+
							"AND O.ACTIVE = 'Y' AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO ) "+
							"UNION "+ 
							//"SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO AND RELIEVE_DATE IS NOT NULL";
							"SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO ";
					
					pstmt = conn.prepareStatement(reportToDownsql);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmt.setString(3, empCode);
				}
				else
				{
					/*reportToDownsql="SELECT DISTINCT EMP_CODE FROM EMPLOYEE WHERE EMP_CODE IN (SELECT O.EMP_CODE FROM ORG_STRUCTURE O,VERSION V START WITH O.EMP_CODE = ? "+ 
							"CONNECT BY PRIOR O.POS_CODE = O.POS_CODE__REPTO AND O.POS_CODE__REPTO IS NOT NULL AND V.VERSION_ID=O.VERSION_ID "+
							"AND O.ACTIVE = 'Y' AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO ) ";*/
					
					reportToDownsql = "SELECT EMP.EMP_CODE FROM EMPLOYEE EMP,ORG_STRUCTURE ORG, VERSION VER WHERE EMP.EMP_CODE IN (SELECT O.EMP_CODE FROM ORG_STRUCTURE O, "+
									  "VERSION V START WITH O.EMP_CODE = ? CONNECT BY PRIOR O.POS_CODE = O.POS_CODE__REPTO "+
							          "AND O.POS_CODE__REPTO IS NOT NULL AND V.VERSION_ID=O.VERSION_ID AND O.ACTIVE = 'Y' AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO ) "+
							          "AND EMP.EMP_CODE = ORG.EMP_CODE AND VER.VERSION_ID=ORG.VERSION_ID AND ORG.ACTIVE = 'Y' AND ? BETWEEN VER.EFF_FROM AND VER.VALID_UPTO ";
					
					pstmt = conn.prepareStatement(reportToDownsql);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					
				}
				//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(END) 

				
				
			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{
				System.out.println("inside db2:::>>>");
				reportToDownsql ="select DISTINCT REPORT_TO AS EMP_CODE from employee where fn_org_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
				pstmt = conn.prepareStatement(reportToDownsql);
			}

			//pstmt = conn.prepareStatement(reportToDownsql);
			pstmt.setString(1, empCode);
			rs =pstmt.executeQuery();
			while(rs.next())
			{
				String teamMember = checkNull(rs.getString("EMP_CODE"));
				teamList.add(teamMember);

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return teamList;
	}
	//Added by mrunalini sinkar to get Report to from org strcuture on 10-01-2019(start)
	public String reportTo(String empCode, String eventDate, Connection conn) throws ITMException
	{
		System.out.println("inside report to in org structure");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String reportTosql = "";
		String reportTo="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			
			//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(start) 
			/*reportTosql = "SELECT EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE  WHERE POS_CODE =(SELECT POS_CODE__REPTO FROM ORG_STRUCTURE WHERE EMP_CODE = ?) " + 
						" AND ? BETWEEN EFF_DATE AND VALID_UPTO AND ACTIVE='Y' ";*/
			
			reportTosql ="SELECT DISTINCT O.EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE O,VERSION V WHERE "+ 
			"POS_CODE =(SELECT O.POS_CODE__REPTO FROM ORG_STRUCTURE O,VERSION V WHERE EMP_CODE = ? AND V.VERSION_ID=O.VERSION_ID "+ 
			"AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO AND O.ACTIVE='Y') AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO AND O.ACTIVE='Y' AND V.VERSION_ID=O.VERSION_ID "; 
			//commented & modified by mrunalini sinkar to add version id condition in org_strucure informed by Gulzar Sir on 15-March-2019(end) 

				
				pstmt = conn.prepareStatement(reportTosql);
				pstmt.setString(1, empCode);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));

				rs =pstmt.executeQuery();
				if(rs.next())
				{
					reportTo = checkNull(rs.getString("REPORT_TO"));
	
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("inside report to in org structure reportTo is["+reportTo+"]");

		}
		catch(Exception e)
		{
			System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getSummaryDetailDcrMeet():==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return reportTo;
	}
	//Added by mrunalini sinkar to get Report to from org strcuture on 10-01-2019(end)

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String getFormattedList( ArrayList dataList )
	{
		String salesPersData = "";
		try
		{
			for (int i = 0; i < dataList.size(); i++) 
			{
				String data = (String) dataList.get(i);
				if(salesPersData == null || salesPersData.trim().length() == 0)
				{
					salesPersData = "'"+data+"'";
				}
				else
				{
					salesPersData = salesPersData + "," + "'"+data+"'";
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return salesPersData;
	}
	public ArrayList reportToUpDown(String empCode, String eventDate, Connection conn) throws ITMException
	{
		ArrayList teamList = new ArrayList();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String reportToUpsql = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String dbName = CommonConstants.DB_NAME;
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				reportToUpsql = "SELECT DISTINCT EMP_CODE AS REPORT_TO FROM ORG_STRUCTURE O, VERSION V START WITH O.POS_CODE= "+
						 "(SELECT O.POS_CODE__REPTO FROM ORG_STRUCTURE O, VERSION V "+
						 "WHERE EMP_CODE = ? AND O.VERSION_ID= V.VERSION_ID AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO "+
						 "AND O.ACTIVE = 'Y') CONNECT BY PRIOR O.POS_CODE__REPTO = O.POS_CODE "+
						 "AND O.VERSION_ID= V.VERSION_ID AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO AND O.ACTIVE = 'Y' "+
						 "UNION "+
						 "SELECT EMP.EMP_CODE AS REPORT_TO FROM EMPLOYEE EMP,ORG_STRUCTURE ORG, VERSION VER WHERE EMP.EMP_CODE IN (SELECT O.EMP_CODE FROM ORG_STRUCTURE O, "+
						 "VERSION V START WITH O.EMP_CODE = ? CONNECT BY PRIOR O.POS_CODE = O.POS_CODE__REPTO "+
				         "AND O.POS_CODE__REPTO IS NOT NULL AND V.VERSION_ID=O.VERSION_ID AND O.ACTIVE = 'Y' AND ? BETWEEN V.EFF_FROM AND V.VALID_UPTO ) "+
				         "AND EMP.EMP_CODE = ORG.EMP_CODE AND VER.VERSION_ID=ORG.VERSION_ID AND ORG.ACTIVE = 'Y' AND ? BETWEEN VER.EFF_FROM AND VER.VALID_UPTO AND EMP.EMP_CODE <> '"+empCode+"'";    
				
				pstmt = conn.prepareStatement(reportToUpsql);
				pstmt.setString(1, empCode);
				pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				pstmt.setString(4, empCode);
				pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{
				reportToUpsql ="select DISTINCT REPORT_TO from employee where fn_org_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
				pstmt = conn.prepareStatement(reportToUpsql);
				pstmt.setString(1, empCode);
			}
			rs =pstmt.executeQuery();
			while(rs.next())
			{
				String teamMember = checkNull(rs.getString("REPORT_TO"));
				teamList.add(teamMember);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :reportToUpDown():==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :reportToUpDown():==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return teamList;
	}
}
