/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.bean;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Patterns {
    ArrayList datePatterns = null;
    ArrayList timestampPatterns = null;
    ArrayList numberPatterns = null;
    ArrayList stringPatterns = null;

    public Patterns() {
        try {
            String patternsFileName = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "Patterns.xml";
            File patternsFile = new File(patternsFileName);
            if (!patternsFile.exists()) {
                FileOutputStream fos = new FileOutputStream(patternsFile);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
                sb.append("\n<Patterns>");
                sb.append("\n\t<DisplayPatterns>");
                sb.append("\n\t\t<DatePatterns>");
                sb.append("\n\t\t\t<pattern><![CDATA[dd/MM/yy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[dd/MM/yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MM/dd/yy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MM/dd/yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[M/d/yy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[yy-MM-dd]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[yyyy-MM-dd]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MMM d, yy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MMM d, yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[dd. MMM. yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MMMMM d, yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[d. MMMMM yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[EEE, MMM d, yy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[EEEEE, MMMMM dd, yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[EEEEE, MMMMM d, yyyy]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MM-dd]]></pattern>");
                sb.append("\n\t\t</DatePatterns>");
                sb.append("\n\t\t<TimestampPatterns>");
                sb.append("\n\t\t\t<pattern><![CDATA[dd/MM/yy hh:mm a]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[dd/MM/yyyy HH:mm:ss]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MM/dd/yy hh:mm a]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[MM/dd/yyyy HH:mm:ss]]></pattern>");
                sb.append("\n\t\t</TimestampPatterns>");
                sb.append("\n\t\t<NumberPatterns>");
                sb.append("\n\t\t\t<pattern><![CDATA[0]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[0.00]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[#,##0]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[#,##0.00]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[#,###.00]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[0%]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[0.00%]]></pattern>");
                sb.append("\n\t\t</NumberPatterns>");
                sb.append("\n\t\t<StringPatterns>");
                sb.append("\n\t\t\t<pattern><![CDATA[Default]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[UPPERCASE]]></pattern>");
                sb.append("\n\t\t\t<pattern><![CDATA[Lowercase]]></pattern>");
                sb.append("\n\t\t</StringPatterns>");
                sb.append("\n\t</DisplayPatterns>");
                sb.append("\n</Patterns>");
                fos.write(sb.toString().getBytes(CommonConstants.ENCODING));
                fos.flush();
                fos.close();
                this.setPatterns(sb.toString());
            } else {
                this.setPatterns(new E12GenericUtility().parseFile(patternsFileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Patterns(String patternXmlString) {
        this.setPatterns(patternXmlString);
    }

    public void setPatterns(String patternXmlString) {
        try {
            this.setPatterns(new E12GenericUtility().parseString(patternXmlString));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPatterns(Document patternDom) {
        try {
            if (this.datePatterns == null) {
                this.datePatterns = new ArrayList();
            }
            if (this.timestampPatterns == null) {
                this.timestampPatterns = new ArrayList();
            }
            if (this.numberPatterns == null) {
                this.numberPatterns = new ArrayList();
            }
            if (this.stringPatterns == null) {
                this.stringPatterns = new ArrayList();
            }
            this.populatePatternList(patternDom.getElementsByTagName("DatePatterns").item(0).getChildNodes(), this.datePatterns);
            this.populatePatternList(patternDom.getElementsByTagName("TimestampPatterns").item(0).getChildNodes(), this.timestampPatterns);
            this.populatePatternList(patternDom.getElementsByTagName("NumberPatterns").item(0).getChildNodes(), this.numberPatterns);
            this.populatePatternList(patternDom.getElementsByTagName("StringPatterns").item(0).getChildNodes(), this.stringPatterns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populatePatternList(NodeList datePatterns, ArrayList patternList) {
        try {
            if (datePatterns != null) {
                int i = 0;
                while (i < datePatterns.getLength()) {
                    String pattern;
                    Node patternNode = datePatterns.item(i);
                    if (patternNode != null && patternNode.getFirstChild() != null && (pattern = patternNode.getFirstChild().getNodeValue()) != null) {
                        patternList.add(pattern);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getDatePatterns() {
        return this.datePatterns;
    }

    public void setDatePatterns(ArrayList datePatterns) {
        this.datePatterns = datePatterns;
    }

    public ArrayList getNumberPatterns() {
        return this.numberPatterns;
    }

    public void setNumberPatterns(ArrayList numberPatterns) {
        this.numberPatterns = numberPatterns;
    }

    public ArrayList getStringPatterns() {
        return this.stringPatterns;
    }

    public void setStringPatterns(ArrayList stringPatterns) {
        this.stringPatterns = stringPatterns;
    }

    public ArrayList getTimestampPatterns() {
        return this.timestampPatterns;
    }

    public void setTimestampPatterns(ArrayList timestampPatterns) {
        this.timestampPatterns = timestampPatterns;
    }
}

