package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.webitm.utility.ResourceImageServiceUtility;

@Path("/ResourceImageService")

public class ResourceImageService extends RestAPIService {
	
	@GET
    @Produces("image/png")
    @Path("/getResourceImage")
    public Response getResourceImage(
    		@QueryParam("fldValue") String fldValue,
    		@QueryParam("object") String object,
    		@QueryParam("objName") String objName,
    		@QueryParam("ALT_FLD_VALUE") String ALT_FLD_VALUE,
            @HeaderParam("TOKEN_ID") String tokenIDfromHeader,
         //   @FormParam("Reload") String Reload,
            @Context HttpServletRequest request,
            @Context HttpServletResponse response) {
		
		ResourceImageServiceUtility customMenuImageServiceUtility =new ResourceImageServiceUtility();
		//customMenuImageServiceUtility.generateImage(fldValue, object, objName, ALT_FLD_VALUE,tokenIDfromHeader, request, response);

		Response rsResponse = customMenuImageServiceUtility.getResourceImage(fldValue, object, objName, ALT_FLD_VALUE,tokenIDfromHeader,  request, response);
		BaseLogger.log( "3", null, null, "response value  :"+ rsResponse );

        // Ensure the response is OK (status 200) and set the entity to response
        return Response.status(200).entity(rsResponse.getEntity()).build();
		
		
    }
	
	
	@GET
    @Produces("image/png")
    @Path("/getMenuImageIcon")
    public Response getResourceImage(
    		@QueryParam("File_Name") String fileName, @HeaderParam("TOKEN_ID") String tokenIDfromHeader,
            @Context HttpServletRequest request,
            @Context HttpServletResponse response) throws BaseException, Exception 

	{
		ResourceImageServiceUtility customMenuImageServiceUtility =new ResourceImageServiceUtility();
		Response rsResponse = customMenuImageServiceUtility.getMenuImageIcon(fileName   ,tokenIDfromHeader,  request, response);
		BaseLogger.log( "3", null, null, "response value  :"+ rsResponse );


        return Response.status(200).entity(rsResponse.getEntity()).build();

	}
	
	

}
