package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SellInItem extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			BaseLogger.log("3",null,null,"Val xmlString :: " + xmlString );
			BaseLogger.log("3",null,null,"Val xmlString1 :: " + xmlString1 );
			BaseLogger.log("3",null,null,"Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "", sql = "";
		int ctr = 0;
		Date lastClaimDateParse = null;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer(); 

		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
			case 1:

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail1>");

				for( ctr = 0; ctr < childNodeListLength; ctr ++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"childNodeName= "+childNodeName);
					if( childNodeName.equalsIgnoreCase("tran_date") )
					{   
						String tranDate = E12GenericUtility.checkNull( genericUtility.getColumnValue("tran_date", dom) ).trim();
						BaseLogger.log("3",null,null,"tranDate = "+tranDate);
						if( tranDate == null || tranDate.length() <= 0 ) 
						{
							errString = getErrorString("tran_date", "VTBLKCHDTE", userId);
							break;
						}
					}
					else if( childNodeName.equalsIgnoreCase("sc_code") )
					{   
						String scCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("sc_code", dom) ).trim();
						BaseLogger.log("3",null,null,"scCode = "+scCode);
						if( scCode == null || scCode.length() <= 0 ) 
						{
							errString = getErrorString("sc_code", "VTPMSISCNL", userId);
							break;
						}
						else
						{
							//Added by sadique shaikh 28-01-2020 [query change]
							String scCodeSql =  "SELECT COUNT(1) FROM STRG_CUSTOMER WHERE SC_CODE = ?";
							pstmt=conn.prepareStatement(scCodeSql);
							pstmt.setString(1, scCode);
							rs = pstmt.executeQuery();
							int cnt = 0;
							if( rs.next() ) 
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errString = getErrorString("sc_code", "VTPMSISCCD", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					//Commented by sadique shaikh 28-01-2020 [sales person from xml]
					/*else if( childNodeName.equalsIgnoreCase("sales_pers") )
					{   
						String salesPers = E12GenericUtility.checkNull( genericUtility.getColumnValue("sales_pers", dom) ).trim();
						BaseLogger.log("3",null,null,"salesPers = "+salesPers);
						if(salesPers == null || salesPers.length() <= 0) 
						{
							BaseLogger.log("3",null,null,"scCode NULL ");
							errString = getErrorString("sales_pers", "VTSTPSPNUL", userId);
							break;
						}
					}*/
				}
				valueXmlString.append("</Detail1>");	
				break;	

			case 2: 
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail2>");

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if ( childNodeName.equalsIgnoreCase("ITEM_CODE") ) 
					{
						String itemCode = E12GenericUtility.checkNull(genericUtility.getColumnValue("item_code", dom)).trim();
						BaseLogger.log("3",null,null,"itemCode "+itemCode);
						if( itemCode ==null || itemCode.length() <= 0 ) 
						{
							errString = getErrorString("itemCode", "NULLITEM", userId);
							break;
						}
						else
						{
							String sql4 = "SELECT ITEM_CODE FROM ITEM WHERE ITEM_CODE = ?";
							pstmt=conn.prepareStatement(sql4);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();

							if( !rs.next() ) 
							{
								errString = getErrorString("itemCode", "VMITEM1", userId);
								break;
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
				}
				valueXmlString.append("</Detail2>");	
				break;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{ 
			BaseLogger.log("3",null,null,"xmlString"+xmlString);
			dom = parseString(xmlString);
			BaseLogger.log("3",null,null,"xmlString1"+xmlString1);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [ItemLot][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;

		try 
		{
			String sellInUnit = "", tranDate = "";
			
			conn = getConnection();
			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			BaseLogger.log("3",null,null,"[" + getClass().getSimpleName()+ "] currentFormNo: ["+ currentFormNo +"]" );

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			System.out.println("Current time of the day using Date - 12 hour format: " + tranDate);

			String loginCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println("loginCode " + loginCode );

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch (currentFormNo) 
			{
			case 1: 
				valueXmlString.append("<Detail1>");
				if ( currentColumn.trim().equalsIgnoreCase("itm_default") )
				{
					//Change by sadique shaikh on 28-01-2020 [to set tran date] 
					valueXmlString.append("<tran_date><![CDATA["+ tranDate +"]]></tran_date>");
					//valueXmlString.append("<sales_pers protect = \"0\"><![CDATA["+ loginCode +"]]></sales_pers>");
				}
				//Added by sadique shaikh on 28-01-2020 [description column item change] start
				else if ( currentColumn.trim().equalsIgnoreCase( "sc_code" ) ) 
				{
					String descr = "";
					String scCode = genericUtility.getColumnValue("sc_code", dom);
					String sql1 = "SELECT DDF_GET_SC_CODE_NAME(?) AS SC_CODE_NAME FROM DUAL";
					pstmt = conn.prepareStatement(sql1);
					pstmt.setString(1, scCode);
					rs = pstmt.executeQuery();
					if (rs.next()) 
					{
						descr = rs.getString("SC_CODE_NAME");
					}
					valueXmlString.append("<scode_descr protect = \"1\"><![CDATA[" + descr + "]]></scode_descr>");
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				//Added by sadique shaikh on 28-01-2020 [description column item change] End
				valueXmlString.append("</Detail1>");
				break;

			case 2:
				String itmDescr ="";
				valueXmlString.append("<Detail2>");
				BaseLogger.log("3",null,null,"IC CURRENT COLUMN 111 " + currentColumn + "]");

				if ( currentColumn.trim().equalsIgnoreCase("ITEM_CODE") )
				{
					String itemCode = E12GenericUtility.checkNull( genericUtility.getColumnValue("item_code", dom) ).trim();
					BaseLogger.log("3",null,null,"itemCode = "+itemCode);

					if( itemCode != null && itemCode.trim().length()!=0 )
					{
						/*String productSql = "SELECT MKT_ARR FROM PRODUCT WHERE PRODUCT_CODE = (SELECT PRODUCT_CODE FROM ITEM WHERE ITEM_CODE = ?)";
						pstmt = conn.prepareStatement(productSql);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();

						if( rs.next() ) 
						{
							sellInUnit = E12GenericUtility.checkNull(rs.getString("MKT_ARR"));
						}
						BaseLogger.log("3",null,null,"sellInUnit: "+sellInUnit );
						
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						if( sellInUnit.equalsIgnoreCase("Y") )
						{
							BaseLogger.log("3",null,null,"sell_in_value" );
							valueXmlString.append("<sell_in_qty protect = \"1\"><![CDATA[]]></sell_in_qty>");
							valueXmlString.append("<sell_in_value protect = \"0\"><![CDATA[]]></sell_in_value>");
						}
						else
						{
							BaseLogger.log("3",null,null,"sell_in_qty" );
							valueXmlString.append("<sell_in_value protect = \"1\"><![CDATA[]]></sell_in_value>");
							valueXmlString.append("<sell_in_qty protect = \"0\"><![CDATA[]]></sell_in_qty>");
						}*/

						//Added by sadique shaikh on 28-01-2020 [description column item change] start
						String sql1 = "SELECT DDF_GET_ITEM_DESC(?) AS ITEM_DESCR FROM DUAL";
						pstmt = conn.prepareStatement(sql1);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							itmDescr = rs.getString("ITEM_DESCR");
						}
						valueXmlString.append("<item_descr protect = \"1\"><![CDATA[" + itmDescr + "]]></item_descr>");
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						//Added by sadique shaikh on 28-01-2020 [description column item change] End
					}
				}

				valueXmlString.append("</Detail2>");
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0",null,null,"Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
					rs.close();
				if(pstmt != null)
					pstmt.close();
				rs = null;
				pstmt = null;
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
}
