<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
    <%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<!DOCTYPE html>
<html>
<head>
	<meta charset="ISO-8859-1">
	<title>Plan View</title>
	
	<style>
	body{
		margin: auto;
		width: 70%;
		padding: 10px;
	}
	@charset "ISO-8859-1";

body{
	size:100%;
}

.center{
	margin: auto;
	width: 80%;
	padding: 10px;
}
.column {
  float: left;
  width: 50%;
  padding: 10px;
  height: 300px; 
  
}
label{
	font-family: "Google Sans",Arial,sans-serif;
}
#empCode{
	font-family: "Google Sans",Arial,sans-serif;	
	font-size:14px;
}
.navbar{
	/*font-family: "Google Sans",Arial,sans-serif;*/
	font-family: "Roboto",sans-serif;
}
input[type="text"]{
	font-family: "Google Sans",Arial,sans-serif !important;
	font-size:16px;
	width:150px;
	border:1px solid black;
	
}
button{
	font-family: "Google Sans",Arial,sans-serif !important;
	font-size:14px;
}
input[type="date"],select{
	font-family: "Google Sans",Arial,sans-serif !important;
  border: 1px solid #c4c4c4;
  border-radius: 5px;
  background-color: #fff;
  padding: 3px 5px;
  box-shadow: inset 0 3px 6px rgba(0,0,0,0.1);

}
input[type="submit"]{
	font-size: 16px;
}
input[type="button"]{
	font-family: "Google Sans",Arial,sans-serif !important;
}
#tableView{
	margin-top: 20px;
}
table {
    border-collapse: collapse;
   /* margin: 25px 0;*/
    font-size: 0.9em;
    font-family: "Google Sans",Arial,sans-serif !important;
    min-width: 400px;
    box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
}
table thead tr {
    
    text-align: left;
}
table th,table td {
    padding: 12px 15px;
}
table tbody tr {
    border-bottom: 1px solid #dddddd;
}
table tbody tr:nth-of-type(even) {
    background-color: #f3f3f3;
}
table tbody tr.active-row {
    font-weight: bold;
    color: #009879;
}

.head{
	 font-family: "Google Sans",Arial,sans-serif !important;
	background-color:#009879;
	 color: #ffffff;
}
table tbody tr:last-of-type {
    border-bottom: 2px solid #009879;
}

.headmenu {
    width:100%;
    height:100px;
    overflow-x: scroll;
    overflow-y: hidden;
}

.container {
    width:2500px;
}
.grid-container {
	display: table;         
  width: auto;               
  border-spacing: 5px; 
  
}
.div-table-row {
  display: table-row;
  width: auto;
  clear: both;
}
.div-table-col {
  float: left; 
  display: table-column;         
  width: 400px;         
 
}

	
			


</style>
</head>
<body>
  <!-- <form action="planview" method="GET"> --> 
	<div>
	<h1 class="center" id="title" style="text-align:center" >Plan View</h1>
		<!-- <label>Select Employee</label>
		<select name="empCode" id="empCode" onChange="" style="width:150px;">
							<option>Select Employee</option>
							<c:forEach items="${empList}" var="emp">
								<option value="${emp.empcode}">${emp.empcode} ${emp.name }</option>
							</c:forEach>
						</select>
						 -->
	</div>
	<div>
		<div class="tab">
  			<button class="tablinks" onclick="openPage(event, 'plan')">VIEW PLAN</button>
  			<button class="tablinks" onclick="openPage(event, 'feedback')">VIVE FEEDBACK</button>
  			
		</div>

		<!-- Tab content -->
		<div id="plan" class="content" style="display:block; border:3px solid white;">
  			<h3>Today's Plan</h3>
  			<table width=100%>
  				<thead>
  					<tr class="head">
  						<td>Person</td>
  						<td>Date</td>
  						<td>RequestID</td>
  						<td>Details DESC</td>
  						<!-- <td>Action DTL</td> -->
  						<td>STD Time</td>
  					</tr>
  				</thead>
  				<tbody>					
					<c:forEach var="plan" items="${planList}">
						<tr>
							<td><c:out value="${plan.name}" /></td>
							<td><c:out value="${plan.date}" /></td>
							<td><c:out value="${plan.requestid}" /></td>
							<td><c:out value="${plan.description}" /></td>
							<!-- <td><c:out value="${plan.actiondtl}" /></td> -->
							<td><c:out value="${plan.time}" /></td>
							<td></td>
						</tr>
					</c:forEach>
					</tbody>
  			</table>
		</div>

		<div id="feedback" class="content" style="display:none;border:3px solid white;">
  			<h3>Feedback</h3>
  			<table  width=100% id="plantable">
  				<thead>
  					<tr class="head">
  						<td>Person</td>
  						<td>RequestID</td>
  						<td>Feedback Date</td>
  						<td>Details DESC</td>
  						<td>Feedback</td>
  						<td>STD Time</td>
  						<td>Spend Time</td>
  					</tr>
  				</thead>
  				<tbody>					
					<c:forEach var="report" items="${feedbackList}">
						<tr>
							<td><c:out value="${report.person}" /></td>
							<td><c:out value="${report.requestId}" /></td>
							<td><c:out value="${report.date}" /></td>							
							<td><c:out value="${report.description}" /></td>
							<td><c:out value="${report.actiondtl}" /></td>
							<td><c:out value="${report.stdtime}" /></td>
							<td><c:out value="${report.timespend}" /></td>
							<td></td>
						</tr>
					</c:forEach>
					</tbody>
  			</table>
		</div>
	</div>
	
		<!-- </form> -->
</body>
<script type="text/javascript">
function openPage(evt, tabname) {
	
	if(tabname=='plan'){
		var table = document.getElementById("plantable");
		var totalRowCount = table.rows.length;
		var tbodyRowCount = table.tBodies[0].rows.length;
		console.log(tbodyRowCount);
		document.getElementById(tabname).style.display = "block";
		document.getElementById('feedback').style.display = "none";
		document.getElementById('title').innerHTML="Plan View";
	}
	else{
		document.getElementById(tabname).style.display = "block";
		document.getElementById('plan').style.display = "none";
		document.getElementById('title').innerHTML="Feedback View";
	}
	
	}
	
</script>
</html>