/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import java.sql.Connection;
import java.util.HashMap;

public class ConnectionFactory {
    private static ConnectionFactory CONNECTION_FACTORY;
    HashMap driverFileConnectionMap;

    private ConnectionFactory() {
        BaseLogger.log("2", null, null, "ConnectionFactory Invoked");
        this.driverFileConnectionMap = new HashMap();
    }

    public static ConnectionFactory getConnectionFactory() throws BaseException {
        try {
            if (CONNECTION_FACTORY == null) {
                CONNECTION_FACTORY = new ConnectionFactory();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ConnectionFactory :getConnectionFactory :==>" + e.getMessage());
            throw new BaseException(e);
        }
        return CONNECTION_FACTORY;
    }

    public Connection getConnection(String driverFileName) throws BaseException {
        Connection connection = null;
        try {
            connection = (Connection)this.driverFileConnectionMap.get(driverFileName);
            if (connection == null) {
                ConnDriver condriver = new ConnDriver();
                connection = condriver.getConnectDB(driverFileName);
                BaseLogger.log("3", null, null, "creating new Cnnnection for file " + driverFileName);
                this.driverFileConnectionMap.put(driverFileName, connection);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ConnectionFactory :getConnection :==>" + e.getMessage());
            throw new BaseException(e);
        }
        return connection;
    }
}

