/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility;

import ibase.utility.BaseException;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUtility {
    public static Document parseString(String xmlStr) throws BaseException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = docBuilder.parse(new ByteArrayInputStream(xmlStr.getBytes(CommonConstants.ENCODING)));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return doc;
    }

    public static Document parseFile(String fileName) throws BaseException {
        Document doc = null;
        try {
            File fileObj = new XMLUtility().getFileObj(fileName);
            doc = XMLUtility.parseFile(fileObj);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return doc;
    }

    public static Document parseFile(File fileObj) throws BaseException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = docBuilder.parse(fileObj);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return doc;
    }

    public static String serializeDomToString(Document dom) throws BaseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Transformer serializer = null;
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            return out.toString(CommonConstants.ENCODING);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public static String serializeDomToString(Node node) throws BaseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Transformer serializer = null;
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
            serializer.transform(new DOMSource(node), new StreamResult(out));
            return out.toString(CommonConstants.ENCODING);
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public static void serializeDomToFile(Document dom, File outFile) throws BaseException {
        try {
            Transformer serializer = null;
            serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("encoding", CommonConstants.ENCODING);
            serializer.transform(new DOMSource(dom), new StreamResult(outFile));
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public static void serializeDomToFile(Document dom, String outFileName) throws BaseException {
        try {
            File outFileObj = new XMLUtility().getFileObj(outFileName);
            XMLUtility.serializeDomToFile(dom, outFileObj);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    private File getFileObj(String fileName) throws BaseException {
        File fileObj = null;
        try {
            if (!fileName.endsWith(".xml")) {
                fileName = String.valueOf(fileName) + ".xml";
            }
            if (!(fileObj = new File(fileName)).exists()) {
                throw new Exception("XML File to be parsed doesn't exist in :[" + fileObj.getAbsolutePath() + "]");
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return fileObj;
    }
}

