/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.servlet;

import ibase.planner.bean.TransDataProviderBean;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PlannerValidateServlet
extends HttpServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String eventDate = null;
            String retVal = null;
            String isAddPlan = "TRUE";
            String sprsCode = "";
            String loginCode = "";
            String mesg = "Error";
            BaseLogger.log("3", null, null, "******************PlannerValidateServlet Called**************");
            HttpSession session = request.getSession();
            E12GenericUtility genericUtility = new E12GenericUtility();
            TransDataProviderBean transDataProviderBean = new TransDataProviderBean();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            eventDate = request.getParameter("EVENT_DATE");
            if (eventDate == null) {
                isAddPlan = "FALSE";
            } else {
                Date eventDate_date = genericUtility.getDateObject(eventDate.trim());
                UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
                loginCode = userInfo.getLoginCode();
                String empCode = this.checkNull(this.getEmpCode(loginCode, userInfo));
                HashMap paramMap = (HashMap)session.getAttribute("PARAM_MAP");
                if (paramMap != null) {
                    for (String dataPrvdrKeyName : paramMap.keySet()) {
                        String dataPrvdrKeyCheckValue = (String)paramMap.get(dataPrvdrKeyName);
                        if (dataPrvdrKeyName.indexOf("_DS_UA") <= 0) continue;
                        sprsCode = (String)paramMap.get(dataPrvdrKeyName);
                    }
                } else {
                    sprsCode = empCode;
                }
                String planAllowDate = transDataProviderBean.getDeafultAllowDate(sprsCode, userInfo);
                Date planAllowDate_date = simpleDateFormat.parse(planAllowDate);
                BaseLogger.log("3", null, null, "sprsCode => " + sprsCode);
                BaseLogger.log("3", null, null, "loginCode => " + loginCode);
                BaseLogger.log("3", null, null, "eventDate => " + eventDate_date);
                BaseLogger.log("3", null, null, "planAllowDate => " + planAllowDate_date);
                if (!sprsCode.trim().equalsIgnoreCase(empCode.trim()) || eventDate_date.before(planAllowDate_date)) {
                    isAddPlan = "FALSE";
                }
                mesg = !sprsCode.trim().equalsIgnoreCase(empCode.trim()) ? "You are only authorised to View Plan" : "You are not allowed to add / modify plan except from current date, please get HO approval to do so";
            }
            retVal = String.valueOf(isAddPlan) + "@" + mesg;
            BaseLogger.log("3", null, null, "retVal => " + retVal);
            response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(retVal);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : ==>" + e.toString());
            e.printStackTrace();
        }
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }

    public String getEmpCode(String userId, UserInfoBean userInfo) throws ITMException {
        String empCode = "";
        String entityCode = "";
        boolean isLocalConn = false;
        PreparedStatement pstmtSelect = null;
        ResultSet resultSelect = null;
        Connection conn = null;
        try {
            try {
                if (userInfo != null && userInfo.getTransDB() != null) {
                    String transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
                    System.out.println("transDB is" + transDB);
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                }
                String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
                pstmtSelect = conn.prepareStatement(selectMsgDescrSql);
                pstmtSelect.setString(1, userId);
                resultSelect = pstmtSelect.executeQuery();
                if (resultSelect.next()) {
                    empCode = this.checkNull(resultSelect.getString("EMP_CODE"));
                    entityCode = this.checkNull(resultSelect.getString("ENTITY_CODE"));
                }
                if (resultSelect != null) {
                    resultSelect.close();
                    resultSelect = null;
                }
                if (pstmtSelect != null) {
                    pstmtSelect.close();
                    pstmtSelect = null;
                }
                if (empCode == null || empCode.trim().length() == 0) {
                    empCode = entityCode;
                }
            }
            catch (Exception e) {
                System.out.println("Exception :SprsPlanBifurGWTIC:getEmpCode():==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (resultSelect != null) {
                    resultSelect.close();
                    resultSelect = null;
                }
                if (pstmtSelect != null) {
                    pstmtSelect.close();
                    pstmtSelect = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return empCode;
    }
}

