/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSLogger;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSSender {
    public static final String JMS_USERNAME = CommonConstants.JMS_USERNAME;
    public static final String JMS_PASSWORD = CommonConstants.JMS_PASSWORD;
    public static final String JMS_CONNECTION_FACTORY = CommonConstants.JMS_CONNECTION_FACTORY;
    public static final String JMS_QUEUE = CommonConstants.JMS_QUEUE;
    public static final String JMS_QUEUE_WRKFLW = CommonConstants.JMS_QUEUE_WRKFLW;
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueSender qsender;
    private Queue queue;
    private QueueSender qsenderWrkflw;
    private Queue queueWrkflw;
    private TextMessage message;
    private UserInfoBean userInfo;

    public JMSSender(UserInfoBean userInfo) {
        try {
            this.userInfo = userInfo;
            this.init();
            JMSLogger.log("0", userInfo, null, "JMS Ready To Send Messages");
        }
        catch (Exception e) {
            JMSLogger.log("0", userInfo, null, "In JMSSender Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
        }
    }

    public void init() throws NamingException, JMSException, ITMException {
        JMSLogger.log("0", this.userInfo, null, "JMSSender.init()");
        InitialContext ctx = new InitialContext();
        this.qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_CONNECTION_FACTORY);
        this.qcon = this.qconFactory.createQueueConnection(JMS_USERNAME, JMS_PASSWORD);
        this.qsession = this.qcon.createQueueSession(false, 101);
        this.queue = (Queue)ctx.lookup(JMS_QUEUE);
        this.qsender = this.qsession.createSender(this.queue);
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        String msgServName = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ENTERPRISE", "MESSAGE_SERVICE_NAME", " WHERE ENTERPRISE = '" + this.userInfo.getEnterprise() + "'", "Driver"));
        JMSLogger.log("0", this.userInfo, null, "JMSSender.init() enterprise  : [" + this.userInfo.getEnterprise() + "]");
        JMSLogger.log("0", this.userInfo, null, "JMSSender.init() msgServName : [" + msgServName + "]");
        if (msgServName != null && msgServName.length() > 0) {
            this.queue = (Queue)ctx.lookup(msgServName);
            this.qsender = this.qsession.createSender(this.queue);
        }
        this.queueWrkflw = (Queue)ctx.lookup(JMS_QUEUE_WRKFLW);
        this.qsenderWrkflw = this.qsession.createSender(this.queueWrkflw);
        this.message = this.qsession.createTextMessage();
        this.qcon.start();
    }

    public void send(String jmsData) throws JMSException {
        String sendStatus = "S";
        E12GenericUtility genericUtility = new E12GenericUtility();
        String msgType = this.message.getJMSType();
        JMSLogger.log("0", this.userInfo, null, "In JMSSender.send() >>>> msgType : [" + msgType + "] >>> calling jmsLog()..");
        int wqMsgCnt = 0;
        String qMsgStr = " ";
        try {
            genericUtility.jmsLog(jmsData, sendStatus, "", msgType, wqMsgCnt, qMsgStr);
        }
        catch (Exception e) {
            JMSLogger.log("0", this.userInfo, null, "In JMSSender.send() => Exception in genericUtility.jmsLog :[ " + E12GenericUtility.getStackTrace(e) + "]");
        }
        try {
            JMSLogger.log("0", this.userInfo, null, "JMSSender.send() jmsData:[" + jmsData + "]");
            this.message.setText(jmsData);
            if ("WORKFLOW".equals(this.message.getJMSType())) {
                JMSLogger.log("0", this.userInfo, null, "JMSSender.send() QUEUE >> qsenderWrkflw..");
                this.qsenderWrkflw.send((Message)this.message);
            } else {
                JMSLogger.log("0", this.userInfo, null, "JMSSender.send() QUEUE >> qsender..");
                this.qsender.send((Message)this.message);
            }
            this.close();
        }
        catch (Exception e) {
            sendStatus = "E";
            try {
                genericUtility.jmsLog(jmsData, sendStatus, "", msgType, 0, " ");
            }
            catch (Exception e1) {
                JMSLogger.log("0", this.userInfo, null, "In JMSSender.send() => Exception in genericUtility.jmsLog :[ " + E12GenericUtility.getStackTrace(e1) + "]");
            }
            JMSLogger.log("0", this.userInfo, null, "In JMSSender.send() Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
        }
    }

    public void close() throws JMSException {
        JMSLogger.log("0", this.userInfo, null, "JMSSender.close()");
        this.qsender.close();
        this.qsenderWrkflw.close();
        this.qsession.close();
        this.qcon.close();
    }

    public TextMessage getMessage() {
        return this.message;
    }

    public void setMessage(TextMessage message) {
        this.message = message;
    }

    public QueueConnection getConnection() {
        return this.qcon;
    }

    private ArrayList countQueueMessages() {
        ArrayList<Object> qMsgList;
        block24: {
            JMSLogger.log("0", this.userInfo, null, "countQueueMessages() at JMSSender...");
            int wqMsgs = 0;
            int qMsgs = 0;
            String qMsgsStr = "";
            qMsgList = new ArrayList<Object>();
            QueueBrowser queueBrowserW = null;
            QueueBrowser queueBrowser = null;
            try {
                try {
                    queueBrowserW = this.qsession.createBrowser(this.queueWrkflw);
                    Enumeration we = queueBrowserW.getEnumeration();
                    Exception exception = null;
                    while (we.hasMoreElements()) {
                        try {
                            we.nextElement();
                            ++wqMsgs;
                        }
                        catch (Exception ex) {
                            exception = ex;
                        }
                    }
                    if (exception != null) {
                        JMSLogger.log("0", null, null, "JMSSender >> queueBrowserW >> error::: " + exception.getMessage());
                    }
                    JMSLogger.log("0", this.userInfo, null, this.queueWrkflw + " has " + wqMsgs + " messages");
                    queueBrowser = this.qsession.createBrowser(this.queue);
                    Enumeration e = queueBrowser.getEnumeration();
                    while (e.hasMoreElements()) {
                        try {
                            e.nextElement();
                            ++qMsgs;
                        }
                        catch (Exception ex) {
                            JMSLogger.log("0", this.userInfo, null, "JMSSender >> queueBrowser >> error::: " + ex.getMessage());
                        }
                    }
                    JMSLogger.log("0", this.userInfo, null, this.queue + " has " + qMsgs + " messages");
                    qMsgsStr = "JMS Sender:[" + this.queueWrkflw + " : " + wqMsgs + " ," + this.queue + " : " + qMsgs + "]";
                    qMsgList.add(wqMsgs);
                    qMsgList.add(qMsgsStr);
                }
                catch (Exception e) {
                    JMSLogger.log("0", this.userInfo, null, "countQueueMessages >> error::: " + e.getMessage());
                    e.printStackTrace();
                    try {
                        if (queueBrowserW != null) {
                            queueBrowserW.close();
                        }
                        if (queueBrowser != null) {
                            queueBrowser.close();
                        }
                        break block24;
                    }
                    catch (JMSException e2) {
                        JMSLogger.log("0", this.userInfo, null, "Error closing QueueBrowser: " + e2.getMessage());
                        e2.printStackTrace();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (queueBrowserW != null) {
                        queueBrowserW.close();
                    }
                    if (queueBrowser != null) {
                        queueBrowser.close();
                    }
                }
                catch (JMSException e) {
                    JMSLogger.log("0", this.userInfo, null, "Error closing QueueBrowser: " + e.getMessage());
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (queueBrowserW != null) {
                    queueBrowserW.close();
                }
                if (queueBrowser != null) {
                    queueBrowser.close();
                }
            }
            catch (JMSException e) {
                JMSLogger.log("0", this.userInfo, null, "Error closing QueueBrowser: " + e.getMessage());
                e.printStackTrace();
            }
        }
        JMSLogger.log("0", null, null, "JMSSender >> qMsgList :: [" + qMsgList + "]");
        return qMsgList;
    }
}

