/*
 * Decompiled with CFR 0.152.
 */
package ibase.utility.training;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;

public class XmlReader {
    public static void main(String[] args) {
        String filePath = "/home/amol.sonawane/Documents/UNS-HSBC";
        String outputFileName = XmlReader.generateOutputFileName();
        String archiveFolderName = XmlReader.generateArchiveFolderName();
        try {
            XmlReader.concatenateXmlFiles(filePath, outputFileName);
            XmlReader.moveFilesToArchive(filePath, archiveFolderName);
            System.out.println("XML files concatenated successfully. Output file: " + outputFileName);
        }
        catch (IOException e) {
            System.err.println("Error concatenating XML files: " + e.getMessage());
        }
    }

    private static void concatenateXmlFiles(String filePath, String outputFileName) throws IOException {
        File[] xmlFiles;
        File outputDir = new File("/home/amol.sonawane/Documents/UNS-HSBC/NewXml");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if ((xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"))) == null || xmlFiles.length == 0) {
            System.err.println("No XML files found in the specified directory.");
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, outputFileName)));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write("<Document xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">");
            int i = 0;
            while (i < xmlFiles.length) {
                String content = new String(Files.readAllBytes(xmlFiles[i].toPath()));
                int startIdxOfMsgId = content.indexOf("<MsgId>");
                int endIdxOfMsgId = content.indexOf("</MsgId>") + "</MsgId>".length();
                if (startIdxOfMsgId != -1 && endIdxOfMsgId != -1) {
                    String updatedMsgIdTag = "<MsgId>" + XmlReader.getFileNameWithoutExtension(XmlReader.generateOutputFileName()) + "</MsgId>";
                    content = String.valueOf(content.substring(0, startIdxOfMsgId)) + updatedMsgIdTag + content.substring(endIdxOfMsgId);
                }
                int startIdxOfPmtInfId = content.indexOf("<PmtInfId>");
                int endIdxOfPmtInfId = content.indexOf("</PmtInfId>") + "</PmtInfId>".length();
                if (startIdxOfPmtInfId != -1 && endIdxOfPmtInfId != -1) {
                    String updatedPmtInfIdTag = "<PmtInfId>" + XmlReader.getFileNameWithoutExtension(XmlReader.generateOutputFileName()) + "</PmtInfId>";
                    content = String.valueOf(content.substring(0, startIdxOfPmtInfId)) + updatedPmtInfIdTag + content.substring(endIdxOfPmtInfId);
                }
                if (i == 0) {
                    int totalCtrlSum = 0;
                    HashSet addedCtrlSums = new HashSet();
                    File[] fileArray = xmlFiles;
                    int n = xmlFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File xmlFile = fileArray[n2];
                        String fileContent = new String(Files.readAllBytes(xmlFile.toPath()));
                        HashSet<String> addedCtrlSumsInFile = new HashSet<String>();
                        int startIdxOfCtrlSum = fileContent.indexOf("<CtrlSum>");
                        int endIdxOfCtrlSum = fileContent.indexOf("</CtrlSum>", startIdxOfCtrlSum);
                        while (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1) {
                            String ctrlSumValueStr = fileContent.substring(startIdxOfCtrlSum + "<CtrlSum>".length(), endIdxOfCtrlSum);
                            int ctrlSumValue = Integer.parseInt(ctrlSumValueStr.trim());
                            if (!addedCtrlSumsInFile.contains(ctrlSumValueStr)) {
                                System.out.println("totalCtrlSum : " + (totalCtrlSum += ctrlSumValue));
                                addedCtrlSumsInFile.add(ctrlSumValueStr);
                            }
                            if ((startIdxOfCtrlSum = fileContent.indexOf("<CtrlSum>", endIdxOfCtrlSum)) == -1) break;
                            endIdxOfCtrlSum = fileContent.indexOf("</CtrlSum>", startIdxOfCtrlSum);
                        }
                        ++n2;
                    }
                    int startIdxOfCtrlSum = content.indexOf("<CtrlSum>");
                    int endIdxOfCtrlSum = content.indexOf("</CtrlSum>", startIdxOfCtrlSum);
                    if (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1) {
                        content = String.valueOf(content.substring(0, startIdxOfCtrlSum + "<CtrlSum>".length())) + totalCtrlSum + content.substring(endIdxOfCtrlSum);
                    }
                    System.out.println("First totalCtrlSum : " + totalCtrlSum);
                    int startIdxOfNbOfTxsTag = content.indexOf("<NbOfTxs>");
                    int endIdxOfNbOfTxsTag = content.indexOf("</NbOfTxs>", startIdxOfNbOfTxsTag);
                    System.out.println("startIdxOfNbOfTxsTag : " + startIdxOfNbOfTxsTag);
                    System.out.println("endIdxOfNbOfTxsTag : " + endIdxOfNbOfTxsTag);
                    if (startIdxOfNbOfTxsTag != -1 && endIdxOfNbOfTxsTag != -1) {
                        content = String.valueOf(content.substring(0, startIdxOfNbOfTxsTag + "<NbOfTxs>".length())) + xmlFiles.length + content.substring(endIdxOfNbOfTxsTag);
                    }
                    int startIdx = content.indexOf("<CstmrCdtTrfInitn>");
                    int endIdx = content.lastIndexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
                    if (startIdx != -1 && endIdx != -1) {
                        content = content.substring(startIdx, endIdx);
                    }
                    int startIdxOfPmtInf = content.indexOf("<PmtInf>");
                    int endIdxOfPmtInf = content.indexOf("</Dbtr>", startIdxOfPmtInf);
                    if (startIdxOfPmtInf != -1 && endIdxOfPmtInf != -1) {
                        int startIdxOfCtrlSumPmtInf = content.indexOf("<CtrlSum>", startIdxOfPmtInf);
                        int endIdxOfCtrlSumPmtInf = content.indexOf("</CtrlSum>", startIdxOfCtrlSumPmtInf);
                        System.out.println("value startIdxOfCtrlSumPmtInf is : " + startIdxOfCtrlSumPmtInf);
                        if (startIdxOfCtrlSumPmtInf != -1 && endIdxOfCtrlSumPmtInf != -1) {
                            String updatedCtrlSumTag = "<CtrlSum>" + totalCtrlSum + "</CtrlSum>";
                            content = String.valueOf(content.substring(0, startIdxOfCtrlSumPmtInf)) + updatedCtrlSumTag + content.substring(endIdxOfCtrlSumPmtInf + "</CtrlSum>".length());
                            System.out.println("value of totalCtrlSum in pmtinf is : " + totalCtrlSum);
                        }
                    }
                    int startIdxOfNbOfTxsPmtInf = content.indexOf("<NbOfTxs>", startIdxOfPmtInf);
                    int endIdxOfNbOfTxsPmtInf = content.indexOf("</NbOfTxs>", startIdxOfPmtInf);
                    if (startIdxOfNbOfTxsPmtInf != -1 && endIdxOfNbOfTxsPmtInf != -1) {
                        content = String.valueOf(content.substring(0, startIdxOfNbOfTxsPmtInf + "<NbOfTxs>".length())) + xmlFiles.length + content.substring(endIdxOfNbOfTxsPmtInf);
                    }
                } else {
                    int startIdx = content.indexOf("<CdtTrfTxInf>");
                    int endIdx = content.indexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
                    if (startIdx != -1 && endIdx != -1) {
                        content = content.substring(startIdx, endIdx);
                    }
                }
                writer.write(content);
                ++i;
            }
            writer.write("</PmtInf>");
            writer.write("</CstmrCdtTrfInitn>");
            writer.write("</Document>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void moveFilesToArchive(String filePath, String archiveFolderName) throws IOException {
        File[] xmlFiles;
        File archiveDir = new File(String.valueOf(filePath) + File.separator + archiveFolderName);
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        if ((xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"))) != null) {
            File[] fileArray = xmlFiles;
            int n = xmlFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File xmlFile = fileArray[n2];
                Path sourcePath = Paths.get(xmlFile.getAbsolutePath(), new String[0]);
                Path destinationPath = Paths.get(String.valueOf(archiveDir.getAbsolutePath()) + File.separator + xmlFile.getName(), new String[0]);
                Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                ++n2;
            }
        }
    }

    private static String generateOutputFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmm");
        String formattedDate = dateFormat.format(new Date());
        return String.valueOf(formattedDate) + ".xml";
    }

    private static String generateArchiveFolderName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
        return dateFormat.format(new Date());
    }

    private static String getFileNameWithoutExtension(String formattedDate) {
        int lastDotIndex = formattedDate.lastIndexOf(".");
        if (lastDotIndex != -1) {
            return formattedDate.substring(0, lastDotIndex);
        }
        return formattedDate;
    }
}

