package ibase.webService;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.HttpHeaders;

import javax.xml.parsers.DocumentBuilderFactory;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.bean.ExtAuthAppAPIBean;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import ibase.webitm.utility.ViewReport;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;

class VisionOBJServiceUtility extends RestAPIServiceUtility {

	// Added By Ankush S on 13-MAR-2023[to get user info from Request]START
	public UserInfoBean getUserInfo(HttpServletRequest request, String tokenId) {
		UserInfoBean userInfo = null;
		String userInfoStr = "";
		try {
			HttpSession session = request.getSession();
			java.util.Enumeration<String> attributeNames = session.getAttributeNames();
			while (attributeNames.hasMoreElements()) {
				if (attributeNames.nextElement().equals("USER_INFO")) {
					userInfoStr = session.getAttribute("USER_INFO").toString();
				}
			}
			if (!userInfoStr.equals("")) {
				userInfo = new UserInfoBean(userInfoStr);
			}
			if (userInfo == null) {
				APIUtility apiUtility = new APIUtility();
				userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
			}
			return userInfo;
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Error in getting User info from Request [" + e.getMessage() + "]");
			return null;
		}
	}
	// Added By Ankush S on 30-NOV-2023[to get user info from Request]END

	public String getPageDetails(HttpServletRequest request, HttpHeaders header, String appId, String objName) {

		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		boolean isError = false;
		UserInfoBean userInfo = null;

		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();
		try {

			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getPageDetails() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getPageDetails() TOKENID length return error" + tokenId.length());
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getPageDetails() appId=" + appId);

			params = request.getQueryString();
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("APP_ID=" + appId);
				paramString.append("&OBJ_NAME=" + objName);
				// paramString.append("&PAGE_NO=" + pageNo);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getPageDetails() params=" + params);

			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getPageDetails() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getPageDetails", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getPageDetails() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId,
							"getPageDetails");
					BaseLogger.log("3", null, null, "getPageDetails() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null,
									"getPageDetails() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}

			}
			if (!isError) {
				DBAccessEJB dbAccess = new DBAccessEJB();
				// String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo,
				// "T", pageNo);

				String pageDetails = dbAccess.getObjDetail(objName, "1", null, userInfo, "T");
				BaseLogger.log("3", null, null, "getPageDetails with pageno API works pageDetails=" + pageDetails);

				JSONObject jsonObject = XML.toJSONObject(pageDetails);
				BaseLogger.log("3", null, null, "getPageDetails with pageno API works JSON=" + jsonObject.toString());
				result = jsonObject.toString();
				status = "success";
			}

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getPageDetails : " + e.getMessage());
			status = "exception";
			result = getStackTrace(e, "JSON");
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status,
					result);
		}
		e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( VisionOBJService/getPageDetails )", status, result, appId,
				request, userInfo);
		return result;

	}

	public String getListPageData(String appId, String objName, String advQuery, String argFieldNames,
			String argFieldTypes, String argFieldValues, String searchParam, String objContext, String pageContext,
			String currentRowNo, String upToRowNo, String dataFormat, HttpServletRequest request, HttpHeaders header) {
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		boolean isError = false;
		UserInfoBean userInfo = null;
		APIUtility apiUtility = new APIUtility();
		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}

			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}

			BaseLogger.log("3", null, null, "getListPageData() appId=" + appId);
			BaseLogger.log("3", null, null, "getListPageData() appId=" + appId.length());

			params = request.getQueryString();
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("APP_ID=" + appId);
				paramString.append("&OBJ_NAME=" + objName);
				paramString.append("&ADV_QRY=" + advQuery);
				paramString.append("&ARG_NAMES=" + argFieldNames);
				paramString.append("&ARG_TYPES=" + argFieldTypes);
				paramString.append("&ARG_VALUES=" + argFieldValues);
				paramString.append("&SEARCH_PARAM=" + searchParam);
				paramString.append("&OBJ_CONTEXT=" + objContext);
				paramString.append("&PAGE_CONTEXT=" + pageContext);
				paramString.append("&CURR_ROW_NUM=" + currentRowNo);
				paramString.append("&UPTO_ROW_NUM=" + upToRowNo);
				paramString.append("&DATA_FORMAT=" + dataFormat);

				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getListPageData() params=" + params);

			if (!isError && !appId.equals("FLUTTERAPP")) {
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getListPageData", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getListPageData() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId,
							"getListPageData");
					BaseLogger.log("3", null, null, "getListPageData() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null,
									"getListPageData() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}
			}
			if (!isError) {
				// DBAccessEJB dbAccess = new DBAccessEJB();

				E12GenericUtility genericUtility = new E12GenericUtility();
				MasterDataEJB masterDataEJB = new MasterDataEJB();
				boolean isRCP = true;
				boolean isMaxBrowCheck = true;
				String[] argValList = argFieldValues.split(":");
				argFieldValues = "";
				String[] argFieldName = argFieldNames.split(":");
				for (int i = 0; i < argFieldName.length; i++) {
					String argVal = "";
					if (i < argValList.length) {
						argVal = genericUtility.getValidDateString(argValList[i], genericUtility.getApplDateFormat(),
								genericUtility.getDispDateFormat());
					} else {
						argVal = " ";
					}
					argFieldValues += argVal + ":";
				}

				HashMap<String, String> incrementalSearchParam = new HashMap<String, String>();
				incrementalSearchParam.put("CURR_ROW_NUM", (currentRowNo == null) ? "0" : currentRowNo);
				incrementalSearchParam.put("UPTO_ROW_NUM", (upToRowNo == null) ? "0" : upToRowNo);
				BaseLogger.log("3", null, null, "getListPageData() is UserInfo null?" + (userInfo == null));
				BaseLogger.log("3", null, null, "getListPageData() Login Code=" + userInfo.getLoginCode());
				String xmlData = masterDataEJB.getXMLFromDBForBrow(objName, objContext, pageContext, argFieldValues,
						argFieldTypes, advQuery, userInfo, isRCP, searchParam, incrementalSearchParam, isMaxBrowCheck);
				JSONObject jsonObject = XML.toJSONObject(xmlData);
				BaseLogger.log("3", null, null, "getListPageData() XML result=" + xmlData);
				BaseLogger.log("3", null, null, "getListPageData() JSON result=" + jsonObject);
				// adding noOfRows because its getting empty in the XML
				JSONObject documentRoot = jsonObject.getJSONObject("DocumentRoot");
				JSONObject group0 = documentRoot.getJSONObject("group0");
				JSONObject header0 = group0.getJSONObject("Header0");
				Object detail1 = header0.get("Detail1");
				String noOfRows = "";
				// Check if Detail1 is an array
				if (detail1 instanceof JSONArray) {
					// Detail1 is an array
					JSONArray detail1Array = (JSONArray) detail1;
					int detail1Size = detail1Array.length();
					BaseLogger.log("3", null, null, "Detail1 is an array");
					BaseLogger.log("3", null, null, "Size of Detail1 array: " + detail1Size);
					noOfRows = String.valueOf(detail1Size);

				} else {
					// Detail1 is not an array
					BaseLogger.log("3", null, null, "Detail1 is not an array");
					if (detail1.equals("")) {
						// Set NoOfRows to 0 if Detail1 is empty
						noOfRows = "0";
					} else
						noOfRows = "1";
				}
				header0.put("NoOfRows", noOfRows);
				group0.put("Header0", header0);
				documentRoot.put("group0", group0);
				jsonObject.put("DocumentRoot", documentRoot);

				BaseLogger.log("3", null, null, "getListPageData() JSON result updated=" + jsonObject);

				result = jsonObject.toString();
				status = "success";
				// return result;

			}

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getListPageData : " + e.getMessage());
			status = "exception";
			result = getStackTrace(e, "JSON");
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getListPageData", params, tokenId, "JSON", status,
					result);
		}
		e12ExtServiceUtility.writeAPICallLog("getListPageData ( VisionOBJService/getListPageData )", status, result,
				appId, request, userInfo);
		return result;
	}

	public Object getPageMetadata(HttpServletRequest request, HttpHeaders header, String appId, String objName,
			String formName, String objContext, String pageContext) {
		BaseLogger.log("3", null, null, "Inside getPageMetadata : VisonObjServiceUtility ");
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		String dataFormat = "JSON";
		UserInfoBean userInfo = null;
		boolean isError = false;
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();

		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getPageMetadata() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getPageMetadata() TOKENID length return error" + tokenId.length());
			}

			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getPageMetadata() appId=" + appId);

			params = request.getQueryString();
			BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("APP_ID=" + appId);
				paramString.append("&OBJ_NAME=" + objName);
				paramString.append("&FORMA_NAME=" + formName);
				paramString.append("&OBJ_CONTEXT=" + objContext);
				paramString.append("&PAGE_CONTEXT=" + pageContext);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getPageMetadata() params=" + params);
			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getPageMetadata() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getPageMetadata", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getPageMetadata() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId,
							"getPageMetadata");
					BaseLogger.log("3", null, null, "getPageMetadata() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null,
									"getPageMetadata() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}
			}
			if (!isError) {
				E12GenericUtility genericUtility = new E12GenericUtility();

				String transDB = userInfo.getTransDB();
				HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
				if (userInfo != null) {
					propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
					propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
					propEditorInfoMap.put("USER_ID", checkNull(userInfo.getLoginCode()));
					propEditorInfoMap.put("PROFILE_ID", checkNull(userInfo.getProfileId()));
				}
				propEditorInfoMap.put("EDITOR", "WebEditor");

				String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "",
						propEditorInfoMap, transDB);
				BaseLogger.log("3", null, null, "getPageMetadata() FilePath=" + filePath);
				File metadataFile = new File(filePath);
				String xmlString = readFile(metadataFile);

				JSONObject jsonObject = new JSONObject();
				jsonObject.put("id", (objName + "_" + objContext + "_" + pageContext));
				jsonObject.put("obj_name", objName);

				jsonObject.put("form_title", formName);
				jsonObject.put("form_no", objContext);
				jsonObject.put("page_context", pageContext);

				jsonObject.put("columns", getPageMetadataJSON(xmlString));
				result = jsonObject.toString();
				status = "success";
			}

		} catch (Exception e) {

			BaseLogger.log("0", null, null, "Exception : getPageMetadata : " + e.getMessage());
			result = getStackTrace(e, dataFormat);
			status = "exception";
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getPageMetadata", params, tokenId, dataFormat,
					status, result);
		}
		e12ExtServiceUtility.writeAPICallLog("getPageMetadata ( /getPageMetadata )", status, result, appId, request,
				userInfo);
		return result;
	}

	public Object getPageMeta(HttpServletRequest request, HttpHeaders header, String appId, String objName,
			String formName, String objContext, String pageContext) {
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		try {
			params = request.getQueryString();
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("APP_ID=" + appId);
				paramString.append("&OBJ_NAME=" + objName);
				paramString.append("&FORMA_NAME=" + formName);
				paramString.append("&OBJ_CONTEXT=" + objContext);
				paramString.append("&PAGE_CONTEXT=" + pageContext);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getPageMeta() params=" + params);
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			BaseLogger.log("3", null, null, "getPageMeta() tokenId=" + tokenId);
			result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageMetadata");
			BaseLogger.log("3", null, null, "getPageMeta() result=" + result);

			if ("valid".equalsIgnoreCase(result)) {
				appId = checkNull(appId);
				objName = checkNull(objName);
				objContext = checkNull(objContext);
				pageContext = checkNull(pageContext);

				if (objName.length() == 0) {
					result = "Please enter valid Object Name.";
					status = "error";
				} else {
					E12GenericUtility genericUtility = new E12GenericUtility();
					UserInfoBean userInfo = getUserInfo(request, tokenId);
					// String objName;
					// String objContext;
					// String pageContext;

					String transDB = userInfo.getTransDB();
					HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
					if (userInfo != null) {
						propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
						propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
						propEditorInfoMap.put("USER_ID", checkNull(userInfo.getLoginCode()));
						propEditorInfoMap.put("PROFILE_ID", checkNull(userInfo.getProfileId()));
					}
					propEditorInfoMap.put("EDITOR", "WebEditor");

					String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "",
							propEditorInfoMap, transDB);
					BaseLogger.log("3", null, null, "getPageMeta() FilePath=" + filePath);
					File metadataFile = new File(filePath);
					String xmlString = readFile(metadataFile);

					JSONObject jsonObject = new JSONObject();
					jsonObject.put("id", (objName + "_" + objContext + "_" + pageContext));
					jsonObject.put("obj_name", objName);

					jsonObject.put("form_title", formName);
					jsonObject.put("form_no", objContext);
					jsonObject.put("page_context", pageContext);

					jsonObject.put("columns", getPageMetadataJSON(xmlString));
					result = jsonObject.toString();
					status = "success";
					return result;
				}

			} else {
				status = "error";
			}

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getPageDetails : " + e.getMessage());
			status = "exception";
			result = getStackTrace(e, "JSON");
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status,
					result);
		}
		return result;
	}

	public String getFormalArgs(HttpServletRequest request, HttpHeaders header, String appId, String objName,
			String pageNo, String formName) {
		BaseLogger.log("3", null, null, "Inside getFormalArgs : VisonObjServiceUtility ");
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		String dataFormat = "JSON";
		boolean isError = false;
		UserInfoBean userInfo = null;
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();
		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getFormalArgs() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getFormalArgs() TOKENID length return error" + tokenId.length());
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getFormalArgs() appId=" + appId);
			params = request.getQueryString();
			BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("APP_ID=" + appId);
				paramString.append("&OBJ_NAME=" + objName);
				paramString.append("&PAGE_NO=" + pageNo);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getFormalArgs() params=" + params);
			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getFormalArgs() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getFormalArgs", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getFormalArgs() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId,
							"getPageDetails");
					BaseLogger.log("3", null, null, "getFormalArgs() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null, "getFormalArgs() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}
			}
			if (!isError) {
				DBAccessEJB dbAccess = new DBAccessEJB();
				String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo, "T", pageNo);
				BaseLogger.log("3", null, null, "getFormalArgs with pageno API works XML=" + pageDetails);

				// JSONObject jsonObject = XML.toJSONObject(pageDetails);
				JSONObject jsonObject = new JSONObject();
				jsonObject.put("columns", getFormalArgs(pageDetails));
				jsonObject.put("form_title", "Search in " + formName);
				jsonObject.put("form_no", "0");
				jsonObject.put("obj_name", objName);
				jsonObject.put("id", objName + "_1_2");
				BaseLogger.log("3", null, null, "getFormalArgs with pageno API works JSON=" + jsonObject.toString());
				result = jsonObject.toString();
				status = "success";
			}
		} catch (Exception e) {

			BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
			result = getStackTrace(e, dataFormat);
			status = "exception";
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat,
					status, result);
		}
		e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( /getFormalArgs )", status, result, appId, request,
				userInfo);
		return result;
	}

	public String getData(HttpServletRequest request, HttpHeaders header, String objName, String refId,
			String dataFormat, String appId) {
		BaseLogger.log("3", null, null, "Inside getData : VisonObjServiceUtility ");
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		boolean isError = false;
		UserInfoBean userInfo = null;
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();
		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getData() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getData() TOKENID length return error" + tokenId.length());
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getData() appId=" + appId);
			params = request.getQueryString();
			BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME=" + objName);
				paramString.append("&REF_ID=" + refId);
				paramString.append("&TOKEN_ID=" + tokenId);
				paramString.append("&DATA_FORMAT=" + dataFormat);
				paramString.append("&APP_ID=" + appId);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getData() params=" + params);
			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getData() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getPageDetails", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getData() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getData");
					BaseLogger.log("3", null, null, "getData() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null, "getData() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}

			}
			if (!isError) {
				result = getDetailXMLDomString(objName, "1", "V", refId, null, userInfo);
				BaseLogger.log("3", null, null, " variable: resultinXML length: " + "[" + result.length() + "]"
						+ "method: getData : class: VisionOBJService ");
				if ("JSON".equalsIgnoreCase(dataFormat)) {

					JSONObject jsonObject = XML.toJSONObject(result);
					BaseLogger.log("3", null, null, "getData  JSON=" + jsonObject.toString());
					result = jsonObject.toString();
					status = "success";

				}
				status = "success";
			}

		} catch (Exception e) {

			BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
			result = getStackTrace(e, dataFormat);
			status = "exception";
		} finally {
			result = e12ExtServiceUtility.generateResponse(request, "getData", params, tokenId, dataFormat, status,
					result);
		}
		e12ExtServiceUtility.writeAPICallLog("getData ( VisionOBJService/getData )", status, result, appId, request,
				userInfo);
		return result;
	}

	public String getReportArgs(String objName, String dataFormat, String appId, String formName,
			HttpServletRequest request, HttpHeaders header) {
		BaseLogger.log("3", null, null, "Inside getData : getReportArgs ");
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		boolean isError = false;
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();
		UserInfoBean userInfo = null;
		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getReportArgs() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getReportArgs() TOKENID length return error" + tokenId.length());
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getReportArgs() appId=" + appId);
			params = request.getQueryString();
			BaseLogger.log("3", null, null, "getReportArgs() request.getQueryString() " + request.getQueryString());
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME=" + objName);
				paramString.append("&TOKEN_ID=" + tokenId);
				paramString.append("&DATA_FORMAT=" + dataFormat);
				paramString.append("&APP_ID=" + appId);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getReportArgs() params=" + params);
			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getReportArgs() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getReportArgs", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getReportArgs() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId,
							"getReportArgs");
					BaseLogger.log("3", null, null, "getReportArgs() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null, "getReportArgs() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}

			}
			if (!isError) {

				XSDParser xsdParser = new XSDParser(objName, userInfo);
				// String attachType = "pdf";
				String argXmlString = xsdParser.getArgumentMetaDataString();
				BaseLogger.log("3", userInfo, null, "argXmlString:: [" + argXmlString + "]");
				if (argXmlString.length() > 0) {
					if (dataFormat.equalsIgnoreCase("JSON")) {
						E12GenericUtility genericUtility = new E12GenericUtility();
						String xmlString = genericUtility.xmlToJSONString(argXmlString);
						BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xmlString + "]");

						JSONObject resultJSON = new JSONObject();
						resultJSON.put("form_title", formName);
						resultJSON.put("form_no", "0");
						resultJSON.put("obj_name", objName);
						resultJSON.put("id", (objName + "_1_2"));

						// make XSD string in JSON Object
						JSONObject xsdJSON = new JSONObject(xmlString);
						BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xsdJSON + "]");

						resultJSON.put("columns", getColumnsArray(xsdJSON));

						result = resultJSON.toString();
						status = "success";
						BaseLogger.log("3", userInfo, null, "getReportArgs() result:: [" + result + "]");
					}
				} else {
					result = "Something went wrong, please check object name!!";
					status = "error";
				}

			}
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}

		finally {
			result = e12ExtServiceUtility.generateResponse(request, "getReportArgs", params, tokenId, dataFormat,
					status, result);
		}
		e12ExtServiceUtility.writeAPICallLog("getReportArgs ( VisionOBJService/getReportArgs )", status, result, appId,
				request, userInfo);
		return result;
	}

	public String getReport(String objName, String appId, String dataFormat, String docType, String reportArgument,
			HttpServletRequest request, HttpHeaders header, HttpServletResponse response) {
		BaseLogger.log("3", null, null, "Inside getData : getReportArgs ");
		String result = "";
		String params = "";
		String status = "error";
		String tokenId = "";
		String filePath = null;
		boolean isError = false;
		UserInfoBean userInfo = null;
		E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		APIUtility apiUtility = new APIUtility();
		try {
			tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
			// validate the request first
			BaseLogger.log("3", null, null, "getReport() TOKENID length=" + tokenId.length());

			if (tokenId.length() == 0) {
				status = "Reject";
				result = "Blank Token ID passed.";
				isError = true;
				BaseLogger.log("3", null, null, "getReport() TOKENID length return error" + tokenId.length());
			}
			if (!isError)
				userInfo = getUserInfo(request, tokenId);
			if (!isError && userInfo == null) {
				status = "Reject";
				result = "User not allowed.";
				isError = true;
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				appId = apiUtility.getAppIdFromJWTToken(tokenId);
			}
			if (!isError && (appId == null || appId.length() == 0)) {
				status = "Reject";
				result = "Blank APPID passed.";
				isError = true;
			}
			BaseLogger.log("3", null, null, "getReport() appId=" + appId);
			params = request.getQueryString();
			BaseLogger.log("3", null, null, "getReport() request.getQueryString() " + request.getQueryString());
			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME=" + objName);
				paramString.append("&TOKEN_ID=" + tokenId);
				paramString.append("&DATA_FORMAT=" + dataFormat);
				paramString.append("&APP_ID=" + appId);
				params = paramString.toString();
			}
			BaseLogger.log("3", null, null, "getReport() params=" + params);
			if (!isError && !appId.equals("FLUTTERAPP")) {
				BaseLogger.log("3", null, null, "getReport() none flutter APP");
				ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess()
						.getAuthAppAPIDetails("getReport", appId);
				if (authAppAPIBean == null) {
					status = "Reject";
					result = "This service not available for given APPID";
					isError = true;
					BaseLogger.log("3", null, null, "getReport() none flutter result=" + result);
				} else {
					result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getReport");
					BaseLogger.log("3", null, null, "getReport() result=" + result);
					if ("valid".equalsIgnoreCase(result)) {

						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
							isError = true;
							BaseLogger.log("3", null, null, "getReport() none flutter validation result=" + result);
						}
					} else {
						status = "Reject";
						isError = true;
					}
				}
			}
			if (!isError) {
				String backgrndProcess = "false";
				String deviceType = "";
				String fromSqlTimeOut = "";
				String fromBackgrounServer = "false";
				String userCode = userInfo.getLoginCode();
				String isExplore = "";
				boolean isConfirmReprint = false;
				String browserType = null;
				String notifyBy = null;
				String remoteAddress = request.getRemoteAddr();

				ViewReport viewReport = new ViewReport();
				viewReport.getReport(docType, objName, backgrndProcess, deviceType, reportArgument, fromSqlTimeOut,
						fromBackgrounServer, userCode, isExplore, isConfirmReprint, browserType, notifyBy,
						remoteAddress);
				filePath = viewReport.getFilePath();

				BaseLogger.log("3", userInfo, null, "report filePath:::[" + filePath + "]");

				if (filePath != null && filePath.length() > 0) {
					File dir = new File(filePath);
					if (dir.exists()) {
						ServletOutputStream outputStream = response.getOutputStream();
						FileInputStream fis = new FileInputStream(filePath);
						byte[] buffer = new byte[(int) dir.length()];
						int length = 0;
						while ((length = fis.read(buffer)) > 0) {
							outputStream.write(buffer, 0, length);
						}
						fis.close();
						outputStream.flush();
						result = "success";
						// response.setContentType("pdf");
						response.setContentType("application/octet-stream");
						response.setHeader("Content-Disposition", "attachment; filename=\"" + dir.getName() + "\"");
						response.setBufferSize(buffer.length);
						result = "Report downloading";
						status = "success";
						BaseLogger.log("3", userInfo, null, "getReportArgs() result:: [" + result + "]");
					}
				} else {
					result = "Report Not Found";
				}
			}
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}

		finally {
			result = e12ExtServiceUtility.generateResponse(request, "VisionOBJService/getReport", params, tokenId,
					dataFormat, status, result);
		}
		e12ExtServiceUtility.writeAPICallLog("getReport ( VisionOBJService/getReport )", status, result, appId, request,
				userInfo);
		return result;
	}

	private String readFile(File fileName) throws Exception {
		StringBuffer fileContent = new StringBuffer();
		BufferedReader bfr = null;
		try {
			if (fileName.exists()) {
				FileInputStream fMainIn = new FileInputStream(fileName);
				bfr = new BufferedReader(new InputStreamReader(fMainIn, CommonConstants.ENCODING));
				String outTempStr = null;
				while ((outTempStr = bfr.readLine()) != null) {
					fileContent.append(outTempStr);
				}
				bfr.close();
				bfr = null;
			}
		} catch (Exception e) {
			throw e;
		} finally {
			try {
				if (bfr != null) {
					bfr.close();
					bfr = null;
				}
			} catch (Exception e) {
				BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
				e.printStackTrace();
			}
		}
		return fileContent.toString();
	}

	private JSONArray getPageMetadataJSON(String xmlData) {
		try {
			BaseLogger.log("3", null, null, "getPageMeta() xmlData=" + xmlData.length());
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
			// get the column objects from XM
			NodeList columnObjectList = doc.getElementsByTagName("ColumnObject");
			NodeList textObjectList = doc.getElementsByTagName("TextObject");

			Map<String, String> labelMap = getLabelMap(textObjectList);
			BaseLogger.log("3", null, null, "label map " + labelMap);

			NodeList groupboxObjectList = doc.getElementsByTagName("GroupBox");
			JSONArray groupArray = getGroupBoxArray(groupboxObjectList);
			BaseLogger.log("3", null, null, "group array = " + groupArray.toString());

			// getting default values
			NodeList tableColumnList = doc.getElementsByTagName("table_column");
			Map<String, JSONObject> tableColumnObjectWithValue = getValueTableColumn(tableColumnList);
			BaseLogger.log("3", null, null, "table column size " + tableColumnList.getLength());

			JSONArray columnArray = new JSONArray();
			for (int i = 0; i < columnObjectList.getLength(); i++) {
				Element columnObject = (Element) columnObjectList.item(i);

				JSONObject column = new JSONObject();
				column.put("alignment", getElementValue(columnObject, "alignment"));
				column.put("tabsequence", getElementValue(columnObject, "tabsequence"));
				column.put("x", getElementValue(columnObject, "x"));
				column.put("y", getElementValue(columnObject, "y"));
				column.put("height", getElementValue(columnObject, "height"));
				column.put("width", getElementValue(columnObject, "width"));
				column.put("format", getElementValue(columnObject, "format"));
				column.put("name", getElementValue(columnObject, "name"));
				column.put("visible", getElementValue(columnObject, "visible"));
				column.put("tag", getElementValue(columnObject, "tag"));

				// for edit style tag
				Element editStyle = (Element) columnObject.getElementsByTagName("EditStyle").item(0);
				String style = editStyle.getAttribute("style");

				column.put("edit_style", style);
				String limit = getElementValue(editStyle, "limit");
				column.put("limit", limit);

				String required = getElementValue(editStyle, "required");
				required = required.equals("") ? "false" : "true";
				column.put("required", required);

				String caseValue = getElementValue(editStyle, "case");
				column.put("case", caseValue);

				String mask = getElementValue(editStyle, "mask");
				column.put("mask", mask);

				String name = getElementValue(columnObject, "name");
				column.put("display_label", labelMap.get(name));

				// get x of element
				String x = getElementValue(columnObject, "x");
				String y = getElementValue(columnObject, "y");
				String group = findGroup(x, y, groupArray);
				column.put("group", group);
				BaseLogger.log("3", null, null, "Found groupbox name " + group);

				// find the default value if any
				if (tableColumnObjectWithValue.containsKey(name)) {
					column.put("initial", tableColumnObjectWithValue.get(name).get("initial"));
					column.put("values", tableColumnObjectWithValue.get(name).get("values"));
				}

				columnArray.put(column);
			}

			// JSONObject jsonObject = XML.toJSONObject(xmlString);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("column", columnArray);
			BaseLogger.log("3", null, null, "column array=" + jsonObject.toString());
			return columnArray;
		} catch (Exception e) {

			e.printStackTrace();
			BaseLogger.log("3", null, null, "Error in getting JSON");
		}
		return new JSONArray();
	}

	private String getElementValue(Element parentElement, String tagName) {
		NodeList nodeList = parentElement.getElementsByTagName(tagName);
		if (nodeList.getLength() > 0) {
			return nodeList.item(0).getTextContent();
		} else {
			return ""; // Return empty string if the element is not present
		}
	}

	private String findGroup(String x, String y, JSONArray groupArray) {
		String groupName = "";
		try {
			int columnX = Integer.parseInt(x);
			int columnY = Integer.parseInt(y);
			for (int i = 0; i < groupArray.length(); i++) {
				JSONObject groupBox = groupArray.getJSONObject(i);
				String name = groupBox.getString("name");
				int groupBoxX = groupBox.getInt("x");
				int groupBoxXMax = groupBox.getInt("x_max");
				int groupBoxY = groupBox.getInt("y");
				int groupBoxYMax = groupBox.getInt("y_max");

				// Check if the component falls within the boundaries of the group box
				if (columnX >= groupBoxX && columnX <= groupBoxXMax && columnY >= groupBoxY
						&& columnY <= groupBoxYMax) {
					groupName = name;
					break;
				}
			}
		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Error: " + e.getMessage());
		}
		BaseLogger.log("3", null, null, "Found Groups name " + groupName);
		return groupName;
	}

	Map<String, String> getLabelMap(NodeList textObjectList) {
		Map<String, String> labelMap = new HashMap<>();

		for (int i = 0; i < textObjectList.getLength(); i++) {
			Node node = textObjectList.item(i);

			if (node.getNodeType() == Node.ELEMENT_NODE) {
				Element textObject = (Element) node;
				String name = getElementValue(textObject, "name");
				String text = getElementValue(textObject, "text");

				if (name != null && name.endsWith("_t")) {
					name = name.substring(0, name.length() - 2);
				}

				if (name != null) {
					labelMap.put(name, text);
				}
			}
		}
		return labelMap;
	}

	private JSONArray getGroupBoxArray(NodeList groupboxObjectList) {
		JSONArray gruopArray = new JSONArray();
		for (int i = 0; i < groupboxObjectList.getLength(); i++) {
			Node node = groupboxObjectList.item(i);
			if (node.getNodeType() == Node.ELEMENT_NODE) {
				Element textObject = (Element) node;
				String name = getElementValue(textObject, "text");
				String x = getElementValue(textObject, "x");
				String y = getElementValue(textObject, "y");

				String height = getElementValue(textObject, "height");
				String width = getElementValue(textObject, "width");

				try {
					int xVal = Integer.parseInt(x);
					int heightVal = Integer.parseInt(height);
					int yVal = Integer.parseInt(y);
					int widthVal = Integer.parseInt(width);

					JSONObject group = new JSONObject();

					group.put("x", xVal);
					group.put("height", heightVal);
					group.put("x_max", (xVal + widthVal));
					group.put("name", name);
					group.put("y", yVal);
					group.put("y_max", (yVal + heightVal));
					group.put("width", widthVal);

					gruopArray.put(group);
				} catch (Exception e) {
					BaseLogger.log("3", null, null, "Error" + e.getMessage());
				}
			}
		}
		return gruopArray;
	}

	private Map<String, JSONObject> getValueTableColumn(NodeList tableColumnList) {

		Map<String, JSONObject> elementMap = new HashMap<>();
		try {
			for (int i = 0; i < tableColumnList.getLength(); i++) {
				Node node = tableColumnList.item(i);
				if (node.getNodeType() == Node.ELEMENT_NODE) {
					Element tableColumnElement = (Element) node;
					NodeList valuesList = tableColumnElement.getElementsByTagName("values");
					if (valuesList.getLength() > 0) {
						String columnName = getElementValue(tableColumnElement, "name");
						String initial = getElementValue(tableColumnElement, "initial");

						Element valuesElement = (Element) valuesList.item(0);
						NodeList itemList = valuesElement.getElementsByTagName("item");
						JSONArray valueArray = new JSONArray();
						for (int j = 0; j < itemList.getLength(); j++) {
							Element itemElement = (Element) itemList.item(j);
							String displayValue = itemElement.getAttribute("display");
							String dataValue = itemElement.getAttribute("data");

							JSONObject item = new JSONObject();
							item.put("display", displayValue);
							item.put("data", dataValue);
							valueArray.put(item);

						}
						JSONObject values = new JSONObject();
						values.put("values", valueArray);
						values.put("initial", initial);

						elementMap.put(columnName, values);

					}
				}
			}
		} catch (Exception e) {

		}
		return elementMap;
	}

	public String getTokenFromHeaders(HttpHeaders headers) {
		BaseLogger.log("0", null, null, "Getting header info: ");
		String tokenId = null;
		// read all headers
		/*
		 * MultivaluedMap<String, String> headerMap = headers.getRequestHeaders(); for
		 * (String key : headerMap.keySet()) { BaseLogger.log("0",null,null,
		 * "headerMap Header Key: " + key); List<String> values = headerMap.get(key);
		 * for (String value : values) { BaseLogger.log("0",null,null,
		 * "headerMap  Value: " + value); } }
		 */

		// get value of TOKEN_ID from header
		List<String> tokenIdList = headers.getRequestHeader("TOKEN_ID");
		if (tokenIdList != null && !tokenIdList.isEmpty()) {
			BaseLogger.log("0", null, null, "GOt token list item=" + tokenIdList);
			tokenId = tokenIdList.get(0);
		}
		return tokenId;
	}

	public JSONArray getFormalArgs(String xmlString) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
			JSONArray formalArgsArray = new JSONArray();
			NodeList formalArgsList = doc.getElementsByTagName("FORMALARGS");

			if (formalArgsList.getLength() > 0) {

				Element formalArgs = (Element) formalArgsList.item(0);
				NodeList formalArgList = formalArgs.getElementsByTagName("FORMALARG");
				int xValue = 10, yValue = 10, tabSeq = 10;
				for (int i = 0; i < formalArgList.getLength(); i++) {
					Element formalArg = (Element) formalArgList.item(i);
					String fieldName = formalArg.getAttribute("field_name");
					String name = formalArg.getAttribute("name");
					String javaType = formalArg.getAttribute("javatype");
					String value = getElementValue(formalArg, "value");
					JSONObject formaArgsObj = new JSONObject();
					formaArgsObj.put("display_label", name);
					formaArgsObj.put("group", "");
					formaArgsObj.put("value", value);

					formaArgsObj.put("alignment", "");
					formaArgsObj.put("tabsequence", String.valueOf(tabSeq));
					formaArgsObj.put("x", String.valueOf(xValue));
					formaArgsObj.put("y", String.valueOf(yValue));
					formaArgsObj.put("height", "16");
					formaArgsObj.put("width", "66");
					formaArgsObj.put("format", "[" + javaType + "]");
					formaArgsObj.put("name", fieldName);
					formaArgsObj.put("tag", "");
					formaArgsObj.put("visible", "1");
					formaArgsObj.put("edit_style", "edit");
					formaArgsObj.put("limit", "");
					formaArgsObj.put("case", "");
					formaArgsObj.put("mask", "");

					yValue += 10;
					tabSeq += 10;
					formalArgsArray.put(formaArgsObj);
				}
				BaseLogger.log("3", null, null, "getFormalArgs formalArgsArray=" + formalArgsArray.toString());
				return formalArgsArray;
			} else {
				return new JSONArray();
			}

		} catch (Exception e) {
			return new JSONArray();
		}
	}

	private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues,
			String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException {
		String resultString = "";

		MasterStatefulLocal masterStateful = null;

		try {
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup("ibase/MasterStatefulEJB/local");
			int randInt = new Random().nextInt();
			masterStateful.setEditorId("" + randInt);
			masterStateful.setUserInfo(userInfo);
			resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues,
					argFieldValues);
		} catch (NamingException e) {
			BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
			throw new ITMException(e);
		}

		finally {
			if (masterStateful != null) {
				masterStateful.remove();
				masterStateful = null;
			}
		}

		return resultString;
	}

	/**
	 * It creates a object of InitialContext & returns the same.
	 *
	 * @return
	 * @throws ITMException
	 */
	private InitialContext getInitialContext() throws ITMException {
		InitialContext ctx = null;
		try {
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		} catch (ITMException itme) {
			BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
			throw itme;
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}

	// for creating column array using the XSD Data
	private JSONArray getColumnsArray(JSONObject xsdJSON) {
		JSONArray columnArray = new JSONArray();
		BaseLogger.log("3", null, null, "argument creating Array of json= " + xsdJSON);
		try {
			JSONObject argumentsObj = xsdJSON.getJSONObject("arguments");
			Object argumentObj = argumentsObj.get("argument");

			if (argumentObj instanceof JSONArray) {
				BaseLogger.log("3", null, null, "argument is Array");
				JSONArray argumentArray = (JSONArray) argumentObj;
				int tabSequence = 10;
				int xVal = 10, yVal = 10;
				for (int i = 0; i < argumentArray.length(); i++) {
					JSONObject argObj = argumentArray.getJSONObject(i);
					BaseLogger.log("3", null, null, "argument value=" + argObj);
					JSONObject column = new JSONObject();

					column.put("tabsequence", String.valueOf(tabSequence));
					tabSequence += 10;

					String visible = argObj.getJSONObject("attrib").getString("@visible");
					column.put("visible", visible);

					String format = argObj.getJSONObject("attrib").getString("@type");
					String[] parts = format.split("\\.");
					String formatVal = parts[parts.length - 1];
					column.put("format", "[" + formatVal + "]");

					column.put("required", "false");

					String displayLabel = argObj.getJSONObject("attrib").getString("@label");
					column.put("display_label", displayLabel);

					String editStyle = argObj.getJSONObject("attrib").getString("@inputType");
					column.put("edit_style", editStyle);

					column.put("x", String.valueOf(xVal));
					xVal += xVal;

					column.put("y", String.valueOf(yVal));
					yVal += yVal;

					String width = argObj.getJSONObject("attrib").getString("@width");
					column.put("width", width);

					String name = argObj.getJSONObject("attrib").getString("@name");
					column.put("name", name);

					String limit = argObj.getJSONObject("attrib").getString("@size");
					column.put("limit", limit);

					column.put("tag", "");

					String alignment = argObj.getJSONObject("attrib").getString("@alignment");
					column.put("alignment", alignment);

					String caseType = argObj.getJSONObject("attrib").getString("@caseType");
					column.put("case", caseType);

					String height = argObj.getJSONObject("attrib").getString("@height");
					column.put("height", height);

					column.put("mask", "");

					column.put("group", "");

					columnArray.put(column);
				}

			} else if (argumentObj instanceof JSONObject) {
				BaseLogger.log("3", null, null, "argument is JSONOBJECT");
			}

		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Error in getting column list" + e.getMessage());

		}
		return columnArray;
	}

	public String getObjPopHelpInfoAll(String objName,  String tokenIDfromHeader) {
		UserInfoBean userInfo = null;

		if (userInfo == null) {
			APIUtility apiUtility = new APIUtility();
			userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);

			BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
		}

		PopUpEJB popUp = new PopUpEJB();
		String popXmlString = popUp.getPopxmlData(objName, userInfo);
		String reqPopxml = "<ROOT>" + popXmlString + "</ROOT>";
	  //  String returnType = E12GenericUtility.checkNull(request.getParameter("RTEURN_TYPE"));
		try {
			org.w3c.dom.Document currentDetailNode = new E12GenericUtility().parseString(reqPopxml);
			if(currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
			{
			E12GenericUtility gn = new E12GenericUtility();
			reqPopxml = gn.xmlToJSONString(reqPopxml);
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

//		
//		if( "json".equalsIgnoreCase(returnType) && currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null )
//		{
//			E12GenericUtility gn = new E12GenericUtility();
//			try {
//				reqPopxml = gn.xmlToJSONString(reqPopxml);
//			} catch (Exception e) {
//				e.printStackTrace();
//			}
//		}
//
//		response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
//		response.setHeader("Cache-Control", "no-cache");
//		try {
//			response.getWriter().write(reqPopxml);
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
		return reqPopxml;
	}


}
