/* Name : WsfaSampleGiftItem
 * Purpose : Validation and Item Change for  Sample and Gift
 * Developed By : Shahu Mali
 * */
package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class WsfaSampleGiftItem extends ValidatorEJB implements WsfaSampleGiftItemLocal,WsfaSampleGiftItemRemote
{

	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	String winName = null;
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		String errCode="";
		String errorType = "";
		String errString = "";
		String itemCode="";
		String itemSer="";
		String applicableToStr="";
		String itemTypeStr="";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		//ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");

		try
		{
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				System.out.println("inside Detail 1=================>");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					System.out.println("inside for loop======================>");
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("child node name =================>"+childNodeName);

					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						System.out.println("inside item_code is equal=======================");
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLITEMCO";
							System.out.println("null item code ============>"+errCode);
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						if ( editFlag != null && editFlag.trim().length() > 0 && "A".equalsIgnoreCase(editFlag.trim()) )
						{
							itemCode = genericUtility.getColumnValue("item_code", dom);
							System.out.println("properties name is equal===========>"+itemCode);
							sql="select count(*) from item_own where item_code = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,itemCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							if(cnt >0)
							{
								errCode = "INVITEMCOD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("descr"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLITEMD";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if(childNodeName.equalsIgnoreCase("item_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLITEMTY";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}
					else if(childNodeName.equalsIgnoreCase("applicable_to"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLAPPLTO";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							applicableToStr=genericUtility.getColumnValue("applicable_to", dom);
							itemTypeStr=genericUtility.getColumnValue("item_type", dom);
							if("S".equalsIgnoreCase(itemTypeStr))
							{
								if(!("M".equalsIgnoreCase(applicableToStr)))
								{
									errList.add("INVSAMPLE");
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}

				}
				break;
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	private String errorType(Connection conn , String errorCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); //added by Kailash on 11-04-2018
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
}
