/*
Modified By :- Vinayak Dwivedi
Date:-         29/09/2015
*/
package ibase.webitm.ejb.wsfa.masters;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class Locality extends ValidatorEJB implements LocalityLocal,LocalityRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: LocalityEJB: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from LocalityEJB wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		ResultSet rs = null;
		ResultSet rsTmp = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int count = 0;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
			//Commented by vinayak on [08/07/2016]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [08/07/2016]
			connectionObject = getConnection();//Added by vinayak on [08/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			stmt = connectionObject.createStatement();

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						
						//Commented by Sachin Satre om [27-Feb-19] no need to validate the locality code becuase its auto genrated [start]
						if (childNodeName.equalsIgnoreCase("locality_code"))
						{
							if(childNode.getFirstChild() == null)
							{
								//Commented by gulzar on 26OCT23 - D23GALD003. Locality creation will be auto for all clients.
								//errString = getErrorString( "locality_code", "NULLOCCODE", userId );
							}
							else if(  editFlag.equalsIgnoreCase("A") )
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									String sql = "SELECT * FROM LOCALITY WHERE LOCALITY_CODE = '"+columnValue+"'";
									rs = stmt.executeQuery(sql);
									if ( rs.next() )
									{
										errString = getErrorString( "locality_code", "UNIQVALERR", userId );
									}
									//modified by kailash on 09-04-18 [Start]
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									//modified by kailash on 09-04-18 [End]
								}
							}
						}
						else
						//Commented by Sachin Satre om [27-Feb-19] no need to validate the locality code becuase its auto genrated [start]
						if (childNodeName.equalsIgnoreCase("city"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "city", "NULCITY", userId );
							}
						}
						else if (childNodeName.equalsIgnoreCase("descr"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "descr", "NULDESC", userId );
							}
						}
						else if ( childNodeName.equalsIgnoreCase("stan_code") )
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "stan_code", "NULSTACODE", userId );
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									String sql = "SELECT * FROM STATION WHERE STAN_CODE = '"+columnValue+"'";
									rs = stmt.executeQuery(sql);
									if ( !rs.next() )
									{
										errString = getErrorString( "stan_code", "STANOTEXT", userId );
									}
								}
							}
						}
						//Added by vinayak for locality subtype validation on [29/09/2015] [start]
						else if (childNodeName.equalsIgnoreCase("locality_subtype"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "locality_subtype", "NULOCSTYPE", userId );
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE '"+columnValue+"' "+
											 "IN(SELECT FLD_VALUE FROM GENCODES WHERE "+
											 "UPPER(MOD_NAME) = 'W_LOCALITY' AND UPPER(FLD_NAME) = 'LOCALITY_SUBTYPE' ) " +
											 "AND UPPER(MOD_NAME) = 'W_LOCALITY' AND UPPER(FLD_NAME) = 'LOCALITY_SUBTYPE' ";
								rs = stmt.executeQuery(sql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count == 0 )
								{
									errString = getErrorString( "locality_subtype", "NOLOCSTYPE", userId );
									break;
								}
								//modified by kailash on 09-04-18 [Start]
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								//modified by kailash on 09-04-18 [End]
							}
						}
						//Added by vinayak for locality subtype validation on [29/09/2015] [end]
						else if (childNodeName.equalsIgnoreCase("locality_type"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "locality_type", "NULLOCTYPE", userId );
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE '"+columnValue+"' "+
											 "IN(SELECT FLD_VALUE FROM GENCODES WHERE "+
											 "UPPER(MOD_NAME) = 'W_LOCALITY' AND UPPER(FLD_NAME) = 'LOCALITY_TYPE' ) " +
											 "AND UPPER(MOD_NAME) = 'W_LOCALITY' AND UPPER(FLD_NAME) = 'LOCALITY_TYPE' ";
								rs = stmt.executeQuery(sql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count == 0 )
								{
									errString = getErrorString( "locality_type", "NOLOCTYPE", userId );
									break;
								}
								rs.close();
								rs = null;
							}
						}
						else if (childNodeName.equalsIgnoreCase("status"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "status", "NULLSTATUS", userId );
								break;
							}
							else
							{
								String localityCode	= checkNull(genericUtility.getColumnValue("locality_code",dom));
								//Added by Sachin Satre on [27-Feb-19] start
								String wfStatus = checkNull(genericUtility.getColumnValue("wf_status",dom));
								String confirmedVal = checkNull(genericUtility.getColumnValue("aprv_stat",dom));
								String confirmed_val_ho = checkNull(genericUtility.getColumnValue("confirmed_val_ho",dom));
								System.out.println("::wfStatus::["+wfStatus+"]::::confirmedVal::["+confirmedVal+"]::confirmed_val_ho::["+confirmed_val_ho+"]");
								
								String sql = "SELECT LOCALITY_CODE , WF_STATUS , APRV_STAT FROM LOCALITY WHERE LOCALITY_CODE = '"+localityCode+"'";
								//String sql = "SELECT LOCALITY_CODE  FROM LOCALITY WHERE LOCALITY_CODE = '"+localityCode+"'";//Addded Bt Atish R on 03 Nov 2019

								pstmt = connectionObject.prepareStatement(sql);
								rs = pstmt.executeQuery();
								String wfStatusDB ="";
								String confirmedValDB ="";
								if (rs.next())
								{
									wfStatusDB = checkNull(rs.getString("WF_STATUS"));
									confirmedValDB = checkNull(rs.getString("APRV_STAT"));
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if( (wfStatusDB != null && wfStatusDB.trim().length() > 0 ) && (confirmedValDB != null && confirmedValDB.trim().length() > 0 ) )
								{
									if( (wfStatus != null && wfStatus.trim().length() > 0 ) && (confirmedVal != null && confirmedVal.trim().length() > 0 ) )
									{
									   if( (wfStatusDB.equalsIgnoreCase(wfStatus) && "S".equalsIgnoreCase(wfStatusDB) ) && (confirmedValDB.equalsIgnoreCase(confirmedVal) && "P".equalsIgnoreCase(confirmedValDB) ) )
									   {
										   errString = getErrorString( "status", "PENDAPRVRP", userId );
											break;
									   } 
										
									}
								}	
								/*if( ( wfStatus != null &&  "S".equalsIgnoreCase(wfStatus)) &&   (confirmedVal != null && "P".equalsIgnoreCase(confirmedVal) ) )//  && (confirmed_val_ho != null && "P".equalsIgnoreCase(confirmed_val_ho) ) )
								{
									errString = getErrorString( "status", "PENDAPRVRP", userId );
									break;
								}*/
								//Added by Sachin Satre on [27-Feb-19] End
								
								
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								sql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE LOCALITY_CODE = '"+localityCode+"' AND STATUS = 'A' ";
								rs = stmt.executeQuery(sql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								rs.close();
								rs = null;
								if ( count > 0 && columnValue != null && columnValue.equalsIgnoreCase("N") )
								{
									errString = getErrorString( "status", "VMSTAC", userId );
									break;
								}
								sql = "SELECT COUNT(*) AS COUNT FROM SPRS_CHEMIST,CHEMIST "+
									"WHERE SPRS_CHEMIST.CHEM_CODE = CHEMIST.CHEM_CODE "+
									"AND CHEMIST.LOCALITY_CODE = '"+localityCode+"' AND SPRS_CHEMIST.STATUS = 'Y'";
								rs = stmt.executeQuery(sql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count > 0 && columnValue != null && columnValue.equalsIgnoreCase("N") )
								{
									errString = getErrorString( "status", "VMSTAC", userId );
									break;
								}
								rs.close();
								rs = null;
								//Following code added by Gulzar on 03/08/10 to throw error message if any Doctor is available [WS90SUN049]
								String sprsCode = "";
								String routeId = "";

								/*
								String countSql = "SELECT COUNT(*) AS COUNT FROM STRG_SERIES WHERE SALES_PERS = ? AND STATUS = 'Y' AND ROUTE_ID = ? " ;
								pstmt = conn.prepareStatement(countSql);
								sql = "SELECT SPRS_CODE, ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND STATUS = 'Y' ";
								stmt = conn.createStatement();
								rs = stmt.executeQuery(selectSql);
								while ( rs.next() )
								{
									sprsCode = rs.getString("SPRS_CODE");
									routeId = rs.getString("ROUTE_ID");

									pstmt.setString( 1, sprsCode );
									pstmt.setString( 2, routeId );
									rsTmp = pstmt.executeQuery();
									pstmt.clearParameters();
									if ( rsTmp.next() )
									{
										count = rs.getInt("COUNT");
									}
									if ( count > 0 && columnValue != null && columnValue.equalsIgnoreCase("N") )
									{
										errString = getErrorString( "status", "ACTDRSEXST", userId );
										break;
									}
									rsTmp.close();
									rsTmp = null;
								}
								rs.close();
								rs = null;
								*/
								String countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND STATUS ='Y' " +
										"AND (SELECT COUNT(*) FROM STRG_SERIES WHERE STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE " +
										"AND STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID AND STRG_SERIES.STATUS ='Y') > 0 ";
								rs = stmt.executeQuery(countSql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count > 0 && columnValue != null && columnValue.equalsIgnoreCase("N") )
								{
									errString = getErrorString( "status", "ACTDRSEXST", userId );
									break;
								}
								rs.close();
								rs = null;

								countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCode+"' AND STATUS ='Y' " +
										"AND (SELECT COUNT(*) FROM SPRS_STOCKIST WHERE SPRS_STOCKIST.SPRS_CODE = SPRS_ROUTE.SPRS_CODE " +
										"AND SPRS_STOCKIST.ROUTE_ID = SPRS_ROUTE.ROUTE_ID AND SPRS_STOCKIST.STATUS ='Y') > 0 ";
								rs = stmt.executeQuery(countSql);
								if ( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count > 0 && columnValue != null && columnValue.equalsIgnoreCase("N") )
								{
									errString = getErrorString( "status", "ACTSTOCKST", userId );
									break;
								}
								rs.close();
								rs = null;
								//End changes by Gulzar  03/08/10 [WS90SUN049]
							}
						}
						//Added by kailash on 26-02-19 for chc related change[start]
						else if ( childNodeName.equalsIgnoreCase("locality_class") )
						{
							int cnt= 0;
							if(childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("columnValue360["+columnValue+"]");
								if( columnValue != null )
								{
									String sql = "SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_NAME = 'LOCALITY_CLASS' AND MOD_NAME ='W_LOCALITY' AND FLD_VALUE = ?";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										cnt = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(cnt == 0)
									{
										errString = getErrorString( "locality_class", "INVLOCCLAS", userId );
										break;
									}
								}
							}
						}
						else if ( childNodeName.equalsIgnoreCase("def_distributor") )
						{
							int cnt= 0;
							if(childNode.getFirstChild() != null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								System.out.println("columnValue["+columnValue+"]");
								if( columnValue != null )
								{
									String sql = "SELECT COUNT (*) AS COUNT FROM STRG_CUSTOMER WHERE CUST_TYPE = 'S' AND SC_CODE = ? AND STATUS='Y' ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										cnt = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(cnt == 0)
									{
										errString = getErrorString( "def_distributor", "INVDEFDIS", userId );
										break;
									}
								}
							}
						}
						//Added by kailash on 26-02-19 for chc related change[end]
					}
					if ( errString != null && errString.trim().length() > 0 )
					{
						break;
					}
				}
			}

		catch(Exception e)
		{
			System.out.println("Exception: LocalityEJB: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e); //added by Kailash on 11-04-2018-
		}
		finally
		{
			try
			{
				//Gulzar - 03/08/10
				if ( rsTmp != null )
				{
					rsTmp.close();
					rsTmp = null;
				}
				//End Gulzar - 03/08/10
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by kailash on 09-04-18 [Start]
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				//Added by kailash on 09-04-18 [End]
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (Exception e1){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :LocalityEJB :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from LocalityEJB itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String columnValue = "";
		String returnString = "";
		String stanCodeDescr = "";
		String countCode = "";
		String countryDescr = "";
		String stationDescr ="";
		String stateCode = "";
		String city = "";
		String routeId = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		ResultSet rs = null;
		ResultSet rSet = null;
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//Added by vinayak on [06/10/2015] [start]
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String chgDate = sdf.format(new java.util.Date());
			String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			//Added by vinayak on [06/10/2015] [end]
			//Added by Sachin Satre on [26-Feb-19] [Start]
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("@@@@ loginEmpCode ::"+loginEmpCode);
			//Added by Sachin Satre on [26-Feb-19] [Start]
			

			ConnDriver connDriver = null;
			//Commented by vinayak on [08/07/2016]
			/*connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [08/07/2016]
			connectionObject = getConnection();//Added by vinayak on [08/07/2016] to get connection.
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
            //valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");

			stmt = connectionObject.createStatement();
			//Added by Sachin Satre on [18-Jan-19] start
            boolean isEmpCodeHO = false ;
			isEmpCodeHO = checkHOEmployee(loginEmpCode ,connectionObject ) ;
			//Added by Sachin Satre on [18-Jan-19] End
			
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					String getGradeCodeSql = "SELECT (UPPER (EMP_FNAME )|| '  ' || UPPER(EMP_MNAME) || '  ' || UPPER(EMP_LNAME) )AS EMP_NAME,EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt = connectionObject.prepareStatement(getGradeCodeSql);
					pstmt.setString(1,loginEmpCode);
					rSet = pstmt.executeQuery();
					String empName ="";
					if( rSet.next())
					{
						empName =rSet.getString("EMP_NAME");
					}
					if(rSet != null)
					{
						rSet.close();
						rSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						System.out.println("inside itm_default...");
						String localityDescr="";
						String localityCode =  checkNull( genericUtility.getColumnValue("locality_code", dom) );
						String sql="SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityCode);
						rs = pstmt.executeQuery();					
						if( rs.next() )
						{
							localityDescr  = rs.getString("DESCR");
							System.out.println("inside itm_default localityDescr..."+localityDescr);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							
							pstmt.close();
							pstmt = null;
						}
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
						//added by shraddha M[08/07/2020]start
						String stateDescr="";
						String stateCodeVal =  checkNull( genericUtility.getColumnValue("state_code", dom) );
						String stateSql = "SELECT DESCR FROM STATE WHERE STATE_CODE= ?";
						pstmt = connectionObject.prepareStatement(stateSql);
						pstmt.setString(1, stateCodeVal);
						rs = pstmt.executeQuery();					
						if( rs.next() )
						{
							stateDescr  = rs.getString("DESCR");
							System.out.println("itm_default stateDescr..."+stateDescr);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(stateCodeVal!=null)
						{
							valueXmlString.append("<state_code><![CDATA[").append(stateCodeVal).append("]]></state_code>\r\n");
							valueXmlString.append("<state_descr><![CDATA[").append(stateDescr).append("]]></state_descr>\r\n");
						}
						//added by shraddha M[08/07/2020]end
						//valueXmlString.append("<status>").append("A").append("</status>\r\n");
						if (isEmpCodeHO ==  true )
						{
							valueXmlString.append("<wf_status protect='1' ><![CDATA[").append("S").append("]]></wf_status>\r\n");
							valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
							valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("A").append("]]></confirmed_val_ho>\r\n");
							valueXmlString.append("<status ><![CDATA[").append("A").append("]]></status>\r\n");
							//valueXmlString.append("<emp_code__aprv><![CDATA[").append(chgUser.trim()).append("]]></emp_code__aprv>\r\n");//
						}
						else
						{
							valueXmlString.append("<wf_status><![CDATA[").append("D").append("]]></wf_status>\r\n");
							valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("P").append("]]></aprv_stat>\r\n");
							valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("P").append("]]></confirmed_val_ho>\r\n");
							//valueXmlString.append("<status><![CDATA[").append("A").append("]]></status>\r\n");
							valueXmlString.append("<status protect='1' ><![CDATA[").append("N").append("]]></status>\r\n"); // Changed by Sachin Satre on [26-Feb-19]
						}	
						//added by saurabh [25/dec/15] | To display Locality as default value for locality_class [Start]
						//valueXmlString.append("<locality_class><![CDATA[").append("L").append("]]></locality_class>\r\n");
						//added by saurabh [25/dec/15] | To display Locality as default value for locality_class [End]
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]

						//Added by vinayak on [06/10/2015] [start]
						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
						valueXmlString.append("<emp_code__login><![CDATA[").append(loginEmpCode.trim()).append("]]></emp_code__login>\r\n");
						valueXmlString.append("<login_emp_name><![CDATA[").append(empName).append("]]></login_emp_name>\r\n");
						
						valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");
						valueXmlString.append("<descr><![CDATA[").append(localityDescr).append("]]></descr>\r\n");
						//Added by vinayak on [06/10/2015] [end]
					}
					//Added by kailash on 26-02-19 for chc related changes[start]
					/*if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						String localityClass = genericUtility.getColumnValue("locality_class",dom);
						System.out.println("localityClass["+localityClass+"]");
						String fldValue= "";
						String descr= "";
						String sql = "SELECT FLD_VALUE,DESCR FROM GENCODES WHERE FLD_NAME='LOCALITY_CLASS' AND MOD_NAME ='W_LOCALITY' AND FLD_VALUE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityClass);
						rs= pstmt.executeQuery();
						if( rs.next() )
						{
							fldValue = checkNull(rs.getString("FLD_VALUE"));
							descr = checkNull(rs.getString("DESCR"));
							valueXmlString.append("<locality_class_descr><![CDATA[").append(descr).append("]]></locality_class_descr>\r\n");
						}
						else
						{
							valueXmlString.append("<locality_class_descr><![CDATA[").append("").append("]]></locality_class_descr>\r\n");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}*/
					//Added by kailash on 26-02-19 for chc related changes[end]
					//Added By Nilesh Start :: 08-07-19
					else if ( currentColumn.trim().equalsIgnoreCase("descr") )
					{
						columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));
						System.out.println("columnValue+++"+columnValue);
						if( columnValue .trim().length() > 15)
						{
							String shortDscr = columnValue.substring(0, 15);
							System.out.println("shortDscr::::"+shortDscr);
							valueXmlString.append("<sh_descr><![CDATA[").append(shortDscr).append("]]></sh_descr>\r\n");
							
						}
						else
						{
							valueXmlString.append("<sh_descr><![CDATA[").append(columnValue).append("]]></sh_descr>\r\n");
						}
						
					}
					//Added By Nilesh Start :: 08-07-19
					else if ( currentColumn.trim().equalsIgnoreCase("stan_code") )
					{
						valueXmlString.append("<locality_class><![CDATA[").append("L").append("]]></locality_class>\r\n");
						
						String sql = "SELECT FLD_VALUE,DESCR FROM GENCODES WHERE FLD_NAME='LOCALITY_CLASS' AND MOD_NAME ='W_LOCALITY' AND FLD_VALUE = 'L' ";
						pstmt = connectionObject.prepareStatement(sql);
						//pstmt.setString(1, columnValue);
						rs= pstmt.executeQuery();
						if( rs.next() )
						{
							//fldValue = checkNull(rs.getString("FLD_VALUE"));
							String descr = checkNull(rs.getString("DESCR"));
							valueXmlString.append("<locality_class_descr><![CDATA[").append(descr).append("]]></locality_class_descr>\r\n");
						}
						else
						{
							valueXmlString.append("<locality_class_descr><![CDATA[").append("").append("]]></locality_class_descr>\r\n");
						}
						//Added by Bhagyashri T for Close dirty connection---[25-JAN-2022][START]
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//Added by Bhagyashri T for Close dirty connection---[25-JAN-2022][END]
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						String selStaSql = "SELECT DESCR,STATE_CODE,CITY FROM STATION WHERE STAN_CODE = '"+columnValue+"' ";

						rs = stmt.executeQuery(selStaSql);
						if( rs.next() )
						{
							stationDescr = rs.getString(1);
							stateCode = rs.getString(2);
							city = rs.getString(3);
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<station_descr>").append(stationDescr).append("</station_descr>\r\n");
							valueXmlString.append("<city>").append(stationDescr).append("</city>\r\n");
							valueXmlString.append("<state_code>").append(stateCode).append("</state_code>\r\n");*/
							valueXmlString.append("<station_descr><![CDATA[").append(stationDescr).append("]]></station_descr>\r\n");
							//valueXmlString.append("<city><![CDATA[").append(stationDescr).append("]]></city>\r\n");
							valueXmlString.append("<city><![CDATA[").append(city).append("]]></city>\r\n");
							valueXmlString.append("<state_code><![CDATA[").append(stateCode).append("]]></state_code>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<station_descr>").append("").append("</station_descr>\r\n");
							valueXmlString.append("<city>").append("").append("</city>\r\n");
							valueXmlString.append("<state_code>").append("").append("</state_code>\r\n");*/
							valueXmlString.append("<station_descr><![CDATA[").append("").append("]]></station_descr>\r\n");
							valueXmlString.append("<city><![CDATA[").append("").append("]]></city>\r\n");
							valueXmlString.append("<state_code><![CDATA[").append("").append("]]></state_code>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						rs.close();
						rs = null;
						String selStateSql = "SELECT DESCR,COUNT_CODE FROM STATE WHERE STATE_CODE = '"+stateCode+"'";
						rs = stmt.executeQuery(selStateSql);
						if( rs.next() )
						{
							stanCodeDescr = rs.getString(1);
							countCode = rs.getString(2);
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<state_descr>").append(stanCodeDescr).append("</state_descr>\r\n");
							valueXmlString.append("<count_code>").append(countCode).append("</count_code>\r\n");*/
							valueXmlString.append("<state_descr><![CDATA[").append(stanCodeDescr).append("]]></state_descr>\r\n");
							valueXmlString.append("<count_code><![CDATA[").append(countCode).append("]]></count_code>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<state_descr>").append("").append("</state_descr>\r\n");
							valueXmlString.append("<count_code>").append("").append("</count_code>\r\n");*/
							valueXmlString.append("<state_descr><![CDATA[").append("").append("]]></state_descr>\r\n");
							valueXmlString.append("<count_code><![CDATA[").append("").append("]]></count_code>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						rs.close();
						rs = null;
						String selCountSql = "SELECT DESCR FROM COUNTRY WHERE COUNT_CODE = '"+countCode+"'";
						rs = stmt.executeQuery(selCountSql);
						if( rs.next())
						{
							countryDescr = rs.getString(1);
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<country_descr>").append(countryDescr).append("</country_descr>\r\n");
							valueXmlString.append("<country_descr><![CDATA[").append(countryDescr).append("]]></country_descr>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<country_descr>").append("").append("</country_descr>\r\n");
							valueXmlString.append("<country_descr><![CDATA[").append("").append("]]></country_descr>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						rs.close();
						rs = null;
					}
					//Added by kailash on 26-02-19 for chc related changes[start]
					else if ( currentColumn.trim().equalsIgnoreCase("locality_class") )
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						System.out.println("columnValue locality_class["+columnValue+"]");
						String fldValue= "";
						String descr= "";
						String sql = "SELECT FLD_VALUE,DESCR FROM GENCODES WHERE FLD_NAME='LOCALITY_CLASS' AND MOD_NAME ='W_LOCALITY' AND FLD_VALUE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rs= pstmt.executeQuery();
						if( rs.next() )
						{
							fldValue = checkNull(rs.getString("FLD_VALUE"));
							descr = checkNull(rs.getString("DESCR"));
							valueXmlString.append("<locality_class_descr><![CDATA[").append(descr).append("]]></locality_class_descr>\r\n");
						}
						else
						{
							valueXmlString.append("<locality_class_descr><![CDATA[").append("").append("]]></locality_class_descr>\r\n");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else if ( currentColumn.trim().equalsIgnoreCase("def_distributor") )
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						System.out.println("columnValue def_distributor["+columnValue+"]");
						String scCode= "";
						String name= "";
						String sql = "SELECT SC_CODE,(FIRST_NAME || ' ' || MIDDLE_NAME || ' ' || LAST_NAME) AS NAME FROM STRG_CUSTOMER WHERE CUST_TYPE='S' AND STATUS='Y' AND SC_CODE= ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rs= pstmt.executeQuery();
						if( rs.next() )
						{
							scCode = checkNull(rs.getString("SC_CODE"));
							name = checkNull(rs.getString("NAME"));
							valueXmlString.append("<def_distributor_name><![CDATA[").append(name).append("]]></def_distributor_name>\r\n");
						}
						else
						{
							valueXmlString.append("<def_distributor_name><![CDATA[").append("").append("]]></def_distributor_name>\r\n");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					//Added by kailash on 26-02-19 for chc related changes[end]
					
					//Added by Sachin Satre on [26-Feb-19] [Start]
					else if ( currentColumn.trim().equalsIgnoreCase("wf_status") )
					{
						
					}
					else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
					{
						String Status = checkNull(genericUtility.getColumnValue("status",dom));

						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status",dom));
						String confirmedVal = checkNull(genericUtility.getColumnValue("aprv_stat",dom));
						String confirmed_val_ho = checkNull(genericUtility.getColumnValue("confirmed_val_ho",dom));
						System.out.println("::Status::["+Status+"]::confirmedVal::["+confirmedVal+"]::confirmed_val_ho::["+confirmed_val_ho+"]::wfStatus::["+wfStatus+"]");
						//valueXmlString.append("<wf_status protect='1'><![CDATA[").append(wfStatus).append("]]></wf_status>\r\n");
						//valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append(confirmedVal).append("]]></aprv_stat>\r\n");
						
						if ( isEmpCodeHO ==  true )
						{
							valueXmlString.append("<wf_status protect='1' ><![CDATA[").append("S").append("]]></wf_status>\r\n");
							valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
							valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("A").append("]]></confirmed_val_ho>\r\n");
							valueXmlString.append("<status ><![CDATA[").append(Status).append("]]></status>\r\n");
							//valueXmlString.append("<emp_code__aprv><![CDATA[").append(chgUser.trim()).append("]]></emp_code__aprv>\r\n");
						}
						else
						{
							//valueXmlString.append("<wf_status><![CDATA[").append("D").append("]]></wf_status>\r\n");
							//valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("P").append("]]></aprv_stat>\r\n");
							//valueXmlString.append("<status><![CDATA[").append("A").append("]]></status>\r\n");
							if( ( wfStatus != null &&  "S".equalsIgnoreCase(wfStatus)) &&   (confirmedVal != null && "A".equalsIgnoreCase(confirmedVal)))
							{
								valueXmlString.append("<wf_status protect='1' ><![CDATA[").append(wfStatus).append("]]></wf_status>\r\n");
								valueXmlString.append("<status protect='0' ><![CDATA[").append(Status).append("]]></status>\r\n"); // Changed by Sachin Satre on [26-Feb-19]
								valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
								valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("A").append("]]></confirmed_val_ho>\r\n");
								
							}
							else if( ( wfStatus != null &&  "D".equalsIgnoreCase(wfStatus)) &&   (confirmedVal != null && "P".equalsIgnoreCase(confirmedVal)))
							{
								valueXmlString.append("<wf_status protect='0' ><![CDATA[").append(wfStatus).append("]]></wf_status>\r\n");
								valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append(confirmedVal).append("]]></aprv_stat>\r\n");
								valueXmlString.append("<status protect='1' ><![CDATA[").append(Status).append("]]></status>\r\n"); // Changed by Sachin Satre on [26-Feb-19]
								valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("P").append("]]></confirmed_val_ho>\r\n");
							}
							else
							{
								if( (wfStatus ==  null || wfStatus.trim().length() == 0 ) &&  (confirmedVal ==  null || confirmedVal.trim().length() == 0) )
								{
									valueXmlString.append("<wf_status protect='1'><![CDATA[").append("S").append("]]></wf_status>\r\n");
									valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
									valueXmlString.append("<confirmed_val_ho protect='1'><![CDATA[").append("A").append("]]></confirmed_val_ho>\r\n");
									valueXmlString.append("<status protect='0' ><![CDATA[").append(Status).append("]]></status>\r\n"); // Changed by Sachin Satre on [26-Feb-19]
								}
								else
								{
									valueXmlString.append("<status protect='0' ><![CDATA[").append(Status).append("]]></status>\r\n"); // Changed by Sachin Satre on [26-Feb-19]
								}	
							}	
						}	
						valueXmlString.append("<emp_code__login><![CDATA[").append(loginEmpCode.trim()).append("]]></emp_code__login>\r\n");
						valueXmlString.append("<login_emp_name><![CDATA[").append(empName).append("]]></login_emp_name>\r\n");
						if( wfStatus ==  null || wfStatus.trim().length() == 0 )
						{
							//valueXmlString.append("<wf_status protect='1'><![CDATA[").append("S").append("]]></wf_status>\r\n");
						}
						if( confirmedVal ==  null || confirmedVal.trim().length() == 0 )
						{
							//valueXmlString.append("<aprv_stat protect='1'><![CDATA[").append("A").append("]]></aprv_stat>\r\n");
						}
					
						String localityClass = genericUtility.getColumnValue("locality_class",dom);
						System.out.println("localityClass["+localityClass+"]");
						String fldValue= "";
						String descr= "";
						String sql = "SELECT FLD_VALUE,DESCR FROM GENCODES WHERE FLD_NAME='LOCALITY_CLASS' AND MOD_NAME ='W_LOCALITY' AND FLD_VALUE = ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityClass);
						rs= pstmt.executeQuery();
						if( rs.next() )
						{
							fldValue = checkNull(rs.getString("FLD_VALUE"));
							descr = checkNull(rs.getString("DESCR"));
							valueXmlString.append("<locality_class_descr><![CDATA[").append(descr).append("]]></locality_class_descr>\r\n");
						}
						else
						{
							valueXmlString.append("<locality_class_descr><![CDATA[").append("").append("]]></locality_class_descr>\r\n");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					//Added by Sachin Satre on [26-Feb-19] [End]
					
					else if ( currentColumn.trim().equalsIgnoreCase("locality_code") )
					{
						System.out.println("inside locality_code...");
						String localityDescr="";
						String localityCode =  checkNull( genericUtility.getColumnValue(currentColumn, dom) );
						String sql="SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityCode);
						rs = pstmt.executeQuery();					
						if( rs.next() )
						{
							localityDescr  = rs.getString("DESCR");
							System.out.println("inside localityDescr..."+localityDescr);
							valueXmlString.append("<descr><![CDATA[").append(localityDescr).append("]]></descr>\r\n");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						
					}
					valueXmlString.append("</Detail>\r\n");
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :LocalityEJB :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by Kailash on 11-04-2018
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				//Added by Bhagyashri T for Close dirty connection---[25-JAN-2022][START]
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T for Close dirty connection---[25-JAN-2022][END]
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (Exception e1){}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	
	//Added by Sachin Satre on [26-Feb-19] [Start]
 	private boolean checkHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		boolean isHo = false ;
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
			"WHERE A.EMP_CODE = ? " + 
			"AND A.PROFILE_ID = B.PROFILE_ID " +
			"AND B.APPLICATION = 'MRO' " +
			"AND B.MENU_ROW = 1 " +       
			"AND B.MENU_COL = 1 " +       
			"AND B.MENU_SUBCOL = 1 " +
			"AND B.LEVEL_4 = 1 " +        
			"AND B.LEVEL_5 = 1 " +        
			"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode.trim() );
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));	
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if( empCodeHO != null && empCodeHO.trim().length() > 0 )
			{
				isHo = true ;
			}	
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return isHo;
	}
 	//Added by Sachin Satre on [26-Feb-19] [End]
}
