/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration;

import ibase.bankIntegration.BankBean;
import ibase.bankIntegration.unsHsbc.UNSHSBC;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BankIntegration
extends ActionHandlerEJB {
    BankBean bankBean = new BankBean();

    public String confirmfual(String tranID, String xtraParam, Connection conn) throws ITMException {
        String result = "";
        System.out.println(" Inside BankIntegration GSB confirm tranID [" + tranID + "] xtraParam [" + xtraParam + "]");
        E12GenericUtility genericUtility = new E12GenericUtility();
        ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
        DBAccessEJB dbAccess = new DBAccessEJB();
        String objName = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "objName");
        BaseLogger.log((String)"3", null, null, (Object)("Inside sendJSONData2UNS objName [" + objName + "]"));
        try {
            if (objName.equals("follow_up_actions_logs")) {
                objName = dbAccess.getDBColumnValue("FOLLOW_UP_ACTIONS_LOGS", "OBJ_NAME", " TRAN_ID = '" + tranID + "' ", this.getUserInfo().getTransDB());
                tranID = dbAccess.getDBColumnValue("FOLLOW_UP_ACTIONS_LOGS", "REF_ID", " OBJ_NAME = '" + objName + "' AND TRAN_ID = '" + tranID + "' ", this.getUserInfo().getTransDB());
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in BankIntegration.confirmfual [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            throw new ITMException(e);
        }
        try {
            String bankCode = this.getBankCodeFromTranID(tranID, this.getUserInfo());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("bankCode in [MiscPayConfirm]: [" + bankCode + "]"));
            Boolean isIntegrated = this.isIntegrated(bankCode, this.getUserInfo());
            BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("isItegrated in [MiscPayConfirm]: [" + isIntegrated + "]"));
            if (isIntegrated.booleanValue()) {
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("getUserInfo() [" + this.getUserInfo() + "]"));
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)"Bank Integration is configured!");
                String executeSystemEventFromBIres = this.executeSystemEvent(tranID, this.getUserInfo(), xtraParam);
                BaseLogger.log((String)"3", (UserInfoBean)this.getUserInfo(), null, (Object)("testres in [MiscPayConfirm] " + executeSystemEventFromBIres));
                result = executeSystemEventFromBIres;
            } else {
                result = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Selected bank is not integrated. ]]></RESULT></ROOT>";
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
            throw new ITMException(e);
        }
        return result;
    }

    public boolean isIntegrated(String bankCode, UserInfoBean userInfo) throws SQLException {
        boolean result = false;
        BaseLogger.log((String)"3", null, null, (Object)"Inside isIntegrated method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String isIntegratedSQL = "SELECT IS_INTEGRATED, PAY_INT_SERVICE FROM BANK WHERE BANK_CODE = ?";
                pstmt = connection.prepareStatement(isIntegratedSQL);
                pstmt.setString(1, bankCode);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String isIntegrated = rs.getString("IS_INTEGRATED");
                    String payIntService = rs.getString("PAY_INT_SERVICE");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class isIntegrated [" + isIntegrated + "]"));
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class payIntService [" + payIntService + "]"));
                    this.bankBean.setPayInitService(payIntService);
                    if (!isIntegrated.equalsIgnoreCase("Y")) continue;
                    result = true;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    public String getBankCodeFromTranID(String tranID, UserInfoBean userInfo) throws SQLException {
        String bankCode = "";
        BaseLogger.log((String)"3", null, null, (Object)"Inside getBankCodeFromTranID method of BankIntegration class ...");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getBankCodeSQL = "SELECT BANK_CODE FROM MISC_PAYMENT WHERE TRAN_ID = ?";
                pstmt = connection.prepareStatement(getBankCodeSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    bankCode = rs.getString("BANK_CODE");
                    BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class bankCode [" + bankCode + "]"));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return bankCode;
    }

    public String executeSystemEvent(String tranID, UserInfoBean userInfo, String xtraParams) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)("Inside isIntegrated method of BankIntegration class tranID gsb [" + tranID + "]"));
        String result = "";
        String eventCode = this.bankBean.getPayInitService();
        BaseLogger.log((String)"3", null, null, (Object)("Inside executeSystemEvent method of BankIntegration class eventCode [" + eventCode + "]"));
        Connection connection = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                UNSHSBC unshsbc = new UNSHSBC();
                result = unshsbc.actionHandler(tranID, xtraParams, connection);
                BaseLogger.log((String)"3", null, null, (Object)("BI.executeSystemEvent result [" + result + "]"));
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }
}

