/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.E12TransEditorCoreModel;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.bean.PopUpBean;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PopupDataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BaseLogger.log("2", null, null, "XXXXXXXXXXXXXXXXXXXXXX[ SearchListServlet ]XXXXXXXXXXXXXXXXXXXX");
        try {
            request.setCharacterEncoding(CommonConstants.ENCODING);
            String opFormat = request.getParameter("OUTPUT_FORMAT");
            BaseLogger.log("2", null, null, "OUTPUT_FORMAT[" + opFormat + "]");
            if ("JSON".equalsIgnoreCase(opFormat)) {
                this.getPophelpJSON(request, response);
            } else {
                this.getPophelpXML(request, response);
            }
        }
        catch (ITMException item) {
            item.printStackTrace();
            try {
                String itmExpMsg = item.getMessage();
                response.setHeader("Cache-Control", "no-cache");
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                response.getWriter().write(itmExpMsg);
                response.getWriter().flush();
                response.getWriter().close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void getPophelpXML(HttpServletRequest request, HttpServletResponse response) throws ServletException, ITMException {
        try {
            String objName = null;
            objName = request.getParameter("OBJ_NAME") != null && request.getParameter("OBJ_NAME") != (String)request.getSession().getAttribute("OBJ_NAME") ? request.getParameter("OBJ_NAME") : (String)request.getSession().getAttribute("OBJ_NAME");
            String fieldName = request.getParameter("FIELDNAME");
            fieldName = fieldName.trim();
            StringTokenizer st = null;
            String[] parameters = null;
            String keyString = request.getParameter("KEYSTRING");
            String xmlString = "";
            String allDetailXML = "";
            String coreMdlId = request.getParameter("CORE_MDL_ID");
            String editorId = coreMdlId;
            Object sess = null;
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String user = userInfo.getLoginCode();
            allDetailXML = this.getDetailDomData(request, editorId, user);
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            String formNo = this.checkNull(request.getParameter("FORM_NO"));
            Document allDetailDom = null;
            if (allDetailXML != null && allDetailXML.length() > 0) {
                allDetailDom = e12GenericUtility.parseString(allDetailXML);
            }
            String nodevalue = "";
            String objcontext = "1";
            if (keyString != null) {
                keyString = keyString.substring(1).trim();
                st = new StringTokenizer(keyString, ":");
            }
            if (st != null && st.countTokens() > 1) {
                parameters = new String[st.countTokens()];
                int ctr = 0;
                boolean flag = false;
                while (st.hasMoreTokens()) {
                    Node detailNode;
                    String curToken = st.nextToken();
                    nodevalue = "";
                    if (curToken.indexOf(".") != -1) {
                        objcontext = curToken.substring(0, curToken.indexOf("."));
                        curToken = curToken.substring(curToken.indexOf(".") + 1);
                    }
                    flag = true;
                    curToken = curToken.indexOf(",") != -1 ? curToken.substring(0, curToken.indexOf(",")) : curToken;
                    BaseLogger.log("3", userInfo, editorId, "curToken: " + curToken);
                    NodeList detailNodeList = null;
                    if (objcontext != null && objcontext.length() > 0 && objcontext.equalsIgnoreCase("0")) {
                        objcontext = "1";
                    }
                    BaseLogger.log("3", userInfo, editorId, "objcontext:[" + objcontext + "]--formno [" + formNo + "]");
                    if (objcontext.equalsIgnoreCase(formNo)) {
                        nodevalue = request.getParameter(curToken);
                        BaseLogger.log("3", userInfo, editorId, "nodevalue if form = objcontxt [" + nodevalue + "]");
                    } else if (allDetailDom != null && (detailNodeList = allDetailDom.getElementsByTagName("Detail" + objcontext)) != null && (detailNode = detailNodeList.item(0)) != null) {
                        detailNodeList = detailNode.getChildNodes();
                        BaseLogger.log("3", userInfo, editorId, "observNode.getLength()-" + detailNodeList.getLength());
                        int cnt = 0;
                        while (cnt < detailNodeList.getLength()) {
                            detailNode = detailNodeList.item(cnt);
                            if (detailNode.getFirstChild() != null && detailNode.getNodeName().equalsIgnoreCase(curToken)) {
                                nodevalue = detailNode.getFirstChild().getNodeValue();
                                BaseLogger.log("3", userInfo, editorId, "nodevalue----" + nodevalue);
                                break;
                            }
                            ++cnt;
                        }
                    }
                    parameters[ctr] = nodevalue;
                    ++ctr;
                }
            } else {
                parameters = new String[1];
                if (keyString != null && keyString.indexOf(".") != -1) {
                    objcontext = keyString.substring(0, keyString.indexOf("."));
                    keyString = keyString.substring(keyString.indexOf(".") + 1);
                    parameters[0] = request.getParameter(keyString);
                } else {
                    parameters[0] = request.getParameter(keyString);
                }
            }
            PopUpBean popUpBean = new PopUpBean(userInfo);
            popUpBean.setObjName(objName);
            xmlString = popUpBean.getPopUpXML(fieldName, parameters, "");
            PrintWriter out = response.getWriter();
            out.println(xmlString);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    private void getPophelpJSON(HttpServletRequest request, HttpServletResponse resp) throws ServletException, ITMException {
        try {
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String jsonString = "";
            if (userInfo != null) {
                String objName = this.checkNull(request.getParameter("OBJ_NAME"));
                String fieldName = this.checkNull(request.getParameter("FIELDNAME"));
                String keyString = this.checkNull(request.getParameter("KEYSTRING"));
                String isBiPophelp = this.checkNull(request.getParameter("IS_BI_POPHELP"));
                System.out.println(" INside getPophelpJSON isBiPophelp " + isBiPophelp);
                StringTokenizer st = null;
                Object[] parameters = null;
                System.out.println(" INside getPophelpJSON keyString [" + keyString + "]");
                if ("true".equalsIgnoreCase(isBiPophelp)) {
                    st = new StringTokenizer(keyString, ",");
                } else if (keyString != null) {
                    keyString = keyString.substring(1).trim();
                    st = new StringTokenizer(keyString, ":");
                }
                if (st != null && st.countTokens() > 1) {
                    parameters = new String[st.countTokens()];
                    int ctr = 0;
                    boolean flag = false;
                    while (st.hasMoreTokens()) {
                        String curToken = st.nextToken();
                        if (curToken.indexOf(".") != -1) {
                            curToken = curToken.substring(curToken.indexOf(".") + 1);
                        }
                        flag = true;
                        String string = curToken = curToken.indexOf(",") != -1 ? curToken.substring(0, curToken.indexOf(",")) : curToken;
                        if ("true".equalsIgnoreCase(isBiPophelp)) {
                            curToken = curToken.indexOf(":") != -1 ? curToken.substring(curToken.indexOf(":") + 1) : curToken;
                        }
                        BaseLogger.log("3", userInfo, null, "curToken: " + curToken);
                        if ("true".equalsIgnoreCase(isBiPophelp) && parameters[ctr] == null) {
                            BaseLogger.log("3", userInfo, null, "curToken in caps[" + curToken.toUpperCase() + "]");
                            parameters[ctr] = request.getParameter(curToken.toUpperCase());
                        } else {
                            parameters[ctr] = request.getParameter(curToken);
                        }
                        ++ctr;
                    }
                } else {
                    parameters = new String[1];
                    if (keyString != null && keyString.indexOf(".") != -1) {
                        keyString = keyString.substring(keyString.indexOf(".") + 1);
                        parameters[0] = request.getParameter(keyString);
                    } else {
                        parameters[0] = request.getParameter(keyString);
                    }
                }
                BaseLogger.log("3", userInfo, null, "parameters : [" + Arrays.toString(parameters) + "]");
                PopUpBean popUpBean = new PopUpBean(userInfo);
                popUpBean.setObjName(objName);
                jsonString = popUpBean.getPopUpJSON(fieldName, (String[])parameters, isBiPophelp);
            }
            BaseLogger.log("3", userInfo, null, "jsonString : [" + jsonString + "]");
            PrintWriter out = resp.getWriter();
            out.println(jsonString);
        }
        catch (ITMException ex) {
            ex.printStackTrace();
            throw new ITMException(ex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getDetailDomData(HttpServletRequest request, String editorId, String user) {
        HttpSession sess = null;
        String retXMLStr = null;
        try {
            E12TransEditorCoreModel transEditorCoreModel;
            sess = request.getSession();
            BaseLogger.log("3", null, editorId, "In getDetailDomData");
            String tempEditorID = editorId;
            editorId = String.valueOf(editorId) + user;
            MasterStatefulRemote masterRem = null;
            if (sess.getAttribute(editorId) instanceof MasterStatefulRemote) {
                masterRem = (MasterStatefulRemote)sess.getAttribute(editorId);
            } else if (sess.getAttribute(tempEditorID) instanceof ITMTransactionCoreModel) {
                ITMTransactionCoreModel transactionCoreModel = (ITMTransactionCoreModel)sess.getAttribute(tempEditorID);
                if (transactionCoreModel != null) {
                    masterRem = transactionCoreModel.getMasterStateful();
                }
            } else if (sess.getAttribute(editorId) instanceof E12TransEditorCoreModel && (transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId)) != null) {
                masterRem = transEditorCoreModel.getMasterStateful();
            }
            if (masterRem != null) {
                BaseLogger.log("3", null, editorId, "Inside getAutoSearchDomData of E12EditorHadler line no 308");
                retXMLStr = masterRem.getDetailDomData();
                BaseLogger.log("3", null, editorId, "Inside retXMLStr of popupdataservlet[" + retXMLStr + "]");
            }
        }
        catch (Exception e) {
            retXMLStr = null;
            BaseLogger.log("0", null, editorId, "Exception :popupdataservlet :getChangedData :==>" + e.getMessage());
        }
        return retXMLStr;
    }
}

