/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.bean.ChangePasswordBean;
import ibase.bean.EventLogInfoBean;
import ibase.bean.ExtAuthAppAPIBean;
import ibase.bean.ExtAuthApplicationBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.ExtServiceEJB;
import ibase.ejb.UserEventLogEJB;
import ibase.servlet.Messages;
import ibase.sessionnotification.ClientWebsocketNotification;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMTransactionEditorBean;
import ibase.webitm.ejb.AuditTrailExtEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.ExtServiceEventManagerEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.ejb.UserActivationEJB;
import ibase.webitm.ejb.UserEnterpriseEJB;
import ibase.webitm.ejb.sys.UserAccountsLock;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import ibase.webitm.utility.hrp.Attd_eSalarySlip;
import ibase.wrkflw.E12FollowUpActionEJB;
import ibase.wrkflw.SignManagerEJB;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class E12ExtServiceUtility
extends RestAPIServiceUtility {
    HttpServletRequest requestGlobal = null;
    private UserInfoBean userInfo = null;
    private E12GenericUtility genericUtility = new E12GenericUtility();
    private CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
    private APIUtility apiUtility = new APIUtility();

    public String getExtServiceData(String dataFor, String userCode, String password, String isPwdEncrypt, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, HttpServletRequest request) throws ITMException {
        JSONObject resultJson = new JSONObject();
        String result = "";
        String status = "error";
        try {
            dataFor = E12GenericUtility.checkNull(dataFor);
            userCode = E12GenericUtility.checkNull(userCode);
            password = E12GenericUtility.checkNull(password);
            isPwdEncrypt = E12GenericUtility.checkNull(isPwdEncrypt).length() > 0 ? E12GenericUtility.checkNull(isPwdEncrypt) : "false";
            String authStatus = "";
            if (userCode.length() > 0) {
                authStatus = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                if ("VALID".equalsIgnoreCase(authStatus)) {
                    if (this.userInfo == null) {
                        this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                    }
                    if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                        status = "Reject";
                        result = "Daily API call limit exceeded";
                    } else {
                        String xtraParams = this.getXtraParams();
                        result = this.executeSystemEvent(dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams);
                        status = "success";
                        resultJson.put("status", (Object)status);
                    }
                } else {
                    status = "error";
                    result = authStatus;
                    resultJson.put("status", (Object)status);
                }
            } else {
                result = "You are not authorized to access.";
                resultJson.put("status", (Object)"error");
            }
            resultJson.put("results", (Object)result);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getExtServiceData : " + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        this.writeAPICallLog("getExtServiceData ( /getExtServiceData )", status, result, null, request, this.userInfo);
        return resultJson.toString();
    }

    public String getExtnServiceData(String dataFor, String userCode, String password, String isPwdEncrypt, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, HttpServletRequest request) throws ITMException {
        String status = "";
        String result = "";
        JSONObject resultJson = new JSONObject();
        try {
            dataFor = E12GenericUtility.checkNull(dataFor);
            userCode = E12GenericUtility.checkNull(userCode);
            password = E12GenericUtility.checkNull(password);
            isPwdEncrypt = E12GenericUtility.checkNull(isPwdEncrypt).length() > 0 ? E12GenericUtility.checkNull(isPwdEncrypt) : "false";
            String authStatus = "";
            if (userCode.length() > 0) {
                authStatus = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                if ("VALID".equalsIgnoreCase(authStatus)) {
                    if (this.userInfo == null) {
                        this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                    }
                    if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                        status = "Reject";
                        result = "Daily API call limit exceeded";
                    } else {
                        String xtraParams = this.getXtraParams();
                        result = this.executeSystemEvent(dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams);
                        status = "success";
                        resultJson.put("status", (Object)status);
                    }
                } else {
                    status = "error";
                    resultJson.put("status", (Object)status);
                    result = authStatus;
                }
            } else {
                resultJson.put("status", (Object)"error");
                result = "You are not authorized to access.";
            }
            resultJson.put("results", (Object)result);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getExtServiceData : " + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        this.writeAPICallLog("getExtnServiceData ( /getExtServiceClient )", status, result, null, request, this.userInfo);
        return resultJson.toString();
    }

    public String authenticateUser(String userCode, String password, String isPwdEncrypt, String dataFormat, boolean isDestroySession, String appId, HttpServletRequest request) throws BaseException {
        String status;
        String result;
        block20: {
            result = "";
            String params = "";
            String tokenId = "";
            status = "error";
            String responseFormat = "";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&IS_DESTROY_SESSION=" + isDestroySession);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, null, false, appId, "login");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            responseFormat = this.commonDBAccessEJB.getDBColumnValue("auth_apps_api", "resp_data_format", "where app_id='" + appId + "' and endpoint='login'", "Driver");
                            BaseLogger.log("3", null, null, "responseFormat from DB - [" + responseFormat + "]");
                            if (responseFormat.equals("2")) {
                                dataFormat = "JSONString";
                            }
                            userCode = this.checkNull(userCode);
                            password = this.checkNull(password);
                            isPwdEncrypt = this.checkNull(isPwdEncrypt).length() > 0 ? this.checkNull(isPwdEncrypt) : "false";
                            String isValidLogin = "false";
                            if (userCode.length() > 0) {
                                isValidLogin = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                                if ("VALID".equalsIgnoreCase(isValidLogin)) {
                                    tokenId = this.generateNewTokenId(userCode);
                                    BaseLogger.log("3", null, null, "tokenId - " + tokenId.length());
                                    request.getSession().setAttribute("TOKEN_ID", (Object)tokenId);
                                    request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                                    JSONObject resultDtlJson = new JSONObject();
                                    resultDtlJson.put("TOKEN_ID", (Object)tokenId);
                                    resultDtlJson.put("EMP_ID", (Object)this.getUserInfo().getEmpCode());
                                    resultDtlJson = this.getUserDtl(resultDtlJson);
                                    resultDtlJson.put("LOGIN_CODE", (Object)this.getUserInfo().getLoginCode());
                                    result = resultDtlJson.toString();
                                    BaseLogger.log("3", null, null, "login code in result " + result);
                                    request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                                    if (!"JSON".equalsIgnoreCase(dataFormat) && !"JSONString".equalsIgnoreCase(dataFormat)) {
                                        result = this.genericUtility.jsonToXMLString(result);
                                    }
                                    status = "success";
                                } else {
                                    result = isValidLogin;
                                    status = "error";
                                }
                            } else {
                                result = "Please enter username.";
                                status = "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : authenticateUser : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
                    BaseLogger.log("3", null, null, "result---> authernticateUser() [" + result + "]");
                    BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
                BaseLogger.log("3", null, null, "result---> authernticateUser() [" + result + "]");
                BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                }
                throw throwable;
            }
            result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
            BaseLogger.log("3", null, null, "result---> authernticateUser() [" + result + "]");
            BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
            }
        }
        this.writeAPICallLog("authenticateUser ( /login )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String authenticateUserClient(String userCode, String password, String isPwdEncrypt, String inputString, String dataFormat, HttpServletRequest request, boolean isDestroySession, String appId) throws BaseException {
        String status;
        String result;
        block20: {
            this.requestGlobal = request;
            result = "";
            String params = "";
            String tokenId = "";
            status = "error";
            String responseFormat = "";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&IS_DESTROY_SESSION=" + isDestroySession);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, null, false, appId, "login");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            responseFormat = this.commonDBAccessEJB.getDBColumnValue("auth_apps_api", "resp_data_format", "where app_id='" + appId + "' and endpoint='login'", "Driver");
                            BaseLogger.log("3", null, null, "responseFormat from DB - [" + responseFormat + "]");
                            if (responseFormat.equals("2")) {
                                dataFormat = "JSONString";
                            }
                            userCode = this.checkNull(userCode);
                            password = this.checkNull(password);
                            isPwdEncrypt = this.checkNull(isPwdEncrypt).length() > 0 ? this.checkNull(isPwdEncrypt) : "false";
                            String isValidLogin = "false";
                            if (userCode.length() > 0) {
                                isValidLogin = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                                if ("VALID".equalsIgnoreCase(isValidLogin)) {
                                    tokenId = this.generateNewTokenId(userCode);
                                    BaseLogger.log("3", null, null, "tokenId - " + tokenId.length());
                                    request.getSession().setAttribute("TOKEN_ID", (Object)tokenId);
                                    request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                                    JSONObject resultDtlJson = new JSONObject();
                                    resultDtlJson.put("TOKEN_ID", (Object)tokenId);
                                    resultDtlJson.put("EMP_ID", (Object)this.getUserInfo().getEmpCode());
                                    resultDtlJson = this.getUserDtl(resultDtlJson);
                                    resultDtlJson.put("LOGIN_CODE", (Object)this.getUserInfo().getLoginCode());
                                    result = resultDtlJson.toString();
                                    if (!"JSON".equalsIgnoreCase(dataFormat) && !"JSONString".equalsIgnoreCase(dataFormat)) {
                                        result = this.genericUtility.jsonToXMLString(result);
                                    }
                                    status = "success";
                                } else {
                                    result = isValidLogin;
                                    status = "error";
                                }
                            } else {
                                result = "Please enter username.";
                                status = "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : authenticateUser : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
                    BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
                BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                }
                throw throwable;
            }
            result = this.generateResponse(request, "login", params, tokenId, dataFormat, status, result);
            BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
            }
        }
        this.writeAPICallLog("authenticateUserClient ( /login )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String authenticateUserClientJSON(String userCode, String password, String isPwdEncrypt, String inputString, String dataFormat, HttpServletRequest request, boolean isDestroySession, String appId) throws BaseException {
        String result;
        block14: {
            result = "";
            String params = "";
            String tokenId = "";
            String status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&IS_DESTROY_SESSION=" + isDestroySession);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = appId.equals("FLUTTERAPP") ? "valid" : this.validateRequest(request, dataFormat, null, false, appId, "login");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        userCode = this.checkNull(userCode);
                        password = this.checkNull(password);
                        isPwdEncrypt = this.checkNull(isPwdEncrypt).length() > 0 ? this.checkNull(isPwdEncrypt) : "false";
                        String isValidLogin = "false";
                        if (userCode.length() > 0) {
                            isValidLogin = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                            if ("VALID".equalsIgnoreCase(isValidLogin)) {
                                tokenId = CryptographyUtil.createBase64EncodedPermanentJWTWithAppId(appId, userCode);
                                BaseLogger.log("3", null, null, "tokenId - " + tokenId.length());
                                BaseLogger.log("3", null, null, "permanent Token ID ======== " + tokenId);
                                request.getSession().setAttribute("TOKEN_ID", (Object)tokenId);
                                request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                                JSONObject resultDtlJson = new JSONObject();
                                resultDtlJson.put("TOKEN_ID", (Object)tokenId);
                                resultDtlJson.put("EMP_ID", (Object)this.getUserInfo().getEmpCode());
                                resultDtlJson = this.getUserDtl(resultDtlJson);
                                resultDtlJson.put("LOGIN_CODE", (Object)this.getUserInfo().getLoginCode());
                                String userInfoStr = this.genericUtility.xmlToJSONString(this.getUserInfo().toString()).replace("\\", "");
                                BaseLogger.log("3", null, null, " slash result json userInfoStr - " + userInfoStr);
                                resultDtlJson.put("USER_INFO", (Object)new JSONObject(userInfoStr));
                                result = resultDtlJson.toString();
                                BaseLogger.log("3", null, null, "result json String - " + result);
                                if (!"JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.jsonToXMLString(result);
                                }
                                status = "success";
                            } else {
                                result = isValidLogin;
                                status = "error";
                            }
                        } else {
                            result = "Please enter username.";
                            status = "error";
                        }
                        break block14;
                    }
                    status = "error";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : authenticateUser : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateJSONResponse(request, "login", params, tokenId, dataFormat, status, result);
                    BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                    }
                }
            }
            finally {
                result = this.generateJSONResponse(request, "login", params, tokenId, dataFormat, status, result);
                BaseLogger.log("3", null, null, "isSessionDestroy [" + isDestroySession + "]");
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                }
            }
        }
        return result;
    }

    public String forgotPassword(String userCode, String dataFormat, String applicationHashCode, String appId, HttpServletRequest request) {
        String status;
        String result;
        block17: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, null, false, appId, "forgot_password");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String empStatus = this.getCommonDBAccess().checkEmpStatus(userCode);
                            Date empDeactDate = this.getCommonDBAccess().checkEmpDeactDate(userCode);
                            Date currentDate = new Date();
                            if ("".equals(empStatus) || "A".equalsIgnoreCase(empStatus)) {
                                if (empDeactDate != null && empDeactDate.before(currentDate)) {
                                    result = Messages.getString("AuthenticateServlet_notAnActiveUser", this.getUserLangAndCountry(userCode));
                                    status = "error";
                                } else {
                                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                                    String condition = " CODE = '" + userCode + "' ";
                                    String emailId = dbAccessEJB.getDBColumnValue("USERS", "EMAIL_ID", condition);
                                    dbAccessEJB = null;
                                    BaseLogger.log("3", null, null, "emailId - [" + emailId + "]");
                                    String clientIP = this.checkNull(request.getRemoteAddr());
                                    String string = clientIP = clientIP.length() > 0 ? clientIP : "SYSTEM";
                                    if (this.checkNull(emailId).length() > 0) {
                                        String varCode = this.getCommonDBAccess().sendVarificationCode(userCode, applicationHashCode);
                                        result = "Verification Code : " + varCode;
                                        this.getCommonDBAccess().secureAccount(userCode, "0", this.userInfo, clientIP, "");
                                        this.getCommonDBAccess().updatePasswordChgLog(userCode, clientIP, "Browser");
                                        result = String.valueOf(Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID", this.getUserLangAndCountry(userCode))) + " [" + emailId + "]";
                                        status = "success";
                                    } else {
                                        result = "Email Id Not Found !";
                                        status = "error";
                                    }
                                }
                            } else {
                                result = Messages.getString("AuthenticateServlet_pleaseEnterValidUser", this.getUserLangAndCountry(userCode));
                                status = "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : forgotPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
        }
        this.writeAPICallLog("forgotPassword ( /forgot_password )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String forgotPasswordClient(String userCode, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    if (!"FLUTTERAPP".equals(appId)) {
                        result = this.validateRequest(request, dataFormat, null, false, appId, "forgot_password");
                        BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    }
                    if ("valid".equalsIgnoreCase(result) || "FLUTTERAPP".equals(appId)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo) && !"FLUTTERAPP".equals(appId)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String empStatus = this.getCommonDBAccess().checkEmpStatus(userCode);
                            Date empDeactDate = this.getCommonDBAccess().checkEmpDeactDate(userCode);
                            Date currentDate = new Date();
                            if ("".equals(empStatus) || "A".equalsIgnoreCase(empStatus)) {
                                if (empDeactDate != null && empDeactDate.before(currentDate)) {
                                    result = Messages.getString("AuthenticateServlet_notAnActiveUser", this.getUserLangAndCountry(userCode));
                                    status = "error";
                                } else {
                                    DBAccessEJB dbAccessEJB = new DBAccessEJB();
                                    String condition = " CODE = '" + userCode + "' ";
                                    String emailId = dbAccessEJB.getDBColumnValue("USERS", "EMAIL_ID", condition);
                                    dbAccessEJB = null;
                                    BaseLogger.log("3", null, null, "emailId - [" + emailId + "]");
                                    String clientIP = this.checkNull(request.getRemoteAddr());
                                    String string = clientIP = clientIP.length() > 0 ? clientIP : "SYSTEM";
                                    if (this.checkNull(emailId).length() > 0) {
                                        String varCode = this.getCommonDBAccess().sendVarificationCode(userCode);
                                        result = "Verification Code : " + varCode;
                                        this.getCommonDBAccess().secureAccount(userCode, "0", this.userInfo, clientIP, "");
                                        this.getCommonDBAccess().updatePasswordChgLog(userCode, clientIP, "Browser");
                                        result = String.valueOf(Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID", this.getUserLangAndCountry(userCode))) + " [" + emailId + "]";
                                        status = "success";
                                    } else {
                                        result = "Email Id Not Found !";
                                        status = "error";
                                    }
                                }
                            } else {
                                result = Messages.getString("AuthenticateServlet_pleaseEnterValidUser", this.getUserLangAndCountry(userCode));
                                status = "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : forgotPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
        }
        this.writeAPICallLog("forgotPasswordClient ( /forgot_password )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String changePassword(String userCode, String oldPassword, String newPassword, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            String newPwdSHA256 = request.getParameter("newPwdSHA256");
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&OLD_PASS=" + oldPassword);
                        paramString.append("&NEW_PASS=" + newPassword);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "change_password");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    String deviceId = request.getParameter("MAC_ADDRESS");
                    if (deviceId == null || deviceId.trim().length() == 0) {
                        deviceId = request.getParameter("DEVICEID");
                    }
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else if (this.getCommonDBAccess().checkOldPassword(userCode, oldPassword, this.userInfo)) {
                            if (this.getCommonDBAccess().validatePassword(newPassword, this.userInfo)) {
                                if (!this.getCommonDBAccess().checkPassHistory(userCode, newPassword, this.userInfo)) {
                                    ChangePasswordBean chgPasswordBean = new ChangePasswordBean();
                                    chgPasswordBean.updatePassword(userCode, newPassword, newPwdSHA256, this.userInfo.getUserLanguage(), this.userInfo, request.getRemoteAddr(), deviceId);
                                    result = "Password updated successfully";
                                    status = "success";
                                } else {
                                    result = "Password already use. Please enter new password.";
                                    status = "error";
                                }
                            } else {
                                result = "The password must contain at least one uppercase character, lowercase character, special character and a digit.";
                                status = "error";
                            }
                        } else {
                            result = Messages.getString("AuthenticateServlet_pleaseEnterValidUserNameAndPassword", this.getUserLangAndCountry(userCode));
                            status = "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : chgPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("changePassword ( /change_password )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String changePasswordClient(String userCode, String oldPassword, String newPassword, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        UserInfoBean userInfo;
        String status;
        String result;
        block22: {
            result = "";
            String params = "";
            status = "error";
            String newPwdSHA256 = request.getParameter("newPwdSHA256");
            boolean isError = false;
            userInfo = null;
            try {
                try {
                    if (tokenId == null) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = this.apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "changePasswordClient() appId=" + appId);
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&OLD_PASS=" + oldPassword);
                        paramString.append("&NEW_PASS=" + newPassword);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    String deviceId = request.getParameter("MAC_ADDRESS");
                    if (deviceId == null || deviceId.trim().length() == 0) {
                        deviceId = request.getParameter("DEVICEID");
                    }
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        result = this.validateRequest(request, dataFormat, tokenId, true, appId, "change_password");
                        BaseLogger.log("3", null, null, "changePasswordClient validateRequest - [" + result + "]");
                        if (!"valid".equalsIgnoreCase(result)) {
                            isError = true;
                            status = "Reject";
                        }
                        if (!isError && this.apiUtility.checkDailyAPILimit(userInfo)) {
                            isError = true;
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        }
                    }
                    if (!isError) {
                        if (this.getCommonDBAccess().checkOldPassword(userCode, oldPassword, userInfo)) {
                            if (this.getCommonDBAccess().validatePassword(newPassword, userInfo)) {
                                if (!this.getCommonDBAccess().checkPassHistory(userCode, newPassword, userInfo)) {
                                    ChangePasswordBean chgPasswordBean = new ChangePasswordBean();
                                    chgPasswordBean.updatePassword(userCode, newPassword, E12GenericUtility.checkNull(newPwdSHA256), userInfo.getUserLanguage(), userInfo, request.getRemoteAddr(), deviceId);
                                    result = "Password updated successfully";
                                } else {
                                    isError = true;
                                    result = "Password exists.";
                                    status = "error";
                                }
                            } else {
                                isError = true;
                                result = "The password must contain at least one uppercase character, lowercase character, special character and a digit.";
                                status = "error";
                            }
                        } else {
                            isError = true;
                            result = Messages.getString("AuthenticateServlet_pleaseEnterValidUserNameAndPassword", this.getUserLangAndCountry(userCode));
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : chgPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
                    break block22;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("changePasswordClient ( /change_password )", status, result, appId, request, userInfo);
        return result;
    }

    public String logout(String userCode, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block16: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "logout");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else if (this.checkNull(userCode).length() > 0) {
                            String sessionUserCode = this.userInfo.getLoginCode();
                            if (userCode.equals(sessionUserCode)) {
                                if (this.validateUserSession(request, tokenId)) {
                                    this.logout(userCode, request);
                                    result = "Logout successfully";
                                    status = "success";
                                }
                            } else {
                                result = "Invalid user.";
                                status = "error";
                            }
                        } else {
                            result = "Please enter username.";
                            status = "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Exception : chgPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("logout ( /logout )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String logoutClient(String userCode, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block16: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("USER_CODE=" + userCode);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "logout");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else if (this.checkNull(userCode).length() > 0) {
                            String sessionUserCode = this.userInfo.getLoginCode();
                            if (userCode.equals(sessionUserCode)) {
                                if (this.validateUserSession(request, tokenId)) {
                                    this.logout(userCode, request);
                                    result = "Logout successfully";
                                    status = "success";
                                }
                            } else {
                                result = "Invalid user.";
                                status = "error";
                            }
                        } else {
                            result = "Please enter username.";
                            status = "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : chgPassword : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("logoutClient ( /logout )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String callSystemAction(String action, String objName, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request, ServletContext context) {
        String status;
        String result;
        block15: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("ACTION=" + action);
                        BaseLogger.log("3", null, null, "action = " + action);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "callSystemAction");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            boolean isRightsAvailable;
                            inputString = this.checkNull(inputString);
                            if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                inputString = this.genericUtility.jsonToXMLString(inputString);
                            }
                            if (isRightsAvailable = this.isObjectRightsAvailable(inputString)) {
                                result = this.checkNull(this.processRequest(inputString, context));
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            } else {
                                status = "error";
                                result = "Rights not available for a provided object.";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : callSystemAction : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("callSystemAction ( /callSystemAction )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String callSystemActionClient(String action, String objName, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request, ServletContext context) {
        String status;
        String result;
        block15: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("ACTION=" + action);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "callSystemAction");
                    BaseLogger.log("3", null, null, "validateRequest :: 888 :: - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            boolean isRightsAvailable;
                            inputString = this.checkNull(inputString);
                            if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                inputString = this.genericUtility.jsonToXMLString(inputString);
                            }
                            if (isRightsAvailable = this.isObjectRightsAvailable(inputString)) {
                                result = this.checkNull(this.processRequest(inputString, context));
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            } else {
                                status = "error";
                                result = "Rights not available for a provided object.";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : callSystemAction [" + e.getMessage() + "]");
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("callSystemActionClient ( /callSystemAction )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String callSystemEvent(String objName, String eventCode, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block15: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("EVENT_CODE=" + eventCode);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "callSystemEvent");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            BaseLogger.log("3", null, null, "getUserInfo() - " + this.getUserInfo().toString());
                            EventManagerEJB eventManager = new EventManagerEJB();
                            if (eventManager.isEventExist(objName, eventCode, this.userInfo)) {
                                String transDB = this.userInfo.getTransDB();
                                String xmlString = inputString;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(inputString);
                                }
                                result = this.checkNull(transDB).length() > 0 ? this.executeSystemEvent(objName, eventCode, xmlString, xmlString, "1", this.getXtraParams(), this.userInfo) : this.executeSystemEvent(objName, eventCode, xmlString, xmlString, "1", this.getXtraParams());
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            } else {
                                status = "error";
                                result = "Event Code not found.";
                            }
                            eventManager = null;
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : callSystemEvent : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("callSystemEvent ( /callSystemEvent )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String callSystemEventClient(String objName, String eventCode, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block15: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("EVENT_CODE=" + eventCode);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "callSystemEvent");
                    BaseLogger.log("9", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            BaseLogger.log("3", null, null, "getUserInfo() - " + this.getUserInfo().toString());
                            EventManagerEJB eventManager = new EventManagerEJB();
                            if (eventManager.isEventExist(objName, eventCode, this.userInfo)) {
                                String transDB = this.userInfo.getTransDB();
                                String xmlString = inputString;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(inputString);
                                }
                                result = this.checkNull(transDB).length() > 0 ? this.executeSystemEvent(objName, eventCode, xmlString, xmlString, "1", this.getXtraParams(), this.userInfo) : this.executeSystemEvent(objName, eventCode, xmlString, xmlString, "1", this.getXtraParams());
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            } else {
                                status = "error";
                                result = "Event Code not found.";
                            }
                            eventManager = null;
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : callSystemEvent : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("callSystemEventClient ( /callSystemEvent )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getData(String objName, String refId, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            BaseLogger.log("3", null, null, "Inside getData : E12ExtServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getData");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getData ( /getData )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getDataClient(String objName, String refId, String tokenId, String enterprise, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            BaseLogger.log("3", null, null, "Inside getDataClient : E12ExtServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        if (appId.equals("FLUTTERAPP")) {
                            paramString.append("getData");
                        } else {
                            paramString.append("/ibase/rest/E12ExtService/getData/").append(objName).append("/").append(enterprise).append("/").append(appId);
                        }
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params gsb- " + params);
                    ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails(params, null);
                    BaseLogger.log("3", null, null, "visionEdiBean : [" + authAppAPIBean + "]");
                    if (authAppAPIBean == null) {
                        status = "Reject";
                        result = "This service not available";
                    } else if ((tokenId = this.checkNull(tokenId)).length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                    } else {
                        result = this.validateRequest(request, dataFormat, tokenId, true, appId, params);
                        BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                        if ("valid".equalsIgnoreCase(result)) {
                            if (this.userInfo == null) {
                                this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                            }
                            if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                                status = "Reject";
                                result = "Daily API call limit exceeded";
                            } else {
                                result = this.getDetailXMLDomString(objName, "1", "V", refId, null);
                                BaseLogger.log("3", null, null, " variable: resultinXML: [" + result + "]" + "method: getDataClient : class: E12ExtServiceUtility ");
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                    BaseLogger.log("3", null, null, " variable: resultinJSON: [" + result + "]" + "method: getDataClient : class: E12ExtServiceUtility ");
                                }
                                status = "success";
                            }
                        } else {
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getExtServiceData ( /getExtServiceData )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getPopHelpData(String objName, String fieldName, String inputString, String tokenId, String dataFormat, String inputStringAllXml, String formNo, String reqParams, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&FIELDNAME=" + fieldName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&INPUT_STR_ALL=" + inputStringAllXml);
                        paramString.append("&FORM_NO=" + formNo);
                        paramString.append("&REQ_PARAMS=" + reqParams);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "fieldPophelp");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            fieldName = this.checkNull(fieldName);
                            inputString = this.checkNull(inputString);
                            inputStringAllXml = this.checkNull(inputStringAllXml);
                            formNo = this.checkNull(formNo);
                            reqParams = this.checkNull(reqParams);
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (fieldName.length() == 0) {
                                result = "Please enter valid Field Name.";
                                status = "error";
                            } else {
                                String xmlString = inputString;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(inputString);
                                }
                                String xmlStringAll = inputStringAllXml;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputStringAllXml.length() > 0) {
                                    xmlStringAll = this.genericUtility.jsonToXMLString(inputStringAllXml);
                                }
                                result = this.getpopUpKeyStr(objName, fieldName, xmlString, this.getUserInfo(), xmlStringAll, formNo, reqParams);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getPopHelpData : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getPopHelpData ( /fieldPophelp )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getPopHelpDataClient(String objName, String fieldName, String inputString, String tokenId, String dataFormat, String inputStringAllXml, String formNo, String reqParams, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&FIELDNAME=" + fieldName);
                        paramString.append("&INPUT_STR=" + inputString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&INPUT_STR_ALL=" + inputStringAllXml);
                        paramString.append("&FORM_NO=" + formNo);
                        paramString.append("&REQ_PARAMS=" + reqParams);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "fieldPophelp");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            fieldName = this.checkNull(fieldName);
                            inputString = this.checkNull(inputString);
                            inputStringAllXml = this.checkNull(inputStringAllXml);
                            formNo = this.checkNull(formNo);
                            reqParams = this.checkNull(reqParams);
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (fieldName.length() == 0) {
                                result = "Please enter valid Field Name.";
                                status = "error";
                            } else {
                                String xmlString = inputString;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(inputString);
                                }
                                String xmlStringAll = inputStringAllXml;
                                if ("JSON".equalsIgnoreCase(dataFormat) && inputStringAllXml.length() > 0) {
                                    xmlStringAll = this.genericUtility.jsonToXMLString(inputStringAllXml);
                                }
                                result = this.getpopUpKeyStr(objName, fieldName, xmlString, this.getUserInfo(), xmlStringAll, formNo, reqParams);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Exception : getPopHelpData : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "fieldPophelp", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getPopHelpDataClient ( /fieldPophelp )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getBrowData(String objName, String argNames, String argValues, String argTypes, String advQuery, String searchParam, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block14: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&ARG_NAMES=" + argNames);
                        paramString.append("&ARG_VALUES=" + argValues);
                        paramString.append("&ARG_TYPES=" + argTypes);
                        paramString.append("&ADV_QRY=" + advQuery);
                        paramString.append("&SEARCH_PARAM=" + searchParam);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "objectBrowse");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            argNames = this.checkNull(argNames);
                            argValues = this.checkNull(argValues);
                            argTypes = this.checkNull(argTypes);
                            advQuery = this.checkNull(advQuery);
                            searchParam = this.checkNull(searchParam);
                            String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else {
                                result = this.getXMLDataForHeader(objName, argValues, argTypes, advQuery, request, searchParam, editorId);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getBrowData : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getBrowData ( /objectBrowse )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getBrowDataClient(String objName, String argNames, String argValues, String argTypes, String advQuery, String searchParam, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block14: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&ARG_NAMES=" + argNames);
                        paramString.append("&ARG_VALUES=" + argValues);
                        paramString.append("&ARG_TYPES=" + argTypes);
                        paramString.append("&ADV_QRY=" + advQuery);
                        paramString.append("&SEARCH_PARAM=" + searchParam);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "objectBrowse");
                    BaseLogger.log("9", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            argNames = this.checkNull(argNames);
                            argValues = this.checkNull(argValues);
                            argTypes = this.checkNull(argTypes);
                            advQuery = this.checkNull(advQuery);
                            searchParam = this.checkNull(searchParam);
                            String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else {
                                result = this.getXMLDataForHeader(objName, argValues, argTypes, advQuery, request, searchParam, editorId);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getBrowData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "objectBrowse", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getBrowDataClient ( /objectBrowse )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getItemChange(String objName, String transDomStr, String detailDomStr, String domId, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block23: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&TRANS_DOM=" + transDomStr);
                        paramString.append("&DETAIL_DOM=" + detailDomStr);
                        paramString.append("&DOM_ID=" + domId);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "performItemChange");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            transDomStr = this.checkNull(transDomStr);
                            detailDomStr = this.checkNull(detailDomStr);
                            domId = this.checkNull(domId);
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (domId.length() == 0) {
                                result = "Please enter valid Dom Id.";
                                status = "error";
                            } else if (transDomStr.length() == 0) {
                                result = "Please enter Transaction Dom data.";
                                status = "error";
                            } else if (detailDomStr.length() == 0) {
                                result = "Please enter Detail Dom data.";
                                status = "error";
                            } else {
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    if (transDomStr.length() > 0) {
                                        transDomStr = this.genericUtility.jsonToXMLString(transDomStr);
                                    }
                                    if (detailDomStr.length() > 0) {
                                        detailDomStr = this.genericUtility.jsonToXMLString(detailDomStr);
                                    }
                                }
                                result = this.getItemChangeData(objName, domId, transDomStr, detailDomStr);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getItemChange : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getItemChange ( /performItemChange )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getItemChangeClient(String objName, String transDomStr, String detailDomStr, String domId, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block23: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&TRANS_DOM=" + transDomStr);
                        paramString.append("&DETAIL_DOM=" + detailDomStr);
                        paramString.append("&DOM_ID=" + domId);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "performItemChange");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            transDomStr = this.checkNull(transDomStr);
                            detailDomStr = this.checkNull(detailDomStr);
                            domId = this.checkNull(domId);
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (domId.length() == 0) {
                                result = "Please enter valid Dom Id.";
                                status = "error";
                            } else if (transDomStr.length() == 0) {
                                result = "Please enter Transaction Dom data.";
                                status = "error";
                            } else if (detailDomStr.length() == 0) {
                                result = "Please enter Detail Dom data.";
                                status = "error";
                            } else {
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    if (transDomStr.length() > 0) {
                                        transDomStr = this.genericUtility.jsonToXMLString(transDomStr);
                                    }
                                    if (detailDomStr.length() > 0) {
                                        detailDomStr = this.genericUtility.jsonToXMLString(detailDomStr);
                                    }
                                }
                                result = this.getItemChangeData(objName, domId, transDomStr, detailDomStr);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getItemChange : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "performItemChange", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getItemChangeClient ( /performItemChange )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwInbox(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getInbox");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "U";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwInbox : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwInbox ( /getInbox )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwInboxClient(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getInbox");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "U";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwInbox : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getInbox", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwInboxClient ( /getInbox )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwApproved(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getApproved");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "S";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwApproved : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwApproved ( /getApproved )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwApprovedClient(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getApproved");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "S";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwApproved : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getApproved", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwApprovedClient ( /getApproved )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwRejected(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getRejected");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "R";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwRejected : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwRejected ( /getRejected )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getWrkFlwRejectedClient(String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block12: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getRejected");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            String signStatus = "R";
                            String roles = "";
                            String context1 = "";
                            String context2 = "";
                            String context3 = "";
                            String applName = "";
                            result = this.getWrkFlwBrowData(signStatus, roles, context1, context2, context3, applName, this.getUserInfo());
                            if ("JSON".equalsIgnoreCase(dataFormat)) {
                                result = this.genericUtility.xmlToJSONString(result);
                            }
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getWrkFlwRejected : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getRejected", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getWrkFlwRejectedClient ( /getRejected )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getSignTransDet(String refSer, String refId, String lineNo, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("REF_SER=" + refSer);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&LINE_NO=" + lineNo);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getSignTransDet");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            refSer = this.checkNull(refSer);
                            refId = this.checkNull(refId);
                            lineNo = this.checkNull(lineNo);
                            if (refSer.length() == 0) {
                                result = "Please enter valid Ref Series.";
                                status = "error";
                            } else if (refId.length() == 0) {
                                result = "Please enter valid Ref Id.";
                                status = "error";
                            } else if (lineNo.length() == 0) {
                                result = "Please enter valid line No.";
                                status = "error";
                            } else {
                                int lineNum = Integer.parseInt(lineNo);
                                result = this.getSignTransDetData(refSer, refId, lineNum, this.getUserInfo());
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getSignTransDet : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getSignTransDet ( /getSignTransDet )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getSignTransDetClient(String refSer, String refId, String lineNo, String tokenId, String dataFormat, String appId, HttpServletRequest request) {
        String status;
        String result;
        block18: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("REF_SER=" + refSer);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&LINE_NO=" + lineNo);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getSignTransDet");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            refSer = this.checkNull(refSer);
                            refId = this.checkNull(refId);
                            lineNo = this.checkNull(lineNo);
                            if (refSer.length() == 0) {
                                result = "Please enter valid Ref Series.";
                                status = "error";
                            } else if (refId.length() == 0) {
                                result = "Please enter valid Ref Id.";
                                status = "error";
                            } else if (lineNo.length() == 0) {
                                result = "Please enter valid line No.";
                                status = "error";
                            } else {
                                int lineNum = Integer.parseInt(lineNo);
                                result = this.getSignTransDetData(refSer, refId, lineNum, this.getUserInfo());
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Exception : getSignTransDet : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getSignTransDet", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getSignTransDetClient ( /getSignTransDet )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String updateSignStatusClient(String actionCode, String xmlString, String tokenId, String dataFormat, String uuid, String appId, HttpServletRequest request, ServletContext context) {
        String status;
        String result;
        block24: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("ACTION_CODE=" + actionCode);
                        paramString.append("&XML_STRING=" + xmlString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&UUID=" + uuid);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    if (this.checkNull(uuid).length() > 0) {
                        String condition = "UUID = '" + uuid + "' ";
                        DBAccessEJB dbAccessEJB = new DBAccessEJB();
                        String userId = dbAccessEJB.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);
                        dbAccessEJB = null;
                        if (this.checkNull(userId).length() > 0) {
                            result = "valid";
                            this.setUserInfo(this.getCommonDBAccess().createUserInfo(userId));
                        } else {
                            result = "invalid";
                        }
                        BaseLogger.log("3", null, null, "validateUUId - [" + result + "]/n UserId:::[" + userId + "]");
                    } else {
                        if (tokenId != null && appId == null) {
                            appId = this.apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        BaseLogger.log("3", null, null, "UpdateSignStatus Got AppId - [" + appId + "]");
                        if (appId.equals("FLUTTERAPP")) {
                            result = "valid";
                        } else {
                            result = this.validateRequest(request, dataFormat, tokenId, true, appId, "updateSignStatus");
                            BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                        }
                    }
                    if ("valid".equalsIgnoreCase(result) || appId.equals("FLUTTERAPP")) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (!appId.equals("FLUTTERAPP") && this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            actionCode = this.checkNull(actionCode);
                            xmlString = this.checkNull(xmlString);
                            if (actionCode.length() == 0) {
                                result = "Please enter valid Action Code.";
                                status = "error";
                            } else if (xmlString.length() == 0) {
                                result = "Please enter XML Data.";
                                status = "error";
                            } else {
                                if ("JSON".equalsIgnoreCase(dataFormat) && xmlString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(xmlString);
                                }
                                result = this.updateSignStatus(xmlString, actionCode, this.getUserInfo(), context);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : updateSignStatus : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("updateSignStatusClient ( /updateSignStatus )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String updateSignStatus(String actionCode, String xmlString, String tokenId, String dataFormat, String uuid, String appId, HttpServletRequest request, ServletContext context) {
        String status;
        String result;
        block21: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("ACTION_CODE=" + actionCode);
                        paramString.append("&XML_STRING=" + xmlString);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&UUID=" + uuid);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("9", null, null, "params - " + params);
                    if (this.checkNull(uuid).length() > 0) {
                        String condition = "UUID = '" + uuid + "' ";
                        DBAccessEJB dbAccessEJB = new DBAccessEJB();
                        String userId = dbAccessEJB.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);
                        dbAccessEJB = null;
                        if (this.checkNull(userId).length() > 0) {
                            result = "valid";
                            this.setUserInfo(this.getCommonDBAccess().createUserInfo(userId));
                        } else {
                            result = "invalid";
                        }
                        BaseLogger.log("9", null, null, "validateUUId - [" + result + "]/n UserId:::[" + userId + "]");
                    } else {
                        result = this.validateRequest(request, dataFormat, tokenId, true, appId, "updateSignStatus");
                        BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    }
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            actionCode = this.checkNull(actionCode);
                            xmlString = this.checkNull(xmlString);
                            if (actionCode.length() == 0) {
                                result = "Please enter valid Action Code.";
                                status = "error";
                            } else if (xmlString.length() == 0) {
                                result = "Please enter XML Data.";
                                status = "error";
                            } else {
                                if ("JSON".equalsIgnoreCase(dataFormat) && xmlString.length() > 0) {
                                    xmlString = this.genericUtility.jsonToXMLString(xmlString);
                                }
                                result = this.updateSignStatus(xmlString, actionCode, this.getUserInfo(), context);
                                if ("JSON".equalsIgnoreCase(dataFormat)) {
                                    result = this.genericUtility.xmlToJSONString(result);
                                }
                                status = "success";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : updateSignStatus : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "updateSignStatus", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("updateSignStatus ( /updateSignStatus )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getUserImage(String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block18: {
            BaseLogger.log("3", null, null, "Inside getUserImage : VisonObjServiceUtility ");
            BaseLogger.log("3", null, null, "getUserImage API Token is null after call - " + (tokenId == null));
            result = "";
            String params = "";
            status = "error";
            userInfo = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    if (tokenId == null || tokenId.equals(null) || tokenId.equals("null")) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getUserImage() appId=" + appId);
                    BaseLogger.log("3", null, null, "getUserImage() appId=" + appId.length());
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getUserImage", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getUserImage() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getUserImage");
                            BaseLogger.log("3", null, null, "getUserImage() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getUserImage() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        result = this.getUserImage(response, userInfo);
                        status = "success".equalsIgnoreCase(result) ? "success" : "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getUserImage : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
                throw throwable;
            }
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
        e12ExtServiceUtility.writeAPICallLog("getFormalArgs ( VisionOBJService/getPageDetails )", status, result, appId, request, userInfo);
        return result;
    }

    public String getTokenFromHeaders(HttpHeaders headers) {
        BaseLogger.log("3", null, null, "Getting header info: ");
        String tokenId = "";
        List tokenIdList = headers.getRequestHeader("TOKEN_ID");
        if (tokenIdList != null && !tokenIdList.isEmpty()) {
            BaseLogger.log("3", null, null, "Got token list item=" + tokenIdList);
            tokenId = (String)tokenIdList.get(0);
        }
        return tokenId;
    }

    public String getUserImageClient(String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response) {
        String status;
        String result;
        block11: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getUserImage");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            result = this.getUserImage(response, null);
                            status = "success".equalsIgnoreCase(result) ? "success" : "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getUserImageClient : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getUserImage", params, tokenId, dataFormat, status, result);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getUserImage", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getUserImage", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getUserImage ( /getUserImageClient )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getAttachDocument(String objName, String refSer, String refId, String docType, String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response) {
        String status;
        String result;
        block16: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REF_SER=" + refSer);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&DOC_TYPE=" + docType);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getAttachDocument");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            if ((refSer = this.checkNull(refSer)).length() == 0) {
                                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                                refSer = dbAccessEJB.getRefSer(null, objName, this.getUserInfo());
                                dbAccessEJB = null;
                            }
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (refId.length() == 0) {
                                result = "Please enter valid Ref Id.";
                                status = "error";
                            } else {
                                result = this.getAttachDocument(refId, refSer, docType, response);
                                status = "success".equalsIgnoreCase(result) ? "success" : "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getAttachDocument : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getAttachDocument ( /getAttachDocument )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String getAttachDocumentClient(String objName, String refSer, String refId, String docType, String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response) {
        String status;
        String result;
        block16: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REF_SER=" + refSer);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&DOC_TYPE=" + docType);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, dataFormat, tokenId, true, appId, "getAttachDocument");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            objName = this.checkNull(objName);
                            if ((refSer = this.checkNull(refSer)).length() == 0) {
                                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                                refSer = dbAccessEJB.getRefSer(null, objName, this.getUserInfo());
                                dbAccessEJB = null;
                            }
                            if (objName.length() == 0) {
                                result = "Please enter valid Object Name.";
                                status = "error";
                            } else if (refId.length() == 0) {
                                result = "Please enter valid Ref Id.";
                                status = "error";
                            } else {
                                result = this.getAttachDocument(refId, refSer, docType, response);
                                status = "success".equalsIgnoreCase(result) ? "success" : "error";
                            }
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getAttachDocumentClient : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, dataFormat);
                    result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getAttachDocument", params, tokenId, dataFormat, status, result);
        }
        this.writeAPICallLog("getAttachDocumentClient ( /getAttachDocument )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String keepSessionAlive(String tokenId, String appId, HttpServletRequest request) {
        String status;
        String result;
        block11: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, "JSON", tokenId, true, appId, "keepAlive");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            result = this.getUserInfo() != null ? String.valueOf(this.getUserInfo().getDesignation()) + ":" + this.getUserInfo().getDivision() + ":" + this.getUserInfo().getSiteCode() + ":" + this.getUserInfo().getDateJoin() + ":" + this.getUserInfo().getEmpName() + ":" + this.getUserInfo().getEmpCode() : "";
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : keepAlive : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
        }
        this.writeAPICallLog("keepSessionAlive ( /keepAlive )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String keepSessionAliveClient(String tokenId, String appId, HttpServletRequest request) {
        String status;
        String result;
        block11: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.validateRequest(request, "JSON", tokenId, true, appId, "keepAlive");
                    BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");
                    if ("valid".equalsIgnoreCase(result)) {
                        if (this.userInfo == null) {
                            this.userInfo = this.apiUtility.createUserInfoFromJWTToken(tokenId);
                        }
                        if (this.apiUtility.checkDailyAPILimit(this.userInfo)) {
                            status = "Reject";
                            result = "Daily API call limit exceeded";
                        } else {
                            result = this.getUserInfo() != null ? String.valueOf(this.getUserInfo().getDesignation()) + ":" + this.getUserInfo().getDivision() + ":" + this.getUserInfo().getSiteCode() + ":" + this.getUserInfo().getDateJoin() + ":" + this.getUserInfo().getEmpName() + ":" + this.getUserInfo().getEmpCode() : "";
                            status = "success";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : keepAlive : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "keepAlive", params, tokenId, "JSON", status, result);
        }
        this.writeAPICallLog("keepSessionAliveClient ( /keepAlive )", status, result, appId, request, this.userInfo);
        return result;
    }

    public String upload(HttpServletRequest request) {
        String status;
        String result;
        block6: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    result = this.uploadDocument(request);
                    status = "success";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : uploadDocument : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "uploadDocument", params, "", "JSON", status, result);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "uploadDocument", params, "", "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "uploadDocument", params, "", "JSON", status, result);
        }
        this.writeAPICallLog("upload ( /uploadDocument )", status, result, null, request, this.userInfo);
        return result;
    }

    public byte[] getDocument(String docId, String userInfoStr, HttpServletRequest request) {
        byte[] docArr;
        String status;
        String result;
        block7: {
            result = "";
            String params = "";
            status = "error";
            docArr = new byte[1];
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    userInfoStr = this.checkNull(userInfoStr);
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    }
                    DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
                    docArr = docHandler.getDocument(docId, this.getUserInfo());
                    docHandler = null;
                    status = "success";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getDocument : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
        }
        this.writeAPICallLog("getDocument ( /getDocument )", status, result, null, request, this.userInfo);
        return docArr;
    }

    public byte[] getDocument(String docId, String userInfoStr, String tokenID, HttpServletRequest request) {
        byte[] docArr;
        String status;
        String result;
        block8: {
            result = "";
            String params = "";
            status = "error";
            docArr = new byte[1];
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    userInfoStr = this.checkNull(userInfoStr);
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    } else {
                        APIUtility apiUtility = new APIUtility();
                        this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenID);
                    }
                    BaseLogger.log("3", null, null, "Inside E12ExtServiceUtility : getDocument : [" + this.userInfo + "]");
                    DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
                    docArr = docHandler.getDocument(docId, this.getUserInfo());
                    docHandler = null;
                    status = "success";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getDocument : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "getDocument", params, "", "JSON", status, result);
        }
        this.writeAPICallLog("getDocument ( /getDocument )", status, result, null, request, this.userInfo);
        return docArr;
    }

    public String deleteDocument(String docId, String refId, String refSer, String refCol, String objName, String userInfoStr, HttpServletRequest request) {
        String status;
        String result;
        block7: {
            result = "";
            String params = "";
            status = "error";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "params - " + params);
                    userInfoStr = this.checkNull(userInfoStr);
                    if (userInfoStr != null && userInfoStr.length() > 0) {
                        this.userInfo = new UserInfoBean(userInfoStr);
                    }
                    DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
                    result = docHandler.removeAttach(docId, refSer, refId, objName, refCol, this.getUserInfo());
                    docHandler = null;
                    status = "success";
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : deleteDocument : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    result = this.generateResponse(request, "deleteDocument", params, "", "JSON", status, result);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                result = this.generateResponse(request, "deleteDocument", params, "", "JSON", status, result);
                throw throwable;
            }
            result = this.generateResponse(request, "deleteDocument", params, "", "JSON", status, result);
        }
        this.writeAPICallLog("deleteDocument ( /deleteDocument )", status, result, null, request, this.userInfo);
        return result;
    }

    public JSONObject getAppsurveyInfo(@QueryParam(value="USER_ID") String userId, @QueryParam(value="APP_ID") String appId, @QueryParam(value="EASE_USE") String easeUse, @QueryParam(value="FUNC_COVERED") String funcCovered, @QueryParam(value="PERFORMANCE") String performance, @QueryParam(value="FEEDBACK") String feedback) throws JSONException {
        JSONObject resultJSON = new JSONObject();
        String result = "";
        String status = "";
        try {
            BaseLogger.log("3", null, null, "USER_ID:[ " + userId + " ]\nAPP_ID:[ " + appId + "] \nEASE_USE:[ " + easeUse + " ]");
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            result = dbAccessEJB.getUserFeedbackOnAppsurvey(userId, appId, easeUse, funcCovered, performance, feedback);
            dbAccessEJB = null;
            BaseLogger.log("3", null, null, "Result::[ " + result + " ]");
            status = "sucess";
            resultJSON.put("result", (Object)status);
            resultJSON.put("message", (Object)result);
        }
        catch (Exception ae) {
            result = "Exception: " + ae.getMessage();
            status = "exception";
            resultJSON.put("result", (Object)status);
            resultJSON.put("message", (Object)result);
            ae.printStackTrace();
            BaseLogger.log("0", null, null, "[POST]Exception in getAppsurveyInfo method:: " + ae.getMessage());
        }
        this.writeAPICallLog("getAppsurveyInfo ( /getAppSurvey )", status, result, null, this.requestGlobal, this.userInfo);
        return resultJSON;
    }

    public JSONObject getAppsurveyInformation(String userId, String appId, String easeUse, String funcCovered, String performance, String feedback) throws JSONException {
        JSONObject resultJSON = new JSONObject();
        String result = "";
        String status = "";
        try {
            BaseLogger.log("3", null, null, "USER_ID:[ " + userId + " ]\nAPP_ID:[ " + appId + "] \nEASE_USE:[ " + easeUse + " ]");
            DBAccessEJB dbAccessEJB = new DBAccessEJB();
            result = dbAccessEJB.getUserFeedbackOnAppsurvey(userId, appId, easeUse, funcCovered, performance, feedback);
            dbAccessEJB = null;
            BaseLogger.log("3", null, null, "Result::[ " + result + " ]");
            status = "success";
            resultJSON.put("result", (Object)status);
            resultJSON.put("message", (Object)result);
        }
        catch (Exception ae) {
            result = "Exception: " + ae.getMessage();
            status = "exception";
            resultJSON.put("result", (Object)status);
            resultJSON.put("message", (Object)result);
            ae.printStackTrace();
            BaseLogger.log("0", null, null, "[POST]Exception in getAppsurveyInfo method:: " + ae.getMessage());
        }
        this.writeAPICallLog("getAppsurveyInformation ( /getAppSurvey )", status, result, null, this.requestGlobal, this.userInfo);
        return resultJSON;
    }

    public JSONObject saveAnnoataionData(String userId, String docId, String annotationData, HttpServletRequest request) {
        String result = null;
        JSONObject resultJson = null;
        String newAnnotatedData = null;
        DBAccessEJB dbAccessEJB = null;
        boolean status = false;
        try {
            docId = this.checkNull(docId);
            userId = this.checkNull(userId);
            annotationData = this.checkNull(annotationData);
            resultJson = new JSONObject();
            if (docId.trim().length() == 0) {
                result = "ERROR: DOC ID is null.";
            }
            if (userId.trim().length() == 0) {
                result = "ERROR: USER ID is null.";
            }
            if (annotationData.trim().length() == 0) {
                result = "ERROR: Annotation Data is null.";
            } else {
                dbAccessEJB = new DBAccessEJB();
                String condition = "CODE = '" + userId + "'";
                String verifyUser = dbAccessEJB.getDBColumnValue("USERS", "CODE", condition);
                if (verifyUser != null && verifyUser.length() > 0) {
                    this.userInfo = dbAccessEJB.createUserInfo(userId);
                    BaseLogger.log("2", null, "saveAnnoataionData", "this.userInfo:[" + this.userInfo + "]");
                    if (this.userInfo != null) {
                        newAnnotatedData = annotationData;
                        result = new DocumentHandlerWrapperEJB().saveAnnotationData(docId, newAnnotatedData, this.userInfo);
                        BaseLogger.log("2", null, "saveAnnoataionData", "result:[" + result + "]");
                        if (result.equalsIgnoreCase("success")) {
                            status = true;
                            result = "Annotation Data Saved Successfully.";
                        } else {
                            result = "EXCEPTION: " + result;
                        }
                    }
                } else {
                    result = "ERROR: Invalid User.";
                }
            }
            resultJson.put("status", (Object)String.valueOf(status));
            resultJson.put("message", (Object)result);
            return resultJson;
        }
        catch (Exception e) {
            try {
                resultJson.put("status", (Object)String.valueOf(status));
                result = "EXCEPTION: " + e.getMessage();
                resultJson.put("message", (Object)result);
            }
            catch (JSONException jse) {
                jse.printStackTrace();
            }
            e.printStackTrace();
            this.writeAPICallLog("saveAnnoataionData ( /saveAnnotationData )", String.valueOf(status), result, null, request, this.userInfo);
            return resultJson;
        }
    }

    public JSONObject uploadCaptureImage(HttpServletRequest request) {
        String refId = null;
        File DUMP_DIR = null;
        String result = null;
        String refSer = null;
        String userId = null;
        String objName = null;
        String dirName = null;
        String fileName = null;
        String newfileName = null;
        String docAttachType = null;
        JSONObject resultJson = new JSONObject();
        boolean status = false;
        try {
            BaseLogger.log("3", null, null, "[uploadCaptureImage] method called::[ " + request + " ]");
            BaseLogger.log("3", null, null, "[uploadCaptureImage method session is::= " + request.getSession());
            if (request != null && request.getSession() != null) {
                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                BaseLogger.log("3", null, null, "[uploadCaptureImage] userInfo is::= " + this.userInfo);
                BaseLogger.log("3", null, null, "[uploadCaptureImage] isMultipartContent::[ " + ServletFileUpload.isMultipartContent((HttpServletRequest)request) + " ]");
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    dirName = String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump";
                    DUMP_DIR = new File(dirName);
                    if (!DUMP_DIR.exists()) {
                        DUMP_DIR.mkdirs();
                    }
                    int MEMORY_THRESHOLD = 0x300000;
                    int MAX_FILE_SIZE = 734003200;
                    int MAX_REQUEST_SIZE = 744488960;
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    factory.setSizeThreshold(MEMORY_THRESHOLD);
                    factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                    upload.setFileSizeMax((long)MAX_FILE_SIZE);
                    upload.setSizeMax((long)MAX_REQUEST_SIZE);
                    List formItems = upload.parseRequest(request);
                    if (formItems != null && formItems.size() > 0) {
                        for (FileItem item : formItems) {
                            String fieldName = item.getFieldName();
                            if (item.isFormField()) {
                                String fieldValue = item.getString();
                                if ("OBJ_NAME".equalsIgnoreCase(fieldName)) {
                                    objName = fieldValue;
                                    continue;
                                }
                                if ("REF_ID".equalsIgnoreCase(fieldName)) {
                                    refId = fieldValue;
                                    continue;
                                }
                                if ("REF_SER".equalsIgnoreCase(fieldName)) {
                                    refSer = fieldValue;
                                    continue;
                                }
                                if ("filename".equalsIgnoreCase(fieldName)) {
                                    fileName = fieldValue;
                                    continue;
                                }
                                if ("DOC_TYPE_ATTACH".equalsIgnoreCase(fieldName)) {
                                    docAttachType = fieldValue;
                                    continue;
                                }
                                if (!"USER_ID".equalsIgnoreCase(fieldName)) continue;
                                userId = fieldValue;
                                if (this.userInfo != null) continue;
                                this.userInfo = new DBAccessEJB().createUserInfo(userId);
                                continue;
                            }
                            if (item.isFormField()) continue;
                            newfileName = new File(item.getName()).getName();
                            String newfilePath = DUMP_DIR + File.separator + newfileName;
                            File storeFile = new File(newfilePath);
                            item.write(storeFile);
                        }
                    }
                    if (newfileName != null) {
                        File file;
                        DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
                        String filePath = String.valueOf(dirName) + File.separator + fileName;
                        String retXMLStringBuff = this.getAttachmentDetailStr(objName, refSer, refId, filePath, file = new File(filePath), this.getUserInfo());
                        if (retXMLStringBuff.indexOf("Exception") == -1) {
                            byte[] previewImage;
                            FileInputStream input = new FileInputStream(file);
                            BufferedInputStream bfr = new BufferedInputStream(input);
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            int i = -1;
                            while ((i = bfr.read()) != -1) {
                                bout.write(i);
                            }
                            byte[] byteArray = bout.toByteArray();
                            String retString = docHandler.addDocument(retXMLStringBuff, byteArray, previewImage = new byte[1], this.getUserInfo());
                            if (retString != null && retString.trim().length() > 0) {
                                String chgTerm = this.getUserInfo().getRemoteHostName();
                                if (chgTerm != null && chgTerm.length() > 15) {
                                    chgTerm = chgTerm.substring(0, 15);
                                } else if (chgTerm == null || chgTerm.length() == 0) {
                                    chgTerm = this.userInfo.getRemoteHost();
                                }
                                AuditTrailExtEJB auditTrailExtEJB = new AuditTrailExtEJB();
                                String auditTranId = auditTrailExtEJB.saveActionPerformedInAudit(objName, refId, "UPLOAD_ATTACHMENT", "UPLOAD_ATTACHMENT", this.getUserInfo().getLoginCode(), chgTerm, this.getUserInfo().getTransDB(), this.getUserInfo());
                                auditTrailExtEJB.updateAuditResponse(auditTranId, "Success", retString, this.userInfo);
                                ArrayList<String> userIdList = new ArrayList<String>();
                                userIdList.add(this.getUserInfo().getLoginCode());
                                this.sendWebSocketNotification(retString, docAttachType, userIdList, fileName, CommonConstants.WebSocketMessageType.UPLOAD_DELEGATE);
                                status = true;
                                result = "successfully Uploaded Cropper Image.";
                            } else {
                                result = "No Response DATA Found.";
                            }
                        }
                    }
                } else {
                    result = "Error: Form must has enctype=multipart/form-data.";
                }
            } else {
                result = "Error: Invalid Request.";
            }
            resultJson.put("status", (Object)String.valueOf(status));
            resultJson.put("message", (Object)result);
            BaseLogger.log("2", null, null, "{uploadCaptureImage method} result::[ " + resultJson.toString() + " ]");
            return resultJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "EXCEPTION:: " + e.getMessage();
            try {
                resultJson.put("status", (Object)String.valueOf(status));
                resultJson.put("message", (Object)result);
            }
            catch (JSONException jsonEx) {
                jsonEx.printStackTrace();
                BaseLogger.log("0", null, null, "[POST]JSONException in uploadCaptureImage method:: " + jsonEx.getMessage());
            }
            BaseLogger.log("0", null, null, "{uploadCaptureImage method} Exception result::[ " + resultJson.toString() + " ]");
            this.writeAPICallLog("uploadCaptureImage ( /uploadCaptureImage )", String.valueOf(status), result, null, request, this.userInfo);
            return resultJson;
        }
    }

    public String getPaySlipDataClient(String userCode, String password, String isPwdEncrypt, String dataFormat, String apiUrl, String token, String guid, String apIPwd, String imei, String appId, String projectName, HttpServletRequest request) throws JSONException, ITMException, SQLException {
        String result;
        JSONObject resultJson;
        block69: {
            String params;
            ResultSet rst;
            Statement pStmt;
            Connection conn;
            JSONObject responseJson;
            block68: {
                responseJson = new JSONObject();
                resultJson = new JSONObject();
                HashMap<String, Object> empInfoListMap = new HashMap<String, Object>();
                ConnDriver connDriver = new ConnDriver();
                conn = null;
                pStmt = null;
                rst = null;
                result = "";
                params = "";
                String sql = "";
                try {
                    try {
                        params = request.getQueryString();
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("USERCODE=" + userCode);
                            paramString.append("&PASSWORD=" + password);
                            paramString.append("&ISPWDENCRYPT=" + isPwdEncrypt);
                            paramString.append("&DATAFORMAT=" + dataFormat);
                            paramString.append("&URL=" + apiUrl);
                            paramString.append("&Token=" + token);
                            paramString.append("&APIPwd=" + apIPwd);
                            paramString.append("&GUID=" + guid);
                            paramString.append("&IMEI=" + imei);
                            paramString.append("&AppID=" + appId);
                            paramString.append("&ProjectName=" + projectName);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "params - " + params);
                        userCode = this.checkNull(userCode);
                        password = this.checkNull(password);
                        String string = isPwdEncrypt = this.checkNull(isPwdEncrypt).length() > 0 ? this.checkNull(isPwdEncrypt) : "false";
                        if ("true".equalsIgnoreCase(isPwdEncrypt)) {
                            userCode = this.decrypt(userCode);
                            password = this.decrypt(password);
                        }
                        dataFormat = this.checkNull(dataFormat);
                        apiUrl = this.checkNull(apiUrl);
                        token = this.checkNull(token);
                        apIPwd = this.checkNull(apIPwd);
                        guid = this.checkNull(guid);
                        imei = this.checkNull(imei);
                        appId = this.checkNull(appId);
                        projectName = this.checkNull(projectName);
                        String isValidLogin = "false";
                        if (this.isValidDataFormat(dataFormat)) {
                            if (userCode.length() > 0) {
                                isValidLogin = this.getAuthStatus(request, userCode, password, "", "I", "false");
                                if ("VALID".equalsIgnoreCase(isValidLogin)) {
                                    conn = connDriver.getConnectDB(this.getUserInfo().getTransDB());
                                    conn.setAutoCommit(false);
                                    String empCode = "";
                                    String periodCode = "";
                                    String year = "";
                                    String mongth = "";
                                    String resStatus = "";
                                    String remarks = "";
                                    String empcodeDB = "";
                                    String deptDescr = "";
                                    String empName = "";
                                    String addr1 = "";
                                    String addr2 = "";
                                    String addr3 = "";
                                    String city = "";
                                    String curPin = "";
                                    String bnkName = "";
                                    String bnkAcNo = "";
                                    String empSite = "";
                                    String finentity = "";
                                    String prtSeq1 = "";
                                    String adCode1 = "";
                                    String lveCode = "";
                                    String logo = "";
                                    String desgn = "";
                                    String location = "";
                                    String status = "";
                                    String bankDet = "";
                                    String paytable = "";
                                    String grades = "";
                                    String cadre = "";
                                    String paysite = "";
                                    String panNo = "";
                                    String shDescr = "";
                                    String shDescr1 = "";
                                    String adCode = "";
                                    String prtSeq = "";
                                    String emppfno = "";
                                    String remark = "";
                                    String payMode = "";
                                    String headQtr = "";
                                    String periodDescr = "";
                                    String code = "";
                                    String propdays = "";
                                    int empCnt = 0;
                                    int empCntResign = 0;
                                    double amt = 0.0;
                                    double amtBal1 = 0.0;
                                    double avalidlve = 0.0;
                                    double balLve = 0.0;
                                    double workDays = 0.0;
                                    double woffDays = 0.0;
                                    double paidDays = 0.0;
                                    double absdays = 0.0;
                                    double totEarn = 0.0;
                                    double totDedu = 0.0;
                                    double netPaid = 0.0;
                                    double mrndoff = 0.0;
                                    double projAmt = 0.0;
                                    double payAmt = 0.0;
                                    double diffAmt = 0.0;
                                    double totaldays = 0.0;
                                    double lwp = 0.0;
                                    request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                                    JSONObject resultDtlJson = new JSONObject();
                                    resultDtlJson.put("Token", (Object)token);
                                    try {
                                        StringBuffer responseBuff = new StringBuffer();
                                        JSONObject paySlipServiceReqJson = new JSONObject();
                                        paySlipServiceReqJson.put("Token", (Object)token);
                                        paySlipServiceReqJson.put("APIPwd", (Object)apIPwd);
                                        paySlipServiceReqJson.put("GUID", (Object)guid);
                                        paySlipServiceReqJson.put("IMEI", (Object)imei);
                                        paySlipServiceReqJson.put("AppID", (Object)appId);
                                        paySlipServiceReqJson.put("ProjectName", (Object)projectName);
                                        URL url = new URL(apiUrl);
                                        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                                        urlConn.setRequestMethod("POST");
                                        urlConn.setDoInput(true);
                                        urlConn.setDoOutput(true);
                                        urlConn.setRequestProperty("Content-Type", "application/json");
                                        OutputStream outputStream = urlConn.getOutputStream();
                                        outputStream.write(paySlipServiceReqJson.toString().getBytes());
                                        outputStream.flush();
                                        outputStream.close();
                                        BufferedReader br = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                                        String output = "";
                                        BaseLogger.log("3", null, null, "Output from Server .... \n");
                                        while ((output = br.readLine()) != null) {
                                            responseBuff.append(output);
                                        }
                                        JSONObject paySlipServiceResJson = new JSONObject(responseBuff.toString());
                                        empCode = this.checkNull(paySlipServiceResJson.getJSONObject("d").getString("MetisCode"));
                                        year = this.checkNull(paySlipServiceResJson.getJSONObject("d").getString("Year"));
                                        mongth = this.checkNull(paySlipServiceResJson.getJSONObject("d").getString("Month"));
                                        periodCode = String.valueOf(year) + mongth;
                                        resStatus = this.checkNull(paySlipServiceResJson.getJSONObject("d").getString("Status"));
                                        remarks = this.checkNull(paySlipServiceResJson.getJSONObject("d").getString("Remarks"));
                                        if (urlConn != null) {
                                            urlConn.disconnect();
                                        }
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    if ("Success".equalsIgnoreCase(resStatus)) {
                                        if (empCode.length() > 0) {
                                            sql = " SELECT COUNT(*) AS EMP_COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
                                            pStmt = conn.prepareStatement(sql);
                                            pStmt.setString(1, empCode);
                                            rst = pStmt.executeQuery();
                                            if (rst.next()) {
                                                empCnt = rst.getInt("EMP_COUNT");
                                            }
                                            if (rst != null) {
                                                rst.close();
                                                rst = null;
                                            }
                                            if (pStmt != null) {
                                                pStmt.close();
                                                pStmt = null;
                                            }
                                            if (empCnt > 0) {
                                                sql = " SELECT COUNT(*) AS EMP_COUNT__RESIGN FROM EMPLOYEE WHERE EMP_CODE = ? AND RELIEVE_DATE IS NULL ";
                                                pStmt = conn.prepareStatement(sql);
                                                pStmt.setString(1, empCode);
                                                rst = pStmt.executeQuery();
                                                if (rst.next()) {
                                                    empCntResign = rst.getInt("EMP_COUNT__RESIGN");
                                                }
                                                if (rst != null) {
                                                    rst.close();
                                                    rst = null;
                                                }
                                                if (pStmt != null) {
                                                    pStmt.close();
                                                    pStmt = null;
                                                }
                                                if (empCntResign > 0) {
                                                    sql = "";
                                                    sql = " SELECT EMPLOYEE.EMP_CODE empcode,DEPARTMENT.SH_DESCR deptDescr, EMPLOYEE.NAME_PREFIX || ' ' || TRIM(EMPLOYEE.EMP_FNAME) || ' ' ||  TRIM(EMPLOYEE.EMP_MNAME) || ' ' || TRIM(EMPLOYEE.EMP_LNAME)  AS EMP_NAME,employee.cur_add1 addr1, employee.cur_add2 addr2,  NVL(employee.cur_add3,'') addr3,EMPLOYEE.CUR_CITY city, EMPLOYEE.CUR_PIN pin,STATE.DESCR state,  BANK.BANK_NAME bnkName,EMPLOYEE.BANK_ACCT bnkAcNo,PAYROLL.SITE_CODE__WORK empSite,  SITE.FIN_ENTITY finentity,  (select VAR_VALUE from payrparm where var_name = 'LOGO_PATH' AND PRD_CODE =\t'999999') || trim(SITE.FIN_ENTITY)||'.gif' AS LOGO,  PAYROLL.WORK_DAYS workdays, PAYROLL.PAID_DAYS paiddays,PAYROLL.WOFF_DAYS woffdays,PAYROLL.ABS_DAYS absdays, PAYROLL.REMARKS remarks,EMPLOYEE.PAY_MODE payMode,PAYROLL.DESIGNATION desgn, STATION.DESCR HQ,PERIOD.DESCR periodDescr, PERIOD.code,GENCODES.descr location,  (case when EMPLOYEE.CONFIRMED = 'Y' then 'CONFIRMED' when EMPLOYEE.PROBATION = 'Y' then 'PROBATION' else 'TRAINEE' end) status,  ddf_company_pf(payroll.site_code__pay,employee.pf_no) AS emppfno,  ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','EARN')) AS as_mtot_earn,  ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','DEDN')) AS as_mtot_dedu,  ddf_payslip_payroll( ? , employee.emp_code, HRAPPL_GET_ENV('999999','NETWR')) AS as_mnetpaid,  ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','RNDOFF_AD')) AS as_mrndoff,  ddf_bank_details(employee.emp_code,payroll.voucher_no) AS as_bank_det,  PAYROLL.PAY_TABLE AS as_paytable,PAYROLL.grade AS as_grades,PAYROLL.cadre AS as_cadre,  PAYROLL.SITE_CODE__WORK AS as_paysite,  employee.it_no AS PAN_NO  FROM PERIOD,EMPLOYEE,PAYROLL,DEPARTMENT,SITE,BANK,STATE,STATION,GENCODES  WHERE PAYROLL.PRD_CODE = PERIOD.CODE  AND PAYROLL.EMP_CODE = EMPLOYEE.EMP_CODE  AND department.dept_code(+) = payroll.dept_code  AND site.site_code = payroll.site_code__pay  AND bank.bank_code(+) = employee.bank_code  AND state.state_code(+) = employee.cur_state  AND station.stan_code(+) = employee.stan_code__hq  AND PERIOD.CODE = ?  AND EMPLOYEE.EMP_CODE = ?  AND PAYROLL.VOUCHER_NO IS NOT NULL  AND gencodes.fld_name(+) = 'GEO_LOC'  AND gencodes.mod_name(+) = 'X'  AND gencodes.fld_value(+) = site.geo_loc ";
                                                    pStmt = conn.prepareStatement(sql);
                                                    pStmt.setString(1, periodCode);
                                                    pStmt.setString(2, periodCode);
                                                    pStmt.setString(3, periodCode);
                                                    pStmt.setString(4, periodCode);
                                                    pStmt.setString(5, periodCode);
                                                    pStmt.setString(6, empCode);
                                                    rst = pStmt.executeQuery();
                                                    if (rst.next()) {
                                                        empcodeDB = this.checkNull(rst.getString("empcode"));
                                                        deptDescr = this.checkNull(rst.getString("deptDescr"));
                                                        empName = this.checkNull(rst.getString("EMP_NAME"));
                                                        addr1 = this.checkNull(rst.getString("addr1"));
                                                        addr2 = this.checkNull(rst.getString("addr2"));
                                                        addr3 = this.checkNull(rst.getString("addr3"));
                                                        city = this.checkNull(rst.getString("city"));
                                                        curPin = this.checkNull(rst.getString("pin"));
                                                        bnkName = this.checkNull(rst.getString("bnkName"));
                                                        bnkAcNo = this.checkNull(rst.getString("bnkAcNo"));
                                                        empSite = this.checkNull(rst.getString("empSite"));
                                                        finentity = this.checkNull(rst.getString("finentity"));
                                                        logo = this.checkNull(rst.getString("LOGO"));
                                                        workDays = rst.getDouble("workdays");
                                                        paidDays = rst.getDouble("paiddays");
                                                        woffDays = rst.getDouble("woffdays");
                                                        absdays = rst.getDouble("absdays");
                                                        remark = this.checkNull(rst.getString("remarks"));
                                                        payMode = this.checkNull(rst.getString("payMode"));
                                                        desgn = this.checkNull(rst.getString("desgn"));
                                                        headQtr = this.checkNull(rst.getString("HQ"));
                                                        periodDescr = this.checkNull(rst.getString("periodDescr"));
                                                        code = this.checkNull(rst.getString("code"));
                                                        location = this.checkNull(rst.getString("location"));
                                                        status = this.checkNull(rst.getString("status"));
                                                        emppfno = this.checkNull(rst.getString("emppfno"));
                                                        totEarn = rst.getDouble("as_mtot_earn");
                                                        totDedu = rst.getDouble("as_mtot_dedu");
                                                        netPaid = rst.getDouble("as_mnetpaid");
                                                        mrndoff = rst.getDouble("as_mrndoff");
                                                        bankDet = this.checkNull(rst.getString("as_bank_det"));
                                                        paytable = this.checkNull(rst.getString("as_paytable"));
                                                        grades = this.checkNull(rst.getString("as_grades"));
                                                        cadre = this.checkNull(rst.getString("as_cadre"));
                                                        paysite = this.checkNull(rst.getString("as_paysite"));
                                                        panNo = this.checkNull(rst.getString("PAN_NO"));
                                                    }
                                                    if (rst != null) {
                                                        rst.close();
                                                        rst = null;
                                                    }
                                                    if (pStmt != null) {
                                                        pStmt.close();
                                                        pStmt = null;
                                                    }
                                                    Attd_eSalarySlip attdeSalarySlip = new Attd_eSalarySlip();
                                                    propdays = this.checkNull(Attd_eSalarySlip.getPropDays((String)periodCode, (String)"Y", (String)empCode, (String)paytable, (String)grades, (String)cadre, (String)paysite));
                                                    totaldays = Double.parseDouble(propdays);
                                                    lwp = totaldays - paidDays;
                                                    empInfoListMap.put("EMP_CODE", empcodeDB);
                                                    empInfoListMap.put("DEPT_DESCR", deptDescr);
                                                    empInfoListMap.put("EMP_NAME", empName);
                                                    empInfoListMap.put("ADDR1", addr1);
                                                    empInfoListMap.put("ADDR2", addr2);
                                                    empInfoListMap.put("ADDR3", addr3);
                                                    empInfoListMap.put("CITY", city);
                                                    empInfoListMap.put("PIN", curPin);
                                                    empInfoListMap.put("BNK_NAME", bnkName);
                                                    empInfoListMap.put("BNK_AC__NO", bnkAcNo);
                                                    empInfoListMap.put("EMP_SITE", empSite);
                                                    empInfoListMap.put("FINENTITY", finentity);
                                                    empInfoListMap.put("LOGO", logo);
                                                    empInfoListMap.put("WORK_DAYS", workDays);
                                                    empInfoListMap.put("PAID_DAYS", paidDays);
                                                    empInfoListMap.put("WOFF_DAYS", woffDays);
                                                    empInfoListMap.put("ABS_DAYS", absdays);
                                                    empInfoListMap.put("TOTAL_DAYS", totaldays);
                                                    empInfoListMap.put("LWP", lwp);
                                                    empInfoListMap.put("REMARK", remark);
                                                    empInfoListMap.put("PAY_MODE", payMode);
                                                    empInfoListMap.put("DESGN", desgn);
                                                    empInfoListMap.put("HQ", headQtr);
                                                    empInfoListMap.put("PERIOD_DESCR", periodDescr);
                                                    empInfoListMap.put("CODE", code);
                                                    empInfoListMap.put("LOCATION", location);
                                                    empInfoListMap.put("STATUS", status);
                                                    empInfoListMap.put("EMP_PF__NO", emppfno);
                                                    empInfoListMap.put("MRND_OFF", mrndoff);
                                                    empInfoListMap.put("BANK_DET", bankDet);
                                                    empInfoListMap.put("PAY_TABLE", paytable);
                                                    empInfoListMap.put("GRADES", grades);
                                                    empInfoListMap.put("CADRE", cadre);
                                                    empInfoListMap.put("PAY_SITE", paysite);
                                                    empInfoListMap.put("PAN_NO", panNo);
                                                    resultDtlJson.put("EMPLOYEE_INFO", empInfoListMap);
                                                    resultDtlJson.put("TOTAL_EARNINGS", totEarn);
                                                    resultDtlJson.put("TOTAL_DEDUCATION", totDedu);
                                                    resultDtlJson.put("NET_PAID", netPaid);
                                                    ArrayList deductionList = new ArrayList();
                                                    sql = "";
                                                    sql = " SELECT ALLWDEDN.SH_DESCR sh_descr,PAYARR_DET.AMOUNT amt,ALLWDEDN.PRT_SEQ prt1_seq,ALLWDEDN.AD_CODE ad1_code,  PAYARR_DET.AMT_BAL amt1_bal  FROM PAYARR_DET,ALLWDEDN  WHERE ALLWDEDN.AD_CODE = PAYARR_DET.AD_CODE  AND payarr_det.prd_code = ?  AND payarr_det.emp_code = ?  AND payarr_det.payable = 'D' AND payarr_det.amount != 0 AND payarr_det.ad_code != 'ROFF'  ORDER BY prt1_seq,sh_descr ";
                                                    pStmt = conn.prepareStatement(sql);
                                                    pStmt.setString(1, periodCode);
                                                    pStmt.setString(2, empCode);
                                                    rst = pStmt.executeQuery();
                                                    while (rst.next()) {
                                                        shDescr = this.checkNull(rst.getString("sh_descr"));
                                                        amt = rst.getDouble("amt");
                                                        prtSeq1 = this.checkNull(rst.getString("prt1_seq"));
                                                        adCode1 = this.checkNull(rst.getString("ad1_code"));
                                                        amtBal1 = rst.getDouble("amt1_bal");
                                                        HashMap<String, Object> deductionMap = new HashMap<String, Object>();
                                                        deductionMap.put("SH_DESCR__DEDN", shDescr);
                                                        deductionMap.put("AMT__DEDN", amt);
                                                        deductionMap.put("PRT_SEQ__DEDN", prtSeq1);
                                                        deductionMap.put("AD_CODE__DEDN", adCode1);
                                                        deductionMap.put("AMT_BAL_DEDN", amtBal1);
                                                        deductionList.add(deductionMap);
                                                    }
                                                    if (rst != null) {
                                                        rst.close();
                                                        rst = null;
                                                    }
                                                    if (pStmt != null) {
                                                        pStmt.close();
                                                        pStmt = null;
                                                    }
                                                    resultDtlJson.put("DEDUCTION_INFO", deductionList);
                                                    ArrayList leaveList = new ArrayList();
                                                    sql = "";
                                                    sql = " SELECT REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 1) lve_code,  REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 2) AVAILED_LVE,  REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 3) BAL_LVE  FROM (SELECT REPLACE(TRIM(LVE_DET) ,'-',' ') LVE_DETAIL  FROM (select regexp_substr(m.lve_cols,'[^, ]+',1,level) as LVE_DET  from (SELECT REPLACE(TRIM(lve_DESC) ,'*',' ') lve_cols  FROM (SELECT REPLACE(TRIM(lve_code) ,'>','') lve_desc  FROM (SELECT REPLACE(TRIM(LVE_DET) ,'<','') lve_code  FROM (select regexp_substr(my.str,'[^,]+',1,level) as LVE_DET  from (SELECT fn_r_get_lve_descr( ? , ?, ?, ? ) as str FROM DUAL)  my connect by level <= length(regexp_replace(TRIM(my.str),'[^, ]+')) + 1))))  m connect by level <= length(regexp_replace(m.lve_cols,'[^, ]+')) + 1))T";
                                                    pStmt = conn.prepareStatement(sql);
                                                    pStmt.setString(1, periodCode);
                                                    pStmt.setString(2, empCode);
                                                    pStmt.setString(3, empSite);
                                                    pStmt.setString(4, userCode);
                                                    rst = pStmt.executeQuery();
                                                    while (rst.next()) {
                                                        lveCode = this.checkNull(rst.getString("lve_code"));
                                                        avalidlve = rst.getDouble("AVAILED_LVE");
                                                        balLve = rst.getDouble("BAL_LVE");
                                                        HashMap<String, Object> leaveMap = new HashMap<String, Object>();
                                                        leaveMap.put("LVE_CODE", lveCode);
                                                        leaveMap.put("AVALID_LVE", avalidlve);
                                                        leaveMap.put("BAL_LVE", balLve);
                                                        leaveList.add(leaveMap);
                                                    }
                                                    if (rst != null) {
                                                        rst.close();
                                                        rst = null;
                                                    }
                                                    if (pStmt != null) {
                                                        pStmt.close();
                                                        pStmt = null;
                                                    }
                                                    resultDtlJson.put("LEAVE_INFO", leaveList);
                                                    ArrayList arrearList = new ArrayList();
                                                    sql = "";
                                                    sql = " SELECT SUM(PROJ_AMT) AS PROJ_AMT,sh_descr,ad_code,SUM(pay_amt) AS PAY_AMT,SUM(diff_amt) AS DIFF_AMT,prt_seq  FROM (  SELECT (case nvl(allwdedn.print_opt,'M') when 'M' then payroll_projdet.amount   else round(payroll_projdet.amount / payroll_projhdr.paid_days,2) end) AS PROJ_AMT,  allwdedn.sh_descr AS SH_DESCR,payroll_projdet.ad_code AS AD_CODE,0 AS PAY_AMT,0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ  FROM payroll_projdet,allwdedn,payroll_projhdr  WHERE allwdedn.ad_code = payroll_projdet.ad_code  AND payroll_projhdr.prd_code = payroll_projdet.prd_code  AND payroll_projhdr.emp_code = payroll_projdet.emp_code  AND payroll_projdet.prd_code = ?  AND payroll_projdet.emp_code = ?  AND payroll_projdet.payable = 'A'  UNION ALL  SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,PAYROLLDET.ad_code AS AD_CODE,payrolldet.amount AS PAY_AMT,  0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ  FROM payrolldet,allwdedn  WHERE allwdedn.ad_code = PAYROLLDET.ad_code  AND PAYROLLDET.prd_code = ?  AND PAYROLLDET.emp_code = ?  AND PAYROLLDET.payable = 'A'  UNION ALL  SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,arreardet.ad_code AS AD_CODE,0 AS PAY_AMT,  arreardet.diff_amt AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ  FROM arreardet,allwdedn,arrears  WHERE allwdedn.ad_code = arreardet.ad_code  AND arrears.prd_code = arreardet.prd_code  AND arrears.emp_code = arreardet.emp_code  AND arrears.prd_code__acc = arreardet.prd_code__acc  AND arrears.voucher_no IS NOT NULL  AND arreardet.prd_code__acc = ?  AND arreardet.emp_code = ?  AND arreardet.payable = 'A'  )  GROUP BY sh_descr,ad_code,prt_seq  HAVING SUM(proj_amt) != 0 OR SUM(diff_amt) != 0 OR SUM(pay_amt) != 0  ORDER BY prt_seq,sh_descr";
                                                    pStmt = conn.prepareStatement(sql);
                                                    pStmt.setString(1, periodCode);
                                                    pStmt.setString(2, empCode);
                                                    pStmt.setString(3, periodCode);
                                                    pStmt.setString(4, empCode);
                                                    pStmt.setString(5, periodCode);
                                                    pStmt.setString(6, empCode);
                                                    rst = pStmt.executeQuery();
                                                    while (rst.next()) {
                                                        projAmt = rst.getDouble("PROJ_AMT");
                                                        shDescr1 = this.checkNull(rst.getString("sh_descr"));
                                                        adCode = this.checkNull(rst.getString("ad_code"));
                                                        payAmt = rst.getDouble("PAY_AMT");
                                                        diffAmt = rst.getDouble("DIFF_AMT");
                                                        prtSeq = this.checkNull(rst.getString("prt_seq"));
                                                        HashMap<String, Object> arrearMap = new HashMap<String, Object>();
                                                        arrearMap.put("PROJ_AMT", projAmt);
                                                        arrearMap.put("SH_DESCR1", shDescr1);
                                                        arrearMap.put("AD_CODE", adCode);
                                                        arrearMap.put("PAY_AMT", payAmt);
                                                        arrearMap.put("DIFF_AMT", diffAmt);
                                                        arrearMap.put("PRT_SEQ", prtSeq);
                                                        arrearList.add(arrearMap);
                                                    }
                                                    if (rst != null) {
                                                        rst.close();
                                                        rst = null;
                                                    }
                                                    if (pStmt != null) {
                                                        pStmt.close();
                                                        pStmt = null;
                                                    }
                                                    resultDtlJson.put("EARNINGS_INFO", arrearList);
                                                    result = resultDtlJson.toString();
                                                    if (!"JSON".equalsIgnoreCase(dataFormat)) {
                                                        result = this.genericUtility.jsonToXMLString(result);
                                                    }
                                                    resultJson.put("Status", (Object)"success");
                                                    resultJson.put("Remarks", (Object)"success");
                                                } else {
                                                    result = "Employee already resigned.";
                                                    resultJson.put("Status", (Object)"Failure");
                                                    resultJson.put("Remarks", (Object)"Employee already resigned.");
                                                }
                                            } else {
                                                resultJson.put("Status", (Object)"Failure");
                                                result = "Employee code does not exist in employee master";
                                                resultJson.put("Remarks", (Object)"Employee code does not exist in employee master.");
                                            }
                                        } else {
                                            resultJson.put("Status", (Object)"Failure");
                                            resultJson.put("Remarks", (Object)"Employee code can not be blank.");
                                            result = "Employee code can not be blank";
                                        }
                                    } else {
                                        result = remarks;
                                        resultJson.put("Status", (Object)"Failure");
                                        resultJson.put("Remarks", (Object)remarks);
                                    }
                                    break block68;
                                }
                                result = isValidLogin;
                                resultJson.put("Status", (Object)"Failure");
                                resultJson.put("Remarks", (Object)isValidLogin);
                                break block68;
                            }
                            result = "Please enter username.";
                            resultJson.put("Status", (Object)"Failure");
                            resultJson.put("Remarks", (Object)"Please enter username.");
                            break block68;
                        }
                        result = "Please enter valid Data Format.";
                        resultJson.put("Status", (Object)"Failure");
                        resultJson.put("Remarks", (Object)"Please enter valid Data Format.");
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : authenticateUser : " + e.getMessage());
                        resultJson.put("Status", (Object)"Failure");
                        resultJson.put("Remarks", (Object)"Something went wrong.");
                        result = this.getStackTrace(e, dataFormat);
                        if (conn != null) {
                            if (rst != null) {
                                rst.close();
                                rst = null;
                            }
                            if (pStmt != null) {
                                pStmt.close();
                                pStmt = null;
                            }
                            conn.close();
                            conn = null;
                        }
                        if ((result = this.checkNull(result)).indexOf("<Errors>") != -1) {
                            resultJson.put("Status", (Object)"Failure");
                            resultJson.put("Remarks", (Object)"Something went wrong.");
                        } else if (result.indexOf("Exception") != -1) {
                            resultJson.put("Status", (Object)"Failure");
                            resultJson.put("Remarks", (Object)"Something went wrong.");
                        }
                        String responseType = "" + resultJson.get("Status");
                        try {
                            String logResult = this.generateExtServiceLog(request, "", "getPaySlipData", params, responseType, result, this.getUserInfo());
                            BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        resultJson.put("results", (Object)result);
                        responseJson.put("Response", (Object)resultJson);
                        result = responseJson.toString();
                        if (!"JSON".equalsIgnoreCase(dataFormat)) {
                            result = this.genericUtility.jsonToXMLString(result);
                            result = this.genericUtility.remAllXmlDec(result);
                        }
                        break block69;
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        if (rst != null) {
                            rst.close();
                            rst = null;
                        }
                        if (pStmt != null) {
                            pStmt.close();
                            pStmt = null;
                        }
                        conn.close();
                        conn = null;
                    }
                    if ((result = this.checkNull(result)).indexOf("<Errors>") != -1) {
                        resultJson.put("Status", (Object)"Failure");
                        resultJson.put("Remarks", (Object)"Something went wrong.");
                    } else if (result.indexOf("Exception") != -1) {
                        resultJson.put("Status", (Object)"Failure");
                        resultJson.put("Remarks", (Object)"Something went wrong.");
                    }
                    String responseType = "" + resultJson.get("Status");
                    try {
                        String logResult = this.generateExtServiceLog(request, "", "getPaySlipData", params, responseType, result, this.getUserInfo());
                        BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    resultJson.put("results", (Object)result);
                    responseJson.put("Response", (Object)resultJson);
                    result = responseJson.toString();
                    if (!"JSON".equalsIgnoreCase(dataFormat)) {
                        result = this.genericUtility.jsonToXMLString(result);
                        result = this.genericUtility.remAllXmlDec(result);
                    }
                    throw throwable;
                }
            }
            if (conn != null) {
                if (rst != null) {
                    rst.close();
                    rst = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                conn.close();
                conn = null;
            }
            if ((result = this.checkNull(result)).indexOf("<Errors>") != -1) {
                resultJson.put("Status", (Object)"Failure");
                resultJson.put("Remarks", (Object)"Something went wrong.");
            } else if (result.indexOf("Exception") != -1) {
                resultJson.put("Status", (Object)"Failure");
                resultJson.put("Remarks", (Object)"Something went wrong.");
            }
            String responseType = "" + resultJson.get("Status");
            try {
                String logResult = this.generateExtServiceLog(request, "", "getPaySlipData", params, responseType, result, this.getUserInfo());
                BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resultJson.put("results", (Object)result);
            responseJson.put("Response", (Object)resultJson);
            result = responseJson.toString();
            if (!"JSON".equalsIgnoreCase(dataFormat)) {
                result = this.genericUtility.jsonToXMLString(result);
                result = this.genericUtility.remAllXmlDec(result);
            }
        }
        String status = resultJson.getString("Status");
        BaseLogger.log("3", null, null, "status - [" + status + "]");
        this.writeAPICallLog("getPaySlipDataClient ( /getPaySlipData )", status, result, null, request, this.userInfo);
        return result;
    }

    public String getHashCode(String tranId, String enterprise, String activeUsrCnt, String usrLicType, String transDb, HttpServletRequest request) throws ITMException, JSONException {
        BaseLogger.log("2", null, null, "tranId[" + tranId + "]activeUsrCnt[" + activeUsrCnt + "]usrLicType[" + usrLicType + "]enterprise[" + enterprise + "]request[" + request + "]");
        String responseString = "";
        UserActivationEJB userActEjb = new UserActivationEJB();
        responseString = userActEjb.getHashCode(tranId, enterprise, activeUsrCnt, usrLicType, transDb);
        this.writeAPICallLog("getHashCode ( /getHashCode )", null, responseString, null, request, this.userInfo);
        return responseString;
    }

    public String setToggleUserLock(String tranId, String enterprise, String acctLock, String transDb, HttpServletRequest request) throws ITMException, JSONException {
        BaseLogger.log("2", null, null, "tranId[" + tranId + "]enterprise[" + enterprise + "]request[" + request + "]");
        String responseString = "";
        UserAccountsLock userAccLock = new UserAccountsLock();
        responseString = userAccLock.setToggleUserLock(tranId, enterprise, acctLock, transDb);
        this.writeAPICallLog("setToggleUserLock ( /setToggleUserLock )", null, responseString, null, request, this.userInfo);
        return responseString;
    }

    public String getEnterpriseCode(String userId, String usrLicType, HttpServletRequest request) throws ITMException, JSONException {
        BaseLogger.log("2", null, null, "userId[" + userId + "]usrLicType[" + usrLicType + "]request[" + request + "]");
        String responseString = "";
        UserEnterpriseEJB userEntpEjb = new UserEnterpriseEJB();
        responseString = userEntpEjb.getEnterpriseCode(userId, usrLicType);
        this.writeAPICallLog("getEnterpriseCode ( /getEnterpriseCode )", null, responseString, null, request, this.userInfo);
        return responseString;
    }

    public String getLicUserCount(String enterprise, String usrLicType) throws ITMException {
        BaseLogger.log("2", null, null, "usrLicType[" + usrLicType + "]enterprise[" + enterprise + "]");
        String responseString = "";
        UserActivationEJB userActEjb = new UserActivationEJB();
        int validLicUserCount = userActEjb.getLicUserLimit(usrLicType, enterprise);
        responseString = String.valueOf(validLicUserCount);
        BaseLogger.log("2", null, null, "validLicUserCount[" + validLicUserCount + "]");
        this.writeAPICallLog("getLicUserCount ( /getLicUserCount )", null, responseString, null, this.requestGlobal, this.userInfo);
        return responseString;
    }

    public String getReportArg(String objName, String userCode, String password, String isPwdEncrypt, String tokenId, String dataFormat, String appId, HttpServletRequest request) throws BaseException {
        String respArgString;
        String status;
        block22: {
            String params = "";
            boolean isDestroySession = false;
            boolean isValidSession = false;
            status = "error";
            respArgString = "";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    if ((respArgString = this.validateRequest(request, dataFormat, null, false, appId, "getReportArg")).equalsIgnoreCase("valid")) {
                        if (!"".equalsIgnoreCase(this.checkNull(objName))) {
                            if (request.getSession().getAttribute("USER_INFO") != null) {
                                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                                String string = userCode = !"".equals(this.checkNull(userCode)) ? userCode : this.userInfo.getLoginCode();
                            }
                            if ((tokenId = this.checkNull(tokenId)).trim().length() > 0) {
                                if (this.validateUserSession(request, tokenId)) {
                                    isValidSession = true;
                                }
                            } else {
                                JSONObject respJson = (JSONObject)this.createSession(userCode, password, isPwdEncrypt, request);
                                respArgString = respJson.getString("result");
                                status = respJson.getString("status");
                                if ("true".equals(respArgString)) {
                                    isValidSession = true;
                                    isDestroySession = true;
                                    BaseLogger.log("3", this.userInfo, null, "params - " + params);
                                }
                            }
                            if (isValidSession) {
                                BaseLogger.log("3", this.userInfo, null, "Valid session!!");
                                XSDParser xsdParser = new XSDParser(objName, this.userInfo);
                                String attachType = "pdf";
                                String argXmlString = xsdParser.getArgumentMetaDataString();
                                if (argXmlString.length() > 0) {
                                    JSONObject repArgsJosn = (JSONObject)this.getReportArgStr(objName, attachType, argXmlString, this.userInfo);
                                    respArgString = repArgsJosn.getString("response");
                                    status = repArgsJosn.getString("status");
                                } else {
                                    respArgString = "Something went wrong, please check object name!!";
                                    status = "error";
                                }
                            } else {
                                respArgString = "You are not authorized to access.";
                                status = "error";
                            }
                        } else {
                            respArgString = "Object name is missing!!";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "Exception: @genReportArg [" + e.getMessage() + "]");
                    respArgString = this.getStackTrace(e, dataFormat);
                    status = "Exception";
                    respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
                }
                throw throwable;
            }
            respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
            }
        }
        this.writeAPICallLog("getReportArg ( /getReportArg )", status, respArgString, appId, request, this.userInfo);
        return respArgString;
    }

    public String getReportArgClient(String objName, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId, HttpServletRequest request) throws BaseException {
        String respArgString;
        String status;
        block23: {
            String params = "";
            boolean isDestroySession = false;
            boolean isValidSession = false;
            status = "error";
            respArgString = "";
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    if ((respArgString = this.validateRequest(request, dataFormat, null, false, appId, "getReportArg")).equalsIgnoreCase("valid")) {
                        if (!"".equalsIgnoreCase(this.checkNull(objName))) {
                            if (request.getSession().getAttribute("USER_INFO") != null) {
                                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                                String string = userCode = !"".equals(this.checkNull(userCode)) ? userCode : this.userInfo.getLoginCode();
                            }
                            if ((tokenId = this.checkNull(tokenId)).trim().length() > 0) {
                                if (this.validateUserSession(request, tokenId)) {
                                    isValidSession = true;
                                }
                            } else {
                                JSONObject respJson = (JSONObject)this.createSession(userCode, password, isPwdEncrypt, request);
                                respArgString = respJson.getString("result");
                                status = respJson.getString("status");
                                if ("true".equals(respArgString)) {
                                    isValidSession = true;
                                    isDestroySession = true;
                                    BaseLogger.log("3", this.userInfo, null, "params - " + params);
                                }
                            }
                            if (isValidSession) {
                                BaseLogger.log("3", this.userInfo, null, "Valid session!!");
                                XSDParser xsdParser = new XSDParser(objName, this.userInfo);
                                String attachType = "pdf";
                                String argXmlString = xsdParser.getArgumentMetaDataString();
                                if (argXmlString.length() > 0) {
                                    JSONObject repArgsJosn = (JSONObject)this.getReportArgStr(objName, attachType, argXmlString, this.userInfo);
                                    respArgString = repArgsJosn.getString("response");
                                    if (dataFormat.equalsIgnoreCase("JSON")) {
                                        respArgString = this.genericUtility.xmlToJSONString(respArgString);
                                    }
                                    status = repArgsJosn.getString("status");
                                } else {
                                    respArgString = "Something went wrong, please check object name!!";
                                    status = "error";
                                }
                            } else {
                                respArgString = "You are not authorized to access.";
                                status = "error";
                            }
                        } else {
                            respArgString = "Object name is missing!!";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "Exception: @genReportArg [" + e.getMessage() + "]");
                    respArgString = this.getStackTrace(e, dataFormat);
                    status = "Exception";
                    respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
                }
                throw throwable;
            }
            respArgString = this.generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, respArgString);
            }
        }
        this.writeAPICallLog("getReportArgClient ( /getReportArg )", status, respArgString, appId, request, this.userInfo);
        return respArgString;
    }

    public String executeReport(String objName, String reportArgStr, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId, HttpServletRequest request, HttpServletResponse response) throws BaseException {
        String retString;
        String status;
        block20: {
            String params = "";
            status = "error";
            retString = "";
            boolean isValidSession = false;
            boolean isDestroySession = false;
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&REPORT_ARG_STR=" + reportArgStr);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    if ((retString = this.validateRequest(request, dataFormat, null, false, appId, "executeReport")).equalsIgnoreCase("valid")) {
                        if (!"".equalsIgnoreCase(this.checkNull(objName)) && !"".equalsIgnoreCase(this.checkNull(reportArgStr))) {
                            if (request.getSession().getAttribute("USER_INFO") != null) {
                                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                                String string = userCode = !"".equals(this.checkNull(userCode)) ? userCode : this.userInfo.getLoginCode();
                            }
                            if ((tokenId = this.checkNull(tokenId)).trim().length() > 0) {
                                if (this.validateUserSession(request, tokenId)) {
                                    isValidSession = true;
                                }
                            } else {
                                JSONObject respJson = (JSONObject)this.createSession(userCode, password, isPwdEncrypt, request);
                                retString = respJson.getString("result");
                                status = respJson.getString("status");
                                if ("true".equals(retString)) {
                                    isDestroySession = true;
                                    isValidSession = true;
                                }
                            }
                            if (isValidSession) {
                                JSONObject repResoJson = (JSONObject)this.getReportResp(retString, objName, userCode, reportArgStr, status, request, response);
                                retString = repResoJson.getString("result");
                                status = repResoJson.getString("status");
                            } else {
                                retString = "You are not authorized to access.";
                                status = "error";
                            }
                        } else {
                            retString = "Object name or report arguments are is missing!!";
                            status = "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    retString = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
                }
                throw throwable;
            }
            retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
            }
        }
        this.writeAPICallLog("executeReport ( /executeReport )", status, retString, appId, request, this.userInfo);
        return retString;
    }

    public String executeReportClient(String objName, String reportArgStr, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId, HttpServletRequest request, HttpServletResponse response) throws BaseException {
        String retString;
        String status;
        block20: {
            String params = "";
            status = "error";
            retString = "";
            boolean isValidSession = false;
            boolean isDestroySession = false;
            try {
                try {
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REPORT_ARG_STR=" + reportArgStr);
                        paramString.append("&USER_CODE=" + userCode);
                        paramString.append("&PASSWORD=" + password);
                        paramString.append("&IS_PWD_ENCRYPT=" + isPwdEncrypt);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    if ((retString = this.validateRequest(request, dataFormat, null, false, appId, "executeReport")).equalsIgnoreCase("valid")) {
                        if (!"".equalsIgnoreCase(this.checkNull(objName)) && !"".equalsIgnoreCase(this.checkNull(reportArgStr))) {
                            if (request.getSession().getAttribute("USER_INFO") != null) {
                                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                                String string = userCode = !"".equals(this.checkNull(userCode)) ? userCode : this.userInfo.getLoginCode();
                            }
                            if ((tokenId = this.checkNull(tokenId)).trim().length() > 0) {
                                if (this.validateUserSession(request, tokenId)) {
                                    isValidSession = true;
                                }
                            } else {
                                JSONObject respJson = (JSONObject)this.createSession(userCode, password, isPwdEncrypt, request);
                                retString = respJson.getString("result");
                                status = respJson.getString("status");
                                if ("true".equals(retString)) {
                                    isDestroySession = true;
                                    isValidSession = true;
                                }
                            }
                            if (isValidSession) {
                                JSONObject repResoJson = (JSONObject)this.getReportResp(retString, objName, userCode, reportArgStr, status, request, response);
                                retString = repResoJson.getString("result");
                                status = repResoJson.getString("status");
                            } else {
                                retString = "You are not authorized to access.";
                                status = "error";
                            }
                        } else {
                            retString = "Object name or report arguments are is missing!!";
                            status = "error";
                        }
                    } else {
                        status = "error";
                    }
                }
                catch (Exception e) {
                    retString = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
                }
                throw throwable;
            }
            retString = this.generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, tokenId, dataFormat, status, retString);
            }
        }
        this.writeAPICallLog("executeReport ( /executeReportClient )", status, retString, appId, request, this.userInfo);
        return retString;
    }

    public String executeReportAndSendMail(String data, HttpServletRequest request, HttpServletResponse response) throws BaseException {
        String retString;
        String status;
        block13: {
            String params = "";
            status = "error";
            retString = "";
            boolean isDestroySession = false;
            String userCode = "";
            String objName = "";
            String dataFormat = "";
            String courseName = "";
            try {
                try {
                    params = request.getQueryString();
                    JSONObject jsonObject = new JSONObject(data);
                    objName = jsonObject.getString("OBJ_NAME");
                    dataFormat = jsonObject.getString("DATA_FORMAT");
                    courseName = jsonObject.getString("course_name");
                    System.out.println("E12ExtService.executeReportAndSendMail() objName[" + objName + "] dataFormat [" + dataFormat + "] courseName" + courseName + "]");
                    System.out.println("DATA:" + data);
                    if (!"".equalsIgnoreCase(this.checkNull(objName))) {
                        if (request.getSession().getAttribute("USER_INFO") != null) {
                            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                            userCode = this.userInfo.getLoginCode();
                        }
                        if (this.userInfo != null) {
                            XSDParser xsdParser = new XSDParser(objName, this.userInfo);
                            String attachType = "pdf";
                            String argXmlString = xsdParser.getArgumentMetaDataString();
                            BaseLogger.log("3", this.userInfo, null, "reportArgStr:: [" + argXmlString + "] data:: [" + data + "]");
                            JSONObject repArgsJosn = (JSONObject)this.getReportArgStr(objName, attachType, argXmlString, this.userInfo, jsonObject);
                            String reportArgStr = repArgsJosn.getString("response");
                            BaseLogger.log("3", this.userInfo, null, "12333 reportArgStr:: [" + reportArgStr + "]");
                            JSONObject repResoJson = (JSONObject)this.getReportResp("SEND_MAIL", objName, userCode, reportArgStr, status, request, response);
                            retString = repResoJson.getString("result");
                            status = repResoJson.getString("status");
                        } else {
                            retString = "You are not authorized to access.";
                            status = "error";
                        }
                    } else {
                        retString = "Object name or report arguments are is missing!!";
                        status = "error";
                    }
                    BaseLogger.log("3", this.userInfo, null, "getReportResponseMsg: userInfo  " + this.userInfo.toString());
                    BaseLogger.log("3", this.userInfo, null, "getReportResponseMsg: retString " + retString);
                    this.sendMail(this.userInfo, retString, "SRVG_COURSE_COMPL");
                }
                catch (Exception e) {
                    retString = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    retString = this.generateResponse(request, "executeReportAndSendMail", params, "", dataFormat, status, retString);
                    if (isDestroySession) {
                        this.logout(userCode, request);
                        this.generateResponse(request, "logout", params, "", dataFormat, status, retString);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                retString = this.generateResponse(request, "executeReportAndSendMail", params, "", dataFormat, status, retString);
                if (isDestroySession) {
                    this.logout(userCode, request);
                    this.generateResponse(request, "logout", params, "", dataFormat, status, retString);
                }
                throw throwable;
            }
            retString = this.generateResponse(request, "executeReportAndSendMail", params, "", dataFormat, status, retString);
            if (isDestroySession) {
                this.logout(userCode, request);
                this.generateResponse(request, "logout", params, "", dataFormat, status, retString);
            }
        }
        BaseLogger.log("3", this.userInfo, null, "getReportResponseMsg: " + retString);
        this.writeAPICallLog("executeReportSendMail ( /executeReportAndSendMail )", status, retString, null, request, this.userInfo);
        return retString;
    }

    private String getAuthStatus(HttpServletRequest request, String userCode, String password, String siteCode, String authMode, String isSHA256Appld) throws Exception, BaseException {
        String authStatus = "false";
        try {
            String xmlInfo = "";
            if (this.getCommonDBAccess() != null) {
                xmlInfo = this.getCommonDBAccess().authenticate(userCode, password, siteCode, authMode, isSHA256Appld, request);
                BaseLogger.log("3", null, null, "xmlInfo - [" + xmlInfo + "]");
                Document xmlInfodocument = this.genericUtility.parseString(xmlInfo);
                String statusCodeFromxmlInfodocument = xmlInfodocument.getElementsByTagName("STATUS").item(0).getNodeName();
                statusCodeFromxmlInfodocument = this.genericUtility.getColumnValue(statusCodeFromxmlInfodocument, xmlInfodocument);
                BaseLogger.log("3", null, null, "statusCodeFromxmlInfodocument - [" + statusCodeFromxmlInfodocument + "]");
                if (!statusCodeFromxmlInfodocument.equalsIgnoreCase("false")) {
                    String authenticatedUsing = xmlInfodocument.getElementsByTagName("AUTHENTICATED_USING").item(0).getNodeName();
                    authenticatedUsing = this.genericUtility.getColumnValue(authenticatedUsing, xmlInfodocument);
                    BaseLogger.log("3", null, null, "authenticatedUsing - [" + authenticatedUsing + "]");
                    String userCodeFromxmlInfodocument = xmlInfodocument.getElementsByTagName("USER_CODE").item(0).getNodeName();
                    userCodeFromxmlInfodocument = this.genericUtility.getColumnValue(userCodeFromxmlInfodocument, xmlInfodocument);
                    BaseLogger.log("3", null, null, "userCodeFromxmlInfodocument - [" + userCodeFromxmlInfodocument + "]");
                    if (authenticatedUsing.contains("MOBILE_NO") || authenticatedUsing.contains("EMAIL_ID") || authenticatedUsing.contains("USER_ID")) {
                        userCode = userCodeFromxmlInfodocument;
                    }
                }
                authStatus = this.generateResponse(request, userCode, authMode, xmlInfo);
                BaseLogger.log("3", null, null, "authStatus --- [" + authStatus + "]");
                if ("VALID".equalsIgnoreCase(authStatus)) {
                    Document document = this.genericUtility.parseString(xmlInfo);
                    this.setUserInfo(this.createUserInfo(userCode, password, document));
                    request.getSession().setAttribute("IS_EMP_INFO_SET", (Object)"true");
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String hostName = inetAddress.getHostName();
                    String hostIP = inetAddress.getHostAddress();
                    String clientIP = this.checkNull(request.getRemoteAddr());
                    if (this.getUserInfo() != null) {
                        this.getUserInfo().setRemoteHost(clientIP.length() > 0 ? clientIP : "SYSTEM");
                        this.getUserInfo().setSessionId(request.getSession().getId());
                        this.getUserInfo().setHostName(hostName);
                        this.getUserInfo().setHostIP(hostIP);
                        this.getUserInfo().setRemoteHostName(hostName);
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: getAuthStatus: " + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "isValidLogin - [" + authStatus + "]");
        return authStatus;
    }

    private String getXtraParams() throws Exception {
        StringBuffer xtraParamsBuff = new StringBuffer();
        try {
            if (this.getUserInfo() != null) {
                UserInfoBean userInfo = this.getUserInfo();
                String XTRA_PARAMS_SEPARATOR = "~~";
                xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfo.getEmpCode());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfo.getSiteCode());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfo.getEntityCode());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfo.getProfileId());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfo.getUserType());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfo.getCharEnc());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=" + userInfo.getRemoteHost());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfo.getUserLanguage());
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfo.getUserCountry());
                String chgTerm = userInfo.getRemoteHostName();
                if (chgTerm != null && chgTerm.length() > 15) {
                    chgTerm = chgTerm.substring(0, 15);
                } else if (chgTerm == null || chgTerm.length() == 0) {
                    chgTerm = userInfo.getRemoteHost();
                }
                xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
            }
            BaseLogger.log("3", null, null, "xtraParamsBuff [" + xtraParamsBuff + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xtraParamsBuff.toString();
    }

    public String validateRequest(HttpServletRequest request, String dataFormat, String tokenId, boolean toValidateSession, String appId, String endpoint) {
        String validStr = "valid";
        try {
            appId = this.checkNull(appId);
            if (appId.length() == 0) {
                validStr = "You are not authorized to access.";
            } else {
                validStr = this.validateAppId(request, appId, endpoint);
                if ("valid".equalsIgnoreCase(validStr)) {
                    if (!this.isValidDataFormat(dataFormat)) {
                        validStr = "Please enter valid Data Format.";
                    } else if (toValidateSession && !this.validateUserSession(request, tokenId, appId, endpoint)) {
                        validStr = "You are not authorized to access.";
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : validateRequest : " + e.getMessage());
            validStr = this.getStackTrace(e);
        }
        return validStr;
    }

    public boolean isValidDataFormat(String dataFormat) {
        boolean isValidDataFormat = false;
        if ("JSON".equalsIgnoreCase(dataFormat = this.checkNull(dataFormat)) || "XML".equalsIgnoreCase(dataFormat)) {
            isValidDataFormat = true;
        }
        return isValidDataFormat;
    }

    public String generateResponse(HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result) {
        String response = "";
        try {
            BaseLogger.log("0", null, null, "dataFormat got in generate response= " + dataFormat);
            JSONObject responseJson = new JSONObject();
            JSONObject resultJson = new JSONObject();
            result = this.checkNull(result);
            BaseLogger.log("0", null, null, "dataFormat got in generate result= " + result);
            if (dataFormat.equals("JSON") || dataFormat.equals("JSONString")) {
                BaseLogger.log("0", null, null, "in generate response= in JSONString");
                if (this.isJSONValid(result)) {
                    BaseLogger.log("0", null, null, "in generate response= in JSONString is valid");
                    JSONObject resultStringToJSON = new JSONObject(result);
                    BaseLogger.log("0", null, null, "in generate response= in JSONString is valid" + resultStringToJSON);
                    if (resultStringToJSON.has("Warning")) {
                        status = "warning";
                    } else if (resultStringToJSON.has("Errors")) {
                        status = "error";
                    } else if (resultStringToJSON.has("Exception")) {
                        status = "exception";
                    }
                }
            } else if (this.genericUtility.isXMLString(result)) {
                try {
                    Document resultDoc = this.convertStringToDocument(result);
                    if (resultDoc != null) {
                        NodeList warningList = resultDoc.getElementsByTagName("Warning");
                        NodeList errorsList = resultDoc.getElementsByTagName("Errors");
                        NodeList exceptionList = resultDoc.getElementsByTagName("Exception");
                        if (warningList.getLength() > 0) {
                            status = "warning";
                        } else if (errorsList.getLength() > 0) {
                            status = "error";
                        } else if (exceptionList.getLength() > 0) {
                            status = "exception";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "ITMException : generateResponse 5318 : " + e.getMessage());
                    e.printStackTrace();
                }
            }
            resultJson.put("status", (Object)status);
            try {
                String logResult = this.generateExtServiceLog(request, tokenId, serviceName, params, status, result, this.getUserInfo());
                BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dataFormat.equalsIgnoreCase("JSON") && this.isJSONValid(result)) {
                BaseLogger.log("3", null, null, "result Is result is validJSON? [" + this.genericUtility.isJSONValid(result) + "]");
                BaseLogger.log("3", null, null, "result E12ExtserviceUtility-is valid [" + result + "]");
                BaseLogger.log("3", null, null, "Adding JSONObject to result");
                JSONObject resultJSON = new JSONObject(result);
                resultJson.put("results", (Object)resultJSON);
            } else {
                resultJson.put("results", (Object)result);
            }
            responseJson.put("Response", (Object)resultJson);
            response = responseJson.toString();
            if (!"JSON".equalsIgnoreCase(dataFormat) && !"JSONString".equalsIgnoreCase(dataFormat)) {
                response = this.genericUtility.jsonToXMLString(response);
                response = this.genericUtility.remAllXmlDec(response);
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException : generateResponse : " + e.getMessage());
            response = this.getStackTrace(e);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException : generateResponse : " + e.getMessage());
            response = this.getStackTrace((Exception)((Object)e));
        }
        return response;
    }

    public String generateJSONResponse(HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result) {
        BaseLogger.log("3", null, null, "Result String for JSON - [" + result);
        String response = "";
        try {
            JSONObject responseJson = new JSONObject();
            JSONObject resultJson = new JSONObject();
            result = this.checkNull(result);
            if (result.indexOf("Warning") != -1) {
                status = "warning";
            } else if (result.indexOf("Errors") != -1) {
                status = "error";
            } else if (result.indexOf("Exception") != -1) {
                status = "exception";
            }
            resultJson.put("status", (Object)status);
            try {
                String logResult = this.generateExtServiceLog(request, tokenId, serviceName, params, status, result, this.getUserInfo());
                BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (result.contains("TOKEN_ID")) {
                BaseLogger.log("3", null, null, "Adding Json result - [");
                JSONObject resultJsonObj = new JSONObject(result);
                resultJson.put("results", (Object)resultJsonObj);
            } else {
                resultJson.put("results", (Object)result);
            }
            responseJson.put("Response", (Object)resultJson);
            response = responseJson.toString();
            if (!"JSON".equalsIgnoreCase(dataFormat)) {
                response = this.genericUtility.jsonToXMLString(response);
                response = this.genericUtility.remAllXmlDec(response);
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException : generateResponse : " + e.getMessage());
            response = this.getStackTrace(e);
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException : generateResponse : " + e.getMessage());
            response = this.getStackTrace((Exception)((Object)e));
        }
        return response;
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues) throws RemoteException, ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(this.userInfo);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    private String generateExtServiceLog(HttpServletRequest request, String tokenId, String action, String params, String responseType, String response, UserInfoBean userInfo) throws ITMException {
        String result = "";
        String requestedTerm = "";
        String requestedUser = "";
        try {
            String hostName = "";
            String hostIP = "";
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getHostName();
            hostIP = inetAddress.getHostAddress();
            if (userInfo != null) {
                requestedTerm = this.checkNull(userInfo.getRemoteHost());
                if (requestedTerm.length() > 15) {
                    requestedTerm = requestedTerm.substring(0, 15);
                }
                requestedUser = this.checkNull(userInfo.getLoginCode());
            } else {
                requestedTerm = this.checkNull(request.getRemoteAddr());
                if (requestedTerm.length() > 15) {
                    requestedTerm = requestedTerm.substring(0, 15);
                }
                if (hostName.length() > 10) {
                    requestedUser = hostName.substring(0, 10);
                }
            }
            ExtServiceEJB extServices = new ExtServiceEJB();
            result = extServices.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, hostName, hostIP, userInfo);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        if ("error".equals(responseType)) {
            String fileName = String.valueOf(requestedUser) + "_log_" + System.currentTimeMillis() + ".log";
            this.generateErrorLog(response, fileName);
        }
        return result;
    }

    private void generateErrorLog(String log, String fileName) {
        try {
            String logDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "webService_Log" + File.separator + fileName;
            File outFile = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "webService_Log");
            if (!outFile.exists()) {
                outFile.mkdir();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
            out.println(log);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ITMException(e);
        }
        return ctx;
    }

    private String executeSystemEvent(String objName, String eventCode, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, String xtraParams) throws ITMException {
        String returnValue = "";
        try {
            String userInfo = "";
            if (this.getUserInfo() != null) {
                userInfo = this.getUserInfo().toString();
            }
            ExtServiceEventManagerEJB eventManager = new ExtServiceEventManagerEJB();
            returnValue = eventManager.executeSystemEvent(objName, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams, userInfo, this.getUserInfo());
            eventManager = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: executeSystemEvent: " + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "executeSystemEvent :[" + returnValue + "]");
        return returnValue;
    }

    private String generateResponse(HttpServletRequest request, String userCode, String loginMode, String xmlInfo) throws BaseException {
        BaseLogger.log("2", null, null, "Generating Response....");
        String responseString = "";
        try {
            Document document;
            HttpSession session = request.getSession();
            if (this.checkNull(xmlInfo).length() > 0 && (document = this.genericUtility.parseString(xmlInfo)).getElementsByTagName("STATUS_CODE").item(0) != null && document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null) {
                String statusCode;
                responseString = statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
                if (statusCode.equalsIgnoreCase("RESIGNED")) {
                    responseString = Messages.getString("AuthenticateServlet_employeeHasResigned", this.getUserLangAndCountry(userCode));
                } else if (statusCode.equalsIgnoreCase("LOCKED")) {
                    responseString = Messages.getString("AuthenticateServlet_accountIsLockedContactAdmin", this.getUserLangAndCountry(userCode));
                } else if (statusCode.indexOf("INVALID") != -1) {
                    if (statusCode.equalsIgnoreCase("INVALID_USR")) {
                        responseString = Messages.getString("AuthenticateServlet_pleaseEnterValidUserNameAndPassword", this.getUserLangAndCountry(userCode));
                    } else if (statusCode.equalsIgnoreCase("ACCOUNT_LOCKED")) {
                        responseString = String.valueOf(Messages.getString("AuthenticateServlet_accountIsLocked", this.getUserLangAndCountry(request.getParameter("USER")))) + " " + CommonConstants.WRONG_LOGIN_COUNT + " times. " + Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID", this.getUserLangAndCountry(request.getParameter("USER"))) + " " + Messages.getString("AuthenticateServlet_accountUnlocked", this.getUserLangAndCountry(request.getParameter("USER")));
                    } else if (statusCode.equalsIgnoreCase("WRONG_LOGIN_COUNT_EXCEED")) {
                        responseString = String.valueOf(Messages.getString("AuthenticateServlet_passwordBlockedSinceWronglyEntered", this.getUserLangAndCountry(request.getParameter("USER")))) + CommonConstants.WRONG_LOGIN_COUNT + Messages.getString("AuthenticateServlet_newPasswordSentToEmailID", this.getUserLangAndCountry(request.getParameter("USER")));
                    } else if (statusCode.equalsIgnoreCase("INVALID_PWD")) {
                        responseString = Messages.getString("AuthenticateServlet_pleaseEnterValidUserNameAndPassword", this.getUserLangAndCountry(userCode));
                    }
                    if (session.getAttribute("INVALID_COUNT") == null) {
                        session.setAttribute("INVALID_COUNT", (Object)new Integer(1));
                    } else {
                        int maxCount = 5;
                        int invaildCount = (Integer)session.getAttribute("INVALID_COUNT");
                        if (invaildCount == maxCount - 1) {
                            if (document.getElementsByTagName("RES_TYPE") != null && document.getElementsByTagName("RES_TYPE").item(0) != null) {
                                String resType = document.getElementsByTagName("RES_TYPE").item(0).getFirstChild().getNodeValue();
                                this.getCommonDBAccess().secureAccount(userCode, "0", this.userInfo, request.getRemoteAddr(), "");
                                if (Integer.parseInt(resType) == 0) {
                                    String emailIdOff = null;
                                    if (document.getElementsByTagName("EMAIL_ID") != null && document.getElementsByTagName("EMAIL_ID").item(0) != null) {
                                        emailIdOff = document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild().getNodeValue();
                                    }
                                    responseString = String.valueOf(Messages.getString("AuthenticateServlet_passwordBlockedSinceWronglyEntered", this.getUserLangAndCountry(userCode))) + maxCount + Messages.getString("AuthenticateServlet_newPasswordSentToEmailID", this.getUserLangAndCountry(userCode)) + emailIdOff;
                                } else if (Integer.parseInt(resType) == 1) {
                                    responseString = Messages.getString("AuthenticateServlet_accountIsLockedContactAdmin", this.getUserLangAndCountry(userCode));
                                } else {
                                    BaseLogger.log("3", null, null, "Invaild Response Type(resType) Found :" + resType);
                                }
                            }
                            session.setAttribute("INVALID_COUNT", (Object)new Integer(0));
                        } else {
                            session.setAttribute("INVALID_COUNT", (Object)new Integer(invaildCount + 1));
                        }
                    }
                } else if (statusCode.indexOf("PASS_EXP") != -1) {
                    if (statusCode.equalsIgnoreCase("PASS_EXP_NOGRACE")) {
                        responseString = Messages.getString("AuthenticateServlet_passwordExpiredChangeIt", this.getUserLangAndCountry(userCode));
                    } else if (statusCode.equalsIgnoreCase("PASS_EXP_GRACE")) {
                        responseString = Messages.getString("AuthenticateServlet_passwordExpiredWouldYouLikeToChange", this.getUserLangAndCountry(userCode));
                    }
                } else if (statusCode.equalsIgnoreCase("VALID")) {
                    if (document.getElementsByTagName("SITE_CODE").item(0) != null) {
                        String siteCodeValue = document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue();
                        if (siteCodeValue.equalsIgnoreCase("INVALID_SITE")) {
                            responseString = Messages.getString("AuthenticateServlet_NotValidSite", this.getUserLangAndCountry(userCode));
                            session.setAttribute("USER_INFO", null);
                        } else if (siteCodeValue.equalsIgnoreCase("INACCESSIBLE_SITE")) {
                            responseString = Messages.getString("AuthenticateServlet_InAccessibleSite", this.getUserLangAndCountry(userCode));
                            session.setAttribute("USER_INFO", null);
                        }
                    }
                } else if (statusCode.equalsIgnoreCase("FIRST_LOGIN")) {
                    responseString = Messages.getString("AuthenticateServlet_compulsoryChangePasswordPleaseDoSo", this.getUserLangAndCountry(userCode));
                } else if (statusCode.equalsIgnoreCase("ATTENDANCE_MISSING")) {
                    responseString = Messages.getString("AuthenticateServlet_entryInDailyAttendanceNotFound", this.getUserLangAndCountry(userCode));
                } else if (statusCode.equalsIgnoreCase("INVALID_LICENCE")) {
                    BaseLogger.log("3", null, null, "statusCode final[" + statusCode + "]");
                    responseString = Messages.getString("Invalid Activation Code", this.getUserLangAndCountry(userCode));
                } else if (statusCode.equalsIgnoreCase("RELEASE")) {
                    responseString = Messages.getString("AuthenticateServlet_employeeHasResigned", this.getUserLangAndCountry(userCode));
                }
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: generateResponse:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: generateResponse:==>\n" + e);
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "responseString - [" + responseString + "]");
        return responseString;
    }

    private UserInfoBean createUserInfo(String userCode, String passwd, Document document) throws BaseException {
        UserInfoBean userInfo = null;
        try {
            userInfo = new UserInfoBean();
            userInfo.setLoginCode(userCode);
            userInfo.setLoginPwd(passwd);
            if (document.getElementsByTagName("PROFILE_ID").item(0) != null && document.getElementsByTagName("PROFILE_ID").item(0).getFirstChild() != null) {
                userInfo.setProfileId(document.getElementsByTagName("PROFILE_ID").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("EMP_CODE").item(0) != null && document.getElementsByTagName("EMP_CODE").item(0).getFirstChild() != null) {
                userInfo.setEmpCode(document.getElementsByTagName("EMP_CODE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("EMP_FNAME").item(0) != null && document.getElementsByTagName("EMP_FNAME").item(0).getFirstChild() != null) {
                userInfo.setEmpFName(document.getElementsByTagName("EMP_FNAME").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("EMP_MNAME").item(0) != null && document.getElementsByTagName("EMP_MNAME").item(0).getFirstChild() != null) {
                userInfo.setEmpMName(document.getElementsByTagName("EMP_MNAME").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("EMP_LNAME").item(0) != null && document.getElementsByTagName("EMP_LNAME").item(0).getFirstChild() != null) {
                userInfo.setEmpLName(document.getElementsByTagName("EMP_LNAME").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SITE_CODE").item(0) != null && document.getElementsByTagName("SITE_CODE").item(0).getFirstChild() != null) {
                userInfo.setSiteCode(document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("IS_BI_USER").item(0) != null && document.getElementsByTagName("IS_BI_USER").item(0).getFirstChild() != null) {
                userInfo.setIsBIUser(document.getElementsByTagName("IS_BI_USER").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("PROFILE_ID__RES").item(0) != null && document.getElementsByTagName("PROFILE_ID__RES").item(0).getFirstChild() != null) {
                userInfo.setProfileIdRes(document.getElementsByTagName("PROFILE_ID__RES").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("LOGGER_TYPE").item(0) != null && document.getElementsByTagName("LOGGER_TYPE").item(0).getFirstChild() != null) {
                userInfo.setLoggerType(document.getElementsByTagName("LOGGER_TYPE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("STAN_CD__HQ_DESCR").item(0) != null && document.getElementsByTagName("STAN_CD__HQ_DESCR").item(0).getFirstChild() != null) {
                userInfo.setStanCode(document.getElementsByTagName("STAN_CD__HQ_DESCR").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("DESIGNATION").item(0) != null && document.getElementsByTagName("DESIGNATION").item(0).getFirstChild() != null) {
                userInfo.setDesignation(document.getElementsByTagName("DESIGNATION").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("DATE_JOIN").item(0) != null && document.getElementsByTagName("DATE_JOIN").item(0).getFirstChild() != null) {
                userInfo.setDateJoin(document.getElementsByTagName("DATE_JOIN").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("TRANS_DB").item(0) != null && document.getElementsByTagName("TRANS_DB").item(0).getFirstChild() != null) {
                userInfo.setTransDB(document.getElementsByTagName("TRANS_DB").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("USER_THEME").item(0) != null && document.getElementsByTagName("USER_THEME").item(0).getFirstChild() != null) {
                userInfo.setUserTheme(document.getElementsByTagName("USER_THEME").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("USER_GEO_FENCE_ENABLED").item(0) != null && document.getElementsByTagName("USER_GEO_FENCE_ENABLED").item(0).getFirstChild() != null) {
                userInfo.setUserGeoFence(document.getElementsByTagName("USER_GEO_FENCE_ENABLED").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("USER_NAME").item(0) != null && document.getElementsByTagName("USER_NAME").item(0).getFirstChild() != null) {
                userInfo.setUserName(document.getElementsByTagName("USER_NAME").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("IS_PASSWORD_STORE").item(0) != null && document.getElementsByTagName("IS_PASSWORD_STORE").item(0).getFirstChild() != null) {
                userInfo.setIsPasswordStore(document.getElementsByTagName("IS_PASSWORD_STORE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("DEFAULT_MENU").item(0) != null && document.getElementsByTagName("DEFAULT_MENU").item(0).getFirstChild() != null) {
                userInfo.setDefaultMenu(document.getElementsByTagName("DEFAULT_MENU").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("FEATURES").item(0) != null && document.getElementsByTagName("FEATURES").item(0).getFirstChild() != null) {
                userInfo.setFeatures(document.getElementsByTagName("FEATURES").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("ENTERPRISE").item(0) != null && document.getElementsByTagName("ENTERPRISE").item(0).getFirstChild() != null) {
                userInfo.setEnterprise(document.getElementsByTagName("ENTERPRISE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("USER_GEO_POS_OPTION").item(0) != null && document.getElementsByTagName("USER_GEO_POS_OPTION").item(0).getFirstChild() != null) {
                userInfo.setGeoPosOption(document.getElementsByTagName("USER_GEO_POS_OPTION").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("ENTERPRISE_DESCR").item(0) != null && document.getElementsByTagName("ENTERPRISE_DESCR").item(0).getFirstChild() != null) {
                userInfo.setEnterpriseDescr(document.getElementsByTagName("ENTERPRISE_DESCR").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("NETWORK_OPTION").item(0) != null && document.getElementsByTagName("NETWORK_OPTION").item(0).getFirstChild() != null) {
                userInfo.setUserNetworkOption(document.getElementsByTagName("NETWORK_OPTION").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0) != null && document.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0).getFirstChild() != null) {
                userInfo.setIsAllowOfflineEdit(document.getElementsByTagName("IS_ALLOW_OFFLINE_EDIT").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0) != null && document.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0).getFirstChild() != null) {
                userInfo.setIsAllowOfflineDelete(document.getElementsByTagName("IS_ALLOW_OFFLINE_DELETE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("USER_ID").item(0) != null && document.getElementsByTagName("USER_ID").item(0).getFirstChild() != null) {
                userInfo.setLoginUserId(document.getElementsByTagName("USER_ID").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("MOBILE_NO").item(0) != null && document.getElementsByTagName("MOBILE_NO").item(0).getFirstChild() != null) {
                userInfo.setLoginMobileNo(document.getElementsByTagName("MOBILE_NO").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("EMAIL_ID").item(0) != null && document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_HOST").item(0) != null && document.getElementsByTagName("SMTP_HOST").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_HOST").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_PORT").item(0) != null && document.getElementsByTagName("SMTP_PORT").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_PORT").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_USER").item(0) != null && document.getElementsByTagName("SMTP_USER").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_USER").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_PASS_WD").item(0) != null && document.getElementsByTagName("SMTP_PASS_WD").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_PASS_WD").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_PROTOCOL_TYPE").item(0) != null && document.getElementsByTagName("SMTP_PROTOCOL_TYPE").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_PROTOCOL_TYPE").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("SMTP_MAILFROM").item(0) != null && document.getElementsByTagName("SMTP_MAILFROM").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("SMTP_MAILFROM").item(0).getFirstChild().getNodeValue());
            }
            if (document.getElementsByTagName("ADMIN_EMAIL_ID").item(0) != null && document.getElementsByTagName("ADMIN_EMAIL_ID").item(0).getFirstChild() != null) {
                userInfo.setLoginEmailId(document.getElementsByTagName("ADMIN_EMAIL_ID").item(0).getFirstChild().getNodeValue());
            }
            if (this.getCommonDBAccess() != null) {
                userInfo.setEmpInfo(this.getCommonDBAccess().getEmpInfo(userInfo.getLoginCode(), userInfo.getSiteCode(), userInfo.getTransDB()));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: createUserInfo:==>\n" + e);
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "UserInfoBean Created.....");
        return userInfo;
    }

    private ArrayList<String> getUserLangAndCountry(String userCode) {
        ArrayList<String> langAndCountryList = new ArrayList<String>();
        try {
            String userLanguage = this.getCommonDBAccess().getDBColumnValue("USERS", "USER_LANG", "WHERE CODE = '" + userCode + "'");
            String userCountry = this.getCommonDBAccess().getDBColumnValue("USERS", "USER_COUNTRY", "WHERE CODE = '" + userCode + "'");
            if (userLanguage != null && userCountry != null) {
                langAndCountryList.add(userLanguage);
                langAndCountryList.add(userCountry);
            }
            BaseLogger.log("3", null, null, "User Language[" + userLanguage + "], User Country[" + userCountry + "], List[" + langAndCountryList.toString() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: while accessing user country and user language from database. ");
            e.printStackTrace();
        }
        return langAndCountryList;
    }

    private String generateNewTokenId(String userCode) {
        String tokenId = String.valueOf(userCode) + ":" + UUID.randomUUID().toString().toUpperCase();
        if (tokenId.length() > 30) {
            tokenId = tokenId.substring(0, 30);
        }
        return tokenId;
    }

    private JSONObject getUserDtl(JSONObject resultDtlJson) throws ITMException, NamingException {
        try {
            BaseLogger.log("3", null, null, "in get user dtl");
            ExtServiceEJB extServices = new ExtServiceEJB();
            BaseLogger.log("3", null, null, "User InfoBean in getUserDtl = " + this.getUserInfo());
            UserInfoBean userInfoBean = extServices.updateUseInfo(this.getUserInfo());
            this.setUserInfo(userInfoBean);
            HashMap<String, String> resultMap = extServices.getLoginUserDetails(this.getUserInfo());
            if (resultMap != null && resultMap.size() > 0) {
                for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                    resultDtlJson.put(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getUserDtl " + e.getMessage());
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "resultDtlJson-[" + resultDtlJson + "]");
        return resultDtlJson;
    }

    public boolean validateUserSession(HttpServletRequest request, String tokenId) {
        return this.validateUserSession(request, tokenId, null, null);
    }

    private boolean validateUserSession(HttpServletRequest request, String tokenId, String appId, String endPoint) {
        boolean isValidUser = false;
        try {
            String sessionTokenId = request.getSession().getAttribute("TOKEN_ID") != null ? "" + request.getSession().getAttribute("TOKEN_ID") : "";
            tokenId = this.checkNull(tokenId);
            BaseLogger.log("3", null, null, "sessionTokenId - [" + sessionTokenId + "], tokenId - [" + tokenId + "]");
            if (tokenId.length() > 0) {
                if (sessionTokenId.equals(tokenId)) {
                    isValidUser = true;
                    if (request.getSession().getAttribute("USER_INFO") != null) {
                        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                        this.setUserInfo(userInfo);
                    }
                } else {
                    isValidUser = this.validateLLT(tokenId, appId, endPoint);
                }
            } else if (appId != null && appId.trim().length() > 0 && endPoint != null && endPoint.trim().length() > 0) {
                isValidUser = this.validateLLT(tokenId, appId, endPoint);
            }
        }
        catch (Exception e) {
            isValidUser = false;
            e.printStackTrace();
        }
        return isValidUser;
    }

    public boolean validateLLT(String tokenId, String appId, String endPoint) {
        boolean isValidUser = false;
        try {
            ExtAuthAppAPIBean authAppAPIBean = this.getCommonDBAccess().getAuthAppAPIDetails(endPoint, appId);
            BaseLogger.log("3", null, null, "visionEdiBean : [" + authAppAPIBean + "]");
            if (authAppAPIBean != null) {
                String authAppUserId = this.checkNull(authAppAPIBean.getUserId());
                BaseLogger.log("3", null, null, "authAppUserId : [" + authAppUserId + "]");
                String enterprise = this.getCommonDBAccess().getUserEnterprise(authAppUserId);
                BaseLogger.log("3", null, null, "enterprise : [" + enterprise + "]");
                DBAccessEJB dbAccess = new DBAccessEJB();
                appId = this.checkNull(appId);
                tokenId = appId.length() == 0 ? dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "TOKEN_ID", " ENTERPRISE = '" + enterprise + "' AND USER_ID = '" + authAppUserId + "' ") : dbAccess.getDBColumnValue("USER_ACC_CHANNEL", "TOKEN_ID", " ENTERPRISE = '" + enterprise + "' AND USER_ID = '" + authAppUserId + "' AND APP_ID = '" + appId + "' ");
                dbAccess = null;
                ExtAuthApplicationBean applicationBean = this.getCommonDBAccess().getExtAuthApplicationInfo(appId);
                if (applicationBean != null) {
                    BaseLogger.log("3", null, null, "E12ExtService :: validateUserSession :: SHARED_KEY : [" + applicationBean.getSharedKey() + "]");
                    String validateJWTResult = this.validateJWT(tokenId, appId, applicationBean.getSharedKey());
                    if ("valid".equalsIgnoreCase(validateJWTResult)) {
                        isValidUser = true;
                        HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenId, applicationBean.getSharedKey());
                        this.setUserInfo(this.createUserInfo(jwtData));
                    }
                }
            }
        }
        catch (Exception e) {
            isValidUser = false;
            e.printStackTrace();
        }
        return isValidUser;
    }

    private void logout(String userCode, HttpServletRequest request) throws BaseException {
        String sessionId = request.getSession().getId();
        try {
            try {
                EventLogInfoBean eventInfoBean = new EventLogInfoBean(userCode);
                eventInfoBean.removeSessionActivity(sessionId);
                this.getCommonDBAccess().updateSessionTrace(userCode, sessionId, "L", "Logout done By User.");
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
            }
        }
        finally {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }
    }

    private boolean isObjectRightsAvailable(String xmlStr) {
        boolean isRightsAvailable = true;
        try {
            String userLevel = this.getUserInfo().getUserLevel();
            if (!"0".equalsIgnoreCase(userLevel) && xmlStr != null && !xmlStr.equalsIgnoreCase("-1")) {
                Document xmlStrDoc = new E12GenericUtility().parseString(xmlStr);
                String editFlag = this.getInputXMLDetails(xmlStrDoc, "editFlag");
                String objName = this.getInputXMLDetails(xmlStrDoc, "objName");
                isRightsAvailable = new ITMTransactionEditorBean().getRightsInfo(objName, this.getUserInfo(), editFlag);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :: isRightsAvailable : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        BaseLogger.log("3", this.userInfo, null, "isRightsAvailable : [" + isRightsAvailable + "]");
        return isRightsAvailable;
    }

    private String getInputXMLDetails(Document xmlStrDoc, String tagName) {
        String tagValue = "";
        try {
            BaseLogger.log("3", this.userInfo, null, "tagName : [" + tagName + "]");
            if (xmlStrDoc != null && tagName != null && tagName.trim().length() > 0 && xmlStrDoc.getElementsByTagName(tagName).item(0) != null && xmlStrDoc.getElementsByTagName(tagName).item(0).getFirstChild() != null) {
                tagValue = xmlStrDoc.getElementsByTagName(tagName).item(0).getFirstChild().getNodeValue().trim();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :: getEditFlag : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        BaseLogger.log("3", this.userInfo, null, "tagValue : [" + tagValue + "]");
        return tagValue;
    }

    private String processRequest(String xmlString, ServletContext context) throws ITMException {
        String resultString = "";
        Connection conn = null;
        boolean isError = false;
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                String userInfoStr = this.getUserInfo().toString();
                BaseLogger.log("3", null, null, "getUserInfo() - " + userInfoStr);
                String transDB = this.getUserInfo().getTransDB();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                conn.setAutoCommit(false);
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfoStr, xmlString);
                resultString = this.checkNull(masterStateful.processRequest(this.getUserInfo(), xmlString, true, conn));
                if (this.checkNull(xmlString).length() > 0) {
                    String saveLevel = "";
                    Node saveLevelNode = this.genericUtility.parseString(xmlString).getElementsByTagName("saveLevel").item(0);
                    if (saveLevelNode != null && saveLevelNode.getFirstChild() != null) {
                        saveLevel = saveLevelNode.getFirstChild().getNodeValue();
                    }
                    if (saveLevel != null && resultString != null && saveLevel.equals("1") && resultString.indexOf("Success") != -1) {
                        try {
                            String tranID = "";
                            Node tranIdNode = this.genericUtility.parseString(resultString).getElementsByTagName("TranID").item(0);
                            if (tranIdNode != null && tranIdNode.getFirstChild() != null) {
                                tranID = tranIdNode.getFirstChild().getNodeValue();
                            }
                            String objName = "";
                            Node objNameNode = this.genericUtility.parseString(xmlString).getElementsByTagName("objName").item(0);
                            if (objNameNode != null && objNameNode.getFirstChild() != null) {
                                objName = objNameNode.getFirstChild().getNodeValue();
                            }
                            BaseLogger.log("3", null, null, "objName - [" + objName + "], tranID - [" + tranID + "]");
                            String userId = this.getUserInfo().getLoginCode();
                            String randomNo = "" + new Random().nextInt();
                            this.addFollowUpAction(userId, randomNo, tranID, objName, context);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (ITMException e) {
                BaseLogger.log("0", null, null, "ITMException :: processRequest() :==>\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
            catch (RemoteException e) {
                BaseLogger.log("0", null, null, "RemoteException :: processRequest() :==>\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
            catch (SQLException e) {
                BaseLogger.log("0", null, null, "SQLException :: processRequest() :==>\n" + e.getMessage());
                isError = true;
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: processRequest() :==>\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :: processRequest() :==>\n" + e.getMessage());
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            if (resultString.indexOf("<Errors>") != -1 || resultString.indexOf("Exception") != -1) {
                isError = true;
            }
            if (conn != null) {
                try {
                    if (isError) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                    conn.close();
                    conn = null;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private void addFollowUpAction(String userId, String editorId, String tranId, String objName, ServletContext context) {
        try {
            String pendingWrkflwMapKey = String.valueOf(userId) + "~" + editorId;
            String pendingWrkflwMapValue = String.valueOf(objName) + "~" + tranId;
            Map<String, String> pendingWrkflwMap = new HashMap();
            if (context.getAttribute("pendingWrkflwMap") != null) {
                pendingWrkflwMap = (Map)context.getAttribute("pendingWrkflwMap");
                if (pendingWrkflwMap != null) {
                    pendingWrkflwMap.put(pendingWrkflwMapKey, pendingWrkflwMapValue);
                }
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
                followUpActionLocal.followUpAction(pendingWrkflwMapKey, context, this.userInfo);
                followUpActionLocal = null;
            }
            BaseLogger.log("3", null, null, "pendingWrkflwMap - " + context.getAttribute("pendingWrkflwMap"));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String executeSystemEvent(String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams) throws ITMException {
        String retStr = "";
        try {
            InitialContext ctx = this.getInitialContext();
            EventManagerEJB eventManager = new EventManagerEJB();
            retStr = eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId);
            eventManager.remove();
            eventManager = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :: executeSystemEvent :==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: executeSystemEvent :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retStr;
    }

    private String executeSystemEvent(String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams, UserInfoBean userInfoBean) throws ITMException {
        String retStr = "";
        try {
            InitialContext ctx = this.getInitialContext();
            EventManagerEJB eventManager = new EventManagerEJB();
            retStr = eventManager.executeSystemEvent(objName, eventCode, null, transDomString, detailDomString, xtraParams, domId, userInfoBean);
            eventManager.remove();
            eventManager = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :: executeSystemEvent :==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: executeSystemEvent :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retStr;
    }

    private String getItemChangeData(String objName, String domId, String transDomStr, String detailDomStr) throws ITMException {
        String resultString = "";
        try {
            String transDB = this.checkNull(this.getUserInfo().getTransDB());
            resultString = transDB.length() > 0 ? this.executeSystemEvent(objName, "post_item_change", transDomStr, detailDomStr, domId, this.getXtraParams(), this.getUserInfo()) : this.executeSystemEvent(objName, "post_item_change", transDomStr, detailDomStr, domId, this.getXtraParams());
            if (resultString != null && resultString.indexOf("Errors") == -1) {
                Document transDom = this.genericUtility.parseString(transDomStr);
                String objContext = this.getValueOfField(transDom, "objContext");
                if (resultString != null && resultString.indexOf("Detail" + objContext) == -1) {
                    resultString = resultString.replaceAll("Detail", "Detail" + objContext);
                }
                BaseLogger.log("3", null, null, "responseStr[After updating the objContext] ::" + resultString);
                Document responseDom = this.genericUtility.parseString(resultString);
                Element element = (Element)responseDom.getElementsByTagName("Detail" + objContext).item(0);
                if (element != null) {
                    element.setAttribute("domID", domId);
                }
                resultString = this.genericUtility.serializeDom(responseDom);
                BaseLogger.log("3", null, null, "responseStr[After updating the domID] ::" + resultString);
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException :: getItemChangeData() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        catch (DOMException e) {
            BaseLogger.log("0", null, null, "DOMException :: getItemChangeData() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getItemChangeData() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return resultString;
    }

    private String getValueOfField(Document parentDom, String currFieldName) throws ITMException {
        BaseLogger.log("2", null, null, "Getting value for field : [" + currFieldName + "]");
        String fieldValue = null;
        try {
            NodeList detailNodeList = parentDom.getElementsByTagName("Detail1");
            if (detailNodeList.getLength() > 0) {
                fieldValue = detailNodeList.item(0).getAttributes().getNamedItem(currFieldName) != null ? detailNodeList.item(0).getAttributes().getNamedItem(currFieldName).getNodeValue() : null;
            }
            if (fieldValue == null) {
                BaseLogger.log("3", null, null, "Seraching dom value as an element from dom.........");
                NodeList currFieldList = parentDom.getElementsByTagName(currFieldName);
                if (currFieldList.getLength() > 0) {
                    fieldValue = currFieldList.item(0).getFirstChild() != null ? currFieldList.item(0).getFirstChild().getNodeValue() : null;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getValueOfField() :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "getValueOfField() - fieldName : [" + currFieldName + "], value : [" + fieldValue + "]");
        return fieldValue;
    }

    private String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr, UserInfoBean userInfo, String allDetailXml, String formNo, String reqParams) throws ITMException {
        String xmlString = "";
        try {
            reqParams = reqParams == null || reqParams.trim().length() == 0 ? null : reqParams;
            formNo = formNo == null || formNo.trim().length() == 0 ? "1" : formNo;
            PopUpEJB popUp = new PopUpEJB();
            xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo, allDetailXml, formNo, reqParams);
            popUp = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getPopUpKeyStr [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return xmlString;
    }

    private String getXMLDataForHeader(String objName, String argFieldValues, String argFieldTypes, String advQuery, HttpServletRequest request, String searchParam, String editorId) throws ITMException {
        String retXMLStr = null;
        try {
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            if (userInfo != null) {
                MasterDataEJB masterDataEJB = new MasterDataEJB();
                masterDataEJB.setEditorId(editorId);
                retXMLStr = masterDataEJB.getXMLFromDBForBrow(objName, "1", "1", argFieldValues, argFieldTypes, advQuery, userInfo, true, searchParam);
                masterDataEJB = null;
            } else {
                retXMLStr = "You have not logged on or your session has expired.";
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException :: getXMLDataForHeader :" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getXMLDataForHeader :" + e.getMessage());
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String getWrkFlwBrowData(String signStatus, String roles, String context1, String context2, String context3, String applName, UserInfoBean userInfo) throws ITMException, Exception {
        String signXMLData = "";
        try {
            SignManagerEJB signManager = new SignManagerEJB();
            String entityCode = "";
            String transDb = "";
            if (userInfo != null) {
                entityCode = userInfo.getEntityCode();
                transDb = userInfo.getTransDB();
            }
            signXMLData = signManager.getBrowData("", signStatus, roles, context1, context2, context3, entityCode, userInfo.toString(), applName, transDb);
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: getWrkFlwBrowData: " + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "signXMLData - [" + signXMLData + "]");
        return signXMLData;
    }

    private String getSignTransDetData(String refSer, String refId, int lineNo, UserInfoBean userInfo) throws RemoteException, ITMException {
        String signTransXMLData = "";
        try {
            SignManagerEJB signManager = new SignManagerEJB();
            String userCode = "";
            String siteCode = "";
            if (userInfo != null) {
                userCode = userInfo.getLoginCode();
                siteCode = userInfo.getSiteCode();
            }
            String transDetailXML = signManager.getTransXMLString(userCode, siteCode, refSer, refId, lineNo, userInfo.toString(), null);
            HashMap<String, String> transDetailMap = new HashMap<String, String>();
            if (this.checkNull(transDetailXML).length() > 0) {
                Document doc = this.genericUtility.parseString(transDetailXML);
                NodeList detailNodeList = doc.getElementsByTagName("Detail");
                Node detailNode = detailNodeList.item(0);
                NodeList detailChildList = detailNode.getChildNodes();
                int detailChildListLength = detailChildList.getLength();
                int dCtr = 0;
                while (dCtr < detailChildListLength) {
                    Node currChild = detailChildList.item(dCtr);
                    if (!currChild.getNodeName().equalsIgnoreCase("attribute")) {
                        if (currChild.getFirstChild() != null) {
                            if (currChild.getFirstChild().getNodeType() == 1) {
                                transDetailMap.put(currChild.getNodeName(), this.genericUtility.serializeDom(currChild));
                            } else {
                                transDetailMap.put(currChild.getNodeName(), currChild.getFirstChild().getNodeValue());
                            }
                        } else {
                            transDetailMap.put(currChild.getNodeName(), "");
                        }
                    }
                    ++dCtr;
                }
            }
            signTransXMLData = (String)transDetailMap.get("TRANS_INFO");
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: getWrkFlwTransXMLData: " + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "signTransXMLData - [" + signTransXMLData + "]");
        return signTransXMLData;
    }

    private String updateSignStatus(String xmlString, String actionCode, UserInfoBean userInfo, ServletContext context) throws ITMException, Exception {
        String responseStr = "";
        UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
        String tempobjName = "";
        String newEditorId = "";
        String tempAction = "";
        String tempEvent = "";
        String argsParam = "";
        String tempTranId = "";
        Date tempstartTime = null;
        try {
            String SIGN_ACTION = "1";
            String REJECT_ACTION = "2";
            String SAVE_ACTION = "3";
            String SIGN_CLOSE_ACTION = "4";
            String REVERT_ACTION = "5";
            String eventCode = "Workflow";
            if (SIGN_ACTION.equals(actionCode)) {
                eventCode = "SIGN_ACTION";
            } else if (SIGN_CLOSE_ACTION.equals(actionCode)) {
                eventCode = "SIGN_CLOSE_ACTION";
            } else if (REVERT_ACTION.equals(actionCode)) {
                eventCode = "REVERT_ACTION";
            } else if (REJECT_ACTION.equals(actionCode)) {
                eventCode = "REJECT_ACTION";
            } else if (SAVE_ACTION.equals(actionCode)) {
                eventCode = "SAVE_ACTION";
            }
            SignManagerEJB signManager = new SignManagerEJB();
            ArrayList<String> signDetailList = this.getSignDetailList(xmlString);
            String objName = this.checkNull(signDetailList.get(0));
            String refSer = this.checkNull(signDetailList.get(1));
            String refId = this.checkNull(signDetailList.get(2));
            String lineNo = this.checkNull(signDetailList.get(3));
            String userId = this.checkNull(signDetailList.get(4));
            String signRemarks = this.checkNull(signDetailList.get(5));
            String signStatus = this.checkNull(signDetailList.get(6));
            String siteCode = this.checkNull(signDetailList.get(7));
            String signReason = "";
            if (signDetailList.size() > 8) {
                signReason = this.checkNull(signDetailList.get(8));
            }
            Date startTime = new Date();
            String chgString = "";
            String signBy = "";
            if (userId.length() == 0) {
                userId = userInfo.getLoginCode();
            }
            if (siteCode.length() == 0) {
                siteCode = userInfo.getSiteCode();
            }
            if (SIGN_ACTION.equals(actionCode) || SIGN_CLOSE_ACTION.equals(actionCode) || REVERT_ACTION.equals(actionCode) || REJECT_ACTION.equals(actionCode)) {
                StringTokenizer refIdST = new StringTokenizer(refId, ",");
                StringTokenizer lineNoST = new StringTokenizer(lineNo, ",");
                TreeMap<String, String> signStatusMap = new TreeMap<String, String>();
                while (refIdST.hasMoreTokens()) {
                    String refID = refIdST.nextToken();
                    int lineNum = Integer.parseInt(lineNoST.nextToken().trim());
                    String temEditorId = "" + new Date().getTime();
                    tempobjName = objName;
                    newEditorId = temEditorId;
                    tempstartTime = startTime;
                    tempAction = eventCode;
                    tempEvent = eventCode;
                    argsParam = "";
                    tempTranId = refID;
                    userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), temEditorId, eventCode, eventCode, startTime, null, "", refID, "Pending", "WF", "");
                    responseStr = signManager.sign(lineNum, refID, refSer, objName, signStatus, userId, siteCode, signRemarks, chgString, userInfo.toString(), actionCode, signBy, signReason);
                    BaseLogger.log("3", userInfo, null, "response String1:" + responseStr);
                    String eventResult = "Success";
                    if (responseStr.indexOf("<Errors>") != -1) {
                        eventResult = "Failure";
                    }
                    if (userEventLogEJB != null && userInfo != null) {
                        userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), temEditorId, eventCode, eventCode, startTime, new Date(), "", refID, eventResult, "WF", "");
                    }
                    signStatusMap.put(String.valueOf(refSer) + "-" + refID, responseStr);
                    try {
                        if (responseStr.indexOf("<Errors>") != -1 || refID == null || refID.trim().length() <= 0) continue;
                        BaseLogger.log("3", userInfo, null, "refID - [" + refID + "]");
                        this.addFollowUpAction(userId, "", refID, objName, context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                responseStr = this.multipleSignStatus(signStatusMap);
                BaseLogger.log("3", userInfo, null, "response String2:" + responseStr);
            } else if (SAVE_ACTION.equals(actionCode)) {
                String tempEditorId = "" + new Date().getTime();
                tempobjName = objName;
                newEditorId = tempEditorId;
                tempstartTime = startTime;
                tempAction = eventCode;
                tempEvent = eventCode;
                argsParam = "";
                tempTranId = refId;
                if (userEventLogEJB != null && userInfo != null) {
                    userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, eventCode, eventCode, startTime, null, "", refId, "Pending", "WF", "");
                }
                responseStr = signManager.saveTrans(objName, refSer, refId, lineNo, chgString, userInfo.toString(), signRemarks, null);
                String eventResult = "Success";
                if (responseStr.indexOf("<Errors>") != -1) {
                    eventResult = "Failure";
                }
                if (userEventLogEJB != null && userInfo != null) {
                    userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, eventCode, eventCode, startTime, new Date(), "", refId, eventResult, "WF", "");
                }
            }
        }
        catch (Exception e) {
            if (userEventLogEJB != null && userInfo != null) {
                ITMException ie = new ITMException(e);
                userEventLogEJB.updateEventLog(userInfo.getLoginCode(), tempobjName, userInfo.getSesstionId(), newEditorId, tempAction, tempEvent, tempstartTime, new Date(), argsParam, tempTranId, "Exception", "WF", e.getMessage());
            }
            BaseLogger.log("0", userInfo, null, "Exception: updateWrkFlwStatus :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("0", userInfo, null, "response String3:" + responseStr);
        return responseStr;
    }

    private ArrayList<String> getSignDetailList(String signXMLStr) throws ITMException {
        ArrayList<String> signDetailList = new ArrayList<String>();
        try {
            String signXML = this.genericUtility.getNormalizeString(signXMLStr);
            Document signDataDom = this.genericUtility.parseString(signXML);
            NodeList detailNodeList = signDataDom.getElementsByTagName("Detail");
            Node detailNode = detailNodeList.item(0);
            NodeList detailChildList = detailNode.getChildNodes();
            int dCtr = 0;
            while (dCtr < detailChildList.getLength()) {
                Node currChild = detailChildList.item(dCtr);
                if (!currChild.getNodeName().equalsIgnoreCase("attribute")) {
                    if (currChild.getFirstChild() != null) {
                        signDetailList.add(currChild.getFirstChild().getNodeValue());
                    } else {
                        signDetailList.add("");
                    }
                }
                ++dCtr;
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :getSignDetailList :==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :getSignDetailList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "signDetailList : " + signDetailList);
        return signDetailList;
    }

    private String multipleSignStatus(TreeMap<String, String> signStatusMap) throws RemoteException, ITMException {
        StringBuffer responseString = new StringBuffer();
        try {
            String str = "";
            BaseLogger.log("3", null, null, "multipleSignStatus: signStatusMap - [" + signStatusMap + "]");
            responseString.append("<?xml version='1.0'?><Root>");
            for (String refSerRefID : signStatusMap.keySet()) {
                responseString.append("<Detail id=\"" + refSerRefID + "\">");
                str = signStatusMap.get(refSerRefID).toString();
                str = str.substring(str.indexOf(">") + 1, str.length());
                responseString.append(str);
                responseString.append("</Detail>");
            }
            responseString.append("</Root>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: multipleSignStatus:==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "multipleSignStatus - [" + responseString.toString() + "]");
        return responseString.toString();
    }

    private String getUserImage(HttpServletResponse response, UserInfoBean userInfoObj) {
        String result = "";
        try {
            String userId = "";
            if (this.getUserInfo() != null) {
                userId = this.checkNull(this.getUserInfo().getLoginCode());
            }
            if (userId.equals("") && userInfoObj != null) {
                userId = userInfoObj.getLoginCode();
            }
            if (userId.length() > 0) {
                String fileName = String.valueOf(userId) + ".png";
                BaseLogger.log("3", null, null, "Got to get user Image fileName=" + fileName);
                String profileImagesPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "resource" + File.separator + "images" + File.separator + "users" + File.separator + fileName;
                BaseLogger.log("3", null, null, "Got file path to get user Image=" + profileImagesPath);
                File dir = new File(profileImagesPath);
                if (dir.exists()) {
                    ServletOutputStream outputStream = response.getOutputStream();
                    FileInputStream fis = new FileInputStream(profileImagesPath);
                    byte[] buffer = new byte[(int)dir.length()];
                    int length = 0;
                    while ((length = fis.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, length);
                    }
                    fis.close();
                    outputStream.flush();
                    result = "success";
                    response.setContentType("image/png");
                    response.setBufferSize(buffer.length);
                } else {
                    result = "User Image not found.";
                }
            } else {
                result = "Invalid User.";
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = "Exception : " + e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = "Exception : " + e.getMessage();
        }
        return result;
    }

    private String getAttachDocument(String refId, String refSer, String docType, HttpServletResponse response) {
        String result = "";
        try {
            String resultXML = "";
            DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
            resultXML = refId != null && refId.indexOf(",") != -1 ? docHandler.getMultiDocumentInfoList(refSer, refId, "", this.userInfo.getTransDB()) : docHandler.getDocumentInfoList(refSer, refId, "", this.userInfo.getTransDB());
            HashMap<String, String> docIdMap = this.getDocumentIds(resultXML, docType);
            if (docIdMap.size() > 0) {
                byte[] byteArray = null;
                int count = 0;
                for (Map.Entry<String, String> docIdEntry : docIdMap.entrySet()) {
                    String docId = this.checkNull(docIdEntry.getKey());
                    String fileName = this.checkNull(docIdEntry.getValue());
                    String fileType = "";
                    if (fileName.length() > 0) {
                        fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    }
                    BaseLogger.log("3", null, null, "docId - [" + docId + "], fileName - [" + fileName + "], fileType - [" + fileType + "]");
                    if (count == 0) {
                        byteArray = docHandler.getDocument(docId, this.userInfo);
                        this.setContentType(fileName, fileType, response);
                        ServletOutputStream outputStream = response.getOutputStream();
                        outputStream.write(byteArray);
                        outputStream.flush();
                        outputStream.close();
                        break;
                    }
                    ++count;
                }
                response.setBufferSize(byteArray.length);
                result = "success";
            } else {
                result = "No Document attached.";
            }
        }
        catch (ITMException e) {
            e.printStackTrace();
            result = "Exception : " + e.getMessage();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            result = "Exception : " + e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = "Exception : " + e.getMessage();
        }
        return result;
    }

    private void setContentType(String fileName, String fileType, HttpServletResponse response) {
        try {
            response.setHeader("Content-disposition", "filename = \"" + fileName + "\"");
            if (fileType.equalsIgnoreCase("pdf")) {
                response.setContentType("application/pdf; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("bmp")) {
                response.setContentType("image/bmp");
            } else if (fileType.equalsIgnoreCase("txt") || fileType.equalsIgnoreCase("dtd") || fileType.equalsIgnoreCase("java")) {
                response.setContentType("text/plain; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("html") || fileType.equalsIgnoreCase("htm")) {
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("doc") || fileType.equalsIgnoreCase("odt")) {
                response.setContentType("application/msword; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("xls")) {
                response.setContentType("application/msexcel; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("gif")) {
                response.setContentType("image/gif");
            } else if (fileType.equalsIgnoreCase("ai")) {
                response.setContentType("application/postscript; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("abs")) {
                response.setContentType("audio/x-mpeg");
            } else if (fileType.equalsIgnoreCase("bin") || fileType.equalsIgnoreCase("exe")) {
                response.setContentType("application/octet-stream; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("class")) {
                response.setContentType("application/java; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("jpe") || fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("jpeg")) {
                response.setContentType("image/jpeg");
            } else if (fileType.equalsIgnoreCase("mpg") || fileType.equalsIgnoreCase("mpeg")) {
                response.setContentType("video/mpeg");
            } else if (fileType.equalsIgnoreCase("pic") || fileType.equalsIgnoreCase("pict") || fileType.equalsIgnoreCase("pict")) {
                response.setContentType("image/pict");
            } else if (fileType.equalsIgnoreCase("aif") || fileType.equalsIgnoreCase("aifc") || fileType.equalsIgnoreCase("aiff")) {
                response.setContentType("audio/x-aiff");
            } else if (fileType.equalsIgnoreCase("aim")) {
                response.setContentType("application/x-aim");
            } else if (fileType.equalsIgnoreCase("art")) {
                response.setContentType("image/x-jg");
            } else if (fileType.equalsIgnoreCase("asf") || fileType.equalsIgnoreCase("asx")) {
                response.setContentType("video/x-ms-asf");
            } else if (fileType.equalsIgnoreCase("avi")) {
                response.setContentType("video/x-msvideo");
            } else if (fileType.equalsIgnoreCase("avx")) {
                response.setContentType("video/x-rad-screenplay");
            } else if (fileType.equalsIgnoreCase("body")) {
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("css")) {
                response.setContentType("text/css; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("dib")) {
                response.setContentType("image/bmp");
            } else if (fileType.equalsIgnoreCase("gz")) {
                response.setContentType("application/x-gzip");
            } else if (fileType.equalsIgnoreCase("jar")) {
                response.setContentType("application/java-archive");
            } else if (fileType.equalsIgnoreCase("js")) {
                response.setContentType("text/javascript; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("midi")) {
                response.setContentType("audio/x-midi");
            } else if (fileType.equalsIgnoreCase("rtf")) {
                response.setContentType("application/rtf");
            } else if (fileType.equalsIgnoreCase("rtx")) {
                response.setContentType("text/richtext; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("tif") || fileType.equalsIgnoreCase("tiff")) {
                response.setContentType("image/tiff");
            } else if (fileType.equalsIgnoreCase("xml") || fileType.equalsIgnoreCase("xsl")) {
                response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            } else if (fileType.equalsIgnoreCase("ppt")) {
                response.setContentType("application/powerpoint");
            } else if (fileType.equalsIgnoreCase("ppm")) {
                response.setContentType("image/x-portable-pixmap");
            } else if (fileType.equalsIgnoreCase("png")) {
                response.setContentType("image/png");
            } else if (fileType.equalsIgnoreCase("oda")) {
                response.setContentType("application/oda");
            } else if (fileType.equalsIgnoreCase("zip")) {
                response.setContentType("application/zip");
            } else {
                response.setContentType("application/octet-stream; charset=" + CommonConstants.ENCODING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> getDocumentIds(String xmlStr, String docType) throws ITMException {
        LinkedHashMap<String, String> docIdMap = new LinkedHashMap<String, String>();
        try {
            Node childNode = null;
            Node node = null;
            NodeList childList = null;
            docType = this.checkNull(docType);
            if (this.checkNull(xmlStr).length() > 0) {
                Document dom = this.genericUtility.parseString(xmlStr);
                NodeList nodeList = dom.getElementsByTagName("ID");
                int cnt = 0;
                while (cnt < nodeList.getLength()) {
                    String docId = "";
                    node = nodeList.item(cnt);
                    if (node.hasAttributes()) {
                        docId = node.getAttributes().getNamedItem("Document_Id").getNodeValue();
                    }
                    childList = node.getChildNodes();
                    String attachDocType = "";
                    String docName = "";
                    int cnt1 = 0;
                    while (cnt1 < childList.getLength()) {
                        childNode = childList.item(cnt1);
                        if (childNode.getNodeName().equalsIgnoreCase("docTypeAttach")) {
                            attachDocType = this.checkNull(childNode.getNodeValue());
                            if (childNode.getFirstChild() != null) {
                                attachDocType = this.checkNull(childNode.getFirstChild().getNodeValue());
                            }
                        } else if (childNode.getNodeName().equalsIgnoreCase("Name")) {
                            docName = this.checkNull(childNode.getNodeValue());
                            if (childNode.getFirstChild() != null) {
                                docName = this.checkNull(childNode.getFirstChild().getNodeValue());
                            }
                        }
                        ++cnt1;
                    }
                    BaseLogger.log("3", null, null, "attachDocType - [" + attachDocType + "], docId - [" + docId + "], docName - [" + docName + "]");
                    if (docType.length() > 0) {
                        if (attachDocType.length() > 0 && attachDocType.equals(docType)) {
                            docIdMap.put(docId, docName);
                        }
                    } else {
                        docIdMap.put(docId, docName);
                    }
                    ++cnt;
                }
            }
            BaseLogger.log("3", null, null, "docIdMap - " + docIdMap);
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        return docIdMap;
    }

    private String uploadDocument(HttpServletRequest request) throws ITMException {
        String retString = "";
        try {
            String retXMLStr = "";
            byte[] byteArray = new byte[1];
            byte[] videoFrameBytes = new byte[1];
            int MEMORY_THRESHOLD = 0x300000;
            int MAX_FILE_SIZE = 0x2800000;
            int MAX_REQUEST_SIZE = 0x3200000;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(MEMORY_THRESHOLD);
            factory.setRepository(new File(System.getProperty("java.io.tmpdir")));
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax((long)MAX_FILE_SIZE);
            upload.setSizeMax((long)MAX_REQUEST_SIZE);
            List formItems = upload.parseRequest(request);
            if (formItems != null && formItems.size() > 0) {
                String fieldName = "";
                for (FileItem item : formItems) {
                    fieldName = item.getFieldName();
                    BaseLogger.log("3", null, null, "fieldName : [" + fieldName + "]");
                    if (item.isFormField()) {
                        String fieldValue = item.getString();
                        BaseLogger.log("3", null, null, "fieldValue : [" + fieldValue + "]");
                        if ("UPLOAD_XML_STR".equalsIgnoreCase(fieldName)) {
                            retXMLStr = fieldValue;
                            continue;
                        }
                        if (!"USER_INFO".equalsIgnoreCase(fieldName) || fieldValue == null) continue;
                        this.userInfo = new UserInfoBean(fieldValue);
                        continue;
                    }
                    if (item.isFormField()) continue;
                    String fileName = new File(item.getName()).getName();
                    BaseLogger.log("3", null, null, "fileName : [" + fileName + "]");
                    if ("fileBytes".equalsIgnoreCase(fieldName)) {
                        byteArray = item.get();
                        BaseLogger.log("3", null, null, "byteArray : [" + byteArray + "]");
                        continue;
                    }
                    if (!"videoFrameBytes".equalsIgnoreCase(fieldName)) continue;
                    videoFrameBytes = item.get();
                    BaseLogger.log("3", null, null, "videoFrameBytes : [" + videoFrameBytes + "]");
                }
            }
            DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
            retString = docHandler.addDocument(retXMLStr, byteArray, videoFrameBytes, this.getUserInfo());
            docHandler = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: uploadDocument : [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return retString;
    }

    private String getAttachmentDetailStr(String objName, String refSer, String refId, String filePath, File file, UserInfoBean userinfobean) {
        StringBuffer retXMLStringBuff = new StringBuffer();
        try {
            String fileName = file.getName();
            String fileType = filePath.substring(filePath.lastIndexOf(".") + 1);
            retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
            retXMLStringBuff.append("<DocumentRoot>");
            retXMLStringBuff.append("<description>Datawindow Root</description>");
            retXMLStringBuff.append("<group0>");
            retXMLStringBuff.append("<description>Group0 description</description>");
            retXMLStringBuff.append("<Header0>");
            retXMLStringBuff.append("<description>Header0 members</description>");
            retXMLStringBuff.append("<header>");
            retXMLStringBuff.append("<ref_id><![CDATA[").append(refId).append("]]></ref_id>");
            retXMLStringBuff.append("<ref_col><![CDATA[").append(" ").append("]]></ref_col>");
            retXMLStringBuff.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
            retXMLStringBuff.append("<ref_ser><![CDATA[").append(refSer).append("]]></ref_ser>");
            retXMLStringBuff.append("<doc_name><![CDATA[").append(fileName).append("]]></doc_name>");
            retXMLStringBuff.append("<doc_type><![CDATA[").append(fileType).append("]]></doc_type>");
            retXMLStringBuff.append("<created_by><![CDATA[").append(userinfobean.getLoginCode()).append("]]></created_by>");
            retXMLStringBuff.append("</header>");
            retXMLStringBuff.append("</Header0>");
            retXMLStringBuff.append("</group0>");
            retXMLStringBuff.append("</DocumentRoot>");
            BaseLogger.log("3", this.userInfo, null, "getAttachmentDetailStr [" + retXMLStringBuff + "]");
            return retXMLStringBuff.toString();
        }
        catch (Exception e) {
            retXMLStringBuff.delete(0, retXMLStringBuff.length());
            retXMLStringBuff.append("[getAttachmentDetailStr] Exception :: " + e.getMessage());
            e.printStackTrace();
            BaseLogger.log("0", null, null, "[getAttachmentDetailStr] Exception :: " + e.getMessage());
            return retXMLStringBuff.toString();
        }
    }

    private void sendWebSocketNotification(String xmlString, String docAttachType, ArrayList<String> userIdList, String fileName, CommonConstants.WebSocketMessageType type) {
        try {
            xmlString = this.checkNull(xmlString);
            docAttachType = this.checkNull(docAttachType);
            fileName = this.checkNull(fileName);
            if (userIdList != null && userIdList.size() > 0 && xmlString.length() > 0) {
                String wsMessageStr = String.valueOf(xmlString) + " ~ " + fileName + " ~ " + docAttachType;
                JSONObject wsMessage = new JSONObject();
                JSONArray userIds = new JSONArray(userIdList);
                wsMessage.put("user_ids", (Object)userIds);
                JSONObject webSocketMsgWithType = new JSONObject();
                webSocketMsgWithType.put("type", (Object)String.valueOf((Object)type));
                webSocketMsgWithType.put("data", (Object)wsMessageStr);
                wsMessage.put("message", (Object)webSocketMsgWithType);
                ClientWebsocketNotification clientWebsocketNotification = new ClientWebsocketNotification();
                clientWebsocketNotification.sendMessage(wsMessage);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[sendWebSocketNotification] Exception :: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean getAuthenticationStatus(String xmlInfo) throws BaseException {
        boolean flag = false;
        try {
            Document document = this.genericUtility.parseString(xmlInfo);
            if (document.getElementsByTagName("STATUS").item(0) != null && document.getElementsByTagName("STATUS").item(0).getFirstChild() != null) {
                flag = Boolean.valueOf(document.getElementsByTagName("STATUS").item(0).getFirstChild().getNodeValue());
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException: getAuthenticationStatus: " + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: getAuthenticationStatus: " + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "Authentication Status :[" + flag + "]");
        return flag;
    }

    private String validateRequest(HttpServletRequest request, String dataFormat) {
        String validStr = "valid";
        try {
            if (!this.isValidDataFormat(dataFormat)) {
                validStr = "Please enter valid Data Format.";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : validateRequest : " + e.getMessage());
            validStr = this.getStackTrace(e);
        }
        return validStr;
    }

    private String decrypt(String CIPHER_TEXT) {
        String IV = "07000000000000000000000000000008";
        String SALT = "07000000000000000000000000000008";
        int KEY_SIZE = 128;
        int ITERATION_COUNT = 10000;
        String PASSPHRASE = "sunpharmametis";
        String decrypt = this.decrypt(SALT, IV, PASSPHRASE, CIPHER_TEXT, ITERATION_COUNT, KEY_SIZE);
        return decrypt;
    }

    private String decrypt(String salt, String iv, String passphrase, String ciphertext, int iterationCount, int keySize) {
        try {
            SecretKey key = this.generateKey(salt, passphrase, iterationCount, keySize);
            byte[] decrypted = this.doFinal(2, key, iv, E12ExtServiceUtility.base64(ciphertext));
            return new String(decrypted, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw this.fail(e);
        }
    }

    private SecretKey generateKey(String salt, String passphrase, int iterationCount, int keySize) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), E12ExtServiceUtility.hex(salt), iterationCount, keySize);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] base64(String str) {
        return DatatypeConverter.parseBase64Binary((String)str);
    }

    public static String hex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public static byte[] hex(String str) {
        return DatatypeConverter.parseHexBinary((String)str);
    }

    private IllegalStateException fail(Exception e) {
        return new IllegalStateException(e);
    }

    private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(encryptMode, (Key)key, new IvParameterSpec(E12ExtServiceUtility.hex(iv)));
            return cipher.doFinal(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.fail(e);
        }
    }

    private int validateRequest(String usrLicType, String enterprise) throws ITMException {
        int licUsrsCnt = 0;
        Statement pstmt = null;
        Connection conn = null;
        ConnDriver conDriver = null;
        ResultSet rs = null;
        try {
            try {
                conDriver = new ConnDriver();
                conn = conDriver.getConnectDB("Driver");
                String sql = "SELECT LIC_USERS FROM ENTP_USERS_LICENCE WHERE TRIM(ENTERPRISE)=? AND USER_LIC_TYPE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, enterprise);
                pstmt.setString(2, usrLicType);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    licUsrsCnt = rs.getInt(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                conn.close();
                conn = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException ::E12ExtService :validateRequest :==>[" + itme.getMessage() + "]");
                throw itme;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", null, null, "SQLException ::E12ExtService :validateRequest:==>[" + ie.getMessage() + "]");
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception ::E12ExtService :validateRequest:==>[" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return licUsrsCnt;
    }

    private String createHashCode(String data) throws UnsupportedEncodingException, ITMException {
        String encData = this.encrypt(data);
        BaseLogger.log("2", null, null, "encoded[" + encData + "]");
        return encData;
    }

    private String encrypt(String as_passwd) {
        BaseLogger.log("2", null, null, "E12ExtService..................encrypt...............");
        String ls_return = "";
        try {
            BaseLogger.log("3", null, null, "Encrypting Password.....");
            int li_len = as_passwd.length();
            int li_count = 0;
            while (li_count < li_len) {
                Random li_Seed_r = new Random();
                int li_Seed = li_Seed_r.nextInt(10);
                int li_passAsc = as_passwd.charAt(li_count);
                li_passAsc = li_passAsc + li_Seed + li_count;
                ls_return = String.valueOf(ls_return) + (char)li_passAsc + (char)(li_Seed + li_count);
                ++li_count;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: E12ExtService: encrypt:==>\n" + e.getMessage());
        }
        BaseLogger.log("2", null, null, "E12ExtService..................encrypt.......[" + ls_return + "]....");
        return ls_return;
    }

    private Object getReportArgStr(String reportFileName, String attachType, String xsdString, UserInfoBean userInfo) throws ITMException, JSONException {
        JSONObject repArgJson = new JSONObject();
        StringBuffer reportArgString = new StringBuffer();
        String respArgString = "";
        String status = "";
        try {
            reportArgString.append("<Arguments>");
            if (xsdString != null && xsdString.length() > 0) {
                HashMap<String, String> userInfoMap = this.getUserInfoMapJasper(userInfo);
                Document doc = this.genericUtility.parseString(xsdString);
                NodeList argNodeList = doc.getElementsByTagName("argument");
                if (argNodeList != null) {
                    int argCnt = 0;
                    while (argCnt <= argNodeList.getLength()) {
                        Node argNode = argNodeList.item(argCnt);
                        if (argNode != null) {
                            String argName = "";
                            String argType = "";
                            String argValue = "";
                            Node attribute = null;
                            attribute = argNode.getAttributes().getNamedItem("name");
                            if (attribute != null && attribute.getFirstChild() != null) {
                                argName = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("type")) != null && attribute.getFirstChild() != null) {
                                argType = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("value")) != null && attribute.getFirstChild() != null) {
                                argValue = attribute.getFirstChild().getNodeValue();
                            }
                            if (userInfoMap != null && userInfoMap.containsKey(argValue.toLowerCase())) {
                                argValue = userInfoMap.get(argValue.toLowerCase());
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            } else if ("report_save_type".equalsIgnoreCase(argName)) {
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + attachType.toUpperCase() + "</value></Argument>");
                            } else {
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            }
                        }
                        ++argCnt;
                    }
                }
            }
            reportArgString.append("</Arguments>");
            respArgString = reportArgString.toString();
            BaseLogger.log("3", userInfo, null, "In genReportArgStr : [" + respArgString + "]");
            status = "Success";
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :: genReportArgStr : [" + e.getMessage() + "]");
            respArgString = this.getStackTrace(e);
            status = "Exception";
        }
        repArgJson.put("response", (Object)respArgString);
        repArgJson.put("status", (Object)status);
        return repArgJson;
    }

    private Object createSession(String userCode, String password, String isPwdEncrypt, HttpServletRequest request) throws JSONException {
        JSONObject respJson = new JSONObject();
        userCode = this.checkNull(userCode);
        password = this.checkNull(password);
        String result = "";
        String status = "";
        try {
            isPwdEncrypt = this.checkNull(isPwdEncrypt).length() > 0 ? this.checkNull(isPwdEncrypt) : "false";
            String isValidLogin = "false";
            if (userCode.length() > 0) {
                isValidLogin = this.getAuthStatus(request, userCode, password, "", "I", isPwdEncrypt);
                if ("VALID".equalsIgnoreCase(isValidLogin)) {
                    request.getSession().setAttribute("USER_INFO", (Object)this.getUserInfo());
                    result = "true";
                    status = "Success";
                } else {
                    result = isValidLogin;
                    status = "error";
                }
            } else {
                result = "Please enter username.";
                status = "error";
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: @createSession [" + e.getMessage() + "]");
            result = this.getStackTrace(e);
            status = "Exception";
        }
        respJson.put("status", (Object)status);
        respJson.put("result", (Object)result);
        return respJson;
    }

    private HashMap<String, String> getUserInfoMapJasper(UserInfoBean userInfo) throws ITMException {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            if (userInfo != null) {
                String user = userInfo.getLoginCode();
                String entityCode = userInfo.getEntityCode();
                String profileId = userInfo.getProfileId();
                String empCode = userInfo.getEmpCode();
                String reportTo = userInfo.getReportTo();
                String deptCode = userInfo.getDeptCode();
                String userLev = userInfo.getUserLevel();
                String userType = userInfo.getUserType();
                String loginSite = userInfo.getSiteCode();
                if (entityCode == null) {
                    entityCode = "";
                }
                if (user == null) {
                    user = "";
                }
                userInfoMap.put("login_site", loginSite);
                userInfoMap.put("login_code", user);
                userInfoMap.put("entity_code", entityCode);
                userInfoMap.put("profile_id", profileId);
                userInfoMap.put("report_to", reportTo);
                userInfoMap.put("dept_code", deptCode);
                userInfoMap.put("user_lev", userLev);
                userInfoMap.put("user_type", userType);
                userInfoMap.put("emp_code", empCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return userInfoMap;
    }

    private Object getReportResp(String retString, String objName, String userCode, String reportargStr, String status, HttpServletRequest request, HttpServletResponse response) throws ITMException, JSONException {
        JSONObject reportResp = new JSONObject();
        try {
            String path = CommonConstants.TOMCAT_HOME;
            if (request.getSession().getAttribute("USER_INFO") != null) {
                this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                userCode = this.userInfo.getLoginCode();
            }
            String attachType = "PDF";
            double dummyInt = Math.random();
            String profileId = this.userInfo.getProfileId();
            String isExplore = "Yes";
            String browserType = "IE";
            attachType = URLEncoder.encode(attachType, CommonConstants.ENCODING);
            profileId = URLEncoder.encode(profileId, CommonConstants.ENCODING);
            reportargStr = URLEncoder.encode(reportargStr, CommonConstants.ENCODING);
            String urlStr = String.valueOf(path) + "/ibase/WebITMRequestHandlerServlet?ACTION=VIEW_REPORT" + "&OBJ_NAME=" + objName + "&PROFILEID=" + profileId + "&ARGUMENTXML=" + reportargStr + "&report_save_type=" + attachType + "&USER_CODE=" + userCode + "&ISExplore=" + isExplore + "&BROWSER_TYPE=" + browserType + "&dummyInt=" + dummyInt;
            String response_ = "";
            E12GenericUtility genericUtility = new E12GenericUtility();
            FileInputStream fileInput = null;
            response_ = this.makeRequest(urlStr, "", this.userInfo.getSesstionId());
            if (response_.indexOf("<Errors>") == -1 && response_.indexOf(String.valueOf(File.separator) + "ibase") != -1) {
                response_ = response_.substring(6, response_.length());
                String fileName = response_.substring(response_.lastIndexOf(File.separator) + 1);
                String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                String filepath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + response_;
                fileInput = new FileInputStream(filepath);
                if ("SEND_MAIL".equalsIgnoreCase(retString)) {
                    retString = filepath;
                    System.out.println("SEND_MAIL retString :[" + retString + "]");
                } else {
                    this.setContentType(fileName, fileType, response);
                    ServletOutputStream outputStream = response.getOutputStream();
                    IOUtils.copy((InputStream)fileInput, (OutputStream)outputStream);
                    outputStream.flush();
                    outputStream.close();
                }
                status = "Success";
            } else if (response_.indexOf("<Errors>") == -1 && response_.indexOf(String.valueOf(File.separator) + "ibase") == -1) {
                retString = "No data found.";
                status = "success";
            } else if (response_.indexOf("<Errors>") != -1) {
                retString = genericUtility.getErrorMsgDescr(response_);
                status = "error";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", this.userInfo, null, "getReportResp IOException - 1734 [" + e.getMessage() + "]");
            retString = this.getStackTrace(e);
            status = "exception";
        }
        reportResp.put("result", (Object)retString);
        reportResp.put("status", (Object)status);
        return reportResp;
    }

    public String makeRequest(String urlStr, String xmlString, String sessionId) {
        String response;
        block6: {
            response = "";
            URL url = null;
            HttpURLConnection conn = null;
            StringBuffer responseBuff = new StringBuffer();
            try {
                try {
                    url = new URL(urlStr);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, CommonConstants.ENCODING));
                    BaseLogger.log("3", this.userInfo, null, "URL: [" + url + "]");
                    DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                    wr.writeBytes(xmlString);
                    wr.flush();
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((response = br.readLine()) != null) {
                        responseBuff.append(response);
                    }
                    response = responseBuff.toString();
                }
                catch (Exception e) {
                    BaseLogger.log("0", this.userInfo, null, "RequestHandlerServlet makeRequest Exception 1710- [" + e.getMessage() + "]");
                    conn.disconnect();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                conn.disconnect();
                throw throwable;
            }
            conn.disconnect();
        }
        BaseLogger.log("0", this.userInfo, null, "Final response retString: " + response);
        return response;
    }

    private void sendMail(UserInfoBean userInfo, String retString, String mailFormatCode) {
        Connection userConn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String to = "";
        String cc = "";
        String sub = "";
        String emailID = "";
        String message = "";
        try {
            try {
                EMail emailObj = new EMail();
                StringBuffer mailInfoXml = new StringBuffer();
                ConnDriver connDriver = new ConnDriver();
                userConn = userInfo != null ? connDriver.getConnectDB(userInfo.getTransDB()) : connDriver.getConnectDB("Driver");
                String userSql = "SELECT SEND_TO,COPY_TO,BLIND_COPY,SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = ? ";
                pstmt = userConn.prepareStatement(userSql);
                pstmt.setString(1, mailFormatCode);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    to = rs.getString("SEND_TO");
                    cc = rs.getString("COPY_TO");
                    sub = rs.getString("SUBJECT");
                    message = rs.getString("BODY_TEXT");
                }
                emailID = "user_id__attend".equalsIgnoreCase(to) ? userInfo.getLoginEmailId() : to;
                System.out.println("E12ExtService.sendMail() : emailID " + emailID);
                pstmt.close();
                rs.close();
                userConn.close();
                mailInfoXml.append("<ROOT>");
                mailInfoXml.append("<MESSAGE_TYPE><![CDATA[text/html]]></MESSAGE_TYPE>");
                mailInfoXml.append("<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>");
                mailInfoXml.append("<TO_ADD><![CDATA[" + emailID + "]]></TO_ADD>");
                mailInfoXml.append("<CC_ADD><![CDATA[" + cc + "]]></CC_ADD>");
                mailInfoXml.append("<SUBJECT><![CDATA[" + sub + "]]></SUBJECT>");
                mailInfoXml.append("<BODY_TEXT><![CDATA[" + message + "]]></BODY_TEXT>");
                mailInfoXml.append("<XML_DATA_FILE_PATH><![CDATA[" + retString + "]]></XML_DATA_FILE_PATH>");
                mailInfoXml.append("</ROOT>");
                emailObj.sendMail(mailInfoXml.toString(), "ITM", userInfo);
            }
            catch (Exception e) {
                System.out.println("exception" + e);
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (userConn != null) {
                        userConn.close();
                        userConn = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (userConn != null) {
                    userConn.close();
                    userConn = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    private Object getReportArgStr(String reportFileName, String attachType, String xsdString, UserInfoBean userInfo, JSONObject argValues) throws ITMException, JSONException {
        JSONObject repArgJson = new JSONObject();
        StringBuffer reportArgString = new StringBuffer();
        String respArgString = "";
        String status = "";
        try {
            reportArgString.append("<Arguments>");
            if (xsdString != null && xsdString.length() > 0) {
                HashMap<String, String> userInfoMap = this.getUserInfoMapJasper(userInfo);
                Document doc = this.genericUtility.parseString(xsdString);
                NodeList argNodeList = doc.getElementsByTagName("argument");
                if (argNodeList != null) {
                    int argCnt = 0;
                    while (argCnt <= argNodeList.getLength()) {
                        Node argNode = argNodeList.item(argCnt);
                        if (argNode != null) {
                            String argName = "";
                            String argType = "";
                            String argValue = "";
                            Node attribute = null;
                            attribute = argNode.getAttributes().getNamedItem("name");
                            if (attribute != null && attribute.getFirstChild() != null) {
                                argName = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("type")) != null && attribute.getFirstChild() != null) {
                                argType = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("value")) != null && attribute.getFirstChild() != null) {
                                argValue = attribute.getFirstChild().getNodeValue();
                            }
                            if (userInfoMap != null && userInfoMap.containsKey(argValue.toLowerCase())) {
                                argValue = userInfoMap.get(argValue.toLowerCase());
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            } else {
                                if ("report_save_type".equalsIgnoreCase(argName)) {
                                    argValue = attachType.toUpperCase();
                                } else if (argValues != null && argValues.has(argName)) {
                                    argValue = argValues.optString(argName);
                                }
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            }
                        }
                        ++argCnt;
                    }
                }
            }
            reportArgString.append("</Arguments>");
            respArgString = reportArgString.toString();
            BaseLogger.log("3", userInfo, null, "In genReportArgStr : [" + respArgString + "]");
            status = "Success";
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :: genReportArgStr : [" + e.getMessage() + "]");
            respArgString = this.getStackTrace(e);
            status = "Exception";
        }
        repArgJson.put("response", (Object)respArgString);
        repArgJson.put("status", (Object)status);
        return repArgJson;
    }

    public void writeAPICallLog(String endpointName, String status, String result, String appId, HttpServletRequest request, UserInfoBean userInfo) {
        status = this.checkNull(status);
        appId = this.checkNull(appId);
        result = this.checkNull(result);
        BaseLogger.log("3", userInfo, null, "Inside E12ExtServiceUtility :: writeAPICallLog : []");
        StringBuffer responseInfo = new StringBuffer("");
        responseInfo.append("1)" + endpointName + " called.");
        responseInfo.append("\n2) Status: " + status + " Result: " + result);
        String callStatus = "";
        callStatus = status.equalsIgnoreCase("error") || status.equalsIgnoreCase("Reject") || status.equalsIgnoreCase("exception") ? "F" : "Y";
        APIUtility APIUtility2 = new APIUtility();
        try {
            APIUtility2.writeApiCallLog(userInfo, responseInfo, callStatus, appId, request.getRemoteAddr());
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
    }

    public boolean validateToken(HttpServletRequest request, String tokenId, boolean toValidateSession, String appId) {
        boolean isValid = false;
        String result = "valid";
        if (toValidateSession && !this.validateUserSession(request, tokenId)) {
            result = "You are not authorized to access.";
        }
        this.userInfo = this.getUserInfo();
        BaseLogger.log("3", null, null, "result from  validateToken VisionEDIUtility: [" + result + "]");
        if (!result.equalsIgnoreCase("valid")) {
            isValid = this.validateLLT(tokenId);
            BaseLogger.log("3", null, null, "isValid from  validateToken VisionEDIUtility: [" + isValid + "]");
        } else {
            isValid = true;
        }
        return isValid;
    }

    private boolean validateLLT(String tokenId) {
        String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";
        boolean isValidUser = false;
        String result = "";
        result = this.validateJWT(tokenId, "", sharedKey);
        if (result.equalsIgnoreCase("valid")) {
            isValidUser = true;
            HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenId, sharedKey);
            this.userInfo = this.createUserInfo(jwtData);
        }
        return isValidUser;
    }

    private Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isJSONValid(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response getApplList(HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo = null;
        APIUtility apiUtility = new APIUtility();
        RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
        String tokenId = "";
        String result = "";
        String status = "error";
        try {
            String appId;
            block34: {
                tokenId = this.getTokenFromHeaders(header);
                BaseLogger.log("3", null, null, "getApplList() got tokenId==>" + tokenId);
                if (tokenId == null || tokenId.length() <= 0) {
                    status = "Reject";
                    result = "Unauthorised Access.";
                    return Response.status((int)401).entity((Object)result).build();
                }
                appId = apiUtility.getAppIdFromJWTToken(tokenId);
                BaseLogger.log("3", null, null, "getApplList() got App_id==>" + appId);
                if (appId == null || appId.length() <= 0) {
                    status = "Reject";
                    result = "Unauthorised Access.";
                    return Response.status((int)401).entity((Object)result).build();
                }
                if (!appId.equals("FLUTTERAPP")) {
                    BaseLogger.log("3", null, null, "getDataModels() validating APPID ExtAuthAppAPIBean==>");
                    ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("appllist", appId);
                    if (authAppAPIBean == null) {
                        status = "Reject";
                        result = "This service not available for this APPID";
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
                    }
                    result = this.validateRequest(request, "JSON", tokenId, true, appId, "appllist");
                    BaseLogger.log("3", null, null, "getAppllist() Validate request result==>" + result);
                    if (!"valid".equalsIgnoreCase(result)) {
                        return Response.status((int)401).entity((Object)result).build();
                    }
                }
                if ((userInfo = apiUtility.createUserInfoFromJWTToken(tokenId)) == null) {
                    status = "Reject";
                    result = "User Not Allowed";
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
                }
                if (apiUtility.checkDailyAPILimit(userInfo)) {
                    status = "Reject";
                    result = "Daily API call limit exceeded";
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
                }
                JSONArray groupArray = new JSONArray();
                JSONObject appObj = new JSONObject();
                Throwable throwable = null;
                Object var13_15 = null;
                try {
                    Connection userConn = new ConnDriver().getConnectDB(userInfo.getTransDB());
                    try {
                        try (PreparedStatement preparedStatement = userConn.prepareStatement("SELECT DISTINCT APPL_GROUP, APPL_GRP_DESCR, APPL_GROUP_COLOR FROM appl_mst");){
                            Throwable throwable2 = null;
                            Object var17_22 = null;
                            try (ResultSet resultSet = preparedStatement.executeQuery();){
                                while (true) {
                                    if (!resultSet.next()) break;
                                    BaseLogger.log("3", null, null, "Value of APPL_GROUP= " + resultSet.getString("APPL_GROUP"));
                                    String applGroup = this.checkNull(resultSet.getString("APPL_GROUP"));
                                    String applGroupDescr = this.checkNull(resultSet.getString("APPL_GRP_DESCR"));
                                    String applGroupColor = this.checkNull(resultSet.getString("APPL_GROUP_COLOR"));
                                    JSONObject groupObject = new JSONObject();
                                    groupObject.put("group_id", (Object)applGroup);
                                    groupObject.put("group_descr", (Object)applGroupDescr);
                                    groupObject.put("group_color", (Object)applGroupColor);
                                    groupArray.put((Object)groupObject);
                                    BaseLogger.log("3", null, null, "Value of applGroup= " + applGroup);
                                    BaseLogger.log("3", null, null, "Value of applGroupDescr= " + applGroupDescr);
                                    BaseLogger.log("3", null, null, "Value of applGroupColor= " + applGroupColor);
                                }
                                BaseLogger.log("3", null, null, "Value of Group Array= " + groupArray.toString());
                                ResultSet resultSet2 = null;
                                PreparedStatement preparedStatement2 = null;
                                JSONArray applArray = new JSONArray();
                                int i = 0;
                                block15: while (true) {
                                    if (i >= groupArray.length()) {
                                        resultSet2 = null;
                                        preparedStatement2 = null;
                                        BaseLogger.log("3", null, null, "Value of applArray= " + applArray.toString());
                                        JSONObject groupObj = new JSONObject();
                                        groupObj.put("appl_group", (Object)applArray);
                                        appObj.put("applications", (Object)groupObj);
                                        BaseLogger.log("3", null, null, "Value of applications= " + appObj.toString());
                                        status = "Success";
                                        result = appObj.toString();
                                        break;
                                    }
                                    JSONObject groupObj = groupArray.getJSONObject(i);
                                    String applGroup = groupObj.getString("group_id");
                                    String query = "SELECT APP_NAME,APPL_COLOR,DESCR,APPL_ORDER,APPL_TYPE,SEARCH_DOMAIN FROM appl_mst WHERE APPL_GROUP=?";
                                    preparedStatement2 = userConn.prepareStatement(query);
                                    preparedStatement2.setString(1, applGroup);
                                    resultSet2 = preparedStatement2.executeQuery();
                                    JSONObject applObj = new JSONObject();
                                    applObj.put("group_id", groupObj.get("group_id"));
                                    applObj.put("group_descr", groupObj.get("group_descr"));
                                    applObj.put("group_color", groupObj.get("group_color"));
                                    JSONArray appList = new JSONArray();
                                    BaseLogger.log("3", null, null, "Getting App values ");
                                    while (true) {
                                        if (!resultSet2.next()) {
                                            applObj.put("appl", (Object)appList);
                                            applArray.put((Object)applObj);
                                            ++i;
                                            continue block15;
                                        }
                                        JSONObject app = new JSONObject();
                                        app.put("app_id", (Object)this.checkNull(resultSet2.getString("APP_NAME")));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("app_id"));
                                        app.put("appl_color", (Object)this.checkNull(resultSet2.getString("APPL_COLOR")));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("appl_color"));
                                        app.put("appl_descr", (Object)this.checkNull(resultSet2.getString("DESCR")));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("appl_descr"));
                                        app.put("appl_order", resultSet2.getInt("APPL_ORDER"));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("appl_order"));
                                        app.put("appl_type", (Object)this.checkNull(resultSet2.getString("APPL_TYPE")));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("appl_type"));
                                        app.put("appl_search_domain", (Object)this.checkNull(resultSet2.getString("SEARCH_DOMAIN")));
                                        BaseLogger.log("3", null, null, "Value of appl= " + app.get("appl_search_domain"));
                                        appList.put((Object)app);
                                    }
                                    break;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                        }
                        if (userConn == null) break block34;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (userConn == null) throw throwable;
                        userConn.close();
                        throw throwable;
                    }
                    userConn.close();
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            this.writeAPICallLog("getReport ( /appllist )", status, result, appId, request, userInfo);
            return Response.status((int)200).entity((Object)result).build();
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Erro in getApplList " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    public UserInfoBean getUserInfoFromRequest(HttpServletRequest request) {
        UserInfoBean userInfo = null;
        String userInfoStr = "";
        try {
            HttpSession session = request.getSession();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            return userInfo;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error in getting User info from Request [" + e.getMessage() + "]");
            return null;
        }
    }

    public UserInfoBean getUserInfo(HttpServletRequest request, String tokenId) {
        UserInfoBean userInfo = null;
        String userInfoStr = "";
        try {
            HttpSession session = request.getSession();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            if (userInfo == null) {
                APIUtility apiUtility = new APIUtility();
                userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
            }
            return userInfo;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error in getting User info from Request [" + e.getMessage() + "]");
            return null;
        }
    }
}

