/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.BckgrndProcessLocal;
import ibase.webitm.ejb.BckgrndProcessRemote;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.EventManagerLocal;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import oracle.sql.BLOB;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Stateless
public class BckgrndProcessEJB
implements BckgrndProcessRemote,
BckgrndProcessLocal {
    private EventManagerLocal eventManager = null;
    private DBAccessLocal dbAccess = null;
    transient InitialContext initialContext = null;
    String objName = null;
    @Resource
    private SessionContext cSessionContext;

    public BckgrndProcessEJB() {
        BaseLogger.log("1", null, null, " **************     BckgrndProcessEJB ::     ******************** ");
        try {
            this.setInitialContext();
            BaseLogger.log("1", null, null, "BckgrndProcessEJB Created...");
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void ejbCreate() {
        BaseLogger.log("2", null, null, " **************     BckgrndProcessEJB ::     ******************** ");
        try {
            this.setInitialContext();
            BaseLogger.log("3", null, null, "BckgrndProcessEJB Created...");
            EventManagerEJB eventManager = new EventManagerEJB();
            DBAccessEJB dbAccess = new DBAccessEJB();
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            eventManager = null;
            Object var2_3 = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
        try {
            this.setInitialContext();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :ejbActivate :==>\n" + e);
        }
    }

    public void ejbPassivate() {
    }

    private void setInitialContext() throws ITMException {
        try {
            AppConnectParm appConnect = new AppConnectParm();
            this.initialContext = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private boolean updateBlob(Connection con, String query, String dataStr, ArrayList bindVarValues, ArrayList bindVarTypes) throws RemoteException, ITMException {
        PreparedStatement pStmt = null;
        boolean updStatus = false;
        try {
            try {
                pStmt = con.prepareStatement(query);
                int ctr = 0;
                while (ctr < bindVarValues.size()) {
                    if (((String)bindVarTypes.get(ctr)).indexOf("String") != -1) {
                        pStmt.setString(ctr + 1, (String)bindVarValues.get(ctr));
                    } else if (((String)bindVarTypes.get(ctr)).indexOf("Int") != -1) {
                        pStmt.setInt(ctr + 1, Integer.parseInt((String)bindVarValues.get(ctr)));
                    }
                    ++ctr;
                }
                ResultSet rs111 = pStmt.executeQuery();
                if (rs111.next()) {
                    Blob mapBlob = rs111.getBlob(1);
                    OutputStream blobOutputStream = ((BLOB)mapBlob).getBinaryOutputStream();
                    byte[] dataByteArray = null;
                    if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);
                        dataByteArray = dataStr.getBytes();
                    } else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1) {
                        dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);
                        dataByteArray = dataStr.getBytes();
                    } else {
                        dataByteArray = dataStr.getBytes();
                    }
                    blobOutputStream.write(dataByteArray);
                    blobOutputStream.close();
                    updStatus = true;
                }
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e) {
                System.err.println("Exception : updateBlob :==>finally\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return updStatus;
    }

    private String getUniqueKey(String objName, String dataDom, Connection con) throws ITMException {
        String uniqueKey = null;
        Statement stmt = null;
        ResultSet rSet = null;
        try {
            try {
                String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + objName + "' ";
                BaseLogger.log("3", null, null, "  keyStringQuery :: " + keyStringQuery);
                stmt = con.createStatement();
                rSet = stmt.executeQuery(keyStringQuery);
                String tranSer = null;
                String keyString = null;
                String keyCol = null;
                if (rSet.next()) {
                    keyString = rSet.getString("KEY_STRING");
                    keyCol = rSet.getString("TRAN_ID_COL");
                    tranSer = rSet.getString("REF_SER");
                }
                BaseLogger.log("3", null, null, " \n keyString [" + keyString + " ]\n keyCol [" + keyCol + "] \ntranSer [" + tranSer + " ]");
                BaseLogger.log("3", null, null, "\n dataDom [" + dataDom + "] \n database [ " + CommonConstants.DB_NAME + "]");
                TransIDGenerator tg = new TransIDGenerator(dataDom, "SYSTEM", CommonConstants.DB_NAME);
                uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, con);
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :getUniqueKey :==>\n" + itme);
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :getUniqueKey :==>\n" + e);
                uniqueKey = null;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                    rSet = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :BckgrndProcessEJB :getUniqueKey :finally==>");
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "Generated Primary Key :" + uniqueKey);
        return uniqueKey;
    }

    private String getQueueNumber(String userId, String siteCode, Connection connObj) throws ITMException {
        ResultSet rs = null;
        Statement st = null;
        String queueId = "0";
        int queueLen = Integer.parseInt(CommonConstants.QUEUE_ID);
        String qry = "SELECT FN_RGRT_BJQID ('" + userId + "'," + Integer.parseInt(CommonConstants.QUEUE_ID) + ",'" + siteCode + "') FROM DUAL";
        BaseLogger.log("3", null, null, "Executing function query :[" + qry + "]");
        try {
            try {
                st = connObj.createStatement();
                rs = st.executeQuery(qry);
                if (rs.next()) {
                    queueId = this.checkNull(rs.getString(1)).trim();
                    BaseLogger.log("3", null, null, "Returned value from function :[" + queueId + "]");
                }
                BaseLogger.log("3", null, null, "Finally queueId [" + queueId + "]");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                    st = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, " Exception :BckgrndProcessEJB :getQueueNumber :finally >>>>>>  " + e);
                throw new ITMException(e);
            }
        }
        return queueId;
    }

    @Override
    public boolean checkProcessInBG(String objName, String execType, String siteCode, UserInfoBean userInfo) throws ITMException {
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rs = null;
        boolean flag = false;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                String query = "";
                if ("E".equals(execType)) {
                    query = "SELECT OBJ_NAME, JOB_STAT, LOGIN_SITE FROM BACKGROUND_JOB WHERE OBJ_NAME = '" + objName + "' AND JOB_STAT = 'P'";
                } else if ("S".equals(execType)) {
                    query = "SELECT OBJ_NAME, JOB_STAT, LOGIN_SITE FROM BACKGROUND_JOB WHERE OBJ_NAME = '" + objName + "' AND JOB_STAT = 'P' AND LOGIN_SITE = '" + siteCode + "'";
                }
                if (query.length() > 0 && (rs = (pStmt = conn.prepareStatement(query)).executeQuery()).next()) {
                    flag = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, " Exception ::  " + e.getMessage());
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", userInfo, null, " Exception ::  " + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, " Exception ::  " + e.getMessage());
            }
        }
        return flag;
    }

    @Override
    public String saveBckgrndProcessData(String isBckgrndProcess, String objName, String objType, String action, String detailDomString, String transDomString, String reqNameValStr, String loginCode, String siteCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        return this.saveBckgrndProcessData(isBckgrndProcess, objName, objType, action, detailDomString, transDomString, reqNameValStr, loginCode, siteCode, "", userInfo);
    }

    public String saveBckgrndProcessData(String isBckgrndProcess, String objName, String objType, String action, String detailDomString, String transDomString, String reqNameValStr, String loginCode, String siteCode, String jobType, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection connObj = null;
        Object jobMap = null;
        boolean isPresent = false;
        String jobId = "";
        String msg = null;
        boolean updStatus = false;
        Object param1Bolb = null;
        Object param2Bolb = null;
        ITMDBAccessEJB itmDBAccess = null;
        PreparedStatement pStmt = null;
        try {
            String transDB = userInfo.getTransDB();
            ConnDriver connDriver = new ConnDriver();
            connObj = connDriver.getConnectDB(transDB);
            connObj.setAutoCommit(false);
            String createDate = "";
            String jobStat = "";
            String execDate = "";
            String execReslt = "";
            String execTrace = "";
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            itmDBAccess = new ITMDBAccessEJB();
            jobStat = "P";
            jobId = this.getUniqueKey("background_job", detailDomString, connObj);
            BaseLogger.log("3", userInfo, null, " objName Generated ID === " + jobId);
            String queueId = this.getQueueNumber(loginCode, siteCode, connObj);
            String sql = "INSERT INTO BACKGROUND_JOB ( JOB_ID, CREATED_DATE, OBJ_NAME, OBJ_TYPE, OBJ_PARAM1, OBJ_PARAM2, JOB_STAT, USER_ID, EXEC_DATE, EXEC_RESULT, EXECP_TRACE ,QUEUE_ID, LOGIN_SITE,JOB_TYPE) VALUES (?, ?, ?, ?, EMPTY_BLOB(), EMPTY_BLOB(), ?,?,?,?,?,?,?,?)";
            pStmt = connObj.prepareStatement(sql);
            pStmt.setString(1, String.valueOf(jobId));
            pStmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pStmt.setString(3, String.valueOf(objName));
            pStmt.setString(4, String.valueOf(objType));
            pStmt.setString(5, String.valueOf(jobStat));
            pStmt.setString(6, String.valueOf(loginCode));
            pStmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            pStmt.setString(8, String.valueOf(execReslt));
            pStmt.setString(9, String.valueOf(execTrace));
            pStmt.setString(10, String.valueOf(queueId));
            pStmt.setString(11, String.valueOf(siteCode));
            pStmt.setString(12, jobType);
            pStmt.executeUpdate();
            pStmt.close();
            pStmt = null;
            ArrayList<String> bindVarValues = new ArrayList<String>();
            bindVarValues.add(jobId);
            bindVarValues.add(objName);
            ArrayList<String> bindVarTypes = new ArrayList<String>();
            bindVarTypes.add("String");
            bindVarTypes.add("String");
            String query = "SELECT OBJ_PARAM1 FROM BACKGROUND_JOB WHERE JOB_ID=? AND OBJ_NAME=? FOR UPDATE NOWAIT ";
            updStatus = this.updateBlob(connObj, query, detailDomString, bindVarValues, bindVarTypes);
            BaseLogger.log("3", userInfo, null, "\n\n updStatus :: " + updStatus);
            query = "SELECT OBJ_PARAM2 FROM BACKGROUND_JOB WHERE JOB_ID=? AND OBJ_NAME=? FOR UPDATE NOWAIT";
            updStatus = this.updateBlob(connObj, query, transDomString, bindVarValues, bindVarTypes);
            BaseLogger.log("3", userInfo, null, "\n\n updStatus :: " + updStatus);
            connObj.commit();
            connObj.close();
            StringBuffer sbfmsg = new StringBuffer();
            String tempmsg = "";
            if (updStatus) {
                tempmsg = itmDBAccess.getErrorString("", "PROCESRGD", "", userInfo);
                BaseLogger.log("3", userInfo, null, "Message String ::" + tempmsg);
                if (tempmsg != null && tempmsg.trim().length() > 0 && tempmsg.toUpperCase().indexOf("REGISTERED") != -1) {
                    sbfmsg = sbfmsg.append(String.valueOf(tempmsg.substring(0, tempmsg.toUpperCase().indexOf("REGISTERED"))) + " [" + jobId + "] ");
                    sbfmsg = sbfmsg.append(tempmsg.substring(tempmsg.toUpperCase().indexOf("REGISTERED")));
                    msg = sbfmsg.toString();
                } else {
                    StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><Errors>");
                    retStrBuff.append("<error id='PROCESRGD' type='E' column_name=''>");
                    retStrBuff.append("<message><![CDATA[Transaction [" + jobId + "] Successfully Registered.]]></message>");
                    retStrBuff.append("<description><![CDATA[ Transaction Registered ]]></description>");
                    retStrBuff.append("<trace><![CDATA[]]></trace>");
                    retStrBuff.append("<redirect>1</redirect></error></Errors>");
                    msg = retStrBuff.toString();
                }
            } else {
                msg = itmDBAccess.getErrorString("", "PROCESFLD", "", userInfo);
                if (msg == null || msg.trim().length() == 0) {
                    StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><Errors>");
                    retStrBuff.append("<error id='' type='' column_name=''>");
                    retStrBuff.append("<message><![CDATA[Transaction [" + jobId + "] Failed to Registered.]]></message>");
                    retStrBuff.append("<description><![CDATA[ Transaction Failed ]]></description>");
                    retStrBuff.append("<trace><![CDATA[]]></trace>");
                    retStrBuff.append("<redirect>1</redirect></error></Errors>");
                    msg = retStrBuff.toString();
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, " Exception When accessing dataBase ::" + e);
            e.printStackTrace();
            msg = itmDBAccess.getErrorString("", "PROCESFLD", "", userInfo);
            if (msg == null || msg.trim().length() == 0) {
                StringBuffer retStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><Errors>");
                retStrBuff.append("<error id='' type='' column_name=''>");
                retStrBuff.append("<message><![CDATA[Transaction [" + jobId + "] Failed to Registered.]]></message>");
                retStrBuff.append("<description><![CDATA[ Transaction Failed ]]></description>");
                retStrBuff.append("<trace><![CDATA[]]></trace>");
                retStrBuff.append("<redirect>1</redirect></error></Errors>");
                msg = retStrBuff.toString();
            }
            return msg;
        }
        BaseLogger.log("2", userInfo, null, "Message String ::" + msg);
        return msg;
    }

    public void updateBackgroundJob(String jobId, HashMap<String, String> updatedColmnWithValMap, String objName, String userId, UserInfoBean userInfo) {
        block18: {
            try {
                BaseLogger.log("3", userInfo, null, "jobId::[ " + jobId + " ]=> objName::[ " + objName + " ]=> userId::[ " + userId + " ]");
                jobId = this.checkNull(jobId);
                objName = this.checkNull(objName);
                userId = this.checkNull(userId);
                if (jobId.length() <= 0 || objName.length() <= 0 || userId.length() <= 0) break block18;
                Connection conn = null;
                Statement pstmt = null;
                String transDB = null;
                try {
                    try {
                        transDB = userInfo.getTransDB();
                        BaseLogger.log("3", null, null, "TransDB::[ " + transDB + " ]");
                        if (transDB == null) {
                            transDB = "Driver";
                        }
                        ConnDriver connDriver = new ConnDriver();
                        conn = connDriver.getConnectDB(transDB);
                        this.updateExecuteDate(conn, jobId.trim());
                        BaseLogger.log("3", userInfo, null, "Updating background job of Report.............");
                        String getUpdatedColmWithVal = this.getSetColumnsWithVal(updatedColmnWithValMap);
                        String condition = "WHERE JOB_ID='" + jobId + "' AND OBJ_NAME='" + objName + "' AND USER_ID='" + userId + "'";
                        StringBuffer sql = new StringBuffer("UPDATE BACKGROUND_JOB SET");
                        sql.append(" ").append(getUpdatedColmWithVal).append(" ").append(condition);
                        pstmt = conn.prepareStatement(sql.toString());
                        pstmt.executeUpdate();
                        conn.commit();
                    }
                    catch (SQLException ae) {
                        ae.printStackTrace();
                        BaseLogger.log("0", null, null, "SQLException in updateBackgroundJob[1]:: " + ae.getMessage());
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                                pstmt = null;
                            }
                            if (conn != null) {
                                conn.close();
                                conn = null;
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            BaseLogger.log("0", null, null, "SQLException in updateBackgroundJob[2]:: " + e.getMessage());
                        }
                    }
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        BaseLogger.log("0", null, null, "SQLException in updateBackgroundJob[2]:: " + e.getMessage());
                    }
                }
            }
            catch (Exception ae) {
                ae.printStackTrace();
                BaseLogger.log("0", null, null, "Exception in updateBackgroundJob:: " + ae.getMessage());
            }
        }
    }

    public void updateExecuteDate(Connection conn, String jobId) {
        String sql = "";
        PreparedStatement pstmt = null;
        try {
            BaseLogger.log("2", null, null, "updating ExecuteDate>>>>>>");
            sql = "UPDATE BACKGROUND_JOB SET EXEC_DATE = ? WHERE JOB_ID='" + jobId + "'";
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            int i = pstmt.executeUpdate();
            if (i > 0) {
                BaseLogger.log("2", null, null, "Updated ExecuteDate Successfully.");
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSetColumnsWithVal(HashMap<String, String> updatedColmnWithValMap) {
        String result = "";
        String temp = "";
        try {
            HashMap<String, String> hm = updatedColmnWithValMap;
            for (Map.Entry<String, String> m : hm.entrySet()) {
                temp = m.getKey() + " = '" + m.getValue() + "'";
                if (result.length() == 0) {
                    result = temp;
                    continue;
                }
                if (result.length() <= 0) continue;
                result = String.valueOf(result) + " , " + temp;
            }
        }
        catch (Exception ae) {
            ae.printStackTrace();
        }
        return result;
    }

    public String getJobIdFromXML(String xmlData) {
        String jobId = "";
        String messageString = "";
        try {
            BaseLogger.log("9", null, null, "XML Data is::[ " + xmlData + " ]");
            Document dom = new E12GenericUtility().parseString(xmlData);
            dom.getDocumentElement().normalize();
            if (dom.getElementsByTagName("message").item(0) != null) {
                Node msg = dom.getElementsByTagName("message").item(0);
                messageString = msg.getFirstChild().getNodeValue();
            }
            jobId = messageString.substring(messageString.indexOf("[") + 1, messageString.indexOf("]"));
        }
        catch (Exception ae) {
            BaseLogger.log("0", null, null, "Exception in alertMessageByParisng:: " + ae.getMessage());
            ae.printStackTrace();
        }
        BaseLogger.log("2", null, null, "jobId is:: [ " + jobId + " ]");
        return jobId;
    }

    public String getAllBckgrndJobStatus(UserInfoBean userInfo, String createdDate) throws RemoteException, ITMException {
        try {
            return this.getAllBckgrndJobStatus(userInfo, createdDate, null, null);
        }
        catch (Exception ae) {
            ae.printStackTrace();
            return null;
        }
    }

    public String getAllBckgrndJobStatus(UserInfoBean userInfo, String createdDate, String callFrom) throws RemoteException, ITMException {
        return this.getAllBckgrndJobStatus(userInfo, createdDate, null, null, null, null, callFrom);
    }

    public String getAllBckgrndJobStatus(UserInfoBean userInfo, String createdDate, String jobID, Connection conn) throws RemoteException, ITMException {
        return this.getAllBckgrndJobStatus(userInfo, createdDate, jobID, conn, null, null, null);
    }

    public String getAllBckgrndJobStatus(UserInfoBean userInfo, String createdDate, String jobID, Connection conn, String outputFormat, String objName, String action) throws RemoteException, ITMException {
        boolean isLocalConn = false;
        Statement pstmt = null;
        ResultSet rs = null;
        String jobId = "";
        String jobStat = "";
        String jobTitle = "";
        String dateStrt = "";
        String dateStop = "";
        String loadDate = "";
        String retResult = "";
        String loadStatus = "";
        String startedDate = "";
        String differnceRes = "";
        String objDescr = "";
        int errorRec = 0;
        int totalRec = 0;
        int processed = 0;
        int successRec = 0;
        int unProcessed = 0;
        int exceptionRec = 0;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String transDB = userInfo.getTransDB();
                String currDate = "";
                String nextDate = "";
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                    Calendar calendar = Calendar.getInstance();
                    Date date = null;
                    date = createdDate != null && !"".equalsIgnoreCase(createdDate) ? sdf.parse(createdDate) : calendar.getTime();
                    calendar.setTime(date);
                    calendar.add(5, 1);
                    Date nextDay = calendar.getTime();
                    currDate = sdf.format(date);
                    currDate = genericUtility.getValidDateString(currDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
                    nextDate = sdf.format(nextDay);
                    nextDate = genericUtility.getValidDateString(nextDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
                }
                catch (Exception e) {
                    BaseLogger.log("3", userInfo, null, "Exception While Parsing..........1300" + e.getMessage());
                }
                BaseLogger.log("3", userInfo, null, "currDate : [" + currDate + "], nextDate : [" + nextDate + "]");
                if (conn == null) {
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    isLocalConn = true;
                }
                JSONObject resultJson = new JSONObject();
                JSONArray resultJsonArr = new JSONArray();
                String sql = this.getsql(currDate, nextDate, jobID, action, objName, userInfo, createdDate);
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    JSONObject tempJson = new JSONObject();
                    jobTitle = this.checkNull(rs.getString(1));
                    objName = this.checkNull(rs.getString(2));
                    jobId = this.checkNull(rs.getString(3));
                    jobStat = this.checkNull(rs.getString(4));
                    totalRec = rs.getInt(5);
                    successRec = rs.getInt(6);
                    errorRec = rs.getInt(7);
                    unProcessed = rs.getInt(8);
                    exceptionRec = rs.getInt(9);
                    dateStrt = rs.getString(10);
                    dateStop = rs.getString(11);
                    objDescr = rs.getString(12);
                    processed = successRec + errorRec + exceptionRec;
                    float percentage = processed * 100 / totalRec;
                    BaseLogger.log("3", userInfo, null, "jobStat:: [ " + jobStat + " ]:::jobId::[ " + jobId + " ]::percentage::[ " + percentage + " ]");
                    if (dateStrt.length() > 0 && dateStop.length() > 0) {
                        differnceRes = this.getDurationByCompareDates(dateStrt, dateStop);
                    }
                    if (exceptionRec > 0) {
                        errorRec = exceptionRec;
                    }
                    if ((loadDate = this.checkNull(dateStrt)).length() > 0) {
                        Date ldDate = new SimpleDateFormat(genericUtility.getDBDateTimeFormat()).parse(loadDate);
                        startedDate = new SimpleDateFormat("dd MMM YYYY").format(ldDate);
                        BaseLogger.log("3", userInfo, null, "startedDate::[ " + startedDate + " ]");
                    }
                    tempJson.put("jobId", (Object)jobId.trim());
                    tempJson.put("objName", (Object)objName.trim());
                    tempJson.put("totalRec", totalRec);
                    tempJson.put("successRec", successRec);
                    tempJson.put("errorRec", errorRec);
                    tempJson.put("unProcessed", (Object)("" + unProcessed));
                    tempJson.put("processed", processed);
                    tempJson.put("progress", (Object)(String.valueOf(processed) + " / " + totalRec));
                    tempJson.put("percentage", percentage);
                    tempJson.put("loadStatus", (Object)loadStatus);
                    tempJson.put("jobTitle", (Object)jobTitle);
                    tempJson.put("jobStat", (Object)jobStat);
                    tempJson.put("startedDate", (Object)startedDate);
                    tempJson.put("takenTime", (Object)differnceRes);
                    tempJson.put("objDescr", (Object)objDescr);
                    resultJson.put(jobId, (Object)tempJson);
                    resultJsonArr.put((Object)tempJson);
                }
                retResult = "Array".equals(outputFormat) ? resultJsonArr.toString() : resultJson.toString();
                BaseLogger.log("3", userInfo, null, "retResult ---[" + retResult + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getallUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null && isLocalConn) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && isLocalConn) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
        return retResult;
    }

    public String getDurationByCompareDates(String dateStrt, String dateStop) {
        String durationRes = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
            Date d1 = sdf.parse(dateStrt);
            Date d2 = sdf.parse(dateStop);
            long diff = d2.getTime() - d1.getTime();
            long diffsecs = diff / 1000L % 60L;
            long diffmins = diff / 60000L % 60L;
            long diffhrs = diff / 3600000L % 24L;
            long diffDays = diff / 86400000L;
            if (diffDays > 0L) {
                durationRes = String.valueOf(diffDays).concat(" days");
                if (diffhrs > 0L) {
                    durationRes = String.valueOf(diffDays).concat(" days, ").concat(String.valueOf(diffhrs)).concat(" hrs");
                }
                if (diffmins > 0L) {
                    durationRes = String.valueOf(diffDays).concat(" days, ").concat(String.valueOf(diffhrs)).concat(" hrs, ").concat(String.valueOf(diffmins)).concat(" mins");
                }
                if (diffsecs > 0L) {
                    durationRes = String.valueOf(diffDays).concat(" days, ").concat(String.valueOf(diffhrs)).concat(" hrs, ").concat(String.valueOf(diffmins)).concat(" mins, ").concat(String.valueOf(diffsecs)).concat(" secs");
                }
                return durationRes;
            }
            if (diffhrs > 0L) {
                durationRes = String.valueOf(diffhrs).concat(" hrs");
                if (diffmins > 0L) {
                    durationRes = String.valueOf(diffhrs).concat(" hrs, ").concat(String.valueOf(diffmins)).concat(" mins");
                }
                if (diffsecs > 0L) {
                    durationRes = String.valueOf(diffhrs).concat(" hrs, ").concat(String.valueOf(diffmins)).concat(" mins, ").concat(String.valueOf(diffsecs)).concat(" secs");
                }
                return durationRes;
            }
            if (diffmins > 0L) {
                durationRes = String.valueOf(diffmins).concat(" mins");
                if (diffsecs > 0L) {
                    durationRes = String.valueOf(diffmins).concat(" mins, ").concat(String.valueOf(diffsecs)).concat("secs");
                }
                return durationRes;
            }
            durationRes = String.valueOf(diffsecs).concat(" secs");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "durationRes::[ " + durationRes + " ]");
        return durationRes;
    }

    public String getBckgrndJobStatus(String jobId, UserInfoBean userInfo, Connection conn) {
        String bckgrndStatusRes = "";
        try {
            BaseLogger.log("3", userInfo, null, "getBckgrndJobStatus called...[ " + jobId + " ]");
            boolean isExistInBatchID = this.isExistInBatchID(conn, jobId, userInfo.getTransDB());
            BaseLogger.log("3", userInfo, null, "isExistInBatchID::[ " + isExistInBatchID + " ]");
            if (isExistInBatchID) {
                UploadFileEJB uploadFile = new UploadFileEJB();
                bckgrndStatusRes = uploadFile.getUploadStatusData(jobId, userInfo, conn);
            } else {
                bckgrndStatusRes = this.getBackgrndJobStatus(jobId, userInfo, conn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bckgrndStatusRes;
    }

    private boolean isExistInBatchID(Connection conn, String batchId, String transDB) {
        boolean isExist = false;
        boolean isLocalConn = false;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (conn == null) {
                BaseLogger.log("3", null, null, "Connnection is null..");
                ConnDriver connDriver = new ConnDriver();
                transDB = this.checkNull(transDB);
                BaseLogger.log("3", null, null, "transDB::[ " + transDB + " ]");
                if (transDB.length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                    isLocalConn = true;
                }
            }
            BaseLogger.log("3", null, null, "isExistInBatchID***batchId::[ " + batchId + " ]");
            String sql = "";
            if (!"".equalsIgnoreCase(this.checkNull(this.objName))) {
                if (!this.objName.startsWith("w_")) {
                    this.objName = "w_" + this.objName;
                }
                sql = "SELECT BATCH_ID FROM BATCHLOAD WHERE BATCH_ID='" + batchId + "' AND WIN_NAME='" + this.objName + "' ";
            } else {
                sql = "SELECT BATCH_ID FROM BATCHLOAD WHERE BATCH_ID='" + batchId + "'";
            }
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            BaseLogger.log("3", null, null, "sql:: " + sql);
            if (rs.next()) {
                BaseLogger.log("3", null, null, "Batch id::[ " + rs.getString(1) + " ]");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && isLocalConn) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("3", null, null, "isExist::[ " + isExist + " ]");
        return isExist;
    }

    public String getBackgrndJobStatus(String jobId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Statement pstmt = null;
        ResultSet rs = null;
        StringBuffer result = new StringBuffer();
        String retResult = "";
        String objName = "";
        String winName = "";
        String loadDate = "";
        String errorMsg = "";
        String loadStatus = "";
        int queueId = 0;
        int totalRec = 0;
        int errorRec = 0;
        int processed = 0;
        int successRec = 0;
        int unProcessed = 0;
        int exceptionRec = 0;
        int count = 0;
        try {
            try {
                BaseLogger.log("3", userInfo, null, "jobId " + jobId);
                SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
                HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
                if (conn == null) {
                    String transDB = userInfo.getTransDB();
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                }
                String sql = "SELECT OBJ_NAME, QUEUE_ID, CREATED_DATE, JOB_STAT, JOB_ID,  CASE WHEN JOB_STAT IN('I','C') THEN 'Successfully Sent.' ELSE REMARKS END REMARKS  FROM BACKGROUND_JOB  WHERE JOB_ID = ?  AND JOB_STAT in ('X','E','I','P','C')  ORDER BY TO_NUMBER(QUEUE_ID)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, jobId);
                rs = pstmt.executeQuery();
                result.append("<ROOT>");
                while (rs.next()) {
                    ++totalRec;
                    ++count;
                    winName = this.checkNull(rs.getString(1));
                    if (winName.indexOf("w_") != -1) {
                        if (winName.length() > 2) {
                            objName = winName.substring(2);
                        }
                    } else {
                        objName = winName;
                    }
                    queueId = rs.getInt(2);
                    BaseLogger.log("3", userInfo, null, "queueId.................." + queueId);
                    if (queueId <= 0) {
                        queueId = count;
                    }
                    loadDate = rs.getTimestamp(3) != null ? sdfdate.format(rs.getTimestamp(3)) : "";
                    loadStatus = rs.getString(4);
                    jobId = rs.getString(5);
                    errorMsg = rs.getString(6);
                    if ("P".equalsIgnoreCase(loadStatus)) {
                        errorMsg = "Downloading not started.";
                    }
                    result.append("<DETAIL>");
                    result.append("<JOB_ID><![CDATA[").append(this.checkNull(jobId.trim())).append("]]></JOB_ID>");
                    result.append("<OBJ_NAME><![CDATA[").append(this.checkNull(objName)).append("]]></OBJ_NAME>");
                    result.append("<TRAN_ID_REF><![CDATA[").append(count).append("]]></TRAN_ID_REF>");
                    result.append("<TRAN_SL><![CDATA[").append(queueId).append("]]></TRAN_SL>");
                    result.append("<LOAD_DATE><![CDATA[").append(this.checkNull(loadDate)).append("]]></LOAD_DATE>");
                    result.append("<LOAD_STAT><![CDATA[").append(loadStatus).append("]]></LOAD_STAT>");
                    result.append("<ERROR_MSG><![CDATA[").append(this.checkNull(errorMsg)).append("]]></ERROR_MSG>");
                    result.append("</DETAIL>");
                    if ("P".equalsIgnoreCase(loadStatus)) {
                        ++unProcessed;
                    } else if ("I".equalsIgnoreCase(loadStatus) || "C".equalsIgnoreCase(loadStatus)) {
                        ++successRec;
                    } else if ("E".equalsIgnoreCase(loadStatus)) {
                        ++errorRec;
                    } else if ("X".equalsIgnoreCase(loadStatus)) {
                        ++exceptionRec;
                    }
                    processed = successRec + errorRec + exceptionRec;
                }
                result.append("</ROOT>");
                HashMap metadataMap = new HashMap();
                int percentage = processed * 100 / totalRec;
                metadataMap.put("jobId", jobId.trim());
                metadataMap.put("objName", objName);
                metadataMap.put("totalRec", "" + totalRec);
                metadataMap.put("successRec", "" + successRec);
                metadataMap.put("errorRec", "" + errorRec);
                metadataMap.put("exceptionRec", "" + exceptionRec);
                metadataMap.put("unProcessed", "" + unProcessed);
                metadataMap.put("processed", "" + processed);
                metadataMap.put("progress", String.valueOf(processed) + " / " + totalRec);
                metadataMap.put("percentage", "" + percentage);
                metadataMap.put("response", "" + result);
                BaseLogger.log("3", userInfo, null, "successRec - [" + successRec + "], errorRec - [" + errorRec + "], exceptionRec - [" + exceptionRec + "]");
                BaseLogger.log("3", userInfo, null, "processed - [" + processed + "]");
                dataMap.put(jobId, metadataMap);
                JSONObject resultJson = new JSONObject();
                for (Map.Entry entry : dataMap.entrySet()) {
                    String mapBatchId = (String)entry.getKey();
                    metadataMap = (HashMap)entry.getValue();
                    if (metadataMap == null) continue;
                    JSONObject metadataJson = new JSONObject();
                    for (Map.Entry entry1 : metadataMap.entrySet()) {
                        metadataJson.put((String)entry1.getKey(), entry1.getValue());
                    }
                    resultJson.put(mapBatchId, (Object)metadataJson);
                }
                retResult = resultJson.toString();
            }
            catch (Exception e) {
                BaseLogger.log("3", userInfo, null, "Exception on getBackgrndJobStatus----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
        return retResult;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getsql(String currDate, String nextDate, String jobID, String action, String objName, UserInfoBean userInfo, String createdDate) {
        StringBuffer sql = new StringBuffer();
        BaseLogger.log("3", userInfo, null, "in getsql From:" + action);
        if ("fromExcel".equalsIgnoreCase(action)) {
            try {
                sql.append("SELECT (CASE WHEN OBJ_TYPE = 'P' THEN 'Process' WHEN OBJ_TYPE = 'R' THEN 'Report' WHEN OBJ_TYPE = 'O' THEN 'Export Zip' ELSE 'Other' END) AS TITLE , ");
                sql.append("OBJ_NAME AS WIN_NAME, JOB_ID, JOB_STAT, ");
                sql.append("1 AS TOTAL_CNT, ");
                sql.append("(CASE WHEN JOB_STAT IN('I','C') THEN 1 ELSE 0 END) AS SUCC_CNT, ");
                sql.append("(CASE WHEN JOB_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT, ");
                sql.append("0 AS PEND_CNT, ");
                sql.append("(CASE WHEN JOB_STAT = 'X' THEN 1 ELSE 0 END) AS EXCPTION_CNT, ");
                sql.append("CREATED_DATE AS DATE_START, ");
                sql.append("EXEC_DATE AS DATE_END, ");
                sql.append("(SELECT DESCR FROM ITM2MENU WHERE ITM2MENU.WIN_NAME = CONCAT('w_', OBJ_NAME ) And ROWNUM = 1) AS OBJ_DESCR ");
                sql.append("FROM BACKGROUND_JOB ");
                sql.append("WHERE JOB_STAT  IN ('I','E','X','P','C') ");
                if (!"".equalsIgnoreCase(objName)) {
                    sql.append(" AND OBJ_NAME = '" + objName + "'");
                }
                if (!"".equalsIgnoreCase(currDate) && !"".equalsIgnoreCase(nextDate)) {
                    sql.append(" AND CREATED_DATE  between TO_DATE('" + currDate + "', 'dd-MON-yyyy') AND TO_DATE('" + nextDate + "', 'dd-MON-yyyy') ");
                }
                sql.append(" AND JOB_TYPE = 'E' ");
                sql.append(" AND USER_ID = '" + userInfo.getLoginCode() + "' ");
                if (this.checkNull(jobID).length() > 0) {
                    sql.append("AND JOB_ID = '" + jobID + "' ");
                }
                sql.append("ORDER BY CREATED_DATE DESC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("fromUpload".equalsIgnoreCase(action)) {
            try {
                sql.append("SELECT BJOB.* ");
                sql.append("FROM ( ");
                sql.append("SELECT 'Excel' AS TITLE, B.WIN_NAME, B.BATCH_ID AS JOB_ID, ' ' AS JOB_STAT, ");
                sql.append("COUNT(B.BATCH_ID) AS TOTAL_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'Y' THEN 1 ELSE 0 END) AS SUCC_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'N' THEN 1 ELSE 0 END) AS PEND_CNT, ");
                sql.append("0 AS EXCPTION_CNT, ");
                sql.append("(CASE WHEN MIN(B.LOAD_DATE) IS NULL THEN MIN(B.CHG_DATE) ELSE MIN(B.LOAD_DATE) END) AS DATE_START,");
                sql.append("(CASE WHEN MAX(B.LOAD_DATE) IS NULL THEN MAX(B.CHG_DATE) ELSE MAX(B.LOAD_DATE) END) AS DATE_END, ");
                sql.append("(SELECT DESCR FROM ITM2MENU WHERE ITM2MENU.WIN_NAME = B.WIN_NAME AND ROWNUM = 1) AS OBJ_DESCR ");
                sql.append("FROM BATCHLOAD B ");
                sql.append("WHERE B.LOAD_STAT IN ('N','E','Y') ");
                sql.append("AND B.CHG_USER = '" + userInfo.getLoginCode() + "' ");
                if (createdDate != null && !"".equalsIgnoreCase(createdDate) && this.checkNull(currDate).length() > 0 && this.checkNull(nextDate).length() > 0) {
                    sql.append("AND B.LOAD_DATE > '" + currDate + "' AND B.LOAD_DATE < '" + nextDate + "' ");
                }
                sql.append("GROUP BY B.WIN_NAME, B.BATCH_ID ");
                sql.append(") BJOB ");
                if (this.checkNull(jobID).length() > 0) {
                    sql.append("WHERE BJOB.JOB_ID = '" + jobID + "' ");
                }
                sql.append("ORDER BY BJOB.DATE_START DESC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                sql.append("SELECT BJOB.* ");
                sql.append("FROM ( ");
                sql.append("SELECT 'Excel' AS TITLE, B.WIN_NAME, B.BATCH_ID AS JOB_ID, ' ' AS JOB_STAT, ");
                sql.append("COUNT(B.BATCH_ID) AS TOTAL_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'Y' THEN 1 ELSE 0 END) AS SUCC_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT, ");
                sql.append("SUM( CASE WHEN B.LOAD_STAT = 'N' THEN 1 ELSE 0 END) AS PEND_CNT, ");
                sql.append("0 AS EXCPTION_CNT, ");
                sql.append("(CASE WHEN MIN(B.LOAD_DATE) IS NULL THEN MIN(B.CHG_DATE) ELSE MIN(B.LOAD_DATE) END) AS DATE_START,");
                sql.append("(CASE WHEN MAX(B.LOAD_DATE) IS NULL THEN MAX(B.CHG_DATE) ELSE MAX(B.LOAD_DATE) END) AS DATE_END, ");
                sql.append("(SELECT DESCR FROM ITM2MENU WHERE ITM2MENU.WIN_NAME = B.WIN_NAME AND ROWNUM = 1) AS OBJ_DESCR ");
                sql.append("FROM BATCHLOAD B ");
                sql.append("WHERE B.LOAD_STAT IN ('N','E','Y') ");
                sql.append("AND B.CHG_USER = '" + userInfo.getLoginCode() + "' ");
                if (this.checkNull(currDate).length() > 0 && this.checkNull(nextDate).length() > 0) {
                    sql.append("AND B.LOAD_DATE > '" + currDate + "' AND B.LOAD_DATE < '" + nextDate + "' ");
                }
                sql.append("GROUP BY B.WIN_NAME, B.BATCH_ID ");
                sql.append("UNION ALL ");
                sql.append("SELECT (CASE WHEN OBJ_TYPE = 'P' THEN 'Process' WHEN OBJ_TYPE = 'R' THEN 'Report' WHEN OBJ_TYPE = 'O' THEN 'Export Zip' ELSE 'Other' END) AS TITLE , ");
                sql.append("OBJ_NAME AS WIN_NAME, JOB_ID, JOB_STAT, ");
                sql.append("1 AS TOTAL_CNT, ");
                sql.append("(CASE WHEN JOB_STAT IN('I','C') THEN 1 ELSE 0 END) AS SUCC_CNT, ");
                sql.append("(CASE WHEN JOB_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT, ");
                sql.append("0 AS PEND_CNT, ");
                sql.append("(CASE WHEN JOB_STAT = 'X' THEN 1 ELSE 0 END) AS EXCPTION_CNT, ");
                sql.append("CREATED_DATE AS DATE_START, ");
                sql.append("EXEC_DATE AS DATE_END, ");
                sql.append("(SELECT DESCR FROM ITM2MENU WHERE ITM2MENU.WIN_NAME = CONCAT('w_', OBJ_NAME ) And ROWNUM = 1) AS OBJ_DESCR ");
                sql.append("FROM BACKGROUND_JOB ");
                sql.append("WHERE JOB_STAT  IN ('I','E','X','P','C') ");
                sql.append("AND USER_ID = '" + userInfo.getLoginCode() + "' ");
                if (this.checkNull(currDate).length() > 0 && this.checkNull(nextDate).length() > 0) {
                    sql.append("AND CREATED_DATE > '" + currDate + "' AND CREATED_DATE < '" + nextDate + "' ");
                }
                sql.append(") BJOB ");
                if (this.checkNull(jobID).length() > 0) {
                    sql.append("WHERE BJOB.JOB_ID = '" + jobID + "' ");
                }
                sql.append("ORDER BY BJOB.DATE_START DESC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sql.toString();
    }
}

