/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.entity.Employee;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@WebServlet(value={"/planview"})
public class PlanViewServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    List<Employee> empList = new ArrayList<Employee>();
    List<TodaysPlan> todaysPlanList = new ArrayList<TodaysPlan>();
    List<Report> feedbackList = new ArrayList<Report>();
    EmployeeDao empDao;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        BaseLogger.log((String)"0", null, null, (Object)"calling /planview Servlet with action......");
        response.setContentType("application/json");
        try {
            String action = request.getParameter("action");
            BaseLogger.log((String)"0", null, null, (Object)("calling /planview Servlet action=[" + action + "]"));
            if (action.equalsIgnoreCase("empList")) {
                this.empDao = new EmployeeDao();
                this.empList.addAll(this.empDao.getEmpList());
                BaseLogger.log((String)"0", null, null, (Object)("Employee List=" + this.empList));
                JSONArray jsonArray = new JSONArray((Collection)this.empList.stream().map(emp -> {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("empcode", (Object)emp.getEmpcode());
                        jsonObject.put("name", (Object)emp.getName());
                    }
                    catch (JSONException e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Get Employee List Error =" + e.getMessage()));
                        e.printStackTrace();
                    }
                    return jsonObject;
                }).collect(Collectors.toList()));
                String jsonString = jsonArray.toString();
                BaseLogger.log((String)"0", null, null, (Object)("Employee List json =" + jsonString));
                PrintWriter writer = response.getWriter();
                writer.print(jsonString);
            } else if (action.equalsIgnoreCase("plan")) {
                this.todaysPlanList.addAll(this.empDao.getTodysPlan());
                BaseLogger.log((String)"0", null, null, (Object)("Todays Plan List=" + this.todaysPlanList));
                JSONArray jsonArray = new JSONArray((Collection)this.todaysPlanList.stream().map(plan -> {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("name", (Object)plan.getName());
                        jsonObject.put("date", (Object)plan.getDate());
                        jsonObject.put("requestid", (Object)plan.getRequestid());
                        jsonObject.put("description", (Object)plan.getDescription());
                        jsonObject.put("actiondtl", (Object)plan.getActiondtl());
                        jsonObject.put("time", plan.getTime());
                    }
                    catch (JSONException e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Get Todays Plan List Error =" + e.getMessage()));
                        e.printStackTrace();
                    }
                    return jsonObject;
                }).collect(Collectors.toList()));
                String jsonString = jsonArray.toString();
                BaseLogger.log((String)"0", null, null, (Object)("todays planlist List json =" + jsonString));
                PrintWriter writer = response.getWriter();
                writer.print(jsonString);
            } else if (action.equalsIgnoreCase("feedback")) {
                this.empDao = new EmployeeDao();
                this.feedbackList.addAll(this.empDao.getYesterdayFeedback());
                BaseLogger.log((String)"0", null, null, (Object)("Feedback List=" + this.feedbackList));
                JSONArray jsonArray = new JSONArray((Collection)this.feedbackList.stream().map(feedback -> {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("person", (Object)feedback.getPerson());
                        jsonObject.put("requestId", (Object)feedback.getRequestId());
                        jsonObject.put("date", (Object)feedback.getDate());
                        jsonObject.put("description", (Object)feedback.getDescription());
                        jsonObject.put("actiondtl", (Object)feedback.getActiondtl());
                        jsonObject.put("stdtime", feedback.getStdtime());
                        jsonObject.put("timespend", feedback.getTimespend());
                    }
                    catch (JSONException e) {
                        BaseLogger.log((String)"0", null, null, (Object)("Get feedback List Error =" + e.getMessage()));
                        e.printStackTrace();
                    }
                    return jsonObject;
                }).collect(Collectors.toList()));
                String jsonString = jsonArray.toString();
                BaseLogger.log((String)"0", null, null, (Object)("feedback List json =" + jsonString));
                PrintWriter writer = response.getWriter();
                writer.print(jsonString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

