/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.InviteUser;
import ibase.hibernate.dao.UserInvitationDAO;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

@Path(value="/UserInvitationService")
public class UserInvitationService {
    @Context
    HttpServletRequest request;

    @GET
    @Path(value="/getInvitedUsers")
    @Produces(value={"application/json"})
    public Response getInvitedUsers(@Context HttpServletRequest request) throws Exception {
        JSONObject resultJson = new JSONObject();
        JSONObject userList = new JSONObject();
        String authStatus = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("*** In getInvitedUsers method 070119 *** " + userInfo));
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            String chngUser = userInfo.getLoginCode();
            String enterpise = userInfo.getEnterprise();
            BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("<--enterpise in getInvitedUsers --> " + enterpise));
            ArrayList invitedUserList = new ArrayList();
            JSONArray userLicListArr = new JSONArray();
            try {
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                invitedUserList = userInvitationDAO.getInvitedUsers(chngUser);
                userLicListArr = userInvitationDAO.getInviteUserLiscenceArr(enterpise);
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("userLicListArr in service " + userLicListArr));
                JSONArray invitedUserJsonArr = new JSONArray();
                for (InviteUser inviteUser : invitedUserList) {
                    invitedUserJsonArr.put((Object)new JSONObject((Object)inviteUser));
                }
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("invitedUserJsonArr in service " + invitedUserJsonArr));
                userList.put("UserList", (Object)invitedUserJsonArr);
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("userList in service " + userList));
                userList.put("UserLiscence", (Object)userLicListArr);
                resultJson.put("status", (Object)userList);
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("resultJson " + resultJson));
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("In getInvitedUsers :: getInvited users : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/inviteUsers/{userCode}")
    @Produces(value={"application/json"})
    public Response getInvitedUser(@PathParam(value="userCode") String userCode, @Context HttpServletRequest request) throws Exception {
        JSONObject resultJson = new JSONObject();
        String authStatus = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            InviteUser invitedUser = new InviteUser();
            try {
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                invitedUser = userInvitationDAO.getInviteUser(userCode);
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("In getInvitedUsers :: getInvited users : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            resultJson.put("status", (Object)new JSONObject((Object)invitedUser));
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/inviteUsers")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addInviteUser(InviteUser inviteUser, @Context HttpServletRequest request) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)(" ** In addinviteUser method **" + new JSONObject((Object)inviteUser)));
        String result = "";
        String authStatus = "";
        JSONObject resultJson = new JSONObject();
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                inviteUser.setTransDB(userInfo.getTransDB());
                inviteUser.setEnterprise(userInfo.getEnterprise());
                inviteUser.setChgUser(userInfo.getLoginCode());
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                String remoteHost = request.getHeader("Host");
                int portIndex = remoteHost.indexOf(":");
                if (portIndex != -1) {
                    remoteHost = remoteHost.substring(0, portIndex);
                }
                userInvitationDAO.setHostName(remoteHost);
                result = userInvitationDAO.addInviteUser(inviteUser, false);
                resultJson.put("status", (Object)result);
            }
            catch (Exception e) {
                ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
                String msgNo = "USRINVTERR";
                String errorMessage = itmDbAccess.getErrorString("", msgNo, userInfo.getLoginCode());
                resultJson.put("status", (Object)errorMessage);
                e.printStackTrace();
            }
        }
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)(" *** Response In addInviteUser*** " + Response.status((int)200).entity((Object)resultJson.toString()).build()));
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/inviteUsersArr")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String addInviteUser(ArrayList<InviteUser> inviteUsers, @Context HttpServletRequest request) throws Exception {
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        String authStatus = "";
        String response = "";
        JSONObject resultJson = new JSONObject();
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                for (InviteUser iUser : inviteUsers) {
                    iUser.setTransDB(userInfo.getTransDB());
                    iUser.setEnterprise(userInfo.getEnterprise());
                    iUser.setChgUser(userInfo.getLoginCode());
                }
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                String remoteHost = request.getHeader("Host");
                int portIndex = remoteHost.indexOf(":");
                if (portIndex != -1) {
                    remoteHost = remoteHost.substring(0, portIndex);
                }
                userInvitationDAO.setHostName(remoteHost);
                response = userInvitationDAO.addInviteUsers(inviteUsers);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return response;
    }

    @POST
    @Path(value="/updateInviteUsers")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public InviteUser updateInviteUser(InviteUser inviteUser, @Context HttpServletRequest request) throws Exception {
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        String authStatus = "";
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                userInvitationDAO.updateInviteUser(inviteUser);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return inviteUser;
    }

    @DELETE
    @Path(value="/deleteUsers/{userCode}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateInviteUser(@PathParam(value="userCode") String userCode) throws Exception {
        UserInfoBean userInfo = (UserInfoBean)this.request.getSession().getAttribute("USER_INFO");
        JSONObject resultJson = new JSONObject();
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In updateInviteUser method:userInfo:" + userInfo + " userCode " + userCode));
        String authStatus = "";
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)" ***In updateInviteUser Method**** ");
            try {
                if (userInfo != null) {
                    UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                    userInvitationDAO.deleteInviteUser(userCode);
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("In updateInviteUser userCode:" + userCode));
                    resultJson.put("result", (Object)userCode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                resultJson.put("result", (Object)"error");
                throw new Exception(e);
            }
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/updateStatus/{userCode}/{status}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateInviteUser(@PathParam(value="userCode") String userCode, @PathParam(value="status") String status, @Context HttpServletRequest request) throws Exception {
        String errString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In updateInviteUser method:userInfo:" + userInfo));
        String authStatus = "";
        JSONObject resultJson = new JSONObject();
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                errString = userInvitationDAO.updateRegstrationStatus(userCode, status);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("In updateInviteUser userCode:" + errString));
                resultJson.put("result", (Object)errString);
            }
            catch (Exception e) {
                resultJson.put("result", (Object)"error");
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/generateLicense")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response generateLicense(String licData) throws Exception {
        UserInvitationDAO userInvitationDAO = new UserInvitationDAO();
        JSONObject respJson = new JSONObject();
        JSONObject licDataJson = new JSONObject(licData);
        String userLimit = licDataJson.optString("userLimit");
        String remoteHost = licDataJson.optString("hostName");
        String remoteHostIp = licDataJson.optString("hostIp");
        String enterprise = licDataJson.optString("enterprise");
        BaseLogger.log((String)"2", null, null, (Object)("In generateLicense userCode:: [" + licData + "]"));
        String response = userInvitationDAO.generateServerLicense(remoteHost, "", userLimit, enterprise);
        respJson.put("status", (Object)response);
        return Response.status((int)200).entity((Object)respJson.toString()).build();
    }

    @GET
    @Path(value="/getUserInfo")
    public Response getUserInfo(@Context HttpServletRequest request) throws Exception {
        String authStatus = "";
        JSONObject resultJson = new JSONObject();
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
            resultJson.put("result", (Object)"ERROR");
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            String userInfoString = userInfo.toString();
            JSONObject userInfoObject = XML.toJSONObject((String)userInfoString);
            BaseLogger.log((String)"3", null, null, (Object)userInfoObject);
            resultJson.put("result", (Object)userInfoObject);
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    private boolean checkIsHost(String hostname) {
        Pattern p = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
        Matcher m = p.matcher(hostname);
        return !m.find();
    }

    @GET
    @Path(value="/userlicence/{enterprise}/{userLicType}")
    @Produces(value={"application/json"})
    public Response getUsersData(@PathParam(value="enterprise") String enterprise, @PathParam(value="userLicType") String userLicType) throws Exception {
        UserInfoBean userInfo = (UserInfoBean)this.request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getUsersData enterprise [" + enterprise + "] userLicType[" + userLicType + "]"));
        JSONObject respJsonObject = new JSONObject();
        try {
            if (userInfo != null) {
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                JSONObject usersData = userInvitationDAO.getUsersData(enterprise, userLicType);
                respJsonObject.put("result", (Object)"success");
                respJsonObject.put("report", (Object)usersData);
            } else {
                respJsonObject.put("result", (Object)"failure");
                respJsonObject.put("message", (Object)"Unauthorised access");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/userlicence/{enterprise}/{userLicType}/{activeUsers}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateUserLicences(@PathParam(value="enterprise") String enterprise, @PathParam(value="userLicType") String userLicType, @PathParam(value="activeUsers") String activeUsers, String selectedUsers) throws Exception {
        UserInfoBean userInfo = (UserInfoBean)this.request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In updateUserLicences enterprise[" + enterprise + "] userLicType[" + userLicType + "]activeUsers[" + activeUsers + "]selectedUsers[" + selectedUsers + "]"));
        JSONObject respJsonObject = new JSONObject();
        try {
            if (userInfo != null) {
                String transDB = userInfo.getTransDB();
                UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
                JSONArray selectedUsersJA = new JSONArray(selectedUsers);
                BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In updateUserLicences selectedUsersJA[" + selectedUsersJA + "]"));
                userInvitationDAO.updateUserLicence(transDB, enterprise, userLicType, activeUsers, selectedUsersJA);
                respJsonObject.put("result", (Object)"success");
            } else {
                respJsonObject.put("result", (Object)"failure");
                respJsonObject.put("message", (Object)"Unauthorised access");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @POST
    @Path(value="/getEmplyeeDetail/{entityCode}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getEmployee(@PathParam(value="entityCode") String entityCode, @Context HttpServletRequest request) throws Exception {
        String errString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getEmployee method:userInfo:" + userInfo));
        JSONObject resultJson = new JSONObject();
        try {
            UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
            errString = userInvitationDAO.getEmpDetail(entityCode, userInfo);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("In getEmployee userCode:" + errString));
            resultJson.put("result", (Object)errString);
        }
        catch (Exception e) {
            resultJson.put("result", (Object)"error");
            e.printStackTrace();
            throw new Exception(e);
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/getDefaultData/{profileId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getDefaultValue(@PathParam(value="profileId") String profileId, @Context HttpServletRequest request) throws Exception {
        String errString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getDefaultValue method:userInfo:" + userInfo));
        JSONObject resultJson = new JSONObject();
        try {
            UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
            errString = userInvitationDAO.getDefaultData(profileId, userInfo);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("In getDefaultValue userCode:" + errString));
            resultJson.put("result", (Object)errString);
        }
        catch (Exception e) {
            resultJson.put("result", (Object)"error");
            e.printStackTrace();
            throw new Exception(e);
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/getDefaultItemSer/{deptCode}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getDefaultItemSer(@PathParam(value="deptCode") String deptCode, @Context HttpServletRequest request) throws Exception {
        String errString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", (UserInfoBean)userInfo, null, (Object)("In getDefaultItemSer method:userInfo:" + userInfo));
        JSONObject resultJson = new JSONObject();
        try {
            UserInvitationDAO userInvitationDAO = new UserInvitationDAO(userInfo);
            errString = userInvitationDAO.getItemSer(deptCode, userInfo);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("In getDefaultItemSer userCode:" + errString));
            resultJson.put("result", (Object)errString);
        }
        catch (Exception e) {
            resultJson.put("result", (Object)"error");
            e.printStackTrace();
            throw new Exception(e);
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }
}

