package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class StrgSeriesVisit extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		boolean isLocalConn = false;
		Connection connectionObject=null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{

			if (connectionObject == null)
			{
				System.out.println("inside connectionObject null>>>>>>>>>>>>>>");
				connectionObject = getConnection();
				isLocalConn = true;
				connectionObject.setAutoCommit(false);
			}

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(connectionObject,dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StrgSeriesVisit: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally 
		{
			try
			{
				if (isLocalConn)
				{
					if ( connectionObject != null )
					{
						connectionObject.close();
						connectionObject = null;
					}
				}

			}
			catch(Exception e){}
		}
		System.out.println("Returning from StrgSeriesVisit wfValData");
		return (errString); 
	}

	public String wfValData(Connection connectionObject,Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("Entering in wfvaldata no of visit::editFlag:: "+editFlag);
		String columnName = "";
		String columnValue = "";
		String userId,loginSite = "";
		String errString = "";
		//Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isLocalConn = false;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		String totalBusiness = "";
		String sql="";
		try
		{
			if (connectionObject == null)
			{
				System.out.println("connection is null in dr lsit add");
				connectionObject = getConnection();
				isLocalConn = true;
				connectionObject.setAutoCommit(false);
			}
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				/*if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}*/
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				System.out.println("childNodeName>>>["+childNodeName+"]");
				String applVisit = checkNull(genericUtility.getColumnValue("appl_visit",dom));
				String enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
				String levelNo = checkNull(genericUtility.getColumnValue("level_no",dom));
				String salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
				System.out.println("applVisit["+applVisit+"],enterprise::["+enterprise+"],levelNo::["+levelNo+"],salesPers::["+salesPers+"]currentFormNo::"+currentFormNo);
				switch(currentFormNo)
				{
					case 1:
					{	
							System.out.println("Before if of enterprise");
							//if("Y".equals(applVisit))
							if(childNodeName.equalsIgnoreCase("enterprise"))
							{
								System.out.println("inside enterprise>>>>>>>>>>>"+childNodeName);
								enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
								levelNo = checkNull(genericUtility.getColumnValue("level_no",dom));
								salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
								if(enterprise!= null && enterprise.trim().length() > 0)
								{
									//columnValue = childNode.getFirstChild().getNodeValue();
									int count = 0;
									sql="SELECT COUNT(*) AS COUNT FROM ENTERPRISE WHERE ENTERPRISE= ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, enterprise);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										count = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close(); 
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("count::::::::"+count);
									if(count == 0)
									{
										errString = getErrorString("enterprise","INVENTRPRS",userId);
										break;
		
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("level_no"))
							{
								System.out.println("inside level_no>>>>>>>>>>>");
								if(levelNo!= null && levelNo.trim().length() > 0)
								{
									int levelNoCount = 0;
									sql="SELECT COUNT(*) AS COUNT FROM GRADE WHERE LEVEL_NO = ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, levelNo);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										levelNoCount = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close(); 
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("levelNoCount::::::::"+levelNoCount);
									if(levelNoCount == 0)
									{
										errString = getErrorString("level_no","INVLEVELNO",userId);
										break;
		
									}
								
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								System.out.println("inside sales_pers>>>>>>>>>>>");
								salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
								levelNo = checkNull(genericUtility.getColumnValue("level_no",dom));
								if(salesPers!= null && salesPers.trim().length() > 0)
								{
									int salesPersCount = 0;
									
									sql="SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ? ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, salesPers);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										salesPersCount = rs.getInt("COUNT");
									}
									if(rs != null)
									{
										rs.close(); 
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("salesPersCount::::::::"+salesPersCount);
									if(salesPersCount == 0)
									{
										errString = getErrorString("sales_pers","INVSALPERS",userId);
										break;
		
									}
									else
									{	
										System.out.println("levelNo::"+levelNo);
										if(levelNo.trim().length() > 0 && levelNo != null)
										{	
											int gradeLevelNo = 0;
											sql="SELECT LEVEL_NO FROM GRADE WHERE GRADE_CODE = (SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? )";
											pstmt = connectionObject.prepareStatement(sql);
											pstmt.setString(1, salesPers);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												gradeLevelNo = rs.getInt("LEVEL_NO");
											}
											if(rs != null)
											{
												rs.close(); 
												rs = null;
											}
											if(pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											System.out.println("levelNo::["+levelNo+"],gradeLevelNo["+gradeLevelNo+"]");
											if(Integer.parseInt(levelNo) != gradeLevelNo) 
											{
												errString = getErrorString("level_no","INVLVLSPRS",userId);
												break;
											}
										}	
									}	
										
								}
							}
		
							else if(childNodeName.equalsIgnoreCase("eff_from"))
							{
								System.out.println("Inside eff_from>>>>");
								String effctFrom = checkNull(genericUtility.getColumnValue("eff_from",dom));
								if("Y".equals(applVisit))
								{
									if(effctFrom.trim().length() == 0)
									{
										System.out.println("inside in effctFrom");
										errString = getErrorString( "eff_from", "NULEFFFROM", userId );
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("valid_upto"))
							{
								System.out.println("Inside valid_upto>>>>");
								String effctFrom = checkNull(genericUtility.getColumnValue( "eff_from", dom ));
								String validUpto = checkNull(genericUtility.getColumnValue("valid_upto",dom));
								System.out.println("effctFrom["+effctFrom+"],validUpto>>["+validUpto+"]");
								if("Y".equals(applVisit))
								{
									if(validUpto == null || validUpto.trim().length() == 0)
									{
										System.out.println("inside in validUpto");
										errString = getErrorString( "valid_upto", "NULVALUPTO", userId );
										break;
									}
								}
								if(validUpto != null && validUpto.trim().length() > 0)
								{
									System.out.println("effctFrom>>["+effctFrom+"],validUpto["+validUpto+"]");
									if((effctFrom != null && effctFrom.trim().length() > 0) && (validUpto != null && validUpto.trim().length() > 0))
									{
										SimpleDateFormat validDate = new SimpleDateFormat(genericUtility.getDispDateFormat());
										Date effeFromDate = validDate.parse(effctFrom);
										Date validUptoDate = validDate.parse(validUpto);
										System.out.println("effeFromDate["+effeFromDate +"],validDate["+validDate+"],validUptoDate"+validUptoDate+"]");
										System.out.println("validUptoDate["+validUptoDate +"]");
										if(!(validUptoDate.after(effeFromDate) || validUptoDate.equals(effeFromDate)))
										{
											System.out.println("validUptoDate is after effeFromDate");
											errString = getErrorString( "enterprise", "INVVALDTFR", userId );
											break;
										}
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("min_strg_visits"))
							{
								System.out.println("Inside in min_strg_visits");
								String minVisit = checkNull(genericUtility.getColumnValue( "min_strg_visits", dom ));
								String maxVisit = checkNull(genericUtility.getColumnValue( "max_strg_visits", dom ));
								applVisit = checkNull(genericUtility.getColumnValue("appl_visit",dom));
								System.out.println("minVisit>>["+minVisit+"]:::applVisit::"+applVisit+"maxVisit::"+maxVisit);
								if("Y".equals(applVisit))
								{
									System.out.println("Inside in applVisit>>>"+applVisit);
									if(minVisit == null || minVisit.trim().length() == 0)
									{
										System.out.println("inside in minVisit");
										errString = getErrorString( "min_strg_visits", "NULMINVIST", userId );
										break;
									}
									if(minVisit != null && minVisit.trim().length() > 0)
									{
										if(minVisit.indexOf('.') != -1)
										{
											System.out.println("minVisit INTEGER minVisit::"+minVisit);
											errString = getErrorString( "min_strg_visits", "DECVLNTALW", userId );
											break;
										}
									}
									if(Integer.parseInt(minVisit) <= 0)
									{
										System.out.println("inside min_strg_visits");
										errString = getErrorString( "min_strg_visits", "INVMINVSIT", userId );
										break;
									}
									else if(maxVisit != null && maxVisit.trim().length() > 0)
									{
										if(Integer.parseInt(minVisit) > Integer.parseInt(maxVisit)  )
										{
											System.out.println("inside min_strg_visits imin visit is greter than max visit");
											errString = getErrorString( "min_strg_visits", "MINVISGRTR", userId );
											break;
										}
									}	
								}
								if(minVisit != null && minVisit.trim().length() > 0)
								{
									if(minVisit.indexOf('.') != -1)
									{
										System.out.println("minVisit INTEGER minVisit::"+minVisit);
										errString = getErrorString( "min_strg_visits", "DECVLNTALW", userId );
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("max_strg_visits"))
							{
								System.out.println("inside max_strg_visits>>>>>>>>>>>");
								String maxVisit = checkNull(genericUtility.getColumnValue( "max_strg_visits", dom ));
								if("Y".equals(applVisit))
								{
									if(maxVisit == null || maxVisit.trim().length() == 0)
									{
										errString = getErrorString( "max_strg_visits", "NULMAXVIST", userId );
										break;
									}
									if(maxVisit != null && maxVisit.trim().length() > 0)
									{
										if(maxVisit.indexOf('.') != -1)
										{
											System.out.println("minVisit INTEGER VALUE:max_strg_visits::"+maxVisit);
											errString = getErrorString( "max_strg_visits", "DECVLNTALW", userId );
											break;
										}
									}
									if(Integer.parseInt(maxVisit) <= 0)
									{
										System.out.println("inside maxVisit");
										errString = getErrorString( "max_strg_visits", "INVMAXVSIT", userId );
										break;
									}
									else if(maxVisit != null && maxVisit.trim().length() > 0)
									{
										if(maxVisit.indexOf('.') != -1)
										{
											System.out.println("minVisit INTEGER VALUE:max_strg_visits::"+maxVisit);
											errString = getErrorString( "max_strg_visits", "DECVLNTALW", userId );
											break;
										}
									}
								}
								if(maxVisit != null && maxVisit.trim().length() > 0)
								{
									if(maxVisit.indexOf('.') != -1)
									{
										System.out.println("minVisit INTEGER VALUE:max_strg_visits::"+maxVisit);
										errString = getErrorString( "max_strg_visits", "DECVLNTALW", userId );
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("min_strg_cust"))
							{
								System.out.println("inside min_strg_cust>>>>>>>>>>>");
								String minDoct = checkNull(genericUtility.getColumnValue( "min_strg_cust", dom ));
								String maxDoct = checkNull(genericUtility.getColumnValue( "max_strg_cust", dom ));
								applVisit = checkNull(genericUtility.getColumnValue("appl_visit",dom));
								if("Y".equals(applVisit))
								{
									if(minDoct == null || minDoct.trim().length() == 0)
									{
										errString = getErrorString( "min_strg_cust", "NULMINDOCT", userId );
										break;
									}
									if(minDoct != null && minDoct.trim().length() > 0)
									{
										if(minDoct.indexOf('.') != -1)
										{
											System.out.println("minVisit INTEGER minDoct::"+minDoct);
											errString = getErrorString( "min_strg_cust", "DECVLNTALW", userId );
											break;
										}
									}
									if(Integer.parseInt(minDoct) <= 0)
									{
										System.out.println("inside minDoct");
										errString = getErrorString( "min_strg_cust", "INVMINDOCT", userId );
										break;
									}
									else if(maxDoct != null && maxDoct.trim().length() > 0)
									{ 
										if(Integer.parseInt(minDoct) > Integer.parseInt(maxDoct)  )
										{
											System.out.println("inside min_strg_visits imin visit is greter than max visit");
											errString = getErrorString( "min_strg_cust", "MAXDOCGRTR", userId );
											break;
										}
									}	
								}
								if(minDoct != null && minDoct.trim().length() > 0)
								{
									if(minDoct.indexOf('.') != -1)
									{
										System.out.println("minVisit INTEGER minDoct::"+minDoct);
										errString = getErrorString( "min_strg_cust", "DECVLNTALW", userId );
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("max_strg_cust"))
							{
								System.out.println("inside max_strg_cust>>>>>>>>>>>");
								String maxDoct = checkNull(genericUtility.getColumnValue( "max_strg_cust", dom ));
								if("Y".equals(applVisit))
								{
									if(maxDoct == null || maxDoct.trim().length() == 0)
									{
										System.out.println("inside maxDoct");
										errString = getErrorString( "max_strg_cust", "NULMAXDOCT", userId );
										break;
									}
									if(maxDoct != null && maxDoct.trim().length() > 0)
									{
										if(maxDoct.indexOf('.') != -1)
										{
											System.out.println("minVisit INTEGER maxDoct::"+maxDoct);
											errString = getErrorString( "max_strg_cust", "DECVLNTALW", userId );
											break;
										}
									}
									if(Integer.parseInt(maxDoct) <= 0)
									{
										System.out.println("inside max_strg_cust");
										errString = getErrorString( "max_strg_cust", "INVMAXDOCT", userId );
										break;
									}
								}
								if(maxDoct != null && maxDoct.trim().length() > 0)
								{
									if(maxDoct.indexOf('.') != -1)
									{
										System.out.println("minVisit INTEGER maxDoct::"+maxDoct);
										errString = getErrorString( "max_strg_cust", "DECVLNTALW", userId );
										break;
									}
								}
							}
							if(childNodeName.equalsIgnoreCase("appl_visit"))
							{
								applVisit = checkNull(genericUtility.getColumnValue("appl_visit",dom));
								enterprise = checkNull(genericUtility.getColumnValue("enterprise",dom));
								levelNo = checkNull(genericUtility.getColumnValue("level_no",dom));
								salesPers = checkNull(genericUtility.getColumnValue("sales_pers",dom));
								System.out.println(">>>>>>>>>>>>>applVisit["+applVisit+"],enterprise::["+enterprise+"],levelNo::["+levelNo+"],salesPers::["+salesPers+"]");
								if("Y".equalsIgnoreCase(applVisit))
								{	
									if(enterprise.trim().length() == 0 && levelNo.trim().length() == 0 && salesPers.trim().length() == 0)    
									{
										System.out.println("inside enterprise null");
										errString = getErrorString( "enterprise", "NULLFIELD", userId );
										break;
									}
									else
									{	
										if("A".equalsIgnoreCase(editFlag))
										{	
											if( enterprise.trim().length() > 0 ||  levelNo.trim().length() > 0 ||  salesPers.trim().length() > 0)
											{
												String effFrom = checkNull(genericUtility.getColumnValue("eff_from",dom));
												String validUpto = checkNull(genericUtility.getColumnValue("valid_upto",dom));
												System.out.println("tranID,effFrom["+effFrom+"],validUpto["+validUpto+"]");
												int enterCount = 0;
												sql = "SELECT COUNT(*) AS COUNT FROM STRG_SER_VISIT WHERE ? BETWEEN EFF_FROM AND VALID_UPTO " ;
														
	
												if( enterprise.trim().length() > 0 &&  levelNo.trim().length() > 0 &&  salesPers.trim().length() > 0)
												{
													sql = sql + " AND ENTERPRISE = ? AND LEVEL_NO = ? AND SALES_PERS = ? ";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, enterprise);
													pstmt.setString(3, levelNo);
													pstmt.setString(4, salesPers);
													System.out.println("sql::all:"+sql);
												}
												else if( enterprise.trim().length() > 0 &&  levelNo.trim().length() > 0 )
												{
													//sql = sql + " AND ENTERPRISE = ? AND LEVEL_NO = ?";
													sql = sql + " AND ENTERPRISE = ? AND LEVEL_NO = ? AND SALES_PERS IS NULL ";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, enterprise);
													pstmt.setString(3, levelNo);
													//pstmt.setString(4, "");
													System.out.println("sql::enterprise::levelNo::"+sql);
												}
												else if( enterprise.trim().length() > 0 &&  salesPers.trim().length() > 0 )
												{
													//sql = sql + " AND ENTERPRISE = ? AND SALES_PERS = ?";
													sql = sql + " AND ENTERPRISE = ? AND SALES_PERS = ? AND LEVEL_NO IS NULL";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, enterprise);
													pstmt.setString(3, salesPers);
													//pstmt.setString(4, "");
													System.out.println("sql::enterprise::salesPers::"+sql);
												}
												else if( levelNo.trim().length() > 0 &&  salesPers.trim().length() > 0 )
												{
													//sql = sql + " AND LEVEL_NO = ? AND SALES_PERS = ?";
													sql = sql + " AND LEVEL_NO = ? AND SALES_PERS  = ? AND ENTERPRISE IS NULL";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, levelNo);
													pstmt.setString(3, salesPers);
													//pstmt.setString(4, "");
													System.out.println("sql::levelNo::salesPers::"+sql);
												}
												else if( enterprise.trim().length() > 0 )
												{
													//sql = sql + " AND ENTERPRISE = ? ";
													sql = sql + " AND ENTERPRISE = ? AND LEVEL_NO IS NULL AND SALES_PERS IS NULL ";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, enterprise);
													//pstmt.setString(3, "");
													//pstmt.setString(4, "");
													System.out.println("sql::enterprise::enterprise::"+sql);
												}
												else if( levelNo.trim().length() > 0 )
												{
													//sql = sql + " AND LEVEL_NO = ? ";
													sql = sql + " AND LEVEL_NO = ? AND ENTERPRISE IS NULL AND SALES_PERS IS NULL ";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, levelNo);
													//pstmt.setString(3, "");
													//pstmt.setString(4, "");
													System.out.println("sql::levelNo::levelNo::"+sql);
												}
												else if( salesPers.trim().length() > 0 )
												{
													//sql = sql + " AND SALES_PERS = ?";
													sql = sql + " AND SALES_PERS = ? AND ENTERPRISE IS NULL AND LEVEL_NO IS NULL";
													pstmt = connectionObject.prepareStatement(sql);
													//pstmt.setString(1, validUpto);
													pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom , genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
													pstmt.setString(2, salesPers);
													//pstmt.setString(3, "");
													//pstmt.setString(4, "");
													System.out.println("sql::salesPers::salesPers::"+sql);
												}
												
												rs = pstmt.executeQuery();
												if( rs.next() )
												{
													enterCount = rs.getInt("COUNT");
												}
												if(rs!=null)
												{
													rs.close();
													rs = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}
												System.out.println("enterCount::["+enterCount+"],tranID");
												if(enterCount > 0)
												{
													errString = getErrorString("enterprise","ENTPRSEXST",userId);
													break;
			
												}
											}
										}
										System.out.println("childNodeName>>>"+childNodeName);
									}
								}	
							}
							System.out.println("END OF WALDATA");
						}	
					}
					if (errString != null && errString.trim().length()>0)
					{
						break;
					}
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgSeriesVisit: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: StrgSeriesVisit: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}

		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				if (isLocalConn)
				{
					if ( connectionObject != null )
					{
						connectionObject.close();
						connectionObject = null;
					}
				}

			}
			catch(Exception e){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :StrgSeriesVisit:itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from StrgSeriesVisit:itemChanged" );
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("STRGSERIES visit ITEMCHANGE");
		String sql = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		try
		{
			connectionObject = getConnection();

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			switch (currentFormNo)
			{
			case 1:
				valueXmlString.append("<Detail1 domId =\"1\">\r\n");
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("*******************xtraParams["+xtraParams+"]");

					valueXmlString.append("<appl_visit>").append("<![CDATA["+'Y'+"]]>").append("</appl_visit>");

				}
				else if(currentColumn.equalsIgnoreCase("enterprise"))
				{
					String enterpriceDescr = "";
					String enterprise = genericUtility.getColumnValue("enterprise", dom);
					sql = "SELECT ENTERPRISE_DESCR FROM ENTERPRISE WHERE ENTERPRISE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, enterprise);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						enterpriceDescr = checkNull(rs.getString("ENTERPRISE_DESCR"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<enterprise_descr>").append("<![CDATA[" + enterpriceDescr + "]]>").append("</enterprise_descr>");
				}
				else if(currentColumn.equalsIgnoreCase("sales_pers"))
				{
					String spName = "";
					String salesPers = genericUtility.getColumnValue("sales_pers", dom);
					sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						spName = checkNull(rs.getString("SP_NAME"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<sp_name>").append("<![CDATA[" + spName + "]]>").append("</sp_name>");
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
			}
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgSeriesVisit: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgSeriesVisit:itemChanged[" + e.getMessage() + "]");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();

	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}





}
