package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.webitm.utility.DocumentViewerServiceUtility;

@Path("/DocumentViewerService")

public class DocumentViewerService  extends RestAPIService 
{
	@GET
	@Path("/getPreviewImage")
	@Produces(MediaType.APPLICATION_JSON)
	//pass the parameter 
	public Response getAttachConfigData( 
			@QueryParam("OBJ_NAME") String objName,
			@QueryParam("REF_ID") String refId,
			@HeaderParam("TOKEN_ID") String tokenIDfromHeader)  throws BaseException, Exception 
	{
		BaseLogger.log( "3", null, null, "getPreviewImage Service Called");

		DocumentViewerServiceUtility documentViewerServiceUtility= new DocumentViewerServiceUtility();
		//chnages done at here check tommorow chng the varible
		   byte[]	response = documentViewerServiceUtility.getPreviewImage(objName, refId,tokenIDfromHeader);
		BaseLogger.log( "3", null, null, "response value  ::"+ response );

		return Response.status(200).entity( response ).build();

	}
}
