/**
 * 
 */
package ibase.webitm.utility.wsfa;

import org.json.JSONObject;
import org.json.XML;
import org.json.simple.JSONArray;

import ibase.webitm.utility.ITMException;

/**
 * @author base
 *
 */
public class ExceptionUtility 
{
	public JSONArray handleException( Exception e )
	{
		JSONArray tempArr = new JSONArray();
		try
		{
			ITMException itme = new ITMException( e );
			String errSting = "<Root>" + itme.getMessage() + "</Root>";
			System.out.println( "ITMException :: getMessage : ["+ errSting +"]" );
			JSONObject jsonObject = convertXmlToJsonInError( errSting );

			tempArr.add( jsonObject );
		}
		catch (Exception e1)
		{
			System.out.println( "Exception :: handleException : ["+ e1.getMessage() +"]" );
			e1.printStackTrace();
		}
		return tempArr;
	}
	
	public JSONObject convertXmlToJsonInError( String xmlString )
	{
		return convertXmlToJsonInError( xmlString, null );
	}

	public JSONObject convertXmlToJsonInError( String xmlString, String trace )
	{
		JSONObject jsonObject = new JSONObject();
		try
		{
			trace = Utilities.checkNull( trace );
			System.out.println( "trace : ["+ trace +"]" );

			JSONObject obj = XML.toJSONObject(xmlString);
			JSONObject root = obj.getJSONObject("Root");
			JSONObject Errors = root.getJSONObject("Errors");
			JSONObject error = Errors.getJSONObject("error");
			//System.out.println( "error : ["+ error +"]" );
			String errorTrace = "";
			if ( error.has( "trace" ) )
			{
				errorTrace = error.getString("trace");
			}
			String columnName = "";
			if ( error.has( "column_name" ) )
			{
				columnName = error.getString("column_name");
			}
			//changed and Added by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] start
			String message = "";
			if ( error.has( "message" ) )
			{
				message = error.getString("message");
			}
			//changed and Added by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] start
			String description = "";
			if ( error.has( "description" ) )
			{
				description = error.getString("description");
			}
			String type = "";
			if ( error.has( "type" ) )
			{
				try
				{
					org.json.JSONArray jsonArraytype = error.getJSONArray("type");
					type = jsonArraytype.getString(1);
				}
				catch (Exception e)
				{
					e.printStackTrace();
					type = error.getString("type");
				}
			}
			System.out.println( "type : ["+ type +"],\ncolumn_name : ["+ columnName +"],\nmessage : ["+ message +"],\ndescription : ["+ description +"],\nerrorTrace : ["+ errorTrace +"]" );
			if ( "X".equalsIgnoreCase( type ) )
			{
				errorTrace = "Exception : ";
			}
			else if ( trace.length() > 0 )
			{
				errorTrace = trace;
			}
			//changed and Added by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ]
			jsonObject.put("column_name", columnName);
			jsonObject.put("type", type);
			jsonObject.put("message", message);
			jsonObject.put("description", description);
			jsonObject.put("trace", errorTrace);
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.convertXmlToJsonInError()"+e);
		}
		return jsonObject;
	}
}
