package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

public class StrgBrandActWizConf extends ActionHandlerEJB
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isLocalConn = false;
		int count = 0;
		String empCodeConf = "";
		Connection conn = null;	
	    String sql1="";
	    String currDate = "";
	    String salesPers ="";
	    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try
		{
			//System.out.println("tranId StrgEventTrackWizConf ::"+tranId);
			//System.out.println("StrgMeetDCRWizConf confirm method is called.........");
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn = true;
				conn.setAutoCommit( false );
			}
			if(!xtraParams.contains("#"))
			{
				empCodeConf = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			}
			else
			{
				String[] xtraParmArr = xtraParams.split("#");
				empCodeConf = xtraParmArr[0];
			}
			
			sql1="SELECT SALES_PERS FROM STRG_BRAND_ACT WHERE TRAN_ID=?";
			pStmt = conn.prepareStatement(sql1);
			pStmt.setString(1,tranId);
			rs = pStmt.executeQuery();
			
			if(rs.next())
			{
				salesPers = rs.getString("SALES_PERS").trim();
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			
			int cntSS = 0;
			int cntBR = 0;
			sql1="SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS,STRG_CUSTOMER SC ,LOCALITY LOC,SPECIALITY SPL,SPRS_ROUTE SR WHERE SS.SC_CODE = SC.SC_CODE AND "
					+ "LOC.LOCALITY_CODE = SR.LOCALITY_CODE AND SPL.SPL_CODE = SS.SPL_CODE "
					+ "AND SS.SALES_PERS =? AND SS.STATUS =? AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SALES_PERS = SR.SPRS_CODE";
			pStmt = conn.prepareStatement(sql1);
			pStmt.setString(1,salesPers);
			pStmt.setString(2,"Y");
			rs = pStmt.executeQuery();
			
			if(rs.next())
			{
				cntSS = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			
			sql1="SELECT COUNT(DISTINCT(SC_CODE)) AS COUNT FROM STRG_BRAND_ACT_DET WHERE TRAN_ID=?";
			pStmt = conn.prepareStatement(sql1);
			pStmt.setString(1,tranId);
			rs = pStmt.executeQuery();
			
			if(rs.next())
			{
				cntBR = rs.getInt("COUNT");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			
			if(cntSS==cntBR)
			{	
			
			    DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			    java.util.Date date = Calendar.getInstance().getTime();
			    currDate = dtFormat.format( date );

			    String pDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			    System.out.println("currDate ::>>>>>>["+currDate+"]");
			    
			    sql1 = "UPDATE STRG_BRAND_ACT SET CONFIRMED = ?,CONF_DATE = ? WHERE TRAN_ID = ?";
			    pStmt = conn.prepareStatement(sql1);
			    pStmt.setString(1,"Y");
			    pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(pDate));
			    pStmt.setString(3,tranId);
			    count = pStmt.executeUpdate();
			
			    if(pStmt!=null)
			    {
				  pStmt.close();
				  pStmt = null;
			    }
			
			     System.out.println("updateStrgBrandActCnt........."+count);
			
			
			    if(count>0)
			    {
			        retString =	itmDBAccessEJB.getErrorString("","CONFSUCCBR","");
			    }
			    else
			    {
			    	retString =	itmDBAccessEJB.getErrorString("","VLTRANCFBR","");
			    }	
			}
			else
			{
				retString =	itmDBAccessEJB.getErrorString("","VONCONFBR","");
			}	
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :StrgBrandActWizConf :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if ( isLocalConn )
					{
						if ( ! isError )
						{
							conn.commit();
							System.out.println("StrgBrandActWizConf Connection commited........");
						}
						conn.close();
						conn = null;
					}

				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgBrandActWizConf :confirm :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("[StrgBrandActWizConf]Return string :"+retString);
		return retString;
	}
		
	private String checkNull(String value)
	{
	   if ( value == null )
	   {
		   value = "";
	   }
	   return value.trim();
	}

}
