/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.utility;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import ibase.bi.ejb.session.Column;
import ibase.bi.utility.BIContentWriter;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class BIPDFWriter
implements BIContentWriter {
    Document document = null;
    PdfPTable datatable = null;
    int noOfCTCols = 0;
    String grpInfo = null;
    ArrayList list = null;
    boolean isNewPageForGroup = false;
    String timeStampInfo = null;
    boolean isSuppressGrid = false;
    String imgPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "bi" + File.separator + "resource" + File.separator + "common" + File.separator + "images";

    public BIPDFWriter(String docFile) throws Exception {
        this.document = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(docFile));
    }

    @Override
    public void setReportHeader(String repHeader) throws Exception {
        this.getFormattedHeader(repHeader == null ? "" : repHeader);
    }

    @Override
    public void setGroupInfo(String grpInfo) throws Exception {
        this.grpInfo = grpInfo;
    }

    @Override
    public void setPageSize(String pageSize, boolean isPotrate) throws Exception {
        if (pageSize.equalsIgnoreCase("A4")) {
            if (isPotrate) {
                this.document.setPageSize(PageSize.A4);
            } else {
                this.document.setPageSize(PageSize.A4.rotate());
            }
        }
    }

    @Override
    public void setPageSize(float pageWidth, float pageHeight) throws Exception {
        this.document.setPageSize(new Rectangle(pageWidth * 72.0f, pageHeight * 72.0f));
    }

    @Override
    public void setPageMargin(float marginLeft, float marginRight, float marginTop, float marginBottom) throws Exception {
        this.document.setMargins(marginLeft * 80.0f, marginRight * 80.0f, marginTop * 80.0f, marginBottom * 80.0f);
    }

    @Override
    public void setPageHeader(String pageHeader, int alignment, boolean showPageNo) throws Exception {
        Phrase p = new Phrase(pageHeader);
        HeaderFooter headerFooter = new HeaderFooter(p, showPageNo);
        headerFooter.setAlignment(this.getAlignment(alignment));
        if (pageHeader != null) {
            this.document.setHeader(headerFooter);
        }
        headerFooter.disableBorderSide(1);
        headerFooter.disableBorderSide(2);
    }

    private int getAlignment(int alignment) throws Exception {
        int align = alignment;
        try {
            switch (alignment) {
                case 1: {
                    align = 0;
                    break;
                }
                case 2: {
                    align = 2;
                    break;
                }
                case 3: {
                    align = 1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return align;
    }

    @Override
    public void setPageFooter(String pageFooter, int alignment, boolean showPageNo) throws Exception {
        Paragraph paragraph;
        BaseLogger.log("3", null, null, "timeStampInfo1 :" + this.timeStampInfo);
        Phrase phrase = new Phrase();
        Font fontObj = new Font(2);
        fontObj.setSize(8.0f);
        if (this.timeStampInfo != null) {
            paragraph = new Paragraph(this.timeStampInfo, fontObj);
            paragraph.setAlignment(0);
            phrase.add((Object)new Chunk("[ "));
            phrase.add((Object)paragraph);
            phrase.add((Object)new Chunk(" ] "));
        }
        pageFooter = pageFooter != null ? String.valueOf(pageFooter) + " " : " ";
        paragraph = new Paragraph(pageFooter, fontObj);
        phrase.add((Object)paragraph);
        HeaderFooter headerFooter = new HeaderFooter(phrase, showPageNo);
        headerFooter.setAlignment(this.getAlignment(alignment));
        if (pageFooter != null) {
            this.document.setFooter(headerFooter);
        }
        headerFooter.disableBorderSide(1);
        headerFooter.disableBorderSide(2);
    }

    @Override
    public void setReportFooter(String repFooter) throws Exception {
    }

    @Override
    public void setHeaderCount(int headerCount) throws Exception {
        if (this.datatable != null) {
            this.datatable.setHeaderRows(headerCount);
        }
    }

    @Override
    public boolean createTable(float[] defaultColWidthArr, boolean fittowidth) throws Exception {
        boolean created = false;
        this.datatable = new PdfPTable(defaultColWidthArr.length);
        this.datatable.setTotalWidth(defaultColWidthArr);
        if (!fittowidth) {
            this.datatable.setLockedWidth(true);
        }
        this.datatable.setHorizontalAlignment(0);
        created = true;
        return created;
    }

    @Override
    public void setTableWidthPercentage(float percentage) throws Exception {
        this.datatable.setWidthPercentage(percentage);
    }

    @Override
    public boolean addDataCell(String data, int colspan, Column formatingObj) throws Exception {
        PdfPCell cellObj = null;
        boolean created = false;
        StringBuffer sbData = new StringBuffer(data);
        int pipeIndex = data.indexOf("|");
        while (pipeIndex != -1) {
            sbData.replace(pipeIndex, pipeIndex + 1, "\n");
            data = sbData.toString();
            pipeIndex = data.indexOf("|");
        }
        String addataType = formatingObj.getDataType();
        if (addataType.equalsIgnoreCase("IMAGE")) {
            File imgFile = new File(String.valueOf(this.imgPath) + File.separator + data);
            URL src = null;
            if (imgFile.isDirectory()) {
                cellObj = new PdfPCell();
            } else {
                src = !imgFile.exists() ? new URL(imgFile.toURL(), "default.jpg") : new URL(imgFile.toURL(), data);
                Image image = Image.getInstance((URL)src);
                image.scaleAbsoluteWidth((float)formatingObj.getImageWidth());
                image.scaleAbsoluteHeight((float)formatingObj.getImageHeight());
                cellObj = new PdfPCell(image, false);
            }
        } else {
            cellObj = new PdfPCell(new Phrase(data, this.getFontForColumn(formatingObj)));
        }
        if (formatingObj != null) {
            cellObj.setHorizontalAlignment(this.getAlignment(Integer.parseInt(formatingObj.getAlignment())));
            if (formatingObj.getBGColor() != null && formatingObj.getBGColor().trim().length() >= 6) {
                cellObj.setBackgroundColor(this.getColor(formatingObj.getBGColor()));
            }
        }
        if (this.isSuppressGrid) {
            cellObj.disableBorderSide(4);
            cellObj.disableBorderSide(8);
            cellObj.disableBorderSide(1);
            cellObj.disableBorderSide(2);
        }
        if (formatingObj != null) {
            cellObj.setHorizontalAlignment(this.getAlignment(Integer.parseInt(formatingObj.getAlignment())));
            if (formatingObj.getBGColor() != null && formatingObj.getBGColor().trim().length() >= 6) {
                cellObj.setBackgroundColor(this.getColor(formatingObj.getBGColor()));
            }
        }
        if (colspan > 0) {
            cellObj.setColspan(colspan);
        }
        this.datatable.addCell(cellObj);
        created = true;
        return created;
    }

    private Color getColor(String htmlColor) throws Exception {
        htmlColor = htmlColor.trim();
        htmlColor = htmlColor.substring(1);
        int hexVal = Integer.parseInt(htmlColor, 16);
        Color color = new Color(hexVal);
        return color;
    }

    private Font getFontForColumn(Column formatingObj) throws Exception {
        Font fontObj = new Font(2);
        if (formatingObj != null) {
            if (formatingObj.getFont() != null) {
                String fontStr = formatingObj.getFont();
                if (fontStr.equalsIgnoreCase("Courier")) {
                    fontObj = new Font(0);
                }
                if (fontStr.equalsIgnoreCase("Helvetica")) {
                    fontObj = new Font(1);
                }
                if (fontStr.equalsIgnoreCase("Symbol")) {
                    fontObj = new Font(3);
                }
                if (fontStr.equalsIgnoreCase("Webdings") || fontStr.equalsIgnoreCase("Wingdings")) {
                    fontObj = new Font(4);
                }
            }
            fontObj.setSize((float)formatingObj.getFontSize());
            String style = "normal";
            if (formatingObj.getBold() == 1) {
                style = String.valueOf(style) + "bold";
            }
            if (formatingObj.getItalic() == 1) {
                style = String.valueOf(style) + "italic";
            }
            if (formatingObj.getUnderline() == 1) {
                style = String.valueOf(style) + "underline";
            }
            if (formatingObj.getFGColor() != null && formatingObj.getFGColor().trim().length() >= 6) {
                fontObj.setColor(this.getColor(formatingObj.getFGColor()));
            }
            fontObj.setStyle(style);
        }
        return fontObj;
    }

    @Override
    public void setNewPageForGroup(boolean isNewPageForGroup) throws Exception {
        this.isNewPageForGroup = isNewPageForGroup;
    }

    @Override
    public void setTimeStampInfo(String timeStampInfo) throws Exception {
        this.timeStampInfo = timeStampInfo;
    }

    @Override
    public boolean writeDocument() throws Exception {
        boolean created = false;
        if (!this.document.isOpen()) {
            this.document.open();
        } else if (this.isNewPageForGroup) {
            this.document.newPage();
        }
        if (this.list != null) {
            int i = 0;
            while (i < this.list.size()) {
                this.document.add((Element)this.list.get(i));
                ++i;
            }
        }
        this.document.add((Element)new Phrase(""));
        if (this.grpInfo != null) {
            this.document.add((Element)new Phrase(""));
            this.document.add((Element)new Phrase(this.grpInfo));
            this.document.add((Element)new Phrase(""));
        }
        if (this.datatable != null) {
            if (this.datatable.getRows().size() <= this.datatable.getHeaderRows()) {
                BaseLogger.log("3", null, null, "No Data...");
                this.datatable = new PdfPTable(1);
                this.datatable.addCell("1 - 0 of 0");
            }
            this.document.add((Element)this.datatable);
            int recs = this.datatable.size() - this.datatable.getHeaderRows();
            Paragraph paragraph = new Paragraph("1 - " + recs + " of " + recs);
            paragraph.setAlignment(2);
            this.document.add((Element)paragraph);
        }
        created = true;
        return created;
    }

    @Override
    public boolean closeDocument() throws Exception {
        boolean closed = false;
        if (this.document != null) {
            this.document.close();
        }
        closed = true;
        return closed;
    }

    private void getFormattedHeader(String pageHeader) {
        this.list = new ArrayList();
        try {
            while (pageHeader.indexOf("&nbsp") != -1) {
                int index = pageHeader.indexOf("&nbsp");
                String beforeNbsp = pageHeader.substring(0, index);
                String afterNbsp = pageHeader.substring(index + 6, pageHeader.length());
                pageHeader = String.valueOf(beforeNbsp) + " " + afterNbsp;
            }
            while (pageHeader.indexOf("~<img") != -1) {
                int startIndex = pageHeader.indexOf("~<img");
                int endIndex = pageHeader.indexOf("/>", startIndex);
                String beforeImg = pageHeader.substring(0, startIndex);
                String afterImg = pageHeader.substring(endIndex + 2, pageHeader.length());
                pageHeader = String.valueOf(beforeImg) + afterImg;
            }
            if (pageHeader.indexOf("~") != -1) {
                pageHeader = pageHeader.replace('~', ' ');
            }
            StringBuffer strbuf = new StringBuffer();
            strbuf.append("<html>");
            strbuf.append(pageHeader);
            strbuf.append("</html>");
            pageHeader = strbuf.toString();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document dom = parser.parse(new ByteArrayInputStream(pageHeader.getBytes()));
            NodeList htmlNodeList = dom.getElementsByTagName("html");
            if (htmlNodeList.getLength() != 0) {
                HashMap styleMap = new HashMap();
                Paragraph paragraph = new Paragraph();
                this.recursion(htmlNodeList.item(0), styleMap, paragraph);
                if (paragraph != null) {
                    this.list.add(paragraph);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recursion(Node node, HashMap map, Paragraph paragraph) {
        this.nodeDetail(node, map, paragraph);
        if (node.hasChildNodes()) {
            NodeList nodeClist = node.getChildNodes();
            int i = 0;
            while (i < nodeClist.getLength()) {
                Node childnode = nodeClist.item(i);
                HashMap stMap = new HashMap(map);
                this.recursion(childnode, stMap, paragraph);
                ++i;
            }
        }
    }

    private void nodeDetail(Node nd, HashMap stMap, Paragraph paragraph) {
        String text;
        if (nd.getNodeType() == 1) {
            if (nd.hasAttributes()) {
                NamedNodeMap alignAttribMap = nd.getAttributes();
                int i = 0;
                while (i < alignAttribMap.getLength()) {
                    Node alignAttribNode = alignAttribMap.item(i);
                    if ("align".equalsIgnoreCase(alignAttribNode.getNodeName())) {
                        String align = alignAttribNode.getNodeValue();
                        stMap.put("ALIGN", align);
                    }
                    ++i;
                }
            }
            if ("font".equalsIgnoreCase(nd.getNodeName())) {
                NamedNodeMap attriBMap = nd.getAttributes();
                int j = 0;
                while (j < attriBMap.getLength()) {
                    String fontStyle;
                    int index;
                    Node attriBNode = attriBMap.item(j);
                    if ("size".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontSize = attriBNode.getNodeValue();
                        stMap.put("SIZE", fontSize);
                    }
                    if ("color".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontColor = attriBNode.getNodeValue();
                        stMap.put("COLOR", fontColor);
                    }
                    if ("face".equalsIgnoreCase(attriBNode.getNodeName())) {
                        String fontFace = attriBNode.getNodeName();
                        stMap.put("FACE", fontFace);
                    }
                    if ("style".equalsIgnoreCase(attriBNode.getNodeName()) && (index = (fontStyle = attriBNode.getNodeValue().toUpperCase()).indexOf(":")) != -1) {
                        String bgColor = fontStyle.substring(index + 1, fontStyle.length());
                        stMap.put("BGCOLOR", bgColor);
                    }
                    ++j;
                }
            } else if ("b".equalsIgnoreCase(nd.getNodeName()) || "strong".equalsIgnoreCase(nd.getNodeName())) {
                stMap.put("B", new Boolean("true"));
            } else if ("u".equalsIgnoreCase(nd.getNodeName())) {
                stMap.put("U", new Boolean("true"));
            } else if ("i".equalsIgnoreCase(nd.getNodeName()) || "em".equalsIgnoreCase(nd.getNodeName())) {
                stMap.put("I", new Boolean("true"));
            } else if ("strike".equalsIgnoreCase(nd.getNodeName())) {
                stMap.put("STRIKE", new Boolean("true"));
            } else if ("img".equalsIgnoreCase(nd.getNodeName())) {
                String width = "25";
                String height = "15";
                String url = null;
                NamedNodeMap imgMap = nd.getAttributes();
                int k = 0;
                while (k < imgMap.getLength()) {
                    Node imgAttriBNode = imgMap.item(k);
                    if ("src".equalsIgnoreCase(imgAttriBNode.getNodeName())) {
                        url = imgAttriBNode.getNodeValue();
                        stMap.put("URL", url);
                    } else if ("width".equalsIgnoreCase(imgAttriBNode.getNodeName())) {
                        width = imgAttriBNode.getNodeValue();
                    } else if ("height".equalsIgnoreCase(imgAttriBNode.getNodeName())) {
                        height = imgAttriBNode.getNodeValue();
                    }
                    if ("alt".equalsIgnoreCase(imgAttriBNode.getNodeName())) {
                        String alt = imgAttriBNode.getNodeValue();
                        stMap.put("ALT", alt);
                    }
                    ++k;
                }
                stMap.put("WIDTH", width);
                stMap.put("HEIGHT", height);
                paragraph = new Paragraph(this.getImgChunk(stMap));
            } else if ("p".equalsIgnoreCase(nd.getNodeName()) || "div".equalsIgnoreCase(nd.getNodeName()) || "br".equalsIgnoreCase(nd.getNodeName())) {
                paragraph.add((Object)Chunk.NEWLINE);
            }
        } else if (nd.getNodeType() == 3 && (text = nd.getNodeValue()) != null) {
            this.getElement(text, stMap, paragraph);
        }
    }

    private void getElement(String value, HashMap stmap, Paragraph paragraph) {
        String stfontSize;
        Boolean isStrikeThObj;
        Boolean isUnderLinedObj;
        Boolean isItalicObj;
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderLined = false;
        boolean isStrikeTh = false;
        int fontSize = 0;
        String align = (String)stmap.get("ALIGN");
        Boolean isBoldObj = (Boolean)stmap.get("B");
        if (isBoldObj != null) {
            isBold = isBoldObj;
        }
        if ((isItalicObj = (Boolean)stmap.get("I")) != null) {
            isItalic = isItalicObj;
        }
        if ((isUnderLinedObj = (Boolean)stmap.get("U")) != null) {
            isUnderLined = isUnderLinedObj;
        }
        if ((isStrikeThObj = (Boolean)stmap.get("STRIKE")) != null) {
            isStrikeTh = isStrikeThObj;
        }
        if ((stfontSize = (String)stmap.get("SIZE")) != null) {
            fontSize = Integer.parseInt(stfontSize) * 4;
        }
        String fontFace = (String)stmap.get("FACE");
        String bgColor = (String)stmap.get("BGCOLOR");
        String fontColor = (String)stmap.get("COLOR");
        String family = "Helvetica";
        Chunk chunk = null;
        Color bgClr = null;
        if (bgColor != null) {
            try {
                bgClr = this.getColor(bgColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Font f = new Font();
        Color clr = null;
        if (fontColor != null) {
            try {
                clr = this.getColor(fontColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("Verdana".equalsIgnoreCase(fontFace)) {
            family = "Helvetica";
        }
        if ("Times New Roman".equalsIgnoreCase(fontFace)) {
            family = "Times New Roman";
        }
        if ("Courier New".equalsIgnoreCase(fontFace)) {
            family = "Courier";
        }
        if (isBold) {
            f.setStyle("bold");
        }
        if (isItalic) {
            f.setStyle("italic");
        }
        if (isUnderLined) {
            f.setStyle("underline");
        }
        if (isStrikeTh) {
            f.setStyle("strike");
        }
        if (fontSize != 0) {
            f.setSize((float)fontSize);
        }
        f.setFamily(family);
        if (clr != null) {
            f.setColor(clr);
        }
        chunk = new Chunk(value);
        if (bgColor != null) {
            chunk.setBackground(bgClr);
        }
        chunk.setFont(f);
        if (align != null) {
            paragraph.add((Object)chunk);
            paragraph.setAlignment(align);
        } else {
            paragraph.add((Object)chunk);
        }
    }

    private Chunk getImgChunk(HashMap map) {
        String url = null;
        String width = null;
        String height = null;
        float wt = 100.0f;
        float ht = 15.0f;
        Chunk chunk = null;
        try {
            url = (String)map.get("URL");
            width = (String)map.get("WIDTH");
            height = (String)map.get("HEIGHT");
            String alt = (String)map.get("ALT");
            if (width != null) {
                wt = Float.parseFloat(width);
            }
            if (height != null) {
                ht = Float.parseFloat(height);
            }
            if (url != null) {
                URL src = new URL(url);
                Image image = Image.getInstance((URL)src);
                image.scaleAbsoluteWidth(wt);
                image.scaleAbsoluteHeight(ht);
                if (alt != null) {
                    image.setAlt("alt");
                }
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chunk;
    }

    @Override
    public void setCSSFile(String cssFile) throws Exception {
    }

    @Override
    public void setSuppressGrid(boolean isSuppressGrid) throws Exception {
        this.isSuppressGrid = isSuppressGrid;
    }
}

