package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.webitm.utility.DataServiceUtility;
import ibase.webitm.utility.DoumentHandlerUtility;

@Path("/DocumentHandlerService")
public class DocumentHandlerService extends RestAPIService{

	@GET
	@Path("/getAttachConfigData")
	@Produces(MediaType.APPLICATION_JSON)
	//pass the parameter 
	public Response getAttachConfigData( 
			@QueryParam("OBJ_NAME") String objName,
			@QueryParam("REF_SER") String refser,
			@QueryParam("REF_ID") String refId,
			@QueryParam("CHECK_OBJ_NAME") String checkObjName, @Context HttpServletRequest request,@HeaderParam("TOKEN_ID") String tokenIDfromHeader)  throws BaseException, Exception 
	{
		BaseLogger.log( "3", null, null, "getAttachConfigData Service Called");

		DoumentHandlerUtility doumentHandlerUtility= new DoumentHandlerUtility();
		
	    byte[]	response = doumentHandlerUtility.getAttachConfigData(objName, refser, refId, checkObjName,request,tokenIDfromHeader);
		BaseLogger.log( "3", null, null, "response value  :"+ response );

		return Response.status(200).entity( response ).build();

	}
	
	
	@GET
	@Path("/getFileConfigurationData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getFileConfigurationData( 
			@QueryParam("OBJ_NAME") String objName,
			 @Context HttpServletRequest request,@HeaderParam("TOKEN_ID") String tokenIDfromHeader)  throws BaseException, Exception 
	{
		BaseLogger.log( "3", null, null, "getAttachConfigData Service Called");

		DoumentHandlerUtility doumentHandlerUtility= new DoumentHandlerUtility();
		
	    String	response = doumentHandlerUtility.getFileConfigurationData(objName, request,tokenIDfromHeader);
		BaseLogger.log( "3", null, null, "response value  :"+ response );

		return Response.status(200).entity( response ).build();

	}

	@POST
	@Path("/getUploadDocument")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getUploadDocument(
	        @FormParam("CAPTURE_IMAGE") boolean captureImage,
	        @FormParam("IMG_EXIST") boolean imgExist,
	        @FormParam("FILE_NAME") String fileName,
	        @FormParam("REF_SER") String refSer,
	        @FormParam("REF_ID") String refId,
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("DOCUMENT_TYPE") String documentType,
	        @FormParam("FILE_TYPE") String fileType,
	        @FormParam("DOC_LINK_OPT") String docLinkOpt,
	        @FormParam("FILE_METADATA") String fileMetadata,
	        @FormParam("DOC_META_DATA") String docMetaData,
	        @FormParam("REF_DESCR") String refDescr,
	        @FormParam("EXP_DATE") String expDate,
	        @FormParam("CACHE_OPT") int cacheOpt,
	        @Context HttpServletRequest request,
	        @HeaderParam("TOKEN_ID") String tokenIDfromHeader) {

	    BaseLogger.log( "3", null, null, "getUploadDocument Service Called");

	    DoumentHandlerUtility doumentHandlerUtility= new DoumentHandlerUtility();
	    
	    String response = doumentHandlerUtility.getUploadDocument(captureImage, imgExist, fileName, refSer, refId, objName, documentType, fileType, docLinkOpt, fileMetadata, docMetaData, refDescr, expDate, cacheOpt, request, tokenIDfromHeader);
	    BaseLogger.log( "3", null, null, "response value  :"+ response );

	    return Response.status(200).entity( response ).build();
	}


}
